# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['deutschland',
 'deutschland.vag',
 'deutschland.vag.api',
 'deutschland.vag.apis',
 'deutschland.vag.model',
 'deutschland.vag.models']

package_data = \
{'': ['*']}

install_requires = \
['python-dateutil', 'urllib3>=1.25.3']

setup_kwargs = {
    'name': 'de-vag',
    'version': '0.1.0',
    'description': 'VAG API',
    'long_description': '# vag\nWeb-API für Echtzeitinformationen der VAG Nürnberg\n\nThis Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:\n\n- API version: v1\n- Package version: 0.1.0\n- Build package: org.openapitools.codegen.languages.PythonClientCodegen\n\n## Requirements.\n\nPython >= 3.6\n\n## Installation & Usage\n### pip install\n\n```sh\npip install deutschland[vag]\n```\n\n### poetry install\n\n```sh\npoetry add deutschland -E vag\n```\n\n### Setuptools\n\nInstall via [Setuptools](http://pypi.python.org/pypi/setuptools).\n\n```sh\npython setup.py install --user\n```\n(or `sudo python setup.py install` to install the package for all users)\n\n## Usage\n\nImport the package:\n```python\nfrom deutschland import vag\n```\n\n## Getting Started\n\nPlease follow the [installation procedure](#installation--usage) and then run the following:\n\n```python\n\nimport time\nfrom deutschland import vag\nfrom pprint import pprint\nfrom deutschland.vag.api import abfahrten_api\nfrom deutschland.vag.model.abfahrten_api_response import AbfahrtenAPIResponse\n# Defining the host is optional and defaults to https://start.vag.de/dm\n# See configuration.py for a list of all supported configuration parameters.\nconfiguration = vag.Configuration(\n    host = "https://start.vag.de/dm"\n)\n\n\n\n# Enter a context with an instance of the API client\nwith vag.ApiClient(configuration) as api_client:\n    # Create an instance of the API class\n    api_instance = abfahrten_api.AbfahrtenApi(api_client)\n    netvu = "netvu_example" # str | Netz des Verkehrsunternehmen, aktuell \\"VAG\\" oder \\"VGN\\"\n    haltid = "haltid_example" # str | Haltestellenkennung je nach NetVU - VGN-Kennung oder die HaltID der VAG\n    product = "product_example" # str | Betriebszweig der VAG Bus, Tram, UBahn, SBahn, RBahn. Querystring: product=Bus,Tram (optional)\n    timespan = 1 # int | Zeitfenster für die Abfrage in Minuten (?timespan=10) (optional)\n    timedelay = 1 # int | Zeitliche Verschiebung für die Anfrage in Minuten (?timedelay=5) (optional)\n    limitcount = 1 # int | Maximale Anzahl der zurückgelieferten Abfahrten (optional)\n\n    try:\n        # Liefert die Abfahrten zu einer bestimmten Haltestelle\n        api_response = api_instance.abfahrten_get1(netvu, haltid, product=product, timespan=timespan, timedelay=timedelay, limitcount=limitcount)\n        pprint(api_response)\n    except vag.ApiException as e:\n        print("Exception when calling AbfahrtenApi->abfahrten_get1: %s\\n" % e)\n```\n\n## Documentation for API Endpoints\n\nAll URIs are relative to *https://start.vag.de/dm*\n\nClass | Method | HTTP request | Description\n------------ | ------------- | ------------- | -------------\n*AbfahrtenApi* | [**abfahrten_get1**](docs/AbfahrtenApi.md#abfahrten_get1) | **GET** /api/v1/abfahrten/{netvu}/{haltid} | Liefert die Abfahrten zu einer bestimmten Haltestelle\n*AbfahrtenApi* | [**abfahrten_get2**](docs/AbfahrtenApi.md#abfahrten_get2) | **GET** /api/v1/abfahrten/{netvu}/{haltid}/{line} | Liefert die Abfahrten zu einer bestimmten Haltestelle\n*FahrtenApi* | [**fahrten_get**](docs/FahrtenApi.md#fahrten_get) | **GET** /api/v1/fahrten/{betriebszweig} | Liefert alle laufenden und startenden Fahrten zu dem angegebenen Betriebszweig innerhalb des angegebenen Zeitfenster.\n*FahrtenApi* | [**fahrten_get_fahrt1**](docs/FahrtenApi.md#fahrten_get_fahrt1) | **GET** /api/v1/fahrten/{betriebszweig}/{fahrtnummer} | Liefert die Fahrt des angegebenen Betriebszweig mit der Fahrtnummer und dem aktuellen Betriebstag\n*FahrtenApi* | [**fahrten_get_fahrt2**](docs/FahrtenApi.md#fahrten_get_fahrt2) | **GET** /api/v1/fahrten/{betriebszweig}/{betriebstag}/{fahrtnummer} | Liefert die Fahrt des angegebenen Betriebszweig mit der Fahrtnummer und dem angegebenen Betriebstag\n*HaltestellenApi* | [**haltestellen_get_by_location**](docs/HaltestellenApi.md#haltestellen_get_by_location) | **GET** /api/v1/haltestellen/{netvu}/location | Liefert die Liste mit den Haltestellen zu der Umkreissuche\n*HaltestellenApi* | [**haltestellen_get_by_name**](docs/HaltestellenApi.md#haltestellen_get_by_name) | **GET** /api/v1/haltestellen/{netvu} | Liefert die Liste mit den Haltestellen zu dem angegebenen Haltestellenname (Optional)\n\n\n## Documentation For Models\n\n - [AbfahrtDto](docs/AbfahrtDto.md)\n - [AbfahrtenAPIResponse](docs/AbfahrtenAPIResponse.md)\n - [FahrtDto](docs/FahrtDto.md)\n - [FahrtenAPIResponse](docs/FahrtenAPIResponse.md)\n - [FahrwegHaltepositionDto](docs/FahrwegHaltepositionDto.md)\n - [HaltestelleDto](docs/HaltestelleDto.md)\n - [HaltestellenAPIResponse](docs/HaltestellenAPIResponse.md)\n - [Metadata](docs/Metadata.md)\n\n\n## Documentation For Authorization\n\n All endpoints do not require authorization.\n\n## Author\n\nkontakt@bund.dev\n\n\n## Notes for Large OpenAPI documents\nIf the OpenAPI document is large, imports in vag.apis and vag.models may fail with a\nRecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:\n\nSolution 1:\nUse specific imports for apis and models like:\n- `from deutschland.vag.api.default_api import DefaultApi`\n- `from deutschland.vag.model.pet import Pet`\n\nSolution 2:\nBefore importing the package, adjust the maximum recursion limit as shown below:\n```\nimport sys\nsys.setrecursionlimit(1500)\nfrom deutschland import vag\nfrom deutschland.vag.apis import *\nfrom deutschland.vag.models import *\n```\n\n',
    'author': 'BundesAPI',
    'author_email': 'kontakt@bund.dev',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/bundesAPI/vag-api',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6',
}


setup(**setup_kwargs)
