import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AclAuthMethodConfig extends cdktf.TerraformMetaArguments {
    /**
    * The raw configuration for this ACL auth method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_auth_method#config AclAuthMethod#config}
    */
    readonly config?: {
        [key: string]: string;
    };
    /**
    * The raw configuration for this ACL auth method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_auth_method#config_json AclAuthMethod#config_json}
    */
    readonly configJson?: string;
    /**
    * A free form human readable description of the auth method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_auth_method#description AclAuthMethod#description}
    */
    readonly description?: string;
    /**
    * An optional name to use instead of the name attribute when displaying information about this auth method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_auth_method#display_name AclAuthMethod#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_auth_method#id AclAuthMethod#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The maximum life of any token created by this auth method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_auth_method#max_token_ttl AclAuthMethod#max_token_ttl}
    */
    readonly maxTokenTtl?: string;
    /**
    * The name of the ACL auth method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_auth_method#name AclAuthMethod#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_auth_method#namespace AclAuthMethod#namespace}
    */
    readonly namespace?: string;
    /**
    * The partition the ACL auth method is associated with.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_auth_method#partition AclAuthMethod#partition}
    */
    readonly partition?: string;
    /**
    * The kind of token that this auth method produces. This can be either 'local' or 'global'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_auth_method#token_locality AclAuthMethod#token_locality}
    */
    readonly tokenLocality?: string;
    /**
    * The type of the ACL auth method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_auth_method#type AclAuthMethod#type}
    */
    readonly type: string;
    /**
    * namespace_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_auth_method#namespace_rule AclAuthMethod#namespace_rule}
    */
    readonly namespaceRule?: AclAuthMethodNamespaceRule[] | cdktf.IResolvable;
}
export interface AclAuthMethodNamespaceRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_auth_method#bind_namespace AclAuthMethod#bind_namespace}
    */
    readonly bindNamespace: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_auth_method#selector AclAuthMethod#selector}
    */
    readonly selector?: string;
}
export declare function aclAuthMethodNamespaceRuleToTerraform(struct?: AclAuthMethodNamespaceRule | cdktf.IResolvable): any;
export declare class AclAuthMethodNamespaceRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AclAuthMethodNamespaceRule | cdktf.IResolvable | undefined;
    set internalValue(value: AclAuthMethodNamespaceRule | cdktf.IResolvable | undefined);
    private _bindNamespace?;
    get bindNamespace(): string;
    set bindNamespace(value: string);
    get bindNamespaceInput(): string | undefined;
    private _selector?;
    get selector(): string;
    set selector(value: string);
    resetSelector(): void;
    get selectorInput(): string | undefined;
}
export declare class AclAuthMethodNamespaceRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AclAuthMethodNamespaceRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AclAuthMethodNamespaceRuleOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/r/acl_auth_method consul_acl_auth_method}
*/
export declare class AclAuthMethod extends cdktf.TerraformResource {
    static readonly tfResourceType = "consul_acl_auth_method";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/r/acl_auth_method consul_acl_auth_method} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AclAuthMethodConfig
    */
    constructor(scope: Construct, id: string, config: AclAuthMethodConfig);
    private _config?;
    get config(): {
        [key: string]: string;
    };
    set config(value: {
        [key: string]: string;
    });
    resetConfig(): void;
    get configInput(): {
        [key: string]: string;
    } | undefined;
    private _configJson?;
    get configJson(): string;
    set configJson(value: string);
    resetConfigJson(): void;
    get configJsonInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maxTokenTtl?;
    get maxTokenTtl(): string;
    set maxTokenTtl(value: string);
    resetMaxTokenTtl(): void;
    get maxTokenTtlInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _partition?;
    get partition(): string;
    set partition(value: string);
    resetPartition(): void;
    get partitionInput(): string | undefined;
    private _tokenLocality?;
    get tokenLocality(): string;
    set tokenLocality(value: string);
    resetTokenLocality(): void;
    get tokenLocalityInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _namespaceRule;
    get namespaceRule(): AclAuthMethodNamespaceRuleList;
    putNamespaceRule(value: AclAuthMethodNamespaceRule[] | cdktf.IResolvable): void;
    resetNamespaceRule(): void;
    get namespaceRuleInput(): cdktf.IResolvable | AclAuthMethodNamespaceRule[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
