import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AclPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ACL policy datacenters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_policy#datacenters AclPolicy#datacenters}
    */
    readonly datacenters?: string[];
    /**
    * The ACL policy description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_policy#description AclPolicy#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_policy#id AclPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ACL policy name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_policy#name AclPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_policy#namespace AclPolicy#namespace}
    */
    readonly namespace?: string;
    /**
    * The partition the ACL policy is associated with.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_policy#partition AclPolicy#partition}
    */
    readonly partition?: string;
    /**
    * The ACL policy rules.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_policy#rules AclPolicy#rules}
    */
    readonly rules: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/r/acl_policy consul_acl_policy}
*/
export declare class AclPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "consul_acl_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/r/acl_policy consul_acl_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AclPolicyConfig
    */
    constructor(scope: Construct, id: string, config: AclPolicyConfig);
    private _datacenters?;
    get datacenters(): string[];
    set datacenters(value: string[]);
    resetDatacenters(): void;
    get datacentersInput(): string[] | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _partition?;
    get partition(): string;
    set partition(value: string);
    resetPartition(): void;
    get partitionInput(): string | undefined;
    private _rules?;
    get rules(): string;
    set rules(value: string);
    get rulesInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
