import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AclRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * A free form human readable description of the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_role#description AclRole#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_role#id AclRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the ACL role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_role#name AclRole#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_role#namespace AclRole#namespace}
    */
    readonly namespace?: string;
    /**
    * The partition the ACL role is associated with.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_role#partition AclRole#partition}
    */
    readonly partition?: string;
    /**
    * The list of policies that should be applied to the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_role#policies AclRole#policies}
    */
    readonly policies?: string[];
    /**
    * node_identities block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_role#node_identities AclRole#node_identities}
    */
    readonly nodeIdentities?: AclRoleNodeIdentities[] | cdktf.IResolvable;
    /**
    * service_identities block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_role#service_identities AclRole#service_identities}
    */
    readonly serviceIdentities?: AclRoleServiceIdentities[] | cdktf.IResolvable;
}
export interface AclRoleNodeIdentities {
    /**
    * Specifies the node's datacenter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_role#datacenter AclRole#datacenter}
    */
    readonly datacenter: string;
    /**
    * The name of the node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_role#node_name AclRole#node_name}
    */
    readonly nodeName: string;
}
export declare function aclRoleNodeIdentitiesToTerraform(struct?: AclRoleNodeIdentities | cdktf.IResolvable): any;
export declare class AclRoleNodeIdentitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AclRoleNodeIdentities | cdktf.IResolvable | undefined;
    set internalValue(value: AclRoleNodeIdentities | cdktf.IResolvable | undefined);
    private _datacenter?;
    get datacenter(): string;
    set datacenter(value: string);
    get datacenterInput(): string | undefined;
    private _nodeName?;
    get nodeName(): string;
    set nodeName(value: string);
    get nodeNameInput(): string | undefined;
}
export declare class AclRoleNodeIdentitiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AclRoleNodeIdentities[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AclRoleNodeIdentitiesOutputReference;
}
export interface AclRoleServiceIdentities {
    /**
    * The datacenters the effective policy is valid within. When no datacenters are provided the effective policy is valid in all datacenters including those which do not yet exist but may in the future.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_role#datacenters AclRole#datacenters}
    */
    readonly datacenters?: string[];
    /**
    * The name of the service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_role#service_name AclRole#service_name}
    */
    readonly serviceName: string;
}
export declare function aclRoleServiceIdentitiesToTerraform(struct?: AclRoleServiceIdentities | cdktf.IResolvable): any;
export declare class AclRoleServiceIdentitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AclRoleServiceIdentities | cdktf.IResolvable | undefined;
    set internalValue(value: AclRoleServiceIdentities | cdktf.IResolvable | undefined);
    private _datacenters?;
    get datacenters(): string[];
    set datacenters(value: string[]);
    resetDatacenters(): void;
    get datacentersInput(): string[] | undefined;
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    get serviceNameInput(): string | undefined;
}
export declare class AclRoleServiceIdentitiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AclRoleServiceIdentities[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AclRoleServiceIdentitiesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/r/acl_role consul_acl_role}
*/
export declare class AclRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "consul_acl_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/r/acl_role consul_acl_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AclRoleConfig
    */
    constructor(scope: Construct, id: string, config: AclRoleConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _partition?;
    get partition(): string;
    set partition(value: string);
    resetPartition(): void;
    get partitionInput(): string | undefined;
    private _policies?;
    get policies(): string[];
    set policies(value: string[]);
    resetPolicies(): void;
    get policiesInput(): string[] | undefined;
    private _nodeIdentities;
    get nodeIdentities(): AclRoleNodeIdentitiesList;
    putNodeIdentities(value: AclRoleNodeIdentities[] | cdktf.IResolvable): void;
    resetNodeIdentities(): void;
    get nodeIdentitiesInput(): cdktf.IResolvable | AclRoleNodeIdentities[] | undefined;
    private _serviceIdentities;
    get serviceIdentities(): AclRoleServiceIdentitiesList;
    putServiceIdentities(value: AclRoleServiceIdentities[] | cdktf.IResolvable): void;
    resetServiceIdentities(): void;
    get serviceIdentitiesInput(): cdktf.IResolvable | AclRoleServiceIdentities[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
