import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AclTokenRoleAttachmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_token_role_attachment#id AclTokenRoleAttachment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The role name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_token_role_attachment#role AclTokenRoleAttachment#role}
    */
    readonly role: string;
    /**
    * The token accessor id.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/acl_token_role_attachment#token_id AclTokenRoleAttachment#token_id}
    */
    readonly tokenId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/r/acl_token_role_attachment consul_acl_token_role_attachment}
*/
export declare class AclTokenRoleAttachment extends cdktf.TerraformResource {
    static readonly tfResourceType = "consul_acl_token_role_attachment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/r/acl_token_role_attachment consul_acl_token_role_attachment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AclTokenRoleAttachmentConfig
    */
    constructor(scope: Construct, id: string, config: AclTokenRoleAttachmentConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _tokenId?;
    get tokenId(): string;
    set tokenId(value: string);
    get tokenIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
