import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AdminPartitionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Free form partition description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/admin_partition#description AdminPartition#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/admin_partition#id AdminPartition#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The partition name. This must be a valid DNS hostname label.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/admin_partition#name AdminPartition#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/r/admin_partition consul_admin_partition}
*/
export declare class AdminPartition extends cdktf.TerraformResource {
    static readonly tfResourceType = "consul_admin_partition";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/r/admin_partition consul_admin_partition} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AdminPartitionConfig
    */
    constructor(scope: Construct, id: string, config: AdminPartitionConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
