import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataConsulAclAuthMethodConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/acl_auth_method#id DataConsulAclAuthMethod#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/acl_auth_method#name DataConsulAclAuthMethod#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/acl_auth_method#namespace DataConsulAclAuthMethod#namespace}
    */
    readonly namespace?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/acl_auth_method#partition DataConsulAclAuthMethod#partition}
    */
    readonly partition?: string;
}
export interface DataConsulAclAuthMethodNamespaceRule {
}
export declare function dataConsulAclAuthMethodNamespaceRuleToTerraform(struct?: DataConsulAclAuthMethodNamespaceRule): any;
export declare class DataConsulAclAuthMethodNamespaceRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataConsulAclAuthMethodNamespaceRule | undefined;
    set internalValue(value: DataConsulAclAuthMethodNamespaceRule | undefined);
    get bindNamespace(): string;
    get selector(): string;
}
export declare class DataConsulAclAuthMethodNamespaceRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataConsulAclAuthMethodNamespaceRuleOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/d/acl_auth_method consul_acl_auth_method}
*/
export declare class DataConsulAclAuthMethod extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "consul_acl_auth_method";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/d/acl_auth_method consul_acl_auth_method} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataConsulAclAuthMethodConfig
    */
    constructor(scope: Construct, id: string, config: DataConsulAclAuthMethodConfig);
    private _config;
    get config(): cdktf.StringMap;
    get configJson(): string;
    get description(): string;
    get displayName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get maxTokenTtl(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _namespaceRule;
    get namespaceRule(): DataConsulAclAuthMethodNamespaceRuleList;
    private _partition?;
    get partition(): string;
    set partition(value: string);
    resetPartition(): void;
    get partitionInput(): string | undefined;
    get tokenLocality(): string;
    get type(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
