import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataConsulAclPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/acl_policy#id DataConsulAclPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/acl_policy#name DataConsulAclPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/acl_policy#namespace DataConsulAclPolicy#namespace}
    */
    readonly namespace?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/acl_policy#partition DataConsulAclPolicy#partition}
    */
    readonly partition?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/d/acl_policy consul_acl_policy}
*/
export declare class DataConsulAclPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "consul_acl_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/d/acl_policy consul_acl_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataConsulAclPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataConsulAclPolicyConfig);
    get datacenters(): string[];
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _partition?;
    get partition(): string;
    set partition(value: string);
    resetPartition(): void;
    get partitionInput(): string | undefined;
    get rules(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
