import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataConsulAutopilotHealthConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/autopilot_health#datacenter DataConsulAutopilotHealth#datacenter}
    */
    readonly datacenter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/autopilot_health#id DataConsulAutopilotHealth#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
export interface DataConsulAutopilotHealthServers {
}
export declare function dataConsulAutopilotHealthServersToTerraform(struct?: DataConsulAutopilotHealthServers): any;
export declare class DataConsulAutopilotHealthServersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataConsulAutopilotHealthServers | undefined;
    set internalValue(value: DataConsulAutopilotHealthServers | undefined);
    get address(): string;
    get healthy(): cdktf.IResolvable;
    get id(): string;
    get lastContact(): string;
    get lastIndex(): number;
    get lastTerm(): number;
    get leader(): cdktf.IResolvable;
    get name(): string;
    get serfStatus(): string;
    get stableSince(): string;
    get version(): string;
    get voter(): cdktf.IResolvable;
}
export declare class DataConsulAutopilotHealthServersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataConsulAutopilotHealthServersOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/d/autopilot_health consul_autopilot_health}
*/
export declare class DataConsulAutopilotHealth extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "consul_autopilot_health";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/d/autopilot_health consul_autopilot_health} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataConsulAutopilotHealthConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataConsulAutopilotHealthConfig);
    private _datacenter?;
    get datacenter(): string;
    set datacenter(value: string);
    resetDatacenter(): void;
    get datacenterInput(): string | undefined;
    get failureTolerance(): number;
    get healthy(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _servers;
    get servers(): DataConsulAutopilotHealthServersList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
