import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataConsulKeyPrefixConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/key_prefix#datacenter DataConsulKeyPrefix#datacenter}
    */
    readonly datacenter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/key_prefix#id DataConsulKeyPrefix#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/key_prefix#namespace DataConsulKeyPrefix#namespace}
    */
    readonly namespace?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/key_prefix#partition DataConsulKeyPrefix#partition}
    */
    readonly partition?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/key_prefix#path_prefix DataConsulKeyPrefix#path_prefix}
    */
    readonly pathPrefix: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/key_prefix#token DataConsulKeyPrefix#token}
    */
    readonly token?: string;
    /**
    * subkey block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/key_prefix#subkey DataConsulKeyPrefix#subkey}
    */
    readonly subkey?: DataConsulKeyPrefixSubkey[] | cdktf.IResolvable;
}
export interface DataConsulKeyPrefixSubkey {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/key_prefix#default DataConsulKeyPrefix#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/key_prefix#name DataConsulKeyPrefix#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/key_prefix#path DataConsulKeyPrefix#path}
    */
    readonly path: string;
}
export declare function dataConsulKeyPrefixSubkeyToTerraform(struct?: DataConsulKeyPrefixSubkey | cdktf.IResolvable): any;
export declare class DataConsulKeyPrefixSubkeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataConsulKeyPrefixSubkey | cdktf.IResolvable | undefined;
    set internalValue(value: DataConsulKeyPrefixSubkey | cdktf.IResolvable | undefined);
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
}
export declare class DataConsulKeyPrefixSubkeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataConsulKeyPrefixSubkey[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataConsulKeyPrefixSubkeyOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/d/key_prefix consul_key_prefix}
*/
export declare class DataConsulKeyPrefix extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "consul_key_prefix";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/d/key_prefix consul_key_prefix} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataConsulKeyPrefixConfig
    */
    constructor(scope: Construct, id: string, config: DataConsulKeyPrefixConfig);
    private _datacenter?;
    get datacenter(): string;
    set datacenter(value: string);
    resetDatacenter(): void;
    get datacenterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _partition?;
    get partition(): string;
    set partition(value: string);
    resetPartition(): void;
    get partitionInput(): string | undefined;
    private _pathPrefix?;
    get pathPrefix(): string;
    set pathPrefix(value: string);
    get pathPrefixInput(): string | undefined;
    private _subkeys;
    get subkeys(): cdktf.StringMap;
    private _token?;
    get token(): string;
    set token(value: string);
    resetToken(): void;
    get tokenInput(): string | undefined;
    private _var;
    get var(): cdktf.StringMap;
    private _subkey;
    get subkey(): DataConsulKeyPrefixSubkeyList;
    putSubkey(value: DataConsulKeyPrefixSubkey[] | cdktf.IResolvable): void;
    resetSubkey(): void;
    get subkeyInput(): cdktf.IResolvable | DataConsulKeyPrefixSubkey[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
