import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataConsulNetworkAreaMembersConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/network_area_members#datacenter DataConsulNetworkAreaMembers#datacenter}
    */
    readonly datacenter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/network_area_members#id DataConsulNetworkAreaMembers#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/network_area_members#token DataConsulNetworkAreaMembers#token}
    */
    readonly token?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/network_area_members#uuid DataConsulNetworkAreaMembers#uuid}
    */
    readonly uuid: string;
}
export interface DataConsulNetworkAreaMembersMembers {
}
export declare function dataConsulNetworkAreaMembersMembersToTerraform(struct?: DataConsulNetworkAreaMembersMembers): any;
export declare class DataConsulNetworkAreaMembersMembersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataConsulNetworkAreaMembersMembers | undefined;
    set internalValue(value: DataConsulNetworkAreaMembersMembers | undefined);
    get address(): string;
    get buildAttribute(): string;
    get datacenter(): string;
    get id(): string;
    get name(): string;
    get port(): number;
    get protocol(): number;
    get role(): string;
    get rtt(): number;
    get status(): string;
}
export declare class DataConsulNetworkAreaMembersMembersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataConsulNetworkAreaMembersMembersOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/d/network_area_members consul_network_area_members}
*/
export declare class DataConsulNetworkAreaMembers extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "consul_network_area_members";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/d/network_area_members consul_network_area_members} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataConsulNetworkAreaMembersConfig
    */
    constructor(scope: Construct, id: string, config: DataConsulNetworkAreaMembersConfig);
    private _datacenter?;
    get datacenter(): string;
    set datacenter(value: string);
    resetDatacenter(): void;
    get datacenterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _members;
    get members(): DataConsulNetworkAreaMembersMembersList;
    private _token?;
    get token(): string;
    set token(value: string);
    resetToken(): void;
    get tokenInput(): string | undefined;
    private _uuid?;
    get uuid(): string;
    set uuid(value: string);
    get uuidInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
