import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataConsulPeeringConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/peering#id DataConsulPeering#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/peering#partition DataConsulPeering#partition}
    */
    readonly partition?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/d/peering#peer_name DataConsulPeering#peer_name}
    */
    readonly peerName: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/d/peering consul_peering}
*/
export declare class DataConsulPeering extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "consul_peering";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/d/peering consul_peering} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataConsulPeeringConfig
    */
    constructor(scope: Construct, id: string, config: DataConsulPeeringConfig);
    get deletedAt(): string;
    get exportedServiceCount(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get importedServiceCount(): number;
    private _meta;
    get meta(): cdktf.StringMap;
    private _partition?;
    get partition(): string;
    set partition(value: string);
    resetPartition(): void;
    get partitionInput(): string | undefined;
    get peerCaPems(): string[];
    get peerId(): string;
    private _peerName?;
    get peerName(): string;
    set peerName(value: string);
    get peerNameInput(): string | undefined;
    get peerServerAddresses(): string[];
    get peerServerName(): string;
    get state(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
