import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LicenseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/license#datacenter License#datacenter}
    */
    readonly datacenter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/license#id License#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/license#license License#license}
    */
    readonly license: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/r/license consul_license}
*/
export declare class License extends cdktf.TerraformResource {
    static readonly tfResourceType = "consul_license";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/r/license consul_license} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LicenseConfig
    */
    constructor(scope: Construct, id: string, config: LicenseConfig);
    get customerId(): string;
    private _datacenter?;
    get datacenter(): string;
    set datacenter(value: string);
    resetDatacenter(): void;
    get datacenterInput(): string | undefined;
    get expirationTime(): string;
    get features(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get installationId(): string;
    get issueTime(): string;
    private _license?;
    get license(): string;
    set license(value: string);
    get licenseInput(): string | undefined;
    get licenseId(): string;
    get product(): string;
    get startTime(): string;
    get valid(): cdktf.IResolvable;
    get warnings(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
