import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NamespaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/namespace#description Namespace#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/namespace#id Namespace#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/namespace#meta Namespace#meta}
    */
    readonly meta?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/namespace#name Namespace#name}
    */
    readonly name: string;
    /**
    * The partition the namespace is associated with.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/namespace#partition Namespace#partition}
    */
    readonly partition?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/namespace#policy_defaults Namespace#policy_defaults}
    */
    readonly policyDefaults?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/namespace#role_defaults Namespace#role_defaults}
    */
    readonly roleDefaults?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/r/namespace consul_namespace}
*/
export declare class Namespace extends cdktf.TerraformResource {
    static readonly tfResourceType = "consul_namespace";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/r/namespace consul_namespace} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NamespaceConfig
    */
    constructor(scope: Construct, id: string, config: NamespaceConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _meta?;
    get meta(): {
        [key: string]: string;
    };
    set meta(value: {
        [key: string]: string;
    });
    resetMeta(): void;
    get metaInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _partition?;
    get partition(): string;
    set partition(value: string);
    resetPartition(): void;
    get partitionInput(): string | undefined;
    private _policyDefaults?;
    get policyDefaults(): string[];
    set policyDefaults(value: string[]);
    resetPolicyDefaults(): void;
    get policyDefaultsInput(): string[] | undefined;
    private _roleDefaults?;
    get roleDefaults(): string[];
    set roleDefaults(value: string[]);
    resetRoleDefaults(): void;
    get roleDefaultsInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
