import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkAreaConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/network_area#datacenter NetworkArea#datacenter}
    */
    readonly datacenter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/network_area#id NetworkArea#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/network_area#peer_datacenter NetworkArea#peer_datacenter}
    */
    readonly peerDatacenter: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/network_area#retry_join NetworkArea#retry_join}
    */
    readonly retryJoin?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/network_area#token NetworkArea#token}
    */
    readonly token?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/network_area#use_tls NetworkArea#use_tls}
    */
    readonly useTls?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/r/network_area consul_network_area}
*/
export declare class NetworkArea extends cdktf.TerraformResource {
    static readonly tfResourceType = "consul_network_area";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/r/network_area consul_network_area} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkAreaConfig
    */
    constructor(scope: Construct, id: string, config: NetworkAreaConfig);
    private _datacenter?;
    get datacenter(): string;
    set datacenter(value: string);
    resetDatacenter(): void;
    get datacenterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _peerDatacenter?;
    get peerDatacenter(): string;
    set peerDatacenter(value: string);
    get peerDatacenterInput(): string | undefined;
    private _retryJoin?;
    get retryJoin(): string[];
    set retryJoin(value: string[]);
    resetRetryJoin(): void;
    get retryJoinInput(): string[] | undefined;
    private _token?;
    get token(): string;
    set token(value: string);
    resetToken(): void;
    get tokenInput(): string | undefined;
    private _useTls?;
    get useTls(): boolean | cdktf.IResolvable;
    set useTls(value: boolean | cdktf.IResolvable);
    resetUseTls(): void;
    get useTlsInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
