import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PreparedQueryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/prepared_query#connect PreparedQuery#connect}
    */
    readonly connect?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/prepared_query#datacenter PreparedQuery#datacenter}
    */
    readonly datacenter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/prepared_query#id PreparedQuery#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/prepared_query#ignore_check_ids PreparedQuery#ignore_check_ids}
    */
    readonly ignoreCheckIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/prepared_query#name PreparedQuery#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/prepared_query#near PreparedQuery#near}
    */
    readonly near?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/prepared_query#node_meta PreparedQuery#node_meta}
    */
    readonly nodeMeta?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/prepared_query#only_passing PreparedQuery#only_passing}
    */
    readonly onlyPassing?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/prepared_query#service PreparedQuery#service}
    */
    readonly service: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/prepared_query#service_meta PreparedQuery#service_meta}
    */
    readonly serviceMeta?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/prepared_query#session PreparedQuery#session}
    */
    readonly session?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/prepared_query#stored_token PreparedQuery#stored_token}
    */
    readonly storedToken?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/prepared_query#tags PreparedQuery#tags}
    */
    readonly tags?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/prepared_query#token PreparedQuery#token}
    */
    readonly token?: string;
    /**
    * dns block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/prepared_query#dns PreparedQuery#dns}
    */
    readonly dns?: PreparedQueryDns;
    /**
    * failover block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/prepared_query#failover PreparedQuery#failover}
    */
    readonly failover?: PreparedQueryFailover;
    /**
    * template block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/prepared_query#template PreparedQuery#template}
    */
    readonly template?: PreparedQueryTemplate;
}
export interface PreparedQueryDns {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/prepared_query#ttl PreparedQuery#ttl}
    */
    readonly ttl?: string;
}
export declare function preparedQueryDnsToTerraform(struct?: PreparedQueryDnsOutputReference | PreparedQueryDns): any;
export declare class PreparedQueryDnsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PreparedQueryDns | undefined;
    set internalValue(value: PreparedQueryDns | undefined);
    private _ttl?;
    get ttl(): string;
    set ttl(value: string);
    resetTtl(): void;
    get ttlInput(): string | undefined;
}
export interface PreparedQueryFailover {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/prepared_query#datacenters PreparedQuery#datacenters}
    */
    readonly datacenters?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/prepared_query#nearest_n PreparedQuery#nearest_n}
    */
    readonly nearestN?: number;
}
export declare function preparedQueryFailoverToTerraform(struct?: PreparedQueryFailoverOutputReference | PreparedQueryFailover): any;
export declare class PreparedQueryFailoverOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PreparedQueryFailover | undefined;
    set internalValue(value: PreparedQueryFailover | undefined);
    private _datacenters?;
    get datacenters(): string[];
    set datacenters(value: string[]);
    resetDatacenters(): void;
    get datacentersInput(): string[] | undefined;
    private _nearestN?;
    get nearestN(): number;
    set nearestN(value: number);
    resetNearestN(): void;
    get nearestNInput(): number | undefined;
}
export interface PreparedQueryTemplate {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/prepared_query#regexp PreparedQuery#regexp}
    */
    readonly regexp: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/prepared_query#type PreparedQuery#type}
    */
    readonly type: string;
}
export declare function preparedQueryTemplateToTerraform(struct?: PreparedQueryTemplateOutputReference | PreparedQueryTemplate): any;
export declare class PreparedQueryTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PreparedQueryTemplate | undefined;
    set internalValue(value: PreparedQueryTemplate | undefined);
    private _regexp?;
    get regexp(): string;
    set regexp(value: string);
    get regexpInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/r/prepared_query consul_prepared_query}
*/
export declare class PreparedQuery extends cdktf.TerraformResource {
    static readonly tfResourceType = "consul_prepared_query";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/r/prepared_query consul_prepared_query} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PreparedQueryConfig
    */
    constructor(scope: Construct, id: string, config: PreparedQueryConfig);
    private _connect?;
    get connect(): boolean | cdktf.IResolvable;
    set connect(value: boolean | cdktf.IResolvable);
    resetConnect(): void;
    get connectInput(): boolean | cdktf.IResolvable | undefined;
    private _datacenter?;
    get datacenter(): string;
    set datacenter(value: string);
    resetDatacenter(): void;
    get datacenterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ignoreCheckIds?;
    get ignoreCheckIds(): string[];
    set ignoreCheckIds(value: string[]);
    resetIgnoreCheckIds(): void;
    get ignoreCheckIdsInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _near?;
    get near(): string;
    set near(value: string);
    resetNear(): void;
    get nearInput(): string | undefined;
    private _nodeMeta?;
    get nodeMeta(): {
        [key: string]: string;
    };
    set nodeMeta(value: {
        [key: string]: string;
    });
    resetNodeMeta(): void;
    get nodeMetaInput(): {
        [key: string]: string;
    } | undefined;
    private _onlyPassing?;
    get onlyPassing(): boolean | cdktf.IResolvable;
    set onlyPassing(value: boolean | cdktf.IResolvable);
    resetOnlyPassing(): void;
    get onlyPassingInput(): boolean | cdktf.IResolvable | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _serviceMeta?;
    get serviceMeta(): {
        [key: string]: string;
    };
    set serviceMeta(value: {
        [key: string]: string;
    });
    resetServiceMeta(): void;
    get serviceMetaInput(): {
        [key: string]: string;
    } | undefined;
    private _session?;
    get session(): string;
    set session(value: string);
    resetSession(): void;
    get sessionInput(): string | undefined;
    private _storedToken?;
    get storedToken(): string;
    set storedToken(value: string);
    resetStoredToken(): void;
    get storedTokenInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _token?;
    get token(): string;
    set token(value: string);
    resetToken(): void;
    get tokenInput(): string | undefined;
    private _dns;
    get dns(): PreparedQueryDnsOutputReference;
    putDns(value: PreparedQueryDns): void;
    resetDns(): void;
    get dnsInput(): PreparedQueryDns | undefined;
    private _failover;
    get failover(): PreparedQueryFailoverOutputReference;
    putFailover(value: PreparedQueryFailover): void;
    resetFailover(): void;
    get failoverInput(): PreparedQueryFailover | undefined;
    private _template;
    get template(): PreparedQueryTemplateOutputReference;
    putTemplate(value: PreparedQueryTemplate): void;
    resetTemplate(): void;
    get templateInput(): PreparedQueryTemplate | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
