import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/service#address Service#address}
    */
    readonly address?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/service#datacenter Service#datacenter}
    */
    readonly datacenter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/service#enable_tag_override Service#enable_tag_override}
    */
    readonly enableTagOverride?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/service#external Service#external}
    */
    readonly external?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/service#id Service#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/service#meta Service#meta}
    */
    readonly meta?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/service#name Service#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/service#namespace Service#namespace}
    */
    readonly namespace?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/service#node Service#node}
    */
    readonly nodeAttribute: string;
    /**
    * The partition the service is associated with.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/service#partition Service#partition}
    */
    readonly partition?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/service#port Service#port}
    */
    readonly port?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/service#service_id Service#service_id}
    */
    readonly serviceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/service#tags Service#tags}
    */
    readonly tags?: string[];
    /**
    * check block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/service#check Service#check}
    */
    readonly check?: ServiceCheck[] | cdktf.IResolvable;
}
export interface ServiceCheckHeader {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/service#name Service#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/service#value Service#value}
    */
    readonly value: string[];
}
export declare function serviceCheckHeaderToTerraform(struct?: ServiceCheckHeader | cdktf.IResolvable): any;
export declare class ServiceCheckHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceCheckHeader | cdktf.IResolvable | undefined;
    set internalValue(value: ServiceCheckHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string[];
    set value(value: string[]);
    get valueInput(): string[] | undefined;
}
export declare class ServiceCheckHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ServiceCheckHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceCheckHeaderOutputReference;
}
export interface ServiceCheck {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/service#check_id Service#check_id}
    */
    readonly checkId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/service#deregister_critical_service_after Service#deregister_critical_service_after}
    */
    readonly deregisterCriticalServiceAfter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/service#http Service#http}
    */
    readonly http?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/service#interval Service#interval}
    */
    readonly interval: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/service#method Service#method}
    */
    readonly method?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/service#name Service#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/service#notes Service#notes}
    */
    readonly notes?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/service#status Service#status}
    */
    readonly status?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/service#tcp Service#tcp}
    */
    readonly tcp?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/service#timeout Service#timeout}
    */
    readonly timeout: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/service#tls_skip_verify Service#tls_skip_verify}
    */
    readonly tlsSkipVerify?: boolean | cdktf.IResolvable;
    /**
    * header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/consul/r/service#header Service#header}
    */
    readonly header?: ServiceCheckHeader[] | cdktf.IResolvable;
}
export declare function serviceCheckToTerraform(struct?: ServiceCheck | cdktf.IResolvable): any;
export declare class ServiceCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceCheck | cdktf.IResolvable | undefined;
    set internalValue(value: ServiceCheck | cdktf.IResolvable | undefined);
    private _checkId?;
    get checkId(): string;
    set checkId(value: string);
    get checkIdInput(): string | undefined;
    private _deregisterCriticalServiceAfter?;
    get deregisterCriticalServiceAfter(): string;
    set deregisterCriticalServiceAfter(value: string);
    resetDeregisterCriticalServiceAfter(): void;
    get deregisterCriticalServiceAfterInput(): string | undefined;
    private _http?;
    get http(): string;
    set http(value: string);
    resetHttp(): void;
    get httpInput(): string | undefined;
    private _interval?;
    get interval(): string;
    set interval(value: string);
    get intervalInput(): string | undefined;
    private _method?;
    get method(): string;
    set method(value: string);
    resetMethod(): void;
    get methodInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _notes?;
    get notes(): string;
    set notes(value: string);
    resetNotes(): void;
    get notesInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _tcp?;
    get tcp(): string;
    set tcp(value: string);
    resetTcp(): void;
    get tcpInput(): string | undefined;
    private _timeout?;
    get timeout(): string;
    set timeout(value: string);
    get timeoutInput(): string | undefined;
    private _tlsSkipVerify?;
    get tlsSkipVerify(): boolean | cdktf.IResolvable;
    set tlsSkipVerify(value: boolean | cdktf.IResolvable);
    resetTlsSkipVerify(): void;
    get tlsSkipVerifyInput(): boolean | cdktf.IResolvable | undefined;
    private _header;
    get header(): ServiceCheckHeaderList;
    putHeader(value: ServiceCheckHeader[] | cdktf.IResolvable): void;
    resetHeader(): void;
    get headerInput(): cdktf.IResolvable | ServiceCheckHeader[] | undefined;
}
export declare class ServiceCheckList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ServiceCheck[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceCheckOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/consul/r/service consul_service}
*/
export declare class Service extends cdktf.TerraformResource {
    static readonly tfResourceType = "consul_service";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/consul/r/service consul_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServiceConfig
    */
    constructor(scope: Construct, id: string, config: ServiceConfig);
    private _address?;
    get address(): string;
    set address(value: string);
    resetAddress(): void;
    get addressInput(): string | undefined;
    private _datacenter?;
    get datacenter(): string;
    set datacenter(value: string);
    resetDatacenter(): void;
    get datacenterInput(): string | undefined;
    private _enableTagOverride?;
    get enableTagOverride(): boolean | cdktf.IResolvable;
    set enableTagOverride(value: boolean | cdktf.IResolvable);
    resetEnableTagOverride(): void;
    get enableTagOverrideInput(): boolean | cdktf.IResolvable | undefined;
    private _external?;
    get external(): boolean | cdktf.IResolvable;
    set external(value: boolean | cdktf.IResolvable);
    resetExternal(): void;
    get externalInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _meta?;
    get meta(): {
        [key: string]: string;
    };
    set meta(value: {
        [key: string]: string;
    });
    resetMeta(): void;
    get metaInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _node?;
    get nodeAttribute(): string;
    set nodeAttribute(value: string);
    get nodeAttributeInput(): string | undefined;
    private _partition?;
    get partition(): string;
    set partition(value: string);
    resetPartition(): void;
    get partitionInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _serviceId?;
    get serviceId(): string;
    set serviceId(value: string);
    resetServiceId(): void;
    get serviceIdInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _check;
    get check(): ServiceCheckList;
    putCheck(value: ServiceCheck[] | cdktf.IResolvable): void;
    resetCheck(): void;
    get checkInput(): cdktf.IResolvable | ServiceCheck[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
