"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const core_1 = require("@aws-cdk/core");
const mediastore = require("@aws-cdk/aws-mediastore");
const lib_1 = require("../lib");
// Setup
const app = new core_1.App();
const stack = new core_1.Stack(app, 'test-cloudfront-mediastore');
stack.templateOptions.description = 'Integration test for aws-cloudfront-mediastore with existing mediastore container';
const mediaStoreContainerObject = new mediastore.CfnContainer(stack, 'MyMediaStoreContainer', {
    containerName: 'MyMediaStoreContainer'
});
// Instantiate construct
new lib_1.CloudFrontToMediaStore(stack, 'test-cloudfront-mediastore', {
    existingMediaStoreContainerObj: mediaStoreContainerObject
});
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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