define("jscatter", ["@jupyter-widgets/base"], (__WEBPACK_EXTERNAL_MODULE__jupyter_widgets_base__) => /******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./embed.js":
/*!******************!*\
  !*** ./embed.js ***!
  \******************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Entry point for the unpkg bundle containing custom model definitions.
//
// It differs from the notebook bundle in that it does not need to define a
// dynamic baseURL for the static assets and may load some css that would
// already be loaded by the notebook otherwise.

// Export widget models and views, and the npm package version number.
module.exports = __webpack_require__(/*! ./src/index.js */ "./src/index.js");
module.exports.version = __webpack_require__(/*! ./package.json */ "./package.json").version;


/***/ }),

/***/ "./node_modules/pub-sub-es/src/index.js":
/*!**********************************************!*\
  !*** ./node_modules/pub-sub-es/src/index.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "globalPubSub": () => /* binding */ globalPubSub,
/* harmony export */   "createPubSub": () => /* binding */ createPubSub,
/* harmony export */   "default": () => __WEBPACK_DEFAULT_EXPORT__
/* harmony export */ });
/**
 * A new or fake broadcast channel.
 * @type {BroadcastChannel|object}
 */
const bc = (() => {
  try {
    return new window.BroadcastChannel('pub-sub-es');
  } catch (e) {
    return { postMessage: () => {} };
  }
})();

/**
 * Get final event name
 * @param {string} eventName - Event name to be adjusted
 * @param {boolean} caseInsensitive - If `true`, `eventName` will be lowercased
 */
const getEventName = (eventName, caseInsensitive) =>
  caseInsensitive ? eventName.toLowerCase() : eventName;

/**
 * Setup subscriber.
 * @param {object} stack - The bound event stack.
 * @return {function} - Curried function for subscribing to an event on a
 *   specific event stack.
 */
const subscribe = (stack, { caseInsensitive } = {}) =>
  /**
   * Subscribe to an event.
   * @param {string} event - Event name to subscribe to.
   * @param {function} handler - Function to be called when event of type
   *   `event` is published.
   * @param {number} times - Number of times the handler should called for the
   *   given event. The event listener will automatically be unsubscribed once
   *   the number of calls exceeds `times`.
   * @return {object} Object with the event name and the handler. The object
   *   can be used to unsubscribe.
   */
  (event, handler, times = Infinity) => {
    const e = getEventName(event, caseInsensitive);

    if (!stack[e]) {
      stack[e] = [];
      stack.__times__[e] = [];
    }

    stack[e].push(handler);
    stack.__times__[e].push(+times || Infinity);

    return { event: e, handler };
  };

/**
 * Setup unsubscriber.
 * @param {object} stack - The bound event stack.
 * @return {function} - Curried function for unsubscribing an event from a
 *   specific event stack.
 */
const unsubscribe = (stack, { caseInsensitive } = {}) =>
  /**
   * Unsubscribe from event.
   * @curried
   * @param {string|object} event - Event from which to unsubscribe or the return
   *   object provided by `subscribe()`.
   * @param {function} handler - Handler function to be unsubscribed. It is
   *   ignored if `id` is provided.
   */
  (event, handler) => {
    if (typeof event === 'object') {
      handler = event.handler; // eslint-disable-line no-param-reassign
      event = event.event; // eslint-disable-line no-param-reassign
    }

    const e = getEventName(event, caseInsensitive);

    if (!stack[e]) return;

    const id = stack[e].indexOf(handler);

    if (id === -1 || id >= stack[e].length) return;

    stack[e].splice(id, 1);
    stack.__times__[e].splice(id, 1);
  };

/**
 * Inform listeners about some news
 * @param {array} listeners - List of listeners
 * @param {*} news - News object
 */
const inform = (listeners, news) => () => {
  listeners.forEach((listener) => listener(news));
};

/**
 * Setup the publisher.
 * @param  {object} stack - The bound event stack.
 * @param  {boolean} isGlobal - If `true` event will be published globally.
 * @return {function} - Curried function for publishing an event on a specific
 *   event stack.
 */
const publish = (stack, { isGlobal, caseInsensitive, async } = {}) => {
  const unsubscriber = unsubscribe(stack);

  /**
   * Public interface for publishing an event.
   * @curried
   * @param {string} event - Event type to be published.
   * @param {any} news - The news to be published.
   * @param {object} options - Option object with
   *   - {boolean} isNoGlobalBroadcast - If `true` event will *not* be
   *     broadcasted gloablly even if `isGlobal` is `true`.
   *   - {boolean} async - If `true` event will *not* be broadcasted
   *     synchronously even if `async` is `false` globally.
   */
  return (event, news, options = {}) => {
    const e = getEventName(event, caseInsensitive);

    if (!stack[e]) return;

    const listeners = [...stack[e]];

    listeners.forEach((listener, i) => {
      if (--stack.__times__[e][i] < 1) unsubscriber(e, listener);
    });

    if (async || options.async) {
      setTimeout(inform(listeners, news), 0);
    } else {
      inform(listeners, news)();
    }

    if (isGlobal && !options.isNoGlobalBroadcast) {
      try {
        bc.postMessage({ event: e, news });
      } catch (error) {
        if (error instanceof DOMException) {
          console.warn(
            `Could not broadcast '${e}' globally. Payload is not clonable.`
          );
        } else {
          throw error;
        }
      }
    }
  };
};

/**
 * Setup event clearer
 * @param {object} stack - The bound event stack.
 * @return {function} - A curried function removing all event listeners on a
 *   specific event stack.
 */
const clear = (stack) =>
  /**
   * Remove all event listeners and unset listening times
   * @curried
   */
  () => {
    Object.keys(stack)
      .filter((eventName) => eventName[0] !== '_')
      .forEach((eventName) => {
        stack[eventName] = undefined;
        stack.__times__[eventName] = undefined;
        delete stack[eventName];
        delete stack.__times__[eventName];
      });
  };

/**
 * Create a new empty stack object
 * @return {object} - An empty stack object.
 */
const createEmptyStack = () => ({ __times__: {} });

/**
 * Create a new pub-sub instance
 * @param {object} stack - Object to be used as the event stack.
 * @return {object} - A new pub-sub instance.
 */
const createPubSub = ({
  async = false,
  caseInsensitive = false,
  stack = createEmptyStack(),
} = {}) => {
  if (!stack.__times__) stack.__times__ = {};

  return {
    publish: publish(stack, { async, caseInsensitive }),
    subscribe: subscribe(stack, { caseInsensitive }),
    unsubscribe: unsubscribe(stack, { caseInsensitive }),
    clear: clear(stack),
    stack,
  };
};

/**
 * Global pub-sub stack object
 * @type {object}
 */
const globalPubSubStack = createEmptyStack();
/**
 * Global pub-sub stack instance
 * @type {object}
 */
const globalPubSub = {
  publish: publish(globalPubSubStack, { isGlobal: true }),
  subscribe: subscribe(globalPubSubStack),
  unsubscribe: unsubscribe(globalPubSubStack),
  stack: globalPubSubStack,
};
bc.onmessage = ({ data: { event, news } }) =>
  globalPubSub.publish(event, news, true);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createPubSub);


/***/ }),

/***/ "./node_modules/regl-scatterplot/dist/regl-scatterplot.js":
/*!****************************************************************!*\
  !*** ./node_modules/regl-scatterplot/dist/regl-scatterplot.js ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

(function (global, factory) {
   true ? factory(exports, __webpack_require__(/*! pub-sub-es */ "./node_modules/pub-sub-es/src/index.js"), __webpack_require__(/*! regl */ "./node_modules/regl/dist/regl.js")) :
  0;
}(this, (function (exports, createPubSub, createOriginalRegl) { 'use strict';

  function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

  var createPubSub__default = /*#__PURE__*/_interopDefaultLegacy(createPubSub);
  var createOriginalRegl__default = /*#__PURE__*/_interopDefaultLegacy(createOriginalRegl);

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);

    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);

      if (enumerableOnly) {
        symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });
      }

      keys.push.apply(keys, symbols);
    }

    return keys;
  }

  function _objectSpread2(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};

      if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }

    return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) return _arrayLikeToArray(arr);
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _iterableToArray(iter) {
    if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
  }

  function _iterableToArrayLimit(arr, i) {
    var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"];

    if (_i == null) return;
    var _arr = [];
    var _n = true;
    var _d = false;

    var _s, _e;

    try {
      for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);

        if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;
      _e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }

    return _arr;
  }

  function _unsupportedIterableToArray(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
  }

  function _arrayLikeToArray(arr, len) {
    if (len == null || len > arr.length) len = arr.length;

    for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];

    return arr2;
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  /**
   * Common utilities
   * @module glMatrix
   */
  // Configuration Constants
  var EPSILON = 0.000001;
  var ARRAY_TYPE = typeof Float32Array !== 'undefined' ? Float32Array : Array;
  if (!Math.hypot) Math.hypot = function () {
    var y = 0,
        i = arguments.length;

    while (i--) {
      y += arguments[i] * arguments[i];
    }

    return Math.sqrt(y);
  };

  /**
   * 4x4 Matrix<br>Format: column-major, when typed out it looks like row-major<br>The matrices are being post multiplied.
   * @module mat4
   */

  /**
   * Creates a new identity mat4
   *
   * @returns {mat4} a new 4x4 matrix
   */

  function create$2() {
    var out = new ARRAY_TYPE(16);

    if (ARRAY_TYPE != Float32Array) {
      out[1] = 0;
      out[2] = 0;
      out[3] = 0;
      out[4] = 0;
      out[6] = 0;
      out[7] = 0;
      out[8] = 0;
      out[9] = 0;
      out[11] = 0;
      out[12] = 0;
      out[13] = 0;
      out[14] = 0;
    }

    out[0] = 1;
    out[5] = 1;
    out[10] = 1;
    out[15] = 1;
    return out;
  }
  /**
   * Creates a new mat4 initialized with values from an existing matrix
   *
   * @param {ReadonlyMat4} a matrix to clone
   * @returns {mat4} a new 4x4 matrix
   */

  function clone(a) {
    var out = new ARRAY_TYPE(16);
    out[0] = a[0];
    out[1] = a[1];
    out[2] = a[2];
    out[3] = a[3];
    out[4] = a[4];
    out[5] = a[5];
    out[6] = a[6];
    out[7] = a[7];
    out[8] = a[8];
    out[9] = a[9];
    out[10] = a[10];
    out[11] = a[11];
    out[12] = a[12];
    out[13] = a[13];
    out[14] = a[14];
    out[15] = a[15];
    return out;
  }
  /**
   * Inverts a mat4
   *
   * @param {mat4} out the receiving matrix
   * @param {ReadonlyMat4} a the source matrix
   * @returns {mat4} out
   */

  function invert(out, a) {
    var a00 = a[0],
        a01 = a[1],
        a02 = a[2],
        a03 = a[3];
    var a10 = a[4],
        a11 = a[5],
        a12 = a[6],
        a13 = a[7];
    var a20 = a[8],
        a21 = a[9],
        a22 = a[10],
        a23 = a[11];
    var a30 = a[12],
        a31 = a[13],
        a32 = a[14],
        a33 = a[15];
    var b00 = a00 * a11 - a01 * a10;
    var b01 = a00 * a12 - a02 * a10;
    var b02 = a00 * a13 - a03 * a10;
    var b03 = a01 * a12 - a02 * a11;
    var b04 = a01 * a13 - a03 * a11;
    var b05 = a02 * a13 - a03 * a12;
    var b06 = a20 * a31 - a21 * a30;
    var b07 = a20 * a32 - a22 * a30;
    var b08 = a20 * a33 - a23 * a30;
    var b09 = a21 * a32 - a22 * a31;
    var b10 = a21 * a33 - a23 * a31;
    var b11 = a22 * a33 - a23 * a32; // Calculate the determinant

    var det = b00 * b11 - b01 * b10 + b02 * b09 + b03 * b08 - b04 * b07 + b05 * b06;

    if (!det) {
      return null;
    }

    det = 1.0 / det;
    out[0] = (a11 * b11 - a12 * b10 + a13 * b09) * det;
    out[1] = (a02 * b10 - a01 * b11 - a03 * b09) * det;
    out[2] = (a31 * b05 - a32 * b04 + a33 * b03) * det;
    out[3] = (a22 * b04 - a21 * b05 - a23 * b03) * det;
    out[4] = (a12 * b08 - a10 * b11 - a13 * b07) * det;
    out[5] = (a00 * b11 - a02 * b08 + a03 * b07) * det;
    out[6] = (a32 * b02 - a30 * b05 - a33 * b01) * det;
    out[7] = (a20 * b05 - a22 * b02 + a23 * b01) * det;
    out[8] = (a10 * b10 - a11 * b08 + a13 * b06) * det;
    out[9] = (a01 * b08 - a00 * b10 - a03 * b06) * det;
    out[10] = (a30 * b04 - a31 * b02 + a33 * b00) * det;
    out[11] = (a21 * b02 - a20 * b04 - a23 * b00) * det;
    out[12] = (a11 * b07 - a10 * b09 - a12 * b06) * det;
    out[13] = (a00 * b09 - a01 * b07 + a02 * b06) * det;
    out[14] = (a31 * b01 - a30 * b03 - a32 * b00) * det;
    out[15] = (a20 * b03 - a21 * b01 + a22 * b00) * det;
    return out;
  }
  /**
   * Multiplies two mat4s
   *
   * @param {mat4} out the receiving matrix
   * @param {ReadonlyMat4} a the first operand
   * @param {ReadonlyMat4} b the second operand
   * @returns {mat4} out
   */

  function multiply(out, a, b) {
    var a00 = a[0],
        a01 = a[1],
        a02 = a[2],
        a03 = a[3];
    var a10 = a[4],
        a11 = a[5],
        a12 = a[6],
        a13 = a[7];
    var a20 = a[8],
        a21 = a[9],
        a22 = a[10],
        a23 = a[11];
    var a30 = a[12],
        a31 = a[13],
        a32 = a[14],
        a33 = a[15]; // Cache only the current line of the second matrix

    var b0 = b[0],
        b1 = b[1],
        b2 = b[2],
        b3 = b[3];
    out[0] = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
    out[1] = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
    out[2] = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
    out[3] = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
    b0 = b[4];
    b1 = b[5];
    b2 = b[6];
    b3 = b[7];
    out[4] = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
    out[5] = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
    out[6] = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
    out[7] = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
    b0 = b[8];
    b1 = b[9];
    b2 = b[10];
    b3 = b[11];
    out[8] = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
    out[9] = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
    out[10] = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
    out[11] = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
    b0 = b[12];
    b1 = b[13];
    b2 = b[14];
    b3 = b[15];
    out[12] = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
    out[13] = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
    out[14] = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
    out[15] = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
    return out;
  }
  /**
   * Creates a matrix from a vector translation
   * This is equivalent to (but much faster than):
   *
   *     mat4.identity(dest);
   *     mat4.translate(dest, dest, vec);
   *
   * @param {mat4} out mat4 receiving operation result
   * @param {ReadonlyVec3} v Translation vector
   * @returns {mat4} out
   */

  function fromTranslation(out, v) {
    out[0] = 1;
    out[1] = 0;
    out[2] = 0;
    out[3] = 0;
    out[4] = 0;
    out[5] = 1;
    out[6] = 0;
    out[7] = 0;
    out[8] = 0;
    out[9] = 0;
    out[10] = 1;
    out[11] = 0;
    out[12] = v[0];
    out[13] = v[1];
    out[14] = v[2];
    out[15] = 1;
    return out;
  }
  /**
   * Creates a matrix from a vector scaling
   * This is equivalent to (but much faster than):
   *
   *     mat4.identity(dest);
   *     mat4.scale(dest, dest, vec);
   *
   * @param {mat4} out mat4 receiving operation result
   * @param {ReadonlyVec3} v Scaling vector
   * @returns {mat4} out
   */

  function fromScaling(out, v) {
    out[0] = v[0];
    out[1] = 0;
    out[2] = 0;
    out[3] = 0;
    out[4] = 0;
    out[5] = v[1];
    out[6] = 0;
    out[7] = 0;
    out[8] = 0;
    out[9] = 0;
    out[10] = v[2];
    out[11] = 0;
    out[12] = 0;
    out[13] = 0;
    out[14] = 0;
    out[15] = 1;
    return out;
  }
  /**
   * Creates a matrix from a given angle around a given axis
   * This is equivalent to (but much faster than):
   *
   *     mat4.identity(dest);
   *     mat4.rotate(dest, dest, rad, axis);
   *
   * @param {mat4} out mat4 receiving operation result
   * @param {Number} rad the angle to rotate the matrix by
   * @param {ReadonlyVec3} axis the axis to rotate around
   * @returns {mat4} out
   */

  function fromRotation(out, rad, axis) {
    var x = axis[0],
        y = axis[1],
        z = axis[2];
    var len = Math.hypot(x, y, z);
    var s, c, t;

    if (len < EPSILON) {
      return null;
    }

    len = 1 / len;
    x *= len;
    y *= len;
    z *= len;
    s = Math.sin(rad);
    c = Math.cos(rad);
    t = 1 - c; // Perform rotation-specific matrix multiplication

    out[0] = x * x * t + c;
    out[1] = y * x * t + z * s;
    out[2] = z * x * t - y * s;
    out[3] = 0;
    out[4] = x * y * t - z * s;
    out[5] = y * y * t + c;
    out[6] = z * y * t + x * s;
    out[7] = 0;
    out[8] = x * z * t + y * s;
    out[9] = y * z * t - x * s;
    out[10] = z * z * t + c;
    out[11] = 0;
    out[12] = 0;
    out[13] = 0;
    out[14] = 0;
    out[15] = 1;
    return out;
  }
  /**
   * Returns the translation vector component of a transformation
   *  matrix. If a matrix is built with fromRotationTranslation,
   *  the returned vector will be the same as the translation vector
   *  originally supplied.
   * @param  {vec3} out Vector to receive translation component
   * @param  {ReadonlyMat4} mat Matrix to be decomposed (input)
   * @return {vec3} out
   */

  function getTranslation(out, mat) {
    out[0] = mat[12];
    out[1] = mat[13];
    out[2] = mat[14];
    return out;
  }
  /**
   * Returns the scaling factor component of a transformation
   *  matrix. If a matrix is built with fromRotationTranslationScale
   *  with a normalized Quaternion paramter, the returned vector will be
   *  the same as the scaling vector
   *  originally supplied.
   * @param  {vec3} out Vector to receive scaling factor component
   * @param  {ReadonlyMat4} mat Matrix to be decomposed (input)
   * @return {vec3} out
   */

  function getScaling(out, mat) {
    var m11 = mat[0];
    var m12 = mat[1];
    var m13 = mat[2];
    var m21 = mat[4];
    var m22 = mat[5];
    var m23 = mat[6];
    var m31 = mat[8];
    var m32 = mat[9];
    var m33 = mat[10];
    out[0] = Math.hypot(m11, m12, m13);
    out[1] = Math.hypot(m21, m22, m23);
    out[2] = Math.hypot(m31, m32, m33);
    return out;
  }

  /**
   * 4 Dimensional Vector
   * @module vec4
   */

  /**
   * Creates a new, empty vec4
   *
   * @returns {vec4} a new 4D vector
   */

  function create$1() {
    var out = new ARRAY_TYPE(4);

    if (ARRAY_TYPE != Float32Array) {
      out[0] = 0;
      out[1] = 0;
      out[2] = 0;
      out[3] = 0;
    }

    return out;
  }
  /**
   * Transforms the vec4 with a mat4.
   *
   * @param {vec4} out the receiving vector
   * @param {ReadonlyVec4} a the vector to transform
   * @param {ReadonlyMat4} m matrix to transform with
   * @returns {vec4} out
   */

  function transformMat4(out, a, m) {
    var x = a[0],
        y = a[1],
        z = a[2],
        w = a[3];
    out[0] = m[0] * x + m[4] * y + m[8] * z + m[12] * w;
    out[1] = m[1] * x + m[5] * y + m[9] * z + m[13] * w;
    out[2] = m[2] * x + m[6] * y + m[10] * z + m[14] * w;
    out[3] = m[3] * x + m[7] * y + m[11] * z + m[15] * w;
    return out;
  }
  /**
   * Perform some operation over an array of vec4s.
   *
   * @param {Array} a the array of vectors to iterate over
   * @param {Number} stride Number of elements between the start of each vec4. If 0 assumes tightly packed
   * @param {Number} offset Number of elements to skip at the beginning of the array
   * @param {Number} count Number of vec4s to iterate over. If 0 iterates over entire array
   * @param {Function} fn Function to call for each vector in the array
   * @param {Object} [arg] additional argument to pass to fn
   * @returns {Array} a
   * @function
   */

  (function () {
    var vec = create$1();
    return function (a, stride, offset, count, fn, arg) {
      var i, l;

      if (!stride) {
        stride = 4;
      }

      if (!offset) {
        offset = 0;
      }

      if (count) {
        l = Math.min(count * stride + offset, a.length);
      } else {
        l = a.length;
      }

      for (i = offset; i < l; i += stride) {
        vec[0] = a[i];
        vec[1] = a[i + 1];
        vec[2] = a[i + 2];
        vec[3] = a[i + 3];
        fn(vec, vec, arg);
        a[i] = vec[0];
        a[i + 1] = vec[1];
        a[i + 2] = vec[2];
        a[i + 3] = vec[3];
      }

      return a;
    };
  })();

  /**
   * 2 Dimensional Vector
   * @module vec2
   */

  /**
   * Creates a new, empty vec2
   *
   * @returns {vec2} a new 2D vector
   */

  function create() {
    var out = new ARRAY_TYPE(2);

    if (ARRAY_TYPE != Float32Array) {
      out[0] = 0;
      out[1] = 0;
    }

    return out;
  }
  /**
   * Get the angle between two 2D vectors
   * @param {ReadonlyVec2} a The first operand
   * @param {ReadonlyVec2} b The second operand
   * @returns {Number} The angle in radians
   */

  function angle(a, b) {
    var x1 = a[0],
        y1 = a[1],
        x2 = b[0],
        y2 = b[1],
        // mag is the product of the magnitudes of a and b
    mag = Math.sqrt(x1 * x1 + y1 * y1) * Math.sqrt(x2 * x2 + y2 * y2),
        // mag &&.. short circuits if mag == 0
    cosine = mag && (x1 * x2 + y1 * y2) / mag; // Math.min(Math.max(cosine, -1), 1) clamps the cosine between -1 and 1

    return Math.acos(Math.min(Math.max(cosine, -1), 1));
  }
  /**
   * Perform some operation over an array of vec2s.
   *
   * @param {Array} a the array of vectors to iterate over
   * @param {Number} stride Number of elements between the start of each vec2. If 0 assumes tightly packed
   * @param {Number} offset Number of elements to skip at the beginning of the array
   * @param {Number} count Number of vec2s to iterate over. If 0 iterates over entire array
   * @param {Function} fn Function to call for each vector in the array
   * @param {Object} [arg] additional argument to pass to fn
   * @returns {Array} a
   * @function
   */

  (function () {
    var vec = create();
    return function (a, stride, offset, count, fn, arg) {
      var i, l;

      if (!stride) {
        stride = 2;
      }

      if (!offset) {
        offset = 0;
      }

      if (count) {
        l = Math.min(count * stride + offset, a.length);
      } else {
        l = a.length;
      }

      for (i = offset; i < l; i += stride) {
        vec[0] = a[i];
        vec[1] = a[i + 1];
        fn(vec, vec, arg);
        a[i] = vec[0];
        a[i + 1] = vec[1];
      }

      return a;
    };
  })();

  const createCamera = (initTarget = [0, 0], initDistance = 1, initRotation = 0, initViewCenter = [0, 0], initScaleBounds = [[0, Infinity], [0, Infinity]], initTranslationBounds = [[-Infinity, Infinity], [-Infinity, Infinity]]) => {
    // Scratch variables
    const scratch0 = new Float32Array(16);
    const scratch1 = new Float32Array(16);
    const scratch2 = new Float32Array(16);
    let view = create$2();
    let viewCenter = [...initViewCenter.slice(0, 2), 0, 1];
    const scaleXBounds = Array.isArray(initScaleBounds[0]) ? [...initScaleBounds[0]] : [...initScaleBounds];
    const scaleYBounds = Array.isArray(initScaleBounds[0]) ? [...initScaleBounds[1]] : [...initScaleBounds];
    const translationXBounds = Array.isArray(initTranslationBounds[0]) ? [...initTranslationBounds[0]] : [...initTranslationBounds];
    const translationYBounds = Array.isArray(initTranslationBounds[0]) ? [...initTranslationBounds[1]] : [...initTranslationBounds];

    const getScaling$1 = () => getScaling(scratch0, view).slice(0, 2);

    const getMinScaling = () => {
      const scaling = getScaling$1();
      return Math.min(scaling[0], scaling[1]);
    };

    const getMaxScaling = () => {
      const scaling = getScaling$1();
      return Math.max(scaling[0], scaling[1]);
    };

    const getRotation = () => Math.acos(view[0] / getMaxScaling());

    const getScaleBounds = () => [[...scaleXBounds], [...scaleYBounds]];

    const getTranslationBounds = () => [[...translationXBounds], [...translationYBounds]];

    const getDistance = () => {
      const scaling = getScaling$1();
      return [1 / scaling[0], 1 / scaling[1]];
    };

    const getMinDistance = () => 1 / getMinScaling();

    const getMaxDistance = () => 1 / getMaxScaling();

    const getTranslation$1 = () => getTranslation(scratch0, view).slice(0, 2);

    const getTarget = () => transformMat4(scratch0, viewCenter, invert(scratch2, view)).slice(0, 2);

    const getView = () => view;

    const getViewCenter = () => viewCenter.slice(0, 2);

    const lookAt = ([x = 0, y = 0] = [], newDistance = 1, newRotation = 0) => {
      // Reset the view
      view = create$2();
      translate([-x, -y]);
      rotate(newRotation);
      scale(1 / newDistance);
    };

    const translate = ([x = 0, y = 0] = []) => {
      scratch0[0] = x;
      scratch0[1] = y;
      scratch0[2] = 0;
      const t = fromTranslation(scratch1, scratch0); // Translate about the viewport center
      // This is identical to `i * t * i * view` where `i` is the identity matrix

      multiply(view, t, view);
    };

    const scale = (d, mousePos) => {
      const isArray = Array.isArray(d);
      let dx = isArray ? d[0] : d;
      let dy = isArray ? d[1] : d;
      if (dx <= 0 || dy <= 0 || dx === 1 && dy === 1) return;
      const scaling = getScaling$1();
      const newXScale = scaling[0] * dx;
      const newYScale = scaling[1] * dy;
      dx = Math.max(scaleXBounds[0], Math.min(newXScale, scaleXBounds[1])) / scaling[0];
      dy = Math.max(scaleYBounds[0], Math.min(newYScale, scaleYBounds[1])) / scaling[1];
      if (dx === 1 && dy === 1) return; // There is nothing to do

      scratch0[0] = dx;
      scratch0[1] = dy;
      scratch0[2] = 1;
      const s = fromScaling(scratch1, scratch0);
      const scaleCenter = mousePos ? [...mousePos, 0] : viewCenter;
      const a = fromTranslation(scratch0, scaleCenter); // Translate about the scale center
      // I.e., the mouse position or the view center

      multiply(view, a, multiply(view, s, multiply(view, invert(scratch2, a), view)));
    };

    const rotate = rad => {
      const r = create$2();
      fromRotation(r, rad, [0, 0, 1]); // Rotate about the viewport center
      // This is identical to `i * r * i * view` where `i` is the identity matrix

      multiply(view, r, view);
    };

    const setScaleBounds = newBounds => {
      const isArray = Array.isArray(newBounds[0]);
      scaleXBounds[0] = isArray ? newBounds[0][0] : newBounds[0];
      scaleXBounds[1] = isArray ? newBounds[0][1] : newBounds[1];
      scaleYBounds[0] = isArray ? newBounds[1][0] : newBounds[0];
      scaleYBounds[1] = isArray ? newBounds[1][1] : newBounds[1];
    };

    const setTranslationBounds = newBounds => {
      const isArray = Array.isArray(newBounds[0]);
      translationXBounds[0] = isArray ? newBounds[0][0] : newBounds[0];
      translationXBounds[1] = isArray ? newBounds[0][1] : newBounds[1];
      translationYBounds[0] = isArray ? newBounds[1][0] : newBounds[0];
      translationYBounds[1] = isArray ? newBounds[1][1] : newBounds[1];
    };

    const setView = newView => {
      if (!newView || newView.length < 16) return;
      view = newView;
    };

    const setViewCenter = newViewCenter => {
      viewCenter = [...newViewCenter.slice(0, 2), 0, 1];
    };

    const reset = () => {
      lookAt(initTarget, initDistance, initRotation);
    }; // Init


    lookAt(initTarget, initDistance, initRotation);
    return {
      get translation() {
        return getTranslation$1();
      },

      get target() {
        return getTarget();
      },

      get scaling() {
        return getScaling$1();
      },

      get minScaling() {
        return getMinScaling();
      },

      get maxScaling() {
        return getMaxScaling();
      },

      get scaleBounds() {
        return getScaleBounds();
      },

      get translationBounds() {
        return getTranslationBounds();
      },

      get distance() {
        return getDistance();
      },

      get minDistance() {
        return getMinDistance();
      },

      get maxDistance() {
        return getMaxDistance();
      },

      get rotation() {
        return getRotation();
      },

      get view() {
        return getView();
      },

      get viewCenter() {
        return getViewCenter();
      },

      lookAt,
      translate,
      pan: translate,
      rotate,
      scale,
      zoom: scale,
      reset,
      set: (...args) => {
        console.warn('`set()` is deprecated. Please use `setView()` instead.');
        return setView(...args);
      },
      setScaleBounds,
      setTranslationBounds,
      setView,
      setViewCenter
    };
  };

  const MOUSE_DOWN_MOVE_ACTIONS = ["pan", "rotate"];
  const KEY_MAP = {
    alt: "altKey",
    cmd: "metaKey",
    ctrl: "ctrlKey",
    meta: "metaKey",
    shift: "shiftKey"
  };

  const dom2dCamera = (element, {
    distance = 1.0,
    target = [0, 0],
    rotation = 0,
    isNdc = true,
    isFixed = false,
    isPan = true,
    isPanInverted = [false, true],
    panSpeed = 1,
    isRotate = true,
    rotateSpeed = 1,
    defaultMouseDownMoveAction = "pan",
    mouseDownMoveModKey = "alt",
    isZoom = true,
    zoomSpeed = 1,
    viewCenter,
    scaleBounds,
    translationBounds,
    onKeyDown = () => {},
    onKeyUp = () => {},
    onMouseDown = () => {},
    onMouseUp = () => {},
    onMouseMove = () => {},
    onWheel = () => {}
  } = {}) => {
    let camera = createCamera(target, distance, rotation, viewCenter, scaleBounds, translationBounds);
    let mouseX = 0;
    let mouseY = 0;
    let mouseRelX = 0;
    let mouseRelY = 0;
    let prevMouseX = 0;
    let prevMouseY = 0;
    let isLeftMousePressed = false;
    let yScroll = 0;
    let width = 1;
    let height = 1;
    let aspectRatio = 1;
    let isInteractivelyChanged = false;
    let isProgrammaticallyChanged = false;
    let isMouseDownMoveModActive = false;
    let panOnMouseDownMove = defaultMouseDownMoveAction === "pan";
    let isPanX = isPan;
    let isPanY = isPan;
    let isPanXInverted = isPanInverted;
    let isPanYInverted = isPanInverted;
    let isZoomX = isZoom;
    let isZoomY = isZoom;

    const spreadXYSettings = () => {
      isPanX = Array.isArray(isPan) ? Boolean(isPan[0]) : isPan;
      isPanY = Array.isArray(isPan) ? Boolean(isPan[1]) : isPan;
      isPanXInverted = Array.isArray(isPanInverted) ? Boolean(isPanInverted[0]) : isPanInverted;
      isPanYInverted = Array.isArray(isPanInverted) ? Boolean(isPanInverted[1]) : isPanInverted;
      isZoomX = Array.isArray(isZoom) ? Boolean(isZoom[0]) : isZoom;
      isZoomY = Array.isArray(isZoom) ? Boolean(isZoom[1]) : isZoom;
    };

    spreadXYSettings();
    const transformPanX = isNdc ? dX => dX / width * 2 * aspectRatio // to normalized device coords
    : dX => dX;
    const transformPanY = isNdc ? dY => dY / height * 2 // to normalized device coords
    : dY => -dY;
    const transformScaleX = isNdc ? x => (-1 + x / width * 2) * aspectRatio // to normalized device coords
    : x => x;
    const transformScaleY = isNdc ? y => 1 - y / height * 2 // to normalized device coords
    : y => y;

    const tick = () => {
      if (isFixed) return false;
      isInteractivelyChanged = false;
      const currentMouseX = mouseX;
      const currentMouseY = mouseY;

      if ((isPanX || isPanY) && isLeftMousePressed && (panOnMouseDownMove && !isMouseDownMoveModActive || !panOnMouseDownMove && isMouseDownMoveModActive)) {
        const dX = isPanXInverted ? prevMouseX - currentMouseX : currentMouseX - prevMouseX;
        const transformedPanX = isPanX ? transformPanX(panSpeed * dX) : 0;
        const dY = isPanYInverted ? prevMouseY - currentMouseY : currentMouseY - prevMouseY;
        const transformedPanY = isPanY ? transformPanY(panSpeed * dY) : 0;

        if (transformedPanX !== 0 || transformedPanY !== 0) {
          camera.pan([transformedPanX, transformedPanY]);
          isInteractivelyChanged = true;
        }
      }

      if (isZoom && yScroll) {
        const dZ = zoomSpeed * Math.exp(yScroll / height);
        const transformedX = transformScaleX(mouseRelX);
        const transformedY = transformScaleY(mouseRelY);
        camera.scale([isZoomX ? 1 / dZ : 1, isZoomY ? 1 / dZ : 1], [transformedX, transformedY]);
        isInteractivelyChanged = true;
      }

      if (isRotate && isLeftMousePressed && (panOnMouseDownMove && isMouseDownMoveModActive || !panOnMouseDownMove && !isMouseDownMoveModActive) && Math.abs(prevMouseX - currentMouseX) + Math.abs(prevMouseY - currentMouseY) > 0) {
        const wh = width / 2;
        const hh = height / 2;
        const x1 = prevMouseX - wh;
        const y1 = hh - prevMouseY;
        const x2 = currentMouseX - wh;
        const y2 = hh - currentMouseY; // Angle between the start and end mouse position with respect to the
        // viewport center

        const radians = angle([x1, y1], [x2, y2]); // Determine the orientation

        const cross = x1 * y2 - x2 * y1;
        camera.rotate(rotateSpeed * radians * Math.sign(cross));
        isInteractivelyChanged = true;
      } // Reset scroll delta and mouse position


      yScroll = 0;
      prevMouseX = currentMouseX;
      prevMouseY = currentMouseY;
      const isChanged = isInteractivelyChanged || isProgrammaticallyChanged;
      isProgrammaticallyChanged = false;
      return isChanged;
    };

    const config = ({
      defaultMouseDownMoveAction: newDefaultMouseDownMoveAction = null,
      isFixed: newIsFixed = null,
      isPan: newIsPan = null,
      isPanInverted: newIsPanInverted = null,
      isRotate: newIsRotate = null,
      isZoom: newIsZoom = null,
      panSpeed: newPanSpeed = null,
      rotateSpeed: newRotateSpeed = null,
      zoomSpeed: newZoomSpeed = null,
      mouseDownMoveModKey: newMouseDownMoveModKey = null
    } = {}) => {
      defaultMouseDownMoveAction = newDefaultMouseDownMoveAction !== null && MOUSE_DOWN_MOVE_ACTIONS.includes(newDefaultMouseDownMoveAction) ? newDefaultMouseDownMoveAction : defaultMouseDownMoveAction;
      panOnMouseDownMove = defaultMouseDownMoveAction === "pan";
      isFixed = newIsFixed !== null ? newIsFixed : isFixed;
      isPan = newIsPan !== null ? newIsPan : isPan;
      isPanInverted = newIsPanInverted !== null ? newIsPanInverted : isPanInverted;
      isRotate = newIsRotate !== null ? newIsRotate : isRotate;
      isZoom = newIsZoom !== null ? newIsZoom : isZoom;
      panSpeed = +newPanSpeed > 0 ? newPanSpeed : panSpeed;
      rotateSpeed = +newRotateSpeed > 0 ? newRotateSpeed : rotateSpeed;
      zoomSpeed = +newZoomSpeed > 0 ? newZoomSpeed : zoomSpeed;
      spreadXYSettings();
      mouseDownMoveModKey = newMouseDownMoveModKey !== null && Object.keys(KEY_MAP).includes(newMouseDownMoveModKey) ? newMouseDownMoveModKey : mouseDownMoveModKey;
    };

    const refresh = () => {
      const bBox = element.getBoundingClientRect();
      width = bBox.width;
      height = bBox.height;
      aspectRatio = width / height;
    };

    const keyUpHandler = event => {
      isMouseDownMoveModActive = false;
      onKeyUp(event);
    };

    const keyDownHandler = event => {
      isMouseDownMoveModActive = event[KEY_MAP[mouseDownMoveModKey]];
      onKeyDown(event);
    };

    const mouseUpHandler = event => {
      isLeftMousePressed = false;
      onMouseUp(event);
    };

    const mouseDownHandler = event => {
      isLeftMousePressed = event.buttons === 1;
      onMouseDown(event);
    };

    const offsetXSupport = document.createEvent("MouseEvent").offsetX !== undefined;
    const updateMouseRelXY = offsetXSupport ? event => {
      mouseRelX = event.offsetX;
      mouseRelY = event.offsetY;
    } : event => {
      const bBox = element.getBoundingClientRect();
      mouseRelX = event.clientX - bBox.left;
      mouseRelY = event.clientY - bBox.top;
    };

    const updateMouseXY = event => {
      mouseX = event.clientX;
      mouseY = event.clientY;
    };

    const mouseMoveHandler = event => {
      updateMouseXY(event);
      onMouseMove(event);
    };

    const wheelHandler = event => {
      event.preventDefault();
      updateMouseXY(event);
      updateMouseRelXY(event);
      const scale = event.deltaMode === 1 ? 12 : 1;
      yScroll += scale * (event.deltaY || 0);
      onWheel(event);
    };

    const dispose = () => {
      camera = undefined;
      window.removeEventListener("keydown", keyDownHandler);
      window.removeEventListener("keyup", keyUpHandler);
      element.removeEventListener("mousedown", mouseDownHandler);
      window.removeEventListener("mouseup", mouseUpHandler);
      window.removeEventListener("mousemove", mouseMoveHandler);
      element.removeEventListener("wheel", wheelHandler);
    };

    window.addEventListener("keydown", keyDownHandler, {
      passive: true
    });
    window.addEventListener("keyup", keyUpHandler, {
      passive: true
    });
    element.addEventListener("mousedown", mouseDownHandler, {
      passive: true
    });
    window.addEventListener("mouseup", mouseUpHandler, {
      passive: true
    });
    window.addEventListener("mousemove", mouseMoveHandler, {
      passive: true
    });
    element.addEventListener("wheel", wheelHandler, {
      passive: false
    });
    camera.config = config;
    camera.dispose = dispose;
    camera.refresh = refresh;
    camera.tick = tick;

    const withProgrammaticChange = fn => function () {
      fn.apply(null, arguments);
      isProgrammaticallyChanged = true;
    };

    camera.lookAt = withProgrammaticChange(camera.lookAt);
    camera.translate = withProgrammaticChange(camera.translate);
    camera.pan = withProgrammaticChange(camera.pan);
    camera.rotate = withProgrammaticChange(camera.rotate);
    camera.scale = withProgrammaticChange(camera.scale);
    camera.zoom = withProgrammaticChange(camera.zoom);
    camera.reset = withProgrammaticChange(camera.reset);
    camera.set = withProgrammaticChange(camera.set);
    camera.setScaleBounds = withProgrammaticChange(camera.setScaleBounds);
    camera.setTranslationBounds = withProgrammaticChange(camera.setTranslationBounds);
    camera.setView = withProgrammaticChange(camera.setView);
    camera.setViewCenter = withProgrammaticChange(camera.setViewCenter);
    refresh();
    return camera;
  };

  function sortKD(ids, coords, nodeSize, left, right, depth) {
    if (right - left <= nodeSize) return;
    const m = left + right >> 1;
    select(ids, coords, m, left, right, depth % 2);
    sortKD(ids, coords, nodeSize, left, m - 1, depth + 1);
    sortKD(ids, coords, nodeSize, m + 1, right, depth + 1);
  }

  function select(ids, coords, k, left, right, inc) {
    while (right > left) {
      if (right - left > 600) {
        const n = right - left + 1;
        const m = k - left + 1;
        const z = Math.log(n);
        const s = 0.5 * Math.exp(2 * z / 3);
        const sd = 0.5 * Math.sqrt(z * s * (n - s) / n) * (m - n / 2 < 0 ? -1 : 1);
        const newLeft = Math.max(left, Math.floor(k - m * s / n + sd));
        const newRight = Math.min(right, Math.floor(k + (n - m) * s / n + sd));
        select(ids, coords, k, newLeft, newRight, inc);
      }

      const t = coords[2 * k + inc];
      let i = left;
      let j = right;
      swapItem(ids, coords, left, k);
      if (coords[2 * right + inc] > t) swapItem(ids, coords, left, right);

      while (i < j) {
        swapItem(ids, coords, i, j);
        i++;
        j--;

        while (coords[2 * i + inc] < t) i++;

        while (coords[2 * j + inc] > t) j--;
      }

      if (coords[2 * left + inc] === t) swapItem(ids, coords, left, j);else {
        j++;
        swapItem(ids, coords, j, right);
      }
      if (j <= k) left = j + 1;
      if (k <= j) right = j - 1;
    }
  }

  function swapItem(ids, coords, i, j) {
    swap(ids, i, j);
    swap(coords, 2 * i, 2 * j);
    swap(coords, 2 * i + 1, 2 * j + 1);
  }

  function swap(arr, i, j) {
    const tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp;
  }

  function range(ids, coords, minX, minY, maxX, maxY, nodeSize) {
    const stack = [0, ids.length - 1, 0];
    const result = [];
    let x, y;

    while (stack.length) {
      const axis = stack.pop();
      const right = stack.pop();
      const left = stack.pop();

      if (right - left <= nodeSize) {
        for (let i = left; i <= right; i++) {
          x = coords[2 * i];
          y = coords[2 * i + 1];
          if (x >= minX && x <= maxX && y >= minY && y <= maxY) result.push(ids[i]);
        }

        continue;
      }

      const m = Math.floor((left + right) / 2);
      x = coords[2 * m];
      y = coords[2 * m + 1];
      if (x >= minX && x <= maxX && y >= minY && y <= maxY) result.push(ids[m]);
      const nextAxis = (axis + 1) % 2;

      if (axis === 0 ? minX <= x : minY <= y) {
        stack.push(left);
        stack.push(m - 1);
        stack.push(nextAxis);
      }

      if (axis === 0 ? maxX >= x : maxY >= y) {
        stack.push(m + 1);
        stack.push(right);
        stack.push(nextAxis);
      }
    }

    return result;
  }

  function within(ids, coords, qx, qy, r, nodeSize) {
    const stack = [0, ids.length - 1, 0];
    const result = [];
    const r2 = r * r;

    while (stack.length) {
      const axis = stack.pop();
      const right = stack.pop();
      const left = stack.pop();

      if (right - left <= nodeSize) {
        for (let i = left; i <= right; i++) {
          if (sqDist(coords[2 * i], coords[2 * i + 1], qx, qy) <= r2) result.push(ids[i]);
        }

        continue;
      }

      const m = Math.floor((left + right) / 2);
      const x = coords[2 * m];
      const y = coords[2 * m + 1];
      if (sqDist(x, y, qx, qy) <= r2) result.push(ids[m]);
      const nextAxis = (axis + 1) % 2;

      if (axis === 0 ? qx - r <= x : qy - r <= y) {
        stack.push(left);
        stack.push(m - 1);
        stack.push(nextAxis);
      }

      if (axis === 0 ? qx + r >= x : qy + r >= y) {
        stack.push(m + 1);
        stack.push(right);
        stack.push(nextAxis);
      }
    }

    return result;
  }

  function sqDist(ax, ay, bx, by) {
    const dx = ax - bx;
    const dy = ay - by;
    return dx * dx + dy * dy;
  }

  const defaultGetX = p => p[0];

  const defaultGetY = p => p[1];

  class KDBush {
    constructor(points, getX = defaultGetX, getY = defaultGetY, nodeSize = 64, ArrayType = Float64Array) {
      this.nodeSize = nodeSize;
      this.points = points;
      const IndexArrayType = points.length < 65536 ? Uint16Array : Uint32Array;
      const ids = this.ids = new IndexArrayType(points.length);
      const coords = this.coords = new ArrayType(points.length * 2);

      for (let i = 0; i < points.length; i++) {
        ids[i] = i;
        coords[2 * i] = getX(points[i]);
        coords[2 * i + 1] = getY(points[i]);
      }

      sortKD(ids, coords, nodeSize, 0, ids.length - 1, 0);
    }

    range(minX, minY, maxX, maxY) {
      return range(this.ids, this.coords, minX, minY, maxX, maxY, this.nodeSize);
    }

    within(x, y, r) {
      return within(this.ids, this.coords, x, y, r, this.nodeSize);
    }

  }

  const FRAGMENT_SHADER$3 = `
precision mediump float;
varying vec4 color;
void main() {
  gl_FragColor = color;
}`;

  // Vertex shader from https://mattdesl.svbtle.com/drawing-lines-is-hard
  // The MIT License (MIT) Copyright (c) 2015 Matt DesLauriers
  const VERTEX_SHADER$1 = `
uniform mat4 projectionViewModel;
uniform float aspectRatio;

uniform sampler2D colorTex;
uniform float colorTexRes;
uniform float colorTexEps;
uniform float width;
uniform float useOpacity;
uniform float useColorOpacity;
uniform int miter;

attribute vec3 prevPosition;
attribute vec3 currPosition;
attribute vec3 nextPosition;
attribute float opacity;
attribute float offsetScale;
attribute float colorIndex;

varying vec4 color;

void main() {
  vec2 aspectVec = vec2(aspectRatio, 1.0);
  vec4 prevProjected = projectionViewModel * vec4(prevPosition, 1.0);
  vec4 currProjected = projectionViewModel * vec4(currPosition, 1.0);
  vec4 nextProjected = projectionViewModel * vec4(nextPosition, 1.0);

  // get 2D screen space with W divide and aspect correction
  vec2 prevScreen = prevProjected.xy / prevProjected.w * aspectVec;
  vec2 currScreen = currProjected.xy / currProjected.w * aspectVec;
  vec2 nextScreen = nextProjected.xy / nextProjected.w * aspectVec;

  // starting point uses (next - current)
  vec2 dir = vec2(0.0);
  if (currScreen == prevScreen) {
    dir = normalize(nextScreen - currScreen);
  }
  // ending point uses (current - previous)
  else if (currScreen == nextScreen) {
    dir = normalize(currScreen - prevScreen);
  }
  // somewhere in middle, needs a join
  else {
    // get directions from (C - B) and (B - A)
    vec2 dirA = normalize((currScreen - prevScreen));
    if (miter == 1) {
      vec2 dirB = normalize((nextScreen - currScreen));
      // now compute the miter join normal and length
      vec2 tangent = normalize(dirA + dirB);
      vec2 perp = vec2(-dirA.y, dirA.x);
      vec2 miter = vec2(-tangent.y, tangent.x);
      dir = tangent;
    } else {
      dir = dirA;
    }
  }

  vec2 normal = vec2(-dir.y, dir.x) * width;
  normal.x /= aspectRatio;
  vec4 offset = vec4(normal * offsetScale, 0.0, 0.0);
  gl_Position = currProjected + offset;

  // Get color from texture
  float colorRowIndex = floor((colorIndex + colorTexEps) / colorTexRes);
  vec2 colorTexIndex = vec2(
    (colorIndex / colorTexRes) - colorRowIndex + colorTexEps,
    colorRowIndex / colorTexRes + colorTexEps
  );

  color = texture2D(colorTex, colorTexIndex);
  color.a = useColorOpacity * color.a + useOpacity * opacity;
}`;

  const {
    push,
    splice
  } = Array.prototype;
  const I = new Float32Array([1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1]);
  const FLOAT_BYTES$1 = Float32Array.BYTES_PER_ELEMENT;

  const createMesh = (numPointsPerLine, buffer = []) => {
    let numPrevPoints = 0;
    numPointsPerLine.forEach(numPoints => {
      for (let i = 0; i < numPoints - 1; i++) {
        const a = numPrevPoints + i * 2; // `2`  because we duplicated all points

        const b = a + 1;
        const c = a + 2;
        const d = a + 3;
        buffer.push(a, b, c, c, b, d);
      } // Each line adds an additional start and end point, hence, `numPoints + 2`
      // And again, since all points are duplicated, we have `* 2`


      numPrevPoints += (numPoints + 2) * 2;
    });
    return buffer;
  };

  const Buffer = {
    duplicate(buffer, stride = 1, dupScale = 1) {
      const out = [];
      const component = new Array(stride * 2);

      for (let i = 0, il = buffer.length / stride; i < il; i++) {
        const index = i * stride;

        for (let j = 0; j < stride; j++) {
          const value = buffer[index + j];
          component[j] = value;
          component[j + stride] = value * dupScale;
        }

        push.apply(out, component);
      }

      return out;
    },

    mapElement(buffer, elementIndex, stride, map) {
      for (let i = 0, il = buffer.length / stride; i < il; i++) {
        const index = elementIndex + i * stride;
        buffer[index] = map(buffer[index], index, i);
      }

      return buffer;
    },

    copyElement(buffer, sourceElementIndex, targetIndex, stride) {
      const component = new Array(stride);
      const ai = sourceElementIndex * stride; // Copy source element component wise

      for (let i = 0; i < stride; i++) component[i] = buffer[ai + i];

      splice.call(buffer, targetIndex * stride, 0, ...component);
      return buffer;
    },

    increaseStride(buffer, stride, newStride, undefValue = 0) {
      const out = [];
      const component = new Array(newStride).fill(undefValue);

      for (let i = 0, il = buffer.length / stride; i < il; i++) {
        const index = i * stride;

        for (let j = 0; j < stride; j++) {
          component[j] = buffer[index + j];
        }

        push.apply(out, component);
      }

      return out;
    }

  };

  const createLine = (regl, {
    projection = I,
    model = I,
    view = I,
    points = [],
    colorIndices = [],
    color = [0.8, 0.5, 0, 1],
    opacity = null,
    opacities = [],
    width = 1,
    widths = [],
    miter = 1,
    is2d = false,
    zPos2d = 0
  } = {}) => {
    if (!regl) {
      console.error('Regl instance is undefined.');
      return;
    }

    const pvm = new Float32Array(16);
    let numLines;
    let numPoints;
    let numPointsPerLine;
    let pointsPadded;
    let pointsDup;
    let colorIndicesDup;
    let opacitiesDup;
    let widthsDup;
    let indices;
    let pointBuffer;
    let opacityBuffer;
    let widthBuffer;
    let colorTex;
    let colorTexRes;
    let colorIndexBuffer;
    let attributes;
    let elements;
    let drawLine;
    let dim = is2d ? 2 : 3;

    const useOpacity = () => +(opacities.length === numPoints || opacity !== null);

    const init = () => {
      pointBuffer = regl.buffer();
      opacityBuffer = regl.buffer();
      widthBuffer = regl.buffer();
      colorIndexBuffer = regl.buffer();
      attributes = {
        prevPosition: {
          buffer: () => pointBuffer,
          offset: 0,
          stride: FLOAT_BYTES$1 * 3
        },
        currPosition: {
          buffer: () => pointBuffer,
          // note that each point is duplicated, hence we need to skip over the first two
          offset: FLOAT_BYTES$1 * 3 * 2,
          stride: FLOAT_BYTES$1 * 3
        },
        nextPosition: {
          buffer: () => pointBuffer,
          // note that each point is duplicated, hence we need to skip over the first four
          offset: FLOAT_BYTES$1 * 3 * 4,
          stride: FLOAT_BYTES$1 * 3
        },
        opacity: {
          buffer: () => opacityBuffer,
          // note that each point is duplicated, hence we need to skip over the first two
          offset: FLOAT_BYTES$1 * 2,
          stride: FLOAT_BYTES$1
        },
        offsetScale: {
          buffer: () => widthBuffer,
          // note that each point is duplicated, hence we need to skip over the first two
          offset: FLOAT_BYTES$1 * 2,
          stride: FLOAT_BYTES$1
        },
        colorIndex: {
          buffer: () => colorIndexBuffer,
          // note that each point is duplicated, hence we need to skip over the first two
          offset: FLOAT_BYTES$1 * 2,
          stride: FLOAT_BYTES$1
        }
      };
      elements = regl.elements();
      drawLine = regl({
        attributes,
        depth: {
          enable: !is2d
        },
        blend: {
          enable: true,
          func: {
            srcRGB: 'src alpha',
            srcAlpha: 'one',
            dstRGB: 'one minus src alpha',
            dstAlpha: 'one minus src alpha'
          }
        },
        uniforms: {
          projectionViewModel: (context, props) => {
            const projection = context.projection || props.projection;
            const model = context.model || props.model;
            const view = context.view || props.view;
            return multiply(pvm, projection, multiply(pvm, view, model));
          },
          aspectRatio: ({
            viewportWidth,
            viewportHeight
          }) => viewportWidth / viewportHeight,
          colorTex: () => colorTex,
          colorTexRes: () => colorTexRes,
          colorTexEps: () => 0.5 / colorTexRes,
          pixelRatio: ({
            pixelRatio
          }) => pixelRatio,
          width: ({
            pixelRatio,
            viewportHeight
          }) => width / viewportHeight * pixelRatio,
          useOpacity,
          useColorOpacity: () => +!useOpacity(),
          miter
        },
        elements: () => elements,
        vert: VERTEX_SHADER$1,
        frag: FRAGMENT_SHADER$3
      });
    };

    const prepare = () => {
      if (numLines === 1 && points.length % dim > 0) {
        console.warn(`The length of points (${numPoints}) does not match the dimensions (${dim}). Incomplete points are ignored.`);
      } // Copy all points belonging to complete points


      pointsPadded = points.flat().slice(0, numPoints * dim); // Add the missing z point

      if (is2d) {
        pointsPadded = Buffer.increaseStride(pointsPadded, 2, 3, zPos2d);
      }

      if (colorIndices.length !== numPoints) colorIndices = new Array(numPoints).fill(0);
      if (widths.length !== numPoints) widths = new Array(numPoints).fill(1);
      let finalColorIndices = colorIndices.slice();
      let finalOpacities = opacities.length === numPoints ? opacities.slice() : new Array(numPoints).fill(+opacity);
      let finalWidths = widths.slice();
      let k = 0;
      numPointsPerLine.forEach(n => {
        const lastPointIdx = k + n - 1; // For each line, duplicate the first and last point.
        // E.g., [1,2,3] -> [1,1,2,3,3]
        // First, copy the last point to the end

        Buffer.copyElement(pointsPadded, lastPointIdx, lastPointIdx, 3); // Second, copy the first point to the beginning

        Buffer.copyElement(pointsPadded, k, k, 3);
        Buffer.copyElement(finalColorIndices, lastPointIdx, lastPointIdx, 1);
        Buffer.copyElement(finalColorIndices, k, k, 1);
        Buffer.copyElement(finalOpacities, lastPointIdx, lastPointIdx, 1);
        Buffer.copyElement(finalOpacities, k, k, 1);
        Buffer.copyElement(finalWidths, lastPointIdx, lastPointIdx, 1);
        Buffer.copyElement(finalWidths, k, k, 1);
        k += n + 2;
      }); // duplicate each point for the positive and negative width (see below)

      pointsDup = new Float32Array(Buffer.duplicate(pointsPadded, 3)); // duplicate each color, opacity, and width such that we have a positive
      // and negative width

      colorIndicesDup = Buffer.duplicate(finalColorIndices);
      opacitiesDup = Buffer.duplicate(finalOpacities);
      widthsDup = Buffer.duplicate(finalWidths, 1, -1); // create the line mesh, i.e., the vertex indices

      indices = createMesh(numPointsPerLine);
      pointBuffer({
        usage: 'dynamic',
        type: 'float',
        length: pointsDup.length * FLOAT_BYTES$1,
        data: pointsDup
      });
      opacityBuffer({
        usage: 'dynamic',
        type: 'float',
        length: opacitiesDup.length * FLOAT_BYTES$1,
        data: opacitiesDup
      });
      widthBuffer({
        usage: 'dynamic',
        type: 'float',
        length: widthsDup.length * FLOAT_BYTES$1,
        data: widthsDup
      });
      colorIndexBuffer({
        usage: 'dynamic',
        type: 'float',
        length: colorIndicesDup.length * FLOAT_BYTES$1,
        data: colorIndicesDup
      });
      elements({
        primitive: 'triangles',
        usage: 'dynamic',
        type: indices.length > 2 ** 16 ? 'uint32' : 'uint16',
        data: indices
      });
    };

    const clear = () => {
      destroy();
      init();
    };

    const destroy = () => {
      points = null;
      pointsPadded = null;
      pointsDup = null;
      widthsDup = null;
      indices = null;
      pointBuffer.destroy();
      widthBuffer.destroy();
      elements.destroy();
    };

    const draw = ({
      projection: newProjection,
      model: newModel,
      view: newView
    } = {}) => {
      // cache the view-defining matrices
      if (newProjection) {
        projection = newProjection;
      }

      if (newModel) {
        model = newModel;
      }

      if (newView) {
        view = newView;
      } // only draw when some points have been specified


      if (points && points.length > 1) {
        drawLine({
          projection,
          model,
          view
        });
      }
    };

    const getPerPointProperty = (property, newValues) => {
      const flatNewValues = newValues.flat(2);

      if (flatNewValues.length === numPoints) {
        return flatNewValues;
      } else if (flatNewValues.length === numLines) {
        return numPointsPerLine.map((n, i) => Array(n).fill(flatNewValues[i])).flat();
      }

      return property;
    };

    const getPoints = () => points;

    const setPoints = (newPoints = [], {
      colorIndices: newColorIndices = colorIndices,
      opacities: newOpacities = opacities,
      widths: newWidths = widths,
      is2d: newIs2d = is2d
    } = {}) => {
      points = newPoints;
      is2d = newIs2d;
      dim = is2d ? 2 : 3;
      numLines = Array.isArray(points[0]) ? points.length : 1;
      numPointsPerLine = numLines > 1 ? points.map(pts => Math.floor(pts.length / dim)) : [Math.floor(points.length / dim)];
      numPoints = numPointsPerLine.reduce((n, nPts) => n + nPts, 0);
      colorIndices = getPerPointProperty(colorIndices, newColorIndices);
      opacities = getPerPointProperty(opacities, newOpacities);
      widths = getPerPointProperty(widths, newWidths);

      if (points && numPoints > 1) {
        prepare();
      } else {
        clear();
      }
    };

    const getNestedness = (arr, level = -1) => {
      if (!Array.isArray(arr)) return level;
      if (arr.length && !Array.isArray(arr[0])) return level + 1;
      return getNestedness(arr[0], ++level);
    };

    const createColorTexture = () => {
      const colors = getNestedness(color) === 0 ? [color] : color;
      colorTexRes = Math.max(2, Math.ceil(Math.sqrt(colors.length)));
      const rgba = new Uint8Array(colorTexRes ** 2 * 4);
      colors.forEach((color, i) => {
        rgba[i * 4] = Math.min(255, Math.max(0, Math.round(color[0] * 255))); // r

        rgba[i * 4 + 1] = Math.min(255, Math.max(0, Math.round(color[1] * 255))); // g

        rgba[i * 4 + 2] = Math.min(255, Math.max(0, Math.round(color[2] * 255))); // b

        rgba[i * 4 + 3] = Number.isNaN(+color[3]) ? 255 : Math.min(255, Math.max(0, Math.round(color[3] * 255))); // a
      });
      colorTex = regl.texture({
        data: rgba,
        shape: [colorTexRes, colorTexRes, 4]
      });
    };

    const setColor = (newColor, newOpacity = opacity) => {
      color = newColor;
      opacity = newOpacity;
      if (colorTex) colorTex.destroy();
      createColorTexture();
    };

    const getStyle = () => ({
      color,
      miter,
      width
    });

    const setStyle = ({
      color: newColor,
      opacity: newOpacity,
      miter: newMiter,
      width: newWidth
    } = {}) => {
      if (newColor) setColor(newColor, newOpacity);
      if (newMiter) miter = newMiter;
      if (+newWidth > 0) width = newWidth;
    };

    const getBuffer = () => ({
      points: pointBuffer,
      widths: widthBuffer,
      opacities: opacityBuffer,
      colorIndices: colorIndexBuffer
    });

    const getData = () => ({
      points: pointsDup,
      widths: widthsDup,
      opacities: opacitiesDup,
      colorIndices: colorIndicesDup
    }); // initialize parameters


    init();
    createColorTexture(); // prepare data if points are already specified

    if (points && points.length > 1) {
      setPoints(points);
    }

    return {
      clear,
      destroy,
      draw,
      getPoints,
      setPoints,
      getData,
      getBuffer,
      getStyle,
      setStyle
    };
  };

  // @flekschas/utils v0.29.0 Copyright 2021 Fritz Lekschas

  /* eslint no-param-reassign:0 */

  /**
   * Cubic in easing function
   * @param {number} t - The input time to be eased. Must be in [0, 1] where `0`
   *   refers to the start and `1` to the end
   * @return {number} The eased time
   */
  const cubicIn = t => t * t * t;
  /**
   * Cubic in and out easing function
   * @param {number} t - The input time to be eased. Must be in [0, 1] where `0`
   *   refers to the start and `1` to the end
   * @return {number} The eased time
   */


  const cubicInOut = t => t < 0.5 ? 4 * t * t * t : (t - 1) * (2 * t - 2) * (2 * t - 2) + 1;
  /**
   * Cubic out easing function
   * @param {number} t - The input time to be eased. Must be in [0, 1] where `0`
   *   refers to the start and `1` to the end
   * @return {number} The eased time
   */


  const cubicOut = t => --t * t * t + 1;
  /**
   * Linear easing function
   * @param {number} t - The input time to be eased. Must be in [0, 1] where `0`
   *   refers to the start and `1` to the end
   * @return {number} Same as the input
   */


  const linear = t => t;
  /**
   * Quadratic in easing function
   * @param {number} t - The input time to be eased. Must be in [0, 1] where `0`
   *   refers to the start and `1` to the end
   * @return {number} The eased time
   */


  const quadIn = t => t * t;
  /**
   * Quadratic in and out easing function
   * @param {number} t - The input time to be eased. Must be in [0, 1] where `0`
   *   refers to the start and `1` to the end
   * @return {number} The eased time
   */


  const quadInOut = t => t < 0.5 ? 2 * t * t : -1 + (4 - 2 * t) * t;
  /**
   * Quadratic out easing function
   * @param {number} t - The input time to be eased. Must be in [0, 1] where `0`
   *   refers to the start and `1` to the end
   * @return {number} The eased time
   */


  const quadOut = t => t * (2 - t);
  /**
   * Identity function
   * @param   {*}  x  Any kind of value
   * @return  {*}  `x`
   */


  const identity = x => x;
  /**
   * Initialize an array of a certain length using a mapping function
   *
   * @description
   * This is equivalent to `Array(length).fill().map(mapFn)` but about 60% faster
   *
   * @param {number} length - Size of the array
   * @param {function} mapFn - Mapping function
   * @return {array} Initialized array
   */


  const rangeMap = (length, mapFn = x => x) => {
    const out = [];

    for (let i = 0; i < length; i++) {
      out.push(mapFn(i, length));
    }

    return out;
  };
  /**
   * Get the unique union of two vectors of integers
   * @param {array} v - First vector of integers
   * @param {array} w - Second vector of integers
   * @return {array} Unique union of `v` and `w`
   */


  const unionIntegers = (v, w) => {
    const a = [];
    v.forEach(x => {
      a[x] = true;
    });
    w.forEach(x => {
      a[x] = true;
    });
    return a.reduce((union, value, i) => {
      if (value) union.push(i);
      return union;
    }, []);
  };

  const assign = (target, ...sources) => {
    sources.forEach(source => {
      // eslint-disable-next-line no-shadow
      const descriptors = Object.keys(source).reduce((descriptors, key) => {
        descriptors[key] = Object.getOwnPropertyDescriptor(source, key);
        return descriptors;
      }, {}); // By default, Object.assign copies enumerable Symbols, too

      Object.getOwnPropertySymbols(source).forEach(symbol => {
        const descriptor = Object.getOwnPropertyDescriptor(source, symbol);

        if (descriptor.enumerable) {
          descriptors[symbol] = descriptor;
        }
      });
      Object.defineProperties(target, descriptors);
    });
    return target;
  };
  /**
   * Convenience function to compose functions
   * @param {...function} fns - Array of functions
   * @return {function} The composed function
   */


  const pipe = (...fns) =>
  /**
   * @param {*} x - Some value
   * @return {*} Output of the composed function
   */
  x => fns.reduce((y, f) => f(y), x);
  /**
   * Assign a constructor to the object
   * @param {function} constructor - Constructor functions
   */


  const withConstructor = constructor => self => assign({
    __proto__: {
      constructor
    }
  }, self);
  /**
   * Assign a static property to an object
   * @param {string} name - Name of the property
   * @param {*} value - Static value
   */


  const withStaticProperty = (name, value) => self => assign(self, {
    get [name]() {
      return value;
    }

  });
  /**
   * L2 distance between a pair of points
   *
   * @description
   * Identical but much faster than `l2Dist([fromX, fromY], [toX, toY])`
   *
   * @param {number} fromX - X coordinate of the first point
   * @param {number} fromY - Y coordinate of the first point
   * @param {number} toX - X coordinate of the second point
   * @param {number} toY - Y coordinate of the first point
   * @return {number} L2 distance
   */


  const l2PointDist = (fromX, fromY, toX, toY) => Math.sqrt((fromX - toX) ** 2 + (fromY - toY) ** 2);
  /**
   * Create a worker from a function
   * @param {function} fn - Function to be turned into a worker
   * @return {Worker} Worker function
   */


  const createWorker = fn => new Worker(window.URL.createObjectURL(new Blob([`(${fn.toString()})()`], {
    type: 'text/javascript'
  })));
  /**
   * Get a promise that resolves after the next `n` animation frames
   * @param {number} n - Number of animation frames to wait
   * @return {Promise} A promise that resolves after the next `n` animation frames
   */


  const nextAnimationFrame = (n = 1) => new Promise(resolve => {
    let i = 0;

    const raf = () => requestAnimationFrame(() => {
      i++;
      if (i < n) raf();else resolve();
    });

    raf();
  });
  /**
   * Throttle and debounce a function call
   *
   * Throttling a function call means that the function is called at most every
   * `interval` milliseconds no matter how frequently you trigger a call.
   * Debouncing a function call means that the function is called the earliest
   * after `finalWait` milliseconds wait time where the function was not called.
   * Combining the two ensures that the function is called at most every
   * `interval` milliseconds and is ensured to be called with the very latest
   * arguments after after `finalWait` milliseconds wait time at the end.
   *
   * The following imaginary scenario describes the behavior:
   *
   * MS | throttleTime=3 and debounceTime=3
   * 1. y(f, 3, 3)(args1) => f(args1) called
   * 2. y(f, 3, 3)(args2) => call ignored due to throttling
   * 3. y(f, 3, 3)(args3) => call ignored due to throttling
   * 4. y(f, 3, 3)(args4) => f(args4) called
   * 5. y(f, 3, 3)(args5) => all ignored due to throttling
   * 6. No call           => nothing
   * 7. No call           => f(args5) called due to debouncing
   *
   * @param {functon} func - Function to be throttled and debounced
   * @param {number} interval - Throttle intevals in milliseconds
   * @param {number} wait - Debounce wait time in milliseconds By default this is
   *   the same as `interval`.
   * @return {function} - Throttled and debounced function
   */


  const throttleAndDebounce = (fn, throttleTime, debounceTime = null) => {
    let timeout;
    let blockedCalls = 0; // eslint-disable-next-line no-param-reassign

    debounceTime = debounceTime === null ? throttleTime : debounceTime;

    const debounced = (...args) => {
      const later = () => {
        // Since we throttle and debounce we should check whether there were
        // actually multiple attempts to call this function after the most recent
        // throttled call. If there were no more calls we don't have to call
        // the function again.
        if (blockedCalls > 0) {
          fn(...args);
          blockedCalls = 0;
        }
      };

      clearTimeout(timeout);
      timeout = setTimeout(later, debounceTime);
    };

    let isWaiting = false;

    const throttledAndDebounced = (...args) => {
      if (!isWaiting) {
        fn(...args);
        debounced(...args);
        isWaiting = true;
        blockedCalls = 0;
        setTimeout(() => {
          isWaiting = false;
        }, throttleTime);
      } else {
        blockedCalls++;
        debounced(...args);
      }
    };

    throttledAndDebounced.reset = () => {
      isWaiting = false;
    };

    throttledAndDebounced.cancel = () => {
      clearTimeout(timeout);
    };

    throttledAndDebounced.now = (...args) => fn(...args);

    return throttledAndDebounced;
  };
  /**
   * Promise that resolves after some time
   * @param {number} msec - Time in milliseconds until the promise is resolved
   * @return {Promise} Promise resolving after `msec` milliseconds
   */


  const wait = msec => new Promise(resolve => setTimeout(resolve, msec));

  var _DEFAULT_KEY_MAP;
  var AUTO = 'auto';
  var COLOR_NORMAL_IDX = 0;
  var COLOR_ACTIVE_IDX = 1;
  var COLOR_HOVER_IDX = 2;
  var COLOR_BG_IDX = 3;
  var COLOR_NUM_STATES = 4;
  var FLOAT_BYTES = Float32Array.BYTES_PER_ELEMENT;
  var GL_EXTENSIONS = ['OES_texture_float', 'OES_element_index_uint', 'WEBGL_color_buffer_float', 'EXT_float_blend'];
  var CLEAR_OPTIONS = {
    color: [0, 0, 0, 0],
    // Transparent background color
    depth: 1
  };
  var MOUSE_MODE_PANZOOM = 'panZoom';
  var MOUSE_MODE_LASSO = 'lasso';
  var MOUSE_MODE_ROTATE = 'rotate';
  var MOUSE_MODES = [MOUSE_MODE_PANZOOM, MOUSE_MODE_LASSO, MOUSE_MODE_ROTATE];
  var DEFAULT_MOUSE_MODE = MOUSE_MODE_PANZOOM; // Easing

  var EASING_FNS = {
    cubicIn: cubicIn,
    cubicInOut: cubicInOut,
    cubicOut: cubicOut,
    linear: linear,
    quadIn: quadIn,
    quadInOut: quadInOut,
    quadOut: quadOut
  };
  var DEFAULT_EASING = cubicInOut; // Default lasso

  var LASSO_CLEAR_ON_DESELECT = 'deselect';
  var LASSO_CLEAR_ON_END = 'lassoEnd';
  var LASSO_CLEAR_EVENTS = [LASSO_CLEAR_ON_DESELECT, LASSO_CLEAR_ON_END];
  var DEFAULT_LASSO_COLOR = [0, 0.666666667, 1, 1];
  var DEFAULT_LASSO_LINE_WIDTH = 2;
  var DEFAULT_LASSO_INITIATOR = false;
  var DEFAULT_LASSO_MIN_DELAY$1 = 10;
  var DEFAULT_LASSO_MIN_DIST$1 = 3;
  var DEFAULT_LASSO_CLEAR_EVENT = LASSO_CLEAR_ON_END; // Key mapping

  var KEY_ACTION_LASSO = 'lasso';
  var KEY_ACTION_ROTATE = 'rotate';
  var KEY_ACTION_MERGE = 'merge';
  var KEY_ACTIONS = [KEY_ACTION_LASSO, KEY_ACTION_ROTATE, KEY_ACTION_MERGE];
  var KEY_ALT = 'alt';
  var KEY_CMD = 'cmd';
  var KEY_CTRL = 'ctrl';
  var KEY_META = 'meta';
  var KEY_SHIFT = 'shift';
  var KEYS = [KEY_ALT, KEY_CMD, KEY_CTRL, KEY_META, KEY_SHIFT];
  var DEFAULT_KEY_MAP = (_DEFAULT_KEY_MAP = {}, _defineProperty(_DEFAULT_KEY_MAP, KEY_ALT, KEY_ACTION_ROTATE), _defineProperty(_DEFAULT_KEY_MAP, KEY_SHIFT, KEY_ACTION_LASSO), _defineProperty(_DEFAULT_KEY_MAP, KEY_CMD, KEY_ACTION_MERGE), _DEFAULT_KEY_MAP); // Default attribute

  var DEFAULT_DATA_ASPECT_RATIO = 1;
  var DEFAULT_WIDTH = AUTO;
  var DEFAULT_HEIGHT = AUTO;
  var DEFAULT_GAMMA = 1; // Default styles

  var MIN_POINT_SIZE = 1;
  var DEFAULT_POINT_SIZE = 6;
  var DEFAULT_POINT_SIZE_SELECTED = 2;
  var DEFAULT_POINT_OUTLINE_WIDTH = 2;
  var DEFAULT_SIZE_BY = null;
  var DEFAULT_POINT_CONNECTION_SIZE = 2;
  var DEFAULT_POINT_CONNECTION_SIZE_ACTIVE = 2;
  var DEFAULT_POINT_CONNECTION_SIZE_BY = null;
  var DEFAULT_POINT_CONNECTION_OPACITY = null;
  var DEFAULT_POINT_CONNECTION_OPACITY_BY = null;
  var DEFAULT_POINT_CONNECTION_OPACITY_ACTIVE = 0.66;
  var DEFAULT_OPACITY = 1;
  var DEFAULT_OPACITY_BY = null;
  var DEFAULT_OPACITY_BY_DENSITY_FILL = 0.15;
  var DEFAULT_OPACITY_BY_DENSITY_DEBOUNCE_TIME = 25; // Default colors
  var DEFAULT_COLOR_BY = null;
  var DEFAULT_COLOR_NORMAL = [0.66, 0.66, 0.66, DEFAULT_OPACITY];
  var DEFAULT_COLOR_ACTIVE = [0, 0.55, 1, 1];
  var DEFAULT_COLOR_HOVER = [1, 1, 1, 1];
  var DEFAULT_COLOR_BG = [0, 0, 0, 1];
  var DEFAULT_POINT_CONNECTION_COLOR_BY = null;
  var DEFAULT_POINT_CONNECTION_COLOR_NORMAL = [0.66, 0.66, 0.66, 0.2];
  var DEFAULT_POINT_CONNECTION_COLOR_ACTIVE = [0, 0.55, 1, 1];
  var DEFAULT_POINT_CONNECTION_COLOR_HOVER = [1, 1, 1, 1]; // Default view

  var DEFAULT_TARGET = [0, 0];
  var DEFAULT_DISTANCE = 1;
  var DEFAULT_ROTATION = 0; // prettier-ignore

  var DEFAULT_VIEW = new Float32Array([1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1]); // Default misc

  var DEFAULT_BACKGROUND_IMAGE = null;
  var DEFAULT_SHOW_RETICLE = false;
  var DEFAULT_RETICLE_COLOR = [1, 1, 1, 0.5];
  var DEFAULT_DESELECT_ON_DBL_CLICK = true;
  var DEFAULT_DESELECT_ON_ESCAPE = true;
  var DEFAULT_SHOW_POINT_CONNECTIONS = false;
  var DEFAULT_POINT_CONNECTION_MAX_INT_POINTS_PER_SEGMENT = 100;
  var DEFAULT_POINT_CONNECTION_INT_POINTS_TOLERANCE = 1 / 500;
  var DEFAULT_POINT_SIZE_MOUSE_DETECTION = 'auto';
  var DEFAULT_PERFORMANCE_MODE = false;
  var SINGLE_CLICK_DELAY = 200;
  var LONG_CLICK_TIME = 500;
  var Z_NAMES = new Set(['z', 'valueZ', 'valueA', 'value1', 'category']);
  var W_NAMES = new Set(['w', 'valueW', 'valueB', 'value2', 'value']);

  /**
   * Check if all GL extensions are enabled and warn otherwise
   * @param   {import('regl').Regl}  regl  Regl instance to be tested
   * @return  {function}  Returns the Regl instance itself
   */

  var checkReglExtensions = function checkReglExtensions(regl) {
    if (!regl) return false;
    return GL_EXTENSIONS.reduce(function (every, EXTENSION) {
      if (!regl.hasExtension(EXTENSION)) {
        console.warn("WebGL: ".concat(EXTENSION, " extension not supported. Scatterplot might not render properly"));
        return false;
      }

      return every;
    }, true);
  };
  /**
   * Create a new Regl instance with `GL_EXTENSIONS` enables
   * @param   {HTMLCanvasElement}  canvas  Canvas element to be rendered on
   * @return  {import('regl').Regl}  New Regl instance
   */

  var createRegl = function createRegl(canvas) {
    var gl = canvas.getContext('webgl', {
      antialias: true,
      preserveDrawingBuffer: true
    });
    var extensions = []; // Needed to run the tests properly as the headless-gl doesn't support all
    // extensions, which is fine for the functional tests.

    GL_EXTENSIONS.forEach(function (EXTENSION) {
      if (gl.getExtension(EXTENSION)) {
        extensions.push(EXTENSION);
      } else {
        console.warn("WebGL: ".concat(EXTENSION, " extension not supported. Scatterplot might not render properly"));
      }
    });
    return createOriginalRegl__default['default']({
      gl: gl,
      extensions: extensions
    });
  };
  /**
   * L2 distance between a pair of 2D points
   * @param   {number}  x1  X coordinate of the first point
   * @param   {number}  y1  Y coordinate of the first point
   * @param   {number}  x2  X coordinate of the second point
   * @param   {number}  y2  Y coordinate of the first point
   * @return  {number}  L2 distance
   */

  var dist = function dist(x1, y1, x2, y2) {
    return Math.sqrt(Math.pow(x1 - x2, 2) + Math.pow(y1 - y2, 2));
  };
  /**
   * Get the bounding box of a set of 2D positions
   * @param   {array}  positions2d  2D positions to be checked
   * @return  {array}  Quadruple of form `[xMin, yMin, xMax, yMax]` defining the
   *  bounding box
   */

  var getBBox = function getBBox(positions2d) {
    var xMin = Infinity;
    var xMax = -Infinity;
    var yMin = Infinity;
    var yMax = -Infinity;

    for (var i = 0; i < positions2d.length; i += 2) {
      xMin = positions2d[i] < xMin ? positions2d[i] : xMin;
      xMax = positions2d[i] > xMax ? positions2d[i] : xMax;
      yMin = positions2d[i + 1] < yMin ? positions2d[i + 1] : yMin;
      yMax = positions2d[i + 1] > yMax ? positions2d[i + 1] : yMax;
    }

    return [xMin, yMin, xMax, yMax];
  };
  /**
   * Convert a HEX-encoded color to an RGB-encoded color
   * @param   {string}  hex  HEX-encoded color string.
   * @param   {boolean}  isNormalize  If `true` the returned RGB values will be
   *   normalized to `[0,1]`.
   * @return  {array}  Triple holding the RGB values.
   */

  var hexToRgb = function hexToRgb(hex) {
    var isNormalize = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    return hex.replace(/^#?([a-f\d])([a-f\d])([a-f\d])$/i, function (m, r, g, b) {
      return "#".concat(r).concat(r).concat(g).concat(g).concat(b).concat(b);
    }).substring(1).match(/.{2}/g).map(function (x) {
      return parseInt(x, 16) / Math.pow(255, isNormalize);
    });
  };
  var isConditionalArray = function isConditionalArray(a, condition) {
    var _ref = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {},
        _ref$minLength = _ref.minLength,
        minLength = _ref$minLength === void 0 ? 0 : _ref$minLength;

    return Array.isArray(a) && a.length >= minLength && a.every(condition);
  };
  var isPositiveNumber = function isPositiveNumber(x) {
    return !Number.isNaN(+x) && +x >= 0;
  };
  var isStrictlyPositiveNumber = function isStrictlyPositiveNumber(x) {
    return !Number.isNaN(+x) && +x > 0;
  };
  /**
   * Create a function to limit choices to a predefined list
   * @param   {array}  choices  Array of acceptable choices
   * @param   {*}  defaultOption  Default choice
   * @return  {function}  Function limiting the choices
   */

  var limit = function limit(choices, defaultChoice) {
    return function (choice) {
      return choices.indexOf(choice) >= 0 ? choice : defaultChoice;
    };
  };
  /**
   * Promised-based image loading
   * @param {string}  src  Remote image source, i.e., a URL
   * @param {boolean} isCrossOrigin If `true` allow loading image from a source of another origin.
   * @return  {Promise<HTMLImageElement>}  Promise resolving to the image once its loaded
   */

  var loadImage = function loadImage(src) {
    var isCrossOrigin = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    return new Promise(function (accept, reject) {
      var image = new Image();
      if (isCrossOrigin) image.crossOrigin = 'anonymous';
      image.src = src;

      image.onload = function () {
        accept(image);
      };

      image.onerror = function (error) {
        reject(error);
      };
    });
  };
  /**
   * @deprecated Please use `scatterplot.createTextureFromUrl(url)`
   *
   * Create a Regl texture from an URL.
   * @param   {import('regl').Regl}  regl  Regl instance used for creating the texture.
   * @param   {string}  url  Source URL of the image.
   * @return  {Promise<import('regl').Texture2D>}  Promise resolving to the texture object.
   */

  var createTextureFromUrl = function createTextureFromUrl(regl, url) {
    return new Promise(function (resolve, reject) {
      loadImage(url, url.indexOf(window.location.origin) !== 0 && url.indexOf('base64') === -1).then(function (image) {
        resolve(regl.texture(image));
      })["catch"](function (error) {
        reject(error);
      });
    });
  };
  /**
   * Convert a HEX-encoded color to an RGBA-encoded color
   * @param   {string}  hex  HEX-encoded color string.
   * @param   {boolean}  isNormalize  If `true` the returned RGBA values will be
   *   normalized to `[0,1]`.
   * @return  {array}  Triple holding the RGBA values.
   */

  var hexToRgba = function hexToRgba(hex) {
    var isNormalize = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    return [].concat(_toConsumableArray(hexToRgb(hex, isNormalize)), [Math.pow(255, !isNormalize)]);
  };
  /**
   * Tests if a string is a valid HEX color encoding
   * @param   {string}  hex  HEX-encoded color string.
   * @return  {boolean}  If `true` the string is a valid HEX color encoding.
   */

  var isHex = function isHex(hex) {
    return /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(hex);
  };
  /**
   * Tests if a number is in `[0,1]`.
   * @param   {number}  x  Number to be tested.
   * @return  {boolean}  If `true` the number is in `[0,1]`.
   */

  var isNormFloat = function isNormFloat(x) {
    return x >= 0 && x <= 1;
  };
  /**
   * Tests if an array consist of normalized numbers that are in `[0,1]` only.
   * @param   {array}  a  Array to be tested
   * @return  {boolean}  If `true` the array contains only numbers in `[0,1]`.
   */

  var isNormFloatArray = function isNormFloatArray(a) {
    return Array.isArray(a) && a.every(isNormFloat);
  };
  /**
   * From: https://wrf.ecse.rpi.edu//Research/Short_Notes/pnpoly.html
   * @param   {Array}  point  Tuple of the form `[x,y]` to be tested.
   * @param   {Array}  polygon  1D list of vertices defining the polygon.
   * @return  {boolean}  If `true` point lies within the polygon.
   */

  var isPointInPolygon = function isPointInPolygon() {
    var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [],
        _ref3 = _slicedToArray(_ref2, 2),
        px = _ref3[0],
        py = _ref3[1];

    var polygon = arguments.length > 1 ? arguments[1] : undefined;
    var x1;
    var y1;
    var x2;
    var y2;
    var isWithin = false;

    for (var i = 0, j = polygon.length - 2; i < polygon.length; i += 2) {
      x1 = polygon[i];
      y1 = polygon[i + 1];
      x2 = polygon[j];
      y2 = polygon[j + 1];
      if (y1 > py !== y2 > py && px < (x2 - x1) * (py - y1) / (y2 - y1) + x1) isWithin = !isWithin;
      j = i;
    }

    return isWithin;
  };
  /**
   * Tests if a variable is a string
   * @param   {*}  s  Variable to be tested
   * @return  {boolean}  If `true` variable is a string
   */

  var isString = function isString(s) {
    return typeof s === 'string' || s instanceof String;
  };
  /**
   * Tests if a number is an interger and in `[0,255]`.
   * @param   {number}  x  Number to be tested.
   * @return  {boolean}  If `true` the number is an interger and in `[0,255]`.
   */

  var isUint8 = function isUint8(x) {
    return Number.isInteger(x) && x >= 0 && x <= 255;
  };
  /**
   * Tests if an array consist of Uint8 numbers only.
   * @param   {array}  a  Array to be tested.
   * @return  {boolean}  If `true` the array contains only Uint8 numbers.
   */

  var isUint8Array = function isUint8Array(a) {
    return Array.isArray(a) && a.every(isUint8);
  };
  /**
   * Tests if an array is encoding an RGB color.
   * @param   {array}  rgb  Array to be tested
   * @return  {boolean}  If `true` the array hold a triple of Uint8 numbers or
   *   a triple of normalized floats.
   */

  var isRgb = function isRgb(rgb) {
    return rgb.length === 3 && (isNormFloatArray(rgb) || isUint8Array(rgb));
  };
  /**
   * Tests if an array is encoding an RGBA color.
   * @param   {array}  rgb  Array to be tested
   * @return  {boolean}  If `true` the array hold a quadruple of Uint8 numbers or
   *   a quadruple of normalized floats.
   */

  var isRgba = function isRgba(rgba) {
    return rgba.length === 4 && (isNormFloatArray(rgba) || isUint8Array(rgba));
  };
  /**
   * Test if a color is multiple colors
   * @param   {*}  color  To be tested
   * @return  {boolean}  If `true`, `color` is an array of colors.
   */

  var isMultipleColors = function isMultipleColors(color) {
    return Array.isArray(color) && color.length && (Array.isArray(color[0]) || isString(color[0]));
  };
  /**
   * Fast version of `Math.max`. Based on
   *   https://jsperf.com/math-min-max-vs-ternary-vs-if/24 `Math.max` is not
   *   very fast
   * @param   {number}  a  Value A
   * @param   {number}  b  Value B
   * @return  {boolean}  If `true` A is greater than B.
   */

  var max = function max(a, b) {
    return a > b ? a : b;
  };
  /**
   * Fast version of `Math.min`. Based on
   *   https://jsperf.com/math-min-max-vs-ternary-vs-if/24 `Math.max` is not
   *   very fast
   * @param   {number}  a  Value A
   * @param   {number}  b  Value B
   * @return  {boolean}  If `true` A is smaller than B.
   */

  var min = function min(a, b) {
    return a < b ? a : b;
  };
  /**
   * Convert a color to an RGBA color
   * @param   {*}  color  Color to be converted. Currently supports:
   *   HEX, RGB, or RGBA.
   * @param   {boolean}  isNormalize  If `true` the returned RGBA values will be
   *   normalized to `[0,1]`.
   * @return  {array}  Quadruple defining an RGBA color.
   */

  var toRgba = function toRgba(color, shouldNormalize) {
    if (isRgba(color)) {
      var isNormalized = isNormFloatArray(color);
      if (shouldNormalize && isNormalized || !shouldNormalize && !isNormalized) return color;
      if (shouldNormalize && !isNormalized) return color.map(function (x) {
        return x / 255;
      });
      return color.map(function (x) {
        return x * 255;
      });
    }

    if (isRgb(color)) {
      var base = Math.pow(255, !shouldNormalize);

      var _isNormalized = isNormFloatArray(color);

      if (shouldNormalize && _isNormalized || !shouldNormalize && !_isNormalized) return [].concat(_toConsumableArray(color), [base]);
      if (shouldNormalize && !_isNormalized) return [].concat(_toConsumableArray(color.map(function (x) {
        return x / 255;
      })), [base]);
      return [].concat(_toConsumableArray(color.map(function (x) {
        return x * 255;
      })), [base]);
    }

    if (isHex(color)) return hexToRgba(color, shouldNormalize);
    console.warn('Only HEX, RGB, and RGBA are handled by this function. Returning white instead.');
    return shouldNormalize ? [1, 1, 1, 1] : [255, 255, 255, 255];
  };
  /**
   * Flip the key-value pairs of an object
   * @param {object} obj - Object to be flipped
   * @return {object} Flipped object
   */

  var flipObj = function flipObj(obj) {
    return Object.entries(obj).reduce(function (out, _ref4) {
      var _ref5 = _slicedToArray(_ref4, 2),
          key = _ref5[0],
          value = _ref5[1];

      if (out[value]) {
        out[value] = [].concat(_toConsumableArray(out[value]), [key]);
      } else {
        out[value] = key;
      }

      return out;
    }, {});
  };
  var rgbBrightness = function rgbBrightness(rgb) {
    return 0.21 * rgb[0] + 0.72 * rgb[1] + 0.07 * rgb[2];
  };

  var createRenderer = function createRenderer() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    var regl = options.regl,
        _options$canvas = options.canvas,
        canvas = _options$canvas === void 0 ? document.createElement('canvas') : _options$canvas,
        _options$gamma = options.gamma,
        _gamma = _options$gamma === void 0 ? DEFAULT_GAMMA : _options$gamma;

    checkReglExtensions(regl); // Same as regl ||= createRegl(canvas) but avoids having to rely on
    // https://babeljs.io/docs/en/babel-plugin-proposal-logical-assignment-operators
    // eslint-disable-next-line no-unused-expressions

    regl || (regl = createRegl(canvas));
    var fboRes = [canvas.width, canvas.height];
    var fbo = regl.framebuffer({
      width: fboRes[0],
      height: fboRes[1],
      colorFormat: 'rgba',
      colorType: 'float'
    });
    /**
     * Render the float32 framebuffer to the internal canvas
     *
     * From https://observablehq.com/@rreusser/selecting-the-right-opacity-for-2d-point-clouds
     */

    var renderToCanvas = regl({
      vert: "\n      precision highp float;\n      attribute vec2 xy;\n      void main () {\n        gl_Position = vec4(xy, 0, 1);\n      }",
      frag: "\n      precision highp float;\n      uniform vec2 srcRes;\n      uniform sampler2D src;\n      uniform float gamma;\n\n      vec3 approxLinearToSRGB (vec3 rgb, float gamma) {\n        return pow(clamp(rgb, vec3(0), vec3(1)), vec3(1.0 / gamma));\n      }\n\n      void main () {\n        vec4 color = texture2D(src, gl_FragCoord.xy / srcRes);\n        gl_FragColor = vec4(approxLinearToSRGB(color.rgb, gamma), color.a);\n      }",
      attributes: {
        xy: [-4, -4, 4, -4, 0, 4]
      },
      uniforms: {
        src: function src() {
          return fbo;
        },
        srcRes: function srcRes() {
          return fboRes;
        },
        gamma: function gamma() {
          return _gamma;
        }
      },
      count: 3,
      depth: {
        enable: false
      },
      blend: {
        enable: true,
        func: {
          srcRGB: 'one',
          srcAlpha: 'one',
          dstRGB: 'one minus src alpha',
          dstAlpha: 'one minus src alpha'
        }
      }
    });
    /**
     * Copy the pixels from the internal canvas onto the target canvas
     */

    var copyTo = function copyTo(targetCanvas) {
      var ctx = targetCanvas.getContext('2d');
      ctx.clearRect(0, 0, targetCanvas.width, targetCanvas.height);
      ctx.drawImage(canvas, (canvas.width - targetCanvas.width) / 2, (canvas.height - targetCanvas.height) / 2, targetCanvas.width, targetCanvas.height, 0, 0, targetCanvas.width, targetCanvas.height);
    };

    var render = function render(draw, targetCanvas) {
      // Clear internal canvas
      regl.clear(CLEAR_OPTIONS);
      fbo.use(function () {
        // Clear framebuffer
        regl.clear(CLEAR_OPTIONS);
        draw(targetCanvas.width / canvas.width, targetCanvas.height / canvas.height);
      });
      renderToCanvas();
      copyTo(targetCanvas);
    };
    /**
     * Update Regl's viewport, drawingBufferWidth, and drawingBufferHeight
     *
     * @description Call this method after the viewport has changed, e.g., width
     * or height have been altered
     */


    var refresh = function refresh() {
      regl.poll();
    };

    var drawFns = new Set();

    var onFrame = function onFrame(draw) {
      drawFns.add(draw);
      return function () {
        drawFns["delete"](draw);
      };
    };

    var frame = regl.frame(function () {
      var iterator = drawFns.values();
      var result = iterator.next();

      while (!result.done) {
        result.value(); // The draw function

        result = iterator.next();
      }
    });

    var resize = function resize() {
      canvas.width = window.innerWidth * window.devicePixelRatio;
      canvas.height = window.innerHeight * window.devicePixelRatio;
      fboRes[0] = canvas.width;
      fboRes[1] = canvas.height;
      fbo.resize.apply(fbo, fboRes);
    };

    if (!options.canvas) {
      window.addEventListener('resize', resize);
      window.addEventListener('orientationchange', resize);
      resize();
    }

    var destroy = function destroy() {
      frame.cancel();
      canvas = undefined;
      regl = undefined;
      window.removeEventListener('resize', resize);
      window.removeEventListener('orientationchange', resize);
    };

    return {
      get canvas() {
        return canvas;
      },

      get regl() {
        return regl;
      },

      get gamma() {
        return _gamma;
      },

      set gamma(newGamma) {
        _gamma = +newGamma;
      },

      render: render,
      onFrame: onFrame,
      refresh: refresh,
      destroy: destroy
    };
  };

  var DEFAULT_LASSO_START_INITIATOR_SHOW = true;
  var DEFAULT_LASSO_MIN_DELAY = 8;
  var DEFAULT_LASSO_MIN_DIST = 2;
  var LASSO_SHOW_START_INITIATOR_TIME = 2500;
  var LASSO_HIDE_START_INITIATOR_TIME = 250;

  var ifNotNull = function ifNotNull(v) {
    var alternative = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    return v === null ? alternative : v;
  };

  var lassoStyleEl = document.createElement('style');
  document.head.appendChild(lassoStyleEl);
  var lassoStylesheets = lassoStyleEl.sheet;

  var addRule = function addRule(rule) {
    var currentNumRules = lassoStylesheets.rules.length;
    lassoStylesheets.insertRule(rule, currentNumRules);
    return currentNumRules;
  };

  var removeRule = function removeRule(index) {
    lassoStylesheets.deleteRule(index);
  };

  var inAnimation = "".concat(LASSO_SHOW_START_INITIATOR_TIME, "ms ease scaleInFadeOut 0s 1 normal backwards");

  var createInAnimationRule = function createInAnimationRule(opacity, scale, rotate) {
    return "\n@keyframes scaleInFadeOut {\n  0% {\n    opacity: ".concat(opacity, ";\n    transform: translate(-50%,-50%) scale(").concat(scale, ") rotate(").concat(rotate, "deg);\n  }\n  10% {\n    opacity: 1;\n    transform: translate(-50%,-50%) scale(1) rotate(").concat(rotate + 20, "deg);\n  }\n  100% {\n    opacity: 0;\n    transform: translate(-50%,-50%) scale(0.9) rotate(").concat(rotate + 60, "deg);\n  }\n}\n");
  };

  var inAnimationRuleIndex = null;
  var outAnimation = "".concat(LASSO_HIDE_START_INITIATOR_TIME, "ms ease fadeScaleOut 0s 1 normal backwards");

  var createOutAnimationRule = function createOutAnimationRule(opacity, scale, rotate) {
    return "\n@keyframes fadeScaleOut {\n  0% {\n    opacity: ".concat(opacity, ";\n    transform: translate(-50%,-50%) scale(").concat(scale, ") rotate(").concat(rotate, "deg);\n  }\n  100% {\n    opacity: 0;\n    transform: translate(-50%,-50%) scale(0) rotate(").concat(rotate, "deg);\n  }\n}\n");
  };

  var outAnimationRuleIndex = null;
  var createLasso = function createLasso(element) {
    var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
        _ref$onDraw = _ref.onDraw,
        initialOnDraw = _ref$onDraw === void 0 ? identity : _ref$onDraw,
        _ref$onStart = _ref.onStart,
        initialOnStart = _ref$onStart === void 0 ? identity : _ref$onStart,
        _ref$onEnd = _ref.onEnd,
        initialOnEnd = _ref$onEnd === void 0 ? identity : _ref$onEnd,
        _ref$enableInitiator = _ref.enableInitiator,
        initialenableInitiator = _ref$enableInitiator === void 0 ? DEFAULT_LASSO_START_INITIATOR_SHOW : _ref$enableInitiator,
        _ref$initiatorParentE = _ref.initiatorParentElement,
        initialinitiatorParentElement = _ref$initiatorParentE === void 0 ? document.body : _ref$initiatorParentE;
        _ref.minDelay;
        _ref.minDist;
        var _ref$pointNorm = _ref.pointNorm,
        initialPointNorm = _ref$pointNorm === void 0 ? identity : _ref$pointNorm;

    var enableInitiator = initialenableInitiator;
    var initiatorParentElement = initialinitiatorParentElement;
    var onDraw = initialOnDraw;
    var onStart = initialOnStart;
    var onEnd = initialOnEnd;
    var pointNorm = initialPointNorm;
    var initiator = document.createElement('div');
    var id = Math.random().toString(36).substring(2, 5) + Math.random().toString(36).substring(2, 5);
    initiator.id = "lasso-initiator-".concat(id);
    initiator.style.position = 'fixed';
    initiator.style.display = 'flex';
    initiator.style.justifyContent = 'center';
    initiator.style.alignItems = 'center';
    initiator.style.zIndex = 99;
    initiator.style.width = '4rem';
    initiator.style.height = '4rem';
    initiator.style.borderRadius = '4rem';
    initiator.style.opacity = 0.5;
    initiator.style.transform = 'translate(-50%,-50%) scale(0) rotate(0deg)';
    var isMouseDown = false;
    var isLasso = false;
    var lassoPos = [];
    var lassoPosFlat = [];
    var lassoPrevMousePos;

    var mouseUpHandler = function mouseUpHandler() {
      isMouseDown = false;
    };

    var getMousePosition = function getMousePosition(event) {
      var _element$getBoundingC = element.getBoundingClientRect(),
          left = _element$getBoundingC.left,
          top = _element$getBoundingC.top;

      return [event.clientX - left, event.clientY - top];
    };

    window.addEventListener('mouseup', mouseUpHandler);

    var resetinitiatorStyle = function resetinitiatorStyle() {
      initiator.style.opacity = 0.5;
      initiator.style.transform = 'translate(-50%,-50%) scale(0) rotate(0deg)';
    };

    var getCurrentinitiatorAnimationStyle = function getCurrentinitiatorAnimationStyle() {
      var computedStyle = getComputedStyle(initiator);
      var opacity = +computedStyle.opacity; // The css rule `transform: translate(-1, -1) scale(0.5);` is represented as
      // `matrix(0.5, 0, 0, 0.5, -1, -1)`

      var m = computedStyle.transform.match(/([0-9.-]+)+/g);
      var a = +m[0];
      var b = +m[1];
      var scale = Math.sqrt(a * a + b * b);
      var rotate = Math.atan2(b, a) * (180 / Math.PI);
      return {
        opacity: opacity,
        scale: scale,
        rotate: rotate
      };
    };

    var showInitiator = function showInitiator(event) {
      if (!enableInitiator) return;
      wait(0).then(function () {
        var x = event.clientX;
        var y = event.clientY;
        if (isMouseDown) return;
        var opacity = 0.5;
        var scale = 0;
        var rotate = 0;
        var style = getCurrentinitiatorAnimationStyle();
        opacity = style.opacity;
        scale = style.scale;
        rotate = style.rotate;
        initiator.style.opacity = opacity;
        initiator.style.transform = "translate(-50%,-50%) scale(".concat(scale, ") rotate(").concat(rotate, "deg)");
        initiator.style.animation = 'none'; // See https://developer.mozilla.org/en-US/docs/Web/CSS/CSS_Animations/Tips
        // why we need to wait for two animation frames

        nextAnimationFrame(2).then(function () {
          initiator.style.top = "".concat(y, "px");
          initiator.style.left = "".concat(x, "px");
          if (inAnimationRuleIndex !== null) removeRule(inAnimationRuleIndex);
          inAnimationRuleIndex = addRule(createInAnimationRule(opacity, scale, rotate));
          initiator.style.animation = inAnimation;
          nextAnimationFrame().then(function () {
            resetinitiatorStyle();
          });
        });
      });
    };

    var hideInitiator = function hideInitiator() {
      var _getCurrentinitiatorA = getCurrentinitiatorAnimationStyle(),
          opacity = _getCurrentinitiatorA.opacity,
          scale = _getCurrentinitiatorA.scale,
          rotate = _getCurrentinitiatorA.rotate;

      initiator.style.opacity = opacity;
      initiator.style.transform = "translate(-50%,-50%) scale(".concat(scale, ") rotate(").concat(rotate, "deg)");
      initiator.style.animation = 'none';
      nextAnimationFrame(2).then(function () {
        if (outAnimationRuleIndex !== null) removeRule(outAnimationRuleIndex);
        outAnimationRuleIndex = addRule(createOutAnimationRule(opacity, scale, rotate));
        initiator.style.animation = outAnimation;
        nextAnimationFrame().then(function () {
          resetinitiatorStyle();
        });
      });
    };

    var draw = function draw() {
      onDraw(lassoPos, lassoPosFlat);
    };

    var extend = function extend(currMousePos) {
      if (!lassoPrevMousePos) {
        if (!isLasso) {
          isLasso = true;
          onStart();
        }

        lassoPrevMousePos = currMousePos;
        var point = pointNorm(currMousePos);
        lassoPos = [point];
        lassoPosFlat = [point[0], point[1]];
      } else {
        var d = l2PointDist(currMousePos[0], currMousePos[1], lassoPrevMousePos[0], lassoPrevMousePos[1]);

        if (d > DEFAULT_LASSO_MIN_DIST) {
          lassoPrevMousePos = currMousePos;

          var _point = pointNorm(currMousePos);

          lassoPos.push(_point);
          lassoPosFlat.push(_point[0], _point[1]);

          if (lassoPos.length > 1) {
            draw();
          }
        }
      }
    };

    var extendDb = throttleAndDebounce(extend, DEFAULT_LASSO_MIN_DELAY, DEFAULT_LASSO_MIN_DELAY);

    var extendPublic = function extendPublic(event, debounced) {
      var mousePosition = getMousePosition(event);
      if (debounced) return extendDb(mousePosition);
      return extend(mousePosition);
    };

    var clear = function clear() {
      lassoPos = [];
      lassoPosFlat = [];
      lassoPrevMousePos = undefined;
      draw();
    };

    var initiatorClickHandler = function initiatorClickHandler(event) {
      showInitiator(event);
    };

    var initiatorMouseDownHandler = function initiatorMouseDownHandler() {
      isMouseDown = true;
      isLasso = true;
      clear();
      onStart();
    };

    var initiatorMouseLeaveHandler = function initiatorMouseLeaveHandler() {
      hideInitiator();
    };

    var end = function end() {
      var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref2$merge = _ref2.merge,
          merge = _ref2$merge === void 0 ? false : _ref2$merge;

      isLasso = false;

      var currLassoPos = _toConsumableArray(lassoPos);

      var currLassoPosFlat = _toConsumableArray(lassoPosFlat);

      extendDb.cancel();
      clear(); // When `currLassoPos` is empty the user didn't actually lasso

      if (currLassoPos.length) onEnd(currLassoPos, currLassoPosFlat, {
        merge: merge
      });
      return currLassoPos;
    };

    var set = function set() {
      var _ref3 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref3$onDraw = _ref3.onDraw,
          newOnDraw = _ref3$onDraw === void 0 ? null : _ref3$onDraw,
          _ref3$onStart = _ref3.onStart,
          newOnStart = _ref3$onStart === void 0 ? null : _ref3$onStart,
          _ref3$onEnd = _ref3.onEnd,
          newOnEnd = _ref3$onEnd === void 0 ? null : _ref3$onEnd,
          _ref3$enableInitiator = _ref3.enableInitiator,
          newEnableInitiator = _ref3$enableInitiator === void 0 ? null : _ref3$enableInitiator,
          _ref3$initiatorParent = _ref3.initiatorParentElement,
          newInitiatorParentElement = _ref3$initiatorParent === void 0 ? null : _ref3$initiatorParent;
          _ref3.minDelay;
          _ref3.minDist;
          var _ref3$pointNorm = _ref3.pointNorm,
          newPointNorm = _ref3$pointNorm === void 0 ? null : _ref3$pointNorm;

      onDraw = ifNotNull(newOnDraw, onDraw);
      onStart = ifNotNull(newOnStart, onStart);
      onEnd = ifNotNull(newOnEnd, onEnd);
      enableInitiator = ifNotNull(newEnableInitiator, enableInitiator);
      pointNorm = ifNotNull(newPointNorm, pointNorm);

      if (newInitiatorParentElement !== null && newInitiatorParentElement !== initiatorParentElement) {
        initiatorParentElement.removeChild(initiator);
        newInitiatorParentElement.appendChild(initiator);
        initiatorParentElement = newInitiatorParentElement;
      }

      if (enableInitiator) {
        initiator.addEventListener('click', initiatorClickHandler);
        initiator.addEventListener('mousedown', initiatorMouseDownHandler);
        initiator.addEventListener('mouseleave', initiatorMouseLeaveHandler);
      } else {
        initiator.removeEventListener('mousedown', initiatorMouseDownHandler);
        initiator.removeEventListener('mouseleave', initiatorMouseLeaveHandler);
      }
    };

    var destroy = function destroy() {
      initiatorParentElement.removeChild(initiator);
      window.removeEventListener('mouseup', mouseUpHandler);
      initiator.removeEventListener('click', initiatorClickHandler);
      initiator.removeEventListener('mousedown', initiatorMouseDownHandler);
      initiator.removeEventListener('mouseleave', initiatorMouseLeaveHandler);
    };

    var withPublicMethods = function withPublicMethods() {
      return function (self) {
        return assign(self, {
          clear: clear,
          destroy: destroy,
          end: end,
          extend: extendPublic,
          set: set,
          showInitiator: showInitiator,
          hideInitiator: hideInitiator
        });
      };
    };

    initiatorParentElement.appendChild(initiator);
    set({
      onDraw: onDraw,
      onStart: onStart,
      onEnd: onEnd,
      enableInitiator: enableInitiator,
      initiatorParentElement: initiatorParentElement
    });
    return pipe(withStaticProperty('initiator', initiator), withPublicMethods(), withConstructor(createLasso))({});
  };

  const FRAGMENT_SHADER$2 = `
precision mediump float;

uniform sampler2D texture;

varying vec2 uv;

void main () {
  gl_FragColor = texture2D(texture, uv);
}
`;

  const VERTEX_SHADER = `
precision mediump float;

uniform mat4 modelViewProjection;

attribute vec2 position;

varying vec2 uv;

void main () {
  uv = position;
  gl_Position = modelViewProjection * vec4(-1.0 + 2.0 * uv.x, 1.0 - 2.0 * uv.y, 0, 1);
}
`;

  const FRAGMENT_SHADER$1 = `
precision highp float;

varying vec4 color;
varying float finalPointSize;

float linearstep(float edge0, float edge1, float x) {
  return clamp((x - edge0) / (edge1 - edge0), 0.0, 1.0);
}

void main() {
  vec2 c = gl_PointCoord * 2.0 - 1.0;
  float sdf = length(c) * finalPointSize;
  float alpha = linearstep(finalPointSize + 0.5, finalPointSize - 0.5, sdf);

  gl_FragColor = vec4(color.rgb, alpha * color.a);
}
`;

  const FRAGMENT_SHADER = `precision highp float;

varying vec4 color;

void main() {
  gl_FragColor = color;
}
`;

  const createVertexShader = (globalState) => `
precision highp float;

uniform sampler2D colorTex;
uniform float colorTexRes;
uniform float colorTexEps;
uniform sampler2D stateTex;
uniform float stateTexRes;
uniform float stateTexEps;
uniform float devicePixelRatio;
uniform sampler2D encodingTex;
uniform float encodingTexRes;
uniform float encodingTexEps;
uniform float pointSizeExtra;
uniform float numPoints;
uniform float globalState;
uniform float isColoredByZ;
uniform float isColoredByW;
uniform float isOpacityByZ;
uniform float isOpacityByW;
uniform float isOpacityByDensity;
uniform float isSizedByZ;
uniform float isSizedByW;
uniform float colorMultiplicator;
uniform float opacityMultiplicator;
uniform float opacityDensity;
uniform float sizeMultiplicator;
uniform float numColorStates;
uniform float pointScale;
uniform mat4 modelViewProjection;

attribute vec2 stateIndex;

varying vec4 color;
varying float finalPointSize;

void main() {
  vec4 state = texture2D(stateTex, stateIndex);

  gl_Position = modelViewProjection * vec4(state.x, state.y, 0.0, 1.0);

  // Determine color index
  float colorIndexZ =  isColoredByZ * floor(state.z * colorMultiplicator);
  float colorIndexW =  isColoredByW * floor(state.w * colorMultiplicator);

  // Multiply by the number of color states per color
  // I.e., normal, active, hover, background, etc.
  float colorIndex = (colorIndexZ + colorIndexW) * numColorStates;

  // Half a "pixel" or "texel" in texture coordinates
  float colorLinearIndex = colorIndex + globalState;

  // Need to add cEps here to avoid floating point issue that can lead to
  // dramatic changes in which color is loaded as floor(3/2.9999) = 1 but
  // floor(3/3.0001) = 0!
  float colorRowIndex = floor((colorLinearIndex + colorTexEps) / colorTexRes);

  vec2 colorTexIndex = vec2(
    (colorLinearIndex / colorTexRes) - colorRowIndex + colorTexEps,
    colorRowIndex / colorTexRes + colorTexEps
  );

  color = texture2D(colorTex, colorTexIndex);

  // Retrieve point size
  float pointSizeIndexZ = isSizedByZ * floor(state.z * sizeMultiplicator);
  float pointSizeIndexW = isSizedByW * floor(state.w * sizeMultiplicator);
  float pointSizeIndex = pointSizeIndexZ + pointSizeIndexW;

  float pointSizeRowIndex = floor((pointSizeIndex + encodingTexEps) / encodingTexRes);
  vec2 pointSizeTexIndex = vec2(
    (pointSizeIndex / encodingTexRes) - pointSizeRowIndex + encodingTexEps,
    pointSizeRowIndex / encodingTexRes + encodingTexEps
  );
  float pointSize = texture2D(encodingTex, pointSizeTexIndex).x;

  // Retrieve opacity
  ${
    (() => {
      // Drawing the inner border of selected points
      if (globalState === 3) return '';

      // Draw points with opacity encoding or dynamic opacity
      return `
        if (isOpacityByDensity < 0.5) {
          float opacityIndexZ = isOpacityByZ * floor(state.z * opacityMultiplicator);
          float opacityIndexW = isOpacityByW * floor(state.w * opacityMultiplicator);
          float opacityIndex = opacityIndexZ + opacityIndexW;

          float opacityRowIndex = floor((opacityIndex + encodingTexEps) / encodingTexRes);
          vec2 opacityTexIndex = vec2(
            (opacityIndex / encodingTexRes) - opacityRowIndex + encodingTexEps,
            opacityRowIndex / encodingTexRes + encodingTexEps
          );
          color.a = texture2D(encodingTex, opacityTexIndex)[${1 + globalState}];
        } else {
          color.a = min(1.0, opacityDensity + globalState);
        }
      `;
    })()
  }

  finalPointSize = (pointSize * pointScale) + pointSizeExtra;
  gl_PointSize = finalPointSize;
}
`;

  const SHADER$1 = `precision highp float;

uniform sampler2D startStateTex;
uniform sampler2D endStateTex;
uniform float t;

varying vec2 particleTextureIndex;

void main() {
  // Interpolate x, y, and value
  vec3 start = texture2D(startStateTex, particleTextureIndex).xyw;
  vec3 end = texture2D(endStateTex, particleTextureIndex).xyw;
  vec3 curr = start * (1.0 - t) + end * t;

  // The category cannot be interpolated
  float endCategory = texture2D(endStateTex, particleTextureIndex).z;

  gl_FragColor = vec4(curr.xy, endCategory, curr.z);
}`;

  const SHADER = `precision highp float;

attribute vec2 position;
varying vec2 particleTextureIndex;

void main() {
  // map normalized device coords to texture coords
  particleTextureIndex = 0.5 * (1.0 + position);

  gl_Position = vec4(position, 0, 1);
}`;

  /* eslint-env worker */

  /* eslint no-restricted-globals: 1 */
  var worker = function worker() {
    /**
     * Catmull-Rom interpolation
     * @param {number} t - Progress value
     * @param {array} p0 - First point
     * @param {array} p1 - Second point
     * @param {array} p2 - Third point
     * @param {array} p3 - Forth point
     * @return {number} Interpolated value
     */

    var catmullRom = function catmullRom(t, p0, p1, p2, p3) {
      var v0 = (p2 - p0) * 0.5;
      var v1 = (p3 - p1) * 0.5;
      return (2 * p1 - 2 * p2 + v0 + v1) * t * t * t + (-3 * p1 + 3 * p2 - 2 * v0 - v1) * t * t + v0 * t + p1;
    };
    /**
     * Interpolate a point with Catmull-Rom
     * @param {number} t - Progress value
     * @param {array} points - Key points
     * @param {number}  maxPointIdx - Highest point index. Same as array.length - 1
     * @return {array} Interpolated point
     */


    var interpolatePoint = function interpolatePoint(t, points, maxPointIdx) {
      var p = maxPointIdx * t;
      var intPoint = Math.floor(p);
      var weight = p - intPoint;
      var p0 = points[Math.max(0, intPoint - 1)];
      var p1 = points[intPoint];
      var p2 = points[Math.min(maxPointIdx, intPoint + 1)];
      var p3 = points[Math.min(maxPointIdx, intPoint + 2)];
      return [catmullRom(weight, p0[0], p1[0], p2[0], p3[0]), catmullRom(weight, p0[1], p1[1], p2[1], p3[1])];
    };
    /**
     * Square distance
     * @param {number} x1 - First x coordinate
     * @param {number} y1 - First y coordinate
     * @param {number} x2 - Second x coordinate
     * @param {number} y2 - Second y coordinate
     * @return {number} Distance
     */


    var sqDist = function sqDist(x1, y1, x2, y2) {
      return Math.pow(x1 - x2, 2) + Math.pow(y1 - y2, 2);
    };
    /**
     * Douglas Peucker square segment distance
     * Implementation from https://github.com/mourner/simplify-js
     * @author Vladimir Agafonkin
     * @copyright Vladimir Agafonkin 2013
     * @license BSD
     * @param {array} p - Point
     * @param {array} p1 - First boundary point
     * @param {array} p2 - Second boundary point
     * @return {number} Distance
     */


    var sqSegDist = function sqSegDist(p, p1, p2) {
      var x = p1[0];
      var y = p1[1];
      var dx = p2[0] - x;
      var dy = p2[1] - y;

      if (dx !== 0 || dy !== 0) {
        var t = ((p[0] - x) * dx + (p[1] - y) * dy) / (dx * dx + dy * dy);

        if (t > 1) {
          x = p2[0];
          y = p2[1];
        } else if (t > 0) {
          x += dx * t;
          y += dy * t;
        }
      }

      dx = p[0] - x;
      dy = p[1] - y;
      return dx * dx + dy * dy;
    };
    /**
     * Douglas Peucker step function
     * Implementation from https://github.com/mourner/simplify-js
     * @author Vladimir Agafonkin
     * @copyright Vladimir Agafonkin 2013
     * @license BSD
     * @param   {[type]}  points  [description]
     * @param   {[type]}  first  [description]
     * @param   {[type]}  last  [description]
     * @param   {[type]}  tolerance  [description]
     * @param   {[type]}  simplified  [description]
     * @return  {[type]}  [description]
     */


    var simplifyDPStep = function simplifyDPStep(points, first, last, tolerance, simplified) {
      var maxDist = tolerance;
      var index;

      for (var i = first + 1; i < last; i++) {
        var dist = sqSegDist(points[i], points[first], points[last]);

        if (dist > maxDist) {
          index = i;
          maxDist = dist;
        }
      }

      if (maxDist > tolerance) {
        if (index - first > 1) simplifyDPStep(points, first, index, tolerance, simplified);
        simplified.push(points[index]);
        if (last - index > 1) simplifyDPStep(points, index, last, tolerance, simplified);
      }
    };
    /**
     * Douglas Peucker. Implementation from https://github.com/mourner/simplify-js
     * @author Vladimir Agafonkin
     * @copyright Vladimir Agafonkin 2013
     * @license BSD
     * @param {array} points - List of points to be simplified
     * @param {number} tolerance - Tolerance level. Points below this distance level will be ignored
     * @return {array} Simplified point list
     */


    var simplifyDouglasPeucker = function simplifyDouglasPeucker(points, tolerance) {
      var last = points.length - 1;
      var simplified = [points[0]];
      simplifyDPStep(points, 0, last, tolerance, simplified);
      simplified.push(points[last]);
      return simplified;
    };
    /**
     * Interpolate intermediate points between key points
     * @param {array} points - Fixed key points
     * @param {number} options.maxIntPointsPerSegment - Maximum number of points between two key points
     * @param {number} options.tolerance - Simplification tolerance
     * @return {array} Interpolated points including key points
     */


    var interpolatePoints = function interpolatePoints(points) {
      var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          _ref$maxIntPointsPerS = _ref.maxIntPointsPerSegment,
          maxIntPointsPerSegment = _ref$maxIntPointsPerS === void 0 ? 100 : _ref$maxIntPointsPerS,
          _ref$tolerance = _ref.tolerance,
          tolerance = _ref$tolerance === void 0 ? 0.002 : _ref$tolerance;

      var numPoints = points.length;
      var maxPointIdx = numPoints - 1;
      var maxOutPoints = maxPointIdx * maxIntPointsPerSegment + 1;
      var sqTolerance = Math.pow(tolerance, 2);
      var outPoints = [];
      var prevPoint; // Generate interpolated points where the squared-distance between points
      // is larger than sqTolerance

      for (var i = 0; i < numPoints - 1; i++) {
        var segmentPoints = [points[i].slice(0, 2)];
        prevPoint = points[i];

        for (var j = 1; j < maxIntPointsPerSegment; j++) {
          var t = (i * maxIntPointsPerSegment + j) / maxOutPoints;
          var intPoint = interpolatePoint(t, points, maxPointIdx); // Check squared distance simplification

          if (sqDist(prevPoint[0], prevPoint[1], intPoint[0], intPoint[1]) > sqTolerance) {
            segmentPoints.push(intPoint);
            prevPoint = intPoint;
          }
        } // Add next key point. Needed for the simplification algorithm


        segmentPoints.push(points[i + 1]); // Simplify interpolated points using the douglas-peuckner algorithm

        segmentPoints = simplifyDouglasPeucker(segmentPoints, sqTolerance); // Add simplified points without the last key point, which is added
        // anyway in the next segment

        outPoints = outPoints.concat(segmentPoints.slice(0, segmentPoints.length - 1));
      }

      outPoints.push(points[points.length - 1].slice(0, 2));
      return outPoints.flat();
    };
    /**
     * Group points by line assignment (the fifth component of a point)
     * @param {array} points - Flat list of points
     * @return {array} List of lists of ordered points by line
     */


    var groupPoints = function groupPoints(points) {
      var groupedPoints = {};
      var isOrdered = !Number.isNaN(+points[0][5]);
      points.forEach(function (point) {
        var segId = point[4];
        if (!groupedPoints[segId]) groupedPoints[segId] = [];
        if (isOrdered) groupedPoints[segId][point[5]] = point;else groupedPoints[segId].push(point);
      }); // The filtering ensures that non-existing array entries are removed

      Object.entries(groupedPoints).forEach(function (idPoints) {
        groupedPoints[idPoints[0]] = idPoints[1].filter(function (v) {
          return v;
        }); // Store the first point as the reference

        groupedPoints[idPoints[0]].reference = idPoints[1][0];
      });
      return groupedPoints;
    };

    self.onmessage = function onmessage(event) {
      var numPoints = event.data.points ? +event.data.points.length : 0;
      if (!numPoints) self.postMessage({
        error: new Error('No points provided')
      });
      event.data.points;
      var groupedPoints = groupPoints(event.data.points);
      self.postMessage({
        points: Object.entries(groupedPoints).reduce(function (curvePoints, idAndPoints) {
          curvePoints[idAndPoints[0]] = interpolatePoints(idAndPoints[1], event.data.options); // Make sure the reference is passed on

          curvePoints[idAndPoints[0]].reference = idAndPoints[1].reference;
          return curvePoints;
        }, {})
      });
    };
  };

  var createSplineCurve = function createSplineCurve(points) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
      tolerance: 0.002,
      maxIntPointsPerSegment: 100
    };
    return new Promise(function (resolve, reject) {
      var worker$1 = createWorker(worker);

      worker$1.onmessage = function (e) {
        if (e.data.error) reject(e.data.error);else resolve(e.data.points);
        worker$1.terminate();
      };

      worker$1.postMessage({
        points: points,
        options: options
      });
    });
  };

  var version = "1.2.2";

  var deprecations = {
    showRecticle: 'showReticle',
    recticleColor: 'reticleColor'
  };

  var checkDeprecations = function checkDeprecations(properties) {
    Object.keys(properties).filter(function (prop) {
      return deprecations[prop];
    }).forEach(function (name) {
      console.warn("regl-scatterplot: the \"".concat(name, "\" property is deprecated. Please use \"").concat(deprecations[name], "\" instead."));
      properties[deprecations[name]] = properties[name];
      delete properties[name];
    });
  };

  var getEncodingType = function getEncodingType(type, defaultValue) {
    var _ref = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {},
        _ref$allowSegment = _ref.allowSegment,
        allowSegment = _ref$allowSegment === void 0 ? false : _ref$allowSegment,
        _ref$allowDensity = _ref.allowDensity,
        allowDensity = _ref$allowDensity === void 0 ? false : _ref$allowDensity;

    // Z refers to the 3rd component of the RGBA value
    if (Z_NAMES.has(type)) return 'valueZ'; // W refers to the 4th component of the RGBA value

    if (W_NAMES.has(type)) return 'valueW';
    if (type === 'segment') return allowSegment ? 'segment' : defaultValue;
    if (type === 'density') return allowDensity ? 'density' : defaultValue;
    return defaultValue;
  };

  var getEncodingIdx = function getEncodingIdx(type) {
    switch (type) {
      case 'valueZ':
        return 2;

      case 'valueW':
        return 3;

      default:
        return null;
    }
  };

  var createScatterplot = function createScatterplot() {
    var initialProperties = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    /** @type {import('./types').PubSub} */
    var pubSub = createPubSub__default['default']({
      async: !initialProperties.syncEvents,
      caseInsensitive: true
    });
    var scratch = new Float32Array(16);
    var pvm = new Float32Array(16);
    var mousePosition = [0, 0];
    checkDeprecations(initialProperties);
    var renderer = initialProperties.renderer,
        _initialProperties$ba = initialProperties.backgroundColor,
        backgroundColor = _initialProperties$ba === void 0 ? DEFAULT_COLOR_BG : _initialProperties$ba,
        _initialProperties$ba2 = initialProperties.backgroundImage,
        backgroundImage = _initialProperties$ba2 === void 0 ? DEFAULT_BACKGROUND_IMAGE : _initialProperties$ba2,
        _initialProperties$ca = initialProperties.canvas,
        canvas = _initialProperties$ca === void 0 ? document.createElement('canvas') : _initialProperties$ca,
        _initialProperties$co = initialProperties.colorBy,
        colorBy = _initialProperties$co === void 0 ? DEFAULT_COLOR_BY : _initialProperties$co,
        _initialProperties$de = initialProperties.deselectOnDblClick,
        deselectOnDblClick = _initialProperties$de === void 0 ? DEFAULT_DESELECT_ON_DBL_CLICK : _initialProperties$de,
        _initialProperties$de2 = initialProperties.deselectOnEscape,
        deselectOnEscape = _initialProperties$de2 === void 0 ? DEFAULT_DESELECT_ON_ESCAPE : _initialProperties$de2,
        _initialProperties$la = initialProperties.lassoColor,
        lassoColor = _initialProperties$la === void 0 ? DEFAULT_LASSO_COLOR : _initialProperties$la,
        _initialProperties$la2 = initialProperties.lassoLineWidth,
        lassoLineWidth = _initialProperties$la2 === void 0 ? DEFAULT_LASSO_LINE_WIDTH : _initialProperties$la2,
        _initialProperties$la3 = initialProperties.lassoMinDelay,
        lassoMinDelay = _initialProperties$la3 === void 0 ? DEFAULT_LASSO_MIN_DELAY$1 : _initialProperties$la3,
        _initialProperties$la4 = initialProperties.lassoMinDist,
        lassoMinDist = _initialProperties$la4 === void 0 ? DEFAULT_LASSO_MIN_DIST$1 : _initialProperties$la4,
        _initialProperties$la5 = initialProperties.lassoClearEvent,
        lassoClearEvent = _initialProperties$la5 === void 0 ? DEFAULT_LASSO_CLEAR_EVENT : _initialProperties$la5,
        _initialProperties$la6 = initialProperties.lassoInitiator,
        lassoInitiator = _initialProperties$la6 === void 0 ? DEFAULT_LASSO_INITIATOR : _initialProperties$la6,
        _initialProperties$la7 = initialProperties.lassoInitiatorParentElement,
        lassoInitiatorParentElement = _initialProperties$la7 === void 0 ? document.body : _initialProperties$la7,
        _initialProperties$ke = initialProperties.keyMap,
        keyMap = _initialProperties$ke === void 0 ? DEFAULT_KEY_MAP : _initialProperties$ke,
        _initialProperties$mo = initialProperties.mouseMode,
        mouseMode = _initialProperties$mo === void 0 ? DEFAULT_MOUSE_MODE : _initialProperties$mo,
        _initialProperties$sh = initialProperties.showReticle,
        showReticle = _initialProperties$sh === void 0 ? DEFAULT_SHOW_RETICLE : _initialProperties$sh,
        _initialProperties$re = initialProperties.reticleColor,
        reticleColor = _initialProperties$re === void 0 ? DEFAULT_RETICLE_COLOR : _initialProperties$re,
        _initialProperties$po = initialProperties.pointColor,
        pointColor = _initialProperties$po === void 0 ? DEFAULT_COLOR_NORMAL : _initialProperties$po,
        _initialProperties$po2 = initialProperties.pointColorActive,
        pointColorActive = _initialProperties$po2 === void 0 ? DEFAULT_COLOR_ACTIVE : _initialProperties$po2,
        _initialProperties$po3 = initialProperties.pointColorHover,
        pointColorHover = _initialProperties$po3 === void 0 ? DEFAULT_COLOR_HOVER : _initialProperties$po3,
        _initialProperties$sh2 = initialProperties.showPointConnections,
        showPointConnections = _initialProperties$sh2 === void 0 ? DEFAULT_SHOW_POINT_CONNECTIONS : _initialProperties$sh2,
        _initialProperties$po4 = initialProperties.pointConnectionColor,
        pointConnectionColor = _initialProperties$po4 === void 0 ? DEFAULT_POINT_CONNECTION_COLOR_NORMAL : _initialProperties$po4,
        _initialProperties$po5 = initialProperties.pointConnectionColorActive,
        pointConnectionColorActive = _initialProperties$po5 === void 0 ? DEFAULT_POINT_CONNECTION_COLOR_ACTIVE : _initialProperties$po5,
        _initialProperties$po6 = initialProperties.pointConnectionColorHover,
        pointConnectionColorHover = _initialProperties$po6 === void 0 ? DEFAULT_POINT_CONNECTION_COLOR_HOVER : _initialProperties$po6,
        _initialProperties$po7 = initialProperties.pointConnectionColorBy,
        pointConnectionColorBy = _initialProperties$po7 === void 0 ? DEFAULT_POINT_CONNECTION_COLOR_BY : _initialProperties$po7,
        _initialProperties$po8 = initialProperties.pointConnectionOpacity,
        pointConnectionOpacity = _initialProperties$po8 === void 0 ? DEFAULT_POINT_CONNECTION_OPACITY : _initialProperties$po8,
        _initialProperties$po9 = initialProperties.pointConnectionOpacityBy,
        pointConnectionOpacityBy = _initialProperties$po9 === void 0 ? DEFAULT_POINT_CONNECTION_OPACITY_BY : _initialProperties$po9,
        _initialProperties$po10 = initialProperties.pointConnectionOpacityActive,
        pointConnectionOpacityActive = _initialProperties$po10 === void 0 ? DEFAULT_POINT_CONNECTION_OPACITY_ACTIVE : _initialProperties$po10,
        _initialProperties$po11 = initialProperties.pointConnectionSize,
        pointConnectionSize = _initialProperties$po11 === void 0 ? DEFAULT_POINT_CONNECTION_SIZE : _initialProperties$po11,
        _initialProperties$po12 = initialProperties.pointConnectionSizeActive,
        pointConnectionSizeActive = _initialProperties$po12 === void 0 ? DEFAULT_POINT_CONNECTION_SIZE_ACTIVE : _initialProperties$po12,
        _initialProperties$po13 = initialProperties.pointConnectionSizeBy,
        pointConnectionSizeBy = _initialProperties$po13 === void 0 ? DEFAULT_POINT_CONNECTION_SIZE_BY : _initialProperties$po13,
        _initialProperties$po14 = initialProperties.pointConnectionMaxIntPointsPerSegment,
        pointConnectionMaxIntPointsPerSegment = _initialProperties$po14 === void 0 ? DEFAULT_POINT_CONNECTION_MAX_INT_POINTS_PER_SEGMENT : _initialProperties$po14,
        _initialProperties$po15 = initialProperties.pointConnectionTolerance,
        pointConnectionTolerance = _initialProperties$po15 === void 0 ? DEFAULT_POINT_CONNECTION_INT_POINTS_TOLERANCE : _initialProperties$po15,
        _initialProperties$po16 = initialProperties.pointSize,
        pointSize = _initialProperties$po16 === void 0 ? DEFAULT_POINT_SIZE : _initialProperties$po16,
        _initialProperties$po17 = initialProperties.pointSizeSelected,
        pointSizeSelected = _initialProperties$po17 === void 0 ? DEFAULT_POINT_SIZE_SELECTED : _initialProperties$po17,
        _initialProperties$po18 = initialProperties.pointSizeMouseDetection,
        pointSizeMouseDetection = _initialProperties$po18 === void 0 ? DEFAULT_POINT_SIZE_MOUSE_DETECTION : _initialProperties$po18,
        _initialProperties$po19 = initialProperties.pointOutlineWidth,
        pointOutlineWidth = _initialProperties$po19 === void 0 ? DEFAULT_POINT_OUTLINE_WIDTH : _initialProperties$po19,
        _initialProperties$op = initialProperties.opacity,
        opacity = _initialProperties$op === void 0 ? AUTO : _initialProperties$op,
        _initialProperties$op2 = initialProperties.opacityBy,
        opacityBy = _initialProperties$op2 === void 0 ? DEFAULT_OPACITY_BY : _initialProperties$op2,
        _initialProperties$op3 = initialProperties.opacityByDensityFill,
        opacityByDensityFill = _initialProperties$op3 === void 0 ? DEFAULT_OPACITY_BY_DENSITY_FILL : _initialProperties$op3,
        _initialProperties$si = initialProperties.sizeBy,
        sizeBy = _initialProperties$si === void 0 ? DEFAULT_SIZE_BY : _initialProperties$si,
        _initialProperties$he = initialProperties.height,
        height = _initialProperties$he === void 0 ? DEFAULT_HEIGHT : _initialProperties$he,
        _initialProperties$wi = initialProperties.width,
        width = _initialProperties$wi === void 0 ? DEFAULT_WIDTH : _initialProperties$wi;
    var currentWidth = width === AUTO ? 1 : width;
    var currentHeight = height === AUTO ? 1 : height; // The following properties cannot be changed after the initialization

    var _initialProperties$pe = initialProperties.performanceMode,
        performanceMode = _initialProperties$pe === void 0 ? DEFAULT_PERFORMANCE_MODE : _initialProperties$pe,
        _initialProperties$op4 = initialProperties.opacityByDensityDebounceTime,
        opacityByDensityDebounceTime = _initialProperties$op4 === void 0 ? DEFAULT_OPACITY_BY_DENSITY_DEBOUNCE_TIME : _initialProperties$op4; // Same as renderer ||= createRenderer({ ... }) but avoids having to rely on
    // https://babeljs.io/docs/en/babel-plugin-proposal-logical-assignment-operators
    // eslint-disable-next-line no-unused-expressions

    renderer || (renderer = createRenderer({
      regl: initialProperties.regl,
      gamma: initialProperties.gamma
    }));
    backgroundColor = toRgba(backgroundColor, true);
    lassoColor = toRgba(lassoColor, true);
    reticleColor = toRgba(reticleColor, true);
    var backgroundColorBrightness = rgbBrightness(backgroundColor);
    var camera;
    var lasso;
    var mouseDown = false;
    var selection = [];
    var selectionSet = new Set();
    var selectionConnecionSet = new Set();
    var mouseDownTime = null;
    var mouseDownPosition = [0, 0];
    var numPoints = 0;
    var numPointsInView = 0;
    var lassoActive = false;
    var lassoPointsCurr = [];
    var searchIndex;
    var viewAspectRatio;
    var dataAspectRatio = DEFAULT_DATA_ASPECT_RATIO;
    var projectionLocal;
    var projection;
    var model;
    var pointConnections;
    var pointConnectionMap;
    var computingPointConnectionCurves;
    var reticleHLine;
    var reticleVLine;
    var computedPointSizeMouseDetection;
    var keyActionMap = flipObj(keyMap);
    var lassoInitiatorTimeout;
    var topRightNdc;
    var bottomLeftNdc;
    var preventEventView = false;
    var draw = true;
    var drawReticleOnce = false;
    var canvasObserver;
    pointColor = isMultipleColors(pointColor) ? _toConsumableArray(pointColor) : [pointColor];
    pointColorActive = isMultipleColors(pointColorActive) ? _toConsumableArray(pointColorActive) : [pointColorActive];
    pointColorHover = isMultipleColors(pointColorHover) ? _toConsumableArray(pointColorHover) : [pointColorHover];
    pointColor = pointColor.map(function (color) {
      return toRgba(color, true);
    });
    pointColorActive = pointColorActive.map(function (color) {
      return toRgba(color, true);
    });
    pointColorHover = pointColorHover.map(function (color) {
      return toRgba(color, true);
    });
    opacity = !Array.isArray(opacity) && Number.isNaN(+opacity) ? pointColor[0][3] : opacity;
    opacity = isConditionalArray(opacity, isPositiveNumber, {
      minLength: 1
    }) ? _toConsumableArray(opacity) : [opacity];
    pointSize = isConditionalArray(pointSize, isPositiveNumber, {
      minLength: 1
    }) ? _toConsumableArray(pointSize) : [pointSize];
    var minPointScale = MIN_POINT_SIZE / pointSize[0];

    if (pointConnectionColor === 'inherit') {
      pointConnectionColor = _toConsumableArray(pointColor);
    } else {
      pointConnectionColor = isMultipleColors(pointConnectionColor) ? _toConsumableArray(pointConnectionColor) : [pointConnectionColor];
      pointConnectionColor = pointConnectionColor.map(function (color) {
        return toRgba(color, true);
      });
    }

    if (pointConnectionColorActive === 'inherit') {
      pointConnectionColorActive = _toConsumableArray(pointColorActive);
    } else {
      pointConnectionColorActive = isMultipleColors(pointConnectionColorActive) ? _toConsumableArray(pointConnectionColorActive) : [pointConnectionColorActive];
      pointConnectionColorActive = pointConnectionColorActive.map(function (color) {
        return toRgba(color, true);
      });
    }

    if (pointConnectionColorHover === 'inherit') {
      pointConnectionColorHover = _toConsumableArray(pointColorHover);
    } else {
      pointConnectionColorHover = isMultipleColors(pointConnectionColorHover) ? _toConsumableArray(pointConnectionColorHover) : [pointConnectionColorHover];
      pointConnectionColorHover = pointConnectionColorHover.map(function (color) {
        return toRgba(color, true);
      });
    }

    if (pointConnectionOpacity === 'inherit') {
      pointConnectionOpacity = _toConsumableArray(opacity);
    } else {
      pointConnectionOpacity = isConditionalArray(pointConnectionOpacity, isPositiveNumber, {
        minLength: 1
      }) ? _toConsumableArray(pointConnectionOpacity) : [pointConnectionOpacity];
    }

    if (pointConnectionSize === 'inherit') {
      pointConnectionSize = _toConsumableArray(pointSize);
    } else {
      pointConnectionSize = isConditionalArray(pointConnectionSize, isPositiveNumber, {
        minLength: 1
      }) ? _toConsumableArray(pointConnectionSize) : [pointConnectionSize];
    }

    colorBy = getEncodingType(colorBy, DEFAULT_COLOR_BY);
    opacityBy = getEncodingType(opacityBy, DEFAULT_OPACITY_BY, {
      allowDensity: true
    });
    sizeBy = getEncodingType(sizeBy, DEFAULT_SIZE_BY);
    pointConnectionColorBy = getEncodingType(pointConnectionColorBy, DEFAULT_POINT_CONNECTION_COLOR_BY, {
      allowSegment: true
    });
    pointConnectionOpacityBy = getEncodingType(pointConnectionOpacityBy, DEFAULT_POINT_CONNECTION_OPACITY_BY, {
      allowSegment: true
    });
    pointConnectionSizeBy = getEncodingType(pointConnectionSizeBy, DEFAULT_POINT_CONNECTION_SIZE_BY, {
      allowSegment: true
    });
    var stateTex; // Stores the point texture holding x, y, category, and value

    var prevStateTex; // Stores the previous point texture. Used for transitions

    var tmpStateTex; // Stores a temporary point texture. Used for transitions

    var tmpStateBuffer; // Temporary frame buffer

    var stateTexRes = 0; // Width and height of the texture

    var stateTexEps = 0; // Half a texel

    var normalPointsIndexBuffer; // Buffer holding the indices pointing to the correct texel

    var selectedPointsIndexBuffer; // Used for pointing to the selected texels

    var hoveredPointIndexBuffer; // Used for pointing to the hovered texels

    var isTransitioning = false;
    var transitionStartTime = null;
    var transitionDuration;
    var transitionEasing;
    var preTransitionShowReticle = showReticle;
    var colorTex; // Stores the point color texture

    var colorTexRes = 0; // Width and height of the texture

    var encodingTex; // Stores the point sizes and opacity values

    var encodingTexRes = 0; // Width and height of the texture

    var isViewChanged = false;
    var isInit = false;
    var maxValueZ = 0;
    var maxValueW = 0;
    var hoveredPoint;
    var isMouseInCanvas = false;
    var xScale = initialProperties.xScale || null;
    var yScale = initialProperties.yScale || null;
    var xDomainStart = 0;
    var xDomainSize = 0;
    var yDomainStart = 0;
    var yDomainSize = 0;

    if (xScale) {
      xDomainStart = xScale.domain()[0];
      xDomainSize = xScale.domain()[1] - xScale.domain()[0];
      xScale.range([0, currentWidth]);
    }

    if (yScale) {
      yDomainStart = yScale.domain()[0];
      yDomainSize = yScale.domain()[1] - yScale.domain()[0];
      yScale.range([currentHeight, 0]);
    }

    var getNdcX = function getNdcX(x) {
      return -1 + x / currentWidth * 2;
    };

    var getNdcY = function getNdcY(y) {
      return 1 + y / currentHeight * -2;
    }; // Get relative WebGL position


    var getMouseGlPos = function getMouseGlPos() {
      return [getNdcX(mousePosition[0]), getNdcY(mousePosition[1])];
    };

    var getScatterGlPos = function getScatterGlPos(xGl, yGl) {
      // Homogeneous vector
      var v = [xGl, yGl, 1, 1]; // projection^-1 * view^-1 * model^-1 is the same as
      // model * view^-1 * projection

      var mvp = invert(scratch, multiply(scratch, projectionLocal, multiply(scratch, camera.view, model))); // Translate vector

      transformMat4(v, v, mvp);
      return v.slice(0, 2);
    };

    var raycast = function raycast() {
      var _getMouseGlPos = getMouseGlPos(),
          _getMouseGlPos2 = _slicedToArray(_getMouseGlPos, 2),
          xGl = _getMouseGlPos2[0],
          yGl = _getMouseGlPos2[1];

      var _getScatterGlPos = getScatterGlPos(xGl, yGl),
          _getScatterGlPos2 = _slicedToArray(_getScatterGlPos, 2),
          xNdc = _getScatterGlPos2[0],
          yNdc = _getScatterGlPos2[1]; // eslint-disable-next-line no-use-before-define


      var pointScale = getPointScale(); // The height of the view in normalized device coordinates

      var heightNdc = topRightNdc[1] - bottomLeftNdc[1]; // The size of a pixel in the current view in normalized device coordinates

      var pxNdc = heightNdc / currentHeight; // The scaled point size in normalized device coordinates

      var pointSizeNdc = computedPointSizeMouseDetection * pointScale * pxNdc * 0.66; // Get all points within a close range

      var pointsInBBox = searchIndex.range(xNdc - pointSizeNdc, yNdc - pointSizeNdc, xNdc + pointSizeNdc, yNdc + pointSizeNdc); // Find the closest point

      var minDist = pointSizeNdc;
      var clostestPoint;
      pointsInBBox.forEach(function (idx) {
        var _searchIndex$points$i = _slicedToArray(searchIndex.points[idx], 2),
            ptX = _searchIndex$points$i[0],
            ptY = _searchIndex$points$i[1];

        var d = dist(ptX, ptY, xNdc, yNdc);

        if (d < minDist) {
          minDist = d;
          clostestPoint = idx;
        }
      });
      if (minDist < computedPointSizeMouseDetection / currentWidth * 2) return clostestPoint;
      return -1;
    };

    var lassoExtend = function lassoExtend(lassoPoints, lassoPointsFlat) {
      lassoPointsCurr = lassoPoints;
      lasso.setPoints(lassoPointsFlat);
      pubSub.publish('lassoExtend', {
        coordinates: lassoPoints
      });
    };

    var findPointsInLasso = function findPointsInLasso(lassoPolygon) {
      var _searchIndex;

      // get the bounding box of the lasso selection...
      var bBox = getBBox(lassoPolygon); // ...to efficiently preselect potentially selected points

      var pointsInBBox = (_searchIndex = searchIndex).range.apply(_searchIndex, _toConsumableArray(bBox)); // next we test each point in the bounding box if it is in the polygon too


      var pointsInPolygon = [];
      pointsInBBox.forEach(function (pointIdx) {
        if (isPointInPolygon(searchIndex.points[pointIdx], lassoPolygon)) pointsInPolygon.push(pointIdx);
      });
      return pointsInPolygon;
    };

    var lassoClear = function lassoClear() {
      lassoPointsCurr = [];
      if (lasso) lasso.clear();
    };

    var hasPointConnections = function hasPointConnections(point) {
      return point && point.length > 4;
    };

    var setPointConnectionColorState = function setPointConnectionColorState(pointIdxs, stateIndex) {
      if (computingPointConnectionCurves || !showPointConnections || !hasPointConnections(searchIndex.points[pointIdxs[0]])) return;
      var isNormal = stateIndex === 0;
      var lineIdCacher = stateIndex === 1 ? function (lineId) {
        return selectionConnecionSet.add(lineId);
      } : identity; // Get line IDs

      var lineIds = Object.keys(pointIdxs.reduce(function (ids, pointIdx) {
        var point = searchIndex.points[pointIdx];
        var isStruct = Array.isArray(point[4]);
        var lineId = isStruct ? point[4][0] : point[4];
        ids[lineId] = true;
        return ids;
      }, {}));
      var buffer = pointConnections.getData().opacities;
      lineIds.filter(function (lineId) {
        return !selectionConnecionSet.has(+lineId);
      }).forEach(function (lineId) {
        var index = pointConnectionMap[lineId][0];
        var numPointPerLine = pointConnectionMap[lineId][2];
        var pointOffset = pointConnectionMap[lineId][3];
        var bufferStart = index * 4 + pointOffset * 2;
        var bufferEnd = bufferStart + numPointPerLine * 2 + 4; // eslint-disable-next-line no-underscore-dangle

        if (buffer.__original__ === undefined) {
          // eslint-disable-next-line no-underscore-dangle
          buffer.__original__ = buffer.slice();
        }

        for (var i = bufferStart; i < bufferEnd; i++) {
          // buffer[i] = Math.floor(buffer[i] / 4) * 4 + stateIndex;
          buffer[i] = isNormal ? // eslint-disable-next-line no-underscore-dangle
          buffer.__original__[i] : pointConnectionOpacityActive;
        }

        lineIdCacher(lineId);
      });
      pointConnections.getBuffer().opacities.subdata(buffer, 0);
    };

    var indexToStateTexCoord = function indexToStateTexCoord(index) {
      return [index % stateTexRes / stateTexRes + stateTexEps, Math.floor(index / stateTexRes) / stateTexRes + stateTexEps];
    };

    var deselect = function deselect() {
      var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref2$preventEvent = _ref2.preventEvent,
          preventEvent = _ref2$preventEvent === void 0 ? false : _ref2$preventEvent;

      if (lassoClearEvent === LASSO_CLEAR_ON_DESELECT) lassoClear();

      if (selection.length) {
        if (!preventEvent) pubSub.publish('deselect');
        selectionConnecionSet.clear();
        setPointConnectionColorState(selection, 0);
        selection = [];
        selectionSet.clear();
        draw = true;
      }
    };
    /**
     * @param {number | number[]} pointIdxs
     * @param {import('./types').ScatterplotMethodOptions['select']}
     */


    var select = function select(pointIdxs) {
      var _ref3 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          _ref3$merge = _ref3.merge,
          merge = _ref3$merge === void 0 ? false : _ref3$merge,
          _ref3$preventEvent = _ref3.preventEvent,
          preventEvent = _ref3$preventEvent === void 0 ? false : _ref3$preventEvent;

      var pointIdxsArr = Array.isArray(pointIdxs) ? pointIdxs : [pointIdxs];

      if (merge) {
        selection = unionIntegers(selection, pointIdxsArr);
      } else {
        // Unset previously highlight point connections
        if (selection && selection.length) setPointConnectionColorState(selection, 0);
        selection = pointIdxsArr;
      }

      var selectionBuffer = [];
      selectionSet.clear();
      selectionConnecionSet.clear();

      for (var i = selection.length - 1; i >= 0; i--) {
        var pointIdx = selection[i];

        if (pointIdx < 0 || pointIdx >= numPoints) {
          // Remove invalid selection
          selection.splice(i, 1);
        } else {
          selectionSet.add(pointIdx);
          var texCoords = indexToStateTexCoord(pointIdx);
          selectionBuffer.push(texCoords[0]);
          selectionBuffer.push(texCoords[1]);
        }
      }

      selectedPointsIndexBuffer({
        usage: 'dynamic',
        type: 'float',
        data: selectionBuffer
      });
      setPointConnectionColorState(selection, 1);
      if (!preventEvent) pubSub.publish('select', {
        points: selection
      });
      draw = true;
    };

    var getRelativeMousePosition = function getRelativeMousePosition(event) {
      var rect = canvas.getBoundingClientRect();
      mousePosition[0] = event.clientX - rect.left;
      mousePosition[1] = event.clientY - rect.top;
      return [].concat(mousePosition);
    };

    var lassoStart = function lassoStart() {
      // Fix camera for the lasso selection
      camera.config({
        isFixed: true
      });
      mouseDown = true;
      lassoActive = true;
      lassoClear();
      pubSub.publish('lassoStart');
    };

    var lassoEnd = function lassoEnd(lassoPoints, lassoPointsFlat) {
      var _ref4 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {},
          _ref4$merge = _ref4.merge,
          merge = _ref4$merge === void 0 ? false : _ref4$merge;

      camera.config({
        isFixed: false
      });
      lassoPointsCurr = _toConsumableArray(lassoPoints); // const t0 = performance.now();

      var pointsInLasso = findPointsInLasso(lassoPointsFlat); // console.log(`found ${pointsInLasso.length} in ${performance.now() - t0} msec`);

      select(pointsInLasso, {
        merge: merge
      });
      pubSub.publish('lassoEnd', {
        coordinates: lassoPointsCurr
      });
      if (lassoClearEvent === LASSO_CLEAR_ON_END) lassoClear();
    };

    var lassoManager = createLasso(canvas, {
      onStart: lassoStart,
      onDraw: lassoExtend,
      onEnd: lassoEnd,
      enableInitiator: lassoInitiator,
      initiatorParentElement: lassoInitiatorParentElement,
      pointNorm: function pointNorm(_ref5) {
        var _ref6 = _slicedToArray(_ref5, 2),
            x = _ref6[0],
            y = _ref6[1];

        return getScatterGlPos(getNdcX(x), getNdcY(y));
      }
    });

    var checkLassoMode = function checkLassoMode() {
      return mouseMode === MOUSE_MODE_LASSO;
    };

    var checkModKey = function checkModKey(event, action) {
      switch (keyActionMap[action]) {
        case KEY_ALT:
          return event.altKey;

        case KEY_CMD:
          return event.metaKey;

        case KEY_CTRL:
          return event.ctrlKey;

        case KEY_META:
          return event.metaKey;

        case KEY_SHIFT:
          return event.shiftKey;

        default:
          return false;
      }
    };

    var mouseDownHandler = function mouseDownHandler(event) {
      if (!isInit) return;
      mouseDown = true;
      mouseDownTime = performance.now();
      mouseDownPosition = getRelativeMousePosition(event);
      lassoActive = checkLassoMode() || checkModKey(event, KEY_ACTION_LASSO);
    };

    var mouseUpHandler = function mouseUpHandler(event) {
      if (!isInit) return;
      mouseDown = false;

      if (lassoActive) {
        event.preventDefault();
        lassoActive = false;
        lassoManager.end({
          merge: checkModKey(event, KEY_ACTION_MERGE)
        });
      }
    };

    var mouseClickHandler = function mouseClickHandler(event) {
      if (!isInit) return;
      event.preventDefault();
      var currentMousePosition = getRelativeMousePosition(event);
      if (dist.apply(void 0, _toConsumableArray(currentMousePosition).concat(_toConsumableArray(mouseDownPosition))) >= lassoMinDist) return;
      var clickTime = performance.now() - mouseDownTime;

      if (lassoInitiator && clickTime > LONG_CLICK_TIME) {
        // Show lasso initiator on long click immideately
        lassoManager.showInitiator(event);
      } else {
        // If the user clicked normally (i.e., fast) we'll only show the lasso
        // initiator if the use click into the void
        var clostestPoint = raycast();

        if (clostestPoint >= 0) {
          if (selection.length && lassoClearEvent === LASSO_CLEAR_ON_DESELECT) {
            // Special case where we silently "deselect" the previous points by
            // overriding the selection. Hence, we need to clear the lasso.
            lassoClear();
          }

          select([clostestPoint], {
            merge: checkModKey(event, KEY_ACTION_MERGE)
          });
        } else if (!lassoInitiatorTimeout) {
          // We'll also wait to make sure the user didn't double click
          lassoInitiatorTimeout = setTimeout(function () {
            lassoInitiatorTimeout = null;
            lassoManager.showInitiator(event);
          }, SINGLE_CLICK_DELAY);
        }
      }
    };

    var mouseDblClickHandler = function mouseDblClickHandler(event) {
      lassoManager.hideInitiator();

      if (lassoInitiatorTimeout) {
        clearTimeout(lassoInitiatorTimeout);
        lassoInitiatorTimeout = null;
      }

      if (deselectOnDblClick) {
        event.preventDefault();
        deselect();
      }
    };

    var mouseMoveHandler = function mouseMoveHandler(event) {
      if (!isInit || !isMouseInCanvas && !mouseDown) return;
      getRelativeMousePosition(event); // Only ray cast if the mouse cursor is inside

      if (isMouseInCanvas && !lassoActive) {
        hover(raycast()); // eslint-disable-line no-use-before-define
      }

      if (lassoActive) {
        event.preventDefault();
        lassoManager.extend(event, true);
      } // Always redraw when mousedown as the user might have panned or lassoed


      if (mouseDown) draw = true;
    };

    var blurHandler = function blurHandler() {
      if (!isInit) return;
      if (+hoveredPoint >= 0 && !selectionSet.has(hoveredPoint)) setPointConnectionColorState([hoveredPoint], 0);
      hoveredPoint = undefined;
      isMouseInCanvas = false;
      mouseUpHandler();
      draw = true;
    };

    var createEncodingTexture = function createEncodingTexture() {
      var maxEncoding = Math.max(pointSize.length, opacity.length);
      encodingTexRes = Math.max(2, Math.ceil(Math.sqrt(maxEncoding)));
      var rgba = new Float32Array(Math.pow(encodingTexRes, 2) * 4);

      for (var i = 0; i < maxEncoding; i++) {
        rgba[i * 4] = pointSize[i] || 0;
        rgba[i * 4 + 1] = Math.min(1, opacity[i] || 0);
        var active = Number((pointColorActive[i] || pointColorActive[0])[3]);
        rgba[i * 4 + 2] = Math.min(1, Number.isNaN(active) ? 1 : active);

        var _hover = Number((pointColorHover[i] || pointColorHover[0])[3]);

        rgba[i * 4 + 3] = Math.min(1, Number.isNaN(_hover) ? 1 : _hover);
      }

      return renderer.regl.texture({
        data: rgba,
        shape: [encodingTexRes, encodingTexRes, 4],
        type: 'float'
      });
    };

    var getColors = function getColors() {
      var baseColor = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : pointColor;
      var activeColor = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : pointColorActive;
      var hoverColor = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : pointColorHover;
      var n = baseColor.length;
      var n2 = activeColor.length;
      var n3 = hoverColor.length;
      var colors = [];

      if (n === n2 && n2 === n3) {
        for (var i = 0; i < n; i++) {
          colors.push(baseColor[i], activeColor[i], hoverColor[i], backgroundColor);
        }
      } else {
        for (var _i = 0; _i < n; _i++) {
          var rgbaOpaque = [baseColor[_i][0], baseColor[_i][1], baseColor[_i][2], 1];
          var colorActive = colorBy === DEFAULT_COLOR_BY ? activeColor[0] : rgbaOpaque;
          var colorHover = colorBy === DEFAULT_COLOR_BY ? hoverColor[0] : rgbaOpaque;
          colors.push(baseColor[_i], colorActive, colorHover, backgroundColor);
        }
      }

      return colors;
    };

    var createColorTexture = function createColorTexture() {
      var colors = getColors();
      var numColors = colors.length;
      colorTexRes = Math.max(2, Math.ceil(Math.sqrt(numColors)));
      var rgba = new Float32Array(Math.pow(colorTexRes, 2) * 4);
      colors.forEach(function (color, i) {
        rgba[i * 4] = color[0]; // r

        rgba[i * 4 + 1] = color[1]; // g

        rgba[i * 4 + 2] = color[2]; // b

        rgba[i * 4 + 3] = color[3]; // a
      });
      return renderer.regl.texture({
        data: rgba,
        shape: [colorTexRes, colorTexRes, 4],
        type: 'float'
      });
    };
    /**
     * Since we're using an external renderer whose canvas' width and height
     * might differ from this instance's width and height, we have to adjust the
     * projection of camera spaces into clip space accordingly.
     *
     * The `widthRatio` is rendererCanvas.width / thisCanvas.width
     * The `heightRatio` is rendererCanvas.height / thisCanvas.height
     */


    var updateProjectionMatrix = function updateProjectionMatrix(widthRatio, heightRatio) {
      projection[0] = widthRatio / viewAspectRatio;
      projection[5] = heightRatio;
    };

    var updateViewAspectRatio = function updateViewAspectRatio() {
      viewAspectRatio = currentWidth / currentHeight;
      projectionLocal = fromScaling([], [1 / viewAspectRatio, 1, 1]);
      projection = fromScaling([], [1 / viewAspectRatio, 1, 1]);
      model = fromScaling([], [dataAspectRatio, 1, 1]);
    };

    var setDataAspectRatio = function setDataAspectRatio(newDataAspectRatio) {
      if (+newDataAspectRatio <= 0) return;
      dataAspectRatio = newDataAspectRatio;
    };

    var setColors = function setColors(getter, setter) {
      return function (newColors) {
        if (!newColors || !newColors.length) return;
        var colors = getter();

        var prevColors = _toConsumableArray(colors);

        var tmpColors = isMultipleColors(newColors) ? newColors : [newColors];
        tmpColors = tmpColors.map(function (color) {
          return toRgba(color, true);
        });
        if (colorTex) colorTex.destroy();

        try {
          setter(tmpColors);
          colorTex = createColorTexture();
        } catch (e) {
          console.error('Invalid colors. Switching back to default colors.'); // eslint-disable-next-line no-param-reassign

          setter(prevColors);
          colorTex = createColorTexture();
        }
      };
    };

    var setPointColor = setColors(function () {
      return pointColor;
    }, function (colors) {
      pointColor = colors;
    });
    var setPointColorActive = setColors(function () {
      return pointColorActive;
    }, function (colors) {
      pointColorActive = colors;
    });
    var setPointColorHover = setColors(function () {
      return pointColorHover;
    }, function (colors) {
      pointColorHover = colors;
    });

    var computeDomainView = function computeDomainView() {
      var xyStartPt = getScatterGlPos(-1, -1);
      var xyEndPt = getScatterGlPos(1, 1);
      var xStart = (xyStartPt[0] + 1) / 2;
      var xEnd = (xyEndPt[0] + 1) / 2;
      var yStart = (xyStartPt[1] + 1) / 2;
      var yEnd = (xyEndPt[1] + 1) / 2;
      var xDomainView = [xDomainStart + xStart * xDomainSize, xDomainStart + xEnd * xDomainSize];
      var yDomainView = [yDomainStart + yStart * yDomainSize, yDomainStart + yEnd * yDomainSize];
      return [xDomainView, yDomainView];
    };

    var updateScales = function updateScales() {
      if (!xScale && !yScale) return;

      var _computeDomainView = computeDomainView(),
          _computeDomainView2 = _slicedToArray(_computeDomainView, 2),
          xDomainView = _computeDomainView2[0],
          yDomainView = _computeDomainView2[1];

      if (xScale) xScale.domain(xDomainView);
      if (yScale) yScale.domain(yDomainView);
    };

    var setCurrentHeight = function setCurrentHeight(newCurrentHeight) {
      currentHeight = newCurrentHeight;
      canvas.height = Math.floor(currentHeight * window.devicePixelRatio);

      if (yScale) {
        yScale.range([currentHeight, 0]);
        updateScales();
      }
    };

    var setHeight = function setHeight(newHeight) {
      if (newHeight === AUTO) {
        height = newHeight;
        canvas.style.height = '100%';
        window.requestAnimationFrame(function () {
          if (canvas) setCurrentHeight(canvas.getBoundingClientRect().height);
        });
        return;
      }

      if (!+newHeight || +newHeight <= 0) return;
      height = +newHeight;
      setCurrentHeight(height);
      canvas.style.height = "".concat(height, "px");
    };

    var computePointSizeMouseDetection = function computePointSizeMouseDetection() {
      computedPointSizeMouseDetection = pointSizeMouseDetection;

      if (pointSizeMouseDetection === AUTO) {
        computedPointSizeMouseDetection = Array.isArray(pointSize) ? pointSize[Math.floor(pointSize.length / 2)] : pointSize;
      }
    };

    var setPointSize = function setPointSize(newPointSize) {
      if (isConditionalArray(newPointSize, isPositiveNumber, {
        minLength: 1
      })) pointSize = _toConsumableArray(newPointSize);
      if (isStrictlyPositiveNumber(+newPointSize)) pointSize = [+newPointSize];
      minPointScale = MIN_POINT_SIZE / pointSize[0];
      encodingTex = createEncodingTexture();
      computePointSizeMouseDetection();
    };

    var setPointSizeSelected = function setPointSizeSelected(newPointSizeSelected) {
      if (!+newPointSizeSelected || +newPointSizeSelected < 0) return;
      pointSizeSelected = +newPointSizeSelected;
    };

    var setPointOutlineWidth = function setPointOutlineWidth(newPointOutlineWidth) {
      if (!+newPointOutlineWidth || +newPointOutlineWidth < 0) return;
      pointOutlineWidth = +newPointOutlineWidth;
    };

    var setCurrentWidth = function setCurrentWidth(newCurrentWidth) {
      currentWidth = newCurrentWidth;
      canvas.width = Math.floor(currentWidth * window.devicePixelRatio);

      if (xScale) {
        xScale.range([0, currentWidth]);
        updateScales();
      }
    };

    var setWidth = function setWidth(newWidth) {
      if (newWidth === AUTO) {
        width = newWidth;
        canvas.style.width = '100%';
        window.requestAnimationFrame(function () {
          if (canvas) setCurrentWidth(canvas.getBoundingClientRect().width);
        });
        return;
      }

      if (!+newWidth || +newWidth <= 0) return;
      width = +newWidth;
      setCurrentWidth(width);
      canvas.style.width = "".concat(currentWidth, "px");
    };

    var setOpacity = function setOpacity(newOpacity) {
      if (isConditionalArray(newOpacity, isPositiveNumber, {
        minLength: 1
      })) opacity = _toConsumableArray(newOpacity);
      if (isStrictlyPositiveNumber(+newOpacity)) opacity = [+newOpacity];
      encodingTex = createEncodingTexture();
    };

    var getEncodingDataType = function getEncodingDataType(type) {
      switch (type) {
        case 'valueZ':
          return maxValueZ > 1 ? 'categorical' : 'continuous';

        case 'valueW':
          return maxValueW > 1 ? 'categorical' : 'continuous';

        default:
          return null;
      }
    };

    var getEncodingValueToIdx = function getEncodingValueToIdx(type, rangeValues) {
      switch (type) {
        default:
        case 'categorical':
          return identity;

        case 'continuous':
          return function (value) {
            return Math.round(value * (rangeValues.length - 1));
          };
      }
    };

    var setColorBy = function setColorBy(type) {
      colorBy = getEncodingType(type, DEFAULT_COLOR_BY);
    };

    var setOpacityBy = function setOpacityBy(type) {
      opacityBy = getEncodingType(type, DEFAULT_OPACITY_BY, {
        allowDensity: true
      });
    };

    var setSizeBy = function setSizeBy(type) {
      sizeBy = getEncodingType(type, DEFAULT_SIZE_BY);
    };

    var setPointConnectionColorBy = function setPointConnectionColorBy(type) {
      pointConnectionColorBy = getEncodingType(type, DEFAULT_POINT_CONNECTION_COLOR_BY, {
        allowSegment: true
      });
    };

    var setPointConnectionOpacityBy = function setPointConnectionOpacityBy(type) {
      pointConnectionOpacityBy = getEncodingType(type, DEFAULT_POINT_CONNECTION_OPACITY_BY, {
        allowSegment: true
      });
    };

    var setPointConnectionSizeBy = function setPointConnectionSizeBy(type) {
      pointConnectionSizeBy = getEncodingType(type, DEFAULT_POINT_CONNECTION_SIZE_BY, {
        allowSegment: true
      });
    };

    var getResolution = function getResolution() {
      return [canvas.width, canvas.height];
    };

    var getBackgroundImage = function getBackgroundImage() {
      return backgroundImage;
    };

    var getColorTex = function getColorTex() {
      return colorTex;
    };

    var getColorTexRes = function getColorTexRes() {
      return colorTexRes;
    };

    var getColorTexEps = function getColorTexEps() {
      return 0.5 / colorTexRes;
    };

    var getDevicePixelRatio = function getDevicePixelRatio() {
      return window.devicePixelRatio;
    };

    var getNormalPointsIndexBuffer = function getNormalPointsIndexBuffer() {
      return normalPointsIndexBuffer;
    };

    var getSelectedPointsIndexBuffer = function getSelectedPointsIndexBuffer() {
      return selectedPointsIndexBuffer;
    };

    var getEncodingTex = function getEncodingTex() {
      return encodingTex;
    };

    var getEncodingTexRes = function getEncodingTexRes() {
      return encodingTexRes;
    };

    var getEncodingTexEps = function getEncodingTexEps() {
      return 0.5 / encodingTexRes;
    };

    var getNormalPointSizeExtra = function getNormalPointSizeExtra() {
      return 0;
    };

    var getStateTex = function getStateTex() {
      return tmpStateTex || stateTex;
    };

    var getStateTexRes = function getStateTexRes() {
      return stateTexRes;
    };

    var getStateTexEps = function getStateTexEps() {
      return 0.5 / stateTexRes;
    };

    var getProjection = function getProjection() {
      return projection;
    };

    var getView = function getView() {
      return camera.view;
    };

    var getModel = function getModel() {
      return model;
    };

    var getModelViewProjection = function getModelViewProjection() {
      return multiply(pvm, projection, multiply(pvm, camera.view, model));
    };

    var getPointScale = function getPointScale() {
      if (camera.scaling[0] > 1) return Math.asinh(max(1.0, camera.scaling[0])) / Math.asinh(1) * window.devicePixelRatio;
      return max(minPointScale, camera.scaling[0]) * window.devicePixelRatio;
    };

    var getNormalNumPoints = function getNormalNumPoints() {
      return numPoints;
    };

    var getSelectedNumPoints = function getSelectedNumPoints() {
      return selection.length;
    };

    var getIsColoredByZ = function getIsColoredByZ() {
      return +(colorBy === 'valueZ');
    };

    var getIsColoredByW = function getIsColoredByW() {
      return +(colorBy === 'valueW');
    };

    var getIsOpacityByZ = function getIsOpacityByZ() {
      return +(opacityBy === 'valueZ');
    };

    var getIsOpacityByW = function getIsOpacityByW() {
      return +(opacityBy === 'valueW');
    };

    var getIsOpacityByDensity = function getIsOpacityByDensity() {
      return +(opacityBy === 'density');
    };

    var getIsSizedByZ = function getIsSizedByZ() {
      return +(sizeBy === 'valueZ');
    };

    var getIsSizedByW = function getIsSizedByW() {
      return +(sizeBy === 'valueW');
    };

    var getColorMultiplicator = function getColorMultiplicator() {
      if (colorBy === 'valueZ') return maxValueZ <= 1 ? pointColor.length - 1 : 1;
      return maxValueW <= 1 ? pointColor.length - 1 : 1;
    };

    var getOpacityMultiplicator = function getOpacityMultiplicator() {
      if (opacityBy === 'valueZ') return maxValueZ <= 1 ? opacity.length - 1 : 1;
      return maxValueW <= 1 ? opacity.length - 1 : 1;
    };

    var getSizeMultiplicator = function getSizeMultiplicator() {
      if (sizeBy === 'valueZ') return maxValueZ <= 1 ? pointSize.length - 1 : 1;
      return maxValueW <= 1 ? pointSize.length - 1 : 1;
    };

    var getOpacityDensity = function getOpacityDensity(context) {
      if (opacityBy !== 'density') return 1; // Adopted from the fabulous Ricky Reusser:
      // https://observablehq.com/@rreusser/selecting-the-right-opacity-for-2d-point-clouds
      // Extended with a point-density based approach

      var pointScale = getPointScale();
      var p = pointSize[0] * pointScale; // Compute the plot's x and y range from the view matrix, though these could come from any source

      var s = 2 / (2 / camera.view[0]) * (2 / (2 / camera.view[5])); // Viewport size, in device pixels

      var H = context.viewportHeight;
      var W = context.viewportWidth; // Adaptation: Instead of using the global number of points, I am using a
      // density-based approach that takes the points in the view into context
      // when zooming in. This ensure that in sparse areas, points are opaque and
      // in dense areas points are more translucent.

      var alpha = opacityByDensityFill * W * H / (numPointsInView * p * p) * min(1, s); // In performanceMode we use squares, otherwise we use circles, which only
      // take up (pi r^2) of the unit square

      alpha *= performanceMode ? 1 : 1 / (0.25 * Math.PI); // If the pixels shrink below the minimum permitted size, then we adjust the opacity instead
      // and apply clamping of the point size in the vertex shader. Note that we add 0.5 since we
      // slightly inrease the size of points during rendering to accommodate SDF-style antialiasing.

      var clampedPointDeviceSize = max(MIN_POINT_SIZE, p) + 0.5; // We square this since we're concerned with the ratio of *areas*.
      // eslint-disable-next-line no-restricted-properties

      alpha *= Math.pow(p / clampedPointDeviceSize, 2); // And finally, we clamp to the range [0, 1]. We should really clamp this to 1 / precision
      // on the low end, depending on the data type of the destination so that we never render *nothing*.

      return min(1, max(0, alpha));
    };

    var updatePoints = renderer.regl({
      framebuffer: function framebuffer() {
        return tmpStateBuffer;
      },
      vert: SHADER,
      frag: SHADER$1,
      attributes: {
        position: [-4, 0, 4, 4, 4, -4]
      },
      uniforms: {
        startStateTex: function startStateTex() {
          return prevStateTex;
        },
        endStateTex: function endStateTex() {
          return stateTex;
        },
        t: function t(ctx, props) {
          return props.t;
        }
      },
      count: 3
    });

    var drawPoints = function drawPoints(getPointSizeExtra, getNumPoints, getStateIndexBuffer) {
      var globalState = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : COLOR_NORMAL_IDX;
      return renderer.regl({
        frag: performanceMode ? FRAGMENT_SHADER : FRAGMENT_SHADER$1,
        vert: createVertexShader(globalState),
        blend: {
          enable: !performanceMode,
          func: {
            srcRGB: 'src alpha',
            srcAlpha: 'one',
            dstRGB: 'one minus src alpha',
            dstAlpha: 'one minus src alpha'
          }
        },
        depth: {
          enable: false
        },
        attributes: {
          stateIndex: {
            buffer: getStateIndexBuffer,
            size: 2
          }
        },
        uniforms: {
          resolution: getResolution,
          modelViewProjection: getModelViewProjection,
          devicePixelRatio: getDevicePixelRatio,
          pointScale: getPointScale,
          encodingTex: getEncodingTex,
          encodingTexRes: getEncodingTexRes,
          encodingTexEps: getEncodingTexEps,
          pointSizeExtra: getPointSizeExtra,
          globalState: globalState,
          colorTex: getColorTex,
          colorTexRes: getColorTexRes,
          colorTexEps: getColorTexEps,
          stateTex: getStateTex,
          stateTexRes: getStateTexRes,
          stateTexEps: getStateTexEps,
          isColoredByZ: getIsColoredByZ,
          isColoredByW: getIsColoredByW,
          isOpacityByZ: getIsOpacityByZ,
          isOpacityByW: getIsOpacityByW,
          isOpacityByDensity: getIsOpacityByDensity,
          isSizedByZ: getIsSizedByZ,
          isSizedByW: getIsSizedByW,
          colorMultiplicator: getColorMultiplicator,
          opacityMultiplicator: getOpacityMultiplicator,
          opacityDensity: getOpacityDensity,
          sizeMultiplicator: getSizeMultiplicator,
          numColorStates: COLOR_NUM_STATES
        },
        count: getNumPoints,
        primitive: 'points'
      });
    };

    var drawPointBodies = drawPoints(getNormalPointSizeExtra, getNormalNumPoints, getNormalPointsIndexBuffer);
    var drawHoveredPoint = drawPoints(getNormalPointSizeExtra, function () {
      return 1;
    }, function () {
      return hoveredPointIndexBuffer;
    }, COLOR_HOVER_IDX);
    var drawSelectedPointOutlines = drawPoints(function () {
      return (pointSizeSelected + pointOutlineWidth * 2) * window.devicePixelRatio;
    }, getSelectedNumPoints, getSelectedPointsIndexBuffer, COLOR_ACTIVE_IDX);
    var drawSelectedPointInnerBorder = drawPoints(function () {
      return (pointSizeSelected + pointOutlineWidth) * window.devicePixelRatio;
    }, getSelectedNumPoints, getSelectedPointsIndexBuffer, COLOR_BG_IDX);
    var drawSelectedPointBodies = drawPoints(function () {
      return pointSizeSelected * window.devicePixelRatio;
    }, getSelectedNumPoints, getSelectedPointsIndexBuffer, COLOR_ACTIVE_IDX);

    var drawSelectedPoints = function drawSelectedPoints() {
      drawSelectedPointOutlines();
      drawSelectedPointInnerBorder();
      drawSelectedPointBodies();
    };

    var drawBackgroundImage = renderer.regl({
      frag: FRAGMENT_SHADER$2,
      vert: VERTEX_SHADER,
      attributes: {
        position: [0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1, 0]
      },
      uniforms: {
        modelViewProjection: getModelViewProjection,
        texture: getBackgroundImage
      },
      count: 6
    });
    var drawPolygon2d = renderer.regl({
      vert: "\n      precision mediump float;\n      uniform mat4 modelViewProjection;\n      attribute vec2 position;\n      void main () {\n        gl_Position = modelViewProjection * vec4(position, 0, 1);\n      }",
      frag: "\n      precision mediump float;\n      uniform vec4 color;\n      void main () {\n        gl_FragColor = vec4(color.rgb, 0.2);\n      }",
      depth: {
        enable: false
      },
      blend: {
        enable: true,
        func: {
          srcRGB: 'src alpha',
          srcAlpha: 'one',
          dstRGB: 'one minus src alpha',
          dstAlpha: 'one minus src alpha'
        }
      },
      attributes: {
        position: function position() {
          return lassoPointsCurr;
        }
      },
      uniforms: {
        modelViewProjection: getModelViewProjection,
        color: function color() {
          return lassoColor;
        }
      },
      elements: function elements() {
        return Array.from({
          length: lassoPointsCurr.length - 2
        }, function (_, i) {
          return [0, i + 1, i + 2];
        });
      }
    });

    var drawReticle = function drawReticle() {
      if (!(hoveredPoint >= 0)) return;

      var _searchIndex$points$h = searchIndex.points[hoveredPoint].slice(0, 2),
          _searchIndex$points$h2 = _slicedToArray(_searchIndex$points$h, 2),
          x = _searchIndex$points$h2[0],
          y = _searchIndex$points$h2[1]; // Homogeneous coordinates of the point


      var v = [x, y, 0, 1]; // We have to calculate the model-view-projection matrix outside of the
      // shader as we actually don't want the model, view, or projection of the
      // line view space to change such that the reticle is visualized across the
      // entire view container and not within the view of the scatterplot

      multiply(scratch, projection, multiply(scratch, camera.view, model));
      transformMat4(v, v, scratch);
      reticleHLine.setPoints([-1, v[1], 1, v[1]]);
      reticleVLine.setPoints([v[0], 1, v[0], -1]);
      reticleHLine.draw();
      reticleVLine.draw(); // Draw outer outline

      drawPoints(function () {
        return (pointSizeSelected + pointOutlineWidth * 2) * window.devicePixelRatio;
      }, function () {
        return 1;
      }, hoveredPointIndexBuffer, COLOR_ACTIVE_IDX)(); // Draw inner outline

      drawPoints(function () {
        return (pointSizeSelected + pointOutlineWidth) * window.devicePixelRatio;
      }, function () {
        return 1;
      }, hoveredPointIndexBuffer, COLOR_BG_IDX)();
    };

    var createPointIndex = function createPointIndex(numNewPoints) {
      var index = new Float32Array(numNewPoints * 2);
      var j = 0;

      for (var i = 0; i < numNewPoints; ++i) {
        var texCoord = indexToStateTexCoord(i);
        index[j] = texCoord[0]; // x

        index[j + 1] = texCoord[1]; // y

        j += 2;
      }

      return index;
    };

    var createStateTexture = function createStateTexture(newPoints) {
      var numNewPoints = newPoints.length;
      stateTexRes = Math.max(2, Math.ceil(Math.sqrt(numNewPoints)));
      stateTexEps = 0.5 / stateTexRes;
      var data = new Float32Array(Math.pow(stateTexRes, 2) * 4);
      maxValueZ = 0;
      maxValueW = 0;

      for (var i = 0; i < numNewPoints; ++i) {
        data[i * 4] = newPoints[i][0]; // x

        data[i * 4 + 1] = newPoints[i][1]; // y

        data[i * 4 + 2] = newPoints[i][2] || 0; // z: value 1

        data[i * 4 + 3] = newPoints[i][3] || 0; // w: value 2

        maxValueZ = Math.max(maxValueZ, data[i * 4 + 2]);
        maxValueW = Math.max(maxValueW, data[i * 4 + 3]);
      }

      return renderer.regl.texture({
        data: data,
        shape: [stateTexRes, stateTexRes, 4],
        type: 'float'
      });
    };

    var cachePoints = function cachePoints(newPoints) {
      if (!stateTex) return false;

      if (isTransitioning) {
        var tmp = prevStateTex;
        prevStateTex = tmpStateTex;
        tmp.destroy();
      } else {
        prevStateTex = stateTex;
      }

      tmpStateTex = createStateTexture(newPoints);
      tmpStateBuffer = renderer.regl.framebuffer({
        color: tmpStateTex,
        depth: false,
        stencil: false
      });
      stateTex = undefined;
      return true;
    };

    var clearCachedPoints = function clearCachedPoints() {
      if (prevStateTex) {
        prevStateTex.destroy();
        prevStateTex = undefined;
      }

      if (tmpStateTex) {
        tmpStateTex.destroy();
        tmpStateTex = undefined;
      }
    };

    var setPoints = function setPoints(newPoints) {
      isInit = false;
      numPoints = newPoints.length;
      numPointsInView = numPoints;
      if (stateTex) stateTex.destroy();
      stateTex = createStateTexture(newPoints);
      normalPointsIndexBuffer({
        usage: 'static',
        type: 'float',
        data: createPointIndex(numPoints)
      });
      searchIndex = new KDBush(newPoints, function (p) {
        return p[0];
      }, function (p) {
        return p[1];
      }, 16);
      isInit = true;
    };

    var getPointConnectionColorIndices = function getPointConnectionColorIndices(curvePoints) {
      var colorEncoding = pointConnectionColorBy === 'inherit' ? colorBy : pointConnectionColorBy;

      if (colorEncoding === 'segment') {
        var maxColorIdx = pointConnectionColor.length - 1;
        if (maxColorIdx < 1) return [];
        return curvePoints.reduce(function (colorIndices, curve, index) {
          var totalLength = 0;
          var segLengths = []; // Compute the total length of the line

          for (var i = 2; i < curve.length; i += 2) {
            var segLength = Math.sqrt(Math.pow(curve[i - 2] - curve[i], 2) + Math.pow(curve[i - 1] - curve[i + 1], 2));
            segLengths.push(segLength);
            totalLength += segLength;
          }

          colorIndices[index] = [0];
          var cumLength = 0; // Assign the color index based on the cumulative length

          for (var _i2 = 0; _i2 < curve.length / 2 - 1; _i2++) {
            cumLength += segLengths[_i2]; // The `4` comes from the fact that we have 4 color states:
            // normal, active, hover, and background

            colorIndices[index].push(Math.floor(cumLength / totalLength * maxColorIdx) * 4);
          } // The `4` comes from the fact that we have 4 color states:
          // normal, active, hover, and background
          // colorIndices[index] = rangeMap(
          //   curve.length,
          //   (i) => Math.floor((i / (curve.length - 1)) * maxColorIdx) * 4
          // );


          return colorIndices;
        }, []);
      }

      if (colorEncoding) {
        var encodingIdx = getEncodingIdx(colorEncoding);
        var encodingValueToIdx = getEncodingValueToIdx(getEncodingDataType(colorEncoding), pointConnectionColorBy === 'inherit' ? pointColor : pointConnectionColor);
        return pointConnectionMap.reduce(function (colorIndices, _ref7) {
          var _ref8 = _slicedToArray(_ref7, 2),
              index = _ref8[0],
              referencePoint = _ref8[1];

          // The `4` comes from the fact that we have 4 color states:
          // normal, active, hover, and background
          colorIndices[index] = encodingValueToIdx(referencePoint[encodingIdx]) * 4;
          return colorIndices;
        }, []);
      }

      return Array(pointConnectionMap.length).fill(0);
    };

    var getPointConnectionOpacities = function getPointConnectionOpacities() {
      var opacityEncoding = pointConnectionOpacityBy === 'inherit' ? opacityBy : pointConnectionOpacityBy;

      if (opacityEncoding === 'segment') {
        var maxOpacityIdx = pointConnectionOpacity.length - 1;
        if (maxOpacityIdx < 1) return [];
        return pointConnectionMap.reduce( // eslint-disable-next-line no-unused-vars
        function (opacities, _ref9) {
          var _ref10 = _slicedToArray(_ref9, 3),
              index = _ref10[0];
              _ref10[1];
              var length = _ref10[2];

          opacities[index] = rangeMap(length, function (i) {
            return pointConnectionOpacity[Math.floor(i / (length - 1) * maxOpacityIdx)];
          });
          return opacities;
        }, []);
      }

      if (opacityEncoding) {
        var encodingIdx = getEncodingIdx(opacityEncoding);
        var encodingRangeMap = pointConnectionOpacityBy === 'inherit' ? opacity : pointConnectionOpacity;
        var encodingValueToIdx = getEncodingValueToIdx(getEncodingDataType(opacityEncoding), encodingRangeMap);
        return pointConnectionMap.reduce(function (opacities, _ref11) {
          var _ref12 = _slicedToArray(_ref11, 2),
              index = _ref12[0],
              referencePoint = _ref12[1];

          opacities[index] = encodingRangeMap[encodingValueToIdx(referencePoint[encodingIdx])];
          return opacities;
        }, []);
      }

      return undefined;
    };

    var getPointConnectionWidths = function getPointConnectionWidths() {
      var sizeEncoding = pointConnectionSizeBy === 'inherit' ? sizeBy : pointConnectionSizeBy;

      if (sizeEncoding === 'segment') {
        var maxSizeIdx = pointConnectionSize.length - 1;
        if (maxSizeIdx < 1) return [];
        return pointConnectionMap.reduce( // eslint-disable-next-line no-unused-vars
        function (widths, _ref13) {
          var _ref14 = _slicedToArray(_ref13, 3),
              index = _ref14[0];
              _ref14[1];
              var length = _ref14[2];

          widths[index] = rangeMap(length, function (i) {
            return pointConnectionSize[Math.floor(i / (length - 1) * maxSizeIdx)];
          });
          return widths;
        }, []);
      }

      if (sizeEncoding) {
        var encodingIdx = getEncodingIdx(sizeEncoding);
        var encodingRangeMap = pointConnectionSizeBy === 'inherit' ? pointSize : pointConnectionSize;
        var encodingValueToIdx = getEncodingValueToIdx(getEncodingDataType(sizeEncoding), encodingRangeMap);
        return pointConnectionMap.reduce(function (widths, _ref15) {
          var _ref16 = _slicedToArray(_ref15, 2),
              index = _ref16[0],
              referencePoint = _ref16[1];

          widths[index] = encodingRangeMap[encodingValueToIdx(referencePoint[encodingIdx])];
          return widths;
        }, []);
      }

      return undefined;
    };

    var setPointConnectionMap = function setPointConnectionMap(curvePoints) {
      pointConnectionMap = [];
      var cumLinePoints = 0;
      Object.keys(curvePoints).forEach(function (id, index) {
        pointConnectionMap[id] = [index, curvePoints[id].reference, curvePoints[id].length / 2, // Used for offsetting in the buffer manipulations on
        // hovering and selecting
        cumLinePoints];
        cumLinePoints += curvePoints[id].length / 2;
      });
    };

    var setPointConnections = function setPointConnections(newPoints) {
      return new Promise(function (resolve) {
        pointConnections.setPoints([]);

        if (!newPoints || !newPoints.length) {
          resolve();
        } else {
          computingPointConnectionCurves = true;
          createSplineCurve(newPoints, {
            maxIntPointsPerSegment: pointConnectionMaxIntPointsPerSegment,
            tolerance: pointConnectionTolerance
          }).then(function (curvePoints) {
            setPointConnectionMap(curvePoints);
            var curvePointValues = Object.values(curvePoints);
            pointConnections.setPoints(curvePointValues, {
              colorIndices: getPointConnectionColorIndices(curvePointValues),
              opacities: getPointConnectionOpacities(),
              widths: getPointConnectionWidths()
            });
            computingPointConnectionCurves = false;
            resolve();
          });
        }
      });
    };

    var getPointsInView = function getPointsInView() {
      return searchIndex.range(bottomLeftNdc[0], bottomLeftNdc[1], topRightNdc[0], topRightNdc[1]);
    };

    var getNumPointsInView = function getNumPointsInView() {
      numPointsInView = getPointsInView().length;
    };

    var getNumPointsInViewDb = throttleAndDebounce(getNumPointsInView, opacityByDensityDebounceTime);

    var tween = function tween(duration, easing) {
      if (!transitionStartTime) transitionStartTime = performance.now();
      var dt = performance.now() - transitionStartTime;
      updatePoints({
        t: Math.min(1, Math.max(0, easing(dt / duration)))
      });
      return dt < duration;
    };

    var endTransition = function endTransition() {
      isTransitioning = false;
      transitionStartTime = null;
      transitionDuration = undefined;
      transitionEasing = undefined;
      showReticle = preTransitionShowReticle;
      clearCachedPoints();
      pubSub.publish('transitionEnd');
    };

    var startTransition = function startTransition(_ref17) {
      var _ref17$duration = _ref17.duration,
          duration = _ref17$duration === void 0 ? 500 : _ref17$duration,
          _ref17$easing = _ref17.easing,
          easing = _ref17$easing === void 0 ? DEFAULT_EASING : _ref17$easing;
      if (isTransitioning) pubSub.publish('transitionEnd');
      isTransitioning = true;
      transitionStartTime = null;
      transitionDuration = duration;
      transitionEasing = isString(easing) ? EASING_FNS[easing] || DEFAULT_EASING : easing;
      preTransitionShowReticle = showReticle;
      showReticle = false;
      pubSub.publish('transitionStart');
    };

    var toArrayOrientedPoints = function toArrayOrientedPoints(points) {
      return new Promise(function (resolve, reject) {
        if (!points || Array.isArray(points)) {
          resolve(points);
        } else {
          var length = Array.isArray(points.x) || ArrayBuffer.isView(points.x) ? points.x.length : 0;

          var getX = (Array.isArray(points.x) || ArrayBuffer.isView(points.x)) && function (i) {
            return points.x[i];
          };

          var getY = (Array.isArray(points.y) || ArrayBuffer.isView(points.y)) && function (i) {
            return points.y[i];
          };

          var getL = (Array.isArray(points.line) || ArrayBuffer.isView(points.line)) && function (i) {
            return points.line[i];
          };

          var getLO = (Array.isArray(points.lineOrder) || ArrayBuffer.isView(points.lineOrder)) && function (i) {
            return points.lineOrder[i];
          };

          var components = Object.keys(points);

          var getZ = function () {
            var z = components.find(function (c) {
              return Z_NAMES.has(c);
            });
            return z && (Array.isArray(points[z]) || ArrayBuffer.isView(points[z])) && function (i) {
              return points[z][i];
            };
          }();

          var getW = function () {
            var w = components.find(function (c) {
              return W_NAMES.has(c);
            });
            return w && (Array.isArray(points[w]) || ArrayBuffer.isView(points[w])) && function (i) {
              return points[w][i];
            };
          }();

          if (getX && getY && getZ && getW && getL && getLO) {
            resolve(points.x.map(function (x, i) {
              return [x, getY(i), getZ(i), getW(i), getL(i), getLO(i)];
            }));
          } else if (getX && getY && getZ && getW && getL) {
            resolve(Array.from({
              length: length
            }, function (_, i) {
              return [getX(i), getY(i), getZ(i), getW(i), getL(i)];
            }));
          } else if (getX && getY && getZ && getW) {
            resolve(Array.from({
              length: length
            }, function (_, i) {
              return [getX(i), getY(i), getZ(i), getW(i)];
            }));
          } else if (getX && getY && getZ) {
            resolve(Array.from({
              length: length
            }, function (_, i) {
              return [getX(i), getY(i), getZ(i)];
            }));
          } else if (getX && getY) {
            resolve(Array.from({
              length: length
            }, function (_, i) {
              return [getX(i), getY(i)];
            }));
          } else {
            reject(new Error('You need to specify at least x and y'));
          }
        }
      });
    };
    /**
     * @param {import('./types').Points} newPoints
     * @param {import('./types').ScatterplotMethodOptions['draw']} options
     * @returns {Promise<void>}
     */


    var publicDraw = function publicDraw(newPoints) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      return toArrayOrientedPoints(newPoints).then(function (points) {
        return new Promise(function (resolve) {
          var pointsCached = false;

          if (points) {
            if (options.transition) {
              if (points.length === numPoints) {
                pointsCached = cachePoints(points);
              } else {
                console.warn('Cannot transition! The number of points between the previous and current draw call must be identical.');
              }
            }

            setPoints(points);

            if (showPointConnections || options.showPointConnectionsOnce && hasPointConnections(points[0])) {
              setPointConnections(points).then(function () {
                pubSub.publish('pointConnectionsDraw');
                draw = true;
                drawReticleOnce = options.showReticleOnce;
              });
            }
          }

          if (options.transition && pointsCached) {
            pubSub.subscribe('transitionEnd', function () {
              // Point connects cannot be transitioned yet so we hide them during
              // the transition. Hence, we need to make sure we call `draw()` once
              // the transition has ended.
              draw = true;
              drawReticleOnce = options.showReticleOnce;
              resolve();
            }, 1);
            startTransition({
              duration: options.transitionDuration,
              easing: options.transitionEasing
            });
          } else {
            pubSub.subscribe('draw', resolve, 1);
            draw = true;
            drawReticleOnce = options.showReticleOnce;
          }
        });
      });
    };
    /** @type {<F extends Function>(f: F) => (...args: Parameters<F>) => ReturnType<F>} */


    var withDraw = function withDraw(f) {
      return function () {
        var out = f.apply(void 0, arguments);
        draw = true;
        return out;
      };
    };

    var updatePointConnectionStyle = function updatePointConnectionStyle() {
      pointConnections.setStyle({
        color: getColors(pointConnectionColor, pointConnectionColorActive, pointConnectionColorHover),
        opacity: pointConnectionOpacity === null ? null : pointConnectionOpacity[0],
        width: pointConnectionSize[0]
      });
    };

    var updateLassoInitiatorStyle = function updateLassoInitiatorStyle() {
      var v = Math.round(backgroundColorBrightness) > 0 ? 0 : 255;
      lassoManager.initiator.style.border = "1px dashed rgba(".concat(v, ", ").concat(v, ", ").concat(v, ", 0.33)");
      lassoManager.initiator.style.background = "rgba(".concat(v, ", ").concat(v, ", ").concat(v, ", 0.1)");
    };

    var setBackgroundColor = function setBackgroundColor(newBackgroundColor) {
      if (!newBackgroundColor) return;
      backgroundColor = toRgba(newBackgroundColor, true);
      backgroundColorBrightness = rgbBrightness(backgroundColor);
      updateLassoInitiatorStyle();
    };

    var setBackgroundImage = function setBackgroundImage(newBackgroundImage) {
      if (!newBackgroundImage) {
        backgroundImage = null;
      } else if (isString(newBackgroundImage)) {
        createTextureFromUrl(renderer.regl, newBackgroundImage).then(function (texture) {
          backgroundImage = texture;
          draw = true;
          pubSub.publish('backgroundImageReady');
        }); // eslint-disable-next-line no-underscore-dangle

      } else if (newBackgroundImage._reglType === 'texture2d') {
        backgroundImage = newBackgroundImage;
      } else {
        backgroundImage = null;
      }
    };

    var setCameraDistance = function setCameraDistance(distance) {
      if (distance > 0) camera.lookAt(camera.target, distance, camera.rotation);
    };

    var setCameraRotation = function setCameraRotation(rotation) {
      if (rotation !== null) camera.lookAt(camera.target, camera.distance[0], rotation);
    };

    var setCameraTarget = function setCameraTarget(target) {
      if (target) camera.lookAt(target, camera.distance[0], camera.rotation);
    };

    var setCameraView = function setCameraView(view) {
      if (view) camera.setView(view);
    };

    var setLassoColor = function setLassoColor(newLassoColor) {
      if (!newLassoColor) return;
      lassoColor = toRgba(newLassoColor, true);
      lasso.setStyle({
        color: lassoColor
      });
    };

    var setLassoLineWidth = function setLassoLineWidth(newLassoLineWidth) {
      if (Number.isNaN(+newLassoLineWidth) || +newLassoLineWidth < 1) return;
      lassoLineWidth = +newLassoLineWidth;
      lasso.setStyle({
        width: lassoLineWidth
      });
    };

    var setLassoMinDelay = function setLassoMinDelay(newLassoMinDelay) {
      if (!+newLassoMinDelay) return;
      lassoMinDelay = +newLassoMinDelay;
      lassoManager.set({
        minDelay: lassoMinDelay
      });
    };

    var setLassoMinDist = function setLassoMinDist(newLassoMinDist) {
      if (!+newLassoMinDist) return;
      lassoMinDist = +newLassoMinDist;
      lassoManager.set({
        minDist: lassoMinDist
      });
    };

    var setLassoClearEvent = function setLassoClearEvent(newLassoClearEvent) {
      lassoClearEvent = limit(LASSO_CLEAR_EVENTS, lassoClearEvent)(newLassoClearEvent);
    };

    var setLassoInitiator = function setLassoInitiator(newLassoInitiator) {
      lassoInitiator = Boolean(newLassoInitiator);
      lassoManager.set({
        enableInitiator: lassoInitiator
      });
    };

    var setLassoInitiatorParentElement = function setLassoInitiatorParentElement(newLassoInitiatorParentElement) {
      lassoInitiatorParentElement = newLassoInitiatorParentElement;
      lassoManager.set({
        startInitiatorParentElement: lassoInitiatorParentElement
      });
    };

    var setKeyMap = function setKeyMap(newKeyMap) {
      keyMap = Object.entries(newKeyMap).reduce(function (map, _ref18) {
        var _ref19 = _slicedToArray(_ref18, 2),
            key = _ref19[0],
            value = _ref19[1];

        if (KEYS.includes(key) && KEY_ACTIONS.includes(value)) {
          map[key] = value;
        }

        return map;
      }, {});
      keyActionMap = flipObj(keyMap);

      if (keyActionMap[KEY_ACTION_ROTATE]) {
        camera.config({
          isRotate: true,
          mouseDownMoveModKey: keyActionMap[KEY_ACTION_ROTATE]
        });
      } else {
        camera.config({
          isRotate: false
        });
      }
    };

    var setMouseMode = function setMouseMode(newMouseMode) {
      mouseMode = limit(MOUSE_MODES, MOUSE_MODE_PANZOOM)(newMouseMode);
      camera.config({
        defaultMouseDownMoveAction: mouseMode === MOUSE_MODE_ROTATE ? 'rotate' : 'pan'
      });
    };

    var setShowReticle = function setShowReticle(newShowReticle) {
      if (newShowReticle === null) return;
      showReticle = newShowReticle;
    };

    var setReticleColor = function setReticleColor(newReticleColor) {
      if (!newReticleColor) return;
      reticleColor = toRgba(newReticleColor, true);
      reticleHLine.setStyle({
        color: reticleColor
      });
      reticleVLine.setStyle({
        color: reticleColor
      });
    };

    var setXScale = function setXScale(newXScale) {
      if (!newXScale) return;
      xScale = newXScale;
      xDomainStart = newXScale.domain()[0];
      xDomainSize = newXScale ? newXScale.domain()[1] - newXScale.domain()[0] : 0;
    };

    var setYScale = function setYScale(newYScale) {
      if (!newYScale) return;
      yScale = newYScale;
      yDomainStart = yScale.domain()[0];
      yDomainSize = yScale ? yScale.domain()[1] - yScale.domain()[0] : 0;
    };

    var setDeselectOnDblClick = function setDeselectOnDblClick(newDeselectOnDblClick) {
      deselectOnDblClick = !!newDeselectOnDblClick;
    };

    var setDeselectOnEscape = function setDeselectOnEscape(newDeselectOnEscape) {
      deselectOnEscape = !!newDeselectOnEscape;
    };

    var setShowPointConnections = function setShowPointConnections(newShowPointConnections) {
      showPointConnections = !!newShowPointConnections;

      if (showPointConnections) {
        if (hasPointConnections(searchIndex.points[0])) {
          setPointConnections(searchIndex.points).then(function () {
            pubSub.publish('pointConnectionsDraw');
            draw = true;
          });
        }
      } else {
        setPointConnections();
      }
    };

    var setPointConnectionColors = function setPointConnectionColors(setter, getInheritance) {
      return function (newColors) {
        if (newColors === 'inherit') {
          setter(_toConsumableArray(getInheritance()));
        } else {
          var tmpColors = isMultipleColors(newColors) ? newColors : [newColors];
          setter(tmpColors.map(function (color) {
            return toRgba(color, true);
          }));
        }

        updatePointConnectionStyle();
      };
    };

    var setPointConnectionColor = setPointConnectionColors(function (newColors) {
      pointConnectionColor = newColors;
    }, function () {
      return pointColor;
    });
    var setPointConnectionColorActive = setPointConnectionColors(function (newColors) {
      pointConnectionColorActive = newColors;
    }, function () {
      return pointColorActive;
    });
    var setPointConnectionColorHover = setPointConnectionColors(function (newColors) {
      pointConnectionColorHover = newColors;
    }, function () {
      return pointColorHover;
    });

    var setPointConnectionOpacity = function setPointConnectionOpacity(newOpacity) {
      if (isConditionalArray(newOpacity, isPositiveNumber, {
        minLength: 1
      })) pointConnectionOpacity = _toConsumableArray(newOpacity);
      if (isStrictlyPositiveNumber(+newOpacity)) pointConnectionOpacity = [+newOpacity];
      pointConnectionColor = pointConnectionColor.map(function (color) {
        color[3] = !Number.isNaN(+pointConnectionOpacity[0]) ? +pointConnectionOpacity[0] : color[3];
        return color;
      });
      updatePointConnectionStyle();
    };

    var setPointConnectionOpacityActive = function setPointConnectionOpacityActive(newOpacity) {
      if (!Number.isNaN(+newOpacity) && +newOpacity) pointConnectionOpacityActive = +newOpacity;
    };

    var setPointConnectionSize = function setPointConnectionSize(newPointConnectionSize) {
      if (isConditionalArray(newPointConnectionSize, isPositiveNumber, {
        minLength: 1
      })) pointConnectionSize = _toConsumableArray(newPointConnectionSize);
      if (isStrictlyPositiveNumber(+newPointConnectionSize)) pointConnectionSize = [+newPointConnectionSize];
      updatePointConnectionStyle();
    };

    var setPointConnectionSizeActive = function setPointConnectionSizeActive(newPointConnectionSizeActive) {
      if (!Number.isNaN(+newPointConnectionSizeActive) && +newPointConnectionSizeActive) pointConnectionSizeActive = Math.max(0, newPointConnectionSizeActive);
    };

    var setPointConnectionMaxIntPointsPerSegment = function setPointConnectionMaxIntPointsPerSegment(newPointConnectionMaxIntPointsPerSegment) {
      pointConnectionMaxIntPointsPerSegment = Math.max(0, newPointConnectionMaxIntPointsPerSegment);
    };

    var setPointConnectionTolerance = function setPointConnectionTolerance(newPointConnectionTolerance) {
      pointConnectionTolerance = Math.max(0, newPointConnectionTolerance);
    };

    var setPointSizeMouseDetection = function setPointSizeMouseDetection(newPointSizeMouseDetection) {
      pointSizeMouseDetection = newPointSizeMouseDetection;
      computePointSizeMouseDetection();
    };

    var setOpacityByDensityFill = function setOpacityByDensityFill(newOpacityByDensityFill) {
      opacityByDensityFill = +newOpacityByDensityFill;
    };

    var setGamma = function setGamma(newGamma) {
      renderer.gamma = newGamma;
    };
    /** @type {<Key extends keyof import('./types').Properties>(property: Key) => import('./types').Properties[Key] } */


    var get = function get(property) {
      checkDeprecations({
        property: true
      });
      if (property === 'aspectRatio') return dataAspectRatio;
      if (property === 'background') return backgroundColor;
      if (property === 'backgroundColor') return backgroundColor;
      if (property === 'backgroundImage') return backgroundImage;
      if (property === 'camera') return camera;
      if (property === 'cameraTarget') return camera.target;
      if (property === 'cameraDistance') return camera.distance[0];
      if (property === 'cameraRotation') return camera.rotation;
      if (property === 'cameraView') return camera.view;
      if (property === 'canvas') return canvas;
      if (property === 'colorBy') return colorBy;
      if (property === 'sizeBy') return sizeBy;
      if (property === 'deselectOnDblClick') return deselectOnDblClick;
      if (property === 'deselectOnEscape') return deselectOnEscape;
      if (property === 'height') return height;
      if (property === 'lassoColor') return lassoColor;
      if (property === 'lassoLineWidth') return lassoLineWidth;
      if (property === 'lassoMinDelay') return lassoMinDelay;
      if (property === 'lassoMinDist') return lassoMinDist;
      if (property === 'lassoClearEvent') return lassoClearEvent;
      if (property === 'lassoInitiator') return lassoInitiator;
      if (property === 'lassoInitiatorElement') return lassoManager.initiator;
      if (property === 'lassoInitiatorParentElement') return lassoInitiatorParentElement;
      if (property === 'keyMap') return _objectSpread2({}, keyMap);
      if (property === 'mouseMode') return mouseMode;
      if (property === 'opacity') return opacity.length === 1 ? opacity[0] : opacity;
      if (property === 'opacityBy') return opacityBy;
      if (property === 'opacityByDensityFill') return opacityByDensityFill;
      if (property === 'opacityByDensityDebounceTime') return opacityByDensityDebounceTime;
      if (property === 'points') return searchIndex.points;
      if (property === 'pointsInView') return getPointsInView();
      if (property === 'pointColor') return pointColor.length === 1 ? pointColor[0] : pointColor;
      if (property === 'pointColorActive') return pointColorActive.length === 1 ? pointColorActive[0] : pointColorActive;
      if (property === 'pointColorHover') return pointColorHover.length === 1 ? pointColorHover[0] : pointColorHover;
      if (property === 'pointOutlineWidth') return pointOutlineWidth;
      if (property === 'pointSize') return pointSize.length === 1 ? pointSize[0] : pointSize;
      if (property === 'pointSizeSelected') return pointSizeSelected;
      if (property === 'pointSizeMouseDetection') return pointSizeMouseDetection;
      if (property === 'showPointConnections') return showPointConnections;
      if (property === 'pointConnectionColor') return pointConnectionColor.length === 1 ? pointConnectionColor[0] : pointConnectionColor;
      if (property === 'pointConnectionColorActive') return pointConnectionColorActive.length === 1 ? pointConnectionColorActive[0] : pointConnectionColorActive;
      if (property === 'pointConnectionColorHover') return pointConnectionColorHover.length === 1 ? pointConnectionColorHover[0] : pointConnectionColorHover;
      if (property === 'pointConnectionColorBy') return pointConnectionColorBy;
      if (property === 'pointConnectionOpacity') return pointConnectionOpacity.length === 1 ? pointConnectionOpacity[0] : pointConnectionOpacity;
      if (property === 'pointConnectionOpacityBy') return pointConnectionOpacityBy;
      if (property === 'pointConnectionOpacityActive') return pointConnectionOpacityActive;
      if (property === 'pointConnectionSize') return pointConnectionSize.length === 1 ? pointConnectionSize[0] : pointConnectionSize;
      if (property === 'pointConnectionSizeActive') return pointConnectionSizeActive;
      if (property === 'pointConnectionSizeBy') return pointConnectionSizeBy;
      if (property === 'pointConnectionMaxIntPointsPerSegment') return pointConnectionMaxIntPointsPerSegment;
      if (property === 'pointConnectionTolerance') return pointConnectionTolerance;
      if (property === 'reticleColor') return reticleColor;
      if (property === 'regl') return renderer.regl;
      if (property === 'showReticle') return showReticle;
      if (property === 'version') return version;
      if (property === 'width') return width;
      if (property === 'xScale') return xScale;
      if (property === 'yScale') return yScale;
      if (property === 'performanceMode') return performanceMode;
      if (property === 'gamma') return renderer.gamma;
      if (property === 'renderer') return renderer;
      return undefined;
    };
    /** @type {(properties: Partial<import('./types').Settable>) => void} */


    var set = function set() {
      var properties = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      checkDeprecations(properties);

      if (properties.backgroundColor !== undefined || properties.background !== undefined) {
        setBackgroundColor(properties.backgroundColor || properties.background);
      }

      if (properties.backgroundImage !== undefined) {
        setBackgroundImage(properties.backgroundImage);
      }

      if (properties.cameraTarget !== undefined) {
        setCameraTarget(properties.cameraTarget);
      }

      if (properties.cameraDistance !== undefined) {
        setCameraDistance(properties.cameraDistance);
      }

      if (properties.cameraRotation !== undefined) {
        setCameraRotation(properties.cameraRotation);
      }

      if (properties.cameraView !== undefined) {
        setCameraView(properties.cameraView);
      }

      if (properties.colorBy !== undefined) {
        setColorBy(properties.colorBy);
      }

      if (properties.pointColor !== undefined) {
        setPointColor(properties.pointColor);
      }

      if (properties.pointColorActive !== undefined) {
        setPointColorActive(properties.pointColorActive);
      }

      if (properties.pointColorHover !== undefined) {
        setPointColorHover(properties.pointColorHover);
      }

      if (properties.pointSize !== undefined) {
        setPointSize(properties.pointSize);
      }

      if (properties.pointSizeSelected !== undefined) {
        setPointSizeSelected(properties.pointSizeSelected);
      }

      if (properties.pointSizeMouseDetection !== undefined) {
        setPointSizeMouseDetection(properties.pointSizeMouseDetection);
      }

      if (properties.sizeBy !== undefined) {
        setSizeBy(properties.sizeBy);
      }

      if (properties.opacity !== undefined) {
        setOpacity(properties.opacity);
      }

      if (properties.showPointConnections !== undefined) {
        setShowPointConnections(properties.showPointConnections);
      }

      if (properties.pointConnectionColor !== undefined) {
        setPointConnectionColor(properties.pointConnectionColor);
      }

      if (properties.pointConnectionColorActive !== undefined) {
        setPointConnectionColorActive(properties.pointConnectionColorActive);
      }

      if (properties.pointConnectionColorHover !== undefined) {
        setPointConnectionColorHover(properties.pointConnectionColorHover);
      }

      if (properties.pointConnectionColorBy !== undefined) {
        setPointConnectionColorBy(properties.pointConnectionColorBy);
      }

      if (properties.pointConnectionOpacityBy !== undefined) {
        setPointConnectionOpacityBy(properties.pointConnectionOpacityBy);
      }

      if (properties.pointConnectionOpacity !== undefined) {
        setPointConnectionOpacity(properties.pointConnectionOpacity);
      }

      if (properties.pointConnectionOpacityActive !== undefined) {
        setPointConnectionOpacityActive(properties.pointConnectionOpacityActive);
      }

      if (properties.pointConnectionSize !== undefined) {
        setPointConnectionSize(properties.pointConnectionSize);
      }

      if (properties.pointConnectionSizeActive !== undefined) {
        setPointConnectionSizeActive(properties.pointConnectionSizeActive);
      }

      if (properties.pointConnectionSizeBy !== undefined) {
        setPointConnectionSizeBy(properties.pointConnectionSizeBy);
      }

      if (properties.pointConnectionMaxIntPointsPerSegment !== undefined) {
        setPointConnectionMaxIntPointsPerSegment(properties.pointConnectionMaxIntPointsPerSegment);
      }

      if (properties.pointConnectionTolerance !== undefined) {
        setPointConnectionTolerance(properties.pointConnectionTolerance);
      }

      if (properties.opacityBy !== undefined) {
        setOpacityBy(properties.opacityBy);
      }

      if (properties.lassoColor !== undefined) {
        setLassoColor(properties.lassoColor);
      }

      if (properties.lassoLineWidth !== undefined) {
        setLassoLineWidth(properties.lassoLineWidth);
      }

      if (properties.lassoMinDelay !== undefined) {
        setLassoMinDelay(properties.lassoMinDelay);
      }

      if (properties.lassoMinDist !== undefined) {
        setLassoMinDist(properties.lassoMinDist);
      }

      if (properties.lassoClearEvent !== undefined) {
        setLassoClearEvent(properties.lassoClearEvent);
      }

      if (properties.lassoInitiator !== undefined) {
        setLassoInitiator(properties.lassoInitiator);
      }

      if (properties.lassoInitiatorParentElement !== undefined) {
        setLassoInitiatorParentElement(properties.lassoInitiatorParentElement);
      }

      if (properties.keyMap !== undefined) {
        setKeyMap(properties.keyMap);
      }

      if (properties.mouseMode !== undefined) {
        setMouseMode(properties.mouseMode);
      }

      if (properties.showReticle !== undefined) {
        setShowReticle(properties.showReticle);
      }

      if (properties.reticleColor !== undefined) {
        setReticleColor(properties.reticleColor);
      }

      if (properties.pointOutlineWidth !== undefined) {
        setPointOutlineWidth(properties.pointOutlineWidth);
      }

      if (properties.height !== undefined) {
        setHeight(properties.height);
      }

      if (properties.width !== undefined) {
        setWidth(properties.width);
      }

      if (properties.aspectRatio !== undefined) {
        setDataAspectRatio(properties.aspectRatio);
      }

      if (properties.xScale !== undefined) {
        setXScale(properties.xScale);
      }

      if (properties.yScale !== undefined) {
        setYScale(properties.yScale);
      }

      if (properties.deselectOnDblClick !== undefined) {
        setDeselectOnDblClick(properties.deselectOnDblClick);
      }

      if (properties.deselectOnEscape !== undefined) {
        setDeselectOnEscape(properties.deselectOnEscape);
      }

      if (properties.opacityByDensityFill !== undefined) {
        setOpacityByDensityFill(properties.opacityByDensityFill);
      }

      if (properties.gamma !== undefined) {
        setGamma(properties.gamma);
      } // setWidth and setHeight can be async when width or height are set to
      // 'auto'. And since draw() would have anyway been async we can just make
      // all calls async.


      return new Promise(function (resolve) {
        return window.requestAnimationFrame(function () {
          if (!canvas) return; // Instance was destroyed in between

          updateViewAspectRatio();
          camera.refresh();
          renderer.refresh();
          draw = true;
          resolve();
        });
      });
    };
    /**
     * @param {number[]} cameraView
     * @param {import('./types').ScatterplotMethodOptions['preventEvent']} options
     */


    var view = function view(cameraView) {
      var _ref20 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          _ref20$preventEvent = _ref20.preventEvent,
          preventEvent = _ref20$preventEvent === void 0 ? false : _ref20$preventEvent;

      setCameraView(cameraView);
      draw = true;
      preventEventView = preventEvent;
    };
    /**
     * @param {number | number[]} point
     * @param {import('./types').ScatterplotMethodOptions['hover']} options
     */


    var hover = function hover(point) {
      var _ref21 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          _ref21$showReticleOnc = _ref21.showReticleOnce,
          showReticleOnce = _ref21$showReticleOnc === void 0 ? false : _ref21$showReticleOnc,
          _ref21$preventEvent = _ref21.preventEvent,
          preventEvent = _ref21$preventEvent === void 0 ? false : _ref21$preventEvent;

      var needsRedraw = false;

      if (point >= 0 && point < numPoints) {
        needsRedraw = true;
        var oldHoveredPoint = hoveredPoint;
        var newHoveredPoint = point !== hoveredPoint;

        if (+oldHoveredPoint >= 0 && newHoveredPoint && !selectionSet.has(oldHoveredPoint)) {
          setPointConnectionColorState([oldHoveredPoint], 0);
        }

        hoveredPoint = point;
        hoveredPointIndexBuffer.subdata(indexToStateTexCoord(point));
        if (!selectionSet.has(point)) setPointConnectionColorState([point], 2);
        if (newHoveredPoint && !preventEvent) pubSub.publish('pointover', hoveredPoint);
      } else {
        needsRedraw = +hoveredPoint >= 0;

        if (needsRedraw) {
          if (!selectionSet.has(hoveredPoint)) {
            setPointConnectionColorState([hoveredPoint], 0);
          }

          if (!preventEvent) {
            pubSub.publish('pointout', hoveredPoint);
          }
        }

        hoveredPoint = undefined;
      }

      if (needsRedraw) {
        draw = true;
        drawReticleOnce = showReticleOnce;
      }
    };

    var initCamera = function initCamera() {
      if (!camera) camera = dom2dCamera(canvas, {
        isPanInverted: [false, true]
      });

      if (initialProperties.cameraView) {
        camera.setView(clone(initialProperties.cameraView));
      } else if (initialProperties.cameraTarget || initialProperties.cameraDistance || initialProperties.cameraRotation) {
        camera.lookAt(_toConsumableArray(initialProperties.cameraTarget || DEFAULT_TARGET), initialProperties.cameraDistance || DEFAULT_DISTANCE, initialProperties.cameraRotation || DEFAULT_ROTATION);
      } else {
        camera.setView(clone(DEFAULT_VIEW));
      }

      topRightNdc = getScatterGlPos(1, 1);
      bottomLeftNdc = getScatterGlPos(-1, -1);
    };
    /**
     * @param {import('./types').ScatterplotMethodOptions['preventEvent']} options
     */


    var reset = function reset() {
      var _ref22 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref22$preventEvent = _ref22.preventEvent,
          preventEvent = _ref22$preventEvent === void 0 ? false : _ref22$preventEvent;

      initCamera();
      updateScales();
      if (preventEvent) return;
      pubSub.publish('view', {
        view: camera.view,
        camera: camera,
        xScale: xScale,
        yScale: yScale
      });
    };

    var keyUpHandler = function keyUpHandler(_ref23) {
      var key = _ref23.key;

      switch (key) {
        case 'Escape':
          if (deselectOnEscape) deselect();
          break;

      }
    };

    var mouseEnterCanvasHandler = function mouseEnterCanvasHandler() {
      isMouseInCanvas = true;
    };

    var mouseLeaveCanvasHandler = function mouseLeaveCanvasHandler() {
      hover();
      isMouseInCanvas = false;
      draw = true;
    };

    var wheelHandler = function wheelHandler() {
      draw = true;
    };
    /** @type {() => void} */


    var clear = function clear() {
      setPoints([]);
      pointConnections.clear();
    };

    var resizeHandler = function resizeHandler() {
      camera.refresh();
      var autoWidth = width === AUTO;
      var autoHeight = height === AUTO;

      if (autoWidth || autoHeight) {
        var _canvas$getBoundingCl = canvas.getBoundingClientRect(),
            newWidth = _canvas$getBoundingCl.width,
            newHeight = _canvas$getBoundingCl.height;

        if (autoWidth) setCurrentWidth(newWidth);
        if (autoHeight) setCurrentHeight(newHeight);
        updateViewAspectRatio();
        draw = true;
      }
    };
    /** @type {() => ImageData} */


    var exportFn = function exportFn() {
      return canvas.getContext('2d').getImageData(0, 0, canvas.width, canvas.height);
    };

    var init = function init() {
      updateViewAspectRatio();
      initCamera();
      updateScales();
      lasso = createLine(renderer.regl, {
        color: lassoColor,
        width: lassoLineWidth,
        is2d: true
      });
      pointConnections = createLine(renderer.regl, {
        color: pointConnectionColor,
        colorHover: pointConnectionColorHover,
        colorActive: pointConnectionColorActive,
        opacity: pointConnectionOpacity === null ? null : pointConnectionOpacity[0],
        width: pointConnectionSize[0],
        widthActive: pointConnectionSizeActive,
        is2d: true
      });
      reticleHLine = createLine(renderer.regl, {
        color: reticleColor,
        width: 1,
        is2d: true
      });
      reticleVLine = createLine(renderer.regl, {
        color: reticleColor,
        width: 1,
        is2d: true
      });
      computePointSizeMouseDetection(); // Event listeners

      canvas.addEventListener('wheel', wheelHandler); // Buffers

      normalPointsIndexBuffer = renderer.regl.buffer();
      selectedPointsIndexBuffer = renderer.regl.buffer();
      hoveredPointIndexBuffer = renderer.regl.buffer({
        usage: 'dynamic',
        type: 'float',
        length: FLOAT_BYTES * 2 // This buffer is fixed to exactly 1 point consisting of 2 coordinates

      });
      colorTex = createColorTexture();
      encodingTex = createEncodingTexture(); // Set dimensions

      var whenSet = set({
        backgroundImage: backgroundImage,
        width: width,
        height: height,
        keyMap: keyMap
      });
      updateLassoInitiatorStyle(); // Setup event handler

      window.addEventListener('keyup', keyUpHandler, false);
      window.addEventListener('blur', blurHandler, false);
      window.addEventListener('mouseup', mouseUpHandler, false);
      window.addEventListener('mousemove', mouseMoveHandler, false);
      canvas.addEventListener('mousedown', mouseDownHandler, false);
      canvas.addEventListener('mouseenter', mouseEnterCanvasHandler, false);
      canvas.addEventListener('mouseleave', mouseLeaveCanvasHandler, false);
      canvas.addEventListener('click', mouseClickHandler, false);
      canvas.addEventListener('dblclick', mouseDblClickHandler, false);

      if ('ResizeObserver' in window) {
        canvasObserver = new ResizeObserver(resizeHandler);
        canvasObserver.observe(canvas);
      } else {
        window.addEventListener('resize', resizeHandler);
        window.addEventListener('orientationchange', resizeHandler);
      }

      whenSet.then(function () {
        pubSub.publish('init');
      });
    };

    var cancelFrameListener = renderer.onFrame(function () {
      // Update camera: this needs to happen on every
      isViewChanged = camera.tick();
      if (!isInit || !(draw || isTransitioning)) return;
      if (isTransitioning && !tween(transitionDuration, transitionEasing)) endTransition();

      if (isViewChanged) {
        topRightNdc = getScatterGlPos(1, 1);
        bottomLeftNdc = getScatterGlPos(-1, -1);
        if (opacityBy === 'density') getNumPointsInViewDb();
      }

      renderer.render(function (widthRatio, heightRatio) {
        updateProjectionMatrix(widthRatio, heightRatio); // eslint-disable-next-line no-underscore-dangle

        if (backgroundImage && backgroundImage._reglType) {
          drawBackgroundImage();
        }

        if (lassoPointsCurr.length > 2) drawPolygon2d(); // The draw order of the following calls is important!

        if (!isTransitioning) {
          pointConnections.draw({
            projection: getProjection(),
            model: getModel(),
            view: getView()
          });
        }

        drawPointBodies();
        if (!mouseDown && (showReticle || drawReticleOnce)) drawReticle();
        if (hoveredPoint >= 0) drawHoveredPoint();
        if (selection.length) drawSelectedPoints();
        lasso.draw({
          projection: getProjection(),
          model: getModel(),
          view: getView()
        });
      }, canvas); // Publish camera change

      if (isViewChanged) {
        updateScales();

        if (preventEventView) {
          preventEventView = false;
        } else {
          pubSub.publish('view', {
            view: camera.view,
            camera: camera,
            xScale: xScale,
            yScale: yScale
          });
        }
      }

      draw = false;
      drawReticleOnce = false;
      pubSub.publish('draw');
    });

    var redraw = function redraw() {
      draw = true;
    };

    var destroy = function destroy() {
      cancelFrameListener();
      window.removeEventListener('keyup', keyUpHandler, false);
      window.removeEventListener('blur', blurHandler, false);
      window.removeEventListener('mouseup', mouseUpHandler, false);
      window.removeEventListener('mousemove', mouseMoveHandler, false);
      canvas.removeEventListener('mousedown', mouseDownHandler, false);
      canvas.removeEventListener('mouseenter', mouseEnterCanvasHandler, false);
      canvas.removeEventListener('mouseleave', mouseLeaveCanvasHandler, false);
      canvas.removeEventListener('click', mouseClickHandler, false);
      canvas.removeEventListener('dblclick', mouseDblClickHandler, false);

      if (canvasObserver) {
        canvasObserver.disconnect();
      } else {
        window.removeEventListener('resize', resizeHandler);
        window.removeEventListener('orientationchange', resizeHandler);
      }

      canvas = undefined;
      camera.dispose();
      camera = undefined;
      lasso.destroy();
      pointConnections.destroy();
      reticleHLine.destroy();
      reticleVLine.destroy();
      pubSub.publish('destroy');
      pubSub.clear();

      if (!initialProperties.renderer) {
        // Since the user did not pass in an externally created renderer we can
        // assume that the renderer is only used by this scatter plot instance.
        // Therefore it's save to destroy it when this scatter plot instance is
        // destroyed.
        renderer.destroy();
      }
    };

    init();
    return {
      clear: withDraw(clear),
      createTextureFromUrl: function createTextureFromUrl$1(
      /** @type {string} */
      url) {
        return createTextureFromUrl(renderer.regl, url);
      },
      deselect: deselect,
      destroy: destroy,
      draw: publicDraw,
      get: get,
      hover: hover,
      redraw: redraw,
      refresh: renderer.refresh,
      reset: withDraw(reset),
      select: select,
      set: set,
      "export": exportFn,
      subscribe: pubSub.subscribe,
      unsubscribe: pubSub.unsubscribe,
      view: view
    };
  };

  exports.createRegl = createRegl;
  exports.createRenderer = createRenderer;
  exports.createTextureFromUrl = createTextureFromUrl;
  exports.default = createScatterplot;

  Object.defineProperty(exports, '__esModule', { value: true });

})));


/***/ }),

/***/ "./node_modules/regl/dist/regl.js":
/*!****************************************!*\
  !*** ./node_modules/regl/dist/regl.js ***!
  \****************************************/
/***/ (function(module) {

(function (global, factory) {
     true ? module.exports = factory() :
    0;
}(this, (function () { 'use strict';

var isTypedArray = function (x) {
  return (
    x instanceof Uint8Array ||
    x instanceof Uint16Array ||
    x instanceof Uint32Array ||
    x instanceof Int8Array ||
    x instanceof Int16Array ||
    x instanceof Int32Array ||
    x instanceof Float32Array ||
    x instanceof Float64Array ||
    x instanceof Uint8ClampedArray
  )
}

var extend = function (base, opts) {
  var keys = Object.keys(opts)
  for (var i = 0; i < keys.length; ++i) {
    base[keys[i]] = opts[keys[i]]
  }
  return base
}

// Error checking and parameter validation.
//
// Statements for the form `check.someProcedure(...)` get removed by
// a browserify transform for optimized/minified bundles.
//
/* globals atob */
var endl = '\n'

// only used for extracting shader names.  if atob not present, then errors
// will be slightly crappier
function decodeB64 (str) {
  if (typeof atob !== 'undefined') {
    return atob(str)
  }
  return 'base64:' + str
}

function raise (message) {
  var error = new Error('(regl) ' + message)
  console.error(error)
  throw error
}

function check (pred, message) {
  if (!pred) {
    raise(message)
  }
}

function encolon (message) {
  if (message) {
    return ': ' + message
  }
  return ''
}

function checkParameter (param, possibilities, message) {
  if (!(param in possibilities)) {
    raise('unknown parameter (' + param + ')' + encolon(message) +
          '. possible values: ' + Object.keys(possibilities).join())
  }
}

function checkIsTypedArray (data, message) {
  if (!isTypedArray(data)) {
    raise(
      'invalid parameter type' + encolon(message) +
      '. must be a typed array')
  }
}

function standardTypeEh (value, type) {
  switch (type) {
    case 'number': return typeof value === 'number'
    case 'object': return typeof value === 'object'
    case 'string': return typeof value === 'string'
    case 'boolean': return typeof value === 'boolean'
    case 'function': return typeof value === 'function'
    case 'undefined': return typeof value === 'undefined'
    case 'symbol': return typeof value === 'symbol'
  }
}

function checkTypeOf (value, type, message) {
  if (!standardTypeEh(value, type)) {
    raise(
      'invalid parameter type' + encolon(message) +
      '. expected ' + type + ', got ' + (typeof value))
  }
}

function checkNonNegativeInt (value, message) {
  if (!((value >= 0) &&
        ((value | 0) === value))) {
    raise('invalid parameter type, (' + value + ')' + encolon(message) +
          '. must be a nonnegative integer')
  }
}

function checkOneOf (value, list, message) {
  if (list.indexOf(value) < 0) {
    raise('invalid value' + encolon(message) + '. must be one of: ' + list)
  }
}

var constructorKeys = [
  'gl',
  'canvas',
  'container',
  'attributes',
  'pixelRatio',
  'extensions',
  'optionalExtensions',
  'profile',
  'onDone'
]

function checkConstructor (obj) {
  Object.keys(obj).forEach(function (key) {
    if (constructorKeys.indexOf(key) < 0) {
      raise('invalid regl constructor argument "' + key + '". must be one of ' + constructorKeys)
    }
  })
}

function leftPad (str, n) {
  str = str + ''
  while (str.length < n) {
    str = ' ' + str
  }
  return str
}

function ShaderFile () {
  this.name = 'unknown'
  this.lines = []
  this.index = {}
  this.hasErrors = false
}

function ShaderLine (number, line) {
  this.number = number
  this.line = line
  this.errors = []
}

function ShaderError (fileNumber, lineNumber, message) {
  this.file = fileNumber
  this.line = lineNumber
  this.message = message
}

function guessCommand () {
  var error = new Error()
  var stack = (error.stack || error).toString()
  var pat = /compileProcedure.*\n\s*at.*\((.*)\)/.exec(stack)
  if (pat) {
    return pat[1]
  }
  var pat2 = /compileProcedure.*\n\s*at\s+(.*)(\n|$)/.exec(stack)
  if (pat2) {
    return pat2[1]
  }
  return 'unknown'
}

function guessCallSite () {
  var error = new Error()
  var stack = (error.stack || error).toString()
  var pat = /at REGLCommand.*\n\s+at.*\((.*)\)/.exec(stack)
  if (pat) {
    return pat[1]
  }
  var pat2 = /at REGLCommand.*\n\s+at\s+(.*)\n/.exec(stack)
  if (pat2) {
    return pat2[1]
  }
  return 'unknown'
}

function parseSource (source, command) {
  var lines = source.split('\n')
  var lineNumber = 1
  var fileNumber = 0
  var files = {
    unknown: new ShaderFile(),
    0: new ShaderFile()
  }
  files.unknown.name = files[0].name = command || guessCommand()
  files.unknown.lines.push(new ShaderLine(0, ''))
  for (var i = 0; i < lines.length; ++i) {
    var line = lines[i]
    var parts = /^\s*#\s*(\w+)\s+(.+)\s*$/.exec(line)
    if (parts) {
      switch (parts[1]) {
        case 'line':
          var lineNumberInfo = /(\d+)(\s+\d+)?/.exec(parts[2])
          if (lineNumberInfo) {
            lineNumber = lineNumberInfo[1] | 0
            if (lineNumberInfo[2]) {
              fileNumber = lineNumberInfo[2] | 0
              if (!(fileNumber in files)) {
                files[fileNumber] = new ShaderFile()
              }
            }
          }
          break
        case 'define':
          var nameInfo = /SHADER_NAME(_B64)?\s+(.*)$/.exec(parts[2])
          if (nameInfo) {
            files[fileNumber].name = (nameInfo[1]
              ? decodeB64(nameInfo[2])
              : nameInfo[2])
          }
          break
      }
    }
    files[fileNumber].lines.push(new ShaderLine(lineNumber++, line))
  }
  Object.keys(files).forEach(function (fileNumber) {
    var file = files[fileNumber]
    file.lines.forEach(function (line) {
      file.index[line.number] = line
    })
  })
  return files
}

function parseErrorLog (errLog) {
  var result = []
  errLog.split('\n').forEach(function (errMsg) {
    if (errMsg.length < 5) {
      return
    }
    var parts = /^ERROR:\s+(\d+):(\d+):\s*(.*)$/.exec(errMsg)
    if (parts) {
      result.push(new ShaderError(
        parts[1] | 0,
        parts[2] | 0,
        parts[3].trim()))
    } else if (errMsg.length > 0) {
      result.push(new ShaderError('unknown', 0, errMsg))
    }
  })
  return result
}

function annotateFiles (files, errors) {
  errors.forEach(function (error) {
    var file = files[error.file]
    if (file) {
      var line = file.index[error.line]
      if (line) {
        line.errors.push(error)
        file.hasErrors = true
        return
      }
    }
    files.unknown.hasErrors = true
    files.unknown.lines[0].errors.push(error)
  })
}

function checkShaderError (gl, shader, source, type, command) {
  if (!gl.getShaderParameter(shader, gl.COMPILE_STATUS)) {
    var errLog = gl.getShaderInfoLog(shader)
    var typeName = type === gl.FRAGMENT_SHADER ? 'fragment' : 'vertex'
    checkCommandType(source, 'string', typeName + ' shader source must be a string', command)
    var files = parseSource(source, command)
    var errors = parseErrorLog(errLog)
    annotateFiles(files, errors)

    Object.keys(files).forEach(function (fileNumber) {
      var file = files[fileNumber]
      if (!file.hasErrors) {
        return
      }

      var strings = ['']
      var styles = ['']

      function push (str, style) {
        strings.push(str)
        styles.push(style || '')
      }

      push('file number ' + fileNumber + ': ' + file.name + '\n', 'color:red;text-decoration:underline;font-weight:bold')

      file.lines.forEach(function (line) {
        if (line.errors.length > 0) {
          push(leftPad(line.number, 4) + '|  ', 'background-color:yellow; font-weight:bold')
          push(line.line + endl, 'color:red; background-color:yellow; font-weight:bold')

          // try to guess token
          var offset = 0
          line.errors.forEach(function (error) {
            var message = error.message
            var token = /^\s*'(.*)'\s*:\s*(.*)$/.exec(message)
            if (token) {
              var tokenPat = token[1]
              message = token[2]
              switch (tokenPat) {
                case 'assign':
                  tokenPat = '='
                  break
              }
              offset = Math.max(line.line.indexOf(tokenPat, offset), 0)
            } else {
              offset = 0
            }

            push(leftPad('| ', 6))
            push(leftPad('^^^', offset + 3) + endl, 'font-weight:bold')
            push(leftPad('| ', 6))
            push(message + endl, 'font-weight:bold')
          })
          push(leftPad('| ', 6) + endl)
        } else {
          push(leftPad(line.number, 4) + '|  ')
          push(line.line + endl, 'color:red')
        }
      })
      if (typeof document !== 'undefined' && !window.chrome) {
        styles[0] = strings.join('%c')
        console.log.apply(console, styles)
      } else {
        console.log(strings.join(''))
      }
    })

    check.raise('Error compiling ' + typeName + ' shader, ' + files[0].name)
  }
}

function checkLinkError (gl, program, fragShader, vertShader, command) {
  if (!gl.getProgramParameter(program, gl.LINK_STATUS)) {
    var errLog = gl.getProgramInfoLog(program)
    var fragParse = parseSource(fragShader, command)
    var vertParse = parseSource(vertShader, command)

    var header = 'Error linking program with vertex shader, "' +
      vertParse[0].name + '", and fragment shader "' + fragParse[0].name + '"'

    if (typeof document !== 'undefined') {
      console.log('%c' + header + endl + '%c' + errLog,
        'color:red;text-decoration:underline;font-weight:bold',
        'color:red')
    } else {
      console.log(header + endl + errLog)
    }
    check.raise(header)
  }
}

function saveCommandRef (object) {
  object._commandRef = guessCommand()
}

function saveDrawCommandInfo (opts, uniforms, attributes, stringStore) {
  saveCommandRef(opts)

  function id (str) {
    if (str) {
      return stringStore.id(str)
    }
    return 0
  }
  opts._fragId = id(opts.static.frag)
  opts._vertId = id(opts.static.vert)

  function addProps (dict, set) {
    Object.keys(set).forEach(function (u) {
      dict[stringStore.id(u)] = true
    })
  }

  var uniformSet = opts._uniformSet = {}
  addProps(uniformSet, uniforms.static)
  addProps(uniformSet, uniforms.dynamic)

  var attributeSet = opts._attributeSet = {}
  addProps(attributeSet, attributes.static)
  addProps(attributeSet, attributes.dynamic)

  opts._hasCount = (
    'count' in opts.static ||
    'count' in opts.dynamic ||
    'elements' in opts.static ||
    'elements' in opts.dynamic)
}

function commandRaise (message, command) {
  var callSite = guessCallSite()
  raise(message +
    ' in command ' + (command || guessCommand()) +
    (callSite === 'unknown' ? '' : ' called from ' + callSite))
}

function checkCommand (pred, message, command) {
  if (!pred) {
    commandRaise(message, command || guessCommand())
  }
}

function checkParameterCommand (param, possibilities, message, command) {
  if (!(param in possibilities)) {
    commandRaise(
      'unknown parameter (' + param + ')' + encolon(message) +
      '. possible values: ' + Object.keys(possibilities).join(),
      command || guessCommand())
  }
}

function checkCommandType (value, type, message, command) {
  if (!standardTypeEh(value, type)) {
    commandRaise(
      'invalid parameter type' + encolon(message) +
      '. expected ' + type + ', got ' + (typeof value),
      command || guessCommand())
  }
}

function checkOptional (block) {
  block()
}

function checkFramebufferFormat (attachment, texFormats, rbFormats) {
  if (attachment.texture) {
    checkOneOf(
      attachment.texture._texture.internalformat,
      texFormats,
      'unsupported texture format for attachment')
  } else {
    checkOneOf(
      attachment.renderbuffer._renderbuffer.format,
      rbFormats,
      'unsupported renderbuffer format for attachment')
  }
}

var GL_CLAMP_TO_EDGE = 0x812F

var GL_NEAREST = 0x2600
var GL_NEAREST_MIPMAP_NEAREST = 0x2700
var GL_LINEAR_MIPMAP_NEAREST = 0x2701
var GL_NEAREST_MIPMAP_LINEAR = 0x2702
var GL_LINEAR_MIPMAP_LINEAR = 0x2703

var GL_BYTE = 5120
var GL_UNSIGNED_BYTE = 5121
var GL_SHORT = 5122
var GL_UNSIGNED_SHORT = 5123
var GL_INT = 5124
var GL_UNSIGNED_INT = 5125
var GL_FLOAT = 5126

var GL_UNSIGNED_SHORT_4_4_4_4 = 0x8033
var GL_UNSIGNED_SHORT_5_5_5_1 = 0x8034
var GL_UNSIGNED_SHORT_5_6_5 = 0x8363
var GL_UNSIGNED_INT_24_8_WEBGL = 0x84FA

var GL_HALF_FLOAT_OES = 0x8D61

var TYPE_SIZE = {}

TYPE_SIZE[GL_BYTE] =
TYPE_SIZE[GL_UNSIGNED_BYTE] = 1

TYPE_SIZE[GL_SHORT] =
TYPE_SIZE[GL_UNSIGNED_SHORT] =
TYPE_SIZE[GL_HALF_FLOAT_OES] =
TYPE_SIZE[GL_UNSIGNED_SHORT_5_6_5] =
TYPE_SIZE[GL_UNSIGNED_SHORT_4_4_4_4] =
TYPE_SIZE[GL_UNSIGNED_SHORT_5_5_5_1] = 2

TYPE_SIZE[GL_INT] =
TYPE_SIZE[GL_UNSIGNED_INT] =
TYPE_SIZE[GL_FLOAT] =
TYPE_SIZE[GL_UNSIGNED_INT_24_8_WEBGL] = 4

function pixelSize (type, channels) {
  if (type === GL_UNSIGNED_SHORT_5_5_5_1 ||
      type === GL_UNSIGNED_SHORT_4_4_4_4 ||
      type === GL_UNSIGNED_SHORT_5_6_5) {
    return 2
  } else if (type === GL_UNSIGNED_INT_24_8_WEBGL) {
    return 4
  } else {
    return TYPE_SIZE[type] * channels
  }
}

function isPow2 (v) {
  return !(v & (v - 1)) && (!!v)
}

function checkTexture2D (info, mipData, limits) {
  var i
  var w = mipData.width
  var h = mipData.height
  var c = mipData.channels

  // Check texture shape
  check(w > 0 && w <= limits.maxTextureSize &&
        h > 0 && h <= limits.maxTextureSize,
  'invalid texture shape')

  // check wrap mode
  if (info.wrapS !== GL_CLAMP_TO_EDGE || info.wrapT !== GL_CLAMP_TO_EDGE) {
    check(isPow2(w) && isPow2(h),
      'incompatible wrap mode for texture, both width and height must be power of 2')
  }

  if (mipData.mipmask === 1) {
    if (w !== 1 && h !== 1) {
      check(
        info.minFilter !== GL_NEAREST_MIPMAP_NEAREST &&
        info.minFilter !== GL_NEAREST_MIPMAP_LINEAR &&
        info.minFilter !== GL_LINEAR_MIPMAP_NEAREST &&
        info.minFilter !== GL_LINEAR_MIPMAP_LINEAR,
        'min filter requires mipmap')
    }
  } else {
    // texture must be power of 2
    check(isPow2(w) && isPow2(h),
      'texture must be a square power of 2 to support mipmapping')
    check(mipData.mipmask === (w << 1) - 1,
      'missing or incomplete mipmap data')
  }

  if (mipData.type === GL_FLOAT) {
    if (limits.extensions.indexOf('oes_texture_float_linear') < 0) {
      check(info.minFilter === GL_NEAREST && info.magFilter === GL_NEAREST,
        'filter not supported, must enable oes_texture_float_linear')
    }
    check(!info.genMipmaps,
      'mipmap generation not supported with float textures')
  }

  // check image complete
  var mipimages = mipData.images
  for (i = 0; i < 16; ++i) {
    if (mipimages[i]) {
      var mw = w >> i
      var mh = h >> i
      check(mipData.mipmask & (1 << i), 'missing mipmap data')

      var img = mipimages[i]

      check(
        img.width === mw &&
        img.height === mh,
        'invalid shape for mip images')

      check(
        img.format === mipData.format &&
        img.internalformat === mipData.internalformat &&
        img.type === mipData.type,
        'incompatible type for mip image')

      if (img.compressed) {
        // TODO: check size for compressed images
      } else if (img.data) {
        // check(img.data.byteLength === mw * mh *
        // Math.max(pixelSize(img.type, c), img.unpackAlignment),
        var rowSize = Math.ceil(pixelSize(img.type, c) * mw / img.unpackAlignment) * img.unpackAlignment
        check(img.data.byteLength === rowSize * mh,
          'invalid data for image, buffer size is inconsistent with image format')
      } else if (img.element) {
        // TODO: check element can be loaded
      } else if (img.copy) {
        // TODO: check compatible format and type
      }
    } else if (!info.genMipmaps) {
      check((mipData.mipmask & (1 << i)) === 0, 'extra mipmap data')
    }
  }

  if (mipData.compressed) {
    check(!info.genMipmaps,
      'mipmap generation for compressed images not supported')
  }
}

function checkTextureCube (texture, info, faces, limits) {
  var w = texture.width
  var h = texture.height
  var c = texture.channels

  // Check texture shape
  check(
    w > 0 && w <= limits.maxTextureSize && h > 0 && h <= limits.maxTextureSize,
    'invalid texture shape')
  check(
    w === h,
    'cube map must be square')
  check(
    info.wrapS === GL_CLAMP_TO_EDGE && info.wrapT === GL_CLAMP_TO_EDGE,
    'wrap mode not supported by cube map')

  for (var i = 0; i < faces.length; ++i) {
    var face = faces[i]
    check(
      face.width === w && face.height === h,
      'inconsistent cube map face shape')

    if (info.genMipmaps) {
      check(!face.compressed,
        'can not generate mipmap for compressed textures')
      check(face.mipmask === 1,
        'can not specify mipmaps and generate mipmaps')
    } else {
      // TODO: check mip and filter mode
    }

    var mipmaps = face.images
    for (var j = 0; j < 16; ++j) {
      var img = mipmaps[j]
      if (img) {
        var mw = w >> j
        var mh = h >> j
        check(face.mipmask & (1 << j), 'missing mipmap data')
        check(
          img.width === mw &&
          img.height === mh,
          'invalid shape for mip images')
        check(
          img.format === texture.format &&
          img.internalformat === texture.internalformat &&
          img.type === texture.type,
          'incompatible type for mip image')

        if (img.compressed) {
          // TODO: check size for compressed images
        } else if (img.data) {
          check(img.data.byteLength === mw * mh *
            Math.max(pixelSize(img.type, c), img.unpackAlignment),
          'invalid data for image, buffer size is inconsistent with image format')
        } else if (img.element) {
          // TODO: check element can be loaded
        } else if (img.copy) {
          // TODO: check compatible format and type
        }
      }
    }
  }
}

var check$1 = extend(check, {
  optional: checkOptional,
  raise: raise,
  commandRaise: commandRaise,
  command: checkCommand,
  parameter: checkParameter,
  commandParameter: checkParameterCommand,
  constructor: checkConstructor,
  type: checkTypeOf,
  commandType: checkCommandType,
  isTypedArray: checkIsTypedArray,
  nni: checkNonNegativeInt,
  oneOf: checkOneOf,
  shaderError: checkShaderError,
  linkError: checkLinkError,
  callSite: guessCallSite,
  saveCommandRef: saveCommandRef,
  saveDrawInfo: saveDrawCommandInfo,
  framebufferFormat: checkFramebufferFormat,
  guessCommand: guessCommand,
  texture2D: checkTexture2D,
  textureCube: checkTextureCube
});

var VARIABLE_COUNTER = 0

var DYN_FUNC = 0
var DYN_CONSTANT = 5
var DYN_ARRAY = 6

function DynamicVariable (type, data) {
  this.id = (VARIABLE_COUNTER++)
  this.type = type
  this.data = data
}

function escapeStr (str) {
  return str.replace(/\\/g, '\\\\').replace(/"/g, '\\"')
}

function splitParts (str) {
  if (str.length === 0) {
    return []
  }

  var firstChar = str.charAt(0)
  var lastChar = str.charAt(str.length - 1)

  if (str.length > 1 &&
      firstChar === lastChar &&
      (firstChar === '"' || firstChar === "'")) {
    return ['"' + escapeStr(str.substr(1, str.length - 2)) + '"']
  }

  var parts = /\[(false|true|null|\d+|'[^']*'|"[^"]*")\]/.exec(str)
  if (parts) {
    return (
      splitParts(str.substr(0, parts.index))
        .concat(splitParts(parts[1]))
        .concat(splitParts(str.substr(parts.index + parts[0].length)))
    )
  }

  var subparts = str.split('.')
  if (subparts.length === 1) {
    return ['"' + escapeStr(str) + '"']
  }

  var result = []
  for (var i = 0; i < subparts.length; ++i) {
    result = result.concat(splitParts(subparts[i]))
  }
  return result
}

function toAccessorString (str) {
  return '[' + splitParts(str).join('][') + ']'
}

function defineDynamic (type, data) {
  return new DynamicVariable(type, toAccessorString(data + ''))
}

function isDynamic (x) {
  return (typeof x === 'function' && !x._reglType) || (x instanceof DynamicVariable)
}

function unbox (x, path) {
  if (typeof x === 'function') {
    return new DynamicVariable(DYN_FUNC, x)
  } else if (typeof x === 'number' || typeof x === 'boolean') {
    return new DynamicVariable(DYN_CONSTANT, x)
  } else if (Array.isArray(x)) {
    return new DynamicVariable(DYN_ARRAY, x.map(function (y, i) { return unbox(y, path + '[' + i + ']') }))
  } else if (x instanceof DynamicVariable) {
    return x
  }
  check$1(false, 'invalid option type in uniform ' + path)
}

var dynamic = {
  DynamicVariable: DynamicVariable,
  define: defineDynamic,
  isDynamic: isDynamic,
  unbox: unbox,
  accessor: toAccessorString
};

/* globals requestAnimationFrame, cancelAnimationFrame */
var raf = {
  next: typeof requestAnimationFrame === 'function'
    ? function (cb) { return requestAnimationFrame(cb) }
    : function (cb) { return setTimeout(cb, 16) },
  cancel: typeof cancelAnimationFrame === 'function'
    ? function (raf) { return cancelAnimationFrame(raf) }
    : clearTimeout
};

/* globals performance */
var clock = (typeof performance !== 'undefined' && performance.now)
    ? function () { return performance.now() }
    : function () { return +(new Date()) };

function createStringStore () {
  var stringIds = { '': 0 }
  var stringValues = ['']
  return {
    id: function (str) {
      var result = stringIds[str]
      if (result) {
        return result
      }
      result = stringIds[str] = stringValues.length
      stringValues.push(str)
      return result
    },

    str: function (id) {
      return stringValues[id]
    }
  }
}

// Context and canvas creation helper functions
function createCanvas (element, onDone, pixelRatio) {
  var canvas = document.createElement('canvas')
  extend(canvas.style, {
    border: 0,
    margin: 0,
    padding: 0,
    top: 0,
    left: 0,
    width: '100%',
    height: '100%'
  })
  element.appendChild(canvas)

  if (element === document.body) {
    canvas.style.position = 'absolute'
    extend(element.style, {
      margin: 0,
      padding: 0
    })
  }

  function resize () {
    var w = window.innerWidth
    var h = window.innerHeight
    if (element !== document.body) {
      var bounds = canvas.getBoundingClientRect()
      w = bounds.right - bounds.left
      h = bounds.bottom - bounds.top
    }
    canvas.width = pixelRatio * w
    canvas.height = pixelRatio * h
  }

  var resizeObserver
  if (element !== document.body && typeof ResizeObserver === 'function') {
    // ignore 'ResizeObserver' is not defined
    // eslint-disable-next-line
    resizeObserver = new ResizeObserver(function () {
      // setTimeout to avoid flicker
      setTimeout(resize)
    })
    resizeObserver.observe(element)
  } else {
    window.addEventListener('resize', resize, false)
  }

  function onDestroy () {
    if (resizeObserver) {
      resizeObserver.disconnect()
    } else {
      window.removeEventListener('resize', resize)
    }
    element.removeChild(canvas)
  }

  resize()

  return {
    canvas: canvas,
    onDestroy: onDestroy
  }
}

function createContext (canvas, contextAttributes) {
  function get (name) {
    try {
      return canvas.getContext(name, contextAttributes)
    } catch (e) {
      return null
    }
  }
  return (
    get('webgl') ||
    get('experimental-webgl') ||
    get('webgl-experimental')
  )
}

function isHTMLElement (obj) {
  return (
    typeof obj.nodeName === 'string' &&
    typeof obj.appendChild === 'function' &&
    typeof obj.getBoundingClientRect === 'function'
  )
}

function isWebGLContext (obj) {
  return (
    typeof obj.drawArrays === 'function' ||
    typeof obj.drawElements === 'function'
  )
}

function parseExtensions (input) {
  if (typeof input === 'string') {
    return input.split()
  }
  check$1(Array.isArray(input), 'invalid extension array')
  return input
}

function getElement (desc) {
  if (typeof desc === 'string') {
    check$1(typeof document !== 'undefined', 'not supported outside of DOM')
    return document.querySelector(desc)
  }
  return desc
}

function parseArgs (args_) {
  var args = args_ || {}
  var element, container, canvas, gl
  var contextAttributes = {}
  var extensions = []
  var optionalExtensions = []
  var pixelRatio = (typeof window === 'undefined' ? 1 : window.devicePixelRatio)
  var profile = false
  var onDone = function (err) {
    if (err) {
      check$1.raise(err)
    }
  }
  var onDestroy = function () {}
  if (typeof args === 'string') {
    check$1(
      typeof document !== 'undefined',
      'selector queries only supported in DOM enviroments')
    element = document.querySelector(args)
    check$1(element, 'invalid query string for element')
  } else if (typeof args === 'object') {
    if (isHTMLElement(args)) {
      element = args
    } else if (isWebGLContext(args)) {
      gl = args
      canvas = gl.canvas
    } else {
      check$1.constructor(args)
      if ('gl' in args) {
        gl = args.gl
      } else if ('canvas' in args) {
        canvas = getElement(args.canvas)
      } else if ('container' in args) {
        container = getElement(args.container)
      }
      if ('attributes' in args) {
        contextAttributes = args.attributes
        check$1.type(contextAttributes, 'object', 'invalid context attributes')
      }
      if ('extensions' in args) {
        extensions = parseExtensions(args.extensions)
      }
      if ('optionalExtensions' in args) {
        optionalExtensions = parseExtensions(args.optionalExtensions)
      }
      if ('onDone' in args) {
        check$1.type(
          args.onDone, 'function',
          'invalid or missing onDone callback')
        onDone = args.onDone
      }
      if ('profile' in args) {
        profile = !!args.profile
      }
      if ('pixelRatio' in args) {
        pixelRatio = +args.pixelRatio
        check$1(pixelRatio > 0, 'invalid pixel ratio')
      }
    }
  } else {
    check$1.raise('invalid arguments to regl')
  }

  if (element) {
    if (element.nodeName.toLowerCase() === 'canvas') {
      canvas = element
    } else {
      container = element
    }
  }

  if (!gl) {
    if (!canvas) {
      check$1(
        typeof document !== 'undefined',
        'must manually specify webgl context outside of DOM environments')
      var result = createCanvas(container || document.body, onDone, pixelRatio)
      if (!result) {
        return null
      }
      canvas = result.canvas
      onDestroy = result.onDestroy
    }
    // workaround for chromium bug, premultiplied alpha value is platform dependent
    if (contextAttributes.premultipliedAlpha === undefined) contextAttributes.premultipliedAlpha = true
    gl = createContext(canvas, contextAttributes)
  }

  if (!gl) {
    onDestroy()
    onDone('webgl not supported, try upgrading your browser or graphics drivers http://get.webgl.org')
    return null
  }

  return {
    gl: gl,
    canvas: canvas,
    container: container,
    extensions: extensions,
    optionalExtensions: optionalExtensions,
    pixelRatio: pixelRatio,
    profile: profile,
    onDone: onDone,
    onDestroy: onDestroy
  }
}

function createExtensionCache (gl, config) {
  var extensions = {}

  function tryLoadExtension (name_) {
    check$1.type(name_, 'string', 'extension name must be string')
    var name = name_.toLowerCase()
    var ext
    try {
      ext = extensions[name] = gl.getExtension(name)
    } catch (e) {}
    return !!ext
  }

  for (var i = 0; i < config.extensions.length; ++i) {
    var name = config.extensions[i]
    if (!tryLoadExtension(name)) {
      config.onDestroy()
      config.onDone('"' + name + '" extension is not supported by the current WebGL context, try upgrading your system or a different browser')
      return null
    }
  }

  config.optionalExtensions.forEach(tryLoadExtension)

  return {
    extensions: extensions,
    restore: function () {
      Object.keys(extensions).forEach(function (name) {
        if (extensions[name] && !tryLoadExtension(name)) {
          throw new Error('(regl): error restoring extension ' + name)
        }
      })
    }
  }
}

function loop (n, f) {
  var result = Array(n)
  for (var i = 0; i < n; ++i) {
    result[i] = f(i)
  }
  return result
}

var GL_BYTE$1 = 5120
var GL_UNSIGNED_BYTE$2 = 5121
var GL_SHORT$1 = 5122
var GL_UNSIGNED_SHORT$1 = 5123
var GL_INT$1 = 5124
var GL_UNSIGNED_INT$1 = 5125
var GL_FLOAT$2 = 5126

function nextPow16 (v) {
  for (var i = 16; i <= (1 << 28); i *= 16) {
    if (v <= i) {
      return i
    }
  }
  return 0
}

function log2 (v) {
  var r, shift
  r = (v > 0xFFFF) << 4
  v >>>= r
  shift = (v > 0xFF) << 3
  v >>>= shift; r |= shift
  shift = (v > 0xF) << 2
  v >>>= shift; r |= shift
  shift = (v > 0x3) << 1
  v >>>= shift; r |= shift
  return r | (v >> 1)
}

function createPool () {
  var bufferPool = loop(8, function () {
    return []
  })

  function alloc (n) {
    var sz = nextPow16(n)
    var bin = bufferPool[log2(sz) >> 2]
    if (bin.length > 0) {
      return bin.pop()
    }
    return new ArrayBuffer(sz)
  }

  function free (buf) {
    bufferPool[log2(buf.byteLength) >> 2].push(buf)
  }

  function allocType (type, n) {
    var result = null
    switch (type) {
      case GL_BYTE$1:
        result = new Int8Array(alloc(n), 0, n)
        break
      case GL_UNSIGNED_BYTE$2:
        result = new Uint8Array(alloc(n), 0, n)
        break
      case GL_SHORT$1:
        result = new Int16Array(alloc(2 * n), 0, n)
        break
      case GL_UNSIGNED_SHORT$1:
        result = new Uint16Array(alloc(2 * n), 0, n)
        break
      case GL_INT$1:
        result = new Int32Array(alloc(4 * n), 0, n)
        break
      case GL_UNSIGNED_INT$1:
        result = new Uint32Array(alloc(4 * n), 0, n)
        break
      case GL_FLOAT$2:
        result = new Float32Array(alloc(4 * n), 0, n)
        break
      default:
        return null
    }
    if (result.length !== n) {
      return result.subarray(0, n)
    }
    return result
  }

  function freeType (array) {
    free(array.buffer)
  }

  return {
    alloc: alloc,
    free: free,
    allocType: allocType,
    freeType: freeType
  }
}

var pool = createPool()

// zero pool for initial zero data
pool.zero = createPool()

var GL_SUBPIXEL_BITS = 0x0D50
var GL_RED_BITS = 0x0D52
var GL_GREEN_BITS = 0x0D53
var GL_BLUE_BITS = 0x0D54
var GL_ALPHA_BITS = 0x0D55
var GL_DEPTH_BITS = 0x0D56
var GL_STENCIL_BITS = 0x0D57

var GL_ALIASED_POINT_SIZE_RANGE = 0x846D
var GL_ALIASED_LINE_WIDTH_RANGE = 0x846E

var GL_MAX_TEXTURE_SIZE = 0x0D33
var GL_MAX_VIEWPORT_DIMS = 0x0D3A
var GL_MAX_VERTEX_ATTRIBS = 0x8869
var GL_MAX_VERTEX_UNIFORM_VECTORS = 0x8DFB
var GL_MAX_VARYING_VECTORS = 0x8DFC
var GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS = 0x8B4D
var GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS = 0x8B4C
var GL_MAX_TEXTURE_IMAGE_UNITS = 0x8872
var GL_MAX_FRAGMENT_UNIFORM_VECTORS = 0x8DFD
var GL_MAX_CUBE_MAP_TEXTURE_SIZE = 0x851C
var GL_MAX_RENDERBUFFER_SIZE = 0x84E8

var GL_VENDOR = 0x1F00
var GL_RENDERER = 0x1F01
var GL_VERSION = 0x1F02
var GL_SHADING_LANGUAGE_VERSION = 0x8B8C

var GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT = 0x84FF

var GL_MAX_COLOR_ATTACHMENTS_WEBGL = 0x8CDF
var GL_MAX_DRAW_BUFFERS_WEBGL = 0x8824

var GL_TEXTURE_2D = 0x0DE1
var GL_TEXTURE_CUBE_MAP = 0x8513
var GL_TEXTURE_CUBE_MAP_POSITIVE_X = 0x8515
var GL_TEXTURE0 = 0x84C0
var GL_RGBA = 0x1908
var GL_FLOAT$1 = 0x1406
var GL_UNSIGNED_BYTE$1 = 0x1401
var GL_FRAMEBUFFER = 0x8D40
var GL_FRAMEBUFFER_COMPLETE = 0x8CD5
var GL_COLOR_ATTACHMENT0 = 0x8CE0
var GL_COLOR_BUFFER_BIT$1 = 0x4000

var wrapLimits = function (gl, extensions) {
  var maxAnisotropic = 1
  if (extensions.ext_texture_filter_anisotropic) {
    maxAnisotropic = gl.getParameter(GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT)
  }

  var maxDrawbuffers = 1
  var maxColorAttachments = 1
  if (extensions.webgl_draw_buffers) {
    maxDrawbuffers = gl.getParameter(GL_MAX_DRAW_BUFFERS_WEBGL)
    maxColorAttachments = gl.getParameter(GL_MAX_COLOR_ATTACHMENTS_WEBGL)
  }

  // detect if reading float textures is available (Safari doesn't support)
  var readFloat = !!extensions.oes_texture_float
  if (readFloat) {
    var readFloatTexture = gl.createTexture()
    gl.bindTexture(GL_TEXTURE_2D, readFloatTexture)
    gl.texImage2D(GL_TEXTURE_2D, 0, GL_RGBA, 1, 1, 0, GL_RGBA, GL_FLOAT$1, null)

    var fbo = gl.createFramebuffer()
    gl.bindFramebuffer(GL_FRAMEBUFFER, fbo)
    gl.framebufferTexture2D(GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT0, GL_TEXTURE_2D, readFloatTexture, 0)
    gl.bindTexture(GL_TEXTURE_2D, null)

    if (gl.checkFramebufferStatus(GL_FRAMEBUFFER) !== GL_FRAMEBUFFER_COMPLETE) readFloat = false

    else {
      gl.viewport(0, 0, 1, 1)
      gl.clearColor(1.0, 0.0, 0.0, 1.0)
      gl.clear(GL_COLOR_BUFFER_BIT$1)
      var pixels = pool.allocType(GL_FLOAT$1, 4)
      gl.readPixels(0, 0, 1, 1, GL_RGBA, GL_FLOAT$1, pixels)

      if (gl.getError()) readFloat = false
      else {
        gl.deleteFramebuffer(fbo)
        gl.deleteTexture(readFloatTexture)

        readFloat = pixels[0] === 1.0
      }

      pool.freeType(pixels)
    }
  }

  // detect non power of two cube textures support (IE doesn't support)
  var isIE = typeof navigator !== 'undefined' && (/MSIE/.test(navigator.userAgent) || /Trident\//.test(navigator.appVersion) || /Edge/.test(navigator.userAgent))

  var npotTextureCube = true

  if (!isIE) {
    var cubeTexture = gl.createTexture()
    var data = pool.allocType(GL_UNSIGNED_BYTE$1, 36)
    gl.activeTexture(GL_TEXTURE0)
    gl.bindTexture(GL_TEXTURE_CUBE_MAP, cubeTexture)
    gl.texImage2D(GL_TEXTURE_CUBE_MAP_POSITIVE_X, 0, GL_RGBA, 3, 3, 0, GL_RGBA, GL_UNSIGNED_BYTE$1, data)
    pool.freeType(data)
    gl.bindTexture(GL_TEXTURE_CUBE_MAP, null)
    gl.deleteTexture(cubeTexture)
    npotTextureCube = !gl.getError()
  }

  return {
    // drawing buffer bit depth
    colorBits: [
      gl.getParameter(GL_RED_BITS),
      gl.getParameter(GL_GREEN_BITS),
      gl.getParameter(GL_BLUE_BITS),
      gl.getParameter(GL_ALPHA_BITS)
    ],
    depthBits: gl.getParameter(GL_DEPTH_BITS),
    stencilBits: gl.getParameter(GL_STENCIL_BITS),
    subpixelBits: gl.getParameter(GL_SUBPIXEL_BITS),

    // supported extensions
    extensions: Object.keys(extensions).filter(function (ext) {
      return !!extensions[ext]
    }),

    // max aniso samples
    maxAnisotropic: maxAnisotropic,

    // max draw buffers
    maxDrawbuffers: maxDrawbuffers,
    maxColorAttachments: maxColorAttachments,

    // point and line size ranges
    pointSizeDims: gl.getParameter(GL_ALIASED_POINT_SIZE_RANGE),
    lineWidthDims: gl.getParameter(GL_ALIASED_LINE_WIDTH_RANGE),
    maxViewportDims: gl.getParameter(GL_MAX_VIEWPORT_DIMS),
    maxCombinedTextureUnits: gl.getParameter(GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS),
    maxCubeMapSize: gl.getParameter(GL_MAX_CUBE_MAP_TEXTURE_SIZE),
    maxRenderbufferSize: gl.getParameter(GL_MAX_RENDERBUFFER_SIZE),
    maxTextureUnits: gl.getParameter(GL_MAX_TEXTURE_IMAGE_UNITS),
    maxTextureSize: gl.getParameter(GL_MAX_TEXTURE_SIZE),
    maxAttributes: gl.getParameter(GL_MAX_VERTEX_ATTRIBS),
    maxVertexUniforms: gl.getParameter(GL_MAX_VERTEX_UNIFORM_VECTORS),
    maxVertexTextureUnits: gl.getParameter(GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS),
    maxVaryingVectors: gl.getParameter(GL_MAX_VARYING_VECTORS),
    maxFragmentUniforms: gl.getParameter(GL_MAX_FRAGMENT_UNIFORM_VECTORS),

    // vendor info
    glsl: gl.getParameter(GL_SHADING_LANGUAGE_VERSION),
    renderer: gl.getParameter(GL_RENDERER),
    vendor: gl.getParameter(GL_VENDOR),
    version: gl.getParameter(GL_VERSION),

    // quirks
    readFloat: readFloat,
    npotTextureCube: npotTextureCube
  }
}

function isNDArrayLike (obj) {
  return (
    !!obj &&
    typeof obj === 'object' &&
    Array.isArray(obj.shape) &&
    Array.isArray(obj.stride) &&
    typeof obj.offset === 'number' &&
    obj.shape.length === obj.stride.length &&
    (Array.isArray(obj.data) ||
      isTypedArray(obj.data)))
}

var values = function (obj) {
  return Object.keys(obj).map(function (key) { return obj[key] })
}

var flattenUtils = {
  shape: arrayShape$1,
  flatten: flattenArray
};

function flatten1D (array, nx, out) {
  for (var i = 0; i < nx; ++i) {
    out[i] = array[i]
  }
}

function flatten2D (array, nx, ny, out) {
  var ptr = 0
  for (var i = 0; i < nx; ++i) {
    var row = array[i]
    for (var j = 0; j < ny; ++j) {
      out[ptr++] = row[j]
    }
  }
}

function flatten3D (array, nx, ny, nz, out, ptr_) {
  var ptr = ptr_
  for (var i = 0; i < nx; ++i) {
    var row = array[i]
    for (var j = 0; j < ny; ++j) {
      var col = row[j]
      for (var k = 0; k < nz; ++k) {
        out[ptr++] = col[k]
      }
    }
  }
}

function flattenRec (array, shape, level, out, ptr) {
  var stride = 1
  for (var i = level + 1; i < shape.length; ++i) {
    stride *= shape[i]
  }
  var n = shape[level]
  if (shape.length - level === 4) {
    var nx = shape[level + 1]
    var ny = shape[level + 2]
    var nz = shape[level + 3]
    for (i = 0; i < n; ++i) {
      flatten3D(array[i], nx, ny, nz, out, ptr)
      ptr += stride
    }
  } else {
    for (i = 0; i < n; ++i) {
      flattenRec(array[i], shape, level + 1, out, ptr)
      ptr += stride
    }
  }
}

function flattenArray (array, shape, type, out_) {
  var sz = 1
  if (shape.length) {
    for (var i = 0; i < shape.length; ++i) {
      sz *= shape[i]
    }
  } else {
    sz = 0
  }
  var out = out_ || pool.allocType(type, sz)
  switch (shape.length) {
    case 0:
      break
    case 1:
      flatten1D(array, shape[0], out)
      break
    case 2:
      flatten2D(array, shape[0], shape[1], out)
      break
    case 3:
      flatten3D(array, shape[0], shape[1], shape[2], out, 0)
      break
    default:
      flattenRec(array, shape, 0, out, 0)
  }
  return out
}

function arrayShape$1 (array_) {
  var shape = []
  for (var array = array_; array.length; array = array[0]) {
    shape.push(array.length)
  }
  return shape
}

var arrayTypes =  {
	"[object Int8Array]": 5120,
	"[object Int16Array]": 5122,
	"[object Int32Array]": 5124,
	"[object Uint8Array]": 5121,
	"[object Uint8ClampedArray]": 5121,
	"[object Uint16Array]": 5123,
	"[object Uint32Array]": 5125,
	"[object Float32Array]": 5126,
	"[object Float64Array]": 5121,
	"[object ArrayBuffer]": 5121
};

var int8 = 5120;
var int16 = 5122;
var int32 = 5124;
var uint8 = 5121;
var uint16 = 5123;
var uint32 = 5125;
var float = 5126;
var float32 = 5126;
var glTypes = {
	int8: int8,
	int16: int16,
	int32: int32,
	uint8: uint8,
	uint16: uint16,
	uint32: uint32,
	float: float,
	float32: float32
};

var dynamic$1 = 35048;
var stream = 35040;
var usageTypes = {
	dynamic: dynamic$1,
	stream: stream,
	"static": 35044
};

var arrayFlatten = flattenUtils.flatten
var arrayShape = flattenUtils.shape

var GL_STATIC_DRAW = 0x88E4
var GL_STREAM_DRAW = 0x88E0

var GL_UNSIGNED_BYTE$3 = 5121
var GL_FLOAT$3 = 5126

var DTYPES_SIZES = []
DTYPES_SIZES[5120] = 1 // int8
DTYPES_SIZES[5122] = 2 // int16
DTYPES_SIZES[5124] = 4 // int32
DTYPES_SIZES[5121] = 1 // uint8
DTYPES_SIZES[5123] = 2 // uint16
DTYPES_SIZES[5125] = 4 // uint32
DTYPES_SIZES[5126] = 4 // float32

function typedArrayCode (data) {
  return arrayTypes[Object.prototype.toString.call(data)] | 0
}

function copyArray (out, inp) {
  for (var i = 0; i < inp.length; ++i) {
    out[i] = inp[i]
  }
}

function transpose (
  result, data, shapeX, shapeY, strideX, strideY, offset) {
  var ptr = 0
  for (var i = 0; i < shapeX; ++i) {
    for (var j = 0; j < shapeY; ++j) {
      result[ptr++] = data[strideX * i + strideY * j + offset]
    }
  }
}

function wrapBufferState (gl, stats, config, destroyBuffer) {
  var bufferCount = 0
  var bufferSet = {}

  function REGLBuffer (type) {
    this.id = bufferCount++
    this.buffer = gl.createBuffer()
    this.type = type
    this.usage = GL_STATIC_DRAW
    this.byteLength = 0
    this.dimension = 1
    this.dtype = GL_UNSIGNED_BYTE$3

    this.persistentData = null

    if (config.profile) {
      this.stats = { size: 0 }
    }
  }

  REGLBuffer.prototype.bind = function () {
    gl.bindBuffer(this.type, this.buffer)
  }

  REGLBuffer.prototype.destroy = function () {
    destroy(this)
  }

  var streamPool = []

  function createStream (type, data) {
    var buffer = streamPool.pop()
    if (!buffer) {
      buffer = new REGLBuffer(type)
    }
    buffer.bind()
    initBufferFromData(buffer, data, GL_STREAM_DRAW, 0, 1, false)
    return buffer
  }

  function destroyStream (stream$$1) {
    streamPool.push(stream$$1)
  }

  function initBufferFromTypedArray (buffer, data, usage) {
    buffer.byteLength = data.byteLength
    gl.bufferData(buffer.type, data, usage)
  }

  function initBufferFromData (buffer, data, usage, dtype, dimension, persist) {
    var shape
    buffer.usage = usage
    if (Array.isArray(data)) {
      buffer.dtype = dtype || GL_FLOAT$3
      if (data.length > 0) {
        var flatData
        if (Array.isArray(data[0])) {
          shape = arrayShape(data)
          var dim = 1
          for (var i = 1; i < shape.length; ++i) {
            dim *= shape[i]
          }
          buffer.dimension = dim
          flatData = arrayFlatten(data, shape, buffer.dtype)
          initBufferFromTypedArray(buffer, flatData, usage)
          if (persist) {
            buffer.persistentData = flatData
          } else {
            pool.freeType(flatData)
          }
        } else if (typeof data[0] === 'number') {
          buffer.dimension = dimension
          var typedData = pool.allocType(buffer.dtype, data.length)
          copyArray(typedData, data)
          initBufferFromTypedArray(buffer, typedData, usage)
          if (persist) {
            buffer.persistentData = typedData
          } else {
            pool.freeType(typedData)
          }
        } else if (isTypedArray(data[0])) {
          buffer.dimension = data[0].length
          buffer.dtype = dtype || typedArrayCode(data[0]) || GL_FLOAT$3
          flatData = arrayFlatten(
            data,
            [data.length, data[0].length],
            buffer.dtype)
          initBufferFromTypedArray(buffer, flatData, usage)
          if (persist) {
            buffer.persistentData = flatData
          } else {
            pool.freeType(flatData)
          }
        } else {
          check$1.raise('invalid buffer data')
        }
      }
    } else if (isTypedArray(data)) {
      buffer.dtype = dtype || typedArrayCode(data)
      buffer.dimension = dimension
      initBufferFromTypedArray(buffer, data, usage)
      if (persist) {
        buffer.persistentData = new Uint8Array(new Uint8Array(data.buffer))
      }
    } else if (isNDArrayLike(data)) {
      shape = data.shape
      var stride = data.stride
      var offset = data.offset

      var shapeX = 0
      var shapeY = 0
      var strideX = 0
      var strideY = 0
      if (shape.length === 1) {
        shapeX = shape[0]
        shapeY = 1
        strideX = stride[0]
        strideY = 0
      } else if (shape.length === 2) {
        shapeX = shape[0]
        shapeY = shape[1]
        strideX = stride[0]
        strideY = stride[1]
      } else {
        check$1.raise('invalid shape')
      }

      buffer.dtype = dtype || typedArrayCode(data.data) || GL_FLOAT$3
      buffer.dimension = shapeY

      var transposeData = pool.allocType(buffer.dtype, shapeX * shapeY)
      transpose(transposeData,
        data.data,
        shapeX, shapeY,
        strideX, strideY,
        offset)
      initBufferFromTypedArray(buffer, transposeData, usage)
      if (persist) {
        buffer.persistentData = transposeData
      } else {
        pool.freeType(transposeData)
      }
    } else if (data instanceof ArrayBuffer) {
      buffer.dtype = GL_UNSIGNED_BYTE$3
      buffer.dimension = dimension
      initBufferFromTypedArray(buffer, data, usage)
      if (persist) {
        buffer.persistentData = new Uint8Array(new Uint8Array(data))
      }
    } else {
      check$1.raise('invalid buffer data')
    }
  }

  function destroy (buffer) {
    stats.bufferCount--

    // remove attribute link
    destroyBuffer(buffer)

    var handle = buffer.buffer
    check$1(handle, 'buffer must not be deleted already')
    gl.deleteBuffer(handle)
    buffer.buffer = null
    delete bufferSet[buffer.id]
  }

  function createBuffer (options, type, deferInit, persistent) {
    stats.bufferCount++

    var buffer = new REGLBuffer(type)
    bufferSet[buffer.id] = buffer

    function reglBuffer (options) {
      var usage = GL_STATIC_DRAW
      var data = null
      var byteLength = 0
      var dtype = 0
      var dimension = 1
      if (Array.isArray(options) ||
          isTypedArray(options) ||
          isNDArrayLike(options) ||
          options instanceof ArrayBuffer) {
        data = options
      } else if (typeof options === 'number') {
        byteLength = options | 0
      } else if (options) {
        check$1.type(
          options, 'object',
          'buffer arguments must be an object, a number or an array')

        if ('data' in options) {
          check$1(
            data === null ||
            Array.isArray(data) ||
            isTypedArray(data) ||
            isNDArrayLike(data),
            'invalid data for buffer')
          data = options.data
        }

        if ('usage' in options) {
          check$1.parameter(options.usage, usageTypes, 'invalid buffer usage')
          usage = usageTypes[options.usage]
        }

        if ('type' in options) {
          check$1.parameter(options.type, glTypes, 'invalid buffer type')
          dtype = glTypes[options.type]
        }

        if ('dimension' in options) {
          check$1.type(options.dimension, 'number', 'invalid dimension')
          dimension = options.dimension | 0
        }

        if ('length' in options) {
          check$1.nni(byteLength, 'buffer length must be a nonnegative integer')
          byteLength = options.length | 0
        }
      }

      buffer.bind()
      if (!data) {
        // #475
        if (byteLength) gl.bufferData(buffer.type, byteLength, usage)
        buffer.dtype = dtype || GL_UNSIGNED_BYTE$3
        buffer.usage = usage
        buffer.dimension = dimension
        buffer.byteLength = byteLength
      } else {
        initBufferFromData(buffer, data, usage, dtype, dimension, persistent)
      }

      if (config.profile) {
        buffer.stats.size = buffer.byteLength * DTYPES_SIZES[buffer.dtype]
      }

      return reglBuffer
    }

    function setSubData (data, offset) {
      check$1(offset + data.byteLength <= buffer.byteLength,
        'invalid buffer subdata call, buffer is too small. ' + ' Can\'t write data of size ' + data.byteLength + ' starting from offset ' + offset + ' to a buffer of size ' + buffer.byteLength)

      gl.bufferSubData(buffer.type, offset, data)
    }

    function subdata (data, offset_) {
      var offset = (offset_ || 0) | 0
      var shape
      buffer.bind()
      if (isTypedArray(data) || data instanceof ArrayBuffer) {
        setSubData(data, offset)
      } else if (Array.isArray(data)) {
        if (data.length > 0) {
          if (typeof data[0] === 'number') {
            var converted = pool.allocType(buffer.dtype, data.length)
            copyArray(converted, data)
            setSubData(converted, offset)
            pool.freeType(converted)
          } else if (Array.isArray(data[0]) || isTypedArray(data[0])) {
            shape = arrayShape(data)
            var flatData = arrayFlatten(data, shape, buffer.dtype)
            setSubData(flatData, offset)
            pool.freeType(flatData)
          } else {
            check$1.raise('invalid buffer data')
          }
        }
      } else if (isNDArrayLike(data)) {
        shape = data.shape
        var stride = data.stride

        var shapeX = 0
        var shapeY = 0
        var strideX = 0
        var strideY = 0
        if (shape.length === 1) {
          shapeX = shape[0]
          shapeY = 1
          strideX = stride[0]
          strideY = 0
        } else if (shape.length === 2) {
          shapeX = shape[0]
          shapeY = shape[1]
          strideX = stride[0]
          strideY = stride[1]
        } else {
          check$1.raise('invalid shape')
        }
        var dtype = Array.isArray(data.data)
          ? buffer.dtype
          : typedArrayCode(data.data)

        var transposeData = pool.allocType(dtype, shapeX * shapeY)
        transpose(transposeData,
          data.data,
          shapeX, shapeY,
          strideX, strideY,
          data.offset)
        setSubData(transposeData, offset)
        pool.freeType(transposeData)
      } else {
        check$1.raise('invalid data for buffer subdata')
      }
      return reglBuffer
    }

    if (!deferInit) {
      reglBuffer(options)
    }

    reglBuffer._reglType = 'buffer'
    reglBuffer._buffer = buffer
    reglBuffer.subdata = subdata
    if (config.profile) {
      reglBuffer.stats = buffer.stats
    }
    reglBuffer.destroy = function () { destroy(buffer) }

    return reglBuffer
  }

  function restoreBuffers () {
    values(bufferSet).forEach(function (buffer) {
      buffer.buffer = gl.createBuffer()
      gl.bindBuffer(buffer.type, buffer.buffer)
      gl.bufferData(
        buffer.type, buffer.persistentData || buffer.byteLength, buffer.usage)
    })
  }

  if (config.profile) {
    stats.getTotalBufferSize = function () {
      var total = 0
      // TODO: Right now, the streams are not part of the total count.
      Object.keys(bufferSet).forEach(function (key) {
        total += bufferSet[key].stats.size
      })
      return total
    }
  }

  return {
    create: createBuffer,

    createStream: createStream,
    destroyStream: destroyStream,

    clear: function () {
      values(bufferSet).forEach(destroy)
      streamPool.forEach(destroy)
    },

    getBuffer: function (wrapper) {
      if (wrapper && wrapper._buffer instanceof REGLBuffer) {
        return wrapper._buffer
      }
      return null
    },

    restore: restoreBuffers,

    _initBuffer: initBufferFromData
  }
}

var points = 0;
var point = 0;
var lines = 1;
var line = 1;
var triangles = 4;
var triangle = 4;
var primTypes = {
	points: points,
	point: point,
	lines: lines,
	line: line,
	triangles: triangles,
	triangle: triangle,
	"line loop": 2,
	"line strip": 3,
	"triangle strip": 5,
	"triangle fan": 6
};

var GL_POINTS = 0
var GL_LINES = 1
var GL_TRIANGLES = 4

var GL_BYTE$2 = 5120
var GL_UNSIGNED_BYTE$4 = 5121
var GL_SHORT$2 = 5122
var GL_UNSIGNED_SHORT$2 = 5123
var GL_INT$2 = 5124
var GL_UNSIGNED_INT$2 = 5125

var GL_ELEMENT_ARRAY_BUFFER = 34963

var GL_STREAM_DRAW$1 = 0x88E0
var GL_STATIC_DRAW$1 = 0x88E4

function wrapElementsState (gl, extensions, bufferState, stats) {
  var elementSet = {}
  var elementCount = 0

  var elementTypes = {
    'uint8': GL_UNSIGNED_BYTE$4,
    'uint16': GL_UNSIGNED_SHORT$2
  }

  if (extensions.oes_element_index_uint) {
    elementTypes.uint32 = GL_UNSIGNED_INT$2
  }

  function REGLElementBuffer (buffer) {
    this.id = elementCount++
    elementSet[this.id] = this
    this.buffer = buffer
    this.primType = GL_TRIANGLES
    this.vertCount = 0
    this.type = 0
  }

  REGLElementBuffer.prototype.bind = function () {
    this.buffer.bind()
  }

  var bufferPool = []

  function createElementStream (data) {
    var result = bufferPool.pop()
    if (!result) {
      result = new REGLElementBuffer(bufferState.create(
        null,
        GL_ELEMENT_ARRAY_BUFFER,
        true,
        false)._buffer)
    }
    initElements(result, data, GL_STREAM_DRAW$1, -1, -1, 0, 0)
    return result
  }

  function destroyElementStream (elements) {
    bufferPool.push(elements)
  }

  function initElements (
    elements,
    data,
    usage,
    prim,
    count,
    byteLength,
    type) {
    elements.buffer.bind()
    var dtype
    if (data) {
      var predictedType = type
      if (!type && (
        !isTypedArray(data) ||
         (isNDArrayLike(data) && !isTypedArray(data.data)))) {
        predictedType = extensions.oes_element_index_uint
          ? GL_UNSIGNED_INT$2
          : GL_UNSIGNED_SHORT$2
      }
      bufferState._initBuffer(
        elements.buffer,
        data,
        usage,
        predictedType,
        3)
    } else {
      gl.bufferData(GL_ELEMENT_ARRAY_BUFFER, byteLength, usage)
      elements.buffer.dtype = dtype || GL_UNSIGNED_BYTE$4
      elements.buffer.usage = usage
      elements.buffer.dimension = 3
      elements.buffer.byteLength = byteLength
    }

    dtype = type
    if (!type) {
      switch (elements.buffer.dtype) {
        case GL_UNSIGNED_BYTE$4:
        case GL_BYTE$2:
          dtype = GL_UNSIGNED_BYTE$4
          break

        case GL_UNSIGNED_SHORT$2:
        case GL_SHORT$2:
          dtype = GL_UNSIGNED_SHORT$2
          break

        case GL_UNSIGNED_INT$2:
        case GL_INT$2:
          dtype = GL_UNSIGNED_INT$2
          break

        default:
          check$1.raise('unsupported type for element array')
      }
      elements.buffer.dtype = dtype
    }
    elements.type = dtype

    // Check oes_element_index_uint extension
    check$1(
      dtype !== GL_UNSIGNED_INT$2 ||
      !!extensions.oes_element_index_uint,
      '32 bit element buffers not supported, enable oes_element_index_uint first')

    // try to guess default primitive type and arguments
    var vertCount = count
    if (vertCount < 0) {
      vertCount = elements.buffer.byteLength
      if (dtype === GL_UNSIGNED_SHORT$2) {
        vertCount >>= 1
      } else if (dtype === GL_UNSIGNED_INT$2) {
        vertCount >>= 2
      }
    }
    elements.vertCount = vertCount

    // try to guess primitive type from cell dimension
    var primType = prim
    if (prim < 0) {
      primType = GL_TRIANGLES
      var dimension = elements.buffer.dimension
      if (dimension === 1) primType = GL_POINTS
      if (dimension === 2) primType = GL_LINES
      if (dimension === 3) primType = GL_TRIANGLES
    }
    elements.primType = primType
  }

  function destroyElements (elements) {
    stats.elementsCount--

    check$1(elements.buffer !== null, 'must not double destroy elements')
    delete elementSet[elements.id]
    elements.buffer.destroy()
    elements.buffer = null
  }

  function createElements (options, persistent) {
    var buffer = bufferState.create(null, GL_ELEMENT_ARRAY_BUFFER, true)
    var elements = new REGLElementBuffer(buffer._buffer)
    stats.elementsCount++

    function reglElements (options) {
      if (!options) {
        buffer()
        elements.primType = GL_TRIANGLES
        elements.vertCount = 0
        elements.type = GL_UNSIGNED_BYTE$4
      } else if (typeof options === 'number') {
        buffer(options)
        elements.primType = GL_TRIANGLES
        elements.vertCount = options | 0
        elements.type = GL_UNSIGNED_BYTE$4
      } else {
        var data = null
        var usage = GL_STATIC_DRAW$1
        var primType = -1
        var vertCount = -1
        var byteLength = 0
        var dtype = 0
        if (Array.isArray(options) ||
            isTypedArray(options) ||
            isNDArrayLike(options)) {
          data = options
        } else {
          check$1.type(options, 'object', 'invalid arguments for elements')
          if ('data' in options) {
            data = options.data
            check$1(
              Array.isArray(data) ||
                isTypedArray(data) ||
                isNDArrayLike(data),
              'invalid data for element buffer')
          }
          if ('usage' in options) {
            check$1.parameter(
              options.usage,
              usageTypes,
              'invalid element buffer usage')
            usage = usageTypes[options.usage]
          }
          if ('primitive' in options) {
            check$1.parameter(
              options.primitive,
              primTypes,
              'invalid element buffer primitive')
            primType = primTypes[options.primitive]
          }
          if ('count' in options) {
            check$1(
              typeof options.count === 'number' && options.count >= 0,
              'invalid vertex count for elements')
            vertCount = options.count | 0
          }
          if ('type' in options) {
            check$1.parameter(
              options.type,
              elementTypes,
              'invalid buffer type')
            dtype = elementTypes[options.type]
          }
          if ('length' in options) {
            byteLength = options.length | 0
          } else {
            byteLength = vertCount
            if (dtype === GL_UNSIGNED_SHORT$2 || dtype === GL_SHORT$2) {
              byteLength *= 2
            } else if (dtype === GL_UNSIGNED_INT$2 || dtype === GL_INT$2) {
              byteLength *= 4
            }
          }
        }
        initElements(
          elements,
          data,
          usage,
          primType,
          vertCount,
          byteLength,
          dtype)
      }

      return reglElements
    }

    reglElements(options)

    reglElements._reglType = 'elements'
    reglElements._elements = elements
    reglElements.subdata = function (data, offset) {
      buffer.subdata(data, offset)
      return reglElements
    }
    reglElements.destroy = function () {
      destroyElements(elements)
    }

    return reglElements
  }

  return {
    create: createElements,
    createStream: createElementStream,
    destroyStream: destroyElementStream,
    getElements: function (elements) {
      if (typeof elements === 'function' &&
          elements._elements instanceof REGLElementBuffer) {
        return elements._elements
      }
      return null
    },
    clear: function () {
      values(elementSet).forEach(destroyElements)
    }
  }
}

var FLOAT = new Float32Array(1)
var INT = new Uint32Array(FLOAT.buffer)

var GL_UNSIGNED_SHORT$4 = 5123

function convertToHalfFloat (array) {
  var ushorts = pool.allocType(GL_UNSIGNED_SHORT$4, array.length)

  for (var i = 0; i < array.length; ++i) {
    if (isNaN(array[i])) {
      ushorts[i] = 0xffff
    } else if (array[i] === Infinity) {
      ushorts[i] = 0x7c00
    } else if (array[i] === -Infinity) {
      ushorts[i] = 0xfc00
    } else {
      FLOAT[0] = array[i]
      var x = INT[0]

      var sgn = (x >>> 31) << 15
      var exp = ((x << 1) >>> 24) - 127
      var frac = (x >> 13) & ((1 << 10) - 1)

      if (exp < -24) {
        // round non-representable denormals to 0
        ushorts[i] = sgn
      } else if (exp < -14) {
        // handle denormals
        var s = -14 - exp
        ushorts[i] = sgn + ((frac + (1 << 10)) >> s)
      } else if (exp > 15) {
        // round overflow to +/- Infinity
        ushorts[i] = sgn + 0x7c00
      } else {
        // otherwise convert directly
        ushorts[i] = sgn + ((exp + 15) << 10) + frac
      }
    }
  }

  return ushorts
}

function isArrayLike (s) {
  return Array.isArray(s) || isTypedArray(s)
}

var isPow2$1 = function (v) {
  return !(v & (v - 1)) && (!!v)
}

var GL_COMPRESSED_TEXTURE_FORMATS = 0x86A3

var GL_TEXTURE_2D$1 = 0x0DE1
var GL_TEXTURE_CUBE_MAP$1 = 0x8513
var GL_TEXTURE_CUBE_MAP_POSITIVE_X$1 = 0x8515

var GL_RGBA$1 = 0x1908
var GL_ALPHA = 0x1906
var GL_RGB = 0x1907
var GL_LUMINANCE = 0x1909
var GL_LUMINANCE_ALPHA = 0x190A

var GL_RGBA4 = 0x8056
var GL_RGB5_A1 = 0x8057
var GL_RGB565 = 0x8D62

var GL_UNSIGNED_SHORT_4_4_4_4$1 = 0x8033
var GL_UNSIGNED_SHORT_5_5_5_1$1 = 0x8034
var GL_UNSIGNED_SHORT_5_6_5$1 = 0x8363
var GL_UNSIGNED_INT_24_8_WEBGL$1 = 0x84FA

var GL_DEPTH_COMPONENT = 0x1902
var GL_DEPTH_STENCIL = 0x84F9

var GL_SRGB_EXT = 0x8C40
var GL_SRGB_ALPHA_EXT = 0x8C42

var GL_HALF_FLOAT_OES$1 = 0x8D61

var GL_COMPRESSED_RGB_S3TC_DXT1_EXT = 0x83F0
var GL_COMPRESSED_RGBA_S3TC_DXT1_EXT = 0x83F1
var GL_COMPRESSED_RGBA_S3TC_DXT3_EXT = 0x83F2
var GL_COMPRESSED_RGBA_S3TC_DXT5_EXT = 0x83F3

var GL_COMPRESSED_RGB_ATC_WEBGL = 0x8C92
var GL_COMPRESSED_RGBA_ATC_EXPLICIT_ALPHA_WEBGL = 0x8C93
var GL_COMPRESSED_RGBA_ATC_INTERPOLATED_ALPHA_WEBGL = 0x87EE

var GL_COMPRESSED_RGB_PVRTC_4BPPV1_IMG = 0x8C00
var GL_COMPRESSED_RGB_PVRTC_2BPPV1_IMG = 0x8C01
var GL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG = 0x8C02
var GL_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG = 0x8C03

var GL_COMPRESSED_RGB_ETC1_WEBGL = 0x8D64

var GL_UNSIGNED_BYTE$5 = 0x1401
var GL_UNSIGNED_SHORT$3 = 0x1403
var GL_UNSIGNED_INT$3 = 0x1405
var GL_FLOAT$4 = 0x1406

var GL_TEXTURE_WRAP_S = 0x2802
var GL_TEXTURE_WRAP_T = 0x2803

var GL_REPEAT = 0x2901
var GL_CLAMP_TO_EDGE$1 = 0x812F
var GL_MIRRORED_REPEAT = 0x8370

var GL_TEXTURE_MAG_FILTER = 0x2800
var GL_TEXTURE_MIN_FILTER = 0x2801

var GL_NEAREST$1 = 0x2600
var GL_LINEAR = 0x2601
var GL_NEAREST_MIPMAP_NEAREST$1 = 0x2700
var GL_LINEAR_MIPMAP_NEAREST$1 = 0x2701
var GL_NEAREST_MIPMAP_LINEAR$1 = 0x2702
var GL_LINEAR_MIPMAP_LINEAR$1 = 0x2703

var GL_GENERATE_MIPMAP_HINT = 0x8192
var GL_DONT_CARE = 0x1100
var GL_FASTEST = 0x1101
var GL_NICEST = 0x1102

var GL_TEXTURE_MAX_ANISOTROPY_EXT = 0x84FE

var GL_UNPACK_ALIGNMENT = 0x0CF5
var GL_UNPACK_FLIP_Y_WEBGL = 0x9240
var GL_UNPACK_PREMULTIPLY_ALPHA_WEBGL = 0x9241
var GL_UNPACK_COLORSPACE_CONVERSION_WEBGL = 0x9243

var GL_BROWSER_DEFAULT_WEBGL = 0x9244

var GL_TEXTURE0$1 = 0x84C0

var MIPMAP_FILTERS = [
  GL_NEAREST_MIPMAP_NEAREST$1,
  GL_NEAREST_MIPMAP_LINEAR$1,
  GL_LINEAR_MIPMAP_NEAREST$1,
  GL_LINEAR_MIPMAP_LINEAR$1
]

var CHANNELS_FORMAT = [
  0,
  GL_LUMINANCE,
  GL_LUMINANCE_ALPHA,
  GL_RGB,
  GL_RGBA$1
]

var FORMAT_CHANNELS = {}
FORMAT_CHANNELS[GL_LUMINANCE] =
FORMAT_CHANNELS[GL_ALPHA] =
FORMAT_CHANNELS[GL_DEPTH_COMPONENT] = 1
FORMAT_CHANNELS[GL_DEPTH_STENCIL] =
FORMAT_CHANNELS[GL_LUMINANCE_ALPHA] = 2
FORMAT_CHANNELS[GL_RGB] =
FORMAT_CHANNELS[GL_SRGB_EXT] = 3
FORMAT_CHANNELS[GL_RGBA$1] =
FORMAT_CHANNELS[GL_SRGB_ALPHA_EXT] = 4

function objectName (str) {
  return '[object ' + str + ']'
}

var CANVAS_CLASS = objectName('HTMLCanvasElement')
var OFFSCREENCANVAS_CLASS = objectName('OffscreenCanvas')
var CONTEXT2D_CLASS = objectName('CanvasRenderingContext2D')
var BITMAP_CLASS = objectName('ImageBitmap')
var IMAGE_CLASS = objectName('HTMLImageElement')
var VIDEO_CLASS = objectName('HTMLVideoElement')

var PIXEL_CLASSES = Object.keys(arrayTypes).concat([
  CANVAS_CLASS,
  OFFSCREENCANVAS_CLASS,
  CONTEXT2D_CLASS,
  BITMAP_CLASS,
  IMAGE_CLASS,
  VIDEO_CLASS
])

// for every texture type, store
// the size in bytes.
var TYPE_SIZES = []
TYPE_SIZES[GL_UNSIGNED_BYTE$5] = 1
TYPE_SIZES[GL_FLOAT$4] = 4
TYPE_SIZES[GL_HALF_FLOAT_OES$1] = 2

TYPE_SIZES[GL_UNSIGNED_SHORT$3] = 2
TYPE_SIZES[GL_UNSIGNED_INT$3] = 4

var FORMAT_SIZES_SPECIAL = []
FORMAT_SIZES_SPECIAL[GL_RGBA4] = 2
FORMAT_SIZES_SPECIAL[GL_RGB5_A1] = 2
FORMAT_SIZES_SPECIAL[GL_RGB565] = 2
FORMAT_SIZES_SPECIAL[GL_DEPTH_STENCIL] = 4

FORMAT_SIZES_SPECIAL[GL_COMPRESSED_RGB_S3TC_DXT1_EXT] = 0.5
FORMAT_SIZES_SPECIAL[GL_COMPRESSED_RGBA_S3TC_DXT1_EXT] = 0.5
FORMAT_SIZES_SPECIAL[GL_COMPRESSED_RGBA_S3TC_DXT3_EXT] = 1
FORMAT_SIZES_SPECIAL[GL_COMPRESSED_RGBA_S3TC_DXT5_EXT] = 1

FORMAT_SIZES_SPECIAL[GL_COMPRESSED_RGB_ATC_WEBGL] = 0.5
FORMAT_SIZES_SPECIAL[GL_COMPRESSED_RGBA_ATC_EXPLICIT_ALPHA_WEBGL] = 1
FORMAT_SIZES_SPECIAL[GL_COMPRESSED_RGBA_ATC_INTERPOLATED_ALPHA_WEBGL] = 1

FORMAT_SIZES_SPECIAL[GL_COMPRESSED_RGB_PVRTC_4BPPV1_IMG] = 0.5
FORMAT_SIZES_SPECIAL[GL_COMPRESSED_RGB_PVRTC_2BPPV1_IMG] = 0.25
FORMAT_SIZES_SPECIAL[GL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG] = 0.5
FORMAT_SIZES_SPECIAL[GL_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG] = 0.25

FORMAT_SIZES_SPECIAL[GL_COMPRESSED_RGB_ETC1_WEBGL] = 0.5

function isNumericArray (arr) {
  return (
    Array.isArray(arr) &&
    (arr.length === 0 ||
    typeof arr[0] === 'number'))
}

function isRectArray (arr) {
  if (!Array.isArray(arr)) {
    return false
  }
  var width = arr.length
  if (width === 0 || !isArrayLike(arr[0])) {
    return false
  }
  return true
}

function classString (x) {
  return Object.prototype.toString.call(x)
}

function isCanvasElement (object) {
  return classString(object) === CANVAS_CLASS
}

function isOffscreenCanvas (object) {
  return classString(object) === OFFSCREENCANVAS_CLASS
}

function isContext2D (object) {
  return classString(object) === CONTEXT2D_CLASS
}

function isBitmap (object) {
  return classString(object) === BITMAP_CLASS
}

function isImageElement (object) {
  return classString(object) === IMAGE_CLASS
}

function isVideoElement (object) {
  return classString(object) === VIDEO_CLASS
}

function isPixelData (object) {
  if (!object) {
    return false
  }
  var className = classString(object)
  if (PIXEL_CLASSES.indexOf(className) >= 0) {
    return true
  }
  return (
    isNumericArray(object) ||
    isRectArray(object) ||
    isNDArrayLike(object))
}

function typedArrayCode$1 (data) {
  return arrayTypes[Object.prototype.toString.call(data)] | 0
}

function convertData (result, data) {
  var n = data.length
  switch (result.type) {
    case GL_UNSIGNED_BYTE$5:
    case GL_UNSIGNED_SHORT$3:
    case GL_UNSIGNED_INT$3:
    case GL_FLOAT$4:
      var converted = pool.allocType(result.type, n)
      converted.set(data)
      result.data = converted
      break

    case GL_HALF_FLOAT_OES$1:
      result.data = convertToHalfFloat(data)
      break

    default:
      check$1.raise('unsupported texture type, must specify a typed array')
  }
}

function preConvert (image, n) {
  return pool.allocType(
    image.type === GL_HALF_FLOAT_OES$1
      ? GL_FLOAT$4
      : image.type, n)
}

function postConvert (image, data) {
  if (image.type === GL_HALF_FLOAT_OES$1) {
    image.data = convertToHalfFloat(data)
    pool.freeType(data)
  } else {
    image.data = data
  }
}

function transposeData (image, array, strideX, strideY, strideC, offset) {
  var w = image.width
  var h = image.height
  var c = image.channels
  var n = w * h * c
  var data = preConvert(image, n)

  var p = 0
  for (var i = 0; i < h; ++i) {
    for (var j = 0; j < w; ++j) {
      for (var k = 0; k < c; ++k) {
        data[p++] = array[strideX * j + strideY * i + strideC * k + offset]
      }
    }
  }

  postConvert(image, data)
}

function getTextureSize (format, type, width, height, isMipmap, isCube) {
  var s
  if (typeof FORMAT_SIZES_SPECIAL[format] !== 'undefined') {
    // we have a special array for dealing with weird color formats such as RGB5A1
    s = FORMAT_SIZES_SPECIAL[format]
  } else {
    s = FORMAT_CHANNELS[format] * TYPE_SIZES[type]
  }

  if (isCube) {
    s *= 6
  }

  if (isMipmap) {
    // compute the total size of all the mipmaps.
    var total = 0

    var w = width
    while (w >= 1) {
      // we can only use mipmaps on a square image,
      // so we can simply use the width and ignore the height:
      total += s * w * w
      w /= 2
    }
    return total
  } else {
    return s * width * height
  }
}

function createTextureSet (
  gl, extensions, limits, reglPoll, contextState, stats, config) {
  // -------------------------------------------------------
  // Initialize constants and parameter tables here
  // -------------------------------------------------------
  var mipmapHint = {
    "don't care": GL_DONT_CARE,
    'dont care': GL_DONT_CARE,
    'nice': GL_NICEST,
    'fast': GL_FASTEST
  }

  var wrapModes = {
    'repeat': GL_REPEAT,
    'clamp': GL_CLAMP_TO_EDGE$1,
    'mirror': GL_MIRRORED_REPEAT
  }

  var magFilters = {
    'nearest': GL_NEAREST$1,
    'linear': GL_LINEAR
  }

  var minFilters = extend({
    'mipmap': GL_LINEAR_MIPMAP_LINEAR$1,
    'nearest mipmap nearest': GL_NEAREST_MIPMAP_NEAREST$1,
    'linear mipmap nearest': GL_LINEAR_MIPMAP_NEAREST$1,
    'nearest mipmap linear': GL_NEAREST_MIPMAP_LINEAR$1,
    'linear mipmap linear': GL_LINEAR_MIPMAP_LINEAR$1
  }, magFilters)

  var colorSpace = {
    'none': 0,
    'browser': GL_BROWSER_DEFAULT_WEBGL
  }

  var textureTypes = {
    'uint8': GL_UNSIGNED_BYTE$5,
    'rgba4': GL_UNSIGNED_SHORT_4_4_4_4$1,
    'rgb565': GL_UNSIGNED_SHORT_5_6_5$1,
    'rgb5 a1': GL_UNSIGNED_SHORT_5_5_5_1$1
  }

  var textureFormats = {
    'alpha': GL_ALPHA,
    'luminance': GL_LUMINANCE,
    'luminance alpha': GL_LUMINANCE_ALPHA,
    'rgb': GL_RGB,
    'rgba': GL_RGBA$1,
    'rgba4': GL_RGBA4,
    'rgb5 a1': GL_RGB5_A1,
    'rgb565': GL_RGB565
  }

  var compressedTextureFormats = {}

  if (extensions.ext_srgb) {
    textureFormats.srgb = GL_SRGB_EXT
    textureFormats.srgba = GL_SRGB_ALPHA_EXT
  }

  if (extensions.oes_texture_float) {
    textureTypes.float32 = textureTypes.float = GL_FLOAT$4
  }

  if (extensions.oes_texture_half_float) {
    textureTypes['float16'] = textureTypes['half float'] = GL_HALF_FLOAT_OES$1
  }

  if (extensions.webgl_depth_texture) {
    extend(textureFormats, {
      'depth': GL_DEPTH_COMPONENT,
      'depth stencil': GL_DEPTH_STENCIL
    })

    extend(textureTypes, {
      'uint16': GL_UNSIGNED_SHORT$3,
      'uint32': GL_UNSIGNED_INT$3,
      'depth stencil': GL_UNSIGNED_INT_24_8_WEBGL$1
    })
  }

  if (extensions.webgl_compressed_texture_s3tc) {
    extend(compressedTextureFormats, {
      'rgb s3tc dxt1': GL_COMPRESSED_RGB_S3TC_DXT1_EXT,
      'rgba s3tc dxt1': GL_COMPRESSED_RGBA_S3TC_DXT1_EXT,
      'rgba s3tc dxt3': GL_COMPRESSED_RGBA_S3TC_DXT3_EXT,
      'rgba s3tc dxt5': GL_COMPRESSED_RGBA_S3TC_DXT5_EXT
    })
  }

  if (extensions.webgl_compressed_texture_atc) {
    extend(compressedTextureFormats, {
      'rgb atc': GL_COMPRESSED_RGB_ATC_WEBGL,
      'rgba atc explicit alpha': GL_COMPRESSED_RGBA_ATC_EXPLICIT_ALPHA_WEBGL,
      'rgba atc interpolated alpha': GL_COMPRESSED_RGBA_ATC_INTERPOLATED_ALPHA_WEBGL
    })
  }

  if (extensions.webgl_compressed_texture_pvrtc) {
    extend(compressedTextureFormats, {
      'rgb pvrtc 4bppv1': GL_COMPRESSED_RGB_PVRTC_4BPPV1_IMG,
      'rgb pvrtc 2bppv1': GL_COMPRESSED_RGB_PVRTC_2BPPV1_IMG,
      'rgba pvrtc 4bppv1': GL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG,
      'rgba pvrtc 2bppv1': GL_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG
    })
  }

  if (extensions.webgl_compressed_texture_etc1) {
    compressedTextureFormats['rgb etc1'] = GL_COMPRESSED_RGB_ETC1_WEBGL
  }

  // Copy over all texture formats
  var supportedCompressedFormats = Array.prototype.slice.call(
    gl.getParameter(GL_COMPRESSED_TEXTURE_FORMATS))
  Object.keys(compressedTextureFormats).forEach(function (name) {
    var format = compressedTextureFormats[name]
    if (supportedCompressedFormats.indexOf(format) >= 0) {
      textureFormats[name] = format
    }
  })

  var supportedFormats = Object.keys(textureFormats)
  limits.textureFormats = supportedFormats

  // associate with every format string its
  // corresponding GL-value.
  var textureFormatsInvert = []
  Object.keys(textureFormats).forEach(function (key) {
    var val = textureFormats[key]
    textureFormatsInvert[val] = key
  })

  // associate with every type string its
  // corresponding GL-value.
  var textureTypesInvert = []
  Object.keys(textureTypes).forEach(function (key) {
    var val = textureTypes[key]
    textureTypesInvert[val] = key
  })

  var magFiltersInvert = []
  Object.keys(magFilters).forEach(function (key) {
    var val = magFilters[key]
    magFiltersInvert[val] = key
  })

  var minFiltersInvert = []
  Object.keys(minFilters).forEach(function (key) {
    var val = minFilters[key]
    minFiltersInvert[val] = key
  })

  var wrapModesInvert = []
  Object.keys(wrapModes).forEach(function (key) {
    var val = wrapModes[key]
    wrapModesInvert[val] = key
  })

  // colorFormats[] gives the format (channels) associated to an
  // internalformat
  var colorFormats = supportedFormats.reduce(function (color, key) {
    var glenum = textureFormats[key]
    if (glenum === GL_LUMINANCE ||
        glenum === GL_ALPHA ||
        glenum === GL_LUMINANCE ||
        glenum === GL_LUMINANCE_ALPHA ||
        glenum === GL_DEPTH_COMPONENT ||
        glenum === GL_DEPTH_STENCIL ||
        (extensions.ext_srgb &&
                (glenum === GL_SRGB_EXT ||
                 glenum === GL_SRGB_ALPHA_EXT))) {
      color[glenum] = glenum
    } else if (glenum === GL_RGB5_A1 || key.indexOf('rgba') >= 0) {
      color[glenum] = GL_RGBA$1
    } else {
      color[glenum] = GL_RGB
    }
    return color
  }, {})

  function TexFlags () {
    // format info
    this.internalformat = GL_RGBA$1
    this.format = GL_RGBA$1
    this.type = GL_UNSIGNED_BYTE$5
    this.compressed = false

    // pixel storage
    this.premultiplyAlpha = false
    this.flipY = false
    this.unpackAlignment = 1
    this.colorSpace = GL_BROWSER_DEFAULT_WEBGL

    // shape info
    this.width = 0
    this.height = 0
    this.channels = 0
  }

  function copyFlags (result, other) {
    result.internalformat = other.internalformat
    result.format = other.format
    result.type = other.type
    result.compressed = other.compressed

    result.premultiplyAlpha = other.premultiplyAlpha
    result.flipY = other.flipY
    result.unpackAlignment = other.unpackAlignment
    result.colorSpace = other.colorSpace

    result.width = other.width
    result.height = other.height
    result.channels = other.channels
  }

  function parseFlags (flags, options) {
    if (typeof options !== 'object' || !options) {
      return
    }

    if ('premultiplyAlpha' in options) {
      check$1.type(options.premultiplyAlpha, 'boolean',
        'invalid premultiplyAlpha')
      flags.premultiplyAlpha = options.premultiplyAlpha
    }

    if ('flipY' in options) {
      check$1.type(options.flipY, 'boolean',
        'invalid texture flip')
      flags.flipY = options.flipY
    }

    if ('alignment' in options) {
      check$1.oneOf(options.alignment, [1, 2, 4, 8],
        'invalid texture unpack alignment')
      flags.unpackAlignment = options.alignment
    }

    if ('colorSpace' in options) {
      check$1.parameter(options.colorSpace, colorSpace,
        'invalid colorSpace')
      flags.colorSpace = colorSpace[options.colorSpace]
    }

    if ('type' in options) {
      var type = options.type
      check$1(extensions.oes_texture_float ||
        !(type === 'float' || type === 'float32'),
      'you must enable the OES_texture_float extension in order to use floating point textures.')
      check$1(extensions.oes_texture_half_float ||
        !(type === 'half float' || type === 'float16'),
      'you must enable the OES_texture_half_float extension in order to use 16-bit floating point textures.')
      check$1(extensions.webgl_depth_texture ||
        !(type === 'uint16' || type === 'uint32' || type === 'depth stencil'),
      'you must enable the WEBGL_depth_texture extension in order to use depth/stencil textures.')
      check$1.parameter(type, textureTypes,
        'invalid texture type')
      flags.type = textureTypes[type]
    }

    var w = flags.width
    var h = flags.height
    var c = flags.channels
    var hasChannels = false
    if ('shape' in options) {
      check$1(Array.isArray(options.shape) && options.shape.length >= 2,
        'shape must be an array')
      w = options.shape[0]
      h = options.shape[1]
      if (options.shape.length === 3) {
        c = options.shape[2]
        check$1(c > 0 && c <= 4, 'invalid number of channels')
        hasChannels = true
      }
      check$1(w >= 0 && w <= limits.maxTextureSize, 'invalid width')
      check$1(h >= 0 && h <= limits.maxTextureSize, 'invalid height')
    } else {
      if ('radius' in options) {
        w = h = options.radius
        check$1(w >= 0 && w <= limits.maxTextureSize, 'invalid radius')
      }
      if ('width' in options) {
        w = options.width
        check$1(w >= 0 && w <= limits.maxTextureSize, 'invalid width')
      }
      if ('height' in options) {
        h = options.height
        check$1(h >= 0 && h <= limits.maxTextureSize, 'invalid height')
      }
      if ('channels' in options) {
        c = options.channels
        check$1(c > 0 && c <= 4, 'invalid number of channels')
        hasChannels = true
      }
    }
    flags.width = w | 0
    flags.height = h | 0
    flags.channels = c | 0

    var hasFormat = false
    if ('format' in options) {
      var formatStr = options.format
      check$1(extensions.webgl_depth_texture ||
        !(formatStr === 'depth' || formatStr === 'depth stencil'),
      'you must enable the WEBGL_depth_texture extension in order to use depth/stencil textures.')
      check$1.parameter(formatStr, textureFormats,
        'invalid texture format')
      var internalformat = flags.internalformat = textureFormats[formatStr]
      flags.format = colorFormats[internalformat]
      if (formatStr in textureTypes) {
        if (!('type' in options)) {
          flags.type = textureTypes[formatStr]
        }
      }
      if (formatStr in compressedTextureFormats) {
        flags.compressed = true
      }
      hasFormat = true
    }

    // Reconcile channels and format
    if (!hasChannels && hasFormat) {
      flags.channels = FORMAT_CHANNELS[flags.format]
    } else if (hasChannels && !hasFormat) {
      if (flags.channels !== CHANNELS_FORMAT[flags.format]) {
        flags.format = flags.internalformat = CHANNELS_FORMAT[flags.channels]
      }
    } else if (hasFormat && hasChannels) {
      check$1(
        flags.channels === FORMAT_CHANNELS[flags.format],
        'number of channels inconsistent with specified format')
    }
  }

  function setFlags (flags) {
    gl.pixelStorei(GL_UNPACK_FLIP_Y_WEBGL, flags.flipY)
    gl.pixelStorei(GL_UNPACK_PREMULTIPLY_ALPHA_WEBGL, flags.premultiplyAlpha)
    gl.pixelStorei(GL_UNPACK_COLORSPACE_CONVERSION_WEBGL, flags.colorSpace)
    gl.pixelStorei(GL_UNPACK_ALIGNMENT, flags.unpackAlignment)
  }

  // -------------------------------------------------------
  // Tex image data
  // -------------------------------------------------------
  function TexImage () {
    TexFlags.call(this)

    this.xOffset = 0
    this.yOffset = 0

    // data
    this.data = null
    this.needsFree = false

    // html element
    this.element = null

    // copyTexImage info
    this.needsCopy = false
  }

  function parseImage (image, options) {
    var data = null
    if (isPixelData(options)) {
      data = options
    } else if (options) {
      check$1.type(options, 'object', 'invalid pixel data type')
      parseFlags(image, options)
      if ('x' in options) {
        image.xOffset = options.x | 0
      }
      if ('y' in options) {
        image.yOffset = options.y | 0
      }
      if (isPixelData(options.data)) {
        data = options.data
      }
    }

    check$1(
      !image.compressed ||
      data instanceof Uint8Array,
      'compressed texture data must be stored in a uint8array')

    if (options.copy) {
      check$1(!data, 'can not specify copy and data field for the same texture')
      var viewW = contextState.viewportWidth
      var viewH = contextState.viewportHeight
      image.width = image.width || (viewW - image.xOffset)
      image.height = image.height || (viewH - image.yOffset)
      image.needsCopy = true
      check$1(image.xOffset >= 0 && image.xOffset < viewW &&
            image.yOffset >= 0 && image.yOffset < viewH &&
            image.width > 0 && image.width <= viewW &&
            image.height > 0 && image.height <= viewH,
      'copy texture read out of bounds')
    } else if (!data) {
      image.width = image.width || 1
      image.height = image.height || 1
      image.channels = image.channels || 4
    } else if (isTypedArray(data)) {
      image.channels = image.channels || 4
      image.data = data
      if (!('type' in options) && image.type === GL_UNSIGNED_BYTE$5) {
        image.type = typedArrayCode$1(data)
      }
    } else if (isNumericArray(data)) {
      image.channels = image.channels || 4
      convertData(image, data)
      image.alignment = 1
      image.needsFree = true
    } else if (isNDArrayLike(data)) {
      var array = data.data
      if (!Array.isArray(array) && image.type === GL_UNSIGNED_BYTE$5) {
        image.type = typedArrayCode$1(array)
      }
      var shape = data.shape
      var stride = data.stride
      var shapeX, shapeY, shapeC, strideX, strideY, strideC
      if (shape.length === 3) {
        shapeC = shape[2]
        strideC = stride[2]
      } else {
        check$1(shape.length === 2, 'invalid ndarray pixel data, must be 2 or 3D')
        shapeC = 1
        strideC = 1
      }
      shapeX = shape[0]
      shapeY = shape[1]
      strideX = stride[0]
      strideY = stride[1]
      image.alignment = 1
      image.width = shapeX
      image.height = shapeY
      image.channels = shapeC
      image.format = image.internalformat = CHANNELS_FORMAT[shapeC]
      image.needsFree = true
      transposeData(image, array, strideX, strideY, strideC, data.offset)
    } else if (isCanvasElement(data) || isOffscreenCanvas(data) || isContext2D(data)) {
      if (isCanvasElement(data) || isOffscreenCanvas(data)) {
        image.element = data
      } else {
        image.element = data.canvas
      }
      image.width = image.element.width
      image.height = image.element.height
      image.channels = 4
    } else if (isBitmap(data)) {
      image.element = data
      image.width = data.width
      image.height = data.height
      image.channels = 4
    } else if (isImageElement(data)) {
      image.element = data
      image.width = data.naturalWidth
      image.height = data.naturalHeight
      image.channels = 4
    } else if (isVideoElement(data)) {
      image.element = data
      image.width = data.videoWidth
      image.height = data.videoHeight
      image.channels = 4
    } else if (isRectArray(data)) {
      var w = image.width || data[0].length
      var h = image.height || data.length
      var c = image.channels
      if (isArrayLike(data[0][0])) {
        c = c || data[0][0].length
      } else {
        c = c || 1
      }
      var arrayShape = flattenUtils.shape(data)
      var n = 1
      for (var dd = 0; dd < arrayShape.length; ++dd) {
        n *= arrayShape[dd]
      }
      var allocData = preConvert(image, n)
      flattenUtils.flatten(data, arrayShape, '', allocData)
      postConvert(image, allocData)
      image.alignment = 1
      image.width = w
      image.height = h
      image.channels = c
      image.format = image.internalformat = CHANNELS_FORMAT[c]
      image.needsFree = true
    }

    if (image.type === GL_FLOAT$4) {
      check$1(limits.extensions.indexOf('oes_texture_float') >= 0,
        'oes_texture_float extension not enabled')
    } else if (image.type === GL_HALF_FLOAT_OES$1) {
      check$1(limits.extensions.indexOf('oes_texture_half_float') >= 0,
        'oes_texture_half_float extension not enabled')
    }

    // do compressed texture  validation here.
  }

  function setImage (info, target, miplevel) {
    var element = info.element
    var data = info.data
    var internalformat = info.internalformat
    var format = info.format
    var type = info.type
    var width = info.width
    var height = info.height

    setFlags(info)

    if (element) {
      gl.texImage2D(target, miplevel, format, format, type, element)
    } else if (info.compressed) {
      gl.compressedTexImage2D(target, miplevel, internalformat, width, height, 0, data)
    } else if (info.needsCopy) {
      reglPoll()
      gl.copyTexImage2D(
        target, miplevel, format, info.xOffset, info.yOffset, width, height, 0)
    } else {
      gl.texImage2D(target, miplevel, format, width, height, 0, format, type, data || null)
    }
  }

  function setSubImage (info, target, x, y, miplevel) {
    var element = info.element
    var data = info.data
    var internalformat = info.internalformat
    var format = info.format
    var type = info.type
    var width = info.width
    var height = info.height

    setFlags(info)

    if (element) {
      gl.texSubImage2D(
        target, miplevel, x, y, format, type, element)
    } else if (info.compressed) {
      gl.compressedTexSubImage2D(
        target, miplevel, x, y, internalformat, width, height, data)
    } else if (info.needsCopy) {
      reglPoll()
      gl.copyTexSubImage2D(
        target, miplevel, x, y, info.xOffset, info.yOffset, width, height)
    } else {
      gl.texSubImage2D(
        target, miplevel, x, y, width, height, format, type, data)
    }
  }

  // texImage pool
  var imagePool = []

  function allocImage () {
    return imagePool.pop() || new TexImage()
  }

  function freeImage (image) {
    if (image.needsFree) {
      pool.freeType(image.data)
    }
    TexImage.call(image)
    imagePool.push(image)
  }

  // -------------------------------------------------------
  // Mip map
  // -------------------------------------------------------
  function MipMap () {
    TexFlags.call(this)

    this.genMipmaps = false
    this.mipmapHint = GL_DONT_CARE
    this.mipmask = 0
    this.images = Array(16)
  }

  function parseMipMapFromShape (mipmap, width, height) {
    var img = mipmap.images[0] = allocImage()
    mipmap.mipmask = 1
    img.width = mipmap.width = width
    img.height = mipmap.height = height
    img.channels = mipmap.channels = 4
  }

  function parseMipMapFromObject (mipmap, options) {
    var imgData = null
    if (isPixelData(options)) {
      imgData = mipmap.images[0] = allocImage()
      copyFlags(imgData, mipmap)
      parseImage(imgData, options)
      mipmap.mipmask = 1
    } else {
      parseFlags(mipmap, options)
      if (Array.isArray(options.mipmap)) {
        var mipData = options.mipmap
        for (var i = 0; i < mipData.length; ++i) {
          imgData = mipmap.images[i] = allocImage()
          copyFlags(imgData, mipmap)
          imgData.width >>= i
          imgData.height >>= i
          parseImage(imgData, mipData[i])
          mipmap.mipmask |= (1 << i)
        }
      } else {
        imgData = mipmap.images[0] = allocImage()
        copyFlags(imgData, mipmap)
        parseImage(imgData, options)
        mipmap.mipmask = 1
      }
    }
    copyFlags(mipmap, mipmap.images[0])

    // For textures of the compressed format WEBGL_compressed_texture_s3tc
    // we must have that
    //
    // "When level equals zero width and height must be a multiple of 4.
    // When level is greater than 0 width and height must be 0, 1, 2 or a multiple of 4. "
    //
    // but we do not yet support having multiple mipmap levels for compressed textures,
    // so we only test for level zero.

    if (
      mipmap.compressed &&
      (
        mipmap.internalformat === GL_COMPRESSED_RGB_S3TC_DXT1_EXT ||
        mipmap.internalformat === GL_COMPRESSED_RGBA_S3TC_DXT1_EXT ||
        mipmap.internalformat === GL_COMPRESSED_RGBA_S3TC_DXT3_EXT ||
        mipmap.internalformat === GL_COMPRESSED_RGBA_S3TC_DXT5_EXT
      )
    ) {
      check$1(mipmap.width % 4 === 0 && mipmap.height % 4 === 0,
        'for compressed texture formats, mipmap level 0 must have width and height that are a multiple of 4')
    }
  }

  function setMipMap (mipmap, target) {
    var images = mipmap.images
    for (var i = 0; i < images.length; ++i) {
      if (!images[i]) {
        return
      }
      setImage(images[i], target, i)
    }
  }

  var mipPool = []

  function allocMipMap () {
    var result = mipPool.pop() || new MipMap()
    TexFlags.call(result)
    result.mipmask = 0
    for (var i = 0; i < 16; ++i) {
      result.images[i] = null
    }
    return result
  }

  function freeMipMap (mipmap) {
    var images = mipmap.images
    for (var i = 0; i < images.length; ++i) {
      if (images[i]) {
        freeImage(images[i])
      }
      images[i] = null
    }
    mipPool.push(mipmap)
  }

  // -------------------------------------------------------
  // Tex info
  // -------------------------------------------------------
  function TexInfo () {
    this.minFilter = GL_NEAREST$1
    this.magFilter = GL_NEAREST$1

    this.wrapS = GL_CLAMP_TO_EDGE$1
    this.wrapT = GL_CLAMP_TO_EDGE$1

    this.anisotropic = 1

    this.genMipmaps = false
    this.mipmapHint = GL_DONT_CARE
  }

  function parseTexInfo (info, options) {
    if ('min' in options) {
      var minFilter = options.min
      check$1.parameter(minFilter, minFilters)
      info.minFilter = minFilters[minFilter]
      if (MIPMAP_FILTERS.indexOf(info.minFilter) >= 0 && !('faces' in options)) {
        info.genMipmaps = true
      }
    }

    if ('mag' in options) {
      var magFilter = options.mag
      check$1.parameter(magFilter, magFilters)
      info.magFilter = magFilters[magFilter]
    }

    var wrapS = info.wrapS
    var wrapT = info.wrapT
    if ('wrap' in options) {
      var wrap = options.wrap
      if (typeof wrap === 'string') {
        check$1.parameter(wrap, wrapModes)
        wrapS = wrapT = wrapModes[wrap]
      } else if (Array.isArray(wrap)) {
        check$1.parameter(wrap[0], wrapModes)
        check$1.parameter(wrap[1], wrapModes)
        wrapS = wrapModes[wrap[0]]
        wrapT = wrapModes[wrap[1]]
      }
    } else {
      if ('wrapS' in options) {
        var optWrapS = options.wrapS
        check$1.parameter(optWrapS, wrapModes)
        wrapS = wrapModes[optWrapS]
      }
      if ('wrapT' in options) {
        var optWrapT = options.wrapT
        check$1.parameter(optWrapT, wrapModes)
        wrapT = wrapModes[optWrapT]
      }
    }
    info.wrapS = wrapS
    info.wrapT = wrapT

    if ('anisotropic' in options) {
      var anisotropic = options.anisotropic
      check$1(typeof anisotropic === 'number' &&
         anisotropic >= 1 && anisotropic <= limits.maxAnisotropic,
      'aniso samples must be between 1 and ')
      info.anisotropic = options.anisotropic
    }

    if ('mipmap' in options) {
      var hasMipMap = false
      switch (typeof options.mipmap) {
        case 'string':
          check$1.parameter(options.mipmap, mipmapHint,
            'invalid mipmap hint')
          info.mipmapHint = mipmapHint[options.mipmap]
          info.genMipmaps = true
          hasMipMap = true
          break

        case 'boolean':
          hasMipMap = info.genMipmaps = options.mipmap
          break

        case 'object':
          check$1(Array.isArray(options.mipmap), 'invalid mipmap type')
          info.genMipmaps = false
          hasMipMap = true
          break

        default:
          check$1.raise('invalid mipmap type')
      }
      if (hasMipMap && !('min' in options)) {
        info.minFilter = GL_NEAREST_MIPMAP_NEAREST$1
      }
    }
  }

  function setTexInfo (info, target) {
    gl.texParameteri(target, GL_TEXTURE_MIN_FILTER, info.minFilter)
    gl.texParameteri(target, GL_TEXTURE_MAG_FILTER, info.magFilter)
    gl.texParameteri(target, GL_TEXTURE_WRAP_S, info.wrapS)
    gl.texParameteri(target, GL_TEXTURE_WRAP_T, info.wrapT)
    if (extensions.ext_texture_filter_anisotropic) {
      gl.texParameteri(target, GL_TEXTURE_MAX_ANISOTROPY_EXT, info.anisotropic)
    }
    if (info.genMipmaps) {
      gl.hint(GL_GENERATE_MIPMAP_HINT, info.mipmapHint)
      gl.generateMipmap(target)
    }
  }

  // -------------------------------------------------------
  // Full texture object
  // -------------------------------------------------------
  var textureCount = 0
  var textureSet = {}
  var numTexUnits = limits.maxTextureUnits
  var textureUnits = Array(numTexUnits).map(function () {
    return null
  })

  function REGLTexture (target) {
    TexFlags.call(this)
    this.mipmask = 0
    this.internalformat = GL_RGBA$1

    this.id = textureCount++

    this.refCount = 1

    this.target = target
    this.texture = gl.createTexture()

    this.unit = -1
    this.bindCount = 0

    this.texInfo = new TexInfo()

    if (config.profile) {
      this.stats = { size: 0 }
    }
  }

  function tempBind (texture) {
    gl.activeTexture(GL_TEXTURE0$1)
    gl.bindTexture(texture.target, texture.texture)
  }

  function tempRestore () {
    var prev = textureUnits[0]
    if (prev) {
      gl.bindTexture(prev.target, prev.texture)
    } else {
      gl.bindTexture(GL_TEXTURE_2D$1, null)
    }
  }

  function destroy (texture) {
    var handle = texture.texture
    check$1(handle, 'must not double destroy texture')
    var unit = texture.unit
    var target = texture.target
    if (unit >= 0) {
      gl.activeTexture(GL_TEXTURE0$1 + unit)
      gl.bindTexture(target, null)
      textureUnits[unit] = null
    }
    gl.deleteTexture(handle)
    texture.texture = null
    texture.params = null
    texture.pixels = null
    texture.refCount = 0
    delete textureSet[texture.id]
    stats.textureCount--
  }

  extend(REGLTexture.prototype, {
    bind: function () {
      var texture = this
      texture.bindCount += 1
      var unit = texture.unit
      if (unit < 0) {
        for (var i = 0; i < numTexUnits; ++i) {
          var other = textureUnits[i]
          if (other) {
            if (other.bindCount > 0) {
              continue
            }
            other.unit = -1
          }
          textureUnits[i] = texture
          unit = i
          break
        }
        if (unit >= numTexUnits) {
          check$1.raise('insufficient number of texture units')
        }
        if (config.profile && stats.maxTextureUnits < (unit + 1)) {
          stats.maxTextureUnits = unit + 1 // +1, since the units are zero-based
        }
        texture.unit = unit
        gl.activeTexture(GL_TEXTURE0$1 + unit)
        gl.bindTexture(texture.target, texture.texture)
      }
      return unit
    },

    unbind: function () {
      this.bindCount -= 1
    },

    decRef: function () {
      if (--this.refCount <= 0) {
        destroy(this)
      }
    }
  })

  function createTexture2D (a, b) {
    var texture = new REGLTexture(GL_TEXTURE_2D$1)
    textureSet[texture.id] = texture
    stats.textureCount++

    function reglTexture2D (a, b) {
      var texInfo = texture.texInfo
      TexInfo.call(texInfo)
      var mipData = allocMipMap()

      if (typeof a === 'number') {
        if (typeof b === 'number') {
          parseMipMapFromShape(mipData, a | 0, b | 0)
        } else {
          parseMipMapFromShape(mipData, a | 0, a | 0)
        }
      } else if (a) {
        check$1.type(a, 'object', 'invalid arguments to regl.texture')
        parseTexInfo(texInfo, a)
        parseMipMapFromObject(mipData, a)
      } else {
        // empty textures get assigned a default shape of 1x1
        parseMipMapFromShape(mipData, 1, 1)
      }

      if (texInfo.genMipmaps) {
        mipData.mipmask = (mipData.width << 1) - 1
      }
      texture.mipmask = mipData.mipmask

      copyFlags(texture, mipData)

      check$1.texture2D(texInfo, mipData, limits)
      texture.internalformat = mipData.internalformat

      reglTexture2D.width = mipData.width
      reglTexture2D.height = mipData.height

      tempBind(texture)
      setMipMap(mipData, GL_TEXTURE_2D$1)
      setTexInfo(texInfo, GL_TEXTURE_2D$1)
      tempRestore()

      freeMipMap(mipData)

      if (config.profile) {
        texture.stats.size = getTextureSize(
          texture.internalformat,
          texture.type,
          mipData.width,
          mipData.height,
          texInfo.genMipmaps,
          false)
      }
      reglTexture2D.format = textureFormatsInvert[texture.internalformat]
      reglTexture2D.type = textureTypesInvert[texture.type]

      reglTexture2D.mag = magFiltersInvert[texInfo.magFilter]
      reglTexture2D.min = minFiltersInvert[texInfo.minFilter]

      reglTexture2D.wrapS = wrapModesInvert[texInfo.wrapS]
      reglTexture2D.wrapT = wrapModesInvert[texInfo.wrapT]

      return reglTexture2D
    }

    function subimage (image, x_, y_, level_) {
      check$1(!!image, 'must specify image data')

      var x = x_ | 0
      var y = y_ | 0
      var level = level_ | 0

      var imageData = allocImage()
      copyFlags(imageData, texture)
      imageData.width = 0
      imageData.height = 0
      parseImage(imageData, image)
      imageData.width = imageData.width || ((texture.width >> level) - x)
      imageData.height = imageData.height || ((texture.height >> level) - y)

      check$1(
        texture.type === imageData.type &&
        texture.format === imageData.format &&
        texture.internalformat === imageData.internalformat,
        'incompatible format for texture.subimage')
      check$1(
        x >= 0 && y >= 0 &&
        x + imageData.width <= texture.width &&
        y + imageData.height <= texture.height,
        'texture.subimage write out of bounds')
      check$1(
        texture.mipmask & (1 << level),
        'missing mipmap data')
      check$1(
        imageData.data || imageData.element || imageData.needsCopy,
        'missing image data')

      tempBind(texture)
      setSubImage(imageData, GL_TEXTURE_2D$1, x, y, level)
      tempRestore()

      freeImage(imageData)

      return reglTexture2D
    }

    function resize (w_, h_) {
      var w = w_ | 0
      var h = (h_ | 0) || w
      if (w === texture.width && h === texture.height) {
        return reglTexture2D
      }

      reglTexture2D.width = texture.width = w
      reglTexture2D.height = texture.height = h

      tempBind(texture)

      for (var i = 0; texture.mipmask >> i; ++i) {
        var _w = w >> i
        var _h = h >> i
        if (!_w || !_h) break
        gl.texImage2D(
          GL_TEXTURE_2D$1,
          i,
          texture.format,
          _w,
          _h,
          0,
          texture.format,
          texture.type,
          null)
      }
      tempRestore()

      // also, recompute the texture size.
      if (config.profile) {
        texture.stats.size = getTextureSize(
          texture.internalformat,
          texture.type,
          w,
          h,
          false,
          false)
      }

      return reglTexture2D
    }

    reglTexture2D(a, b)

    reglTexture2D.subimage = subimage
    reglTexture2D.resize = resize
    reglTexture2D._reglType = 'texture2d'
    reglTexture2D._texture = texture
    if (config.profile) {
      reglTexture2D.stats = texture.stats
    }
    reglTexture2D.destroy = function () {
      texture.decRef()
    }

    return reglTexture2D
  }

  function createTextureCube (a0, a1, a2, a3, a4, a5) {
    var texture = new REGLTexture(GL_TEXTURE_CUBE_MAP$1)
    textureSet[texture.id] = texture
    stats.cubeCount++

    var faces = new Array(6)

    function reglTextureCube (a0, a1, a2, a3, a4, a5) {
      var i
      var texInfo = texture.texInfo
      TexInfo.call(texInfo)
      for (i = 0; i < 6; ++i) {
        faces[i] = allocMipMap()
      }

      if (typeof a0 === 'number' || !a0) {
        var s = (a0 | 0) || 1
        for (i = 0; i < 6; ++i) {
          parseMipMapFromShape(faces[i], s, s)
        }
      } else if (typeof a0 === 'object') {
        if (a1) {
          parseMipMapFromObject(faces[0], a0)
          parseMipMapFromObject(faces[1], a1)
          parseMipMapFromObject(faces[2], a2)
          parseMipMapFromObject(faces[3], a3)
          parseMipMapFromObject(faces[4], a4)
          parseMipMapFromObject(faces[5], a5)
        } else {
          parseTexInfo(texInfo, a0)
          parseFlags(texture, a0)
          if ('faces' in a0) {
            var faceInput = a0.faces
            check$1(Array.isArray(faceInput) && faceInput.length === 6,
              'cube faces must be a length 6 array')
            for (i = 0; i < 6; ++i) {
              check$1(typeof faceInput[i] === 'object' && !!faceInput[i],
                'invalid input for cube map face')
              copyFlags(faces[i], texture)
              parseMipMapFromObject(faces[i], faceInput[i])
            }
          } else {
            for (i = 0; i < 6; ++i) {
              parseMipMapFromObject(faces[i], a0)
            }
          }
        }
      } else {
        check$1.raise('invalid arguments to cube map')
      }

      copyFlags(texture, faces[0])
      check$1.optional(function () {
        if (!limits.npotTextureCube) {
          check$1(isPow2$1(texture.width) && isPow2$1(texture.height), 'your browser does not support non power or two texture dimensions')
        }
      })

      if (texInfo.genMipmaps) {
        texture.mipmask = (faces[0].width << 1) - 1
      } else {
        texture.mipmask = faces[0].mipmask
      }

      check$1.textureCube(texture, texInfo, faces, limits)
      texture.internalformat = faces[0].internalformat

      reglTextureCube.width = faces[0].width
      reglTextureCube.height = faces[0].height

      tempBind(texture)
      for (i = 0; i < 6; ++i) {
        setMipMap(faces[i], GL_TEXTURE_CUBE_MAP_POSITIVE_X$1 + i)
      }
      setTexInfo(texInfo, GL_TEXTURE_CUBE_MAP$1)
      tempRestore()

      if (config.profile) {
        texture.stats.size = getTextureSize(
          texture.internalformat,
          texture.type,
          reglTextureCube.width,
          reglTextureCube.height,
          texInfo.genMipmaps,
          true)
      }

      reglTextureCube.format = textureFormatsInvert[texture.internalformat]
      reglTextureCube.type = textureTypesInvert[texture.type]

      reglTextureCube.mag = magFiltersInvert[texInfo.magFilter]
      reglTextureCube.min = minFiltersInvert[texInfo.minFilter]

      reglTextureCube.wrapS = wrapModesInvert[texInfo.wrapS]
      reglTextureCube.wrapT = wrapModesInvert[texInfo.wrapT]

      for (i = 0; i < 6; ++i) {
        freeMipMap(faces[i])
      }

      return reglTextureCube
    }

    function subimage (face, image, x_, y_, level_) {
      check$1(!!image, 'must specify image data')
      check$1(typeof face === 'number' && face === (face | 0) &&
        face >= 0 && face < 6, 'invalid face')

      var x = x_ | 0
      var y = y_ | 0
      var level = level_ | 0

      var imageData = allocImage()
      copyFlags(imageData, texture)
      imageData.width = 0
      imageData.height = 0
      parseImage(imageData, image)
      imageData.width = imageData.width || ((texture.width >> level) - x)
      imageData.height = imageData.height || ((texture.height >> level) - y)

      check$1(
        texture.type === imageData.type &&
        texture.format === imageData.format &&
        texture.internalformat === imageData.internalformat,
        'incompatible format for texture.subimage')
      check$1(
        x >= 0 && y >= 0 &&
        x + imageData.width <= texture.width &&
        y + imageData.height <= texture.height,
        'texture.subimage write out of bounds')
      check$1(
        texture.mipmask & (1 << level),
        'missing mipmap data')
      check$1(
        imageData.data || imageData.element || imageData.needsCopy,
        'missing image data')

      tempBind(texture)
      setSubImage(imageData, GL_TEXTURE_CUBE_MAP_POSITIVE_X$1 + face, x, y, level)
      tempRestore()

      freeImage(imageData)

      return reglTextureCube
    }

    function resize (radius_) {
      var radius = radius_ | 0
      if (radius === texture.width) {
        return
      }

      reglTextureCube.width = texture.width = radius
      reglTextureCube.height = texture.height = radius

      tempBind(texture)
      for (var i = 0; i < 6; ++i) {
        for (var j = 0; texture.mipmask >> j; ++j) {
          gl.texImage2D(
            GL_TEXTURE_CUBE_MAP_POSITIVE_X$1 + i,
            j,
            texture.format,
            radius >> j,
            radius >> j,
            0,
            texture.format,
            texture.type,
            null)
        }
      }
      tempRestore()

      if (config.profile) {
        texture.stats.size = getTextureSize(
          texture.internalformat,
          texture.type,
          reglTextureCube.width,
          reglTextureCube.height,
          false,
          true)
      }

      return reglTextureCube
    }

    reglTextureCube(a0, a1, a2, a3, a4, a5)

    reglTextureCube.subimage = subimage
    reglTextureCube.resize = resize
    reglTextureCube._reglType = 'textureCube'
    reglTextureCube._texture = texture
    if (config.profile) {
      reglTextureCube.stats = texture.stats
    }
    reglTextureCube.destroy = function () {
      texture.decRef()
    }

    return reglTextureCube
  }

  // Called when regl is destroyed
  function destroyTextures () {
    for (var i = 0; i < numTexUnits; ++i) {
      gl.activeTexture(GL_TEXTURE0$1 + i)
      gl.bindTexture(GL_TEXTURE_2D$1, null)
      textureUnits[i] = null
    }
    values(textureSet).forEach(destroy)

    stats.cubeCount = 0
    stats.textureCount = 0
  }

  if (config.profile) {
    stats.getTotalTextureSize = function () {
      var total = 0
      Object.keys(textureSet).forEach(function (key) {
        total += textureSet[key].stats.size
      })
      return total
    }
  }

  function restoreTextures () {
    for (var i = 0; i < numTexUnits; ++i) {
      var tex = textureUnits[i]
      if (tex) {
        tex.bindCount = 0
        tex.unit = -1
        textureUnits[i] = null
      }
    }

    values(textureSet).forEach(function (texture) {
      texture.texture = gl.createTexture()
      gl.bindTexture(texture.target, texture.texture)
      for (var i = 0; i < 32; ++i) {
        if ((texture.mipmask & (1 << i)) === 0) {
          continue
        }
        if (texture.target === GL_TEXTURE_2D$1) {
          gl.texImage2D(GL_TEXTURE_2D$1,
            i,
            texture.internalformat,
            texture.width >> i,
            texture.height >> i,
            0,
            texture.internalformat,
            texture.type,
            null)
        } else {
          for (var j = 0; j < 6; ++j) {
            gl.texImage2D(GL_TEXTURE_CUBE_MAP_POSITIVE_X$1 + j,
              i,
              texture.internalformat,
              texture.width >> i,
              texture.height >> i,
              0,
              texture.internalformat,
              texture.type,
              null)
          }
        }
      }
      setTexInfo(texture.texInfo, texture.target)
    })
  }

  function refreshTextures () {
    for (var i = 0; i < numTexUnits; ++i) {
      var tex = textureUnits[i]
      if (tex) {
        tex.bindCount = 0
        tex.unit = -1
        textureUnits[i] = null
      }
      gl.activeTexture(GL_TEXTURE0$1 + i)
      gl.bindTexture(GL_TEXTURE_2D$1, null)
      gl.bindTexture(GL_TEXTURE_CUBE_MAP$1, null)
    }
  }

  return {
    create2D: createTexture2D,
    createCube: createTextureCube,
    clear: destroyTextures,
    getTexture: function (wrapper) {
      return null
    },
    restore: restoreTextures,
    refresh: refreshTextures
  }
}

var GL_RENDERBUFFER = 0x8D41

var GL_RGBA4$1 = 0x8056
var GL_RGB5_A1$1 = 0x8057
var GL_RGB565$1 = 0x8D62
var GL_DEPTH_COMPONENT16 = 0x81A5
var GL_STENCIL_INDEX8 = 0x8D48
var GL_DEPTH_STENCIL$1 = 0x84F9

var GL_SRGB8_ALPHA8_EXT = 0x8C43

var GL_RGBA32F_EXT = 0x8814

var GL_RGBA16F_EXT = 0x881A
var GL_RGB16F_EXT = 0x881B

var FORMAT_SIZES = []

FORMAT_SIZES[GL_RGBA4$1] = 2
FORMAT_SIZES[GL_RGB5_A1$1] = 2
FORMAT_SIZES[GL_RGB565$1] = 2

FORMAT_SIZES[GL_DEPTH_COMPONENT16] = 2
FORMAT_SIZES[GL_STENCIL_INDEX8] = 1
FORMAT_SIZES[GL_DEPTH_STENCIL$1] = 4

FORMAT_SIZES[GL_SRGB8_ALPHA8_EXT] = 4
FORMAT_SIZES[GL_RGBA32F_EXT] = 16
FORMAT_SIZES[GL_RGBA16F_EXT] = 8
FORMAT_SIZES[GL_RGB16F_EXT] = 6

function getRenderbufferSize (format, width, height) {
  return FORMAT_SIZES[format] * width * height
}

var wrapRenderbuffers = function (gl, extensions, limits, stats, config) {
  var formatTypes = {
    'rgba4': GL_RGBA4$1,
    'rgb565': GL_RGB565$1,
    'rgb5 a1': GL_RGB5_A1$1,
    'depth': GL_DEPTH_COMPONENT16,
    'stencil': GL_STENCIL_INDEX8,
    'depth stencil': GL_DEPTH_STENCIL$1
  }

  if (extensions.ext_srgb) {
    formatTypes['srgba'] = GL_SRGB8_ALPHA8_EXT
  }

  if (extensions.ext_color_buffer_half_float) {
    formatTypes['rgba16f'] = GL_RGBA16F_EXT
    formatTypes['rgb16f'] = GL_RGB16F_EXT
  }

  if (extensions.webgl_color_buffer_float) {
    formatTypes['rgba32f'] = GL_RGBA32F_EXT
  }

  var formatTypesInvert = []
  Object.keys(formatTypes).forEach(function (key) {
    var val = formatTypes[key]
    formatTypesInvert[val] = key
  })

  var renderbufferCount = 0
  var renderbufferSet = {}

  function REGLRenderbuffer (renderbuffer) {
    this.id = renderbufferCount++
    this.refCount = 1

    this.renderbuffer = renderbuffer

    this.format = GL_RGBA4$1
    this.width = 0
    this.height = 0

    if (config.profile) {
      this.stats = { size: 0 }
    }
  }

  REGLRenderbuffer.prototype.decRef = function () {
    if (--this.refCount <= 0) {
      destroy(this)
    }
  }

  function destroy (rb) {
    var handle = rb.renderbuffer
    check$1(handle, 'must not double destroy renderbuffer')
    gl.bindRenderbuffer(GL_RENDERBUFFER, null)
    gl.deleteRenderbuffer(handle)
    rb.renderbuffer = null
    rb.refCount = 0
    delete renderbufferSet[rb.id]
    stats.renderbufferCount--
  }

  function createRenderbuffer (a, b) {
    var renderbuffer = new REGLRenderbuffer(gl.createRenderbuffer())
    renderbufferSet[renderbuffer.id] = renderbuffer
    stats.renderbufferCount++

    function reglRenderbuffer (a, b) {
      var w = 0
      var h = 0
      var format = GL_RGBA4$1

      if (typeof a === 'object' && a) {
        var options = a
        if ('shape' in options) {
          var shape = options.shape
          check$1(Array.isArray(shape) && shape.length >= 2,
            'invalid renderbuffer shape')
          w = shape[0] | 0
          h = shape[1] | 0
        } else {
          if ('radius' in options) {
            w = h = options.radius | 0
          }
          if ('width' in options) {
            w = options.width | 0
          }
          if ('height' in options) {
            h = options.height | 0
          }
        }
        if ('format' in options) {
          check$1.parameter(options.format, formatTypes,
            'invalid renderbuffer format')
          format = formatTypes[options.format]
        }
      } else if (typeof a === 'number') {
        w = a | 0
        if (typeof b === 'number') {
          h = b | 0
        } else {
          h = w
        }
      } else if (!a) {
        w = h = 1
      } else {
        check$1.raise('invalid arguments to renderbuffer constructor')
      }

      // check shape
      check$1(
        w > 0 && h > 0 &&
        w <= limits.maxRenderbufferSize && h <= limits.maxRenderbufferSize,
        'invalid renderbuffer size')

      if (w === renderbuffer.width &&
          h === renderbuffer.height &&
          format === renderbuffer.format) {
        return
      }

      reglRenderbuffer.width = renderbuffer.width = w
      reglRenderbuffer.height = renderbuffer.height = h
      renderbuffer.format = format

      gl.bindRenderbuffer(GL_RENDERBUFFER, renderbuffer.renderbuffer)
      gl.renderbufferStorage(GL_RENDERBUFFER, format, w, h)

      check$1(
        gl.getError() === 0,
        'invalid render buffer format')

      if (config.profile) {
        renderbuffer.stats.size = getRenderbufferSize(renderbuffer.format, renderbuffer.width, renderbuffer.height)
      }
      reglRenderbuffer.format = formatTypesInvert[renderbuffer.format]

      return reglRenderbuffer
    }

    function resize (w_, h_) {
      var w = w_ | 0
      var h = (h_ | 0) || w

      if (w === renderbuffer.width && h === renderbuffer.height) {
        return reglRenderbuffer
      }

      // check shape
      check$1(
        w > 0 && h > 0 &&
        w <= limits.maxRenderbufferSize && h <= limits.maxRenderbufferSize,
        'invalid renderbuffer size')

      reglRenderbuffer.width = renderbuffer.width = w
      reglRenderbuffer.height = renderbuffer.height = h

      gl.bindRenderbuffer(GL_RENDERBUFFER, renderbuffer.renderbuffer)
      gl.renderbufferStorage(GL_RENDERBUFFER, renderbuffer.format, w, h)

      check$1(
        gl.getError() === 0,
        'invalid render buffer format')

      // also, recompute size.
      if (config.profile) {
        renderbuffer.stats.size = getRenderbufferSize(
          renderbuffer.format, renderbuffer.width, renderbuffer.height)
      }

      return reglRenderbuffer
    }

    reglRenderbuffer(a, b)

    reglRenderbuffer.resize = resize
    reglRenderbuffer._reglType = 'renderbuffer'
    reglRenderbuffer._renderbuffer = renderbuffer
    if (config.profile) {
      reglRenderbuffer.stats = renderbuffer.stats
    }
    reglRenderbuffer.destroy = function () {
      renderbuffer.decRef()
    }

    return reglRenderbuffer
  }

  if (config.profile) {
    stats.getTotalRenderbufferSize = function () {
      var total = 0
      Object.keys(renderbufferSet).forEach(function (key) {
        total += renderbufferSet[key].stats.size
      })
      return total
    }
  }

  function restoreRenderbuffers () {
    values(renderbufferSet).forEach(function (rb) {
      rb.renderbuffer = gl.createRenderbuffer()
      gl.bindRenderbuffer(GL_RENDERBUFFER, rb.renderbuffer)
      gl.renderbufferStorage(GL_RENDERBUFFER, rb.format, rb.width, rb.height)
    })
    gl.bindRenderbuffer(GL_RENDERBUFFER, null)
  }

  return {
    create: createRenderbuffer,
    clear: function () {
      values(renderbufferSet).forEach(destroy)
    },
    restore: restoreRenderbuffers
  }
}

// We store these constants so that the minifier can inline them
var GL_FRAMEBUFFER$1 = 0x8D40
var GL_RENDERBUFFER$1 = 0x8D41

var GL_TEXTURE_2D$2 = 0x0DE1
var GL_TEXTURE_CUBE_MAP_POSITIVE_X$2 = 0x8515

var GL_COLOR_ATTACHMENT0$1 = 0x8CE0
var GL_DEPTH_ATTACHMENT = 0x8D00
var GL_STENCIL_ATTACHMENT = 0x8D20
var GL_DEPTH_STENCIL_ATTACHMENT = 0x821A

var GL_FRAMEBUFFER_COMPLETE$1 = 0x8CD5
var GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 0x8CD6
var GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 0x8CD7
var GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS = 0x8CD9
var GL_FRAMEBUFFER_UNSUPPORTED = 0x8CDD

var GL_HALF_FLOAT_OES$2 = 0x8D61
var GL_UNSIGNED_BYTE$6 = 0x1401
var GL_FLOAT$5 = 0x1406

var GL_RGB$1 = 0x1907
var GL_RGBA$2 = 0x1908

var GL_DEPTH_COMPONENT$1 = 0x1902

var colorTextureFormatEnums = [
  GL_RGB$1,
  GL_RGBA$2
]

// for every texture format, store
// the number of channels
var textureFormatChannels = []
textureFormatChannels[GL_RGBA$2] = 4
textureFormatChannels[GL_RGB$1] = 3

// for every texture type, store
// the size in bytes.
var textureTypeSizes = []
textureTypeSizes[GL_UNSIGNED_BYTE$6] = 1
textureTypeSizes[GL_FLOAT$5] = 4
textureTypeSizes[GL_HALF_FLOAT_OES$2] = 2

var GL_RGBA4$2 = 0x8056
var GL_RGB5_A1$2 = 0x8057
var GL_RGB565$2 = 0x8D62
var GL_DEPTH_COMPONENT16$1 = 0x81A5
var GL_STENCIL_INDEX8$1 = 0x8D48
var GL_DEPTH_STENCIL$2 = 0x84F9

var GL_SRGB8_ALPHA8_EXT$1 = 0x8C43

var GL_RGBA32F_EXT$1 = 0x8814

var GL_RGBA16F_EXT$1 = 0x881A
var GL_RGB16F_EXT$1 = 0x881B

var colorRenderbufferFormatEnums = [
  GL_RGBA4$2,
  GL_RGB5_A1$2,
  GL_RGB565$2,
  GL_SRGB8_ALPHA8_EXT$1,
  GL_RGBA16F_EXT$1,
  GL_RGB16F_EXT$1,
  GL_RGBA32F_EXT$1
]

var statusCode = {}
statusCode[GL_FRAMEBUFFER_COMPLETE$1] = 'complete'
statusCode[GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT] = 'incomplete attachment'
statusCode[GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS] = 'incomplete dimensions'
statusCode[GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT] = 'incomplete, missing attachment'
statusCode[GL_FRAMEBUFFER_UNSUPPORTED] = 'unsupported'

function wrapFBOState (
  gl,
  extensions,
  limits,
  textureState,
  renderbufferState,
  stats) {
  var framebufferState = {
    cur: null,
    next: null,
    dirty: false,
    setFBO: null
  }

  var colorTextureFormats = ['rgba']
  var colorRenderbufferFormats = ['rgba4', 'rgb565', 'rgb5 a1']

  if (extensions.ext_srgb) {
    colorRenderbufferFormats.push('srgba')
  }

  if (extensions.ext_color_buffer_half_float) {
    colorRenderbufferFormats.push('rgba16f', 'rgb16f')
  }

  if (extensions.webgl_color_buffer_float) {
    colorRenderbufferFormats.push('rgba32f')
  }

  var colorTypes = ['uint8']
  if (extensions.oes_texture_half_float) {
    colorTypes.push('half float', 'float16')
  }
  if (extensions.oes_texture_float) {
    colorTypes.push('float', 'float32')
  }

  function FramebufferAttachment (target, texture, renderbuffer) {
    this.target = target
    this.texture = texture
    this.renderbuffer = renderbuffer

    var w = 0
    var h = 0
    if (texture) {
      w = texture.width
      h = texture.height
    } else if (renderbuffer) {
      w = renderbuffer.width
      h = renderbuffer.height
    }
    this.width = w
    this.height = h
  }

  function decRef (attachment) {
    if (attachment) {
      if (attachment.texture) {
        attachment.texture._texture.decRef()
      }
      if (attachment.renderbuffer) {
        attachment.renderbuffer._renderbuffer.decRef()
      }
    }
  }

  function incRefAndCheckShape (attachment, width, height) {
    if (!attachment) {
      return
    }
    if (attachment.texture) {
      var texture = attachment.texture._texture
      var tw = Math.max(1, texture.width)
      var th = Math.max(1, texture.height)
      check$1(tw === width && th === height,
        'inconsistent width/height for supplied texture')
      texture.refCount += 1
    } else {
      var renderbuffer = attachment.renderbuffer._renderbuffer
      check$1(
        renderbuffer.width === width && renderbuffer.height === height,
        'inconsistent width/height for renderbuffer')
      renderbuffer.refCount += 1
    }
  }

  function attach (location, attachment) {
    if (attachment) {
      if (attachment.texture) {
        gl.framebufferTexture2D(
          GL_FRAMEBUFFER$1,
          location,
          attachment.target,
          attachment.texture._texture.texture,
          0)
      } else {
        gl.framebufferRenderbuffer(
          GL_FRAMEBUFFER$1,
          location,
          GL_RENDERBUFFER$1,
          attachment.renderbuffer._renderbuffer.renderbuffer)
      }
    }
  }

  function parseAttachment (attachment) {
    var target = GL_TEXTURE_2D$2
    var texture = null
    var renderbuffer = null

    var data = attachment
    if (typeof attachment === 'object') {
      data = attachment.data
      if ('target' in attachment) {
        target = attachment.target | 0
      }
    }

    check$1.type(data, 'function', 'invalid attachment data')

    var type = data._reglType
    if (type === 'texture2d') {
      texture = data
      check$1(target === GL_TEXTURE_2D$2)
    } else if (type === 'textureCube') {
      texture = data
      check$1(
        target >= GL_TEXTURE_CUBE_MAP_POSITIVE_X$2 &&
        target < GL_TEXTURE_CUBE_MAP_POSITIVE_X$2 + 6,
        'invalid cube map target')
    } else if (type === 'renderbuffer') {
      renderbuffer = data
      target = GL_RENDERBUFFER$1
    } else {
      check$1.raise('invalid regl object for attachment')
    }

    return new FramebufferAttachment(target, texture, renderbuffer)
  }

  function allocAttachment (
    width,
    height,
    isTexture,
    format,
    type) {
    if (isTexture) {
      var texture = textureState.create2D({
        width: width,
        height: height,
        format: format,
        type: type
      })
      texture._texture.refCount = 0
      return new FramebufferAttachment(GL_TEXTURE_2D$2, texture, null)
    } else {
      var rb = renderbufferState.create({
        width: width,
        height: height,
        format: format
      })
      rb._renderbuffer.refCount = 0
      return new FramebufferAttachment(GL_RENDERBUFFER$1, null, rb)
    }
  }

  function unwrapAttachment (attachment) {
    return attachment && (attachment.texture || attachment.renderbuffer)
  }

  function resizeAttachment (attachment, w, h) {
    if (attachment) {
      if (attachment.texture) {
        attachment.texture.resize(w, h)
      } else if (attachment.renderbuffer) {
        attachment.renderbuffer.resize(w, h)
      }
      attachment.width = w
      attachment.height = h
    }
  }

  var framebufferCount = 0
  var framebufferSet = {}

  function REGLFramebuffer () {
    this.id = framebufferCount++
    framebufferSet[this.id] = this

    this.framebuffer = gl.createFramebuffer()
    this.width = 0
    this.height = 0

    this.colorAttachments = []
    this.depthAttachment = null
    this.stencilAttachment = null
    this.depthStencilAttachment = null
  }

  function decFBORefs (framebuffer) {
    framebuffer.colorAttachments.forEach(decRef)
    decRef(framebuffer.depthAttachment)
    decRef(framebuffer.stencilAttachment)
    decRef(framebuffer.depthStencilAttachment)
  }

  function destroy (framebuffer) {
    var handle = framebuffer.framebuffer
    check$1(handle, 'must not double destroy framebuffer')
    gl.deleteFramebuffer(handle)
    framebuffer.framebuffer = null
    stats.framebufferCount--
    delete framebufferSet[framebuffer.id]
  }

  function updateFramebuffer (framebuffer) {
    var i

    gl.bindFramebuffer(GL_FRAMEBUFFER$1, framebuffer.framebuffer)
    var colorAttachments = framebuffer.colorAttachments
    for (i = 0; i < colorAttachments.length; ++i) {
      attach(GL_COLOR_ATTACHMENT0$1 + i, colorAttachments[i])
    }
    for (i = colorAttachments.length; i < limits.maxColorAttachments; ++i) {
      gl.framebufferTexture2D(
        GL_FRAMEBUFFER$1,
        GL_COLOR_ATTACHMENT0$1 + i,
        GL_TEXTURE_2D$2,
        null,
        0)
    }

    gl.framebufferTexture2D(
      GL_FRAMEBUFFER$1,
      GL_DEPTH_STENCIL_ATTACHMENT,
      GL_TEXTURE_2D$2,
      null,
      0)
    gl.framebufferTexture2D(
      GL_FRAMEBUFFER$1,
      GL_DEPTH_ATTACHMENT,
      GL_TEXTURE_2D$2,
      null,
      0)
    gl.framebufferTexture2D(
      GL_FRAMEBUFFER$1,
      GL_STENCIL_ATTACHMENT,
      GL_TEXTURE_2D$2,
      null,
      0)

    attach(GL_DEPTH_ATTACHMENT, framebuffer.depthAttachment)
    attach(GL_STENCIL_ATTACHMENT, framebuffer.stencilAttachment)
    attach(GL_DEPTH_STENCIL_ATTACHMENT, framebuffer.depthStencilAttachment)

    // Check status code
    var status = gl.checkFramebufferStatus(GL_FRAMEBUFFER$1)
    if (!gl.isContextLost() && status !== GL_FRAMEBUFFER_COMPLETE$1) {
      check$1.raise('framebuffer configuration not supported, status = ' +
        statusCode[status])
    }

    gl.bindFramebuffer(GL_FRAMEBUFFER$1, framebufferState.next ? framebufferState.next.framebuffer : null)
    framebufferState.cur = framebufferState.next

    // FIXME: Clear error code here.  This is a work around for a bug in
    // headless-gl
    gl.getError()
  }

  function createFBO (a0, a1) {
    var framebuffer = new REGLFramebuffer()
    stats.framebufferCount++

    function reglFramebuffer (a, b) {
      var i

      check$1(framebufferState.next !== framebuffer,
        'can not update framebuffer which is currently in use')

      var width = 0
      var height = 0

      var needsDepth = true
      var needsStencil = true

      var colorBuffer = null
      var colorTexture = true
      var colorFormat = 'rgba'
      var colorType = 'uint8'
      var colorCount = 1

      var depthBuffer = null
      var stencilBuffer = null
      var depthStencilBuffer = null
      var depthStencilTexture = false

      if (typeof a === 'number') {
        width = a | 0
        height = (b | 0) || width
      } else if (!a) {
        width = height = 1
      } else {
        check$1.type(a, 'object', 'invalid arguments for framebuffer')
        var options = a

        if ('shape' in options) {
          var shape = options.shape
          check$1(Array.isArray(shape) && shape.length >= 2,
            'invalid shape for framebuffer')
          width = shape[0]
          height = shape[1]
        } else {
          if ('radius' in options) {
            width = height = options.radius
          }
          if ('width' in options) {
            width = options.width
          }
          if ('height' in options) {
            height = options.height
          }
        }

        if ('color' in options ||
            'colors' in options) {
          colorBuffer =
            options.color ||
            options.colors
          if (Array.isArray(colorBuffer)) {
            check$1(
              colorBuffer.length === 1 || extensions.webgl_draw_buffers,
              'multiple render targets not supported')
          }
        }

        if (!colorBuffer) {
          if ('colorCount' in options) {
            colorCount = options.colorCount | 0
            check$1(colorCount > 0, 'invalid color buffer count')
          }

          if ('colorTexture' in options) {
            colorTexture = !!options.colorTexture
            colorFormat = 'rgba4'
          }

          if ('colorType' in options) {
            colorType = options.colorType
            if (!colorTexture) {
              if (colorType === 'half float' || colorType === 'float16') {
                check$1(extensions.ext_color_buffer_half_float,
                  'you must enable EXT_color_buffer_half_float to use 16-bit render buffers')
                colorFormat = 'rgba16f'
              } else if (colorType === 'float' || colorType === 'float32') {
                check$1(extensions.webgl_color_buffer_float,
                  'you must enable WEBGL_color_buffer_float in order to use 32-bit floating point renderbuffers')
                colorFormat = 'rgba32f'
              }
            } else {
              check$1(extensions.oes_texture_float ||
                !(colorType === 'float' || colorType === 'float32'),
              'you must enable OES_texture_float in order to use floating point framebuffer objects')
              check$1(extensions.oes_texture_half_float ||
                !(colorType === 'half float' || colorType === 'float16'),
              'you must enable OES_texture_half_float in order to use 16-bit floating point framebuffer objects')
            }
            check$1.oneOf(colorType, colorTypes, 'invalid color type')
          }

          if ('colorFormat' in options) {
            colorFormat = options.colorFormat
            if (colorTextureFormats.indexOf(colorFormat) >= 0) {
              colorTexture = true
            } else if (colorRenderbufferFormats.indexOf(colorFormat) >= 0) {
              colorTexture = false
            } else {
              check$1.optional(function () {
                if (colorTexture) {
                  check$1.oneOf(
                    options.colorFormat, colorTextureFormats,
                    'invalid color format for texture')
                } else {
                  check$1.oneOf(
                    options.colorFormat, colorRenderbufferFormats,
                    'invalid color format for renderbuffer')
                }
              })
            }
          }
        }

        if ('depthTexture' in options || 'depthStencilTexture' in options) {
          depthStencilTexture = !!(options.depthTexture ||
            options.depthStencilTexture)
          check$1(!depthStencilTexture || extensions.webgl_depth_texture,
            'webgl_depth_texture extension not supported')
        }

        if ('depth' in options) {
          if (typeof options.depth === 'boolean') {
            needsDepth = options.depth
          } else {
            depthBuffer = options.depth
            needsStencil = false
          }
        }

        if ('stencil' in options) {
          if (typeof options.stencil === 'boolean') {
            needsStencil = options.stencil
          } else {
            stencilBuffer = options.stencil
            needsDepth = false
          }
        }

        if ('depthStencil' in options) {
          if (typeof options.depthStencil === 'boolean') {
            needsDepth = needsStencil = options.depthStencil
          } else {
            depthStencilBuffer = options.depthStencil
            needsDepth = false
            needsStencil = false
          }
        }
      }

      // parse attachments
      var colorAttachments = null
      var depthAttachment = null
      var stencilAttachment = null
      var depthStencilAttachment = null

      // Set up color attachments
      if (Array.isArray(colorBuffer)) {
        colorAttachments = colorBuffer.map(parseAttachment)
      } else if (colorBuffer) {
        colorAttachments = [parseAttachment(colorBuffer)]
      } else {
        colorAttachments = new Array(colorCount)
        for (i = 0; i < colorCount; ++i) {
          colorAttachments[i] = allocAttachment(
            width,
            height,
            colorTexture,
            colorFormat,
            colorType)
        }
      }

      check$1(extensions.webgl_draw_buffers || colorAttachments.length <= 1,
        'you must enable the WEBGL_draw_buffers extension in order to use multiple color buffers.')
      check$1(colorAttachments.length <= limits.maxColorAttachments,
        'too many color attachments, not supported')

      width = width || colorAttachments[0].width
      height = height || colorAttachments[0].height

      if (depthBuffer) {
        depthAttachment = parseAttachment(depthBuffer)
      } else if (needsDepth && !needsStencil) {
        depthAttachment = allocAttachment(
          width,
          height,
          depthStencilTexture,
          'depth',
          'uint32')
      }

      if (stencilBuffer) {
        stencilAttachment = parseAttachment(stencilBuffer)
      } else if (needsStencil && !needsDepth) {
        stencilAttachment = allocAttachment(
          width,
          height,
          false,
          'stencil',
          'uint8')
      }

      if (depthStencilBuffer) {
        depthStencilAttachment = parseAttachment(depthStencilBuffer)
      } else if (!depthBuffer && !stencilBuffer && needsStencil && needsDepth) {
        depthStencilAttachment = allocAttachment(
          width,
          height,
          depthStencilTexture,
          'depth stencil',
          'depth stencil')
      }

      check$1(
        (!!depthBuffer) + (!!stencilBuffer) + (!!depthStencilBuffer) <= 1,
        'invalid framebuffer configuration, can specify exactly one depth/stencil attachment')

      var commonColorAttachmentSize = null

      for (i = 0; i < colorAttachments.length; ++i) {
        incRefAndCheckShape(colorAttachments[i], width, height)
        check$1(!colorAttachments[i] ||
          (colorAttachments[i].texture &&
            colorTextureFormatEnums.indexOf(colorAttachments[i].texture._texture.format) >= 0) ||
          (colorAttachments[i].renderbuffer &&
            colorRenderbufferFormatEnums.indexOf(colorAttachments[i].renderbuffer._renderbuffer.format) >= 0),
        'framebuffer color attachment ' + i + ' is invalid')

        if (colorAttachments[i] && colorAttachments[i].texture) {
          var colorAttachmentSize =
              textureFormatChannels[colorAttachments[i].texture._texture.format] *
              textureTypeSizes[colorAttachments[i].texture._texture.type]

          if (commonColorAttachmentSize === null) {
            commonColorAttachmentSize = colorAttachmentSize
          } else {
            // We need to make sure that all color attachments have the same number of bitplanes
            // (that is, the same numer of bits per pixel)
            // This is required by the GLES2.0 standard. See the beginning of Chapter 4 in that document.
            check$1(commonColorAttachmentSize === colorAttachmentSize,
              'all color attachments much have the same number of bits per pixel.')
          }
        }
      }
      incRefAndCheckShape(depthAttachment, width, height)
      check$1(!depthAttachment ||
        (depthAttachment.texture &&
          depthAttachment.texture._texture.format === GL_DEPTH_COMPONENT$1) ||
        (depthAttachment.renderbuffer &&
          depthAttachment.renderbuffer._renderbuffer.format === GL_DEPTH_COMPONENT16$1),
      'invalid depth attachment for framebuffer object')
      incRefAndCheckShape(stencilAttachment, width, height)
      check$1(!stencilAttachment ||
        (stencilAttachment.renderbuffer &&
          stencilAttachment.renderbuffer._renderbuffer.format === GL_STENCIL_INDEX8$1),
      'invalid stencil attachment for framebuffer object')
      incRefAndCheckShape(depthStencilAttachment, width, height)
      check$1(!depthStencilAttachment ||
        (depthStencilAttachment.texture &&
          depthStencilAttachment.texture._texture.format === GL_DEPTH_STENCIL$2) ||
        (depthStencilAttachment.renderbuffer &&
          depthStencilAttachment.renderbuffer._renderbuffer.format === GL_DEPTH_STENCIL$2),
      'invalid depth-stencil attachment for framebuffer object')

      // decrement references
      decFBORefs(framebuffer)

      framebuffer.width = width
      framebuffer.height = height

      framebuffer.colorAttachments = colorAttachments
      framebuffer.depthAttachment = depthAttachment
      framebuffer.stencilAttachment = stencilAttachment
      framebuffer.depthStencilAttachment = depthStencilAttachment

      reglFramebuffer.color = colorAttachments.map(unwrapAttachment)
      reglFramebuffer.depth = unwrapAttachment(depthAttachment)
      reglFramebuffer.stencil = unwrapAttachment(stencilAttachment)
      reglFramebuffer.depthStencil = unwrapAttachment(depthStencilAttachment)

      reglFramebuffer.width = framebuffer.width
      reglFramebuffer.height = framebuffer.height

      updateFramebuffer(framebuffer)

      return reglFramebuffer
    }

    function resize (w_, h_) {
      check$1(framebufferState.next !== framebuffer,
        'can not resize a framebuffer which is currently in use')

      var w = Math.max(w_ | 0, 1)
      var h = Math.max((h_ | 0) || w, 1)
      if (w === framebuffer.width && h === framebuffer.height) {
        return reglFramebuffer
      }

      // resize all buffers
      var colorAttachments = framebuffer.colorAttachments
      for (var i = 0; i < colorAttachments.length; ++i) {
        resizeAttachment(colorAttachments[i], w, h)
      }
      resizeAttachment(framebuffer.depthAttachment, w, h)
      resizeAttachment(framebuffer.stencilAttachment, w, h)
      resizeAttachment(framebuffer.depthStencilAttachment, w, h)

      framebuffer.width = reglFramebuffer.width = w
      framebuffer.height = reglFramebuffer.height = h

      updateFramebuffer(framebuffer)

      return reglFramebuffer
    }

    reglFramebuffer(a0, a1)

    return extend(reglFramebuffer, {
      resize: resize,
      _reglType: 'framebuffer',
      _framebuffer: framebuffer,
      destroy: function () {
        destroy(framebuffer)
        decFBORefs(framebuffer)
      },
      use: function (block) {
        framebufferState.setFBO({
          framebuffer: reglFramebuffer
        }, block)
      }
    })
  }

  function createCubeFBO (options) {
    var faces = Array(6)

    function reglFramebufferCube (a) {
      var i

      check$1(faces.indexOf(framebufferState.next) < 0,
        'can not update framebuffer which is currently in use')

      var params = {
        color: null
      }

      var radius = 0

      var colorBuffer = null
      var colorFormat = 'rgba'
      var colorType = 'uint8'
      var colorCount = 1

      if (typeof a === 'number') {
        radius = a | 0
      } else if (!a) {
        radius = 1
      } else {
        check$1.type(a, 'object', 'invalid arguments for framebuffer')
        var options = a

        if ('shape' in options) {
          var shape = options.shape
          check$1(
            Array.isArray(shape) && shape.length >= 2,
            'invalid shape for framebuffer')
          check$1(
            shape[0] === shape[1],
            'cube framebuffer must be square')
          radius = shape[0]
        } else {
          if ('radius' in options) {
            radius = options.radius | 0
          }
          if ('width' in options) {
            radius = options.width | 0
            if ('height' in options) {
              check$1(options.height === radius, 'must be square')
            }
          } else if ('height' in options) {
            radius = options.height | 0
          }
        }

        if ('color' in options ||
            'colors' in options) {
          colorBuffer =
            options.color ||
            options.colors
          if (Array.isArray(colorBuffer)) {
            check$1(
              colorBuffer.length === 1 || extensions.webgl_draw_buffers,
              'multiple render targets not supported')
          }
        }

        if (!colorBuffer) {
          if ('colorCount' in options) {
            colorCount = options.colorCount | 0
            check$1(colorCount > 0, 'invalid color buffer count')
          }

          if ('colorType' in options) {
            check$1.oneOf(
              options.colorType, colorTypes,
              'invalid color type')
            colorType = options.colorType
          }

          if ('colorFormat' in options) {
            colorFormat = options.colorFormat
            check$1.oneOf(
              options.colorFormat, colorTextureFormats,
              'invalid color format for texture')
          }
        }

        if ('depth' in options) {
          params.depth = options.depth
        }

        if ('stencil' in options) {
          params.stencil = options.stencil
        }

        if ('depthStencil' in options) {
          params.depthStencil = options.depthStencil
        }
      }

      var colorCubes
      if (colorBuffer) {
        if (Array.isArray(colorBuffer)) {
          colorCubes = []
          for (i = 0; i < colorBuffer.length; ++i) {
            colorCubes[i] = colorBuffer[i]
          }
        } else {
          colorCubes = [ colorBuffer ]
        }
      } else {
        colorCubes = Array(colorCount)
        var cubeMapParams = {
          radius: radius,
          format: colorFormat,
          type: colorType
        }
        for (i = 0; i < colorCount; ++i) {
          colorCubes[i] = textureState.createCube(cubeMapParams)
        }
      }

      // Check color cubes
      params.color = Array(colorCubes.length)
      for (i = 0; i < colorCubes.length; ++i) {
        var cube = colorCubes[i]
        check$1(
          typeof cube === 'function' && cube._reglType === 'textureCube',
          'invalid cube map')
        radius = radius || cube.width
        check$1(
          cube.width === radius && cube.height === radius,
          'invalid cube map shape')
        params.color[i] = {
          target: GL_TEXTURE_CUBE_MAP_POSITIVE_X$2,
          data: colorCubes[i]
        }
      }

      for (i = 0; i < 6; ++i) {
        for (var j = 0; j < colorCubes.length; ++j) {
          params.color[j].target = GL_TEXTURE_CUBE_MAP_POSITIVE_X$2 + i
        }
        // reuse depth-stencil attachments across all cube maps
        if (i > 0) {
          params.depth = faces[0].depth
          params.stencil = faces[0].stencil
          params.depthStencil = faces[0].depthStencil
        }
        if (faces[i]) {
          (faces[i])(params)
        } else {
          faces[i] = createFBO(params)
        }
      }

      return extend(reglFramebufferCube, {
        width: radius,
        height: radius,
        color: colorCubes
      })
    }

    function resize (radius_) {
      var i
      var radius = radius_ | 0
      check$1(radius > 0 && radius <= limits.maxCubeMapSize,
        'invalid radius for cube fbo')

      if (radius === reglFramebufferCube.width) {
        return reglFramebufferCube
      }

      var colors = reglFramebufferCube.color
      for (i = 0; i < colors.length; ++i) {
        colors[i].resize(radius)
      }

      for (i = 0; i < 6; ++i) {
        faces[i].resize(radius)
      }

      reglFramebufferCube.width = reglFramebufferCube.height = radius

      return reglFramebufferCube
    }

    reglFramebufferCube(options)

    return extend(reglFramebufferCube, {
      faces: faces,
      resize: resize,
      _reglType: 'framebufferCube',
      destroy: function () {
        faces.forEach(function (f) {
          f.destroy()
        })
      }
    })
  }

  function restoreFramebuffers () {
    framebufferState.cur = null
    framebufferState.next = null
    framebufferState.dirty = true
    values(framebufferSet).forEach(function (fb) {
      fb.framebuffer = gl.createFramebuffer()
      updateFramebuffer(fb)
    })
  }

  return extend(framebufferState, {
    getFramebuffer: function (object) {
      if (typeof object === 'function' && object._reglType === 'framebuffer') {
        var fbo = object._framebuffer
        if (fbo instanceof REGLFramebuffer) {
          return fbo
        }
      }
      return null
    },
    create: createFBO,
    createCube: createCubeFBO,
    clear: function () {
      values(framebufferSet).forEach(destroy)
    },
    restore: restoreFramebuffers
  })
}

var GL_FLOAT$6 = 5126
var GL_ARRAY_BUFFER$1 = 34962
var GL_ELEMENT_ARRAY_BUFFER$1 = 34963

var VAO_OPTIONS = [
  'attributes',
  'elements',
  'offset',
  'count',
  'primitive',
  'instances'
]

function AttributeRecord () {
  this.state = 0

  this.x = 0.0
  this.y = 0.0
  this.z = 0.0
  this.w = 0.0

  this.buffer = null
  this.size = 0
  this.normalized = false
  this.type = GL_FLOAT$6
  this.offset = 0
  this.stride = 0
  this.divisor = 0
}

function wrapAttributeState (
  gl,
  extensions,
  limits,
  stats,
  bufferState,
  elementState,
  drawState) {
  var NUM_ATTRIBUTES = limits.maxAttributes
  var attributeBindings = new Array(NUM_ATTRIBUTES)
  for (var i = 0; i < NUM_ATTRIBUTES; ++i) {
    attributeBindings[i] = new AttributeRecord()
  }
  var vaoCount = 0
  var vaoSet = {}

  var state = {
    Record: AttributeRecord,
    scope: {},
    state: attributeBindings,
    currentVAO: null,
    targetVAO: null,
    restore: extVAO() ? restoreVAO : function () {},
    createVAO: createVAO,
    getVAO: getVAO,
    destroyBuffer: destroyBuffer,
    setVAO: extVAO() ? setVAOEXT : setVAOEmulated,
    clear: extVAO() ? destroyVAOEXT : function () {}
  }

  function destroyBuffer (buffer) {
    for (var i = 0; i < attributeBindings.length; ++i) {
      var record = attributeBindings[i]
      if (record.buffer === buffer) {
        gl.disableVertexAttribArray(i)
        record.buffer = null
      }
    }
  }

  function extVAO () {
    return extensions.oes_vertex_array_object
  }

  function extInstanced () {
    return extensions.angle_instanced_arrays
  }

  function getVAO (vao) {
    if (typeof vao === 'function' && vao._vao) {
      return vao._vao
    }
    return null
  }

  function setVAOEXT (vao) {
    if (vao === state.currentVAO) {
      return
    }
    var ext = extVAO()
    if (vao) {
      ext.bindVertexArrayOES(vao.vao)
    } else {
      ext.bindVertexArrayOES(null)
    }
    state.currentVAO = vao
  }

  function setVAOEmulated (vao) {
    if (vao === state.currentVAO) {
      return
    }
    if (vao) {
      vao.bindAttrs()
    } else {
      var exti = extInstanced()
      for (var i = 0; i < attributeBindings.length; ++i) {
        var binding = attributeBindings[i]
        if (binding.buffer) {
          gl.enableVertexAttribArray(i)
          binding.buffer.bind()
          gl.vertexAttribPointer(i, binding.size, binding.type, binding.normalized, binding.stride, binding.offfset)
          if (exti && binding.divisor) {
            exti.vertexAttribDivisorANGLE(i, binding.divisor)
          }
        } else {
          gl.disableVertexAttribArray(i)
          gl.vertexAttrib4f(i, binding.x, binding.y, binding.z, binding.w)
        }
      }
      if (drawState.elements) {
        gl.bindBuffer(GL_ELEMENT_ARRAY_BUFFER$1, drawState.elements.buffer.buffer)
      } else {
        gl.bindBuffer(GL_ELEMENT_ARRAY_BUFFER$1, null)
      }
    }
    state.currentVAO = vao
  }

  function destroyVAOEXT () {
    values(vaoSet).forEach(function (vao) {
      vao.destroy()
    })
  }

  function REGLVAO () {
    this.id = ++vaoCount
    this.attributes = []
    this.elements = null
    this.ownsElements = false
    this.count = 0
    this.offset = 0
    this.instances = -1
    this.primitive = 4
    var extension = extVAO()
    if (extension) {
      this.vao = extension.createVertexArrayOES()
    } else {
      this.vao = null
    }
    vaoSet[this.id] = this
    this.buffers = []
  }

  REGLVAO.prototype.bindAttrs = function () {
    var exti = extInstanced()
    var attributes = this.attributes
    for (var i = 0; i < attributes.length; ++i) {
      var attr = attributes[i]
      if (attr.buffer) {
        gl.enableVertexAttribArray(i)
        gl.bindBuffer(GL_ARRAY_BUFFER$1, attr.buffer.buffer)
        gl.vertexAttribPointer(i, attr.size, attr.type, attr.normalized, attr.stride, attr.offset)
        if (exti && attr.divisor) {
          exti.vertexAttribDivisorANGLE(i, attr.divisor)
        }
      } else {
        gl.disableVertexAttribArray(i)
        gl.vertexAttrib4f(i, attr.x, attr.y, attr.z, attr.w)
      }
    }
    for (var j = attributes.length; j < NUM_ATTRIBUTES; ++j) {
      gl.disableVertexAttribArray(j)
    }
    var elements = elementState.getElements(this.elements)
    if (elements) {
      gl.bindBuffer(GL_ELEMENT_ARRAY_BUFFER$1, elements.buffer.buffer)
    } else {
      gl.bindBuffer(GL_ELEMENT_ARRAY_BUFFER$1, null)
    }
  }

  REGLVAO.prototype.refresh = function () {
    var ext = extVAO()
    if (ext) {
      ext.bindVertexArrayOES(this.vao)
      this.bindAttrs()
      state.currentVAO = null
      ext.bindVertexArrayOES(null)
    }
  }

  REGLVAO.prototype.destroy = function () {
    if (this.vao) {
      var extension = extVAO()
      if (this === state.currentVAO) {
        state.currentVAO = null
        extension.bindVertexArrayOES(null)
      }
      extension.deleteVertexArrayOES(this.vao)
      this.vao = null
    }
    if (this.ownsElements) {
      this.elements.destroy()
      this.elements = null
      this.ownsElements = false
    }
    if (vaoSet[this.id]) {
      delete vaoSet[this.id]
      stats.vaoCount -= 1
    }
  }

  function restoreVAO () {
    var ext = extVAO()
    if (ext) {
      values(vaoSet).forEach(function (vao) {
        vao.refresh()
      })
    }
  }

  function createVAO (_attr) {
    var vao = new REGLVAO()
    stats.vaoCount += 1

    function updateVAO (options) {
      var attributes
      if (Array.isArray(options)) {
        attributes = options
        if (vao.elements && vao.ownsElements) {
          vao.elements.destroy()
        }
        vao.elements = null
        vao.ownsElements = false
        vao.offset = 0
        vao.count = 0
        vao.instances = -1
        vao.primitive = 4
      } else {
        check$1(typeof options === 'object', 'invalid arguments for create vao')
        check$1('attributes' in options, 'must specify attributes for vao')
        if (options.elements) {
          var elements = options.elements
          if (vao.ownsElements) {
            if (typeof elements === 'function' && elements._reglType === 'elements') {
              vao.elements.destroy()
              vao.ownsElements = false
            } else {
              vao.elements(elements)
              vao.ownsElements = false
            }
          } else if (elementState.getElements(options.elements)) {
            vao.elements = options.elements
            vao.ownsElements = false
          } else {
            vao.elements = elementState.create(options.elements)
            vao.ownsElements = true
          }
        } else {
          vao.elements = null
          vao.ownsElements = false
        }
        attributes = options.attributes

        // set default vao
        vao.offset = 0
        vao.count = -1
        vao.instances = -1
        vao.primitive = 4

        // copy element properties
        if (vao.elements) {
          vao.count = vao.elements._elements.vertCount
          vao.primitive = vao.elements._elements.primType
        }

        if ('offset' in options) {
          vao.offset = options.offset | 0
        }
        if ('count' in options) {
          vao.count = options.count | 0
        }
        if ('instances' in options) {
          vao.instances = options.instances | 0
        }
        if ('primitive' in options) {
          check$1(options.primitive in primTypes, 'bad primitive type: ' + options.primitive)
          vao.primitive = primTypes[options.primitive]
        }

        check$1.optional(() => {
          var keys = Object.keys(options)
          for (var i = 0; i < keys.length; ++i) {
            check$1(VAO_OPTIONS.indexOf(keys[i]) >= 0, 'invalid option for vao: "' + keys[i] + '" valid options are ' + VAO_OPTIONS)
          }
        })
        check$1(Array.isArray(attributes), 'attributes must be an array')
      }

      check$1(attributes.length < NUM_ATTRIBUTES, 'too many attributes')
      check$1(attributes.length > 0, 'must specify at least one attribute')

      var bufUpdated = {}
      var nattributes = vao.attributes
      nattributes.length = attributes.length
      for (var i = 0; i < attributes.length; ++i) {
        var spec = attributes[i]
        var rec = nattributes[i] = new AttributeRecord()
        var data = spec.data || spec
        if (Array.isArray(data) || isTypedArray(data) || isNDArrayLike(data)) {
          var buf
          if (vao.buffers[i]) {
            buf = vao.buffers[i]
            if (isTypedArray(data) && buf._buffer.byteLength >= data.byteLength) {
              buf.subdata(data)
            } else {
              buf.destroy()
              vao.buffers[i] = null
            }
          }
          if (!vao.buffers[i]) {
            buf = vao.buffers[i] = bufferState.create(spec, GL_ARRAY_BUFFER$1, false, true)
          }
          rec.buffer = bufferState.getBuffer(buf)
          rec.size = rec.buffer.dimension | 0
          rec.normalized = false
          rec.type = rec.buffer.dtype
          rec.offset = 0
          rec.stride = 0
          rec.divisor = 0
          rec.state = 1
          bufUpdated[i] = 1
        } else if (bufferState.getBuffer(spec)) {
          rec.buffer = bufferState.getBuffer(spec)
          rec.size = rec.buffer.dimension | 0
          rec.normalized = false
          rec.type = rec.buffer.dtype
          rec.offset = 0
          rec.stride = 0
          rec.divisor = 0
          rec.state = 1
        } else if (bufferState.getBuffer(spec.buffer)) {
          rec.buffer = bufferState.getBuffer(spec.buffer)
          rec.size = ((+spec.size) || rec.buffer.dimension) | 0
          rec.normalized = !!spec.normalized || false
          if ('type' in spec) {
            check$1.parameter(spec.type, glTypes, 'invalid buffer type')
            rec.type = glTypes[spec.type]
          } else {
            rec.type = rec.buffer.dtype
          }
          rec.offset = (spec.offset || 0) | 0
          rec.stride = (spec.stride || 0) | 0
          rec.divisor = (spec.divisor || 0) | 0
          rec.state = 1

          check$1(rec.size >= 1 && rec.size <= 4, 'size must be between 1 and 4')
          check$1(rec.offset >= 0, 'invalid offset')
          check$1(rec.stride >= 0 && rec.stride <= 255, 'stride must be between 0 and 255')
          check$1(rec.divisor >= 0, 'divisor must be positive')
          check$1(!rec.divisor || !!extensions.angle_instanced_arrays, 'ANGLE_instanced_arrays must be enabled to use divisor')
        } else if ('x' in spec) {
          check$1(i > 0, 'first attribute must not be a constant')
          rec.x = +spec.x || 0
          rec.y = +spec.y || 0
          rec.z = +spec.z || 0
          rec.w = +spec.w || 0
          rec.state = 2
        } else {
          check$1(false, 'invalid attribute spec for location ' + i)
        }
      }

      // retire unused buffers
      for (var j = 0; j < vao.buffers.length; ++j) {
        if (!bufUpdated[j] && vao.buffers[j]) {
          vao.buffers[j].destroy()
          vao.buffers[j] = null
        }
      }

      vao.refresh()
      return updateVAO
    }

    updateVAO.destroy = function () {
      for (var j = 0; j < vao.buffers.length; ++j) {
        if (vao.buffers[j]) {
          vao.buffers[j].destroy()
        }
      }
      vao.buffers.length = 0

      if (vao.ownsElements) {
        vao.elements.destroy()
        vao.elements = null
        vao.ownsElements = false
      }

      vao.destroy()
    }

    updateVAO._vao = vao
    updateVAO._reglType = 'vao'

    return updateVAO(_attr)
  }

  return state
}

var GL_FRAGMENT_SHADER = 35632
var GL_VERTEX_SHADER = 35633

var GL_ACTIVE_UNIFORMS = 0x8B86
var GL_ACTIVE_ATTRIBUTES = 0x8B89

function wrapShaderState (gl, stringStore, stats, config) {
  // ===================================================
  // glsl compilation and linking
  // ===================================================
  var fragShaders = {}
  var vertShaders = {}

  function ActiveInfo (name, id, location, info) {
    this.name = name
    this.id = id
    this.location = location
    this.info = info
  }

  function insertActiveInfo (list, info) {
    for (var i = 0; i < list.length; ++i) {
      if (list[i].id === info.id) {
        list[i].location = info.location
        return
      }
    }
    list.push(info)
  }

  function getShader (type, id, command) {
    var cache = type === GL_FRAGMENT_SHADER ? fragShaders : vertShaders
    var shader = cache[id]

    if (!shader) {
      var source = stringStore.str(id)
      shader = gl.createShader(type)
      gl.shaderSource(shader, source)
      gl.compileShader(shader)
      check$1.shaderError(gl, shader, source, type, command)
      cache[id] = shader
    }

    return shader
  }

  // ===================================================
  // program linking
  // ===================================================
  var programCache = {}
  var programList = []

  var PROGRAM_COUNTER = 0

  function REGLProgram (fragId, vertId) {
    this.id = PROGRAM_COUNTER++
    this.fragId = fragId
    this.vertId = vertId
    this.program = null
    this.uniforms = []
    this.attributes = []
    this.refCount = 1

    if (config.profile) {
      this.stats = {
        uniformsCount: 0,
        attributesCount: 0
      }
    }
  }

  function linkProgram (desc, command, attributeLocations) {
    var i, info

    // -------------------------------
    // compile & link
    // -------------------------------
    var fragShader = getShader(GL_FRAGMENT_SHADER, desc.fragId)
    var vertShader = getShader(GL_VERTEX_SHADER, desc.vertId)

    var program = desc.program = gl.createProgram()
    gl.attachShader(program, fragShader)
    gl.attachShader(program, vertShader)
    if (attributeLocations) {
      for (i = 0; i < attributeLocations.length; ++i) {
        var binding = attributeLocations[i]
        gl.bindAttribLocation(program, binding[0], binding[1])
      }
    }

    gl.linkProgram(program)
    check$1.linkError(
      gl,
      program,
      stringStore.str(desc.fragId),
      stringStore.str(desc.vertId),
      command)

    // -------------------------------
    // grab uniforms
    // -------------------------------
    var numUniforms = gl.getProgramParameter(program, GL_ACTIVE_UNIFORMS)
    if (config.profile) {
      desc.stats.uniformsCount = numUniforms
    }
    var uniforms = desc.uniforms
    for (i = 0; i < numUniforms; ++i) {
      info = gl.getActiveUniform(program, i)
      if (info) {
        if (info.size > 1) {
          for (var j = 0; j < info.size; ++j) {
            var name = info.name.replace('[0]', '[' + j + ']')
            insertActiveInfo(uniforms, new ActiveInfo(
              name,
              stringStore.id(name),
              gl.getUniformLocation(program, name),
              info))
          }
        }
        var uniName = info.name
        if (info.size > 1) {
          uniName = uniName.replace('[0]', '')
        }
        insertActiveInfo(uniforms, new ActiveInfo(
          uniName,
          stringStore.id(uniName),
          gl.getUniformLocation(program, uniName),
          info))
      }
    }

    // -------------------------------
    // grab attributes
    // -------------------------------
    var numAttributes = gl.getProgramParameter(program, GL_ACTIVE_ATTRIBUTES)
    if (config.profile) {
      desc.stats.attributesCount = numAttributes
    }

    var attributes = desc.attributes
    for (i = 0; i < numAttributes; ++i) {
      info = gl.getActiveAttrib(program, i)
      if (info) {
        insertActiveInfo(attributes, new ActiveInfo(
          info.name,
          stringStore.id(info.name),
          gl.getAttribLocation(program, info.name),
          info))
      }
    }
  }

  if (config.profile) {
    stats.getMaxUniformsCount = function () {
      var m = 0
      programList.forEach(function (desc) {
        if (desc.stats.uniformsCount > m) {
          m = desc.stats.uniformsCount
        }
      })
      return m
    }

    stats.getMaxAttributesCount = function () {
      var m = 0
      programList.forEach(function (desc) {
        if (desc.stats.attributesCount > m) {
          m = desc.stats.attributesCount
        }
      })
      return m
    }
  }

  function restoreShaders () {
    fragShaders = {}
    vertShaders = {}
    for (var i = 0; i < programList.length; ++i) {
      linkProgram(programList[i], null, programList[i].attributes.map(function (info) {
        return [info.location, info.name]
      }))
    }
  }

  return {
    clear: function () {
      var deleteShader = gl.deleteShader.bind(gl)
      values(fragShaders).forEach(deleteShader)
      fragShaders = {}
      values(vertShaders).forEach(deleteShader)
      vertShaders = {}

      programList.forEach(function (desc) {
        gl.deleteProgram(desc.program)
      })
      programList.length = 0
      programCache = {}

      stats.shaderCount = 0
    },

    program: function (vertId, fragId, command, attribLocations) {
      check$1.command(vertId >= 0, 'missing vertex shader', command)
      check$1.command(fragId >= 0, 'missing fragment shader', command)

      var cache = programCache[fragId]
      if (!cache) {
        cache = programCache[fragId] = {}
      }
      var prevProgram = cache[vertId]
      if (prevProgram) {
        prevProgram.refCount++
        if (!attribLocations) {
          return prevProgram
        }
      }
      var program = new REGLProgram(fragId, vertId)
      stats.shaderCount++
      linkProgram(program, command, attribLocations)
      if (!prevProgram) {
        cache[vertId] = program
      }
      programList.push(program)
      return extend(program, {
        destroy: function () {
          program.refCount--
          if (program.refCount <= 0) {
            gl.deleteProgram(program.program)
            var idx = programList.indexOf(program)
            programList.splice(idx, 1)
            stats.shaderCount--
          }
          // no program is linked to this vert anymore
          if (cache[program.vertId].refCount <= 0) {
            gl.deleteShader(vertShaders[program.vertId])
            delete vertShaders[program.vertId]
            delete programCache[program.fragId][program.vertId]
          }
          // no program is linked to this frag anymore
          if (!Object.keys(programCache[program.fragId]).length) {
            gl.deleteShader(fragShaders[program.fragId])
            delete fragShaders[program.fragId]
            delete programCache[program.fragId]
          }
        }
      })
    },

    restore: restoreShaders,

    shader: getShader,

    frag: -1,
    vert: -1
  }
}

var GL_RGBA$3 = 6408
var GL_UNSIGNED_BYTE$7 = 5121
var GL_PACK_ALIGNMENT = 0x0D05
var GL_FLOAT$7 = 0x1406 // 5126

function wrapReadPixels (
  gl,
  framebufferState,
  reglPoll,
  context,
  glAttributes,
  extensions,
  limits) {
  function readPixelsImpl (input) {
    var type
    if (framebufferState.next === null) {
      check$1(
        glAttributes.preserveDrawingBuffer,
        'you must create a webgl context with "preserveDrawingBuffer":true in order to read pixels from the drawing buffer')
      type = GL_UNSIGNED_BYTE$7
    } else {
      check$1(
        framebufferState.next.colorAttachments[0].texture !== null,
        'You cannot read from a renderbuffer')
      type = framebufferState.next.colorAttachments[0].texture._texture.type

      check$1.optional(function () {
        if (extensions.oes_texture_float) {
          check$1(
            type === GL_UNSIGNED_BYTE$7 || type === GL_FLOAT$7,
            'Reading from a framebuffer is only allowed for the types \'uint8\' and \'float\'')

          if (type === GL_FLOAT$7) {
            check$1(limits.readFloat, 'Reading \'float\' values is not permitted in your browser. For a fallback, please see: https://www.npmjs.com/package/glsl-read-float')
          }
        } else {
          check$1(
            type === GL_UNSIGNED_BYTE$7,
            'Reading from a framebuffer is only allowed for the type \'uint8\'')
        }
      })
    }

    var x = 0
    var y = 0
    var width = context.framebufferWidth
    var height = context.framebufferHeight
    var data = null

    if (isTypedArray(input)) {
      data = input
    } else if (input) {
      check$1.type(input, 'object', 'invalid arguments to regl.read()')
      x = input.x | 0
      y = input.y | 0
      check$1(
        x >= 0 && x < context.framebufferWidth,
        'invalid x offset for regl.read')
      check$1(
        y >= 0 && y < context.framebufferHeight,
        'invalid y offset for regl.read')
      width = (input.width || (context.framebufferWidth - x)) | 0
      height = (input.height || (context.framebufferHeight - y)) | 0
      data = input.data || null
    }

    // sanity check input.data
    if (data) {
      if (type === GL_UNSIGNED_BYTE$7) {
        check$1(
          data instanceof Uint8Array,
          'buffer must be \'Uint8Array\' when reading from a framebuffer of type \'uint8\'')
      } else if (type === GL_FLOAT$7) {
        check$1(
          data instanceof Float32Array,
          'buffer must be \'Float32Array\' when reading from a framebuffer of type \'float\'')
      }
    }

    check$1(
      width > 0 && width + x <= context.framebufferWidth,
      'invalid width for read pixels')
    check$1(
      height > 0 && height + y <= context.framebufferHeight,
      'invalid height for read pixels')

    // Update WebGL state
    reglPoll()

    // Compute size
    var size = width * height * 4

    // Allocate data
    if (!data) {
      if (type === GL_UNSIGNED_BYTE$7) {
        data = new Uint8Array(size)
      } else if (type === GL_FLOAT$7) {
        data = data || new Float32Array(size)
      }
    }

    // Type check
    check$1.isTypedArray(data, 'data buffer for regl.read() must be a typedarray')
    check$1(data.byteLength >= size, 'data buffer for regl.read() too small')

    // Run read pixels
    gl.pixelStorei(GL_PACK_ALIGNMENT, 4)
    gl.readPixels(x, y, width, height, GL_RGBA$3,
      type,
      data)

    return data
  }

  function readPixelsFBO (options) {
    var result
    framebufferState.setFBO({
      framebuffer: options.framebuffer
    }, function () {
      result = readPixelsImpl(options)
    })
    return result
  }

  function readPixels (options) {
    if (!options || !('framebuffer' in options)) {
      return readPixelsImpl(options)
    } else {
      return readPixelsFBO(options)
    }
  }

  return readPixels
}

function slice (x) {
  return Array.prototype.slice.call(x)
}

function join (x) {
  return slice(x).join('')
}

function createEnvironment () {
  // Unique variable id counter
  var varCounter = 0

  // Linked values are passed from this scope into the generated code block
  // Calling link() passes a value into the generated scope and returns
  // the variable name which it is bound to
  var linkedNames = []
  var linkedValues = []
  function link (value) {
    for (var i = 0; i < linkedValues.length; ++i) {
      if (linkedValues[i] === value) {
        return linkedNames[i]
      }
    }

    var name = 'g' + (varCounter++)
    linkedNames.push(name)
    linkedValues.push(value)
    return name
  }

  // create a code block
  function block () {
    var code = []
    function push () {
      code.push.apply(code, slice(arguments))
    }

    var vars = []
    function def () {
      var name = 'v' + (varCounter++)
      vars.push(name)

      if (arguments.length > 0) {
        code.push(name, '=')
        code.push.apply(code, slice(arguments))
        code.push(';')
      }

      return name
    }

    return extend(push, {
      def: def,
      toString: function () {
        return join([
          (vars.length > 0 ? 'var ' + vars.join(',') + ';' : ''),
          join(code)
        ])
      }
    })
  }

  function scope () {
    var entry = block()
    var exit = block()

    var entryToString = entry.toString
    var exitToString = exit.toString

    function save (object, prop) {
      exit(object, prop, '=', entry.def(object, prop), ';')
    }

    return extend(function () {
      entry.apply(entry, slice(arguments))
    }, {
      def: entry.def,
      entry: entry,
      exit: exit,
      save: save,
      set: function (object, prop, value) {
        save(object, prop)
        entry(object, prop, '=', value, ';')
      },
      toString: function () {
        return entryToString() + exitToString()
      }
    })
  }

  function conditional () {
    var pred = join(arguments)
    var thenBlock = scope()
    var elseBlock = scope()

    var thenToString = thenBlock.toString
    var elseToString = elseBlock.toString

    return extend(thenBlock, {
      then: function () {
        thenBlock.apply(thenBlock, slice(arguments))
        return this
      },
      else: function () {
        elseBlock.apply(elseBlock, slice(arguments))
        return this
      },
      toString: function () {
        var elseClause = elseToString()
        if (elseClause) {
          elseClause = 'else{' + elseClause + '}'
        }
        return join([
          'if(', pred, '){',
          thenToString(),
          '}', elseClause
        ])
      }
    })
  }

  // procedure list
  var globalBlock = block()
  var procedures = {}
  function proc (name, count) {
    var args = []
    function arg () {
      var name = 'a' + args.length
      args.push(name)
      return name
    }

    count = count || 0
    for (var i = 0; i < count; ++i) {
      arg()
    }

    var body = scope()
    var bodyToString = body.toString

    var result = procedures[name] = extend(body, {
      arg: arg,
      toString: function () {
        return join([
          'function(', args.join(), '){',
          bodyToString(),
          '}'
        ])
      }
    })

    return result
  }

  function compile () {
    var code = ['"use strict";',
      globalBlock,
      'return {']
    Object.keys(procedures).forEach(function (name) {
      code.push('"', name, '":', procedures[name].toString(), ',')
    })
    code.push('}')
    var src = join(code)
      .replace(/;/g, ';\n')
      .replace(/}/g, '}\n')
      .replace(/{/g, '{\n')
    var proc = Function.apply(null, linkedNames.concat(src))
    return proc.apply(null, linkedValues)
  }

  return {
    global: globalBlock,
    link: link,
    block: block,
    proc: proc,
    scope: scope,
    cond: conditional,
    compile: compile
  }
}

// "cute" names for vector components
var CUTE_COMPONENTS = 'xyzw'.split('')

var GL_UNSIGNED_BYTE$8 = 5121

var ATTRIB_STATE_POINTER = 1
var ATTRIB_STATE_CONSTANT = 2

var DYN_FUNC$1 = 0
var DYN_PROP$1 = 1
var DYN_CONTEXT$1 = 2
var DYN_STATE$1 = 3
var DYN_THUNK = 4
var DYN_CONSTANT$1 = 5
var DYN_ARRAY$1 = 6

var S_DITHER = 'dither'
var S_BLEND_ENABLE = 'blend.enable'
var S_BLEND_COLOR = 'blend.color'
var S_BLEND_EQUATION = 'blend.equation'
var S_BLEND_FUNC = 'blend.func'
var S_DEPTH_ENABLE = 'depth.enable'
var S_DEPTH_FUNC = 'depth.func'
var S_DEPTH_RANGE = 'depth.range'
var S_DEPTH_MASK = 'depth.mask'
var S_COLOR_MASK = 'colorMask'
var S_CULL_ENABLE = 'cull.enable'
var S_CULL_FACE = 'cull.face'
var S_FRONT_FACE = 'frontFace'
var S_LINE_WIDTH = 'lineWidth'
var S_POLYGON_OFFSET_ENABLE = 'polygonOffset.enable'
var S_POLYGON_OFFSET_OFFSET = 'polygonOffset.offset'
var S_SAMPLE_ALPHA = 'sample.alpha'
var S_SAMPLE_ENABLE = 'sample.enable'
var S_SAMPLE_COVERAGE = 'sample.coverage'
var S_STENCIL_ENABLE = 'stencil.enable'
var S_STENCIL_MASK = 'stencil.mask'
var S_STENCIL_FUNC = 'stencil.func'
var S_STENCIL_OPFRONT = 'stencil.opFront'
var S_STENCIL_OPBACK = 'stencil.opBack'
var S_SCISSOR_ENABLE = 'scissor.enable'
var S_SCISSOR_BOX = 'scissor.box'
var S_VIEWPORT = 'viewport'

var S_PROFILE = 'profile'

var S_FRAMEBUFFER = 'framebuffer'
var S_VERT = 'vert'
var S_FRAG = 'frag'
var S_ELEMENTS = 'elements'
var S_PRIMITIVE = 'primitive'
var S_COUNT = 'count'
var S_OFFSET = 'offset'
var S_INSTANCES = 'instances'
var S_VAO = 'vao'

var SUFFIX_WIDTH = 'Width'
var SUFFIX_HEIGHT = 'Height'

var S_FRAMEBUFFER_WIDTH = S_FRAMEBUFFER + SUFFIX_WIDTH
var S_FRAMEBUFFER_HEIGHT = S_FRAMEBUFFER + SUFFIX_HEIGHT
var S_VIEWPORT_WIDTH = S_VIEWPORT + SUFFIX_WIDTH
var S_VIEWPORT_HEIGHT = S_VIEWPORT + SUFFIX_HEIGHT
var S_DRAWINGBUFFER = 'drawingBuffer'
var S_DRAWINGBUFFER_WIDTH = S_DRAWINGBUFFER + SUFFIX_WIDTH
var S_DRAWINGBUFFER_HEIGHT = S_DRAWINGBUFFER + SUFFIX_HEIGHT

var NESTED_OPTIONS = [
  S_BLEND_FUNC,
  S_BLEND_EQUATION,
  S_STENCIL_FUNC,
  S_STENCIL_OPFRONT,
  S_STENCIL_OPBACK,
  S_SAMPLE_COVERAGE,
  S_VIEWPORT,
  S_SCISSOR_BOX,
  S_POLYGON_OFFSET_OFFSET
]

var GL_ARRAY_BUFFER$2 = 34962
var GL_ELEMENT_ARRAY_BUFFER$2 = 34963

var GL_FRAGMENT_SHADER$1 = 35632
var GL_VERTEX_SHADER$1 = 35633

var GL_TEXTURE_2D$3 = 0x0DE1
var GL_TEXTURE_CUBE_MAP$2 = 0x8513

var GL_CULL_FACE = 0x0B44
var GL_BLEND = 0x0BE2
var GL_DITHER = 0x0BD0
var GL_STENCIL_TEST = 0x0B90
var GL_DEPTH_TEST = 0x0B71
var GL_SCISSOR_TEST = 0x0C11
var GL_POLYGON_OFFSET_FILL = 0x8037
var GL_SAMPLE_ALPHA_TO_COVERAGE = 0x809E
var GL_SAMPLE_COVERAGE = 0x80A0

var GL_FLOAT$8 = 5126
var GL_FLOAT_VEC2 = 35664
var GL_FLOAT_VEC3 = 35665
var GL_FLOAT_VEC4 = 35666
var GL_INT$3 = 5124
var GL_INT_VEC2 = 35667
var GL_INT_VEC3 = 35668
var GL_INT_VEC4 = 35669
var GL_BOOL = 35670
var GL_BOOL_VEC2 = 35671
var GL_BOOL_VEC3 = 35672
var GL_BOOL_VEC4 = 35673
var GL_FLOAT_MAT2 = 35674
var GL_FLOAT_MAT3 = 35675
var GL_FLOAT_MAT4 = 35676
var GL_SAMPLER_2D = 35678
var GL_SAMPLER_CUBE = 35680

var GL_TRIANGLES$1 = 4

var GL_FRONT = 1028
var GL_BACK = 1029
var GL_CW = 0x0900
var GL_CCW = 0x0901
var GL_MIN_EXT = 0x8007
var GL_MAX_EXT = 0x8008
var GL_ALWAYS = 519
var GL_KEEP = 7680
var GL_ZERO = 0
var GL_ONE = 1
var GL_FUNC_ADD = 0x8006
var GL_LESS = 513

var GL_FRAMEBUFFER$2 = 0x8D40
var GL_COLOR_ATTACHMENT0$2 = 0x8CE0

var blendFuncs = {
  '0': 0,
  '1': 1,
  'zero': 0,
  'one': 1,
  'src color': 768,
  'one minus src color': 769,
  'src alpha': 770,
  'one minus src alpha': 771,
  'dst color': 774,
  'one minus dst color': 775,
  'dst alpha': 772,
  'one minus dst alpha': 773,
  'constant color': 32769,
  'one minus constant color': 32770,
  'constant alpha': 32771,
  'one minus constant alpha': 32772,
  'src alpha saturate': 776
}

// There are invalid values for srcRGB and dstRGB. See:
// https://www.khronos.org/registry/webgl/specs/1.0/#6.13
// https://github.com/KhronosGroup/WebGL/blob/0d3201f5f7ec3c0060bc1f04077461541f1987b9/conformance-suites/1.0.3/conformance/misc/webgl-specific.html#L56
var invalidBlendCombinations = [
  'constant color, constant alpha',
  'one minus constant color, constant alpha',
  'constant color, one minus constant alpha',
  'one minus constant color, one minus constant alpha',
  'constant alpha, constant color',
  'constant alpha, one minus constant color',
  'one minus constant alpha, constant color',
  'one minus constant alpha, one minus constant color'
]

var compareFuncs = {
  'never': 512,
  'less': 513,
  '<': 513,
  'equal': 514,
  '=': 514,
  '==': 514,
  '===': 514,
  'lequal': 515,
  '<=': 515,
  'greater': 516,
  '>': 516,
  'notequal': 517,
  '!=': 517,
  '!==': 517,
  'gequal': 518,
  '>=': 518,
  'always': 519
}

var stencilOps = {
  '0': 0,
  'zero': 0,
  'keep': 7680,
  'replace': 7681,
  'increment': 7682,
  'decrement': 7683,
  'increment wrap': 34055,
  'decrement wrap': 34056,
  'invert': 5386
}

var shaderType = {
  'frag': GL_FRAGMENT_SHADER$1,
  'vert': GL_VERTEX_SHADER$1
}

var orientationType = {
  'cw': GL_CW,
  'ccw': GL_CCW
}

function isBufferArgs (x) {
  return Array.isArray(x) ||
    isTypedArray(x) ||
    isNDArrayLike(x)
}

// Make sure viewport is processed first
function sortState (state) {
  return state.sort(function (a, b) {
    if (a === S_VIEWPORT) {
      return -1
    } else if (b === S_VIEWPORT) {
      return 1
    }
    return (a < b) ? -1 : 1
  })
}

function Declaration (thisDep, contextDep, propDep, append) {
  this.thisDep = thisDep
  this.contextDep = contextDep
  this.propDep = propDep
  this.append = append
}

function isStatic (decl) {
  return decl && !(decl.thisDep || decl.contextDep || decl.propDep)
}

function createStaticDecl (append) {
  return new Declaration(false, false, false, append)
}

function createDynamicDecl (dyn, append) {
  var type = dyn.type
  if (type === DYN_FUNC$1) {
    var numArgs = dyn.data.length
    return new Declaration(
      true,
      numArgs >= 1,
      numArgs >= 2,
      append)
  } else if (type === DYN_THUNK) {
    var data = dyn.data
    return new Declaration(
      data.thisDep,
      data.contextDep,
      data.propDep,
      append)
  } else if (type === DYN_CONSTANT$1) {
    return new Declaration(
      false,
      false,
      false,
      append)
  } else if (type === DYN_ARRAY$1) {
    var thisDep = false
    var contextDep = false
    var propDep = false
    for (var i = 0; i < dyn.data.length; ++i) {
      var subDyn = dyn.data[i]
      if (subDyn.type === DYN_PROP$1) {
        propDep = true
      } else if (subDyn.type === DYN_CONTEXT$1) {
        contextDep = true
      } else if (subDyn.type === DYN_STATE$1) {
        thisDep = true
      } else if (subDyn.type === DYN_FUNC$1) {
        thisDep = true
        var subArgs = subDyn.data
        if (subArgs >= 1) {
          contextDep = true
        }
        if (subArgs >= 2) {
          propDep = true
        }
      } else if (subDyn.type === DYN_THUNK) {
        thisDep = thisDep || subDyn.data.thisDep
        contextDep = contextDep || subDyn.data.contextDep
        propDep = propDep || subDyn.data.propDep
      }
    }
    return new Declaration(
      thisDep,
      contextDep,
      propDep,
      append)
  } else {
    return new Declaration(
      type === DYN_STATE$1,
      type === DYN_CONTEXT$1,
      type === DYN_PROP$1,
      append)
  }
}

var SCOPE_DECL = new Declaration(false, false, false, function () {})

function reglCore (
  gl,
  stringStore,
  extensions,
  limits,
  bufferState,
  elementState,
  textureState,
  framebufferState,
  uniformState,
  attributeState,
  shaderState,
  drawState,
  contextState,
  timer,
  config) {
  var AttributeRecord = attributeState.Record

  var blendEquations = {
    'add': 32774,
    'subtract': 32778,
    'reverse subtract': 32779
  }
  if (extensions.ext_blend_minmax) {
    blendEquations.min = GL_MIN_EXT
    blendEquations.max = GL_MAX_EXT
  }

  var extInstancing = extensions.angle_instanced_arrays
  var extDrawBuffers = extensions.webgl_draw_buffers
  var extVertexArrays = extensions.oes_vertex_array_object

  // ===================================================
  // ===================================================
  // WEBGL STATE
  // ===================================================
  // ===================================================
  var currentState = {
    dirty: true,
    profile: config.profile
  }
  var nextState = {}
  var GL_STATE_NAMES = []
  var GL_FLAGS = {}
  var GL_VARIABLES = {}

  function propName (name) {
    return name.replace('.', '_')
  }

  function stateFlag (sname, cap, init) {
    var name = propName(sname)
    GL_STATE_NAMES.push(sname)
    nextState[name] = currentState[name] = !!init
    GL_FLAGS[name] = cap
  }

  function stateVariable (sname, func, init) {
    var name = propName(sname)
    GL_STATE_NAMES.push(sname)
    if (Array.isArray(init)) {
      currentState[name] = init.slice()
      nextState[name] = init.slice()
    } else {
      currentState[name] = nextState[name] = init
    }
    GL_VARIABLES[name] = func
  }

  // Dithering
  stateFlag(S_DITHER, GL_DITHER)

  // Blending
  stateFlag(S_BLEND_ENABLE, GL_BLEND)
  stateVariable(S_BLEND_COLOR, 'blendColor', [0, 0, 0, 0])
  stateVariable(S_BLEND_EQUATION, 'blendEquationSeparate',
    [GL_FUNC_ADD, GL_FUNC_ADD])
  stateVariable(S_BLEND_FUNC, 'blendFuncSeparate',
    [GL_ONE, GL_ZERO, GL_ONE, GL_ZERO])

  // Depth
  stateFlag(S_DEPTH_ENABLE, GL_DEPTH_TEST, true)
  stateVariable(S_DEPTH_FUNC, 'depthFunc', GL_LESS)
  stateVariable(S_DEPTH_RANGE, 'depthRange', [0, 1])
  stateVariable(S_DEPTH_MASK, 'depthMask', true)

  // Color mask
  stateVariable(S_COLOR_MASK, S_COLOR_MASK, [true, true, true, true])

  // Face culling
  stateFlag(S_CULL_ENABLE, GL_CULL_FACE)
  stateVariable(S_CULL_FACE, 'cullFace', GL_BACK)

  // Front face orientation
  stateVariable(S_FRONT_FACE, S_FRONT_FACE, GL_CCW)

  // Line width
  stateVariable(S_LINE_WIDTH, S_LINE_WIDTH, 1)

  // Polygon offset
  stateFlag(S_POLYGON_OFFSET_ENABLE, GL_POLYGON_OFFSET_FILL)
  stateVariable(S_POLYGON_OFFSET_OFFSET, 'polygonOffset', [0, 0])

  // Sample coverage
  stateFlag(S_SAMPLE_ALPHA, GL_SAMPLE_ALPHA_TO_COVERAGE)
  stateFlag(S_SAMPLE_ENABLE, GL_SAMPLE_COVERAGE)
  stateVariable(S_SAMPLE_COVERAGE, 'sampleCoverage', [1, false])

  // Stencil
  stateFlag(S_STENCIL_ENABLE, GL_STENCIL_TEST)
  stateVariable(S_STENCIL_MASK, 'stencilMask', -1)
  stateVariable(S_STENCIL_FUNC, 'stencilFunc', [GL_ALWAYS, 0, -1])
  stateVariable(S_STENCIL_OPFRONT, 'stencilOpSeparate',
    [GL_FRONT, GL_KEEP, GL_KEEP, GL_KEEP])
  stateVariable(S_STENCIL_OPBACK, 'stencilOpSeparate',
    [GL_BACK, GL_KEEP, GL_KEEP, GL_KEEP])

  // Scissor
  stateFlag(S_SCISSOR_ENABLE, GL_SCISSOR_TEST)
  stateVariable(S_SCISSOR_BOX, 'scissor',
    [0, 0, gl.drawingBufferWidth, gl.drawingBufferHeight])

  // Viewport
  stateVariable(S_VIEWPORT, S_VIEWPORT,
    [0, 0, gl.drawingBufferWidth, gl.drawingBufferHeight])

  // ===================================================
  // ===================================================
  // ENVIRONMENT
  // ===================================================
  // ===================================================
  var sharedState = {
    gl: gl,
    context: contextState,
    strings: stringStore,
    next: nextState,
    current: currentState,
    draw: drawState,
    elements: elementState,
    buffer: bufferState,
    shader: shaderState,
    attributes: attributeState.state,
    vao: attributeState,
    uniforms: uniformState,
    framebuffer: framebufferState,
    extensions: extensions,

    timer: timer,
    isBufferArgs: isBufferArgs
  }

  var sharedConstants = {
    primTypes: primTypes,
    compareFuncs: compareFuncs,
    blendFuncs: blendFuncs,
    blendEquations: blendEquations,
    stencilOps: stencilOps,
    glTypes: glTypes,
    orientationType: orientationType
  }

  check$1.optional(function () {
    sharedState.isArrayLike = isArrayLike
  })

  if (extDrawBuffers) {
    sharedConstants.backBuffer = [GL_BACK]
    sharedConstants.drawBuffer = loop(limits.maxDrawbuffers, function (i) {
      if (i === 0) {
        return [0]
      }
      return loop(i, function (j) {
        return GL_COLOR_ATTACHMENT0$2 + j
      })
    })
  }

  var drawCallCounter = 0
  function createREGLEnvironment () {
    var env = createEnvironment()
    var link = env.link
    var global = env.global
    env.id = drawCallCounter++

    env.batchId = '0'

    // link shared state
    var SHARED = link(sharedState)
    var shared = env.shared = {
      props: 'a0'
    }
    Object.keys(sharedState).forEach(function (prop) {
      shared[prop] = global.def(SHARED, '.', prop)
    })

    // Inject runtime assertion stuff for debug builds
    check$1.optional(function () {
      env.CHECK = link(check$1)
      env.commandStr = check$1.guessCommand()
      env.command = link(env.commandStr)
      env.assert = function (block, pred, message) {
        block(
          'if(!(', pred, '))',
          this.CHECK, '.commandRaise(', link(message), ',', this.command, ');')
      }

      sharedConstants.invalidBlendCombinations = invalidBlendCombinations
    })

    // Copy GL state variables over
    var nextVars = env.next = {}
    var currentVars = env.current = {}
    Object.keys(GL_VARIABLES).forEach(function (variable) {
      if (Array.isArray(currentState[variable])) {
        nextVars[variable] = global.def(shared.next, '.', variable)
        currentVars[variable] = global.def(shared.current, '.', variable)
      }
    })

    // Initialize shared constants
    var constants = env.constants = {}
    Object.keys(sharedConstants).forEach(function (name) {
      constants[name] = global.def(JSON.stringify(sharedConstants[name]))
    })

    // Helper function for calling a block
    env.invoke = function (block, x) {
      switch (x.type) {
        case DYN_FUNC$1:
          var argList = [
            'this',
            shared.context,
            shared.props,
            env.batchId
          ]
          return block.def(
            link(x.data), '.call(',
            argList.slice(0, Math.max(x.data.length + 1, 4)),
            ')')
        case DYN_PROP$1:
          return block.def(shared.props, x.data)
        case DYN_CONTEXT$1:
          return block.def(shared.context, x.data)
        case DYN_STATE$1:
          return block.def('this', x.data)
        case DYN_THUNK:
          x.data.append(env, block)
          return x.data.ref
        case DYN_CONSTANT$1:
          return x.data.toString()
        case DYN_ARRAY$1:
          return x.data.map(function (y) {
            return env.invoke(block, y)
          })
      }
    }

    env.attribCache = {}

    var scopeAttribs = {}
    env.scopeAttrib = function (name) {
      var id = stringStore.id(name)
      if (id in scopeAttribs) {
        return scopeAttribs[id]
      }
      var binding = attributeState.scope[id]
      if (!binding) {
        binding = attributeState.scope[id] = new AttributeRecord()
      }
      var result = scopeAttribs[id] = link(binding)
      return result
    }

    return env
  }

  // ===================================================
  // ===================================================
  // PARSING
  // ===================================================
  // ===================================================
  function parseProfile (options) {
    var staticOptions = options.static
    var dynamicOptions = options.dynamic

    var profileEnable
    if (S_PROFILE in staticOptions) {
      var value = !!staticOptions[S_PROFILE]
      profileEnable = createStaticDecl(function (env, scope) {
        return value
      })
      profileEnable.enable = value
    } else if (S_PROFILE in dynamicOptions) {
      var dyn = dynamicOptions[S_PROFILE]
      profileEnable = createDynamicDecl(dyn, function (env, scope) {
        return env.invoke(scope, dyn)
      })
    }

    return profileEnable
  }

  function parseFramebuffer (options, env) {
    var staticOptions = options.static
    var dynamicOptions = options.dynamic

    if (S_FRAMEBUFFER in staticOptions) {
      var framebuffer = staticOptions[S_FRAMEBUFFER]
      if (framebuffer) {
        framebuffer = framebufferState.getFramebuffer(framebuffer)
        check$1.command(framebuffer, 'invalid framebuffer object')
        return createStaticDecl(function (env, block) {
          var FRAMEBUFFER = env.link(framebuffer)
          var shared = env.shared
          block.set(
            shared.framebuffer,
            '.next',
            FRAMEBUFFER)
          var CONTEXT = shared.context
          block.set(
            CONTEXT,
            '.' + S_FRAMEBUFFER_WIDTH,
            FRAMEBUFFER + '.width')
          block.set(
            CONTEXT,
            '.' + S_FRAMEBUFFER_HEIGHT,
            FRAMEBUFFER + '.height')
          return FRAMEBUFFER
        })
      } else {
        return createStaticDecl(function (env, scope) {
          var shared = env.shared
          scope.set(
            shared.framebuffer,
            '.next',
            'null')
          var CONTEXT = shared.context
          scope.set(
            CONTEXT,
            '.' + S_FRAMEBUFFER_WIDTH,
            CONTEXT + '.' + S_DRAWINGBUFFER_WIDTH)
          scope.set(
            CONTEXT,
            '.' + S_FRAMEBUFFER_HEIGHT,
            CONTEXT + '.' + S_DRAWINGBUFFER_HEIGHT)
          return 'null'
        })
      }
    } else if (S_FRAMEBUFFER in dynamicOptions) {
      var dyn = dynamicOptions[S_FRAMEBUFFER]
      return createDynamicDecl(dyn, function (env, scope) {
        var FRAMEBUFFER_FUNC = env.invoke(scope, dyn)
        var shared = env.shared
        var FRAMEBUFFER_STATE = shared.framebuffer
        var FRAMEBUFFER = scope.def(
          FRAMEBUFFER_STATE, '.getFramebuffer(', FRAMEBUFFER_FUNC, ')')

        check$1.optional(function () {
          env.assert(scope,
            '!' + FRAMEBUFFER_FUNC + '||' + FRAMEBUFFER,
            'invalid framebuffer object')
        })

        scope.set(
          FRAMEBUFFER_STATE,
          '.next',
          FRAMEBUFFER)
        var CONTEXT = shared.context
        scope.set(
          CONTEXT,
          '.' + S_FRAMEBUFFER_WIDTH,
          FRAMEBUFFER + '?' + FRAMEBUFFER + '.width:' +
          CONTEXT + '.' + S_DRAWINGBUFFER_WIDTH)
        scope.set(
          CONTEXT,
          '.' + S_FRAMEBUFFER_HEIGHT,
          FRAMEBUFFER +
          '?' + FRAMEBUFFER + '.height:' +
          CONTEXT + '.' + S_DRAWINGBUFFER_HEIGHT)
        return FRAMEBUFFER
      })
    } else {
      return null
    }
  }

  function parseViewportScissor (options, framebuffer, env) {
    var staticOptions = options.static
    var dynamicOptions = options.dynamic

    function parseBox (param) {
      if (param in staticOptions) {
        var box = staticOptions[param]
        check$1.commandType(box, 'object', 'invalid ' + param, env.commandStr)

        var isStatic = true
        var x = box.x | 0
        var y = box.y | 0
        var w, h
        if ('width' in box) {
          w = box.width | 0
          check$1.command(w >= 0, 'invalid ' + param, env.commandStr)
        } else {
          isStatic = false
        }
        if ('height' in box) {
          h = box.height | 0
          check$1.command(h >= 0, 'invalid ' + param, env.commandStr)
        } else {
          isStatic = false
        }

        return new Declaration(
          !isStatic && framebuffer && framebuffer.thisDep,
          !isStatic && framebuffer && framebuffer.contextDep,
          !isStatic && framebuffer && framebuffer.propDep,
          function (env, scope) {
            var CONTEXT = env.shared.context
            var BOX_W = w
            if (!('width' in box)) {
              BOX_W = scope.def(CONTEXT, '.', S_FRAMEBUFFER_WIDTH, '-', x)
            }
            var BOX_H = h
            if (!('height' in box)) {
              BOX_H = scope.def(CONTEXT, '.', S_FRAMEBUFFER_HEIGHT, '-', y)
            }
            return [x, y, BOX_W, BOX_H]
          })
      } else if (param in dynamicOptions) {
        var dynBox = dynamicOptions[param]
        var result = createDynamicDecl(dynBox, function (env, scope) {
          var BOX = env.invoke(scope, dynBox)

          check$1.optional(function () {
            env.assert(scope,
              BOX + '&&typeof ' + BOX + '==="object"',
              'invalid ' + param)
          })

          var CONTEXT = env.shared.context
          var BOX_X = scope.def(BOX, '.x|0')
          var BOX_Y = scope.def(BOX, '.y|0')
          var BOX_W = scope.def(
            '"width" in ', BOX, '?', BOX, '.width|0:',
            '(', CONTEXT, '.', S_FRAMEBUFFER_WIDTH, '-', BOX_X, ')')
          var BOX_H = scope.def(
            '"height" in ', BOX, '?', BOX, '.height|0:',
            '(', CONTEXT, '.', S_FRAMEBUFFER_HEIGHT, '-', BOX_Y, ')')

          check$1.optional(function () {
            env.assert(scope,
              BOX_W + '>=0&&' +
              BOX_H + '>=0',
              'invalid ' + param)
          })

          return [BOX_X, BOX_Y, BOX_W, BOX_H]
        })
        if (framebuffer) {
          result.thisDep = result.thisDep || framebuffer.thisDep
          result.contextDep = result.contextDep || framebuffer.contextDep
          result.propDep = result.propDep || framebuffer.propDep
        }
        return result
      } else if (framebuffer) {
        return new Declaration(
          framebuffer.thisDep,
          framebuffer.contextDep,
          framebuffer.propDep,
          function (env, scope) {
            var CONTEXT = env.shared.context
            return [
              0, 0,
              scope.def(CONTEXT, '.', S_FRAMEBUFFER_WIDTH),
              scope.def(CONTEXT, '.', S_FRAMEBUFFER_HEIGHT)]
          })
      } else {
        return null
      }
    }

    var viewport = parseBox(S_VIEWPORT)

    if (viewport) {
      var prevViewport = viewport
      viewport = new Declaration(
        viewport.thisDep,
        viewport.contextDep,
        viewport.propDep,
        function (env, scope) {
          var VIEWPORT = prevViewport.append(env, scope)
          var CONTEXT = env.shared.context
          scope.set(
            CONTEXT,
            '.' + S_VIEWPORT_WIDTH,
            VIEWPORT[2])
          scope.set(
            CONTEXT,
            '.' + S_VIEWPORT_HEIGHT,
            VIEWPORT[3])
          return VIEWPORT
        })
    }

    return {
      viewport: viewport,
      scissor_box: parseBox(S_SCISSOR_BOX)
    }
  }

  function parseAttribLocations (options, attributes) {
    var staticOptions = options.static
    var staticProgram =
      typeof staticOptions[S_FRAG] === 'string' &&
      typeof staticOptions[S_VERT] === 'string'
    if (staticProgram) {
      if (Object.keys(attributes.dynamic).length > 0) {
        return null
      }
      var staticAttributes = attributes.static
      var sAttributes = Object.keys(staticAttributes)
      if (sAttributes.length > 0 && typeof staticAttributes[sAttributes[0]] === 'number') {
        var bindings = []
        for (var i = 0; i < sAttributes.length; ++i) {
          check$1(typeof staticAttributes[sAttributes[i]] === 'number', 'must specify all vertex attribute locations when using vaos')
          bindings.push([staticAttributes[sAttributes[i]] | 0, sAttributes[i]])
        }
        return bindings
      }
    }
    return null
  }

  function parseProgram (options, env, attribLocations) {
    var staticOptions = options.static
    var dynamicOptions = options.dynamic

    function parseShader (name) {
      if (name in staticOptions) {
        var id = stringStore.id(staticOptions[name])
        check$1.optional(function () {
          shaderState.shader(shaderType[name], id, check$1.guessCommand())
        })
        var result = createStaticDecl(function () {
          return id
        })
        result.id = id
        return result
      } else if (name in dynamicOptions) {
        var dyn = dynamicOptions[name]
        return createDynamicDecl(dyn, function (env, scope) {
          var str = env.invoke(scope, dyn)
          var id = scope.def(env.shared.strings, '.id(', str, ')')
          check$1.optional(function () {
            scope(
              env.shared.shader, '.shader(',
              shaderType[name], ',',
              id, ',',
              env.command, ');')
          })
          return id
        })
      }
      return null
    }

    var frag = parseShader(S_FRAG)
    var vert = parseShader(S_VERT)

    var program = null
    var progVar
    if (isStatic(frag) && isStatic(vert)) {
      program = shaderState.program(vert.id, frag.id, null, attribLocations)
      progVar = createStaticDecl(function (env, scope) {
        return env.link(program)
      })
    } else {
      progVar = new Declaration(
        (frag && frag.thisDep) || (vert && vert.thisDep),
        (frag && frag.contextDep) || (vert && vert.contextDep),
        (frag && frag.propDep) || (vert && vert.propDep),
        function (env, scope) {
          var SHADER_STATE = env.shared.shader
          var fragId
          if (frag) {
            fragId = frag.append(env, scope)
          } else {
            fragId = scope.def(SHADER_STATE, '.', S_FRAG)
          }
          var vertId
          if (vert) {
            vertId = vert.append(env, scope)
          } else {
            vertId = scope.def(SHADER_STATE, '.', S_VERT)
          }
          var progDef = SHADER_STATE + '.program(' + vertId + ',' + fragId
          check$1.optional(function () {
            progDef += ',' + env.command
          })
          return scope.def(progDef + ')')
        })
    }

    return {
      frag: frag,
      vert: vert,
      progVar: progVar,
      program: program
    }
  }

  function parseDraw (options, env) {
    var staticOptions = options.static
    var dynamicOptions = options.dynamic

    // TODO: should use VAO to get default values for offset properties
    // should move vao parse into here and out of the old stuff

    var staticDraw = {}
    var vaoActive = false

    function parseVAO () {
      if (S_VAO in staticOptions) {
        var vao = staticOptions[S_VAO]
        if (vao !== null && attributeState.getVAO(vao) === null) {
          vao = attributeState.createVAO(vao)
        }

        vaoActive = true
        staticDraw.vao = vao

        return createStaticDecl(function (env) {
          var vaoRef = attributeState.getVAO(vao)
          if (vaoRef) {
            return env.link(vaoRef)
          } else {
            return 'null'
          }
        })
      } else if (S_VAO in dynamicOptions) {
        vaoActive = true
        var dyn = dynamicOptions[S_VAO]
        return createDynamicDecl(dyn, function (env, scope) {
          var vaoRef = env.invoke(scope, dyn)
          return scope.def(env.shared.vao + '.getVAO(' + vaoRef + ')')
        })
      }
      return null
    }

    var vao = parseVAO()

    var elementsActive = false

    function parseElements () {
      if (S_ELEMENTS in staticOptions) {
        var elements = staticOptions[S_ELEMENTS]
        staticDraw.elements = elements
        if (isBufferArgs(elements)) {
          var e = staticDraw.elements = elementState.create(elements, true)
          elements = elementState.getElements(e)
          elementsActive = true
        } else if (elements) {
          elements = elementState.getElements(elements)
          elementsActive = true
          check$1.command(elements, 'invalid elements', env.commandStr)
        }

        var result = createStaticDecl(function (env, scope) {
          if (elements) {
            var result = env.link(elements)
            env.ELEMENTS = result
            return result
          }
          env.ELEMENTS = null
          return null
        })
        result.value = elements
        return result
      } else if (S_ELEMENTS in dynamicOptions) {
        elementsActive = true

        var dyn = dynamicOptions[S_ELEMENTS]
        return createDynamicDecl(dyn, function (env, scope) {
          var shared = env.shared

          var IS_BUFFER_ARGS = shared.isBufferArgs
          var ELEMENT_STATE = shared.elements

          var elementDefn = env.invoke(scope, dyn)
          var elements = scope.def('null')
          var elementStream = scope.def(IS_BUFFER_ARGS, '(', elementDefn, ')')

          var ifte = env.cond(elementStream)
            .then(elements, '=', ELEMENT_STATE, '.createStream(', elementDefn, ');')
            .else(elements, '=', ELEMENT_STATE, '.getElements(', elementDefn, ');')

          check$1.optional(function () {
            env.assert(ifte.else,
              '!' + elementDefn + '||' + elements,
              'invalid elements')
          })

          scope.entry(ifte)
          scope.exit(
            env.cond(elementStream)
              .then(ELEMENT_STATE, '.destroyStream(', elements, ');'))

          env.ELEMENTS = elements

          return elements
        })
      } else if (vaoActive) {
        return new Declaration(
          vao.thisDep,
          vao.contextDep,
          vao.propDep,
          function (env, scope) {
            return scope.def(env.shared.vao + '.currentVAO?' + env.shared.elements + '.getElements(' + env.shared.vao + '.currentVAO.elements):null')
          })
      }
      return null
    }

    var elements = parseElements()

    function parsePrimitive () {
      if (S_PRIMITIVE in staticOptions) {
        var primitive = staticOptions[S_PRIMITIVE]
        staticDraw.primitive = primitive
        check$1.commandParameter(primitive, primTypes, 'invalid primitve', env.commandStr)
        return createStaticDecl(function (env, scope) {
          return primTypes[primitive]
        })
      } else if (S_PRIMITIVE in dynamicOptions) {
        var dynPrimitive = dynamicOptions[S_PRIMITIVE]
        return createDynamicDecl(dynPrimitive, function (env, scope) {
          var PRIM_TYPES = env.constants.primTypes
          var prim = env.invoke(scope, dynPrimitive)
          check$1.optional(function () {
            env.assert(scope,
              prim + ' in ' + PRIM_TYPES,
              'invalid primitive, must be one of ' + Object.keys(primTypes))
          })
          return scope.def(PRIM_TYPES, '[', prim, ']')
        })
      } else if (elementsActive) {
        if (isStatic(elements)) {
          if (elements.value) {
            return createStaticDecl(function (env, scope) {
              return scope.def(env.ELEMENTS, '.primType')
            })
          } else {
            return createStaticDecl(function () {
              return GL_TRIANGLES$1
            })
          }
        } else {
          return new Declaration(
            elements.thisDep,
            elements.contextDep,
            elements.propDep,
            function (env, scope) {
              var elements = env.ELEMENTS
              return scope.def(elements, '?', elements, '.primType:', GL_TRIANGLES$1)
            })
        }
      } else if (vaoActive) {
        return new Declaration(
          vao.thisDep,
          vao.contextDep,
          vao.propDep,
          function (env, scope) {
            return scope.def(env.shared.vao + '.currentVAO?' + env.shared.vao + '.currentVAO.primitive:' + GL_TRIANGLES$1)
          })
      }
      return null
    }

    function parseParam (param, isOffset) {
      if (param in staticOptions) {
        var value = staticOptions[param] | 0
        if (isOffset) {
          staticDraw.offset = value
        } else {
          staticDraw.instances = value
        }
        check$1.command(!isOffset || value >= 0, 'invalid ' + param, env.commandStr)
        return createStaticDecl(function (env, scope) {
          if (isOffset) {
            env.OFFSET = value
          }
          return value
        })
      } else if (param in dynamicOptions) {
        var dynValue = dynamicOptions[param]
        return createDynamicDecl(dynValue, function (env, scope) {
          var result = env.invoke(scope, dynValue)
          if (isOffset) {
            env.OFFSET = result
            check$1.optional(function () {
              env.assert(scope,
                result + '>=0',
                'invalid ' + param)
            })
          }
          return result
        })
      } else if (isOffset) {
        if (elementsActive) {
          return createStaticDecl(function (env, scope) {
            env.OFFSET = 0
            return 0
          })
        } else if (vaoActive) {
          return new Declaration(
            vao.thisDep,
            vao.contextDep,
            vao.propDep,
            function (env, scope) {
              return scope.def(env.shared.vao + '.currentVAO?' + env.shared.vao + '.currentVAO.offset:0')
            })
        }
      } else if (vaoActive) {
        return new Declaration(
          vao.thisDep,
          vao.contextDep,
          vao.propDep,
          function (env, scope) {
            return scope.def(env.shared.vao + '.currentVAO?' + env.shared.vao + '.currentVAO.instances:-1')
          })
      }
      return null
    }

    var OFFSET = parseParam(S_OFFSET, true)

    function parseVertCount () {
      if (S_COUNT in staticOptions) {
        var count = staticOptions[S_COUNT] | 0
        staticDraw.count = count
        check$1.command(
          typeof count === 'number' && count >= 0, 'invalid vertex count', env.commandStr)
        return createStaticDecl(function () {
          return count
        })
      } else if (S_COUNT in dynamicOptions) {
        var dynCount = dynamicOptions[S_COUNT]
        return createDynamicDecl(dynCount, function (env, scope) {
          var result = env.invoke(scope, dynCount)
          check$1.optional(function () {
            env.assert(scope,
              'typeof ' + result + '==="number"&&' +
              result + '>=0&&' +
              result + '===(' + result + '|0)',
              'invalid vertex count')
          })
          return result
        })
      } else if (elementsActive) {
        if (isStatic(elements)) {
          if (elements) {
            if (OFFSET) {
              return new Declaration(
                OFFSET.thisDep,
                OFFSET.contextDep,
                OFFSET.propDep,
                function (env, scope) {
                  var result = scope.def(
                    env.ELEMENTS, '.vertCount-', env.OFFSET)

                  check$1.optional(function () {
                    env.assert(scope,
                      result + '>=0',
                      'invalid vertex offset/element buffer too small')
                  })

                  return result
                })
            } else {
              return createStaticDecl(function (env, scope) {
                return scope.def(env.ELEMENTS, '.vertCount')
              })
            }
          } else {
            var result = createStaticDecl(function () {
              return -1
            })
            check$1.optional(function () {
              result.MISSING = true
            })
            return result
          }
        } else {
          var variable = new Declaration(
            elements.thisDep || OFFSET.thisDep,
            elements.contextDep || OFFSET.contextDep,
            elements.propDep || OFFSET.propDep,
            function (env, scope) {
              var elements = env.ELEMENTS
              if (env.OFFSET) {
                return scope.def(elements, '?', elements, '.vertCount-',
                  env.OFFSET, ':-1')
              }
              return scope.def(elements, '?', elements, '.vertCount:-1')
            })
          check$1.optional(function () {
            variable.DYNAMIC = true
          })
          return variable
        }
      } else if (vaoActive) {
        var countVariable = new Declaration(
          vao.thisDep,
          vao.contextDep,
          vao.propDep,
          function (env, scope) {
            return scope.def(env.shared.vao, '.currentVAO?', env.shared.vao, '.currentVAO.count:-1')
          })
        return countVariable
      }
      return null
    }

    var primitive = parsePrimitive()
    var count = parseVertCount()
    var instances = parseParam(S_INSTANCES, false)

    return {
      elements: elements,
      primitive: primitive,
      count: count,
      instances: instances,
      offset: OFFSET,
      vao: vao,

      vaoActive: vaoActive,
      elementsActive: elementsActive,

      // static draw props
      static: staticDraw
    }
  }

  function parseGLState (options, env) {
    var staticOptions = options.static
    var dynamicOptions = options.dynamic

    var STATE = {}

    GL_STATE_NAMES.forEach(function (prop) {
      var param = propName(prop)

      function parseParam (parseStatic, parseDynamic) {
        if (prop in staticOptions) {
          var value = parseStatic(staticOptions[prop])
          STATE[param] = createStaticDecl(function () {
            return value
          })
        } else if (prop in dynamicOptions) {
          var dyn = dynamicOptions[prop]
          STATE[param] = createDynamicDecl(dyn, function (env, scope) {
            return parseDynamic(env, scope, env.invoke(scope, dyn))
          })
        }
      }

      switch (prop) {
        case S_CULL_ENABLE:
        case S_BLEND_ENABLE:
        case S_DITHER:
        case S_STENCIL_ENABLE:
        case S_DEPTH_ENABLE:
        case S_SCISSOR_ENABLE:
        case S_POLYGON_OFFSET_ENABLE:
        case S_SAMPLE_ALPHA:
        case S_SAMPLE_ENABLE:
        case S_DEPTH_MASK:
          return parseParam(
            function (value) {
              check$1.commandType(value, 'boolean', prop, env.commandStr)
              return value
            },
            function (env, scope, value) {
              check$1.optional(function () {
                env.assert(scope,
                  'typeof ' + value + '==="boolean"',
                  'invalid flag ' + prop, env.commandStr)
              })
              return value
            })

        case S_DEPTH_FUNC:
          return parseParam(
            function (value) {
              check$1.commandParameter(value, compareFuncs, 'invalid ' + prop, env.commandStr)
              return compareFuncs[value]
            },
            function (env, scope, value) {
              var COMPARE_FUNCS = env.constants.compareFuncs
              check$1.optional(function () {
                env.assert(scope,
                  value + ' in ' + COMPARE_FUNCS,
                  'invalid ' + prop + ', must be one of ' + Object.keys(compareFuncs))
              })
              return scope.def(COMPARE_FUNCS, '[', value, ']')
            })

        case S_DEPTH_RANGE:
          return parseParam(
            function (value) {
              check$1.command(
                isArrayLike(value) &&
                value.length === 2 &&
                typeof value[0] === 'number' &&
                typeof value[1] === 'number' &&
                value[0] <= value[1],
                'depth range is 2d array',
                env.commandStr)
              return value
            },
            function (env, scope, value) {
              check$1.optional(function () {
                env.assert(scope,
                  env.shared.isArrayLike + '(' + value + ')&&' +
                  value + '.length===2&&' +
                  'typeof ' + value + '[0]==="number"&&' +
                  'typeof ' + value + '[1]==="number"&&' +
                  value + '[0]<=' + value + '[1]',
                  'depth range must be a 2d array')
              })

              var Z_NEAR = scope.def('+', value, '[0]')
              var Z_FAR = scope.def('+', value, '[1]')
              return [Z_NEAR, Z_FAR]
            })

        case S_BLEND_FUNC:
          return parseParam(
            function (value) {
              check$1.commandType(value, 'object', 'blend.func', env.commandStr)
              var srcRGB = ('srcRGB' in value ? value.srcRGB : value.src)
              var srcAlpha = ('srcAlpha' in value ? value.srcAlpha : value.src)
              var dstRGB = ('dstRGB' in value ? value.dstRGB : value.dst)
              var dstAlpha = ('dstAlpha' in value ? value.dstAlpha : value.dst)
              check$1.commandParameter(srcRGB, blendFuncs, param + '.srcRGB', env.commandStr)
              check$1.commandParameter(srcAlpha, blendFuncs, param + '.srcAlpha', env.commandStr)
              check$1.commandParameter(dstRGB, blendFuncs, param + '.dstRGB', env.commandStr)
              check$1.commandParameter(dstAlpha, blendFuncs, param + '.dstAlpha', env.commandStr)

              check$1.command(
                (invalidBlendCombinations.indexOf(srcRGB + ', ' + dstRGB) === -1),
                'unallowed blending combination (srcRGB, dstRGB) = (' + srcRGB + ', ' + dstRGB + ')', env.commandStr)

              return [
                blendFuncs[srcRGB],
                blendFuncs[dstRGB],
                blendFuncs[srcAlpha],
                blendFuncs[dstAlpha]
              ]
            },
            function (env, scope, value) {
              var BLEND_FUNCS = env.constants.blendFuncs

              check$1.optional(function () {
                env.assert(scope,
                  value + '&&typeof ' + value + '==="object"',
                  'invalid blend func, must be an object')
              })

              function read (prefix, suffix) {
                var func = scope.def(
                  '"', prefix, suffix, '" in ', value,
                  '?', value, '.', prefix, suffix,
                  ':', value, '.', prefix)

                check$1.optional(function () {
                  env.assert(scope,
                    func + ' in ' + BLEND_FUNCS,
                    'invalid ' + prop + '.' + prefix + suffix + ', must be one of ' + Object.keys(blendFuncs))
                })

                return func
              }

              var srcRGB = read('src', 'RGB')
              var dstRGB = read('dst', 'RGB')

              check$1.optional(function () {
                var INVALID_BLEND_COMBINATIONS = env.constants.invalidBlendCombinations

                env.assert(scope,
                  INVALID_BLEND_COMBINATIONS +
                           '.indexOf(' + srcRGB + '+", "+' + dstRGB + ') === -1 ',
                  'unallowed blending combination for (srcRGB, dstRGB)'
                )
              })

              var SRC_RGB = scope.def(BLEND_FUNCS, '[', srcRGB, ']')
              var SRC_ALPHA = scope.def(BLEND_FUNCS, '[', read('src', 'Alpha'), ']')
              var DST_RGB = scope.def(BLEND_FUNCS, '[', dstRGB, ']')
              var DST_ALPHA = scope.def(BLEND_FUNCS, '[', read('dst', 'Alpha'), ']')

              return [SRC_RGB, DST_RGB, SRC_ALPHA, DST_ALPHA]
            })

        case S_BLEND_EQUATION:
          return parseParam(
            function (value) {
              if (typeof value === 'string') {
                check$1.commandParameter(value, blendEquations, 'invalid ' + prop, env.commandStr)
                return [
                  blendEquations[value],
                  blendEquations[value]
                ]
              } else if (typeof value === 'object') {
                check$1.commandParameter(
                  value.rgb, blendEquations, prop + '.rgb', env.commandStr)
                check$1.commandParameter(
                  value.alpha, blendEquations, prop + '.alpha', env.commandStr)
                return [
                  blendEquations[value.rgb],
                  blendEquations[value.alpha]
                ]
              } else {
                check$1.commandRaise('invalid blend.equation', env.commandStr)
              }
            },
            function (env, scope, value) {
              var BLEND_EQUATIONS = env.constants.blendEquations

              var RGB = scope.def()
              var ALPHA = scope.def()

              var ifte = env.cond('typeof ', value, '==="string"')

              check$1.optional(function () {
                function checkProp (block, name, value) {
                  env.assert(block,
                    value + ' in ' + BLEND_EQUATIONS,
                    'invalid ' + name + ', must be one of ' + Object.keys(blendEquations))
                }
                checkProp(ifte.then, prop, value)

                env.assert(ifte.else,
                  value + '&&typeof ' + value + '==="object"',
                  'invalid ' + prop)
                checkProp(ifte.else, prop + '.rgb', value + '.rgb')
                checkProp(ifte.else, prop + '.alpha', value + '.alpha')
              })

              ifte.then(
                RGB, '=', ALPHA, '=', BLEND_EQUATIONS, '[', value, '];')
              ifte.else(
                RGB, '=', BLEND_EQUATIONS, '[', value, '.rgb];',
                ALPHA, '=', BLEND_EQUATIONS, '[', value, '.alpha];')

              scope(ifte)

              return [RGB, ALPHA]
            })

        case S_BLEND_COLOR:
          return parseParam(
            function (value) {
              check$1.command(
                isArrayLike(value) &&
                value.length === 4,
                'blend.color must be a 4d array', env.commandStr)
              return loop(4, function (i) {
                return +value[i]
              })
            },
            function (env, scope, value) {
              check$1.optional(function () {
                env.assert(scope,
                  env.shared.isArrayLike + '(' + value + ')&&' +
                  value + '.length===4',
                  'blend.color must be a 4d array')
              })
              return loop(4, function (i) {
                return scope.def('+', value, '[', i, ']')
              })
            })

        case S_STENCIL_MASK:
          return parseParam(
            function (value) {
              check$1.commandType(value, 'number', param, env.commandStr)
              return value | 0
            },
            function (env, scope, value) {
              check$1.optional(function () {
                env.assert(scope,
                  'typeof ' + value + '==="number"',
                  'invalid stencil.mask')
              })
              return scope.def(value, '|0')
            })

        case S_STENCIL_FUNC:
          return parseParam(
            function (value) {
              check$1.commandType(value, 'object', param, env.commandStr)
              var cmp = value.cmp || 'keep'
              var ref = value.ref || 0
              var mask = 'mask' in value ? value.mask : -1
              check$1.commandParameter(cmp, compareFuncs, prop + '.cmp', env.commandStr)
              check$1.commandType(ref, 'number', prop + '.ref', env.commandStr)
              check$1.commandType(mask, 'number', prop + '.mask', env.commandStr)
              return [
                compareFuncs[cmp],
                ref,
                mask
              ]
            },
            function (env, scope, value) {
              var COMPARE_FUNCS = env.constants.compareFuncs
              check$1.optional(function () {
                function assert () {
                  env.assert(scope,
                    Array.prototype.join.call(arguments, ''),
                    'invalid stencil.func')
                }
                assert(value + '&&typeof ', value, '==="object"')
                assert('!("cmp" in ', value, ')||(',
                  value, '.cmp in ', COMPARE_FUNCS, ')')
              })
              var cmp = scope.def(
                '"cmp" in ', value,
                '?', COMPARE_FUNCS, '[', value, '.cmp]',
                ':', GL_KEEP)
              var ref = scope.def(value, '.ref|0')
              var mask = scope.def(
                '"mask" in ', value,
                '?', value, '.mask|0:-1')
              return [cmp, ref, mask]
            })

        case S_STENCIL_OPFRONT:
        case S_STENCIL_OPBACK:
          return parseParam(
            function (value) {
              check$1.commandType(value, 'object', param, env.commandStr)
              var fail = value.fail || 'keep'
              var zfail = value.zfail || 'keep'
              var zpass = value.zpass || 'keep'
              check$1.commandParameter(fail, stencilOps, prop + '.fail', env.commandStr)
              check$1.commandParameter(zfail, stencilOps, prop + '.zfail', env.commandStr)
              check$1.commandParameter(zpass, stencilOps, prop + '.zpass', env.commandStr)
              return [
                prop === S_STENCIL_OPBACK ? GL_BACK : GL_FRONT,
                stencilOps[fail],
                stencilOps[zfail],
                stencilOps[zpass]
              ]
            },
            function (env, scope, value) {
              var STENCIL_OPS = env.constants.stencilOps

              check$1.optional(function () {
                env.assert(scope,
                  value + '&&typeof ' + value + '==="object"',
                  'invalid ' + prop)
              })

              function read (name) {
                check$1.optional(function () {
                  env.assert(scope,
                    '!("' + name + '" in ' + value + ')||' +
                    '(' + value + '.' + name + ' in ' + STENCIL_OPS + ')',
                    'invalid ' + prop + '.' + name + ', must be one of ' + Object.keys(stencilOps))
                })

                return scope.def(
                  '"', name, '" in ', value,
                  '?', STENCIL_OPS, '[', value, '.', name, ']:',
                  GL_KEEP)
              }

              return [
                prop === S_STENCIL_OPBACK ? GL_BACK : GL_FRONT,
                read('fail'),
                read('zfail'),
                read('zpass')
              ]
            })

        case S_POLYGON_OFFSET_OFFSET:
          return parseParam(
            function (value) {
              check$1.commandType(value, 'object', param, env.commandStr)
              var factor = value.factor | 0
              var units = value.units | 0
              check$1.commandType(factor, 'number', param + '.factor', env.commandStr)
              check$1.commandType(units, 'number', param + '.units', env.commandStr)
              return [factor, units]
            },
            function (env, scope, value) {
              check$1.optional(function () {
                env.assert(scope,
                  value + '&&typeof ' + value + '==="object"',
                  'invalid ' + prop)
              })

              var FACTOR = scope.def(value, '.factor|0')
              var UNITS = scope.def(value, '.units|0')

              return [FACTOR, UNITS]
            })

        case S_CULL_FACE:
          return parseParam(
            function (value) {
              var face = 0
              if (value === 'front') {
                face = GL_FRONT
              } else if (value === 'back') {
                face = GL_BACK
              }
              check$1.command(!!face, param, env.commandStr)
              return face
            },
            function (env, scope, value) {
              check$1.optional(function () {
                env.assert(scope,
                  value + '==="front"||' +
                  value + '==="back"',
                  'invalid cull.face')
              })
              return scope.def(value, '==="front"?', GL_FRONT, ':', GL_BACK)
            })

        case S_LINE_WIDTH:
          return parseParam(
            function (value) {
              check$1.command(
                typeof value === 'number' &&
                value >= limits.lineWidthDims[0] &&
                value <= limits.lineWidthDims[1],
                'invalid line width, must be a positive number between ' +
                limits.lineWidthDims[0] + ' and ' + limits.lineWidthDims[1], env.commandStr)
              return value
            },
            function (env, scope, value) {
              check$1.optional(function () {
                env.assert(scope,
                  'typeof ' + value + '==="number"&&' +
                  value + '>=' + limits.lineWidthDims[0] + '&&' +
                  value + '<=' + limits.lineWidthDims[1],
                  'invalid line width')
              })

              return value
            })

        case S_FRONT_FACE:
          return parseParam(
            function (value) {
              check$1.commandParameter(value, orientationType, param, env.commandStr)
              return orientationType[value]
            },
            function (env, scope, value) {
              check$1.optional(function () {
                env.assert(scope,
                  value + '==="cw"||' +
                  value + '==="ccw"',
                  'invalid frontFace, must be one of cw,ccw')
              })
              return scope.def(value + '==="cw"?' + GL_CW + ':' + GL_CCW)
            })

        case S_COLOR_MASK:
          return parseParam(
            function (value) {
              check$1.command(
                isArrayLike(value) && value.length === 4,
                'color.mask must be length 4 array', env.commandStr)
              return value.map(function (v) { return !!v })
            },
            function (env, scope, value) {
              check$1.optional(function () {
                env.assert(scope,
                  env.shared.isArrayLike + '(' + value + ')&&' +
                  value + '.length===4',
                  'invalid color.mask')
              })
              return loop(4, function (i) {
                return '!!' + value + '[' + i + ']'
              })
            })

        case S_SAMPLE_COVERAGE:
          return parseParam(
            function (value) {
              check$1.command(typeof value === 'object' && value, param, env.commandStr)
              var sampleValue = 'value' in value ? value.value : 1
              var sampleInvert = !!value.invert
              check$1.command(
                typeof sampleValue === 'number' &&
                sampleValue >= 0 && sampleValue <= 1,
                'sample.coverage.value must be a number between 0 and 1', env.commandStr)
              return [sampleValue, sampleInvert]
            },
            function (env, scope, value) {
              check$1.optional(function () {
                env.assert(scope,
                  value + '&&typeof ' + value + '==="object"',
                  'invalid sample.coverage')
              })
              var VALUE = scope.def(
                '"value" in ', value, '?+', value, '.value:1')
              var INVERT = scope.def('!!', value, '.invert')
              return [VALUE, INVERT]
            })
      }
    })

    return STATE
  }

  function parseUniforms (uniforms, env) {
    var staticUniforms = uniforms.static
    var dynamicUniforms = uniforms.dynamic

    var UNIFORMS = {}

    Object.keys(staticUniforms).forEach(function (name) {
      var value = staticUniforms[name]
      var result
      if (typeof value === 'number' ||
          typeof value === 'boolean') {
        result = createStaticDecl(function () {
          return value
        })
      } else if (typeof value === 'function') {
        var reglType = value._reglType
        if (reglType === 'texture2d' ||
            reglType === 'textureCube') {
          result = createStaticDecl(function (env) {
            return env.link(value)
          })
        } else if (reglType === 'framebuffer' ||
                   reglType === 'framebufferCube') {
          check$1.command(value.color.length > 0,
            'missing color attachment for framebuffer sent to uniform "' + name + '"', env.commandStr)
          result = createStaticDecl(function (env) {
            return env.link(value.color[0])
          })
        } else {
          check$1.commandRaise('invalid data for uniform "' + name + '"', env.commandStr)
        }
      } else if (isArrayLike(value)) {
        result = createStaticDecl(function (env) {
          var ITEM = env.global.def('[',
            loop(value.length, function (i) {
              check$1.command(
                typeof value[i] === 'number' ||
                typeof value[i] === 'boolean',
                'invalid uniform ' + name, env.commandStr)
              return value[i]
            }), ']')
          return ITEM
        })
      } else {
        check$1.commandRaise('invalid or missing data for uniform "' + name + '"', env.commandStr)
      }
      result.value = value
      UNIFORMS[name] = result
    })

    Object.keys(dynamicUniforms).forEach(function (key) {
      var dyn = dynamicUniforms[key]
      UNIFORMS[key] = createDynamicDecl(dyn, function (env, scope) {
        return env.invoke(scope, dyn)
      })
    })

    return UNIFORMS
  }

  function parseAttributes (attributes, env) {
    var staticAttributes = attributes.static
    var dynamicAttributes = attributes.dynamic

    var attributeDefs = {}

    Object.keys(staticAttributes).forEach(function (attribute) {
      var value = staticAttributes[attribute]
      var id = stringStore.id(attribute)

      var record = new AttributeRecord()
      if (isBufferArgs(value)) {
        record.state = ATTRIB_STATE_POINTER
        record.buffer = bufferState.getBuffer(
          bufferState.create(value, GL_ARRAY_BUFFER$2, false, true))
        record.type = 0
      } else {
        var buffer = bufferState.getBuffer(value)
        if (buffer) {
          record.state = ATTRIB_STATE_POINTER
          record.buffer = buffer
          record.type = 0
        } else {
          check$1.command(typeof value === 'object' && value,
            'invalid data for attribute ' + attribute, env.commandStr)
          if ('constant' in value) {
            var constant = value.constant
            record.buffer = 'null'
            record.state = ATTRIB_STATE_CONSTANT
            if (typeof constant === 'number') {
              record.x = constant
            } else {
              check$1.command(
                isArrayLike(constant) &&
                constant.length > 0 &&
                constant.length <= 4,
                'invalid constant for attribute ' + attribute, env.commandStr)
              CUTE_COMPONENTS.forEach(function (c, i) {
                if (i < constant.length) {
                  record[c] = constant[i]
                }
              })
            }
          } else {
            if (isBufferArgs(value.buffer)) {
              buffer = bufferState.getBuffer(
                bufferState.create(value.buffer, GL_ARRAY_BUFFER$2, false, true))
            } else {
              buffer = bufferState.getBuffer(value.buffer)
            }
            check$1.command(!!buffer, 'missing buffer for attribute "' + attribute + '"', env.commandStr)

            var offset = value.offset | 0
            check$1.command(offset >= 0,
              'invalid offset for attribute "' + attribute + '"', env.commandStr)

            var stride = value.stride | 0
            check$1.command(stride >= 0 && stride < 256,
              'invalid stride for attribute "' + attribute + '", must be integer betweeen [0, 255]', env.commandStr)

            var size = value.size | 0
            check$1.command(!('size' in value) || (size > 0 && size <= 4),
              'invalid size for attribute "' + attribute + '", must be 1,2,3,4', env.commandStr)

            var normalized = !!value.normalized

            var type = 0
            if ('type' in value) {
              check$1.commandParameter(
                value.type, glTypes,
                'invalid type for attribute ' + attribute, env.commandStr)
              type = glTypes[value.type]
            }

            var divisor = value.divisor | 0
            check$1.optional(function () {
              if ('divisor' in value) {
                check$1.command(divisor === 0 || extInstancing,
                  'cannot specify divisor for attribute "' + attribute + '", instancing not supported', env.commandStr)
                check$1.command(divisor >= 0,
                  'invalid divisor for attribute "' + attribute + '"', env.commandStr)
              }

              var command = env.commandStr

              var VALID_KEYS = [
                'buffer',
                'offset',
                'divisor',
                'normalized',
                'type',
                'size',
                'stride'
              ]

              Object.keys(value).forEach(function (prop) {
                check$1.command(
                  VALID_KEYS.indexOf(prop) >= 0,
                  'unknown parameter "' + prop + '" for attribute pointer "' + attribute + '" (valid parameters are ' + VALID_KEYS + ')',
                  command)
              })
            })

            record.buffer = buffer
            record.state = ATTRIB_STATE_POINTER
            record.size = size
            record.normalized = normalized
            record.type = type || buffer.dtype
            record.offset = offset
            record.stride = stride
            record.divisor = divisor
          }
        }
      }

      attributeDefs[attribute] = createStaticDecl(function (env, scope) {
        var cache = env.attribCache
        if (id in cache) {
          return cache[id]
        }
        var result = {
          isStream: false
        }
        Object.keys(record).forEach(function (key) {
          result[key] = record[key]
        })
        if (record.buffer) {
          result.buffer = env.link(record.buffer)
          result.type = result.type || (result.buffer + '.dtype')
        }
        cache[id] = result
        return result
      })
    })

    Object.keys(dynamicAttributes).forEach(function (attribute) {
      var dyn = dynamicAttributes[attribute]

      function appendAttributeCode (env, block) {
        var VALUE = env.invoke(block, dyn)

        var shared = env.shared
        var constants = env.constants

        var IS_BUFFER_ARGS = shared.isBufferArgs
        var BUFFER_STATE = shared.buffer

        // Perform validation on attribute
        check$1.optional(function () {
          env.assert(block,
            VALUE + '&&(typeof ' + VALUE + '==="object"||typeof ' +
            VALUE + '==="function")&&(' +
            IS_BUFFER_ARGS + '(' + VALUE + ')||' +
            BUFFER_STATE + '.getBuffer(' + VALUE + ')||' +
            BUFFER_STATE + '.getBuffer(' + VALUE + '.buffer)||' +
            IS_BUFFER_ARGS + '(' + VALUE + '.buffer)||' +
            '("constant" in ' + VALUE +
            '&&(typeof ' + VALUE + '.constant==="number"||' +
            shared.isArrayLike + '(' + VALUE + '.constant))))',
            'invalid dynamic attribute "' + attribute + '"')
        })

        // allocate names for result
        var result = {
          isStream: block.def(false)
        }
        var defaultRecord = new AttributeRecord()
        defaultRecord.state = ATTRIB_STATE_POINTER
        Object.keys(defaultRecord).forEach(function (key) {
          result[key] = block.def('' + defaultRecord[key])
        })

        var BUFFER = result.buffer
        var TYPE = result.type
        block(
          'if(', IS_BUFFER_ARGS, '(', VALUE, ')){',
          result.isStream, '=true;',
          BUFFER, '=', BUFFER_STATE, '.createStream(', GL_ARRAY_BUFFER$2, ',', VALUE, ');',
          TYPE, '=', BUFFER, '.dtype;',
          '}else{',
          BUFFER, '=', BUFFER_STATE, '.getBuffer(', VALUE, ');',
          'if(', BUFFER, '){',
          TYPE, '=', BUFFER, '.dtype;',
          '}else if("constant" in ', VALUE, '){',
          result.state, '=', ATTRIB_STATE_CONSTANT, ';',
          'if(typeof ' + VALUE + '.constant === "number"){',
          result[CUTE_COMPONENTS[0]], '=', VALUE, '.constant;',
          CUTE_COMPONENTS.slice(1).map(function (n) {
            return result[n]
          }).join('='), '=0;',
          '}else{',
          CUTE_COMPONENTS.map(function (name, i) {
            return (
              result[name] + '=' + VALUE + '.constant.length>' + i +
              '?' + VALUE + '.constant[' + i + ']:0;'
            )
          }).join(''),
          '}}else{',
          'if(', IS_BUFFER_ARGS, '(', VALUE, '.buffer)){',
          BUFFER, '=', BUFFER_STATE, '.createStream(', GL_ARRAY_BUFFER$2, ',', VALUE, '.buffer);',
          '}else{',
          BUFFER, '=', BUFFER_STATE, '.getBuffer(', VALUE, '.buffer);',
          '}',
          TYPE, '="type" in ', VALUE, '?',
          constants.glTypes, '[', VALUE, '.type]:', BUFFER, '.dtype;',
          result.normalized, '=!!', VALUE, '.normalized;')
        function emitReadRecord (name) {
          block(result[name], '=', VALUE, '.', name, '|0;')
        }
        emitReadRecord('size')
        emitReadRecord('offset')
        emitReadRecord('stride')
        emitReadRecord('divisor')

        block('}}')

        block.exit(
          'if(', result.isStream, '){',
          BUFFER_STATE, '.destroyStream(', BUFFER, ');',
          '}')

        return result
      }

      attributeDefs[attribute] = createDynamicDecl(dyn, appendAttributeCode)
    })

    return attributeDefs
  }

  function parseContext (context) {
    var staticContext = context.static
    var dynamicContext = context.dynamic
    var result = {}

    Object.keys(staticContext).forEach(function (name) {
      var value = staticContext[name]
      result[name] = createStaticDecl(function (env, scope) {
        if (typeof value === 'number' || typeof value === 'boolean') {
          return '' + value
        } else {
          return env.link(value)
        }
      })
    })

    Object.keys(dynamicContext).forEach(function (name) {
      var dyn = dynamicContext[name]
      result[name] = createDynamicDecl(dyn, function (env, scope) {
        return env.invoke(scope, dyn)
      })
    })

    return result
  }

  function parseArguments (options, attributes, uniforms, context, env) {
    var staticOptions = options.static
    var dynamicOptions = options.dynamic

    check$1.optional(function () {
      var KEY_NAMES = [
        S_FRAMEBUFFER,
        S_VERT,
        S_FRAG,
        S_ELEMENTS,
        S_PRIMITIVE,
        S_OFFSET,
        S_COUNT,
        S_INSTANCES,
        S_PROFILE,
        S_VAO
      ].concat(GL_STATE_NAMES)

      function checkKeys (dict) {
        Object.keys(dict).forEach(function (key) {
          check$1.command(
            KEY_NAMES.indexOf(key) >= 0,
            'unknown parameter "' + key + '"',
            env.commandStr)
        })
      }

      checkKeys(staticOptions)
      checkKeys(dynamicOptions)
    })

    var attribLocations = parseAttribLocations(options, attributes)

    var framebuffer = parseFramebuffer(options, env)
    var viewportAndScissor = parseViewportScissor(options, framebuffer, env)
    var draw = parseDraw(options, env)
    var state = parseGLState(options, env)
    var shader = parseProgram(options, env, attribLocations)

    function copyBox (name) {
      var defn = viewportAndScissor[name]
      if (defn) {
        state[name] = defn
      }
    }
    copyBox(S_VIEWPORT)
    copyBox(propName(S_SCISSOR_BOX))

    var dirty = Object.keys(state).length > 0

    var result = {
      framebuffer: framebuffer,
      draw: draw,
      shader: shader,
      state: state,
      dirty: dirty,
      scopeVAO: null,
      drawVAO: null,
      useVAO: false,
      attributes: {}
    }

    result.profile = parseProfile(options, env)
    result.uniforms = parseUniforms(uniforms, env)
    result.drawVAO = result.scopeVAO = draw.vao
    // special case: check if we can statically allocate a vertex array object for this program
    if (!result.drawVAO &&
      shader.program &&
      !attribLocations &&
      extensions.angle_instanced_arrays &&
      draw.static.elements) {
      var useVAO = true
      var staticBindings = shader.program.attributes.map(function (attr) {
        var binding = attributes.static[attr]
        useVAO = useVAO && !!binding
        return binding
      })
      if (useVAO && staticBindings.length > 0) {
        var vao = attributeState.getVAO(attributeState.createVAO({
          attributes: staticBindings,
          elements: draw.static.elements
        }))
        result.drawVAO = new Declaration(null, null, null, function (env, scope) {
          return env.link(vao)
        })
        result.useVAO = true
      }
    }
    if (attribLocations) {
      result.useVAO = true
    } else {
      result.attributes = parseAttributes(attributes, env)
    }
    result.context = parseContext(context, env)
    return result
  }

  // ===================================================
  // ===================================================
  // COMMON UPDATE FUNCTIONS
  // ===================================================
  // ===================================================
  function emitContext (env, scope, context) {
    var shared = env.shared
    var CONTEXT = shared.context

    var contextEnter = env.scope()

    Object.keys(context).forEach(function (name) {
      scope.save(CONTEXT, '.' + name)
      var defn = context[name]
      var value = defn.append(env, scope)
      if (Array.isArray(value)) {
        contextEnter(CONTEXT, '.', name, '=[', value.join(), '];')
      } else {
        contextEnter(CONTEXT, '.', name, '=', value, ';')
      }
    })

    scope(contextEnter)
  }

  // ===================================================
  // ===================================================
  // COMMON DRAWING FUNCTIONS
  // ===================================================
  // ===================================================
  function emitPollFramebuffer (env, scope, framebuffer, skipCheck) {
    var shared = env.shared

    var GL = shared.gl
    var FRAMEBUFFER_STATE = shared.framebuffer
    var EXT_DRAW_BUFFERS
    if (extDrawBuffers) {
      EXT_DRAW_BUFFERS = scope.def(shared.extensions, '.webgl_draw_buffers')
    }

    var constants = env.constants

    var DRAW_BUFFERS = constants.drawBuffer
    var BACK_BUFFER = constants.backBuffer

    var NEXT
    if (framebuffer) {
      NEXT = framebuffer.append(env, scope)
    } else {
      NEXT = scope.def(FRAMEBUFFER_STATE, '.next')
    }

    if (!skipCheck) {
      scope('if(', NEXT, '!==', FRAMEBUFFER_STATE, '.cur){')
    }
    scope(
      'if(', NEXT, '){',
      GL, '.bindFramebuffer(', GL_FRAMEBUFFER$2, ',', NEXT, '.framebuffer);')
    if (extDrawBuffers) {
      scope(EXT_DRAW_BUFFERS, '.drawBuffersWEBGL(',
        DRAW_BUFFERS, '[', NEXT, '.colorAttachments.length]);')
    }
    scope('}else{',
      GL, '.bindFramebuffer(', GL_FRAMEBUFFER$2, ',null);')
    if (extDrawBuffers) {
      scope(EXT_DRAW_BUFFERS, '.drawBuffersWEBGL(', BACK_BUFFER, ');')
    }
    scope(
      '}',
      FRAMEBUFFER_STATE, '.cur=', NEXT, ';')
    if (!skipCheck) {
      scope('}')
    }
  }

  function emitPollState (env, scope, args) {
    var shared = env.shared

    var GL = shared.gl

    var CURRENT_VARS = env.current
    var NEXT_VARS = env.next
    var CURRENT_STATE = shared.current
    var NEXT_STATE = shared.next

    var block = env.cond(CURRENT_STATE, '.dirty')

    GL_STATE_NAMES.forEach(function (prop) {
      var param = propName(prop)
      if (param in args.state) {
        return
      }

      var NEXT, CURRENT
      if (param in NEXT_VARS) {
        NEXT = NEXT_VARS[param]
        CURRENT = CURRENT_VARS[param]
        var parts = loop(currentState[param].length, function (i) {
          return block.def(NEXT, '[', i, ']')
        })
        block(env.cond(parts.map(function (p, i) {
          return p + '!==' + CURRENT + '[' + i + ']'
        }).join('||'))
          .then(
            GL, '.', GL_VARIABLES[param], '(', parts, ');',
            parts.map(function (p, i) {
              return CURRENT + '[' + i + ']=' + p
            }).join(';'), ';'))
      } else {
        NEXT = block.def(NEXT_STATE, '.', param)
        var ifte = env.cond(NEXT, '!==', CURRENT_STATE, '.', param)
        block(ifte)
        if (param in GL_FLAGS) {
          ifte(
            env.cond(NEXT)
              .then(GL, '.enable(', GL_FLAGS[param], ');')
              .else(GL, '.disable(', GL_FLAGS[param], ');'),
            CURRENT_STATE, '.', param, '=', NEXT, ';')
        } else {
          ifte(
            GL, '.', GL_VARIABLES[param], '(', NEXT, ');',
            CURRENT_STATE, '.', param, '=', NEXT, ';')
        }
      }
    })
    if (Object.keys(args.state).length === 0) {
      block(CURRENT_STATE, '.dirty=false;')
    }
    scope(block)
  }

  function emitSetOptions (env, scope, options, filter) {
    var shared = env.shared
    var CURRENT_VARS = env.current
    var CURRENT_STATE = shared.current
    var GL = shared.gl
    sortState(Object.keys(options)).forEach(function (param) {
      var defn = options[param]
      if (filter && !filter(defn)) {
        return
      }
      var variable = defn.append(env, scope)
      if (GL_FLAGS[param]) {
        var flag = GL_FLAGS[param]
        if (isStatic(defn)) {
          if (variable) {
            scope(GL, '.enable(', flag, ');')
          } else {
            scope(GL, '.disable(', flag, ');')
          }
        } else {
          scope(env.cond(variable)
            .then(GL, '.enable(', flag, ');')
            .else(GL, '.disable(', flag, ');'))
        }
        scope(CURRENT_STATE, '.', param, '=', variable, ';')
      } else if (isArrayLike(variable)) {
        var CURRENT = CURRENT_VARS[param]
        scope(
          GL, '.', GL_VARIABLES[param], '(', variable, ');',
          variable.map(function (v, i) {
            return CURRENT + '[' + i + ']=' + v
          }).join(';'), ';')
      } else {
        scope(
          GL, '.', GL_VARIABLES[param], '(', variable, ');',
          CURRENT_STATE, '.', param, '=', variable, ';')
      }
    })
  }

  function injectExtensions (env, scope) {
    if (extInstancing) {
      env.instancing = scope.def(
        env.shared.extensions, '.angle_instanced_arrays')
    }
  }

  function emitProfile (env, scope, args, useScope, incrementCounter) {
    var shared = env.shared
    var STATS = env.stats
    var CURRENT_STATE = shared.current
    var TIMER = shared.timer
    var profileArg = args.profile

    function perfCounter () {
      if (typeof performance === 'undefined') {
        return 'Date.now()'
      } else {
        return 'performance.now()'
      }
    }

    var CPU_START, QUERY_COUNTER
    function emitProfileStart (block) {
      CPU_START = scope.def()
      block(CPU_START, '=', perfCounter(), ';')
      if (typeof incrementCounter === 'string') {
        block(STATS, '.count+=', incrementCounter, ';')
      } else {
        block(STATS, '.count++;')
      }
      if (timer) {
        if (useScope) {
          QUERY_COUNTER = scope.def()
          block(QUERY_COUNTER, '=', TIMER, '.getNumPendingQueries();')
        } else {
          block(TIMER, '.beginQuery(', STATS, ');')
        }
      }
    }

    function emitProfileEnd (block) {
      block(STATS, '.cpuTime+=', perfCounter(), '-', CPU_START, ';')
      if (timer) {
        if (useScope) {
          block(TIMER, '.pushScopeStats(',
            QUERY_COUNTER, ',',
            TIMER, '.getNumPendingQueries(),',
            STATS, ');')
        } else {
          block(TIMER, '.endQuery();')
        }
      }
    }

    function scopeProfile (value) {
      var prev = scope.def(CURRENT_STATE, '.profile')
      scope(CURRENT_STATE, '.profile=', value, ';')
      scope.exit(CURRENT_STATE, '.profile=', prev, ';')
    }

    var USE_PROFILE
    if (profileArg) {
      if (isStatic(profileArg)) {
        if (profileArg.enable) {
          emitProfileStart(scope)
          emitProfileEnd(scope.exit)
          scopeProfile('true')
        } else {
          scopeProfile('false')
        }
        return
      }
      USE_PROFILE = profileArg.append(env, scope)
      scopeProfile(USE_PROFILE)
    } else {
      USE_PROFILE = scope.def(CURRENT_STATE, '.profile')
    }

    var start = env.block()
    emitProfileStart(start)
    scope('if(', USE_PROFILE, '){', start, '}')
    var end = env.block()
    emitProfileEnd(end)
    scope.exit('if(', USE_PROFILE, '){', end, '}')
  }

  function emitAttributes (env, scope, args, attributes, filter) {
    var shared = env.shared

    function typeLength (x) {
      switch (x) {
        case GL_FLOAT_VEC2:
        case GL_INT_VEC2:
        case GL_BOOL_VEC2:
          return 2
        case GL_FLOAT_VEC3:
        case GL_INT_VEC3:
        case GL_BOOL_VEC3:
          return 3
        case GL_FLOAT_VEC4:
        case GL_INT_VEC4:
        case GL_BOOL_VEC4:
          return 4
        default:
          return 1
      }
    }

    function emitBindAttribute (ATTRIBUTE, size, record) {
      var GL = shared.gl

      var LOCATION = scope.def(ATTRIBUTE, '.location')
      var BINDING = scope.def(shared.attributes, '[', LOCATION, ']')

      var STATE = record.state
      var BUFFER = record.buffer
      var CONST_COMPONENTS = [
        record.x,
        record.y,
        record.z,
        record.w
      ]

      var COMMON_KEYS = [
        'buffer',
        'normalized',
        'offset',
        'stride'
      ]

      function emitBuffer () {
        scope(
          'if(!', BINDING, '.buffer){',
          GL, '.enableVertexAttribArray(', LOCATION, ');}')

        var TYPE = record.type
        var SIZE
        if (!record.size) {
          SIZE = size
        } else {
          SIZE = scope.def(record.size, '||', size)
        }

        scope('if(',
          BINDING, '.type!==', TYPE, '||',
          BINDING, '.size!==', SIZE, '||',
          COMMON_KEYS.map(function (key) {
            return BINDING + '.' + key + '!==' + record[key]
          }).join('||'),
          '){',
          GL, '.bindBuffer(', GL_ARRAY_BUFFER$2, ',', BUFFER, '.buffer);',
          GL, '.vertexAttribPointer(', [
            LOCATION,
            SIZE,
            TYPE,
            record.normalized,
            record.stride,
            record.offset
          ], ');',
          BINDING, '.type=', TYPE, ';',
          BINDING, '.size=', SIZE, ';',
          COMMON_KEYS.map(function (key) {
            return BINDING + '.' + key + '=' + record[key] + ';'
          }).join(''),
          '}')

        if (extInstancing) {
          var DIVISOR = record.divisor
          scope(
            'if(', BINDING, '.divisor!==', DIVISOR, '){',
            env.instancing, '.vertexAttribDivisorANGLE(', [LOCATION, DIVISOR], ');',
            BINDING, '.divisor=', DIVISOR, ';}')
        }
      }

      function emitConstant () {
        scope(
          'if(', BINDING, '.buffer){',
          GL, '.disableVertexAttribArray(', LOCATION, ');',
          BINDING, '.buffer=null;',
          '}if(', CUTE_COMPONENTS.map(function (c, i) {
            return BINDING + '.' + c + '!==' + CONST_COMPONENTS[i]
          }).join('||'), '){',
          GL, '.vertexAttrib4f(', LOCATION, ',', CONST_COMPONENTS, ');',
          CUTE_COMPONENTS.map(function (c, i) {
            return BINDING + '.' + c + '=' + CONST_COMPONENTS[i] + ';'
          }).join(''),
          '}')
      }

      if (STATE === ATTRIB_STATE_POINTER) {
        emitBuffer()
      } else if (STATE === ATTRIB_STATE_CONSTANT) {
        emitConstant()
      } else {
        scope('if(', STATE, '===', ATTRIB_STATE_POINTER, '){')
        emitBuffer()
        scope('}else{')
        emitConstant()
        scope('}')
      }
    }

    attributes.forEach(function (attribute) {
      var name = attribute.name
      var arg = args.attributes[name]
      var record
      if (arg) {
        if (!filter(arg)) {
          return
        }
        record = arg.append(env, scope)
      } else {
        if (!filter(SCOPE_DECL)) {
          return
        }
        var scopeAttrib = env.scopeAttrib(name)
        check$1.optional(function () {
          env.assert(scope,
            scopeAttrib + '.state',
            'missing attribute ' + name)
        })
        record = {}
        Object.keys(new AttributeRecord()).forEach(function (key) {
          record[key] = scope.def(scopeAttrib, '.', key)
        })
      }
      emitBindAttribute(
        env.link(attribute), typeLength(attribute.info.type), record)
    })
  }

  function emitUniforms (env, scope, args, uniforms, filter, isBatchInnerLoop) {
    var shared = env.shared
    var GL = shared.gl

    var definedArrUniforms = {}
    var infix
    for (var i = 0; i < uniforms.length; ++i) {
      var uniform = uniforms[i]
      var name = uniform.name
      var type = uniform.info.type
      var size = uniform.info.size
      var arg = args.uniforms[name]
      if (size > 1) {
        // either foo[n] or foos, avoid define both
        if (!arg) {
          continue
        }
        var arrUniformName = name.replace('[0]', '')
        if (definedArrUniforms[arrUniformName]) {
          continue
        }
        definedArrUniforms[arrUniformName] = 1
      }
      var UNIFORM = env.link(uniform)
      var LOCATION = UNIFORM + '.location'

      var VALUE
      if (arg) {
        if (!filter(arg)) {
          continue
        }
        if (isStatic(arg)) {
          var value = arg.value
          check$1.command(
            value !== null && typeof value !== 'undefined',
            'missing uniform "' + name + '"', env.commandStr)
          if (type === GL_SAMPLER_2D || type === GL_SAMPLER_CUBE) {
            check$1.command(
              typeof value === 'function' &&
              ((type === GL_SAMPLER_2D &&
                (value._reglType === 'texture2d' ||
                value._reglType === 'framebuffer')) ||
              (type === GL_SAMPLER_CUBE &&
                (value._reglType === 'textureCube' ||
                value._reglType === 'framebufferCube'))),
              'invalid texture for uniform ' + name, env.commandStr)
            var TEX_VALUE = env.link(value._texture || value.color[0]._texture)
            scope(GL, '.uniform1i(', LOCATION, ',', TEX_VALUE + '.bind());')
            scope.exit(TEX_VALUE, '.unbind();')
          } else if (
            type === GL_FLOAT_MAT2 ||
            type === GL_FLOAT_MAT3 ||
            type === GL_FLOAT_MAT4) {
            check$1.optional(function () {
              check$1.command(isArrayLike(value),
                'invalid matrix for uniform ' + name, env.commandStr)
              check$1.command(
                (type === GL_FLOAT_MAT2 && value.length === 4) ||
                (type === GL_FLOAT_MAT3 && value.length === 9) ||
                (type === GL_FLOAT_MAT4 && value.length === 16),
                'invalid length for matrix uniform ' + name, env.commandStr)
            })
            var MAT_VALUE = env.global.def('new Float32Array([' +
              Array.prototype.slice.call(value) + '])')
            var dim = 2
            if (type === GL_FLOAT_MAT3) {
              dim = 3
            } else if (type === GL_FLOAT_MAT4) {
              dim = 4
            }
            scope(
              GL, '.uniformMatrix', dim, 'fv(',
              LOCATION, ',false,', MAT_VALUE, ');')
          } else {
            switch (type) {
              case GL_FLOAT$8:
                if (size === 1) {
                  check$1.commandType(value, 'number', 'uniform ' + name, env.commandStr)
                } else {
                  check$1.command(
                    isArrayLike(value) && (value.length === size),
                    'uniform ' + name, env.commandStr)
                }
                infix = '1f'
                break
              case GL_FLOAT_VEC2:
                check$1.command(
                  isArrayLike(value) && (value.length && value.length % 2 === 0 && value.length <= size * 2),
                  'uniform ' + name, env.commandStr)
                infix = '2f'
                break
              case GL_FLOAT_VEC3:
                check$1.command(
                  isArrayLike(value) && (value.length && value.length % 3 === 0 && value.length <= size * 3),
                  'uniform ' + name, env.commandStr)
                infix = '3f'
                break
              case GL_FLOAT_VEC4:
                check$1.command(
                  isArrayLike(value) && (value.length && value.length % 4 === 0 && value.length <= size * 4),
                  'uniform ' + name, env.commandStr)
                infix = '4f'
                break
              case GL_BOOL:
                if (size === 1) {
                  check$1.commandType(value, 'boolean', 'uniform ' + name, env.commandStr)
                } else {
                  check$1.command(
                    isArrayLike(value) && (value.length === size),
                    'uniform ' + name, env.commandStr)
                }
                infix = '1i'
                break
              case GL_INT$3:
                if (size === 1) {
                  check$1.commandType(value, 'number', 'uniform ' + name, env.commandStr)
                } else {
                  check$1.command(
                    isArrayLike(value) && (value.length === size),
                    'uniform ' + name, env.commandStr)
                }
                infix = '1i'
                break
              case GL_BOOL_VEC2:
                check$1.command(
                  isArrayLike(value) && (value.length && value.length % 2 === 0 && value.length <= size * 2),
                  'uniform ' + name, env.commandStr)
                infix = '2i'
                break
              case GL_INT_VEC2:
                check$1.command(
                  isArrayLike(value) && (value.length && value.length % 2 === 0 && value.length <= size * 2),
                  'uniform ' + name, env.commandStr)
                infix = '2i'
                break
              case GL_BOOL_VEC3:
                check$1.command(
                  isArrayLike(value) && (value.length && value.length % 3 === 0 && value.length <= size * 3),
                  'uniform ' + name, env.commandStr)
                infix = '3i'
                break
              case GL_INT_VEC3:
                check$1.command(
                  isArrayLike(value) && (value.length && value.length % 3 === 0 && value.length <= size * 3),
                  'uniform ' + name, env.commandStr)
                infix = '3i'
                break
              case GL_BOOL_VEC4:
                check$1.command(
                  isArrayLike(value) && (value.length && value.length % 4 === 0 && value.length <= size * 4),
                  'uniform ' + name, env.commandStr)
                infix = '4i'
                break
              case GL_INT_VEC4:
                check$1.command(
                  isArrayLike(value) && (value.length && value.length % 4 === 0 && value.length <= size * 4),
                  'uniform ' + name, env.commandStr)
                infix = '4i'
                break
            }
            if (size > 1) {
              infix += 'v'
              value = env.global.def('[' +
              Array.prototype.slice.call(value) + ']')
            } else {
              value = isArrayLike(value) ? Array.prototype.slice.call(value) : value
            }
            scope(GL, '.uniform', infix, '(', LOCATION, ',',
              value,
              ');')
          }
          continue
        } else {
          VALUE = arg.append(env, scope)
        }
      } else {
        if (!filter(SCOPE_DECL)) {
          continue
        }
        VALUE = scope.def(shared.uniforms, '[', stringStore.id(name), ']')
      }

      if (type === GL_SAMPLER_2D) {
        check$1(!Array.isArray(VALUE), 'must specify a scalar prop for textures')
        scope(
          'if(', VALUE, '&&', VALUE, '._reglType==="framebuffer"){',
          VALUE, '=', VALUE, '.color[0];',
          '}')
      } else if (type === GL_SAMPLER_CUBE) {
        check$1(!Array.isArray(VALUE), 'must specify a scalar prop for cube maps')
        scope(
          'if(', VALUE, '&&', VALUE, '._reglType==="framebufferCube"){',
          VALUE, '=', VALUE, '.color[0];',
          '}')
      }

      // perform type validation
      check$1.optional(function () {
        function emitCheck (pred, message) {
          env.assert(scope, pred,
            'bad data or missing for uniform "' + name + '".  ' + message)
        }

        function checkType (type, size) {
          if (size === 1) {
            check$1(!Array.isArray(VALUE), 'must not specify an array type for uniform')
          }
          emitCheck(
            'Array.isArray(' + VALUE + ') && typeof ' + VALUE + '[0]===" ' + type + '"' +
            ' || typeof ' + VALUE + '==="' + type + '"',
            'invalid type, expected ' + type)
        }

        function checkVector (n, type, size) {
          if (Array.isArray(VALUE)) {
            check$1(VALUE.length && VALUE.length % n === 0 && VALUE.length <= n * size, 'must have length of ' + (size === 1 ? '' : 'n * ') + n)
          } else {
            emitCheck(
              shared.isArrayLike + '(' + VALUE + ')&&' + VALUE + '.length && ' + VALUE + '.length % ' + n + ' === 0' +
              ' && ' + VALUE + '.length<=' + n * size,
              'invalid vector, should have length of ' + (size === 1 ? '' : 'n * ') + n, env.commandStr)
          }
        }

        function checkTexture (target) {
          check$1(!Array.isArray(VALUE), 'must not specify a value type')
          emitCheck(
            'typeof ' + VALUE + '==="function"&&' +
            VALUE + '._reglType==="texture' +
            (target === GL_TEXTURE_2D$3 ? '2d' : 'Cube') + '"',
            'invalid texture type', env.commandStr)
        }

        switch (type) {
          case GL_INT$3:
            checkType('number', size)
            break
          case GL_INT_VEC2:
            checkVector(2, 'number', size)
            break
          case GL_INT_VEC3:
            checkVector(3, 'number', size)
            break
          case GL_INT_VEC4:
            checkVector(4, 'number', size)
            break
          case GL_FLOAT$8:
            checkType('number', size)
            break
          case GL_FLOAT_VEC2:
            checkVector(2, 'number', size)
            break
          case GL_FLOAT_VEC3:
            checkVector(3, 'number', size)
            break
          case GL_FLOAT_VEC4:
            checkVector(4, 'number', size)
            break
          case GL_BOOL:
            checkType('boolean', size)
            break
          case GL_BOOL_VEC2:
            checkVector(2, 'boolean', size)
            break
          case GL_BOOL_VEC3:
            checkVector(3, 'boolean', size)
            break
          case GL_BOOL_VEC4:
            checkVector(4, 'boolean', size)
            break
          case GL_FLOAT_MAT2:
            checkVector(4, 'number', size)
            break
          case GL_FLOAT_MAT3:
            checkVector(9, 'number', size)
            break
          case GL_FLOAT_MAT4:
            checkVector(16, 'number', size)
            break
          case GL_SAMPLER_2D:
            checkTexture(GL_TEXTURE_2D$3)
            break
          case GL_SAMPLER_CUBE:
            checkTexture(GL_TEXTURE_CUBE_MAP$2)
            break
        }
      })

      var unroll = 1
      switch (type) {
        case GL_SAMPLER_2D:
        case GL_SAMPLER_CUBE:
          var TEX = scope.def(VALUE, '._texture')
          scope(GL, '.uniform1i(', LOCATION, ',', TEX, '.bind());')
          scope.exit(TEX, '.unbind();')
          continue

        case GL_INT$3:
        case GL_BOOL:
          infix = '1i'
          break

        case GL_INT_VEC2:
        case GL_BOOL_VEC2:
          infix = '2i'
          unroll = 2
          break

        case GL_INT_VEC3:
        case GL_BOOL_VEC3:
          infix = '3i'
          unroll = 3
          break

        case GL_INT_VEC4:
        case GL_BOOL_VEC4:
          infix = '4i'
          unroll = 4
          break

        case GL_FLOAT$8:
          infix = '1f'
          break

        case GL_FLOAT_VEC2:
          infix = '2f'
          unroll = 2
          break

        case GL_FLOAT_VEC3:
          infix = '3f'
          unroll = 3
          break

        case GL_FLOAT_VEC4:
          infix = '4f'
          unroll = 4
          break

        case GL_FLOAT_MAT2:
          infix = 'Matrix2fv'
          break

        case GL_FLOAT_MAT3:
          infix = 'Matrix3fv'
          break

        case GL_FLOAT_MAT4:
          infix = 'Matrix4fv'
          break
      }

      if (infix.indexOf('Matrix') === -1 && size > 1) {
        infix += 'v'
        unroll = 1
      }

      if (infix.charAt(0) === 'M') {
        scope(GL, '.uniform', infix, '(', LOCATION, ',')
        var matSize = Math.pow(type - GL_FLOAT_MAT2 + 2, 2)
        var STORAGE = env.global.def('new Float32Array(', matSize, ')')
        if (Array.isArray(VALUE)) {
          scope(
            'false,(',
            loop(matSize, function (i) {
              return STORAGE + '[' + i + ']=' + VALUE[i]
            }), ',', STORAGE, ')')
        } else {
          scope(
            'false,(Array.isArray(', VALUE, ')||', VALUE, ' instanceof Float32Array)?', VALUE, ':(',
            loop(matSize, function (i) {
              return STORAGE + '[' + i + ']=' + VALUE + '[' + i + ']'
            }), ',', STORAGE, ')')
        }
        scope(');')
      } else if (unroll > 1) {
        var prev = []
        var cur = []
        for (var j = 0; j < unroll; ++j) {
          if (Array.isArray(VALUE)) {
            cur.push(VALUE[j])
          } else {
            cur.push(scope.def(VALUE + '[' + j + ']'))
          }
          if (isBatchInnerLoop) {
            prev.push(scope.def())
          }
        }
        if (isBatchInnerLoop) {
          scope('if(!', env.batchId, '||', prev.map(function (p, i) {
            return p + '!==' + cur[i]
          }).join('||'), '){', prev.map(function (p, i) {
            return p + '=' + cur[i] + ';'
          }).join(''))
        }
        scope(GL, '.uniform', infix, '(', LOCATION, ',', cur.join(','), ');')
        if (isBatchInnerLoop) {
          scope('}')
        }
      } else {
        check$1(!Array.isArray(VALUE), 'uniform value must not be an array')
        if (isBatchInnerLoop) {
          var prevS = scope.def()
          scope('if(!', env.batchId, '||', prevS, '!==', VALUE, '){',
            prevS, '=', VALUE, ';')
        }
        scope(GL, '.uniform', infix, '(', LOCATION, ',', VALUE, ');')
        if (isBatchInnerLoop) {
          scope('}')
        }
      }
    }
  }

  function emitDraw (env, outer, inner, args) {
    var shared = env.shared
    var GL = shared.gl
    var DRAW_STATE = shared.draw

    var drawOptions = args.draw

    function emitElements () {
      var defn = drawOptions.elements
      var ELEMENTS
      var scope = outer
      if (defn) {
        if ((defn.contextDep && args.contextDynamic) || defn.propDep) {
          scope = inner
        }
        ELEMENTS = defn.append(env, scope)
        if (drawOptions.elementsActive) {
          scope(
            'if(' + ELEMENTS + ')' +
            GL + '.bindBuffer(' + GL_ELEMENT_ARRAY_BUFFER$2 + ',' + ELEMENTS + '.buffer.buffer);')
        }
      } else {
        ELEMENTS = scope.def()
        scope(
          ELEMENTS, '=', DRAW_STATE, '.', S_ELEMENTS, ';',
          'if(', ELEMENTS, '){',
          GL, '.bindBuffer(', GL_ELEMENT_ARRAY_BUFFER$2, ',', ELEMENTS, '.buffer.buffer);}',
          'else if(', shared.vao, '.currentVAO){',
          ELEMENTS, '=', env.shared.elements + '.getElements(' + shared.vao, '.currentVAO.elements);',
          (!extVertexArrays ? 'if(' + ELEMENTS + ')' + GL + '.bindBuffer(' + GL_ELEMENT_ARRAY_BUFFER$2 + ',' + ELEMENTS + '.buffer.buffer);' : ''),
          '}')
      }
      return ELEMENTS
    }

    function emitCount () {
      var defn = drawOptions.count
      var COUNT
      var scope = outer
      if (defn) {
        if ((defn.contextDep && args.contextDynamic) || defn.propDep) {
          scope = inner
        }
        COUNT = defn.append(env, scope)
        check$1.optional(function () {
          if (defn.MISSING) {
            env.assert(outer, 'false', 'missing vertex count')
          }
          if (defn.DYNAMIC) {
            env.assert(scope, COUNT + '>=0', 'missing vertex count')
          }
        })
      } else {
        COUNT = scope.def(DRAW_STATE, '.', S_COUNT)
        check$1.optional(function () {
          env.assert(scope, COUNT + '>=0', 'missing vertex count')
        })
      }
      return COUNT
    }

    var ELEMENTS = emitElements()
    function emitValue (name) {
      var defn = drawOptions[name]
      if (defn) {
        if ((defn.contextDep && args.contextDynamic) || defn.propDep) {
          return defn.append(env, inner)
        } else {
          return defn.append(env, outer)
        }
      } else {
        return outer.def(DRAW_STATE, '.', name)
      }
    }

    var PRIMITIVE = emitValue(S_PRIMITIVE)
    var OFFSET = emitValue(S_OFFSET)

    var COUNT = emitCount()
    if (typeof COUNT === 'number') {
      if (COUNT === 0) {
        return
      }
    } else {
      inner('if(', COUNT, '){')
      inner.exit('}')
    }

    var INSTANCES, EXT_INSTANCING
    if (extInstancing) {
      INSTANCES = emitValue(S_INSTANCES)
      EXT_INSTANCING = env.instancing
    }

    var ELEMENT_TYPE = ELEMENTS + '.type'

    var elementsStatic = drawOptions.elements && isStatic(drawOptions.elements) && !drawOptions.vaoActive

    function emitInstancing () {
      function drawElements () {
        inner(EXT_INSTANCING, '.drawElementsInstancedANGLE(', [
          PRIMITIVE,
          COUNT,
          ELEMENT_TYPE,
          OFFSET + '<<((' + ELEMENT_TYPE + '-' + GL_UNSIGNED_BYTE$8 + ')>>1)',
          INSTANCES
        ], ');')
      }

      function drawArrays () {
        inner(EXT_INSTANCING, '.drawArraysInstancedANGLE(',
          [PRIMITIVE, OFFSET, COUNT, INSTANCES], ');')
      }

      if (ELEMENTS && ELEMENTS !== 'null') {
        if (!elementsStatic) {
          inner('if(', ELEMENTS, '){')
          drawElements()
          inner('}else{')
          drawArrays()
          inner('}')
        } else {
          drawElements()
        }
      } else {
        drawArrays()
      }
    }

    function emitRegular () {
      function drawElements () {
        inner(GL + '.drawElements(' + [
          PRIMITIVE,
          COUNT,
          ELEMENT_TYPE,
          OFFSET + '<<((' + ELEMENT_TYPE + '-' + GL_UNSIGNED_BYTE$8 + ')>>1)'
        ] + ');')
      }

      function drawArrays () {
        inner(GL + '.drawArrays(' + [PRIMITIVE, OFFSET, COUNT] + ');')
      }

      if (ELEMENTS && ELEMENTS !== 'null') {
        if (!elementsStatic) {
          inner('if(', ELEMENTS, '){')
          drawElements()
          inner('}else{')
          drawArrays()
          inner('}')
        } else {
          drawElements()
        }
      } else {
        drawArrays()
      }
    }

    if (extInstancing && (typeof INSTANCES !== 'number' || INSTANCES >= 0)) {
      if (typeof INSTANCES === 'string') {
        inner('if(', INSTANCES, '>0){')
        emitInstancing()
        inner('}else if(', INSTANCES, '<0){')
        emitRegular()
        inner('}')
      } else {
        emitInstancing()
      }
    } else {
      emitRegular()
    }
  }

  function createBody (emitBody, parentEnv, args, program, count) {
    var env = createREGLEnvironment()
    var scope = env.proc('body', count)
    check$1.optional(function () {
      env.commandStr = parentEnv.commandStr
      env.command = env.link(parentEnv.commandStr)
    })
    if (extInstancing) {
      env.instancing = scope.def(
        env.shared.extensions, '.angle_instanced_arrays')
    }
    emitBody(env, scope, args, program)
    return env.compile().body
  }

  // ===================================================
  // ===================================================
  // DRAW PROC
  // ===================================================
  // ===================================================
  function emitDrawBody (env, draw, args, program) {
    injectExtensions(env, draw)
    if (args.useVAO) {
      if (args.drawVAO) {
        draw(env.shared.vao, '.setVAO(', args.drawVAO.append(env, draw), ');')
      } else {
        draw(env.shared.vao, '.setVAO(', env.shared.vao, '.targetVAO);')
      }
    } else {
      draw(env.shared.vao, '.setVAO(null);')
      emitAttributes(env, draw, args, program.attributes, function () {
        return true
      })
    }
    emitUniforms(env, draw, args, program.uniforms, function () {
      return true
    }, false)
    emitDraw(env, draw, draw, args)
  }

  function emitDrawProc (env, args) {
    var draw = env.proc('draw', 1)

    injectExtensions(env, draw)

    emitContext(env, draw, args.context)
    emitPollFramebuffer(env, draw, args.framebuffer)

    emitPollState(env, draw, args)
    emitSetOptions(env, draw, args.state)

    emitProfile(env, draw, args, false, true)

    var program = args.shader.progVar.append(env, draw)
    draw(env.shared.gl, '.useProgram(', program, '.program);')

    if (args.shader.program) {
      emitDrawBody(env, draw, args, args.shader.program)
    } else {
      draw(env.shared.vao, '.setVAO(null);')
      var drawCache = env.global.def('{}')
      var PROG_ID = draw.def(program, '.id')
      var CACHED_PROC = draw.def(drawCache, '[', PROG_ID, ']')
      draw(
        env.cond(CACHED_PROC)
          .then(CACHED_PROC, '.call(this,a0);')
          .else(
            CACHED_PROC, '=', drawCache, '[', PROG_ID, ']=',
            env.link(function (program) {
              return createBody(emitDrawBody, env, args, program, 1)
            }), '(', program, ');',
            CACHED_PROC, '.call(this,a0);'))
    }

    if (Object.keys(args.state).length > 0) {
      draw(env.shared.current, '.dirty=true;')
    }
    if (env.shared.vao) {
      draw(env.shared.vao, '.setVAO(null);')
    }
  }

  // ===================================================
  // ===================================================
  // BATCH PROC
  // ===================================================
  // ===================================================

  function emitBatchDynamicShaderBody (env, scope, args, program) {
    env.batchId = 'a1'

    injectExtensions(env, scope)

    function all () {
      return true
    }

    emitAttributes(env, scope, args, program.attributes, all)
    emitUniforms(env, scope, args, program.uniforms, all, false)
    emitDraw(env, scope, scope, args)
  }

  function emitBatchBody (env, scope, args, program) {
    injectExtensions(env, scope)

    var contextDynamic = args.contextDep

    var BATCH_ID = scope.def()
    var PROP_LIST = 'a0'
    var NUM_PROPS = 'a1'
    var PROPS = scope.def()
    env.shared.props = PROPS
    env.batchId = BATCH_ID

    var outer = env.scope()
    var inner = env.scope()

    scope(
      outer.entry,
      'for(', BATCH_ID, '=0;', BATCH_ID, '<', NUM_PROPS, ';++', BATCH_ID, '){',
      PROPS, '=', PROP_LIST, '[', BATCH_ID, '];',
      inner,
      '}',
      outer.exit)

    function isInnerDefn (defn) {
      return ((defn.contextDep && contextDynamic) || defn.propDep)
    }

    function isOuterDefn (defn) {
      return !isInnerDefn(defn)
    }

    if (args.needsContext) {
      emitContext(env, inner, args.context)
    }
    if (args.needsFramebuffer) {
      emitPollFramebuffer(env, inner, args.framebuffer)
    }
    emitSetOptions(env, inner, args.state, isInnerDefn)

    if (args.profile && isInnerDefn(args.profile)) {
      emitProfile(env, inner, args, false, true)
    }

    if (!program) {
      var progCache = env.global.def('{}')
      var PROGRAM = args.shader.progVar.append(env, inner)
      var PROG_ID = inner.def(PROGRAM, '.id')
      var CACHED_PROC = inner.def(progCache, '[', PROG_ID, ']')
      inner(
        env.shared.gl, '.useProgram(', PROGRAM, '.program);',
        'if(!', CACHED_PROC, '){',
        CACHED_PROC, '=', progCache, '[', PROG_ID, ']=',
        env.link(function (program) {
          return createBody(
            emitBatchDynamicShaderBody, env, args, program, 2)
        }), '(', PROGRAM, ');}',
        CACHED_PROC, '.call(this,a0[', BATCH_ID, '],', BATCH_ID, ');')
    } else {
      if (args.useVAO) {
        if (args.drawVAO) {
          if (isInnerDefn(args.drawVAO)) {
            // vao is a prop
            inner(env.shared.vao, '.setVAO(', args.drawVAO.append(env, inner), ');')
          } else {
            // vao is invariant
            outer(env.shared.vao, '.setVAO(', args.drawVAO.append(env, outer), ');')
          }
        } else {
          // scoped vao binding
          outer(env.shared.vao, '.setVAO(', env.shared.vao, '.targetVAO);')
        }
      } else {
        outer(env.shared.vao, '.setVAO(null);')
        emitAttributes(env, outer, args, program.attributes, isOuterDefn)
        emitAttributes(env, inner, args, program.attributes, isInnerDefn)
      }
      emitUniforms(env, outer, args, program.uniforms, isOuterDefn, false)
      emitUniforms(env, inner, args, program.uniforms, isInnerDefn, true)
      emitDraw(env, outer, inner, args)
    }
  }

  function emitBatchProc (env, args) {
    var batch = env.proc('batch', 2)
    env.batchId = '0'

    injectExtensions(env, batch)

    // Check if any context variables depend on props
    var contextDynamic = false
    var needsContext = true
    Object.keys(args.context).forEach(function (name) {
      contextDynamic = contextDynamic || args.context[name].propDep
    })
    if (!contextDynamic) {
      emitContext(env, batch, args.context)
      needsContext = false
    }

    // framebuffer state affects framebufferWidth/height context vars
    var framebuffer = args.framebuffer
    var needsFramebuffer = false
    if (framebuffer) {
      if (framebuffer.propDep) {
        contextDynamic = needsFramebuffer = true
      } else if (framebuffer.contextDep && contextDynamic) {
        needsFramebuffer = true
      }
      if (!needsFramebuffer) {
        emitPollFramebuffer(env, batch, framebuffer)
      }
    } else {
      emitPollFramebuffer(env, batch, null)
    }

    // viewport is weird because it can affect context vars
    if (args.state.viewport && args.state.viewport.propDep) {
      contextDynamic = true
    }

    function isInnerDefn (defn) {
      return (defn.contextDep && contextDynamic) || defn.propDep
    }

    // set webgl options
    emitPollState(env, batch, args)
    emitSetOptions(env, batch, args.state, function (defn) {
      return !isInnerDefn(defn)
    })

    if (!args.profile || !isInnerDefn(args.profile)) {
      emitProfile(env, batch, args, false, 'a1')
    }

    // Save these values to args so that the batch body routine can use them
    args.contextDep = contextDynamic
    args.needsContext = needsContext
    args.needsFramebuffer = needsFramebuffer

    // determine if shader is dynamic
    var progDefn = args.shader.progVar
    if ((progDefn.contextDep && contextDynamic) || progDefn.propDep) {
      emitBatchBody(
        env,
        batch,
        args,
        null)
    } else {
      var PROGRAM = progDefn.append(env, batch)
      batch(env.shared.gl, '.useProgram(', PROGRAM, '.program);')
      if (args.shader.program) {
        emitBatchBody(
          env,
          batch,
          args,
          args.shader.program)
      } else {
        batch(env.shared.vao, '.setVAO(null);')
        var batchCache = env.global.def('{}')
        var PROG_ID = batch.def(PROGRAM, '.id')
        var CACHED_PROC = batch.def(batchCache, '[', PROG_ID, ']')
        batch(
          env.cond(CACHED_PROC)
            .then(CACHED_PROC, '.call(this,a0,a1);')
            .else(
              CACHED_PROC, '=', batchCache, '[', PROG_ID, ']=',
              env.link(function (program) {
                return createBody(emitBatchBody, env, args, program, 2)
              }), '(', PROGRAM, ');',
              CACHED_PROC, '.call(this,a0,a1);'))
      }
    }

    if (Object.keys(args.state).length > 0) {
      batch(env.shared.current, '.dirty=true;')
    }

    if (env.shared.vao) {
      batch(env.shared.vao, '.setVAO(null);')
    }
  }

  // ===================================================
  // ===================================================
  // SCOPE COMMAND
  // ===================================================
  // ===================================================
  function emitScopeProc (env, args) {
    var scope = env.proc('scope', 3)
    env.batchId = 'a2'

    var shared = env.shared
    var CURRENT_STATE = shared.current

    emitContext(env, scope, args.context)

    if (args.framebuffer) {
      args.framebuffer.append(env, scope)
    }

    sortState(Object.keys(args.state)).forEach(function (name) {
      var defn = args.state[name]
      var value = defn.append(env, scope)
      if (isArrayLike(value)) {
        value.forEach(function (v, i) {
          scope.set(env.next[name], '[' + i + ']', v)
        })
      } else {
        scope.set(shared.next, '.' + name, value)
      }
    })

    emitProfile(env, scope, args, true, true)

    ;[S_ELEMENTS, S_OFFSET, S_COUNT, S_INSTANCES, S_PRIMITIVE].forEach(
      function (opt) {
        var variable = args.draw[opt]
        if (!variable) {
          return
        }
        scope.set(shared.draw, '.' + opt, '' + variable.append(env, scope))
      })

    Object.keys(args.uniforms).forEach(function (opt) {
      var value = args.uniforms[opt].append(env, scope)
      if (Array.isArray(value)) {
        value = '[' + value.join() + ']'
      }
      scope.set(
        shared.uniforms,
        '[' + stringStore.id(opt) + ']',
        value)
    })

    Object.keys(args.attributes).forEach(function (name) {
      var record = args.attributes[name].append(env, scope)
      var scopeAttrib = env.scopeAttrib(name)
      Object.keys(new AttributeRecord()).forEach(function (prop) {
        scope.set(scopeAttrib, '.' + prop, record[prop])
      })
    })

    if (args.scopeVAO) {
      scope.set(shared.vao, '.targetVAO', args.scopeVAO.append(env, scope))
    }

    function saveShader (name) {
      var shader = args.shader[name]
      if (shader) {
        scope.set(shared.shader, '.' + name, shader.append(env, scope))
      }
    }
    saveShader(S_VERT)
    saveShader(S_FRAG)

    if (Object.keys(args.state).length > 0) {
      scope(CURRENT_STATE, '.dirty=true;')
      scope.exit(CURRENT_STATE, '.dirty=true;')
    }

    scope('a1(', env.shared.context, ',a0,', env.batchId, ');')
  }

  function isDynamicObject (object) {
    if (typeof object !== 'object' || isArrayLike(object)) {
      return
    }
    var props = Object.keys(object)
    for (var i = 0; i < props.length; ++i) {
      if (dynamic.isDynamic(object[props[i]])) {
        return true
      }
    }
    return false
  }

  function splatObject (env, options, name) {
    var object = options.static[name]
    if (!object || !isDynamicObject(object)) {
      return
    }

    var globals = env.global
    var keys = Object.keys(object)
    var thisDep = false
    var contextDep = false
    var propDep = false
    var objectRef = env.global.def('{}')
    keys.forEach(function (key) {
      var value = object[key]
      if (dynamic.isDynamic(value)) {
        if (typeof value === 'function') {
          value = object[key] = dynamic.unbox(value)
        }
        var deps = createDynamicDecl(value, null)
        thisDep = thisDep || deps.thisDep
        propDep = propDep || deps.propDep
        contextDep = contextDep || deps.contextDep
      } else {
        globals(objectRef, '.', key, '=')
        switch (typeof value) {
          case 'number':
            globals(value)
            break
          case 'string':
            globals('"', value, '"')
            break
          case 'object':
            if (Array.isArray(value)) {
              globals('[', value.join(), ']')
            }
            break
          default:
            globals(env.link(value))
            break
        }
        globals(';')
      }
    })

    function appendBlock (env, block) {
      keys.forEach(function (key) {
        var value = object[key]
        if (!dynamic.isDynamic(value)) {
          return
        }
        var ref = env.invoke(block, value)
        block(objectRef, '.', key, '=', ref, ';')
      })
    }

    options.dynamic[name] = new dynamic.DynamicVariable(DYN_THUNK, {
      thisDep: thisDep,
      contextDep: contextDep,
      propDep: propDep,
      ref: objectRef,
      append: appendBlock
    })
    delete options.static[name]
  }

  // ===========================================================================
  // ===========================================================================
  // MAIN DRAW COMMAND
  // ===========================================================================
  // ===========================================================================
  function compileCommand (options, attributes, uniforms, context, stats) {
    var env = createREGLEnvironment()

    // link stats, so that we can easily access it in the program.
    env.stats = env.link(stats)

    // splat options and attributes to allow for dynamic nested properties
    Object.keys(attributes.static).forEach(function (key) {
      splatObject(env, attributes, key)
    })
    NESTED_OPTIONS.forEach(function (name) {
      splatObject(env, options, name)
    })

    var args = parseArguments(options, attributes, uniforms, context, env)

    emitDrawProc(env, args)
    emitScopeProc(env, args)
    emitBatchProc(env, args)

    return extend(env.compile(), {
      destroy: function () {
        args.shader.program.destroy()
      }
    })
  }

  // ===========================================================================
  // ===========================================================================
  // POLL / REFRESH
  // ===========================================================================
  // ===========================================================================
  return {
    next: nextState,
    current: currentState,
    procs: (function () {
      var env = createREGLEnvironment()
      var poll = env.proc('poll')
      var refresh = env.proc('refresh')
      var common = env.block()
      poll(common)
      refresh(common)

      var shared = env.shared
      var GL = shared.gl
      var NEXT_STATE = shared.next
      var CURRENT_STATE = shared.current

      common(CURRENT_STATE, '.dirty=false;')

      emitPollFramebuffer(env, poll)
      emitPollFramebuffer(env, refresh, null, true)

      // Refresh updates all attribute state changes
      var INSTANCING
      if (extInstancing) {
        INSTANCING = env.link(extInstancing)
      }

      // update vertex array bindings
      if (extensions.oes_vertex_array_object) {
        refresh(env.link(extensions.oes_vertex_array_object), '.bindVertexArrayOES(null);')
      }
      for (var i = 0; i < limits.maxAttributes; ++i) {
        var BINDING = refresh.def(shared.attributes, '[', i, ']')
        var ifte = env.cond(BINDING, '.buffer')
        ifte.then(
          GL, '.enableVertexAttribArray(', i, ');',
          GL, '.bindBuffer(',
          GL_ARRAY_BUFFER$2, ',',
          BINDING, '.buffer.buffer);',
          GL, '.vertexAttribPointer(',
          i, ',',
          BINDING, '.size,',
          BINDING, '.type,',
          BINDING, '.normalized,',
          BINDING, '.stride,',
          BINDING, '.offset);'
        ).else(
          GL, '.disableVertexAttribArray(', i, ');',
          GL, '.vertexAttrib4f(',
          i, ',',
          BINDING, '.x,',
          BINDING, '.y,',
          BINDING, '.z,',
          BINDING, '.w);',
          BINDING, '.buffer=null;')
        refresh(ifte)
        if (extInstancing) {
          refresh(
            INSTANCING, '.vertexAttribDivisorANGLE(',
            i, ',',
            BINDING, '.divisor);')
        }
      }
      refresh(
        env.shared.vao, '.currentVAO=null;',
        env.shared.vao, '.setVAO(', env.shared.vao, '.targetVAO);')

      Object.keys(GL_FLAGS).forEach(function (flag) {
        var cap = GL_FLAGS[flag]
        var NEXT = common.def(NEXT_STATE, '.', flag)
        var block = env.block()
        block('if(', NEXT, '){',
          GL, '.enable(', cap, ')}else{',
          GL, '.disable(', cap, ')}',
          CURRENT_STATE, '.', flag, '=', NEXT, ';')
        refresh(block)
        poll(
          'if(', NEXT, '!==', CURRENT_STATE, '.', flag, '){',
          block,
          '}')
      })

      Object.keys(GL_VARIABLES).forEach(function (name) {
        var func = GL_VARIABLES[name]
        var init = currentState[name]
        var NEXT, CURRENT
        var block = env.block()
        block(GL, '.', func, '(')
        if (isArrayLike(init)) {
          var n = init.length
          NEXT = env.global.def(NEXT_STATE, '.', name)
          CURRENT = env.global.def(CURRENT_STATE, '.', name)
          block(
            loop(n, function (i) {
              return NEXT + '[' + i + ']'
            }), ');',
            loop(n, function (i) {
              return CURRENT + '[' + i + ']=' + NEXT + '[' + i + '];'
            }).join(''))
          poll(
            'if(', loop(n, function (i) {
              return NEXT + '[' + i + ']!==' + CURRENT + '[' + i + ']'
            }).join('||'), '){',
            block,
            '}')
        } else {
          NEXT = common.def(NEXT_STATE, '.', name)
          CURRENT = common.def(CURRENT_STATE, '.', name)
          block(
            NEXT, ');',
            CURRENT_STATE, '.', name, '=', NEXT, ';')
          poll(
            'if(', NEXT, '!==', CURRENT, '){',
            block,
            '}')
        }
        refresh(block)
      })

      return env.compile()
    })(),
    compile: compileCommand
  }
}

function stats () {
  return {
    vaoCount: 0,
    bufferCount: 0,
    elementsCount: 0,
    framebufferCount: 0,
    shaderCount: 0,
    textureCount: 0,
    cubeCount: 0,
    renderbufferCount: 0,
    maxTextureUnits: 0
  }
}

var GL_QUERY_RESULT_EXT = 0x8866
var GL_QUERY_RESULT_AVAILABLE_EXT = 0x8867
var GL_TIME_ELAPSED_EXT = 0x88BF

var createTimer = function (gl, extensions) {
  if (!extensions.ext_disjoint_timer_query) {
    return null
  }

  // QUERY POOL BEGIN
  var queryPool = []
  function allocQuery () {
    return queryPool.pop() || extensions.ext_disjoint_timer_query.createQueryEXT()
  }
  function freeQuery (query) {
    queryPool.push(query)
  }
  // QUERY POOL END

  var pendingQueries = []
  function beginQuery (stats) {
    var query = allocQuery()
    extensions.ext_disjoint_timer_query.beginQueryEXT(GL_TIME_ELAPSED_EXT, query)
    pendingQueries.push(query)
    pushScopeStats(pendingQueries.length - 1, pendingQueries.length, stats)
  }

  function endQuery () {
    extensions.ext_disjoint_timer_query.endQueryEXT(GL_TIME_ELAPSED_EXT)
  }

  //
  // Pending stats pool.
  //
  function PendingStats () {
    this.startQueryIndex = -1
    this.endQueryIndex = -1
    this.sum = 0
    this.stats = null
  }
  var pendingStatsPool = []
  function allocPendingStats () {
    return pendingStatsPool.pop() || new PendingStats()
  }
  function freePendingStats (pendingStats) {
    pendingStatsPool.push(pendingStats)
  }
  // Pending stats pool end

  var pendingStats = []
  function pushScopeStats (start, end, stats) {
    var ps = allocPendingStats()
    ps.startQueryIndex = start
    ps.endQueryIndex = end
    ps.sum = 0
    ps.stats = stats
    pendingStats.push(ps)
  }

  // we should call this at the beginning of the frame,
  // in order to update gpuTime
  var timeSum = []
  var queryPtr = []
  function update () {
    var ptr, i

    var n = pendingQueries.length
    if (n === 0) {
      return
    }

    // Reserve space
    queryPtr.length = Math.max(queryPtr.length, n + 1)
    timeSum.length = Math.max(timeSum.length, n + 1)
    timeSum[0] = 0
    queryPtr[0] = 0

    // Update all pending timer queries
    var queryTime = 0
    ptr = 0
    for (i = 0; i < pendingQueries.length; ++i) {
      var query = pendingQueries[i]
      if (extensions.ext_disjoint_timer_query.getQueryObjectEXT(query, GL_QUERY_RESULT_AVAILABLE_EXT)) {
        queryTime += extensions.ext_disjoint_timer_query.getQueryObjectEXT(query, GL_QUERY_RESULT_EXT)
        freeQuery(query)
      } else {
        pendingQueries[ptr++] = query
      }
      timeSum[i + 1] = queryTime
      queryPtr[i + 1] = ptr
    }
    pendingQueries.length = ptr

    // Update all pending stat queries
    ptr = 0
    for (i = 0; i < pendingStats.length; ++i) {
      var stats = pendingStats[i]
      var start = stats.startQueryIndex
      var end = stats.endQueryIndex
      stats.sum += timeSum[end] - timeSum[start]
      var startPtr = queryPtr[start]
      var endPtr = queryPtr[end]
      if (endPtr === startPtr) {
        stats.stats.gpuTime += stats.sum / 1e6
        freePendingStats(stats)
      } else {
        stats.startQueryIndex = startPtr
        stats.endQueryIndex = endPtr
        pendingStats[ptr++] = stats
      }
    }
    pendingStats.length = ptr
  }

  return {
    beginQuery: beginQuery,
    endQuery: endQuery,
    pushScopeStats: pushScopeStats,
    update: update,
    getNumPendingQueries: function () {
      return pendingQueries.length
    },
    clear: function () {
      queryPool.push.apply(queryPool, pendingQueries)
      for (var i = 0; i < queryPool.length; i++) {
        extensions.ext_disjoint_timer_query.deleteQueryEXT(queryPool[i])
      }
      pendingQueries.length = 0
      queryPool.length = 0
    },
    restore: function () {
      pendingQueries.length = 0
      queryPool.length = 0
    }
  }
}

var GL_COLOR_BUFFER_BIT = 16384
var GL_DEPTH_BUFFER_BIT = 256
var GL_STENCIL_BUFFER_BIT = 1024

var GL_ARRAY_BUFFER = 34962

var CONTEXT_LOST_EVENT = 'webglcontextlost'
var CONTEXT_RESTORED_EVENT = 'webglcontextrestored'

var DYN_PROP = 1
var DYN_CONTEXT = 2
var DYN_STATE = 3

function find (haystack, needle) {
  for (var i = 0; i < haystack.length; ++i) {
    if (haystack[i] === needle) {
      return i
    }
  }
  return -1
}

function wrapREGL (args) {
  var config = parseArgs(args)
  if (!config) {
    return null
  }

  var gl = config.gl
  var glAttributes = gl.getContextAttributes()
  var contextLost = gl.isContextLost()

  var extensionState = createExtensionCache(gl, config)
  if (!extensionState) {
    return null
  }

  var stringStore = createStringStore()
  var stats$$1 = stats()
  var extensions = extensionState.extensions
  var timer = createTimer(gl, extensions)

  var START_TIME = clock()
  var WIDTH = gl.drawingBufferWidth
  var HEIGHT = gl.drawingBufferHeight

  var contextState = {
    tick: 0,
    time: 0,
    viewportWidth: WIDTH,
    viewportHeight: HEIGHT,
    framebufferWidth: WIDTH,
    framebufferHeight: HEIGHT,
    drawingBufferWidth: WIDTH,
    drawingBufferHeight: HEIGHT,
    pixelRatio: config.pixelRatio
  }
  var uniformState = {}
  var drawState = {
    elements: null,
    primitive: 4, // GL_TRIANGLES
    count: -1,
    offset: 0,
    instances: -1
  }

  var limits = wrapLimits(gl, extensions)
  var bufferState = wrapBufferState(
    gl,
    stats$$1,
    config,
    destroyBuffer)
  var elementState = wrapElementsState(gl, extensions, bufferState, stats$$1)
  var attributeState = wrapAttributeState(
    gl,
    extensions,
    limits,
    stats$$1,
    bufferState,
    elementState,
    drawState)
  function destroyBuffer (buffer) {
    return attributeState.destroyBuffer(buffer)
  }
  var shaderState = wrapShaderState(gl, stringStore, stats$$1, config)
  var textureState = createTextureSet(
    gl,
    extensions,
    limits,
    function () { core.procs.poll() },
    contextState,
    stats$$1,
    config)
  var renderbufferState = wrapRenderbuffers(gl, extensions, limits, stats$$1, config)
  var framebufferState = wrapFBOState(
    gl,
    extensions,
    limits,
    textureState,
    renderbufferState,
    stats$$1)
  var core = reglCore(
    gl,
    stringStore,
    extensions,
    limits,
    bufferState,
    elementState,
    textureState,
    framebufferState,
    uniformState,
    attributeState,
    shaderState,
    drawState,
    contextState,
    timer,
    config)
  var readPixels = wrapReadPixels(
    gl,
    framebufferState,
    core.procs.poll,
    contextState,
    glAttributes, extensions, limits)

  var nextState = core.next
  var canvas = gl.canvas

  var rafCallbacks = []
  var lossCallbacks = []
  var restoreCallbacks = []
  var destroyCallbacks = [config.onDestroy]

  var activeRAF = null
  function handleRAF () {
    if (rafCallbacks.length === 0) {
      if (timer) {
        timer.update()
      }
      activeRAF = null
      return
    }

    // schedule next animation frame
    activeRAF = raf.next(handleRAF)

    // poll for changes
    poll()

    // fire a callback for all pending rafs
    for (var i = rafCallbacks.length - 1; i >= 0; --i) {
      var cb = rafCallbacks[i]
      if (cb) {
        cb(contextState, null, 0)
      }
    }

    // flush all pending webgl calls
    gl.flush()

    // poll GPU timers *after* gl.flush so we don't delay command dispatch
    if (timer) {
      timer.update()
    }
  }

  function startRAF () {
    if (!activeRAF && rafCallbacks.length > 0) {
      activeRAF = raf.next(handleRAF)
    }
  }

  function stopRAF () {
    if (activeRAF) {
      raf.cancel(handleRAF)
      activeRAF = null
    }
  }

  function handleContextLoss (event) {
    event.preventDefault()

    // set context lost flag
    contextLost = true

    // pause request animation frame
    stopRAF()

    // lose context
    lossCallbacks.forEach(function (cb) {
      cb()
    })
  }

  function handleContextRestored (event) {
    // clear error code
    gl.getError()

    // clear context lost flag
    contextLost = false

    // refresh state
    extensionState.restore()
    shaderState.restore()
    bufferState.restore()
    textureState.restore()
    renderbufferState.restore()
    framebufferState.restore()
    attributeState.restore()
    if (timer) {
      timer.restore()
    }

    // refresh state
    core.procs.refresh()

    // restart RAF
    startRAF()

    // restore context
    restoreCallbacks.forEach(function (cb) {
      cb()
    })
  }

  if (canvas) {
    canvas.addEventListener(CONTEXT_LOST_EVENT, handleContextLoss, false)
    canvas.addEventListener(CONTEXT_RESTORED_EVENT, handleContextRestored, false)
  }

  function destroy () {
    rafCallbacks.length = 0
    stopRAF()

    if (canvas) {
      canvas.removeEventListener(CONTEXT_LOST_EVENT, handleContextLoss)
      canvas.removeEventListener(CONTEXT_RESTORED_EVENT, handleContextRestored)
    }

    shaderState.clear()
    framebufferState.clear()
    renderbufferState.clear()
    attributeState.clear()
    textureState.clear()
    elementState.clear()
    bufferState.clear()

    if (timer) {
      timer.clear()
    }

    destroyCallbacks.forEach(function (cb) {
      cb()
    })
  }

  function compileProcedure (options) {
    check$1(!!options, 'invalid args to regl({...})')
    check$1.type(options, 'object', 'invalid args to regl({...})')

    function flattenNestedOptions (options) {
      var result = extend({}, options)
      delete result.uniforms
      delete result.attributes
      delete result.context
      delete result.vao

      if ('stencil' in result && result.stencil.op) {
        result.stencil.opBack = result.stencil.opFront = result.stencil.op
        delete result.stencil.op
      }

      function merge (name) {
        if (name in result) {
          var child = result[name]
          delete result[name]
          Object.keys(child).forEach(function (prop) {
            result[name + '.' + prop] = child[prop]
          })
        }
      }
      merge('blend')
      merge('depth')
      merge('cull')
      merge('stencil')
      merge('polygonOffset')
      merge('scissor')
      merge('sample')

      if ('vao' in options) {
        result.vao = options.vao
      }

      return result
    }

    function separateDynamic (object, useArrays) {
      var staticItems = {}
      var dynamicItems = {}
      Object.keys(object).forEach(function (option) {
        var value = object[option]
        if (dynamic.isDynamic(value)) {
          dynamicItems[option] = dynamic.unbox(value, option)
          return
        } else if (useArrays && Array.isArray(value)) {
          for (var i = 0; i < value.length; ++i) {
            if (dynamic.isDynamic(value[i])) {
              dynamicItems[option] = dynamic.unbox(value, option)
              return
            }
          }
        }
        staticItems[option] = value
      })
      return {
        dynamic: dynamicItems,
        static: staticItems
      }
    }

    // Treat context variables separate from other dynamic variables
    var context = separateDynamic(options.context || {}, true)
    var uniforms = separateDynamic(options.uniforms || {}, true)
    var attributes = separateDynamic(options.attributes || {}, false)
    var opts = separateDynamic(flattenNestedOptions(options), false)

    var stats$$1 = {
      gpuTime: 0.0,
      cpuTime: 0.0,
      count: 0
    }

    var compiled = core.compile(opts, attributes, uniforms, context, stats$$1)

    var draw = compiled.draw
    var batch = compiled.batch
    var scope = compiled.scope

    // FIXME: we should modify code generation for batch commands so this
    // isn't necessary
    var EMPTY_ARRAY = []
    function reserve (count) {
      while (EMPTY_ARRAY.length < count) {
        EMPTY_ARRAY.push(null)
      }
      return EMPTY_ARRAY
    }

    function REGLCommand (args, body) {
      var i
      if (contextLost) {
        check$1.raise('context lost')
      }
      if (typeof args === 'function') {
        return scope.call(this, null, args, 0)
      } else if (typeof body === 'function') {
        if (typeof args === 'number') {
          for (i = 0; i < args; ++i) {
            scope.call(this, null, body, i)
          }
        } else if (Array.isArray(args)) {
          for (i = 0; i < args.length; ++i) {
            scope.call(this, args[i], body, i)
          }
        } else {
          return scope.call(this, args, body, 0)
        }
      } else if (typeof args === 'number') {
        if (args > 0) {
          return batch.call(this, reserve(args | 0), args | 0)
        }
      } else if (Array.isArray(args)) {
        if (args.length) {
          return batch.call(this, args, args.length)
        }
      } else {
        return draw.call(this, args)
      }
    }

    return extend(REGLCommand, {
      stats: stats$$1,
      destroy: function () {
        compiled.destroy()
      }
    })
  }

  var setFBO = framebufferState.setFBO = compileProcedure({
    framebuffer: dynamic.define.call(null, DYN_PROP, 'framebuffer')
  })

  function clearImpl (_, options) {
    var clearFlags = 0
    core.procs.poll()

    var c = options.color
    if (c) {
      gl.clearColor(+c[0] || 0, +c[1] || 0, +c[2] || 0, +c[3] || 0)
      clearFlags |= GL_COLOR_BUFFER_BIT
    }
    if ('depth' in options) {
      gl.clearDepth(+options.depth)
      clearFlags |= GL_DEPTH_BUFFER_BIT
    }
    if ('stencil' in options) {
      gl.clearStencil(options.stencil | 0)
      clearFlags |= GL_STENCIL_BUFFER_BIT
    }

    check$1(!!clearFlags, 'called regl.clear with no buffer specified')
    gl.clear(clearFlags)
  }

  function clear (options) {
    check$1(
      typeof options === 'object' && options,
      'regl.clear() takes an object as input')
    if ('framebuffer' in options) {
      if (options.framebuffer &&
          options.framebuffer_reglType === 'framebufferCube') {
        for (var i = 0; i < 6; ++i) {
          setFBO(extend({
            framebuffer: options.framebuffer.faces[i]
          }, options), clearImpl)
        }
      } else {
        setFBO(options, clearImpl)
      }
    } else {
      clearImpl(null, options)
    }
  }

  function frame (cb) {
    check$1.type(cb, 'function', 'regl.frame() callback must be a function')
    rafCallbacks.push(cb)

    function cancel () {
      // FIXME:  should we check something other than equals cb here?
      // what if a user calls frame twice with the same callback...
      //
      var i = find(rafCallbacks, cb)
      check$1(i >= 0, 'cannot cancel a frame twice')
      function pendingCancel () {
        var index = find(rafCallbacks, pendingCancel)
        rafCallbacks[index] = rafCallbacks[rafCallbacks.length - 1]
        rafCallbacks.length -= 1
        if (rafCallbacks.length <= 0) {
          stopRAF()
        }
      }
      rafCallbacks[i] = pendingCancel
    }

    startRAF()

    return {
      cancel: cancel
    }
  }

  // poll viewport
  function pollViewport () {
    var viewport = nextState.viewport
    var scissorBox = nextState.scissor_box
    viewport[0] = viewport[1] = scissorBox[0] = scissorBox[1] = 0
    contextState.viewportWidth =
      contextState.framebufferWidth =
      contextState.drawingBufferWidth =
      viewport[2] =
      scissorBox[2] = gl.drawingBufferWidth
    contextState.viewportHeight =
      contextState.framebufferHeight =
      contextState.drawingBufferHeight =
      viewport[3] =
      scissorBox[3] = gl.drawingBufferHeight
  }

  function poll () {
    contextState.tick += 1
    contextState.time = now()
    pollViewport()
    core.procs.poll()
  }

  function refresh () {
    textureState.refresh()
    pollViewport()
    core.procs.refresh()
    if (timer) {
      timer.update()
    }
  }

  function now () {
    return (clock() - START_TIME) / 1000.0
  }

  refresh()

  function addListener (event, callback) {
    check$1.type(callback, 'function', 'listener callback must be a function')

    var callbacks
    switch (event) {
      case 'frame':
        return frame(callback)
      case 'lost':
        callbacks = lossCallbacks
        break
      case 'restore':
        callbacks = restoreCallbacks
        break
      case 'destroy':
        callbacks = destroyCallbacks
        break
      default:
        check$1.raise('invalid event, must be one of frame,lost,restore,destroy')
    }

    callbacks.push(callback)
    return {
      cancel: function () {
        for (var i = 0; i < callbacks.length; ++i) {
          if (callbacks[i] === callback) {
            callbacks[i] = callbacks[callbacks.length - 1]
            callbacks.pop()
            return
          }
        }
      }
    }
  }

  var regl = extend(compileProcedure, {
    // Clear current FBO
    clear: clear,

    // Short cuts for dynamic variables
    prop: dynamic.define.bind(null, DYN_PROP),
    context: dynamic.define.bind(null, DYN_CONTEXT),
    this: dynamic.define.bind(null, DYN_STATE),

    // executes an empty draw command
    draw: compileProcedure({}),

    // Resources
    buffer: function (options) {
      return bufferState.create(options, GL_ARRAY_BUFFER, false, false)
    },
    elements: function (options) {
      return elementState.create(options, false)
    },
    texture: textureState.create2D,
    cube: textureState.createCube,
    renderbuffer: renderbufferState.create,
    framebuffer: framebufferState.create,
    framebufferCube: framebufferState.createCube,
    vao: attributeState.createVAO,

    // Expose context attributes
    attributes: glAttributes,

    // Frame rendering
    frame: frame,
    on: addListener,

    // System limits
    limits: limits,
    hasExtension: function (name) {
      return limits.extensions.indexOf(name.toLowerCase()) >= 0
    },

    // Read pixels
    read: readPixels,

    // Destroy regl and all associated resources
    destroy: destroy,

    // Direct GL state manipulation
    _gl: gl,
    _refresh: refresh,

    poll: function () {
      poll()
      if (timer) {
        timer.update()
      }
    },

    // Current time
    now: now,

    // regl Statistics Information
    stats: stats$$1
  })

  config.onDone(null, regl)

  return regl
}

return wrapREGL;

})));
//# sourceMappingURL=regl.js.map


/***/ }),

/***/ "./package.json":
/*!**********************!*\
  !*** ./package.json ***!
  \**********************/
/***/ ((module) => {

"use strict";
module.exports = JSON.parse("{\"name\":\"jupyter-scatter\",\"version\":\"0.3.0\",\"description\":\"A scatter plot extension for Jupyter Notebook and Lab\",\"author\":\"Fritz Lekschas\",\"main\":\"src/index.js\",\"repository\":{\"type\":\"git\",\"url\":\"https://github.com/flekschas/jupyter-scatter.git\"},\"license\":\"Apache-2.0\",\"keywords\":[\"scatter\",\"scatter plot\",\"jupyter\",\"jupyterlab\",\"jupyterlab-extension\"],\"files\":[\"embed.js\",\"extension.js\",\"index.js\",\"labplugin.js\",\"src/**/*.js\",\"dist/*.js\"],\"scripts\":{\"clean\":\"rimraf dist/ && rimraf ../jscatter/labextension/ && rimraf ../jscatter/nbextension\",\"prepare\":\"npm run clean && npm run build:prod\",\"build\":\"webpack --mode=development && npm run build:labextension:dev\",\"build:prod\":\"webpack --mode=production && npm run build:labextension\",\"build:labextension\":\"jupyter labextension build .\",\"build:labextension:dev\":\"jupyter labextension build --development True .\",\"watch\":\"webpack --watch --mode=development\",\"test\":\"echo \\\"Error: no test specified\\\" && exit 1\"},\"dependencies\":{\"@jupyter-widgets/base\":\"^1.1.10 || ^2 || ^3 || ^4\",\"camera-2d-simple\":\"~2.2.1\",\"dom-2d-camera\":\"~2.2.3\",\"gl-matrix\":\"^3.3.0\",\"lodash\":\"^4.17.21\",\"pub-sub-es\":\"~2.0.1\",\"regl\":\"~2.1.0\",\"regl-scatterplot\":\"~1.2.2\"},\"devDependencies\":{\"@jupyterlab/builder\":\"^3.0.8\",\"css-loader\":\"^3.5.3\",\"eslint\":\"^7.4.0\",\"eslint-config-prettier\":\"^6.11.0\",\"eslint-plugin-prettier\":\"^3.1.4\",\"lint-staged\":\"^10.2.7\",\"prettier\":\"^2.0.5\",\"pretty-quick\":\"^2.0.1\",\"rimraf\":\"^3.0.2\",\"style-loader\":\"^1.2.1\",\"webpack\":\"^5.18.0\",\"webpack-cli\":\"^4.4.0\"},\"jupyterlab\":{\"extension\":\"labplugin\",\"outputDir\":\"../jscatter/labextension\",\"sharedPackages\":{\"@jupyter-widgets/base\":{\"bundled\":false,\"singleton\":true}}}}");

/***/ }),

/***/ "./src/codecs.js":
/*!***********************!*\
  !*** ./src/codecs.js ***!
  \***********************/
/***/ ((module) => {

const DTYPES = {
  uint8: Uint8Array,
  int8: Int8Array,
  uint16: Uint16Array,
  int16: Int16Array,
  uint32: Uint32Array,
  int32: Int32Array,
  float32: Float32Array,
  float64: Float64Array,
};

class NumpyCodec {
  /** @param {keyof typeof DTYPES} dtype */
  constructor(dtype) {
    if (!(dtype in DTYPES)) {
      throw Error(`Dtype not supported, got ${JSON.stringify(dtype)}.`);
    }
    this.dtype = dtype;
  }
}

class Numpy2D extends NumpyCodec {

  /**
   * @param {{buffer: DataView, dtype: keyof typeof DTYPES, shape: [number, number]}} data
   * @returns {number[][]}
   */
  deserialize(data) {
    if (data == null) return null;
    // Take full view of data buffer
    const arr = new DTYPES[this.dtype](data.buffer.buffer);
    // Chunk single TypedArray into nested Array of points
    const [height, width] = data.shape;
    // Float32Array(width * height) -> [Array(width), Array(width), ...]
    const points = Array
      .from({ length: height })
      .map((_, i) => Array.from(arr.subarray(i * width, (i + 1) * width)));
    return points;
  }

  /**
   * @param {number[][]} data
   * @returns {{data: ArrayBuffer, dtype: keyof typeof DTYPES, shape: [number, number]}}
   */
  serialize(data) {
    const height = data.length;
    const width = data[0].length;
    const arr = new DTYPES[this.dtype](height * width);
    for (let i = 0; i < data.length; i++) {
      arr.set(data[i], i * height);
    }
    return { data: arr.buffer, dtype: this.dtype, shape: [height, width] };
  }
}

class Numpy1D extends NumpyCodec {

  /**
   * @param {{buffer: DataView, dtype: keyof typeof DTYPES, shape: [number]}} data
   * @returns {number[]}
   */
  deserialize(data) {
    if (data == null) return null;
    // for some reason can't be a typed array
    return Array.from(new DTYPES[this.dtype](data.buffer.buffer));
  }

  /**
   * @param {number[]} data
   * @returns {{data: ArrayBuffer, dtype: keyof typeof DTYPES, shape: [number]}}
   */
  serialize(data) {
    const arr = new DTYPES[this.dtype](data)
    return { data: arr.buffer, dtype: this.dtype, shape: [data.length] };
  }
}

module.exports = { Numpy1D, Numpy2D };


/***/ }),

/***/ "./src/index.js":
/*!**********************!*\
  !*** ./src/index.js ***!
  \**********************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* eslint-env browser */
const widgets = __webpack_require__(/*! @jupyter-widgets/base */ "@jupyter-widgets/base");
const reglScatterplot = __webpack_require__(/*! regl-scatterplot/dist/regl-scatterplot.js */ "./node_modules/regl-scatterplot/dist/regl-scatterplot.js");
const pubSub = __webpack_require__(/*! pub-sub-es */ "./node_modules/pub-sub-es/src/index.js");
const codecs = __webpack_require__(/*! ./codecs */ "./src/codecs.js");
const packageJson = __webpack_require__(/*! ../package.json */ "./package.json");

const createScatterplot = reglScatterplot.default;
const createRenderer = reglScatterplot.createRenderer;

const JupyterScatterModel = widgets.DOMWidgetModel.extend(
  {
    defaults: {
      ...widgets.DOMWidgetModel.prototype.defaults(),
      _model_name : 'JupyterScatterModel',
      _model_module : packageJson.name,
      _model_module_version : packageJson.version,
      _view_name : 'JupyterScatterView',
      _view_module : packageJson.name,
      _view_module_version : packageJson.version
    }
  },
  {
    serializers: {
      ...widgets.DOMWidgetModel.serializers,
      points: new codecs.Numpy2D('float32'),
      selection: new codecs.Numpy1D('uint32'),
      view_data: new codecs.Numpy1D('uint8'),
    }
  },
);

function camelToSnake(string) {
  return string.replace(/[\w]([A-Z])/g, function(m) {
    return m[0] + "_" + m[1];
  }).toLowerCase();
}

function flipObj(obj) {
  return Object.entries(obj).reduce((ret, entry) => {
    const [ key, value ] = entry;
    ret[ value ] = key;
    return ret;
  }, {});
}

function downloadBlob(blob, name) {
  const link = document.createElement('a');
  link.href = URL.createObjectURL(blob);
  link.download = name || 'jscatter.png';

  document.body.appendChild(link);

  link.dispatchEvent(
    new MouseEvent('click', {
      bubbles: true,
      cancelable: true,
      view: window,
    })
  );

  document.body.removeChild(link);
}

const MIN_WIDTH = 240;

const properties = {
  backgroundColor: 'backgroundColor',
  backgroundImage: 'backgroundImage',
  cameraDistance: 'cameraDistance',
  cameraRotation: 'cameraRotation',
  cameraTarget: 'cameraTarget',
  cameraView: 'cameraView',
  color: 'pointColor',
  colorActive: 'pointColorActive',
  colorBy: 'colorBy',
  colorHover: 'pointColorHover',
  height: 'height',
  lassoColor: 'lassoColor',
  lassoInitiator: 'lassoInitiator',
  lassoMinDelay: 'lassoMinDelay',
  lassoMinDist: 'lassoMinDist',
  mouseMode: 'mouseMode',
  opacity: 'opacity',
  opacityBy: 'opacityBy',
  otherOptions: 'otherOptions',
  points: 'points',
  reticle: 'showReticle',
  reticleColor: 'reticleColor',
  selection: 'selectedPoints',
  size: 'pointSize',
  sizeBy: 'sizeBy',
  connect: 'showPointConnections',
  connectionColor: 'pointConnectionColor',
  connectionColorActive: 'pointConnectionColorActive',
  connectionColorHover: 'pointConnectionColorHover',
  connectionColorBy: 'pointConnectionColorBy',
  connectionOpacity: 'pointConnectionOpacity',
  connectionOpacityBy: 'pointConnectionOpacityBy',
  connectionSize: 'pointConnectionSize',
  connectionSizeBy: 'pointConnectionSizeBy',
  viewDownload: 'viewDownload',
  viewReset: 'viewReset',
  hovering: 'hovering',
};

// Custom View. Renders the widget model.
const JupyterScatterView = widgets.DOMWidgetView.extend({
  render: function render() {
    var self = this;

    if (!window.jupyterScatter) {
      window.jupyterScatter = {
        renderer: createRenderer(),
        versionLog: false,
      }
    }

    Object.keys(properties).forEach(function(propertyName) {
      self[propertyName] = self.model.get(camelToSnake(propertyName));
    });

    this.height = this.model.get('height');
    this.width = !Number.isNaN(+this.model.get('width')) && +this.model.get('width') > 0
      ? +this.model.get('width')
      : 'auto';

    // Create a random 6-letter string
    // From https://gist.github.com/6174/6062387
    this.randomStr = (
      Math.random().toString(36).substring(2, 5) +
      Math.random().toString(36).substring(2, 5)
    );
    this.model.set('dom_element_id', this.randomStr);

    this.container = document.createElement('div');
    this.container.setAttribute('id', this.randomStr);
    this.container.style.position = 'relative'
    this.container.style.width = this.width === 'auto'
      ? '100%'
      : this.width + 'px';
    this.container.style.height = this.height + 'px';

    this.el.appendChild(this.container);

    this.canvas = document.createElement('canvas');
    this.canvas.style.width = '100%';
    this.canvas.style.height = '100%';

    this.container.appendChild(this.canvas);

    window.requestAnimationFrame(function init() {
      const initialOptions = {
        renderer: window.jupyterScatter.renderer,
        canvas: self.canvas,
      }

      if (self.width !== 'auto') initialOptions.width = self.width;

      Object.entries(properties).forEach(function(property) {
        const pyName = property[0];
        const jsName = property[1];
        if (self[pyName] !== null)
          initialOptions[jsName] = self[pyName];
      });

      self.scatterplot = createScatterplot(initialOptions);

      if (!window.jupyterScatter.versionLog) {
        // eslint-disable-next-line
        console.log(
          'jupyter-scatter v' + packageJson.version +
          ' with regl-scatterplot v' + self.scatterplot.get('version')
        );
        window.jupyterScatter.versionLog = true;
      }

      self.container.api = self.scatterplot;

      // Listen to events from the JavaScript world
      self.pointoverHandlerBound = self.pointoverHandler.bind(self);
      self.pointoutHandlerBound = self.pointoutHandler.bind(self);
      self.selectHandlerBound = self.selectHandler.bind(self);
      self.deselectHandlerBound = self.deselectHandler.bind(self);
      self.externalViewChangeHandlerBound = self.externalViewChangeHandler.bind(self);
      self.viewChangeHandlerBound = self.viewChangeHandler.bind(self);

      self.scatterplot.subscribe('pointover', self.pointoverHandlerBound);
      self.scatterplot.subscribe('pointout', self.pointoutHandlerBound);
      self.scatterplot.subscribe('select', self.selectHandlerBound);
      self.scatterplot.subscribe('deselect', self.deselectHandlerBound);
      self.scatterplot.subscribe('view', self.viewChangeHandlerBound);

      pubSub.globalPubSub.subscribe(
        'jscatter::view', self.externalViewChangeHandlerBound
      );

      // Listen to messages from the Python world
      Object.keys(properties).forEach(function(propertyName) {
        if (self[propertyName + 'Handler']) {
          self.model.on(
            'change:' + camelToSnake(propertyName),
            self.withModelChangeHandler(
              propertyName,
              self[propertyName + 'Handler'].bind(self)
            ),
            self
          );
        } else {
          console.warn('No handler for ' + propertyName);
        }
      });

      self.colorCanvas();

      if (self.points.length) {
        self.scatterplot
          .draw(self.points)
          .then(function onInitialDraw() {
            if (self.selection.length) {
              self.scatterplot.select(self.selection, { preventEvent: true });
            }
          });
      }
    });

    this.model.save_changes();
  },

  remove: function destroy() {
    pubSub.globalPubSub.unsubscribe(
      'jscatter::view',
      this.externalViewChangeHandlerBound
    );
    this.scatterplot.unsubscribe('pointover', this.pointoverHandlerBound);
    this.scatterplot.unsubscribe('pointout', this.pointoutHandlerBound);
    this.scatterplot.unsubscribe('select', this.selectHandlerBound);
    this.scatterplot.unsubscribe('deselect', this.deselectHandlerBound);
    this.scatterplot.unsubscribe('view', this.viewChangeHandlerBound);
    this.scatterplot.destroy();
  },

  // Helper
  colorCanvas: function colorCanvas() {
    if (Array.isArray(this.backgroundColor)) {
      this.canvas.style.backgroundColor = 'rgb(' +
        this.backgroundColor.slice(0, 3).map(function (x) { return x * 255 }).join(',') +
        ')';
    } else {
      this.canvas.style.backgroundColor = this.backgroundColor;
    }
  },

  // Event handlers for JS-triggered events
  pointoverHandler: function pointoverHandler(pointIndex) {
    this.hoveringChangedByJs = true;
    this.model.set('hovering', pointIndex);
    this.model.save_changes();
  },

  pointoutHandler: function pointoutHandler() {
    this.hoveringChangedByJs = true;
    this.model.set('hovering', null);
    this.model.save_changes();
  },

  selectHandler: function selectHandler(event) {
    this.selectionChangedByJs = true;
    this.model.set('selection', [...event.points]);
    this.model.save_changes();
  },

  deselectHandler: function deselectHandler() {
    this.selectionChangedByJs = true;
    this.model.set('selection', []);
    this.model.save_changes();
  },

  externalViewChangeHandler: function externalViewChangeHandler(event) {
    const viewSync = this.model.get('view_sync');
    if (
      !viewSync
      || event.uuid !== viewSync
      || event.src === this.randomStr
    ) return;
    this.scatterplot.view(event.view, { preventEvent: true });
  },

  viewChangeHandler: function viewChangeHandler(event) {
    const viewSync = this.model.get('view_sync');
    if (!viewSync) return;
    pubSub.globalPubSub.publish(
      'jscatter::view',
      {
        src: this.randomStr,
        uuid: viewSync,
        view: event.view,
      }
    );
  },

  // Event handlers for Python-triggered events
  pointsHandler: function pointsHandler(newPoints) {
    this.scatterplot.draw(newPoints, {
      transition: true,
      transitionDuration: 3000,
      transitionEasing: 'quadInOut',
    });
  },

  selectionHandler: function selectionHandler(newSelection) {
    // Avoid calling `this.scatterplot.select()` twice when the selection was
    // triggered by the JavaScript (i.e., the user interactively selected points)
    if (this.selectionChangedByJs) {
      this.selectionChangedByJs = undefined;
      return;
    }

    if (!newSelection || !newSelection.length) {
      this.scatterplot.deselect({ preventEvent: true });
    } else {
      this.scatterplot.select(newSelection, { preventEvent: true });
    }
  },

  hoveringHandler: function hoveringHandler(newHovering) {
    // Avoid calling `this.scatterplot.hover()` twice when the hovering was
    // triggered by the JavaScript (i.e., the user interactively selected points)
    if (this.hoveringChangedByJs) {
      this.hoveringChangedByJs = undefined;
      return;
    }

    if (Number.isNaN(+newHovering)) {
      this.scatterplot.hover({ preventEvent: true });
    } else {
      this.scatterplot.hover(+newHovering, { preventEvent: true });
    }
  },

  heightHandler: function heightHandler(newValue) {
    this.withPropertyChangeHandler('height', newValue);
    this.resizeHandler();
  },

  backgroundColorHandler: function backgroundColorHandler(newValue) {
    this.withPropertyChangeHandler('backgroundColor', newValue);
    this.colorCanvas();
  },

  backgroundImageHandler: function backgroundImageHandler(newValue) {
    this.withPropertyChangeHandler('backgroundImage', newValue);
  },

  lassoColorHandler: function lassoColorHandler(newValue) {
    this.withPropertyChangeHandler('lassoColor', newValue);
  },

  lassoMinDelayHandler: function lassoMinDelayHandler(newValue) {
    this.withPropertyChangeHandler('lassoMinDelay', newValue);
  },

  lassoMinDistHandler: function lassoMinDistHandler(newValue) {
    this.withPropertyChangeHandler('lassoMinDist', newValue);
  },

  colorHandler: function colorHandler(newValue) {
    this.withPropertyChangeHandler('pointColor', newValue);
  },

  colorActiveHandler: function colorActiveHandler(newValue) {
    this.withPropertyChangeHandler('pointColorActive', newValue);
  },

  colorHoverHandler: function colorHoverHandler(newValue) {
    this.withPropertyChangeHandler('pointColorHover', newValue);
  },

  colorByHandler: function colorByHandler(newValue) {
    this.withPropertyChangeHandler('colorBy', newValue);
  },

  opacityHandler: function opacityHandler(newValue) {
    this.withPropertyChangeHandler('opacity', newValue);
  },

  opacityByHandler: function opacityByHandler(newValue) {
    this.withPropertyChangeHandler('opacityBy', newValue);
  },

  sizeHandler: function sizeHandler(newValue) {
    this.withPropertyChangeHandler('pointSize', newValue);
  },

  sizeByHandler: function sizeByHandler(newValue) {
    this.withPropertyChangeHandler('sizeBy', newValue);
  },

  connectHandler: function connectHandler(newValue) {
    this.withPropertyChangeHandler('showPointConnections', Boolean(newValue));
  },

  connectionColorHandler: function connectionColorHandler(newValue) {
    this.withPropertyChangeHandler('pointConnectionColor', newValue);
  },

  connectionColorActiveHandler: function connectionColorActiveHandler(newValue) {
    this.withPropertyChangeHandler('pointConnectionColorActive', newValue);
  },

  connectionColorHoverHandler: function connectionColorHoverHandler(newValue) {
    this.withPropertyChangeHandler('pointConnectionColorHover', newValue);
  },

  connectionColorByHandler: function connectionColorByHandler(newValue) {
    this.withPropertyChangeHandler('pointConnectionColorBy', newValue);
  },

  connectionOpacityHandler: function connectionOpacityHandler(newValue) {
    this.withPropertyChangeHandler('pointConnectionOpacity', newValue);
  },

  connectionOpacityByHandler: function connectionOpacityByHandler(newValue) {
    this.withPropertyChangeHandler('pointConnectionOpacityBy', newValue);
  },

  connectionSizeHandler: function connectionSizeHandler(newValue) {
    this.withPropertyChangeHandler('pointConnectionSize', newValue);
  },

  connectionSizeByHandler: function connectionSizeByHandler(newValue) {
    this.withPropertyChangeHandler('pointConnectionSizeBy', newValue);
  },

  reticleHandler: function reticleHandler(newValue) {
    this.withPropertyChangeHandler('showReticle', newValue);
  },

  reticleColorHandler: function reticleColorHandler(newValue) {
    this.withPropertyChangeHandler('reticleColor', newValue);
  },

  cameraTargetHandler: function cameraTargetHandler(newValue) {
    this.withPropertyChangeHandler('cameraTarget', newValue);
  },

  cameraDistanceHandler: function cameraDistanceHandler(newValue) {
    this.withPropertyChangeHandler('cameraDistance', newValue);
  },

  cameraRotationHandler: function cameraRotationHandler(newValue) {
    this.withPropertyChangeHandler('cameraRotation', newValue);
  },

  cameraViewHandler: function cameraViewHandler(newValue) {
    this.withPropertyChangeHandler('cameraView', newValue);
  },

  lassoInitiatorHandler: function lassoInitiatorHandler(newValue) {
    this.withPropertyChangeHandler('lassoInitiator', newValue);
  },

  mouseModeHandler: function mouseModeHandler(newValue) {
    this.withPropertyChangeHandler('mouseMode', newValue);
  },

  otherOptionsHandler: function otherOptionsHandler(newOptions) {
    this.scatterplot.set(newOptions);
  },

  viewDownloadHandler: function viewDownloadHandler(target) {
    if (!target) return;

    const image = this.scatterplot.export();

    if (target === 'property') {
      this.model.set('view_data', image.data);
      this.model.set('view_shape', [image.width, image.height]);
      this.model.set('view_download', null);
      this.model.save_changes();
      return;
    }

    this.scatterplot.get('canvas').toBlob((blob) => {
      downloadBlob(blob, 'scatter.png');
      setTimeout(() => {
        this.model.set('view_download', null);
        this.model.save_changes();
      }, 0);
    });
  },

  viewResetHandler: function viewResetHandler() {
    this.scatterplot.reset();
    setTimeout(() => {
      this.model.set('view_reset', false);
      this.model.save_changes();
    }, 0);
  },

  withPropertyChangeHandler: function withPropertyChangeHandler(property, changedValue) {
    var p = {};
    p[property] = changedValue;
    this.scatterplot.set(p);
  },

  withModelChangeHandler: function withModelChangeHandler(property, handler) {
    var self = this;

    return function modelChangeHandler() {
      var changes = self.model.changedAttributes();
      var pyPropertyName = camelToSnake(property);

      if (
        changes[pyPropertyName] === undefined ||
        self[property + 'Changed'] === true
      ) {
        self[property + 'Changed'] = false;
        return;
      };

      self[property] = changes[camelToSnake(property)];

      if (handler) handler(self[property]);
    }
  }
});

module.exports = {
  JupyterScatterModel: JupyterScatterModel,
  JupyterScatterView: JupyterScatterView
};


/***/ }),

/***/ "@jupyter-widgets/base":
/*!****************************************!*\
  !*** external "@jupyter-widgets/base" ***!
  \****************************************/
/***/ ((module) => {

"use strict";
module.exports = __WEBPACK_EXTERNAL_MODULE__jupyter_widgets_base__;

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		if(__webpack_module_cache__[moduleId]) {
/******/ 			return __webpack_module_cache__[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => Object.prototype.hasOwnProperty.call(obj, prop)
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	// module exports must be returned from runtime so entry inlining is disabled
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__("./embed.js");
/******/ })()
);;
//# sourceMappingURL=index.js.map