"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UisNode = exports.UisNodeProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const uis_generated_1 = require("./uis.generated");
Object.defineProperty(exports, "UisNodeProperty", { enumerable: true, get: function () { return uis_generated_1.RosUisNode; } });
/**
 * A ROS resource type:  `ALIYUN::UIS::UisNode`
 */
class UisNode extends ros.Resource {
    /**
     * Create a new `ALIYUN::UIS::UisNode`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosUisNode = new uis_generated_1.RosUisNode(this, id, {
            description: props.description,
            uisId: props.uisId,
            ipAddrsNum: props.ipAddrsNum ? props.ipAddrsNum : 2,
            uisNodeBandwidth: props.uisNodeBandwidth ? props.uisNodeBandwidth : 20,
            uisNodeAreaId: props.uisNodeAreaId,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosUisNode;
        this.attrUisNodeActiveIps = rosUisNode.attrUisNodeActiveIps;
        this.attrUisNodeId = rosUisNode.attrUisNodeId;
        this.attrUisNodeIps = rosUisNode.attrUisNodeIps;
    }
}
exports.UisNode = UisNode;
//# sourceMappingURL=data:application/json;base64,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