import React from 'react';
import { createUseStyles } from 'react-jss';
import { FileDIDItemDetails } from './FileDIDItemDetails';
import { CollectionDIDItemDetails } from './CollectionDIDItemDetails';
import { toHumanReadableSize } from '../../utils/Helpers';
import { ListAttachedFilesPopover } from './ListAttachedFilesPopover';
const useStyles = createUseStyles({
    listItemContainer: {
        borderBottom: '1px solid var(--jp-border-color2)',
        overflow: 'hidden',
        boxSizing: 'border-box'
    },
    listItem: {
        display: 'flex',
        flexDirection: 'row',
        fontSize: '9pt',
        alignItems: 'center',
        padding: '8px 16px 8px 16px',
        cursor: 'pointer'
    },
    listItemCollapsed: {
        extend: 'listItem',
        '&:hover': {
            backgroundColor: 'var(--jp-layout-color2)'
        }
    },
    listItemExpanded: {
        extend: 'listItem',
        backgroundColor: 'var(--jp-layout-color2)'
    },
    textContainer: {
        flex: 1,
        textOverflow: 'ellipsis',
        overflow: 'hidden',
        whiteSpace: 'nowrap'
    },
    iconContainer: {
        lineHeight: 0,
        marginRight: '8px'
    },
    icon: {
        fontSize: '16px',
        verticalAlign: 'middle'
    },
    fileIcon: {
        extend: 'icon',
        color: '#66B100'
    },
    containerIcon: {
        extend: 'icon',
        color: '#5DC0FD'
    },
    datasetIcon: {
        extend: 'icon',
        color: '#FFB100'
    },
    sizeContainer: {
        color: 'var(--jp-ui-font-color2)'
    },
    listFilesIcon: {
        extend: 'icon',
        color: '#2196F3',
        cursor: 'pointer'
    }
});
export const DIDListItem = ({ did, size, type, onClick, expand, style }) => {
    const classes = useStyles();
    const handleViewFilesClick = (e) => {
        e.stopPropagation();
    };
    return (React.createElement("div", { className: classes.listItemContainer, style: style },
        React.createElement("div", { className: expand ? classes.listItemExpanded : classes.listItemCollapsed, onClick: onClick },
            React.createElement("div", { className: classes.iconContainer },
                type === 'file' && React.createElement("i", { className: `${classes.fileIcon} material-icons` }, "attachment"),
                type === 'container' && React.createElement("i", { className: `${classes.containerIcon} material-icons` }, "folder"),
                type === 'dataset' && React.createElement("i", { className: `${classes.datasetIcon} material-icons` }, "folder_open")),
            React.createElement("div", { className: classes.textContainer }, did),
            type === 'file' && !!size && React.createElement("div", { className: classes.sizeContainer }, toHumanReadableSize(size)),
            (type === 'container' || type === 'dataset') && (React.createElement("div", { onClick: handleViewFilesClick },
                React.createElement(ListAttachedFilesPopover, { did: did },
                    React.createElement("i", { className: `${classes.listFilesIcon} material-icons` }, "visibility"))))),
        !!expand && type === 'file' && React.createElement(FileDIDItemDetails, { did: did }),
        !!expand && (type === 'container' || type === 'dataset') && React.createElement(CollectionDIDItemDetails, { did: did })));
};
