var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React, { useEffect, useState } from 'react';
import { createUseStyles } from 'react-jss';
import { useStoreState } from 'pullstate';
import { UIStore } from '../../stores/UIStore';
import { Spinning } from '../Spinning';
import { withRequestAPI } from '../../utils/Actions';
import { AddToNotebookPopover } from './AddToNotebookPopover';
import { withPollingManager, PollingRequesterRef } from '../../utils/DIDPollingManager';
const useStyles = createUseStyles({
    container: {
        padding: '4px 16px 4px 16px',
        backgroundColor: 'var(--jp-layout-color2)',
        boxSizing: 'border-box',
        height: '32px',
        alignItems: 'center'
    },
    icon: {
        fontSize: '10pt',
        verticalAlign: 'middle'
    },
    loading: {
        color: 'var(--jp-ui-font-color2)'
    },
    statusText: {
        fontSize: '9pt',
        verticalAlign: 'middle',
        paddingLeft: '4px',
        flex: 1,
        textOverflow: 'ellipsis',
        overflow: 'hidden',
        whiteSpace: 'nowrap'
    },
    statusContainer: {
        display: 'flex',
        flexDirection: 'row',
        alignItems: 'center',
        flex: 1
    },
    statusAvailable: {
        extend: 'statusContainer',
        color: 'var(--jp-success-color0)'
    },
    statusNotAvailable: {
        extend: 'statusContainer',
        color: 'var(--jp-error-color1)'
    },
    statusReplicating: {
        extend: 'statusContainer',
        color: 'var(--jp-rucio-yellow-color)'
    },
    action: {
        fontSize: '9pt',
        color: 'var(--jp-rucio-primary-blue-color)',
        cursor: 'pointer'
    }
});
const _FileDIDItemDetails = (_a) => {
    var { did } = _a, props = __rest(_a, ["did"]);
    const { actions } = props;
    const { didPollingManager } = props;
    const classes = useStyles();
    const activeInstance = useStoreState(UIStore, s => s.activeInstance);
    const fileDetails = useStoreState(UIStore, s => s.fileDetails[did]);
    const [pollingRequesterRef] = useState(() => new PollingRequesterRef());
    const enablePolling = () => {
        didPollingManager.requestPolling(did, 'file', pollingRequesterRef);
    };
    const disablePolling = () => {
        didPollingManager.disablePolling(did, pollingRequesterRef);
    };
    useEffect(() => {
        enablePolling();
        return () => {
            disablePolling();
        };
    }, []);
    const makeAvailable = () => {
        actions
            .makeFileAvailable(activeInstance.name, did)
            .then(() => enablePolling())
            .catch(e => console.log(e)); // TODO handle error
    };
    return (React.createElement("div", { className: classes.container },
        !fileDetails && (React.createElement("div", { className: classes.loading },
            React.createElement(Spinning, { className: `${classes.icon} material-icons` }, "hourglass_top"),
            React.createElement("span", { className: classes.statusText }, "Loading..."))),
        !!fileDetails && fileDetails.status === 'OK' && React.createElement(FileAvailable, { did: did, path: fileDetails.path }),
        !!fileDetails && fileDetails.status === 'NOT_AVAILABLE' && React.createElement(FileNotAvailable, { onMakeAvailableClicked: makeAvailable }),
        !!fileDetails && fileDetails.status === 'REPLICATING' && React.createElement(FileReplicating, { did: did }),
        !!fileDetails && fileDetails.status === 'STUCK' && React.createElement(FileStuck, { onMakeAvailableClicked: makeAvailable })));
};
const FileAvailable = ({ did, path }) => {
    const classes = useStyles();
    return (React.createElement("div", { className: classes.statusAvailable },
        React.createElement("i", { className: `${classes.icon} material-icons` }, "check_circle"),
        React.createElement("div", { className: classes.statusText }, "Available"),
        React.createElement("div", { className: classes.action },
            React.createElement(AddToNotebookPopover, { did: did, type: "file" }, "Add to Notebook"))));
};
const FileNotAvailable = ({ onMakeAvailableClicked }) => {
    const classes = useStyles();
    return (React.createElement("div", { className: classes.statusNotAvailable },
        React.createElement("i", { className: `${classes.icon} material-icons` }, "lens"),
        React.createElement("div", { className: classes.statusText }, "Not Available"),
        React.createElement("div", { className: classes.action, onClick: onMakeAvailableClicked }, "Make Available")));
};
const FileReplicating = ({ did }) => {
    const classes = useStyles();
    return (React.createElement("div", { className: classes.statusReplicating },
        React.createElement(Spinning, { className: `${classes.icon} material-icons` }, "hourglass_top"),
        React.createElement("div", { className: classes.statusText }, "Replicating file..."),
        React.createElement("div", { className: classes.action },
            React.createElement(AddToNotebookPopover, { did: did, type: "file" }, "Add to Notebook"))));
};
const FileStuck = ({ onMakeAvailableClicked }) => {
    const classes = useStyles();
    return (React.createElement("div", { className: classes.statusNotAvailable },
        React.createElement("i", { className: `${classes.icon} material-icons` }, "error"),
        React.createElement("div", { className: classes.statusText }, "Something went wrong"),
        React.createElement("div", { className: classes.action, onClick: onMakeAvailableClicked }, "Make Available")));
};
export const FileDIDItemDetails = withPollingManager(withRequestAPI(_FileDIDItemDetails));
