var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React, { useState, useEffect, useRef } from 'react';
import { createUseStyles } from 'react-jss';
const useStyles = createUseStyles({
    dropdown: {
        position: 'relative',
        display: 'inline-block'
    },
    dropdownTitle: {
        cursor: 'pointer'
    },
    dropdownContent: {
        display: 'none',
        position: 'absolute',
        marginTop: '8px',
        boxShadow: '0 3px 6px rgba(0,0,0,0.16), 0 3px 6px rgba(0,0,0,0.23)',
        borderRadius: '4px',
        zIndex: 1,
        fontSize: '10pt',
        background: 'var(--jp-layout-color1)',
        color: 'var(--jp-ui-font-color1)'
    },
    dropdownActive: {
        minWidth: (props) => props.optionWidth || '150px',
        extend: 'dropdownContent',
        display: 'block'
    },
    dropdownListItem: {
        padding: '8px',
        width: 'auto',
        borderBottom: '1px solid var(--jp-border-color2)',
        cursor: 'pointer',
        '&:hover': {
            backgroundColor: 'var(--jp-layout-color2)'
        },
        '&:last-child': {
            borderBottom: 'none'
        }
    },
    icon: {
        fontSize: '16px',
        verticalAlign: 'middle'
    }
});
export const InlineDropdown = (_a) => {
    var { options, value, onItemSelected, optionWidth } = _a, props = __rest(_a, ["options", "value", "onItemSelected", "optionWidth"]);
    const classes = useStyles({ optionWidth });
    const [open, setOpen] = useState(false);
    const currentOption = options.find(o => o.value === value);
    const clickTargetRef = useRef();
    const handleClickOutside = (event) => {
        if (clickTargetRef && !clickTargetRef.current.contains(event.target)) {
            setOpen(false);
        }
    };
    useEffect(() => {
        document.addEventListener('mousedown', handleClickOutside);
        return () => {
            document.removeEventListener('mousedown', handleClickOutside);
        };
    });
    return (React.createElement("span", { className: classes.dropdown, onClick: () => setOpen(!open), ref: clickTargetRef },
        React.createElement("span", Object.assign({ className: classes.dropdownTitle }, props),
            currentOption ? currentOption.title : '(select)',
            React.createElement("span", { className: `${classes.icon} material-icons` }, "arrow_drop_down")),
        React.createElement("div", { className: open ? classes.dropdownActive : classes.dropdownContent }, options.map(option => (React.createElement("div", { className: classes.dropdownListItem, onClick: () => onItemSelected && onItemSelected(option.value), key: option.value }, option.title))))));
};
