import React from 'react';
import { createUseStyles } from 'react-jss';
import { TextField } from '../TextField';
import { Spinning } from '../Spinning';
const useStyles = createUseStyles({
    container: {
        padding: '8px 16px 8px 16px'
    },
    label: {
        margin: '4px 0 4px 0'
    },
    textFieldContainer: {
        margin: '8px 0 8px 0'
    },
    warning: {
        margin: '8px 8px 16px 8px',
        color: 'var(--jp-ui-font-color2)',
        fontSize: '9pt'
    },
    loadingIcon: {
        fontSize: '10pt',
        verticalAlign: 'middle'
    },
    loadingContainer: {
        padding: '0 8px 0 8px',
        display: 'flex',
        alignItems: 'center'
    }
});
export const UserPassAuth = ({ params = { username: '', password: '', account: '' }, loading, onAuthParamsChange }) => {
    const classes = useStyles();
    const onUsernameChange = (username) => {
        onAuthParamsChange(Object.assign(Object.assign({}, params), { username }));
    };
    const onPasswordChange = (password) => {
        onAuthParamsChange(Object.assign(Object.assign({}, params), { password }));
    };
    const onAccountChange = (account) => {
        onAuthParamsChange(Object.assign(Object.assign({}, params), { account }));
    };
    const loadingSpinner = (React.createElement("div", { className: classes.loadingContainer },
        React.createElement(Spinning, { className: `${classes.loadingIcon} material-icons` }, "hourglass_top")));
    return (React.createElement(React.Fragment, null,
        React.createElement("div", { className: classes.container },
            React.createElement("div", { className: classes.textFieldContainer },
                React.createElement("div", { className: classes.label }, "Username"),
                React.createElement(TextField, { placeholder: "Username", value: params.username, onChange: e => onUsernameChange(e.target.value), disabled: loading, after: loading ? loadingSpinner : undefined })),
            React.createElement("div", { className: classes.textFieldContainer },
                React.createElement("div", { className: classes.label }, "Password"),
                React.createElement(TextField, { placeholder: "Password", type: "password", value: params.password, onChange: e => onPasswordChange(e.target.value), disabled: loading, after: loading ? loadingSpinner : undefined })),
            React.createElement("div", { className: classes.warning }, "Your password will be stored in plain text inside your user directory."),
            React.createElement("div", { className: classes.textFieldContainer },
                React.createElement("div", { className: classes.label }, "Account"),
                React.createElement(TextField, { placeholder: "Account", value: params.account, onChange: e => onAccountChange(e.target.value), disabled: loading, after: loading ? loadingSpinner : undefined })))));
};
