import * as events from 'aws-cdk-lib/aws-events';
import * as iam from 'aws-cdk-lib/aws-iam';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import * as logs from 'aws-cdk-lib/aws-logs';
import * as sns from 'aws-cdk-lib/aws-sns';
import { Construct } from 'constructs';
import { FsxLifecycleStatusMonitorProps } from './monitorProps';
export declare class FsxLifecycleStatusMonitor extends Construct {
    /**
     * Default schedule for the FSx Lifecycle Status Monitor.
     *
     * @static
     * @memberof FsxLifecycleStatusMonitor
     */
    static readonly DEFAULT_SCHEDULE: events.Schedule;
    /**
     * Default log retention for the FSx Lifecycle Status Monitor.
     *
     * @static
     * @memberof FsxLifecycleStatusMonitor
     */
    static readonly DEFAULT_LOG_RETENTION_PERIOD = logs.RetentionDays.ONE_YEAR;
    /**
     * The Lambda function that will be triggered by the CloudWatch event.
     *
     * @type {lambda.Function}
     * @memberof FsxLifecycleStatusMonitor
     */
    fn: lambda.Function;
    /**
     * Log group for the Lambda function.
     *
     * @type {logs.LogGroup}
     * @memberof FsxLifecycleStatusMonitor
     */
    logGroup: logs.LogGroup;
    /**
     * The IAM policy that will be attached to the Lambda function.
     *
     * @type {iam.Policy}
     * @memberof FsxLifecycleStatusMonitor
     */
    policy: iam.Policy;
    /**
     * The CloudWatch event rule that will trigger the Lambda function.
     *
     * @type {events.Rule}
     * @memberof FsxLifecycleStatusMonitor
     */
    rule: events.Rule;
    /**
     * Topic linked to the Lambda function.
     *
     * @type {sns.Topic}
     * @memberof FsxLifecycleStatusMonitor
     */
    topic: sns.Topic;
    /**
     * Creates an instance of FsxLifecycleStatusMonitor.
     * @param {Construct} scope - parent construct
     * @param {string} id - unique id
     * @memberof FsxLifecycleStatusMonitor - class instance
     */
    constructor(scope: Construct, id: string, props: FsxLifecycleStatusMonitorProps);
    /**
     * Topic linked to the Lambda function.
     *
     * @return {*}  {sns.Topic} - sns topic
     * @memberof FsxLifecycleStatusMonitor - class instance
     */
    createSNSTopic(): sns.Topic;
    createIamPolicy(): iam.Policy;
    /**
     *
     *
     * @return {*}  {lambda.Function}
     * @memberof FsxLifecycleStatusMonitor
     */
    createLambdaFunction(): lambda.Function;
}
