"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.phoneNumberValidator = void 0;
var AREA_CODE = /^[^01][0-9]{2}$/;
var TOLL_FREE = /^8(33|44|55|66|77|88)$/;
function phoneNumberValidator(props) {
    if (props.phoneCity && !props.phoneState) {
        throw new Error('State must be included with City search');
    }
    if ((props.phoneCountry === 'US' || !props.phoneCountry) &&
        !(props.phoneState ||
            props.phoneAreaCode ||
            props.phoneNumberTollFreePrefix)) {
        throw new Error('Need a State, Area Code, or Toll Free Prefix');
    }
    if (props.phoneCountry &&
        !(props.phoneCountry === 'US') &&
        !props.phoneNumberType) {
        throw new Error('Non US numbers must include Number Type');
    }
    if (props.phoneProductType === 'VoiceConnector' &&
        !(props.phoneCountry === 'US')) {
        throw new Error('Non US numbers must be SipMediaApplicationDialIn');
    }
    if (props.phoneNumberTollFreePrefix) {
        if (!TOLL_FREE.test(props.phoneNumberTollFreePrefix.toString())) {
            throw new Error('Invalid Toll Free Prefix');
        }
    }
    if (props.phoneAreaCode) {
        if (!AREA_CODE.test(props.phoneAreaCode.toString())) {
            throw new Error('Invalid Area Code');
        }
    }
    return true;
}
exports.phoneNumberValidator = phoneNumberValidator;
//# sourceMappingURL=data:application/json;base64,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