"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Intrinsic = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const stack_trace_1 = require("../stack-trace");
const token_1 = require("../token");
/**
 * Token subclass that represents values intrinsic to the target document language
 *
 * WARNING: this class should not be externally exposed, but is currently visible
 * because of a limitation of jsii (https://github.com/aws/jsii/issues/524).
 *
 * This class will disappear in a future release and should not be used.
 *
 */
class Intrinsic {
    constructor(value, options = {}) {
        var _b;
        try {
            jsiiDeprecationWarnings._aws_cdk_core_IntrinsicProps(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if (isFunction(value)) {
            throw new Error(`Argument to Intrinsic must be a plain value object, got ${value}`);
        }
        this.creationStack = ((_b = options.stackTrace) !== null && _b !== void 0 ? _b : true) ? stack_trace_1.captureStackTrace() : [];
        this.value = value;
    }
    resolve(_context) {
        try {
            jsiiDeprecationWarnings._aws_cdk_core_IResolveContext(_context);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.resolve);
            }
            throw error;
        }
        return this.value;
    }
    /**
     * Convert an instance of this Token to a string
     *
     * This method will be called implicitly by language runtimes if the object
     * is embedded into a string. We treat it the same as an explicit
     * stringification.
     */
    toString() {
        return token_1.Token.asString(this);
    }
    /**
     * Turn this Token into JSON
     *
     * Called automatically when JSON.stringify() is called on a Token.
     */
    toJSON() {
        // We can't do the right work here because in case we contain a function, we
        // won't know the type of value that function represents (in the simplest
        // case, string or number), and we can't know that without an
        // IResolveContext to actually do the resolution, which we don't have.
        // We used to throw an error, but since JSON.stringify() is often used in
        // error messages to produce a readable representation of an object, if we
        // throw here we'll obfuscate that descriptive error with something worse.
        // So return a string representation that indicates this thing is a token
        // and needs resolving.
        return '<unresolved-token>';
    }
    /**
     * Creates a throwable Error object that contains the token creation stack trace.
     * @param message Error message
     */
    newError(message) {
        return new Error(`${message}\nToken created:\n    at ${this.creationStack.join('\n    at ')}\nError thrown:`);
    }
}
exports.Intrinsic = Intrinsic;
_a = JSII_RTTI_SYMBOL_1;
Intrinsic[_a] = { fqn: "@aws-cdk/core.Intrinsic", version: "1.156.1" };
function isFunction(x) {
    return typeof x === 'function';
}
//# sourceMappingURL=data:application/json;base64,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