# This code is part of Qiskit.
#
# (C) Copyright IBM 2022.
#
# This code is licensed under the Apache License, Version 2.0. You may
# obtain a copy of this license in the LICENSE.txt file in the root directory
# of this source tree or at http://www.apache.org/licenses/LICENSE-2.0.
#
# Any modifications or derivative works of this code must retain this
# copyright notice, and modified files need to carry a notice indicating
# that they have been altered from the originals.

"""Some expected VibrationalOps."""

from qiskit_nature.second_q.operators import VibrationalOp

_truncation_order_1_op = VibrationalOp(
    {
        "+_0_0 -_0_0": 1268.0676746875001,
        "+_0_1 -_0_1": 3813.8767834375008,
        "+_1_0 -_1_0": 705.8633818750001,
        "+_1_0 -_1_1": -46.025705898886045,
        "-_1_0 +_1_1": -46.025705898886045,
        "+_1_1 -_1_1": 2120.1145593750007,
        "+_2_0 -_2_0": 238.31540750000005,
        "+_2_1 -_2_1": 728.9613775000003,
        "+_3_0 -_3_0": 238.31540750000005,
        "+_3_1 -_3_1": 728.9613775000003,
    },
    num_modals=[2, 2, 2, 2],
).normal_order()

_truncation_order_2_op = VibrationalOp(
    {
        "+_0_0 -_0_0": 1268.0676746875001,
        "+_0_1 -_0_1": 3813.8767834375008,
        "+_1_0 -_1_0": 705.8633818750001,
        "+_1_0 -_1_1": -46.025705898886045,
        "-_1_0 +_1_1": -46.025705898886045,
        "+_1_1 -_1_1": 2120.1145593750007,
        "+_2_0 -_2_0": 238.31540750000005,
        "+_2_1 -_2_1": 728.9613775000003,
        "+_3_0 -_3_0": 238.31540750000005,
        "+_3_1 -_3_1": 728.9613775000003,
        "+_1_0 -_1_0 +_2_1 -_2_1": -12.582898125000007,
        "+_0_0 -_0_0 +_3_0 -_3_0": -10.205891250000004,
        "+_1_1 -_1_1 +_2_1 -_2_1": -37.74869437500002,
        "-_1_0 +_1_1 +_3_1 -_3_1": 128.02581930849442,
        "+_2_1 -_2_1 +_3_1 -_3_1": 63.88515000000004,
        "+_0_0 -_0_0 +_3_1 -_3_1": -30.61767375000002,
        "+_1_1 -_1_1 +_3_0 -_3_0": -12.582898125000007,
        "+_0_0 -_0_0 +_1_1 -_1_1": 14.827627500000007,
        "+_0_1 -_0_1 +_3_0 -_3_0": -30.617673750000016,
        "+_2_0 -_2_0 +_3_1 -_3_1": 21.29505000000001,
        "+_0_0 -_0_0 +_1_0 -_1_1": -88.20174216876333,
        "+_0_0 -_0_0 +_2_1 -_2_1": -30.61767375000002,
        "+_0_1 -_0_1 +_1_0 -_1_0": 14.827627500000007,
        "+_0_1 -_0_1 +_2_0 -_2_0": -30.617673750000016,
        "+_0_0 -_0_0 +_1_0 -_1_0": 4.942542500000002,
        "+_0_0 -_0_0 -_1_0 +_1_1": -88.20174216876333,
        "+_1_0 -_1_1 +_2_1 -_2_1": 128.02581930849442,
        "+_0_1 -_0_1 +_2_1 -_2_1": -91.85302125000007,
        "-_1_0 +_1_1 +_2_0 -_2_0": 42.67527310283147,
        "+_1_0 -_1_0 +_2_0 -_2_0": -4.194299375000002,
        "+_2_1 -_2_1 +_3_0 -_3_0": 21.29505000000001,
        "-_1_0 +_1_1 +_3_0 -_3_0": 42.67527310283147,
        "+_0_0 -_0_0 +_2_0 -_2_0": -10.205891250000004,
        "+_1_0 -_1_1 +_2_0 -_2_0": 42.67527310283147,
        "+_1_0 -_1_0 +_3_0 -_3_0": -4.194299375000002,
        "+_1_1 -_1_1 +_2_0 -_2_0": -12.582898125000007,
        "+_1_0 -_1_1 +_3_0 -_3_0": 42.67527310283147,
        "+_1_0 -_1_0 +_3_1 -_3_1": -12.582898125000007,
        "+_1_0 -_1_1 +_3_1 -_3_1": 128.02581930849442,
        "-_1_0 +_1_1 +_2_1 -_2_1": 128.02581930849442,
        "+_1_1 -_1_1 +_3_1 -_3_1": -37.74869437500002,
        "+_0_1 -_0_1 +_1_0 -_1_1": -264.60522650629,
        "+_0_1 -_0_1 +_1_1 -_1_1": 44.482882500000024,
        "+_2_0 -_2_0 +_3_0 -_3_0": 7.0983500000000035,
        "+_0_1 -_0_1 -_1_0 +_1_1": -264.60522650629,
        "+_0_1 -_0_1 +_3_1 -_3_1": -91.85302125000007,
    },
    num_modals=[2, 2, 2, 2],
).normal_order()
