SITE_ID = 1

# Social Profile
### Custom Social Profile User
AUTH_USER_MODEL = "socialprofile.SocialProfile"
SOCIAL_AUTH_GOOGLE_OAUTH_SCOPE = [
    "https://www.googleapis.com/auth/drive",
    "https://www.googleapis.com/auth/userinfo.profile",
]

SOCIAL_AUTH_PIPELINE = (
    "social.pipeline.social_auth.social_details",
    "social.pipeline.social_auth.social_uid",
    "social.pipeline.social_auth.auth_allowed",
    "social.pipeline.social_auth.social_user",
    "social.pipeline.user.get_username",
    "social.pipeline.mail.mail_validation",
    "social.pipeline.user.create_user",
    "social.pipeline.social_auth.associate_user",
    "social.pipeline.debug.debug",
    "social.pipeline.social_auth.load_extra_data",
    "social.pipeline.user.user_details",
    "socialprofile.pipeline.socialprofile_extra_values",
)

SOCIAL_AUTH_LOGIN_REDIRECT_URL = "/"
SOCIAL_AUTH_NEW_USER_REDIRECT_URL = "/"
SOCIAL_AUTH_NEW_ASSOCIATION_REDIRECT_URL = "/select/"
DEFAULT_RETURNTO_PATH = "/select/"

# Core Authentication Settings
LOGIN_URL = "/select/"
LOGIN_REDIRECT_URL = "/"
LOGIN_ERROR_URL = "/select/"

SESSION_SERIALIZER = "django.contrib.sessions.serializers.PickleSerializer"

AUTHENTICATION_BACKENDS = (
    # 'django.contrib.auth.backends.ModelBackend',  # Comment if you want DISABLE Login Form (Password)
    "social.backends.amazon.AmazonOAuth2",
    "social.backends.angel.AngelOAuth2",
    "social.backends.aol.AOLOpenId",
    "social.backends.appsfuel.AppsfuelOAuth2",
    "social.backends.beats.BeatsOAuth2",
    "social.backends.behance.BehanceOAuth2",
    "social.backends.belgiumeid.BelgiumEIDOpenId",
    "social.backends.bitbucket.BitbucketOAuth",
    "social.backends.box.BoxOAuth2",
    "social.backends.clef.ClefOAuth2",
    "social.backends.coinbase.CoinbaseOAuth2",
    # 'social.backends.coursera.CourseraOAuth2',
    "social.backends.dailymotion.DailymotionOAuth2",
    "social.backends.disqus.DisqusOAuth2",
    "social.backends.douban.DoubanOAuth2",
    # 'social.backends.dropbox.DropboxOAuth',
    "social.backends.dropbox.DropboxOAuth2",
    # 'social.backends.eveonline.EVEOnlineOAuth2',
    "social.backends.evernote.EvernoteSandboxOAuth",
    "social.backends.facebook.FacebookAppOAuth2",
    "social.backends.facebook.FacebookOAuth2",
    "social.backends.fedora.FedoraOpenId",
    "social.backends.fitbit.FitbitOAuth",
    "social.backends.flickr.FlickrOAuth",
    "social.backends.foursquare.FoursquareOAuth2",
    "social.backends.github.GithubOAuth2",
    # 'social.backends.google.GoogleOAuth',
    "social.backends.google.GoogleOAuth2",
    # 'social.backends.google.GoogleOpenId',
    # 'social.backends.google.GooglePlusAuth',
    # 'social.backends.google.GoogleOpenIdConnect',
    "social.backends.instagram.InstagramOAuth2",
    "social.backends.jawbone.JawboneOAuth2",
    "social.backends.kakao.KakaoOAuth2",
    "social.backends.linkedin.LinkedinOAuth",
    "social.backends.linkedin.LinkedinOAuth2",
    "social.backends.live.LiveOAuth2",
    "social.backends.livejournal.LiveJournalOpenId",
    "social.backends.mailru.MailruOAuth2",
    "social.backends.mendeley.MendeleyOAuth",
    "social.backends.mendeley.MendeleyOAuth2",
    # 'social.backends.mineid.MineIDOAuth2',
    "social.backends.mixcloud.MixcloudOAuth2",
    # 'social.backends.nationbuilder.NationBuilderOAuth2',
    "social.backends.odnoklassniki.OdnoklassnikiOAuth2",
    "social.backends.open_id.OpenIdAuth",
    "social.backends.openstreetmap.OpenStreetMapOAuth",
    "social.backends.persona.PersonaAuth",
    "social.backends.podio.PodioOAuth2",
    "social.backends.rdio.RdioOAuth1",
    "social.backends.rdio.RdioOAuth2",
    "social.backends.readability.ReadabilityOAuth",
    "social.backends.reddit.RedditOAuth2",
    "social.backends.runkeeper.RunKeeperOAuth2",
    "social.backends.skyrock.SkyrockOAuth",
    "social.backends.soundcloud.SoundcloudOAuth2",
    "social.backends.spotify.SpotifyOAuth2",
    "social.backends.stackoverflow.StackoverflowOAuth2",
    "social.backends.steam.SteamOpenId",
    "social.backends.stocktwits.StocktwitsOAuth2",
    "social.backends.stripe.StripeOAuth2",
    "social.backends.suse.OpenSUSEOpenId",
    "social.backends.thisismyjam.ThisIsMyJamOAuth1",
    "social.backends.trello.TrelloOAuth",
    "social.backends.tripit.TripItOAuth",
    "social.backends.tumblr.TumblrOAuth",
    "social.backends.twilio.TwilioAuth",
    "social.backends.twitter.TwitterOAuth",
    "social.backends.vk.VKOAuth2",
    "social.backends.weibo.WeiboOAuth2",
    # 'social.backends.wunderlist.WunderlistOAuth2',
    "social.backends.xing.XingOAuth",
    "social.backends.yahoo.YahooOAuth",
    "social.backends.yahoo.YahooOpenId",
    "social.backends.yammer.YammerOAuth2",
    "social.backends.yandex.YandexOAuth2",
    "social.backends.vimeo.VimeoOAuth1",
    "social.backends.lastfm.LastFmAuth",
    "social.backends.moves.MovesOAuth2",
    # 'social.backends.vend.VendOAuth2',
    "social.backends.email.EmailAuth",
    "social.backends.username.UsernameAuth",
)

SECRET_KEY = "fake-key"
DATABASES = {
    "default": {
        "ENGINE": "django.db.backends.sqlite3",
        "NAME": "tests.db",
        "SUPPORTS_TRANSACTIONS": "false",
    }
}
ROOT_URLCONF = "socialprofile.urls"
INSTALLED_APPS = [
    "django.contrib.admin",
    "django.contrib.auth",
    "django.contrib.contenttypes",
    "django.contrib.sessions",
    "django.contrib.messages",
    "django.contrib.sites",
    "django.contrib.staticfiles",
    "django_errors",
    "social.apps.django_app.default",
    "django_countries",
    "socialprofile",
]
