"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnServer = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2023-02-15T19:08:27.403Z","fingerprint":"CjAT6nG4mGJbsN69mSs+o8FxbgFTHTUq11E9Iq2slFA="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("@aws-cdk/core");
const cfn_parse = require("@aws-cdk/core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnServerProps`
 *
 * @param properties - the TypeScript properties of a `CfnServerProps`
 *
 * @returns the result of the validation.
 */
function CfnServerPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('associatePublicIpAddress', cdk.validateBoolean)(properties.associatePublicIpAddress));
    errors.collect(cdk.propertyValidator('backupId', cdk.validateString)(properties.backupId));
    errors.collect(cdk.propertyValidator('backupRetentionCount', cdk.validateNumber)(properties.backupRetentionCount));
    errors.collect(cdk.propertyValidator('customCertificate', cdk.validateString)(properties.customCertificate));
    errors.collect(cdk.propertyValidator('customDomain', cdk.validateString)(properties.customDomain));
    errors.collect(cdk.propertyValidator('customPrivateKey', cdk.validateString)(properties.customPrivateKey));
    errors.collect(cdk.propertyValidator('disableAutomatedBackup', cdk.validateBoolean)(properties.disableAutomatedBackup));
    errors.collect(cdk.propertyValidator('engine', cdk.validateString)(properties.engine));
    errors.collect(cdk.propertyValidator('engineAttributes', cdk.listValidator(CfnServer_EngineAttributePropertyValidator))(properties.engineAttributes));
    errors.collect(cdk.propertyValidator('engineModel', cdk.validateString)(properties.engineModel));
    errors.collect(cdk.propertyValidator('engineVersion', cdk.validateString)(properties.engineVersion));
    errors.collect(cdk.propertyValidator('instanceProfileArn', cdk.requiredValidator)(properties.instanceProfileArn));
    errors.collect(cdk.propertyValidator('instanceProfileArn', cdk.validateString)(properties.instanceProfileArn));
    errors.collect(cdk.propertyValidator('instanceType', cdk.requiredValidator)(properties.instanceType));
    errors.collect(cdk.propertyValidator('instanceType', cdk.validateString)(properties.instanceType));
    errors.collect(cdk.propertyValidator('keyPair', cdk.validateString)(properties.keyPair));
    errors.collect(cdk.propertyValidator('preferredBackupWindow', cdk.validateString)(properties.preferredBackupWindow));
    errors.collect(cdk.propertyValidator('preferredMaintenanceWindow', cdk.validateString)(properties.preferredMaintenanceWindow));
    errors.collect(cdk.propertyValidator('securityGroupIds', cdk.listValidator(cdk.validateString))(properties.securityGroupIds));
    errors.collect(cdk.propertyValidator('serviceRoleArn', cdk.requiredValidator)(properties.serviceRoleArn));
    errors.collect(cdk.propertyValidator('serviceRoleArn', cdk.validateString)(properties.serviceRoleArn));
    errors.collect(cdk.propertyValidator('subnetIds', cdk.listValidator(cdk.validateString))(properties.subnetIds));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnServerProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::OpsWorksCM::Server` resource
 *
 * @param properties - the TypeScript properties of a `CfnServerProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::OpsWorksCM::Server` resource.
 */
// @ts-ignore TS6133
function cfnServerPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnServerPropsValidator(properties).assertSuccess();
    return {
        InstanceProfileArn: cdk.stringToCloudFormation(properties.instanceProfileArn),
        InstanceType: cdk.stringToCloudFormation(properties.instanceType),
        ServiceRoleArn: cdk.stringToCloudFormation(properties.serviceRoleArn),
        AssociatePublicIpAddress: cdk.booleanToCloudFormation(properties.associatePublicIpAddress),
        BackupId: cdk.stringToCloudFormation(properties.backupId),
        BackupRetentionCount: cdk.numberToCloudFormation(properties.backupRetentionCount),
        CustomCertificate: cdk.stringToCloudFormation(properties.customCertificate),
        CustomDomain: cdk.stringToCloudFormation(properties.customDomain),
        CustomPrivateKey: cdk.stringToCloudFormation(properties.customPrivateKey),
        DisableAutomatedBackup: cdk.booleanToCloudFormation(properties.disableAutomatedBackup),
        Engine: cdk.stringToCloudFormation(properties.engine),
        EngineAttributes: cdk.listMapper(cfnServerEngineAttributePropertyToCloudFormation)(properties.engineAttributes),
        EngineModel: cdk.stringToCloudFormation(properties.engineModel),
        EngineVersion: cdk.stringToCloudFormation(properties.engineVersion),
        KeyPair: cdk.stringToCloudFormation(properties.keyPair),
        PreferredBackupWindow: cdk.stringToCloudFormation(properties.preferredBackupWindow),
        PreferredMaintenanceWindow: cdk.stringToCloudFormation(properties.preferredMaintenanceWindow),
        SecurityGroupIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupIds),
        SubnetIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.subnetIds),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnServerPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('instanceProfileArn', 'InstanceProfileArn', cfn_parse.FromCloudFormation.getString(properties.InstanceProfileArn));
    ret.addPropertyResult('instanceType', 'InstanceType', cfn_parse.FromCloudFormation.getString(properties.InstanceType));
    ret.addPropertyResult('serviceRoleArn', 'ServiceRoleArn', cfn_parse.FromCloudFormation.getString(properties.ServiceRoleArn));
    ret.addPropertyResult('associatePublicIpAddress', 'AssociatePublicIpAddress', properties.AssociatePublicIpAddress != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AssociatePublicIpAddress) : undefined);
    ret.addPropertyResult('backupId', 'BackupId', properties.BackupId != null ? cfn_parse.FromCloudFormation.getString(properties.BackupId) : undefined);
    ret.addPropertyResult('backupRetentionCount', 'BackupRetentionCount', properties.BackupRetentionCount != null ? cfn_parse.FromCloudFormation.getNumber(properties.BackupRetentionCount) : undefined);
    ret.addPropertyResult('customCertificate', 'CustomCertificate', properties.CustomCertificate != null ? cfn_parse.FromCloudFormation.getString(properties.CustomCertificate) : undefined);
    ret.addPropertyResult('customDomain', 'CustomDomain', properties.CustomDomain != null ? cfn_parse.FromCloudFormation.getString(properties.CustomDomain) : undefined);
    ret.addPropertyResult('customPrivateKey', 'CustomPrivateKey', properties.CustomPrivateKey != null ? cfn_parse.FromCloudFormation.getString(properties.CustomPrivateKey) : undefined);
    ret.addPropertyResult('disableAutomatedBackup', 'DisableAutomatedBackup', properties.DisableAutomatedBackup != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DisableAutomatedBackup) : undefined);
    ret.addPropertyResult('engine', 'Engine', properties.Engine != null ? cfn_parse.FromCloudFormation.getString(properties.Engine) : undefined);
    ret.addPropertyResult('engineAttributes', 'EngineAttributes', properties.EngineAttributes != null ? cfn_parse.FromCloudFormation.getArray(CfnServerEngineAttributePropertyFromCloudFormation)(properties.EngineAttributes) : undefined);
    ret.addPropertyResult('engineModel', 'EngineModel', properties.EngineModel != null ? cfn_parse.FromCloudFormation.getString(properties.EngineModel) : undefined);
    ret.addPropertyResult('engineVersion', 'EngineVersion', properties.EngineVersion != null ? cfn_parse.FromCloudFormation.getString(properties.EngineVersion) : undefined);
    ret.addPropertyResult('keyPair', 'KeyPair', properties.KeyPair != null ? cfn_parse.FromCloudFormation.getString(properties.KeyPair) : undefined);
    ret.addPropertyResult('preferredBackupWindow', 'PreferredBackupWindow', properties.PreferredBackupWindow != null ? cfn_parse.FromCloudFormation.getString(properties.PreferredBackupWindow) : undefined);
    ret.addPropertyResult('preferredMaintenanceWindow', 'PreferredMaintenanceWindow', properties.PreferredMaintenanceWindow != null ? cfn_parse.FromCloudFormation.getString(properties.PreferredMaintenanceWindow) : undefined);
    ret.addPropertyResult('securityGroupIds', 'SecurityGroupIds', properties.SecurityGroupIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupIds) : undefined);
    ret.addPropertyResult('subnetIds', 'SubnetIds', properties.SubnetIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SubnetIds) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::OpsWorksCM::Server`
 *
 * The `AWS::OpsWorksCM::Server` resource creates an AWS OpsWorks for Chef Automate or OpsWorks for Puppet Enterprise configuration management server. For more information, see [Create a Chef Automate Server in AWS CloudFormation](https://docs.aws.amazon.com/opsworks/latest/userguide/opscm-create-server-cfn.html) or [Create a Puppet Enterprise Master in AWS CloudFormation](https://docs.aws.amazon.com/opsworks/latest/userguide/opspup-create-server-cfn.html) in the *AWS OpsWorks User Guide* , and [CreateServer](https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_CreateServer.html) in the *AWS OpsWorks CM API Reference* .
 *
 * @cloudformationResource AWS::OpsWorksCM::Server
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html
 */
class CfnServer extends cdk.CfnResource {
    /**
     * Create a new `AWS::OpsWorksCM::Server`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnServer.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_opsworkscm_CfnServerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnServer);
            }
            throw error;
        }
        cdk.requireProperty(props, 'instanceProfileArn', this);
        cdk.requireProperty(props, 'instanceType', this);
        cdk.requireProperty(props, 'serviceRoleArn', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrEndpoint = cdk.Token.asString(this.getAtt('Endpoint'));
        this.attrServerName = cdk.Token.asString(this.getAtt('ServerName'));
        this.instanceProfileArn = props.instanceProfileArn;
        this.instanceType = props.instanceType;
        this.serviceRoleArn = props.serviceRoleArn;
        this.associatePublicIpAddress = props.associatePublicIpAddress;
        this.backupId = props.backupId;
        this.backupRetentionCount = props.backupRetentionCount;
        this.customCertificate = props.customCertificate;
        this.customDomain = props.customDomain;
        this.customPrivateKey = props.customPrivateKey;
        this.disableAutomatedBackup = props.disableAutomatedBackup;
        this.engine = props.engine;
        this.engineAttributes = props.engineAttributes;
        this.engineModel = props.engineModel;
        this.engineVersion = props.engineVersion;
        this.keyPair = props.keyPair;
        this.preferredBackupWindow = props.preferredBackupWindow;
        this.preferredMaintenanceWindow = props.preferredMaintenanceWindow;
        this.securityGroupIds = props.securityGroupIds;
        this.subnetIds = props.subnetIds;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::OpsWorksCM::Server", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnServerPropsFromCloudFormation(resourceProperties);
        const ret = new CfnServer(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnServer.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            instanceProfileArn: this.instanceProfileArn,
            instanceType: this.instanceType,
            serviceRoleArn: this.serviceRoleArn,
            associatePublicIpAddress: this.associatePublicIpAddress,
            backupId: this.backupId,
            backupRetentionCount: this.backupRetentionCount,
            customCertificate: this.customCertificate,
            customDomain: this.customDomain,
            customPrivateKey: this.customPrivateKey,
            disableAutomatedBackup: this.disableAutomatedBackup,
            engine: this.engine,
            engineAttributes: this.engineAttributes,
            engineModel: this.engineModel,
            engineVersion: this.engineVersion,
            keyPair: this.keyPair,
            preferredBackupWindow: this.preferredBackupWindow,
            preferredMaintenanceWindow: this.preferredMaintenanceWindow,
            securityGroupIds: this.securityGroupIds,
            subnetIds: this.subnetIds,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnServerPropsToCloudFormation(props);
    }
}
exports.CfnServer = CfnServer;
_a = JSII_RTTI_SYMBOL_1;
CfnServer[_a] = { fqn: "@aws-cdk/aws-opsworkscm.CfnServer", version: "1.193.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnServer.CFN_RESOURCE_TYPE_NAME = "AWS::OpsWorksCM::Server";
/**
 * Determine whether the given properties match those of a `EngineAttributeProperty`
 *
 * @param properties - the TypeScript properties of a `EngineAttributeProperty`
 *
 * @returns the result of the validation.
 */
function CfnServer_EngineAttributePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "EngineAttributeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::OpsWorksCM::Server.EngineAttribute` resource
 *
 * @param properties - the TypeScript properties of a `EngineAttributeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::OpsWorksCM::Server.EngineAttribute` resource.
 */
// @ts-ignore TS6133
function cfnServerEngineAttributePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnServer_EngineAttributePropertyValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnServerEngineAttributePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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