# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['BackendRole']


class BackendRole(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_object_id: Optional[pulumi.Input[str]] = None,
                 azure_roles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BackendRoleAzureRoleArgs']]]]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 max_ttl: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a BackendRole resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_object_id: Application Object ID for an existing service principal that will
               be used instead of creating dynamic service principals. If present, `azure_roles` will be ignored.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BackendRoleAzureRoleArgs']]]] azure_roles: List of Azure roles to be assigned to the generated service principal.
        :param pulumi.Input[str] backend: Path to the mounted Azure auth backend
        :param pulumi.Input[str] description: Human-friendly description of the mount for the backend.
        :param pulumi.Input[str] max_ttl: Specifies the maximum TTL for service principals generated using this role. Accepts time
               suffixed strings ("1h") or an integer number of seconds. Defaults to the system/engine max TTL time.
        :param pulumi.Input[str] role: Name of the Azure role
        :param pulumi.Input[str] ttl: Specifies the default TTL for service principals generated using this role.
               Accepts time suffixed strings ("1h") or an integer number of seconds. Defaults to the system/engine default TTL time.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['application_object_id'] = application_object_id
            __props__['azure_roles'] = azure_roles
            __props__['backend'] = backend
            __props__['description'] = description
            __props__['max_ttl'] = max_ttl
            if role is None:
                raise TypeError("Missing required property 'role'")
            __props__['role'] = role
            __props__['ttl'] = ttl
        super(BackendRole, __self__).__init__(
            'vault:azure/backendRole:BackendRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_object_id: Optional[pulumi.Input[str]] = None,
            azure_roles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BackendRoleAzureRoleArgs']]]]] = None,
            backend: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            max_ttl: Optional[pulumi.Input[str]] = None,
            role: Optional[pulumi.Input[str]] = None,
            ttl: Optional[pulumi.Input[str]] = None) -> 'BackendRole':
        """
        Get an existing BackendRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_object_id: Application Object ID for an existing service principal that will
               be used instead of creating dynamic service principals. If present, `azure_roles` will be ignored.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BackendRoleAzureRoleArgs']]]] azure_roles: List of Azure roles to be assigned to the generated service principal.
        :param pulumi.Input[str] backend: Path to the mounted Azure auth backend
        :param pulumi.Input[str] description: Human-friendly description of the mount for the backend.
        :param pulumi.Input[str] max_ttl: Specifies the maximum TTL for service principals generated using this role. Accepts time
               suffixed strings ("1h") or an integer number of seconds. Defaults to the system/engine max TTL time.
        :param pulumi.Input[str] role: Name of the Azure role
        :param pulumi.Input[str] ttl: Specifies the default TTL for service principals generated using this role.
               Accepts time suffixed strings ("1h") or an integer number of seconds. Defaults to the system/engine default TTL time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["application_object_id"] = application_object_id
        __props__["azure_roles"] = azure_roles
        __props__["backend"] = backend
        __props__["description"] = description
        __props__["max_ttl"] = max_ttl
        __props__["role"] = role
        __props__["ttl"] = ttl
        return BackendRole(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationObjectId")
    def application_object_id(self) -> pulumi.Output[Optional[str]]:
        """
        Application Object ID for an existing service principal that will
        be used instead of creating dynamic service principals. If present, `azure_roles` will be ignored.
        """
        return pulumi.get(self, "application_object_id")

    @property
    @pulumi.getter(name="azureRoles")
    def azure_roles(self) -> pulumi.Output[Optional[Sequence['outputs.BackendRoleAzureRole']]]:
        """
        List of Azure roles to be assigned to the generated service principal.
        """
        return pulumi.get(self, "azure_roles")

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output[Optional[str]]:
        """
        Path to the mounted Azure auth backend
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Human-friendly description of the mount for the backend.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the maximum TTL for service principals generated using this role. Accepts time
        suffixed strings ("1h") or an integer number of seconds. Defaults to the system/engine max TTL time.
        """
        return pulumi.get(self, "max_ttl")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[str]:
        """
        Name of the Azure role
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the default TTL for service principals generated using this role.
        Accepts time suffixed strings ("1h") or an integer number of seconds. Defaults to the system/engine default TTL time.
        """
        return pulumi.get(self, "ttl")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

