# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables

__all__ = ['SecretBackendStaticRole']


class SecretBackendStaticRole(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rotation_period: Optional[pulumi.Input[int]] = None,
                 rotation_statements: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates a Database Secret Backend static role in Vault. Database secret backend
        static roles can be used to manage 1-to-1 mapping of a Vault Role to a user in a
        database for the database.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        db = vault.Mount("db",
            path="postgres",
            type="database")
        postgres = vault.database.SecretBackendConnection("postgres",
            allowed_roles=["*"],
            backend=db.path,
            postgresql=vault.database.SecretBackendConnectionPostgresqlArgs(
                connection_url="postgres://username:password@host:port/database",
            ))
        static_role = vault.database.SecretBackendStaticRole("staticRole",
            backend=db.path,
            db_name=postgres.name,
            rotation_period=3600,
            rotation_statements=["ALTER USER \"{{name}}\" WITH PASSWORD '{{password}}';"],
            username="example")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend: The unique name of the Vault mount to configure.
        :param pulumi.Input[str] db_name: The unique name of the database connection to use for the static role.
        :param pulumi.Input[str] name: A unique name to give the static role.
        :param pulumi.Input[int] rotation_period: The amount of time Vault should wait before rotating the password, in seconds.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rotation_statements: Database statements to execute to rotate the password for the configured database user.
        :param pulumi.Input[str] username: The database username that this static role corresponds to.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if backend is None:
                raise TypeError("Missing required property 'backend'")
            __props__['backend'] = backend
            if db_name is None:
                raise TypeError("Missing required property 'db_name'")
            __props__['db_name'] = db_name
            __props__['name'] = name
            if rotation_period is None:
                raise TypeError("Missing required property 'rotation_period'")
            __props__['rotation_period'] = rotation_period
            __props__['rotation_statements'] = rotation_statements
            if username is None:
                raise TypeError("Missing required property 'username'")
            __props__['username'] = username
        super(SecretBackendStaticRole, __self__).__init__(
            'vault:database/secretBackendStaticRole:SecretBackendStaticRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend: Optional[pulumi.Input[str]] = None,
            db_name: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            rotation_period: Optional[pulumi.Input[int]] = None,
            rotation_statements: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            username: Optional[pulumi.Input[str]] = None) -> 'SecretBackendStaticRole':
        """
        Get an existing SecretBackendStaticRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend: The unique name of the Vault mount to configure.
        :param pulumi.Input[str] db_name: The unique name of the database connection to use for the static role.
        :param pulumi.Input[str] name: A unique name to give the static role.
        :param pulumi.Input[int] rotation_period: The amount of time Vault should wait before rotating the password, in seconds.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rotation_statements: Database statements to execute to rotate the password for the configured database user.
        :param pulumi.Input[str] username: The database username that this static role corresponds to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["backend"] = backend
        __props__["db_name"] = db_name
        __props__["name"] = name
        __props__["rotation_period"] = rotation_period
        __props__["rotation_statements"] = rotation_statements
        __props__["username"] = username
        return SecretBackendStaticRole(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output[str]:
        """
        The unique name of the Vault mount to configure.
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Output[str]:
        """
        The unique name of the database connection to use for the static role.
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A unique name to give the static role.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="rotationPeriod")
    def rotation_period(self) -> pulumi.Output[int]:
        """
        The amount of time Vault should wait before rotating the password, in seconds.
        """
        return pulumi.get(self, "rotation_period")

    @property
    @pulumi.getter(name="rotationStatements")
    def rotation_statements(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Database statements to execute to rotate the password for the configured database user.
        """
        return pulumi.get(self, "rotation_statements")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        The database username that this static role corresponds to.
        """
        return pulumi.get(self, "username")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

