# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables

__all__ = ['AuthBackendRole']


class AuthBackendRole(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audience: Optional[pulumi.Input[str]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 bound_service_account_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 bound_service_account_namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_ttl: Optional[pulumi.Input[int]] = None,
                 num_uses: Optional[pulumi.Input[int]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[int]] = None,
                 token_max_ttl: Optional[pulumi.Input[int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[bool]] = None,
                 token_num_uses: Optional[pulumi.Input[int]] = None,
                 token_period: Optional[pulumi.Input[int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_ttl: Optional[pulumi.Input[int]] = None,
                 token_type: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages an Kubernetes auth backend role in a Vault server. See the [Vault
        documentation](https://www.vaultproject.io/docs/auth/kubernetes.html) for more
        information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        kubernetes = vault.AuthBackend("kubernetes", type="kubernetes")
        example = vault.kubernetes.AuthBackendRole("example",
            backend=kubernetes.path,
            role_name="example-role",
            bound_service_account_names=["example"],
            bound_service_account_namespaces=["example"],
            token_ttl=3600,
            token_policies=[
                "default",
                "dev",
                "prod",
            ],
            audience="vault")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] audience: Audience claim to verify in the JWT.
        :param pulumi.Input[str] backend: Unique name of the kubernetes backend to configure.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bound_cidrs: If set, a list of
               CIDRs valid as the source address for login requests. This value is also encoded into any resulting token.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bound_service_account_names: List of service account names able to access this role. If set to `["*"]` all names are allowed, both this and bound_service_account_namespaces can not be "*".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bound_service_account_namespaces: List of namespaces allowed to access this role. If set to `["*"]` all namespaces are allowed, both this and bound_service_account_names can not be set to "*".
        :param pulumi.Input[int] max_ttl: The maximum allowed lifetime of tokens
               issued using this role, provided as a number of seconds.
        :param pulumi.Input[int] num_uses: If set, puts a use-count
               limitation on the issued token.
        :param pulumi.Input[int] period: If set, indicates that the
               token generated using this role should never expire. The token should be renewed within the
               duration specified by this value. At each renewal, the token's TTL will be set to the
               value of this field. Specified in seconds.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policies: An array of strings
               specifying the policies to be set on tokens issued using this role.
        :param pulumi.Input[str] role_name: Name of the role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] token_bound_cidrs: List of CIDR blocks; if set, specifies blocks of IP
               addresses which can authenticate successfully, and ties the resulting token to these blocks
               as well.
        :param pulumi.Input[int] token_explicit_max_ttl: If set, will encode an
               [explicit max TTL](https://www.vaultproject.io/docs/concepts/tokens.html#token-time-to-live-periodic-tokens-and-explicit-max-ttls)
               onto the token in number of seconds. This is a hard cap even if `token_ttl` and
               `token_max_ttl` would otherwise allow a renewal.
        :param pulumi.Input[int] token_max_ttl: The maximum lifetime for generated tokens in number of seconds.
               Its current value will be referenced at renewal time.
        :param pulumi.Input[bool] token_no_default_policy: If set, the default policy will not be set on
               generated tokens; otherwise it will be added to the policies set in token_policies.
        :param pulumi.Input[int] token_num_uses: The
               [period](https://www.vaultproject.io/docs/concepts/tokens.html#token-time-to-live-periodic-tokens-and-explicit-max-ttls),
               if any, in number of seconds to set on the token.
        :param pulumi.Input[int] token_period: If set, indicates that the
               token generated using this role should never expire. The token should be renewed within the
               duration specified by this value. At each renewal, the token's TTL will be set to the
               value of this field. Specified in seconds.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] token_policies: List of policies to encode onto generated tokens. Depending
               on the auth method, this list may be supplemented by user/group/other values.
        :param pulumi.Input[int] token_ttl: The incremental lifetime for generated tokens in number of seconds.
               Its current value will be referenced at renewal time.
        :param pulumi.Input[str] token_type: The type of token that should be generated. Can be `service`,
               `batch`, or `default` to use the mount's tuned default (which unless changed will be
               `service` tokens). For token store roles, there are two additional possibilities:
               `default-service` and `default-batch` which specify the type to return unless the client
               requests a different type at generation time.
        :param pulumi.Input[int] ttl: The TTL period of tokens issued
               using this role, provided as a number of seconds.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['audience'] = audience
            __props__['backend'] = backend
            if bound_cidrs is not None:
                warnings.warn("use `token_bound_cidrs` instead if you are running Vault >= 1.2", DeprecationWarning)
                pulumi.log.warn("bound_cidrs is deprecated: use `token_bound_cidrs` instead if you are running Vault >= 1.2")
            __props__['bound_cidrs'] = bound_cidrs
            if bound_service_account_names is None:
                raise TypeError("Missing required property 'bound_service_account_names'")
            __props__['bound_service_account_names'] = bound_service_account_names
            if bound_service_account_namespaces is None:
                raise TypeError("Missing required property 'bound_service_account_namespaces'")
            __props__['bound_service_account_namespaces'] = bound_service_account_namespaces
            if max_ttl is not None:
                warnings.warn("use `token_max_ttl` instead if you are running Vault >= 1.2", DeprecationWarning)
                pulumi.log.warn("max_ttl is deprecated: use `token_max_ttl` instead if you are running Vault >= 1.2")
            __props__['max_ttl'] = max_ttl
            if num_uses is not None:
                warnings.warn("use `token_num_uses` instead if you are running Vault >= 1.2", DeprecationWarning)
                pulumi.log.warn("num_uses is deprecated: use `token_num_uses` instead if you are running Vault >= 1.2")
            __props__['num_uses'] = num_uses
            if period is not None:
                warnings.warn("use `token_period` instead if you are running Vault >= 1.2", DeprecationWarning)
                pulumi.log.warn("period is deprecated: use `token_period` instead if you are running Vault >= 1.2")
            __props__['period'] = period
            if policies is not None:
                warnings.warn("use `token_policies` instead if you are running Vault >= 1.2", DeprecationWarning)
                pulumi.log.warn("policies is deprecated: use `token_policies` instead if you are running Vault >= 1.2")
            __props__['policies'] = policies
            if role_name is None:
                raise TypeError("Missing required property 'role_name'")
            __props__['role_name'] = role_name
            __props__['token_bound_cidrs'] = token_bound_cidrs
            __props__['token_explicit_max_ttl'] = token_explicit_max_ttl
            __props__['token_max_ttl'] = token_max_ttl
            __props__['token_no_default_policy'] = token_no_default_policy
            __props__['token_num_uses'] = token_num_uses
            __props__['token_period'] = token_period
            __props__['token_policies'] = token_policies
            __props__['token_ttl'] = token_ttl
            __props__['token_type'] = token_type
            if ttl is not None:
                warnings.warn("use `token_ttl` instead if you are running Vault >= 1.2", DeprecationWarning)
                pulumi.log.warn("ttl is deprecated: use `token_ttl` instead if you are running Vault >= 1.2")
            __props__['ttl'] = ttl
        super(AuthBackendRole, __self__).__init__(
            'vault:kubernetes/authBackendRole:AuthBackendRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            audience: Optional[pulumi.Input[str]] = None,
            backend: Optional[pulumi.Input[str]] = None,
            bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            bound_service_account_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            bound_service_account_namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            max_ttl: Optional[pulumi.Input[int]] = None,
            num_uses: Optional[pulumi.Input[int]] = None,
            period: Optional[pulumi.Input[int]] = None,
            policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            role_name: Optional[pulumi.Input[str]] = None,
            token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            token_explicit_max_ttl: Optional[pulumi.Input[int]] = None,
            token_max_ttl: Optional[pulumi.Input[int]] = None,
            token_no_default_policy: Optional[pulumi.Input[bool]] = None,
            token_num_uses: Optional[pulumi.Input[int]] = None,
            token_period: Optional[pulumi.Input[int]] = None,
            token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            token_ttl: Optional[pulumi.Input[int]] = None,
            token_type: Optional[pulumi.Input[str]] = None,
            ttl: Optional[pulumi.Input[int]] = None) -> 'AuthBackendRole':
        """
        Get an existing AuthBackendRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] audience: Audience claim to verify in the JWT.
        :param pulumi.Input[str] backend: Unique name of the kubernetes backend to configure.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bound_cidrs: If set, a list of
               CIDRs valid as the source address for login requests. This value is also encoded into any resulting token.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bound_service_account_names: List of service account names able to access this role. If set to `["*"]` all names are allowed, both this and bound_service_account_namespaces can not be "*".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bound_service_account_namespaces: List of namespaces allowed to access this role. If set to `["*"]` all namespaces are allowed, both this and bound_service_account_names can not be set to "*".
        :param pulumi.Input[int] max_ttl: The maximum allowed lifetime of tokens
               issued using this role, provided as a number of seconds.
        :param pulumi.Input[int] num_uses: If set, puts a use-count
               limitation on the issued token.
        :param pulumi.Input[int] period: If set, indicates that the
               token generated using this role should never expire. The token should be renewed within the
               duration specified by this value. At each renewal, the token's TTL will be set to the
               value of this field. Specified in seconds.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policies: An array of strings
               specifying the policies to be set on tokens issued using this role.
        :param pulumi.Input[str] role_name: Name of the role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] token_bound_cidrs: List of CIDR blocks; if set, specifies blocks of IP
               addresses which can authenticate successfully, and ties the resulting token to these blocks
               as well.
        :param pulumi.Input[int] token_explicit_max_ttl: If set, will encode an
               [explicit max TTL](https://www.vaultproject.io/docs/concepts/tokens.html#token-time-to-live-periodic-tokens-and-explicit-max-ttls)
               onto the token in number of seconds. This is a hard cap even if `token_ttl` and
               `token_max_ttl` would otherwise allow a renewal.
        :param pulumi.Input[int] token_max_ttl: The maximum lifetime for generated tokens in number of seconds.
               Its current value will be referenced at renewal time.
        :param pulumi.Input[bool] token_no_default_policy: If set, the default policy will not be set on
               generated tokens; otherwise it will be added to the policies set in token_policies.
        :param pulumi.Input[int] token_num_uses: The
               [period](https://www.vaultproject.io/docs/concepts/tokens.html#token-time-to-live-periodic-tokens-and-explicit-max-ttls),
               if any, in number of seconds to set on the token.
        :param pulumi.Input[int] token_period: If set, indicates that the
               token generated using this role should never expire. The token should be renewed within the
               duration specified by this value. At each renewal, the token's TTL will be set to the
               value of this field. Specified in seconds.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] token_policies: List of policies to encode onto generated tokens. Depending
               on the auth method, this list may be supplemented by user/group/other values.
        :param pulumi.Input[int] token_ttl: The incremental lifetime for generated tokens in number of seconds.
               Its current value will be referenced at renewal time.
        :param pulumi.Input[str] token_type: The type of token that should be generated. Can be `service`,
               `batch`, or `default` to use the mount's tuned default (which unless changed will be
               `service` tokens). For token store roles, there are two additional possibilities:
               `default-service` and `default-batch` which specify the type to return unless the client
               requests a different type at generation time.
        :param pulumi.Input[int] ttl: The TTL period of tokens issued
               using this role, provided as a number of seconds.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["audience"] = audience
        __props__["backend"] = backend
        __props__["bound_cidrs"] = bound_cidrs
        __props__["bound_service_account_names"] = bound_service_account_names
        __props__["bound_service_account_namespaces"] = bound_service_account_namespaces
        __props__["max_ttl"] = max_ttl
        __props__["num_uses"] = num_uses
        __props__["period"] = period
        __props__["policies"] = policies
        __props__["role_name"] = role_name
        __props__["token_bound_cidrs"] = token_bound_cidrs
        __props__["token_explicit_max_ttl"] = token_explicit_max_ttl
        __props__["token_max_ttl"] = token_max_ttl
        __props__["token_no_default_policy"] = token_no_default_policy
        __props__["token_num_uses"] = token_num_uses
        __props__["token_period"] = token_period
        __props__["token_policies"] = token_policies
        __props__["token_ttl"] = token_ttl
        __props__["token_type"] = token_type
        __props__["ttl"] = ttl
        return AuthBackendRole(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def audience(self) -> pulumi.Output[Optional[str]]:
        """
        Audience claim to verify in the JWT.
        """
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output[Optional[str]]:
        """
        Unique name of the kubernetes backend to configure.
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter(name="boundCidrs")
    def bound_cidrs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        If set, a list of
        CIDRs valid as the source address for login requests. This value is also encoded into any resulting token.
        """
        return pulumi.get(self, "bound_cidrs")

    @property
    @pulumi.getter(name="boundServiceAccountNames")
    def bound_service_account_names(self) -> pulumi.Output[Sequence[str]]:
        """
        List of service account names able to access this role. If set to `["*"]` all names are allowed, both this and bound_service_account_namespaces can not be "*".
        """
        return pulumi.get(self, "bound_service_account_names")

    @property
    @pulumi.getter(name="boundServiceAccountNamespaces")
    def bound_service_account_namespaces(self) -> pulumi.Output[Sequence[str]]:
        """
        List of namespaces allowed to access this role. If set to `["*"]` all namespaces are allowed, both this and bound_service_account_names can not be set to "*".
        """
        return pulumi.get(self, "bound_service_account_namespaces")

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum allowed lifetime of tokens
        issued using this role, provided as a number of seconds.
        """
        return pulumi.get(self, "max_ttl")

    @property
    @pulumi.getter(name="numUses")
    def num_uses(self) -> pulumi.Output[Optional[int]]:
        """
        If set, puts a use-count
        limitation on the issued token.
        """
        return pulumi.get(self, "num_uses")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        If set, indicates that the
        token generated using this role should never expire. The token should be renewed within the
        duration specified by this value. At each renewal, the token's TTL will be set to the
        value of this field. Specified in seconds.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def policies(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        An array of strings
        specifying the policies to be set on tokens issued using this role.
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[str]:
        """
        Name of the role.
        """
        return pulumi.get(self, "role_name")

    @property
    @pulumi.getter(name="tokenBoundCidrs")
    def token_bound_cidrs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of CIDR blocks; if set, specifies blocks of IP
        addresses which can authenticate successfully, and ties the resulting token to these blocks
        as well.
        """
        return pulumi.get(self, "token_bound_cidrs")

    @property
    @pulumi.getter(name="tokenExplicitMaxTtl")
    def token_explicit_max_ttl(self) -> pulumi.Output[Optional[int]]:
        """
        If set, will encode an
        [explicit max TTL](https://www.vaultproject.io/docs/concepts/tokens.html#token-time-to-live-periodic-tokens-and-explicit-max-ttls)
        onto the token in number of seconds. This is a hard cap even if `token_ttl` and
        `token_max_ttl` would otherwise allow a renewal.
        """
        return pulumi.get(self, "token_explicit_max_ttl")

    @property
    @pulumi.getter(name="tokenMaxTtl")
    def token_max_ttl(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum lifetime for generated tokens in number of seconds.
        Its current value will be referenced at renewal time.
        """
        return pulumi.get(self, "token_max_ttl")

    @property
    @pulumi.getter(name="tokenNoDefaultPolicy")
    def token_no_default_policy(self) -> pulumi.Output[Optional[bool]]:
        """
        If set, the default policy will not be set on
        generated tokens; otherwise it will be added to the policies set in token_policies.
        """
        return pulumi.get(self, "token_no_default_policy")

    @property
    @pulumi.getter(name="tokenNumUses")
    def token_num_uses(self) -> pulumi.Output[Optional[int]]:
        """
        The
        [period](https://www.vaultproject.io/docs/concepts/tokens.html#token-time-to-live-periodic-tokens-and-explicit-max-ttls),
        if any, in number of seconds to set on the token.
        """
        return pulumi.get(self, "token_num_uses")

    @property
    @pulumi.getter(name="tokenPeriod")
    def token_period(self) -> pulumi.Output[Optional[int]]:
        """
        If set, indicates that the
        token generated using this role should never expire. The token should be renewed within the
        duration specified by this value. At each renewal, the token's TTL will be set to the
        value of this field. Specified in seconds.
        """
        return pulumi.get(self, "token_period")

    @property
    @pulumi.getter(name="tokenPolicies")
    def token_policies(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of policies to encode onto generated tokens. Depending
        on the auth method, this list may be supplemented by user/group/other values.
        """
        return pulumi.get(self, "token_policies")

    @property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> pulumi.Output[Optional[int]]:
        """
        The incremental lifetime for generated tokens in number of seconds.
        Its current value will be referenced at renewal time.
        """
        return pulumi.get(self, "token_ttl")

    @property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of token that should be generated. Can be `service`,
        `batch`, or `default` to use the mount's tuned default (which unless changed will be
        `service` tokens). For token store roles, there are two additional possibilities:
        `default-service` and `default-batch` which specify the type to return unless the client
        requests a different type at generation time.
        """
        return pulumi.get(self, "token_type")

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[int]]:
        """
        The TTL period of tokens issued
        using this role, provided as a number of seconds.
        """
        return pulumi.get(self, "ttl")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

