# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['MfaDuo']


class MfaDuo(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_hostname: Optional[pulumi.Input[str]] = None,
                 integration_key: Optional[pulumi.Input[str]] = None,
                 mount_accessor: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 push_info: Optional[pulumi.Input[str]] = None,
                 secret_key: Optional[pulumi.Input[str]] = None,
                 username_format: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Provides a resource to manage [Duo MFA](https://www.vaultproject.io/docs/enterprise/mfa/mfa-duo.html).

        **Note** this feature is available only with Vault Enterprise.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        userpass = vault.AuthBackend("userpass",
            path="userpass",
            type="userpass")
        my_duo = vault.MfaDuo("myDuo",
            api_hostname="api-2b5c39f5.duosecurity.com",
            integration_key="BIACEUEAXI20BNWTEYXT",
            mount_accessor=userpass.accessor,
            secret_key="8C7THtrIigh2rPZQMbguugt8IUftWhMRCOBzbuyz")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] api_hostname: `(string: <required>)` - API hostname for Duo.
        :param pulumi.Input[str] integration_key: `(string: <required>)` - Integration key for Duo.
        :param pulumi.Input[str] mount_accessor: `(string: <required>)` - The mount to tie this method to for use in automatic mappings. The mapping will use the Name field of Aliases associated with this mount as the username in the mapping.
        :param pulumi.Input[str] name: `(string: <required>)` – Name of the MFA method.
        :param pulumi.Input[str] push_info: `(string)` - Push information for Duo.
        :param pulumi.Input[str] secret_key: `(string: <required>)` - Secret key for Duo.
        :param pulumi.Input[str] username_format: `(string)` - A format string for mapping Identity names to MFA method names. Values to substitute should be placed in `{{}}`. For example, `"{{alias.name}}@example.com"`. If blank, the Alias's Name field will be used as-is. Currently-supported mappings:
               - alias.name: The name returned by the mount configured via the `mount_accessor` parameter
               - entity.name: The name configured for the Entity
               - alias.metadata.`<key>`: The value of the Alias's metadata parameter
               - entity.metadata.`<key>`: The value of the Entity's metadata parameter
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if api_hostname is None:
                raise TypeError("Missing required property 'api_hostname'")
            __props__['api_hostname'] = api_hostname
            if integration_key is None:
                raise TypeError("Missing required property 'integration_key'")
            __props__['integration_key'] = integration_key
            if mount_accessor is None:
                raise TypeError("Missing required property 'mount_accessor'")
            __props__['mount_accessor'] = mount_accessor
            __props__['name'] = name
            __props__['push_info'] = push_info
            if secret_key is None:
                raise TypeError("Missing required property 'secret_key'")
            __props__['secret_key'] = secret_key
            __props__['username_format'] = username_format
        super(MfaDuo, __self__).__init__(
            'vault:index/mfaDuo:MfaDuo',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_hostname: Optional[pulumi.Input[str]] = None,
            integration_key: Optional[pulumi.Input[str]] = None,
            mount_accessor: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            push_info: Optional[pulumi.Input[str]] = None,
            secret_key: Optional[pulumi.Input[str]] = None,
            username_format: Optional[pulumi.Input[str]] = None) -> 'MfaDuo':
        """
        Get an existing MfaDuo resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] api_hostname: `(string: <required>)` - API hostname for Duo.
        :param pulumi.Input[str] integration_key: `(string: <required>)` - Integration key for Duo.
        :param pulumi.Input[str] mount_accessor: `(string: <required>)` - The mount to tie this method to for use in automatic mappings. The mapping will use the Name field of Aliases associated with this mount as the username in the mapping.
        :param pulumi.Input[str] name: `(string: <required>)` – Name of the MFA method.
        :param pulumi.Input[str] push_info: `(string)` - Push information for Duo.
        :param pulumi.Input[str] secret_key: `(string: <required>)` - Secret key for Duo.
        :param pulumi.Input[str] username_format: `(string)` - A format string for mapping Identity names to MFA method names. Values to substitute should be placed in `{{}}`. For example, `"{{alias.name}}@example.com"`. If blank, the Alias's Name field will be used as-is. Currently-supported mappings:
               - alias.name: The name returned by the mount configured via the `mount_accessor` parameter
               - entity.name: The name configured for the Entity
               - alias.metadata.`<key>`: The value of the Alias's metadata parameter
               - entity.metadata.`<key>`: The value of the Entity's metadata parameter
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["api_hostname"] = api_hostname
        __props__["integration_key"] = integration_key
        __props__["mount_accessor"] = mount_accessor
        __props__["name"] = name
        __props__["push_info"] = push_info
        __props__["secret_key"] = secret_key
        __props__["username_format"] = username_format
        return MfaDuo(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiHostname")
    def api_hostname(self) -> pulumi.Output[str]:
        """
        `(string: <required>)` - API hostname for Duo.
        """
        return pulumi.get(self, "api_hostname")

    @property
    @pulumi.getter(name="integrationKey")
    def integration_key(self) -> pulumi.Output[str]:
        """
        `(string: <required>)` - Integration key for Duo.
        """
        return pulumi.get(self, "integration_key")

    @property
    @pulumi.getter(name="mountAccessor")
    def mount_accessor(self) -> pulumi.Output[str]:
        """
        `(string: <required>)` - The mount to tie this method to for use in automatic mappings. The mapping will use the Name field of Aliases associated with this mount as the username in the mapping.
        """
        return pulumi.get(self, "mount_accessor")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        `(string: <required>)` – Name of the MFA method.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pushInfo")
    def push_info(self) -> pulumi.Output[Optional[str]]:
        """
        `(string)` - Push information for Duo.
        """
        return pulumi.get(self, "push_info")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[str]:
        """
        `(string: <required>)` - Secret key for Duo.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="usernameFormat")
    def username_format(self) -> pulumi.Output[Optional[str]]:
        """
        `(string)` - A format string for mapping Identity names to MFA method names. Values to substitute should be placed in `{{}}`. For example, `"{{alias.name}}@example.com"`. If blank, the Alias's Name field will be used as-is. Currently-supported mappings:
        - alias.name: The name returned by the mount configured via the `mount_accessor` parameter
        - entity.name: The name configured for the Entity
        - alias.metadata.`<key>`: The value of the Alias's metadata parameter
        - entity.metadata.`<key>`: The value of the Entity's metadata parameter
        """
        return pulumi.get(self, "username_format")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

