# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables

__all__ = [
    'AuthBackendGroup',
    'AuthBackendUser',
]

@pulumi.output_type
class AuthBackendGroup(dict):
    def __init__(__self__, *,
                 group_name: str,
                 policies: Sequence[str]):
        """
        :param str group_name: Name of the group within the Okta
        :param Sequence[str] policies: List of Vault policies to associate with this user
        """
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "policies", policies)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> str:
        """
        Name of the group within the Okta
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter
    def policies(self) -> Sequence[str]:
        """
        List of Vault policies to associate with this user
        """
        return pulumi.get(self, "policies")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AuthBackendUser(dict):
    def __init__(__self__, *,
                 groups: Sequence[str],
                 username: str,
                 policies: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] groups: List of Okta groups to associate with this user
        :param str username: Name of the user within Okta
        :param Sequence[str] policies: List of Vault policies to associate with this user
        """
        pulumi.set(__self__, "groups", groups)
        pulumi.set(__self__, "username", username)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)

    @property
    @pulumi.getter
    def groups(self) -> Sequence[str]:
        """
        List of Okta groups to associate with this user
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Name of the user within Okta
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def policies(self) -> Optional[Sequence[str]]:
        """
        List of Vault policies to associate with this user
        """
        return pulumi.get(self, "policies")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


