# sense_street
This is a Python client for Sense Street API.

# Run the client
In order to use the client, import SenseStreetClient from sense_street:
```
from sense_street import SenseStreetClient
```
and provide the app_id and api_url:
```
client = SenseStreetClient(app_id="test", api_url="https://server.com/api")
```
To simply ping the server, use:
```
client.ping()
```

# Overview of all functions:

## Pings
```
ping()
```
Sends ping to the server to check if server is up and responding.

```
ping_auth()
```
Similar to ping but with authorisation - easy way to check if you're authorised to send requests to the server.

## Requests to prediction server:

```
predict_rfqs(conversation, options)
```
Sends request to predict rfqs in a conversation. Conversation has to be either a dict or a json.

```
chat_snippet_predict_rfqs(chat_snippet, options)
```
Sends request to predict rfqs in the conversation. Conversation has to be either a dict or a json. The difference between this function and the one above is the structure of the conversation, <em>predict_rfqs</em> is for a conversation in the Sense Street's format, while <em>chat_snippet_predict_rfqs</em> is for conversation that is a cutout from the chat.

## Batch job requests:
```
upload_files_with_conversations(files_paths)
```
Uploads specified files with conversation to be processed by the server. It returns an id for each file that will be nedded later on to obtain processed conversations. To run this function you need to have permission to open these files. Make sure you're not trying to upload over 1Gb of files in a single request.

```
upload_file_with_bond(file_path)
```
Uploads file with bond data to the server.

```
get_processed_conv_file(file_id, save_path)
```
Returns file with processed conversations, <em>file_id</em> is the id that was returned during the files upload - by the <em>upload_files_with_conversations</em> function.

```
get_conv_file_status(file_id)
```
Returns the status of the uploaded file. With this function you can check if the file has already been processed by the server and is ready for download.

# How to use your key to authorise requests
In order to send requests to the server you need to obtain a pair of keys - public and private (if you don't have a key contact the Sense Street to get one). In order to be correctly authorised by the server initialised the SenseStreetClient with the paths to both of the keys:

```
client = SenseStreetClient(
    app_id="id of your app",
    api_url="https://server.com/api",
    priv_key_path='path to your private key',
    pub_key_path='path to your public key'
    )
```

# How to define proxies
In order to use proxy provide a dict of proxies when initializing Sense Street Client. The <em>proxies</em> parameter has a form of a dictionary mapping protocol to the URL of the proxy, eg.:
```
client = SenseStreetClient(
    app_id="id of your app",
    api_url="https://server.com/api",
    proxies = {
        "https": "https://10.10.1.10:1080",
        }
    )
```

To read more about proxies refer to: https://requests.readthedocs.io/en/latest/user/advanced/#proxies
