# coding: utf-8

"""
    Data Repository API

    This document defines the REST API for Data Repository. **Status: design in progress** There are four top-level endpoints (besides some used by swagger):  * /swagger-ui.html - generated by swagger: swagger API page that provides this documentation and a live UI for      submitting REST requests  * /status - provides the operational status of the service  * /api    - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The overall API (/api) currently supports two interfaces:  * Repository - a general and default interface for initial setup, managing ingest and repository metadata  * Resource - an interface for managing billing accounts and resources  The API endpoints are organized by interface. Each interface is separately versioned. ## Notes on Naming All of the reference items are suffixed with \"Model\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. ## Editing and debugging I have found it best to edit this file directly to make changes and then use the swagger-editor to validate. The errors out of swagger-codegen are not that helpful. In the swagger-editor, it gives you nice errors and links to the place in the YAML where the errors are. But... the swagger-editor has been a bit of a pain for me to run. I tried the online website and was not able to load my YAML. Instead, I run it locally in a docker container, like this: ``` docker pull swaggerapi/swagger-editor docker run -p 9090:8080 swaggerapi/swagger-editor ``` Then navigate to localhost:9090 in your browser. I have not been able to get the file upload to work. It is a bit of a PITA, but I copy-paste the source code, replacing what is in the editor. Then make any fixes. Then copy-paste the resulting, valid file back into our source code. Not elegant, but easier than playing detective with the swagger-codegen errors. This might be something about my browser or environment, so give it a try yourself and see how it goes. ## Merging the DRS standard swagger into this swagger ## The merging is done in three sections:  1. Merging the security definitions into our security definitions  2. This section of paths. We make all paths explicit (prefixed with /ga4gh/drs/v1)     All standard DRS definitions and parameters are prefixed with 'DRS' to separate them     from our native definitions and parameters. We remove the x-swagger-router-controller lines.  3. A separate part of the definitions section for the DRS definitions  NOTE: the code here does not relect the DRS spec anymore. See DR-409.   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class SnapshotSummaryModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'name': 'str',
        'description': 'str',
        'created_date': 'str',
        'profile_id': 'str',
        'storage': 'list[StorageResourceModel]',
        'secure_monitoring_enabled': 'bool',
        'cloud_platform': 'CloudPlatform',
        'data_projects': 'str',
        'storage_accounts': 'str'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'created_date': 'createdDate',
        'profile_id': 'profileId',
        'storage': 'storage',
        'secure_monitoring_enabled': 'secureMonitoringEnabled',
        'cloud_platform': 'cloudPlatform',
        'data_projects': 'dataProjects',
        'storage_accounts': 'storageAccounts'
    }

    def __init__(self, id=None, name=None, description=None, created_date=None, profile_id=None, storage=None, secure_monitoring_enabled=False, cloud_platform=None, data_projects=None, storage_accounts=None, local_vars_configuration=None):  # noqa: E501
        """SnapshotSummaryModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._name = None
        self._description = None
        self._created_date = None
        self._profile_id = None
        self._storage = None
        self._secure_monitoring_enabled = None
        self._cloud_platform = None
        self._data_projects = None
        self._storage_accounts = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        if created_date is not None:
            self.created_date = created_date
        if profile_id is not None:
            self.profile_id = profile_id
        if storage is not None:
            self.storage = storage
        if secure_monitoring_enabled is not None:
            self.secure_monitoring_enabled = secure_monitoring_enabled
        if cloud_platform is not None:
            self.cloud_platform = cloud_platform
        if data_projects is not None:
            self.data_projects = data_projects
        if storage_accounts is not None:
            self.storage_accounts = storage_accounts

    @property
    def id(self):
        """Gets the id of this SnapshotSummaryModel.  # noqa: E501

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :return: The id of this SnapshotSummaryModel.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this SnapshotSummaryModel.

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :param id: The id of this SnapshotSummaryModel.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this SnapshotSummaryModel.  # noqa: E501

        Dataset and snapshot names follow this pattern. It is the same as ObjectNameProperty, but has a greater maxLength.   # noqa: E501

        :return: The name of this SnapshotSummaryModel.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this SnapshotSummaryModel.

        Dataset and snapshot names follow this pattern. It is the same as ObjectNameProperty, but has a greater maxLength.   # noqa: E501

        :param name: The name of this SnapshotSummaryModel.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 511):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `511`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) < 1):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and not re.search(r'^[a-zA-Z0-9][_a-zA-Z0-9]*$', name)):  # noqa: E501
            raise ValueError(r"Invalid value for `name`, must be a follow pattern or equal to `/^[a-zA-Z0-9][_a-zA-Z0-9]*$/`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this SnapshotSummaryModel.  # noqa: E501

        Description of the snapshot  # noqa: E501

        :return: The description of this SnapshotSummaryModel.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this SnapshotSummaryModel.

        Description of the snapshot  # noqa: E501

        :param description: The description of this SnapshotSummaryModel.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def created_date(self):
        """Gets the created_date of this SnapshotSummaryModel.  # noqa: E501

        Date the snapshot was created  # noqa: E501

        :return: The created_date of this SnapshotSummaryModel.  # noqa: E501
        :rtype: str
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date):
        """Sets the created_date of this SnapshotSummaryModel.

        Date the snapshot was created  # noqa: E501

        :param created_date: The created_date of this SnapshotSummaryModel.  # noqa: E501
        :type: str
        """

        self._created_date = created_date

    @property
    def profile_id(self):
        """Gets the profile_id of this SnapshotSummaryModel.  # noqa: E501

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :return: The profile_id of this SnapshotSummaryModel.  # noqa: E501
        :rtype: str
        """
        return self._profile_id

    @profile_id.setter
    def profile_id(self, profile_id):
        """Sets the profile_id of this SnapshotSummaryModel.

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :param profile_id: The profile_id of this SnapshotSummaryModel.  # noqa: E501
        :type: str
        """

        self._profile_id = profile_id

    @property
    def storage(self):
        """Gets the storage of this SnapshotSummaryModel.  # noqa: E501


        :return: The storage of this SnapshotSummaryModel.  # noqa: E501
        :rtype: list[StorageResourceModel]
        """
        return self._storage

    @storage.setter
    def storage(self, storage):
        """Sets the storage of this SnapshotSummaryModel.


        :param storage: The storage of this SnapshotSummaryModel.  # noqa: E501
        :type: list[StorageResourceModel]
        """

        self._storage = storage

    @property
    def secure_monitoring_enabled(self):
        """Gets the secure_monitoring_enabled of this SnapshotSummaryModel.  # noqa: E501


        :return: The secure_monitoring_enabled of this SnapshotSummaryModel.  # noqa: E501
        :rtype: bool
        """
        return self._secure_monitoring_enabled

    @secure_monitoring_enabled.setter
    def secure_monitoring_enabled(self, secure_monitoring_enabled):
        """Sets the secure_monitoring_enabled of this SnapshotSummaryModel.


        :param secure_monitoring_enabled: The secure_monitoring_enabled of this SnapshotSummaryModel.  # noqa: E501
        :type: bool
        """

        self._secure_monitoring_enabled = secure_monitoring_enabled

    @property
    def cloud_platform(self):
        """Gets the cloud_platform of this SnapshotSummaryModel.  # noqa: E501


        :return: The cloud_platform of this SnapshotSummaryModel.  # noqa: E501
        :rtype: CloudPlatform
        """
        return self._cloud_platform

    @cloud_platform.setter
    def cloud_platform(self, cloud_platform):
        """Sets the cloud_platform of this SnapshotSummaryModel.


        :param cloud_platform: The cloud_platform of this SnapshotSummaryModel.  # noqa: E501
        :type: CloudPlatform
        """

        self._cloud_platform = cloud_platform

    @property
    def data_projects(self):
        """Gets the data_projects of this SnapshotSummaryModel.  # noqa: E501

        The google projects of this dataset  # noqa: E501

        :return: The data_projects of this SnapshotSummaryModel.  # noqa: E501
        :rtype: str
        """
        return self._data_projects

    @data_projects.setter
    def data_projects(self, data_projects):
        """Sets the data_projects of this SnapshotSummaryModel.

        The google projects of this dataset  # noqa: E501

        :param data_projects: The data_projects of this SnapshotSummaryModel.  # noqa: E501
        :type: str
        """

        self._data_projects = data_projects

    @property
    def storage_accounts(self):
        """Gets the storage_accounts of this SnapshotSummaryModel.  # noqa: E501

        The azure storage accounts of this dataset  # noqa: E501

        :return: The storage_accounts of this SnapshotSummaryModel.  # noqa: E501
        :rtype: str
        """
        return self._storage_accounts

    @storage_accounts.setter
    def storage_accounts(self, storage_accounts):
        """Sets the storage_accounts of this SnapshotSummaryModel.

        The azure storage accounts of this dataset  # noqa: E501

        :param storage_accounts: The storage_accounts of this SnapshotSummaryModel.  # noqa: E501
        :type: str
        """

        self._storage_accounts = storage_accounts

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SnapshotSummaryModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SnapshotSummaryModel):
            return True

        return self.to_dict() != other.to_dict()
