# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetGroupBillableMemberMembershipsResult',
    'AwaitableGetGroupBillableMemberMembershipsResult',
    'get_group_billable_member_memberships',
    'get_group_billable_member_memberships_output',
]

@pulumi.output_type
class GetGroupBillableMemberMembershipsResult:
    """
    A collection of values returned by getGroupBillableMemberMemberships.
    """
    def __init__(__self__, group_id=None, id=None, memberships=None, user_id=None):
        if group_id and not isinstance(group_id, str):
            raise TypeError("Expected argument 'group_id' to be a str")
        pulumi.set(__self__, "group_id", group_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if memberships and not isinstance(memberships, list):
            raise TypeError("Expected argument 'memberships' to be a list")
        pulumi.set(__self__, "memberships", memberships)
        if user_id and not isinstance(user_id, int):
            raise TypeError("Expected argument 'user_id' to be a int")
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        """
        The ID of the group.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the data source. It will always be equal to the user_id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def memberships(self) -> Sequence['outputs.GetGroupBillableMemberMembershipsMembershipResult']:
        """
        group- and/or project-memberships of the user.
        """
        return pulumi.get(self, "memberships")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> int:
        """
        The ID of the user.
        """
        return pulumi.get(self, "user_id")


class AwaitableGetGroupBillableMemberMembershipsResult(GetGroupBillableMemberMembershipsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGroupBillableMemberMembershipsResult(
            group_id=self.group_id,
            id=self.id,
            memberships=self.memberships,
            user_id=self.user_id)


def get_group_billable_member_memberships(group_id: Optional[str] = None,
                                          user_id: Optional[int] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGroupBillableMemberMembershipsResult:
    """
    The `get_group_billable_member_memberships` data source allows (sub)group- and project-memberships of a billable member of a group to be retrieved by either the user ID, username or email address.

    > You must be an administrator!

    > When using the `email` attribute, an exact match is not guaranteed. The most related match will be returned. Starting with GitLab 16.6,
    the most related match will prioritize an exact match if one is available.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/members.html#list-memberships-for-a-billable-member-of-a-group)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    test_user_membership = gitlab.get_group_billable_member_memberships(user_id=21,
        group_id="42")
    ```


    :param str group_id: The ID of the group.
    :param int user_id: The ID of the user.
    """
    __args__ = dict()
    __args__['groupId'] = group_id
    __args__['userId'] = user_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gitlab:index/getGroupBillableMemberMemberships:getGroupBillableMemberMemberships', __args__, opts=opts, typ=GetGroupBillableMemberMembershipsResult).value

    return AwaitableGetGroupBillableMemberMembershipsResult(
        group_id=pulumi.get(__ret__, 'group_id'),
        id=pulumi.get(__ret__, 'id'),
        memberships=pulumi.get(__ret__, 'memberships'),
        user_id=pulumi.get(__ret__, 'user_id'))
def get_group_billable_member_memberships_output(group_id: Optional[pulumi.Input[str]] = None,
                                                 user_id: Optional[pulumi.Input[int]] = None,
                                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGroupBillableMemberMembershipsResult]:
    """
    The `get_group_billable_member_memberships` data source allows (sub)group- and project-memberships of a billable member of a group to be retrieved by either the user ID, username or email address.

    > You must be an administrator!

    > When using the `email` attribute, an exact match is not guaranteed. The most related match will be returned. Starting with GitLab 16.6,
    the most related match will prioritize an exact match if one is available.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/members.html#list-memberships-for-a-billable-member-of-a-group)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    test_user_membership = gitlab.get_group_billable_member_memberships(user_id=21,
        group_id="42")
    ```


    :param str group_id: The ID of the group.
    :param int user_id: The ID of the user.
    """
    __args__ = dict()
    __args__['groupId'] = group_id
    __args__['userId'] = user_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gitlab:index/getGroupBillableMemberMemberships:getGroupBillableMemberMemberships', __args__, opts=opts, typ=GetGroupBillableMemberMembershipsResult)
    return __ret__.apply(lambda __response__: GetGroupBillableMemberMembershipsResult(
        group_id=pulumi.get(__response__, 'group_id'),
        id=pulumi.get(__response__, 'id'),
        memberships=pulumi.get(__response__, 'memberships'),
        user_id=pulumi.get(__response__, 'user_id')))
