# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetProjectMembershipResult',
    'AwaitableGetProjectMembershipResult',
    'get_project_membership',
    'get_project_membership_output',
]

@pulumi.output_type
class GetProjectMembershipResult:
    """
    A collection of values returned by getProjectMembership.
    """
    def __init__(__self__, full_path=None, id=None, inherited=None, members=None, project_id=None, query=None, user_ids=None):
        if full_path and not isinstance(full_path, str):
            raise TypeError("Expected argument 'full_path' to be a str")
        pulumi.set(__self__, "full_path", full_path)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if inherited and not isinstance(inherited, bool):
            raise TypeError("Expected argument 'inherited' to be a bool")
        pulumi.set(__self__, "inherited", inherited)
        if members and not isinstance(members, list):
            raise TypeError("Expected argument 'members' to be a list")
        pulumi.set(__self__, "members", members)
        if project_id and not isinstance(project_id, int):
            raise TypeError("Expected argument 'project_id' to be a int")
        pulumi.set(__self__, "project_id", project_id)
        if query and not isinstance(query, str):
            raise TypeError("Expected argument 'query' to be a str")
        pulumi.set(__self__, "query", query)
        if user_ids and not isinstance(user_ids, list):
            raise TypeError("Expected argument 'user_ids' to be a list")
        pulumi.set(__self__, "user_ids", user_ids)

    @property
    @pulumi.getter(name="fullPath")
    def full_path(self) -> str:
        """
        The full path of the project.
        """
        return pulumi.get(self, "full_path")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def inherited(self) -> Optional[bool]:
        """
        Return all project members including members through ancestor groups
        """
        return pulumi.get(self, "inherited")

    @property
    @pulumi.getter
    def members(self) -> Sequence['outputs.GetProjectMembershipMemberResult']:
        """
        The list of project members.
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> int:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def query(self) -> Optional[str]:
        """
        A query string to search for members
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="userIds")
    def user_ids(self) -> Optional[Sequence[int]]:
        """
        List of user ids to filter members by
        """
        return pulumi.get(self, "user_ids")


class AwaitableGetProjectMembershipResult(GetProjectMembershipResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectMembershipResult(
            full_path=self.full_path,
            id=self.id,
            inherited=self.inherited,
            members=self.members,
            project_id=self.project_id,
            query=self.query,
            user_ids=self.user_ids)


def get_project_membership(full_path: Optional[str] = None,
                           inherited: Optional[bool] = None,
                           project_id: Optional[int] = None,
                           query: Optional[str] = None,
                           user_ids: Optional[Sequence[int]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectMembershipResult:
    """
    The `ProjectMembership` data source allows to list and filter all members of a project specified by either its id or full path.

    > **Note** exactly one of project_id or full_path must be provided.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/members.html#list-all-members-of-a-group-or-project)


    :param str full_path: The full path of the project.
    :param bool inherited: Return all project members including members through ancestor groups
    :param int project_id: The ID of the project.
    :param str query: A query string to search for members
    :param Sequence[int] user_ids: List of user ids to filter members by
    """
    __args__ = dict()
    __args__['fullPath'] = full_path
    __args__['inherited'] = inherited
    __args__['projectId'] = project_id
    __args__['query'] = query
    __args__['userIds'] = user_ids
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gitlab:index/getProjectMembership:getProjectMembership', __args__, opts=opts, typ=GetProjectMembershipResult).value

    return AwaitableGetProjectMembershipResult(
        full_path=pulumi.get(__ret__, 'full_path'),
        id=pulumi.get(__ret__, 'id'),
        inherited=pulumi.get(__ret__, 'inherited'),
        members=pulumi.get(__ret__, 'members'),
        project_id=pulumi.get(__ret__, 'project_id'),
        query=pulumi.get(__ret__, 'query'),
        user_ids=pulumi.get(__ret__, 'user_ids'))
def get_project_membership_output(full_path: Optional[pulumi.Input[Optional[str]]] = None,
                                  inherited: Optional[pulumi.Input[Optional[bool]]] = None,
                                  project_id: Optional[pulumi.Input[Optional[int]]] = None,
                                  query: Optional[pulumi.Input[Optional[str]]] = None,
                                  user_ids: Optional[pulumi.Input[Optional[Sequence[int]]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProjectMembershipResult]:
    """
    The `ProjectMembership` data source allows to list and filter all members of a project specified by either its id or full path.

    > **Note** exactly one of project_id or full_path must be provided.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/members.html#list-all-members-of-a-group-or-project)


    :param str full_path: The full path of the project.
    :param bool inherited: Return all project members including members through ancestor groups
    :param int project_id: The ID of the project.
    :param str query: A query string to search for members
    :param Sequence[int] user_ids: List of user ids to filter members by
    """
    __args__ = dict()
    __args__['fullPath'] = full_path
    __args__['inherited'] = inherited
    __args__['projectId'] = project_id
    __args__['query'] = query
    __args__['userIds'] = user_ids
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gitlab:index/getProjectMembership:getProjectMembership', __args__, opts=opts, typ=GetProjectMembershipResult)
    return __ret__.apply(lambda __response__: GetProjectMembershipResult(
        full_path=pulumi.get(__response__, 'full_path'),
        id=pulumi.get(__response__, 'id'),
        inherited=pulumi.get(__response__, 'inherited'),
        members=pulumi.get(__response__, 'members'),
        project_id=pulumi.get(__response__, 'project_id'),
        query=pulumi.get(__response__, 'query'),
        user_ids=pulumi.get(__response__, 'user_ids')))
