# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GroupCustomAttributeArgs', 'GroupCustomAttribute']

@pulumi.input_type
class GroupCustomAttributeArgs:
    def __init__(__self__, *,
                 group: pulumi.Input[int],
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        The set of arguments for constructing a GroupCustomAttribute resource.
        :param pulumi.Input[int] group: The id of the group.
        :param pulumi.Input[str] key: Key for the Custom Attribute.
        :param pulumi.Input[str] value: Value for the Custom Attribute.
        """
        pulumi.set(__self__, "group", group)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def group(self) -> pulumi.Input[int]:
        """
        The id of the group.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: pulumi.Input[int]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        Key for the Custom Attribute.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Value for the Custom Attribute.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class _GroupCustomAttributeState:
    def __init__(__self__, *,
                 group: Optional[pulumi.Input[int]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering GroupCustomAttribute resources.
        :param pulumi.Input[int] group: The id of the group.
        :param pulumi.Input[str] key: Key for the Custom Attribute.
        :param pulumi.Input[str] value: Value for the Custom Attribute.
        """
        if group is not None:
            pulumi.set(__self__, "group", group)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[int]]:
        """
        The id of the group.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Key for the Custom Attribute.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value for the Custom Attribute.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


class GroupCustomAttribute(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group: Optional[pulumi.Input[int]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The `GroupCustomAttribute` resource allows to manage custom attributes for a group.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/custom_attributes.html)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        attr = gitlab.GroupCustomAttribute("attr",
            group=42,
            key="location",
            value="Greenland")
        ```

        ## Import

        Starting in Terraform v1.5.0 you can use an import block to import `gitlab_group_custom_attribute`. For example:

        terraform

        import {

          to = gitlab_group_custom_attribute.example

          id = "see CLI command below for ID"

        }

        Import using the CLI is supported using the following syntax:

        You can import a group custom attribute using the an id made up of `{group-id}:{key}`, e.g.

        ```sh
        $ pulumi import gitlab:index/groupCustomAttribute:GroupCustomAttribute attr 42:location
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] group: The id of the group.
        :param pulumi.Input[str] key: Key for the Custom Attribute.
        :param pulumi.Input[str] value: Value for the Custom Attribute.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GroupCustomAttributeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `GroupCustomAttribute` resource allows to manage custom attributes for a group.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/custom_attributes.html)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        attr = gitlab.GroupCustomAttribute("attr",
            group=42,
            key="location",
            value="Greenland")
        ```

        ## Import

        Starting in Terraform v1.5.0 you can use an import block to import `gitlab_group_custom_attribute`. For example:

        terraform

        import {

          to = gitlab_group_custom_attribute.example

          id = "see CLI command below for ID"

        }

        Import using the CLI is supported using the following syntax:

        You can import a group custom attribute using the an id made up of `{group-id}:{key}`, e.g.

        ```sh
        $ pulumi import gitlab:index/groupCustomAttribute:GroupCustomAttribute attr 42:location
        ```

        :param str resource_name: The name of the resource.
        :param GroupCustomAttributeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupCustomAttributeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group: Optional[pulumi.Input[int]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupCustomAttributeArgs.__new__(GroupCustomAttributeArgs)

            if group is None and not opts.urn:
                raise TypeError("Missing required property 'group'")
            __props__.__dict__["group"] = group
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
        super(GroupCustomAttribute, __self__).__init__(
            'gitlab:index/groupCustomAttribute:GroupCustomAttribute',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group: Optional[pulumi.Input[int]] = None,
            key: Optional[pulumi.Input[str]] = None,
            value: Optional[pulumi.Input[str]] = None) -> 'GroupCustomAttribute':
        """
        Get an existing GroupCustomAttribute resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] group: The id of the group.
        :param pulumi.Input[str] key: Key for the Custom Attribute.
        :param pulumi.Input[str] value: Value for the Custom Attribute.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupCustomAttributeState.__new__(_GroupCustomAttributeState)

        __props__.__dict__["group"] = group
        __props__.__dict__["key"] = key
        __props__.__dict__["value"] = value
        return GroupCustomAttribute(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def group(self) -> pulumi.Output[int]:
        """
        The id of the group.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[str]:
        """
        Key for the Custom Attribute.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[str]:
        """
        Value for the Custom Attribute.
        """
        return pulumi.get(self, "value")

