# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['IntegrationTelegramArgs', 'IntegrationTelegram']

@pulumi.input_type
class IntegrationTelegramArgs:
    def __init__(__self__, *,
                 confidential_issues_events: pulumi.Input[bool],
                 confidential_note_events: pulumi.Input[bool],
                 issues_events: pulumi.Input[bool],
                 merge_requests_events: pulumi.Input[bool],
                 note_events: pulumi.Input[bool],
                 pipeline_events: pulumi.Input[bool],
                 project: pulumi.Input[str],
                 push_events: pulumi.Input[bool],
                 room: pulumi.Input[str],
                 tag_push_events: pulumi.Input[bool],
                 token: pulumi.Input[str],
                 wiki_page_events: pulumi.Input[bool],
                 branches_to_be_notified: Optional[pulumi.Input[str]] = None,
                 notify_only_broken_pipelines: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a IntegrationTelegram resource.
        :param pulumi.Input[bool] confidential_issues_events: Enable notifications for confidential issues events.
        :param pulumi.Input[bool] confidential_note_events: Enable notifications for confidential note events.
        :param pulumi.Input[bool] issues_events: Enable notifications for issues events.
        :param pulumi.Input[bool] merge_requests_events: Enable notifications for merge requests events.
        :param pulumi.Input[bool] note_events: Enable notifications for note events.
        :param pulumi.Input[bool] pipeline_events: Enable notifications for pipeline events.
        :param pulumi.Input[str] project: The ID or full path of the project to integrate with Telegram.
        :param pulumi.Input[bool] push_events: Enable notifications for push events.
        :param pulumi.Input[str] room: Unique identifier for the target chat or the username of the target channel (in the format `@channelusername`)
        :param pulumi.Input[bool] tag_push_events: Enable notifications for tag push events.
        :param pulumi.Input[str] token: The Telegram bot token.
        :param pulumi.Input[bool] wiki_page_events: Enable notifications for wiki page events.
        :param pulumi.Input[str] branches_to_be_notified: Branches to send notifications for (introduced in GitLab 16.5). Update of this attribute was not supported before Gitlab 16.11 due to API bug. Valid options are `all`, `default`, `protected`, `default_and_protected`.
        :param pulumi.Input[bool] notify_only_broken_pipelines: Send notifications for broken pipelines.
        """
        pulumi.set(__self__, "confidential_issues_events", confidential_issues_events)
        pulumi.set(__self__, "confidential_note_events", confidential_note_events)
        pulumi.set(__self__, "issues_events", issues_events)
        pulumi.set(__self__, "merge_requests_events", merge_requests_events)
        pulumi.set(__self__, "note_events", note_events)
        pulumi.set(__self__, "pipeline_events", pipeline_events)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "push_events", push_events)
        pulumi.set(__self__, "room", room)
        pulumi.set(__self__, "tag_push_events", tag_push_events)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "wiki_page_events", wiki_page_events)
        if branches_to_be_notified is not None:
            pulumi.set(__self__, "branches_to_be_notified", branches_to_be_notified)
        if notify_only_broken_pipelines is not None:
            pulumi.set(__self__, "notify_only_broken_pipelines", notify_only_broken_pipelines)

    @property
    @pulumi.getter(name="confidentialIssuesEvents")
    def confidential_issues_events(self) -> pulumi.Input[bool]:
        """
        Enable notifications for confidential issues events.
        """
        return pulumi.get(self, "confidential_issues_events")

    @confidential_issues_events.setter
    def confidential_issues_events(self, value: pulumi.Input[bool]):
        pulumi.set(self, "confidential_issues_events", value)

    @property
    @pulumi.getter(name="confidentialNoteEvents")
    def confidential_note_events(self) -> pulumi.Input[bool]:
        """
        Enable notifications for confidential note events.
        """
        return pulumi.get(self, "confidential_note_events")

    @confidential_note_events.setter
    def confidential_note_events(self, value: pulumi.Input[bool]):
        pulumi.set(self, "confidential_note_events", value)

    @property
    @pulumi.getter(name="issuesEvents")
    def issues_events(self) -> pulumi.Input[bool]:
        """
        Enable notifications for issues events.
        """
        return pulumi.get(self, "issues_events")

    @issues_events.setter
    def issues_events(self, value: pulumi.Input[bool]):
        pulumi.set(self, "issues_events", value)

    @property
    @pulumi.getter(name="mergeRequestsEvents")
    def merge_requests_events(self) -> pulumi.Input[bool]:
        """
        Enable notifications for merge requests events.
        """
        return pulumi.get(self, "merge_requests_events")

    @merge_requests_events.setter
    def merge_requests_events(self, value: pulumi.Input[bool]):
        pulumi.set(self, "merge_requests_events", value)

    @property
    @pulumi.getter(name="noteEvents")
    def note_events(self) -> pulumi.Input[bool]:
        """
        Enable notifications for note events.
        """
        return pulumi.get(self, "note_events")

    @note_events.setter
    def note_events(self, value: pulumi.Input[bool]):
        pulumi.set(self, "note_events", value)

    @property
    @pulumi.getter(name="pipelineEvents")
    def pipeline_events(self) -> pulumi.Input[bool]:
        """
        Enable notifications for pipeline events.
        """
        return pulumi.get(self, "pipeline_events")

    @pipeline_events.setter
    def pipeline_events(self, value: pulumi.Input[bool]):
        pulumi.set(self, "pipeline_events", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        The ID or full path of the project to integrate with Telegram.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pushEvents")
    def push_events(self) -> pulumi.Input[bool]:
        """
        Enable notifications for push events.
        """
        return pulumi.get(self, "push_events")

    @push_events.setter
    def push_events(self, value: pulumi.Input[bool]):
        pulumi.set(self, "push_events", value)

    @property
    @pulumi.getter
    def room(self) -> pulumi.Input[str]:
        """
        Unique identifier for the target chat or the username of the target channel (in the format `@channelusername`)
        """
        return pulumi.get(self, "room")

    @room.setter
    def room(self, value: pulumi.Input[str]):
        pulumi.set(self, "room", value)

    @property
    @pulumi.getter(name="tagPushEvents")
    def tag_push_events(self) -> pulumi.Input[bool]:
        """
        Enable notifications for tag push events.
        """
        return pulumi.get(self, "tag_push_events")

    @tag_push_events.setter
    def tag_push_events(self, value: pulumi.Input[bool]):
        pulumi.set(self, "tag_push_events", value)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[str]:
        """
        The Telegram bot token.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[str]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter(name="wikiPageEvents")
    def wiki_page_events(self) -> pulumi.Input[bool]:
        """
        Enable notifications for wiki page events.
        """
        return pulumi.get(self, "wiki_page_events")

    @wiki_page_events.setter
    def wiki_page_events(self, value: pulumi.Input[bool]):
        pulumi.set(self, "wiki_page_events", value)

    @property
    @pulumi.getter(name="branchesToBeNotified")
    def branches_to_be_notified(self) -> Optional[pulumi.Input[str]]:
        """
        Branches to send notifications for (introduced in GitLab 16.5). Update of this attribute was not supported before Gitlab 16.11 due to API bug. Valid options are `all`, `default`, `protected`, `default_and_protected`.
        """
        return pulumi.get(self, "branches_to_be_notified")

    @branches_to_be_notified.setter
    def branches_to_be_notified(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branches_to_be_notified", value)

    @property
    @pulumi.getter(name="notifyOnlyBrokenPipelines")
    def notify_only_broken_pipelines(self) -> Optional[pulumi.Input[bool]]:
        """
        Send notifications for broken pipelines.
        """
        return pulumi.get(self, "notify_only_broken_pipelines")

    @notify_only_broken_pipelines.setter
    def notify_only_broken_pipelines(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "notify_only_broken_pipelines", value)


@pulumi.input_type
class _IntegrationTelegramState:
    def __init__(__self__, *,
                 branches_to_be_notified: Optional[pulumi.Input[str]] = None,
                 confidential_issues_events: Optional[pulumi.Input[bool]] = None,
                 confidential_note_events: Optional[pulumi.Input[bool]] = None,
                 issues_events: Optional[pulumi.Input[bool]] = None,
                 merge_requests_events: Optional[pulumi.Input[bool]] = None,
                 note_events: Optional[pulumi.Input[bool]] = None,
                 notify_only_broken_pipelines: Optional[pulumi.Input[bool]] = None,
                 pipeline_events: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 push_events: Optional[pulumi.Input[bool]] = None,
                 room: Optional[pulumi.Input[str]] = None,
                 tag_push_events: Optional[pulumi.Input[bool]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 wiki_page_events: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering IntegrationTelegram resources.
        :param pulumi.Input[str] branches_to_be_notified: Branches to send notifications for (introduced in GitLab 16.5). Update of this attribute was not supported before Gitlab 16.11 due to API bug. Valid options are `all`, `default`, `protected`, `default_and_protected`.
        :param pulumi.Input[bool] confidential_issues_events: Enable notifications for confidential issues events.
        :param pulumi.Input[bool] confidential_note_events: Enable notifications for confidential note events.
        :param pulumi.Input[bool] issues_events: Enable notifications for issues events.
        :param pulumi.Input[bool] merge_requests_events: Enable notifications for merge requests events.
        :param pulumi.Input[bool] note_events: Enable notifications for note events.
        :param pulumi.Input[bool] notify_only_broken_pipelines: Send notifications for broken pipelines.
        :param pulumi.Input[bool] pipeline_events: Enable notifications for pipeline events.
        :param pulumi.Input[str] project: The ID or full path of the project to integrate with Telegram.
        :param pulumi.Input[bool] push_events: Enable notifications for push events.
        :param pulumi.Input[str] room: Unique identifier for the target chat or the username of the target channel (in the format `@channelusername`)
        :param pulumi.Input[bool] tag_push_events: Enable notifications for tag push events.
        :param pulumi.Input[str] token: The Telegram bot token.
        :param pulumi.Input[bool] wiki_page_events: Enable notifications for wiki page events.
        """
        if branches_to_be_notified is not None:
            pulumi.set(__self__, "branches_to_be_notified", branches_to_be_notified)
        if confidential_issues_events is not None:
            pulumi.set(__self__, "confidential_issues_events", confidential_issues_events)
        if confidential_note_events is not None:
            pulumi.set(__self__, "confidential_note_events", confidential_note_events)
        if issues_events is not None:
            pulumi.set(__self__, "issues_events", issues_events)
        if merge_requests_events is not None:
            pulumi.set(__self__, "merge_requests_events", merge_requests_events)
        if note_events is not None:
            pulumi.set(__self__, "note_events", note_events)
        if notify_only_broken_pipelines is not None:
            pulumi.set(__self__, "notify_only_broken_pipelines", notify_only_broken_pipelines)
        if pipeline_events is not None:
            pulumi.set(__self__, "pipeline_events", pipeline_events)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if push_events is not None:
            pulumi.set(__self__, "push_events", push_events)
        if room is not None:
            pulumi.set(__self__, "room", room)
        if tag_push_events is not None:
            pulumi.set(__self__, "tag_push_events", tag_push_events)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if wiki_page_events is not None:
            pulumi.set(__self__, "wiki_page_events", wiki_page_events)

    @property
    @pulumi.getter(name="branchesToBeNotified")
    def branches_to_be_notified(self) -> Optional[pulumi.Input[str]]:
        """
        Branches to send notifications for (introduced in GitLab 16.5). Update of this attribute was not supported before Gitlab 16.11 due to API bug. Valid options are `all`, `default`, `protected`, `default_and_protected`.
        """
        return pulumi.get(self, "branches_to_be_notified")

    @branches_to_be_notified.setter
    def branches_to_be_notified(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branches_to_be_notified", value)

    @property
    @pulumi.getter(name="confidentialIssuesEvents")
    def confidential_issues_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for confidential issues events.
        """
        return pulumi.get(self, "confidential_issues_events")

    @confidential_issues_events.setter
    def confidential_issues_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "confidential_issues_events", value)

    @property
    @pulumi.getter(name="confidentialNoteEvents")
    def confidential_note_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for confidential note events.
        """
        return pulumi.get(self, "confidential_note_events")

    @confidential_note_events.setter
    def confidential_note_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "confidential_note_events", value)

    @property
    @pulumi.getter(name="issuesEvents")
    def issues_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for issues events.
        """
        return pulumi.get(self, "issues_events")

    @issues_events.setter
    def issues_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "issues_events", value)

    @property
    @pulumi.getter(name="mergeRequestsEvents")
    def merge_requests_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for merge requests events.
        """
        return pulumi.get(self, "merge_requests_events")

    @merge_requests_events.setter
    def merge_requests_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "merge_requests_events", value)

    @property
    @pulumi.getter(name="noteEvents")
    def note_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for note events.
        """
        return pulumi.get(self, "note_events")

    @note_events.setter
    def note_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "note_events", value)

    @property
    @pulumi.getter(name="notifyOnlyBrokenPipelines")
    def notify_only_broken_pipelines(self) -> Optional[pulumi.Input[bool]]:
        """
        Send notifications for broken pipelines.
        """
        return pulumi.get(self, "notify_only_broken_pipelines")

    @notify_only_broken_pipelines.setter
    def notify_only_broken_pipelines(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "notify_only_broken_pipelines", value)

    @property
    @pulumi.getter(name="pipelineEvents")
    def pipeline_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for pipeline events.
        """
        return pulumi.get(self, "pipeline_events")

    @pipeline_events.setter
    def pipeline_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pipeline_events", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID or full path of the project to integrate with Telegram.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pushEvents")
    def push_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for push events.
        """
        return pulumi.get(self, "push_events")

    @push_events.setter
    def push_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "push_events", value)

    @property
    @pulumi.getter
    def room(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier for the target chat or the username of the target channel (in the format `@channelusername`)
        """
        return pulumi.get(self, "room")

    @room.setter
    def room(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "room", value)

    @property
    @pulumi.getter(name="tagPushEvents")
    def tag_push_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for tag push events.
        """
        return pulumi.get(self, "tag_push_events")

    @tag_push_events.setter
    def tag_push_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tag_push_events", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        The Telegram bot token.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter(name="wikiPageEvents")
    def wiki_page_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for wiki page events.
        """
        return pulumi.get(self, "wiki_page_events")

    @wiki_page_events.setter
    def wiki_page_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wiki_page_events", value)


class IntegrationTelegram(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 branches_to_be_notified: Optional[pulumi.Input[str]] = None,
                 confidential_issues_events: Optional[pulumi.Input[bool]] = None,
                 confidential_note_events: Optional[pulumi.Input[bool]] = None,
                 issues_events: Optional[pulumi.Input[bool]] = None,
                 merge_requests_events: Optional[pulumi.Input[bool]] = None,
                 note_events: Optional[pulumi.Input[bool]] = None,
                 notify_only_broken_pipelines: Optional[pulumi.Input[bool]] = None,
                 pipeline_events: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 push_events: Optional[pulumi.Input[bool]] = None,
                 room: Optional[pulumi.Input[str]] = None,
                 tag_push_events: Optional[pulumi.Input[bool]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 wiki_page_events: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        The `IntegrationTelegram` resource allows to manage the lifecycle of a project integration with Telegram.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/integrations.html#telegram)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        awesome_project = gitlab.Project("awesome_project",
            name="awesome_project",
            description="My awesome project.",
            visibility_level="public")
        default = gitlab.IntegrationTelegram("default",
            token="123456:ABC-DEF1234ghIkl-zyx57W2v1u123ew11",
            room="-1000000000000000",
            notify_only_broken_pipelines=False,
            branches_to_be_notified="all",
            push_events=False,
            issues_events=False,
            confidential_issues_events=False,
            merge_requests_events=False,
            tag_push_events=False,
            note_events=False,
            confidential_note_events=False,
            pipeline_events=False,
            wiki_page_events=False)
        ```

        ## Import

        Starting in Terraform v1.5.0 you can use an import block to import `gitlab_integration_telegram`. For example:

        terraform

        import {

          to = gitlab_integration_telegram.example

          id = "see CLI command below for ID"

        }

        Import using the CLI is supported using the following syntax:

        You can import a gitlab_integration_telegram state using the project ID, e.g.

        ```sh
        $ pulumi import gitlab:index/integrationTelegram:IntegrationTelegram default 1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] branches_to_be_notified: Branches to send notifications for (introduced in GitLab 16.5). Update of this attribute was not supported before Gitlab 16.11 due to API bug. Valid options are `all`, `default`, `protected`, `default_and_protected`.
        :param pulumi.Input[bool] confidential_issues_events: Enable notifications for confidential issues events.
        :param pulumi.Input[bool] confidential_note_events: Enable notifications for confidential note events.
        :param pulumi.Input[bool] issues_events: Enable notifications for issues events.
        :param pulumi.Input[bool] merge_requests_events: Enable notifications for merge requests events.
        :param pulumi.Input[bool] note_events: Enable notifications for note events.
        :param pulumi.Input[bool] notify_only_broken_pipelines: Send notifications for broken pipelines.
        :param pulumi.Input[bool] pipeline_events: Enable notifications for pipeline events.
        :param pulumi.Input[str] project: The ID or full path of the project to integrate with Telegram.
        :param pulumi.Input[bool] push_events: Enable notifications for push events.
        :param pulumi.Input[str] room: Unique identifier for the target chat or the username of the target channel (in the format `@channelusername`)
        :param pulumi.Input[bool] tag_push_events: Enable notifications for tag push events.
        :param pulumi.Input[str] token: The Telegram bot token.
        :param pulumi.Input[bool] wiki_page_events: Enable notifications for wiki page events.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntegrationTelegramArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `IntegrationTelegram` resource allows to manage the lifecycle of a project integration with Telegram.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/integrations.html#telegram)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        awesome_project = gitlab.Project("awesome_project",
            name="awesome_project",
            description="My awesome project.",
            visibility_level="public")
        default = gitlab.IntegrationTelegram("default",
            token="123456:ABC-DEF1234ghIkl-zyx57W2v1u123ew11",
            room="-1000000000000000",
            notify_only_broken_pipelines=False,
            branches_to_be_notified="all",
            push_events=False,
            issues_events=False,
            confidential_issues_events=False,
            merge_requests_events=False,
            tag_push_events=False,
            note_events=False,
            confidential_note_events=False,
            pipeline_events=False,
            wiki_page_events=False)
        ```

        ## Import

        Starting in Terraform v1.5.0 you can use an import block to import `gitlab_integration_telegram`. For example:

        terraform

        import {

          to = gitlab_integration_telegram.example

          id = "see CLI command below for ID"

        }

        Import using the CLI is supported using the following syntax:

        You can import a gitlab_integration_telegram state using the project ID, e.g.

        ```sh
        $ pulumi import gitlab:index/integrationTelegram:IntegrationTelegram default 1
        ```

        :param str resource_name: The name of the resource.
        :param IntegrationTelegramArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationTelegramArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 branches_to_be_notified: Optional[pulumi.Input[str]] = None,
                 confidential_issues_events: Optional[pulumi.Input[bool]] = None,
                 confidential_note_events: Optional[pulumi.Input[bool]] = None,
                 issues_events: Optional[pulumi.Input[bool]] = None,
                 merge_requests_events: Optional[pulumi.Input[bool]] = None,
                 note_events: Optional[pulumi.Input[bool]] = None,
                 notify_only_broken_pipelines: Optional[pulumi.Input[bool]] = None,
                 pipeline_events: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 push_events: Optional[pulumi.Input[bool]] = None,
                 room: Optional[pulumi.Input[str]] = None,
                 tag_push_events: Optional[pulumi.Input[bool]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 wiki_page_events: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationTelegramArgs.__new__(IntegrationTelegramArgs)

            __props__.__dict__["branches_to_be_notified"] = branches_to_be_notified
            if confidential_issues_events is None and not opts.urn:
                raise TypeError("Missing required property 'confidential_issues_events'")
            __props__.__dict__["confidential_issues_events"] = confidential_issues_events
            if confidential_note_events is None and not opts.urn:
                raise TypeError("Missing required property 'confidential_note_events'")
            __props__.__dict__["confidential_note_events"] = confidential_note_events
            if issues_events is None and not opts.urn:
                raise TypeError("Missing required property 'issues_events'")
            __props__.__dict__["issues_events"] = issues_events
            if merge_requests_events is None and not opts.urn:
                raise TypeError("Missing required property 'merge_requests_events'")
            __props__.__dict__["merge_requests_events"] = merge_requests_events
            if note_events is None and not opts.urn:
                raise TypeError("Missing required property 'note_events'")
            __props__.__dict__["note_events"] = note_events
            __props__.__dict__["notify_only_broken_pipelines"] = notify_only_broken_pipelines
            if pipeline_events is None and not opts.urn:
                raise TypeError("Missing required property 'pipeline_events'")
            __props__.__dict__["pipeline_events"] = pipeline_events
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if push_events is None and not opts.urn:
                raise TypeError("Missing required property 'push_events'")
            __props__.__dict__["push_events"] = push_events
            if room is None and not opts.urn:
                raise TypeError("Missing required property 'room'")
            __props__.__dict__["room"] = room
            if tag_push_events is None and not opts.urn:
                raise TypeError("Missing required property 'tag_push_events'")
            __props__.__dict__["tag_push_events"] = tag_push_events
            if token is None and not opts.urn:
                raise TypeError("Missing required property 'token'")
            __props__.__dict__["token"] = None if token is None else pulumi.Output.secret(token)
            if wiki_page_events is None and not opts.urn:
                raise TypeError("Missing required property 'wiki_page_events'")
            __props__.__dict__["wiki_page_events"] = wiki_page_events
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(IntegrationTelegram, __self__).__init__(
            'gitlab:index/integrationTelegram:IntegrationTelegram',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            branches_to_be_notified: Optional[pulumi.Input[str]] = None,
            confidential_issues_events: Optional[pulumi.Input[bool]] = None,
            confidential_note_events: Optional[pulumi.Input[bool]] = None,
            issues_events: Optional[pulumi.Input[bool]] = None,
            merge_requests_events: Optional[pulumi.Input[bool]] = None,
            note_events: Optional[pulumi.Input[bool]] = None,
            notify_only_broken_pipelines: Optional[pulumi.Input[bool]] = None,
            pipeline_events: Optional[pulumi.Input[bool]] = None,
            project: Optional[pulumi.Input[str]] = None,
            push_events: Optional[pulumi.Input[bool]] = None,
            room: Optional[pulumi.Input[str]] = None,
            tag_push_events: Optional[pulumi.Input[bool]] = None,
            token: Optional[pulumi.Input[str]] = None,
            wiki_page_events: Optional[pulumi.Input[bool]] = None) -> 'IntegrationTelegram':
        """
        Get an existing IntegrationTelegram resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] branches_to_be_notified: Branches to send notifications for (introduced in GitLab 16.5). Update of this attribute was not supported before Gitlab 16.11 due to API bug. Valid options are `all`, `default`, `protected`, `default_and_protected`.
        :param pulumi.Input[bool] confidential_issues_events: Enable notifications for confidential issues events.
        :param pulumi.Input[bool] confidential_note_events: Enable notifications for confidential note events.
        :param pulumi.Input[bool] issues_events: Enable notifications for issues events.
        :param pulumi.Input[bool] merge_requests_events: Enable notifications for merge requests events.
        :param pulumi.Input[bool] note_events: Enable notifications for note events.
        :param pulumi.Input[bool] notify_only_broken_pipelines: Send notifications for broken pipelines.
        :param pulumi.Input[bool] pipeline_events: Enable notifications for pipeline events.
        :param pulumi.Input[str] project: The ID or full path of the project to integrate with Telegram.
        :param pulumi.Input[bool] push_events: Enable notifications for push events.
        :param pulumi.Input[str] room: Unique identifier for the target chat or the username of the target channel (in the format `@channelusername`)
        :param pulumi.Input[bool] tag_push_events: Enable notifications for tag push events.
        :param pulumi.Input[str] token: The Telegram bot token.
        :param pulumi.Input[bool] wiki_page_events: Enable notifications for wiki page events.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntegrationTelegramState.__new__(_IntegrationTelegramState)

        __props__.__dict__["branches_to_be_notified"] = branches_to_be_notified
        __props__.__dict__["confidential_issues_events"] = confidential_issues_events
        __props__.__dict__["confidential_note_events"] = confidential_note_events
        __props__.__dict__["issues_events"] = issues_events
        __props__.__dict__["merge_requests_events"] = merge_requests_events
        __props__.__dict__["note_events"] = note_events
        __props__.__dict__["notify_only_broken_pipelines"] = notify_only_broken_pipelines
        __props__.__dict__["pipeline_events"] = pipeline_events
        __props__.__dict__["project"] = project
        __props__.__dict__["push_events"] = push_events
        __props__.__dict__["room"] = room
        __props__.__dict__["tag_push_events"] = tag_push_events
        __props__.__dict__["token"] = token
        __props__.__dict__["wiki_page_events"] = wiki_page_events
        return IntegrationTelegram(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="branchesToBeNotified")
    def branches_to_be_notified(self) -> pulumi.Output[str]:
        """
        Branches to send notifications for (introduced in GitLab 16.5). Update of this attribute was not supported before Gitlab 16.11 due to API bug. Valid options are `all`, `default`, `protected`, `default_and_protected`.
        """
        return pulumi.get(self, "branches_to_be_notified")

    @property
    @pulumi.getter(name="confidentialIssuesEvents")
    def confidential_issues_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for confidential issues events.
        """
        return pulumi.get(self, "confidential_issues_events")

    @property
    @pulumi.getter(name="confidentialNoteEvents")
    def confidential_note_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for confidential note events.
        """
        return pulumi.get(self, "confidential_note_events")

    @property
    @pulumi.getter(name="issuesEvents")
    def issues_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for issues events.
        """
        return pulumi.get(self, "issues_events")

    @property
    @pulumi.getter(name="mergeRequestsEvents")
    def merge_requests_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for merge requests events.
        """
        return pulumi.get(self, "merge_requests_events")

    @property
    @pulumi.getter(name="noteEvents")
    def note_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for note events.
        """
        return pulumi.get(self, "note_events")

    @property
    @pulumi.getter(name="notifyOnlyBrokenPipelines")
    def notify_only_broken_pipelines(self) -> pulumi.Output[bool]:
        """
        Send notifications for broken pipelines.
        """
        return pulumi.get(self, "notify_only_broken_pipelines")

    @property
    @pulumi.getter(name="pipelineEvents")
    def pipeline_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for pipeline events.
        """
        return pulumi.get(self, "pipeline_events")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID or full path of the project to integrate with Telegram.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pushEvents")
    def push_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for push events.
        """
        return pulumi.get(self, "push_events")

    @property
    @pulumi.getter
    def room(self) -> pulumi.Output[str]:
        """
        Unique identifier for the target chat or the username of the target channel (in the format `@channelusername`)
        """
        return pulumi.get(self, "room")

    @property
    @pulumi.getter(name="tagPushEvents")
    def tag_push_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for tag push events.
        """
        return pulumi.get(self, "tag_push_events")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[str]:
        """
        The Telegram bot token.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter(name="wikiPageEvents")
    def wiki_page_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for wiki page events.
        """
        return pulumi.get(self, "wiki_page_events")

