# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProjectLevelNotificationsArgs', 'ProjectLevelNotifications']

@pulumi.input_type
class ProjectLevelNotificationsArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[str],
                 close_issue: Optional[pulumi.Input[bool]] = None,
                 close_merge_request: Optional[pulumi.Input[bool]] = None,
                 failed_pipeline: Optional[pulumi.Input[bool]] = None,
                 fixed_pipeline: Optional[pulumi.Input[bool]] = None,
                 issue_due: Optional[pulumi.Input[bool]] = None,
                 level: Optional[pulumi.Input[str]] = None,
                 merge_merge_request: Optional[pulumi.Input[bool]] = None,
                 merge_when_pipeline_succeeds: Optional[pulumi.Input[bool]] = None,
                 moved_project: Optional[pulumi.Input[bool]] = None,
                 new_issue: Optional[pulumi.Input[bool]] = None,
                 new_merge_request: Optional[pulumi.Input[bool]] = None,
                 new_note: Optional[pulumi.Input[bool]] = None,
                 push_to_merge_request: Optional[pulumi.Input[bool]] = None,
                 reassign_issue: Optional[pulumi.Input[bool]] = None,
                 reassign_merge_request: Optional[pulumi.Input[bool]] = None,
                 reopen_issue: Optional[pulumi.Input[bool]] = None,
                 reopen_merge_request: Optional[pulumi.Input[bool]] = None,
                 success_pipeline: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a ProjectLevelNotifications resource.
        :param pulumi.Input[str] project: The ID or URL-encoded path of a project where notifications will be configured.
        :param pulumi.Input[bool] close_issue: Enable notifications for closed issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] close_merge_request: Enable notifications for closed merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] failed_pipeline: Enable notifications for failed pipelines. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] fixed_pipeline: Enable notifications for fixed pipelines. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] issue_due: Enable notifications for due issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[str] level: The level of the notification. Valid values are: `disabled`, `participating`, `watch`, `global`, `mention`, `custom`.
        :param pulumi.Input[bool] merge_merge_request: Enable notifications for merged merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] merge_when_pipeline_succeeds: Enable notifications for merged merge requests when the pipeline succeeds. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] moved_project: Enable notifications for moved projects. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] new_issue: Enable notifications for new issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] new_merge_request: Enable notifications for new merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] new_note: Enable notifications for new notes on merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] push_to_merge_request: Enable notifications for push to merge request branches. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] reassign_issue: Enable notifications for issue reassignments. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] reassign_merge_request: Enable notifications for merge request reassignments. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] reopen_issue: Enable notifications for reopened issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] reopen_merge_request: Enable notifications for reopened merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] success_pipeline: Enable notifications for successful pipelines. Can only be used when `level` is `custom`.
        """
        pulumi.set(__self__, "project", project)
        if close_issue is not None:
            pulumi.set(__self__, "close_issue", close_issue)
        if close_merge_request is not None:
            pulumi.set(__self__, "close_merge_request", close_merge_request)
        if failed_pipeline is not None:
            pulumi.set(__self__, "failed_pipeline", failed_pipeline)
        if fixed_pipeline is not None:
            pulumi.set(__self__, "fixed_pipeline", fixed_pipeline)
        if issue_due is not None:
            pulumi.set(__self__, "issue_due", issue_due)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if merge_merge_request is not None:
            pulumi.set(__self__, "merge_merge_request", merge_merge_request)
        if merge_when_pipeline_succeeds is not None:
            pulumi.set(__self__, "merge_when_pipeline_succeeds", merge_when_pipeline_succeeds)
        if moved_project is not None:
            pulumi.set(__self__, "moved_project", moved_project)
        if new_issue is not None:
            pulumi.set(__self__, "new_issue", new_issue)
        if new_merge_request is not None:
            pulumi.set(__self__, "new_merge_request", new_merge_request)
        if new_note is not None:
            pulumi.set(__self__, "new_note", new_note)
        if push_to_merge_request is not None:
            pulumi.set(__self__, "push_to_merge_request", push_to_merge_request)
        if reassign_issue is not None:
            pulumi.set(__self__, "reassign_issue", reassign_issue)
        if reassign_merge_request is not None:
            pulumi.set(__self__, "reassign_merge_request", reassign_merge_request)
        if reopen_issue is not None:
            pulumi.set(__self__, "reopen_issue", reopen_issue)
        if reopen_merge_request is not None:
            pulumi.set(__self__, "reopen_merge_request", reopen_merge_request)
        if success_pipeline is not None:
            pulumi.set(__self__, "success_pipeline", success_pipeline)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        The ID or URL-encoded path of a project where notifications will be configured.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="closeIssue")
    def close_issue(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for closed issues. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "close_issue")

    @close_issue.setter
    def close_issue(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "close_issue", value)

    @property
    @pulumi.getter(name="closeMergeRequest")
    def close_merge_request(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for closed merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "close_merge_request")

    @close_merge_request.setter
    def close_merge_request(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "close_merge_request", value)

    @property
    @pulumi.getter(name="failedPipeline")
    def failed_pipeline(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for failed pipelines. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "failed_pipeline")

    @failed_pipeline.setter
    def failed_pipeline(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "failed_pipeline", value)

    @property
    @pulumi.getter(name="fixedPipeline")
    def fixed_pipeline(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for fixed pipelines. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "fixed_pipeline")

    @fixed_pipeline.setter
    def fixed_pipeline(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fixed_pipeline", value)

    @property
    @pulumi.getter(name="issueDue")
    def issue_due(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for due issues. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "issue_due")

    @issue_due.setter
    def issue_due(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "issue_due", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[str]]:
        """
        The level of the notification. Valid values are: `disabled`, `participating`, `watch`, `global`, `mention`, `custom`.
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter(name="mergeMergeRequest")
    def merge_merge_request(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for merged merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "merge_merge_request")

    @merge_merge_request.setter
    def merge_merge_request(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "merge_merge_request", value)

    @property
    @pulumi.getter(name="mergeWhenPipelineSucceeds")
    def merge_when_pipeline_succeeds(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for merged merge requests when the pipeline succeeds. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "merge_when_pipeline_succeeds")

    @merge_when_pipeline_succeeds.setter
    def merge_when_pipeline_succeeds(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "merge_when_pipeline_succeeds", value)

    @property
    @pulumi.getter(name="movedProject")
    def moved_project(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for moved projects. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "moved_project")

    @moved_project.setter
    def moved_project(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "moved_project", value)

    @property
    @pulumi.getter(name="newIssue")
    def new_issue(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for new issues. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "new_issue")

    @new_issue.setter
    def new_issue(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "new_issue", value)

    @property
    @pulumi.getter(name="newMergeRequest")
    def new_merge_request(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for new merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "new_merge_request")

    @new_merge_request.setter
    def new_merge_request(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "new_merge_request", value)

    @property
    @pulumi.getter(name="newNote")
    def new_note(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for new notes on merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "new_note")

    @new_note.setter
    def new_note(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "new_note", value)

    @property
    @pulumi.getter(name="pushToMergeRequest")
    def push_to_merge_request(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for push to merge request branches. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "push_to_merge_request")

    @push_to_merge_request.setter
    def push_to_merge_request(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "push_to_merge_request", value)

    @property
    @pulumi.getter(name="reassignIssue")
    def reassign_issue(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for issue reassignments. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "reassign_issue")

    @reassign_issue.setter
    def reassign_issue(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reassign_issue", value)

    @property
    @pulumi.getter(name="reassignMergeRequest")
    def reassign_merge_request(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for merge request reassignments. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "reassign_merge_request")

    @reassign_merge_request.setter
    def reassign_merge_request(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reassign_merge_request", value)

    @property
    @pulumi.getter(name="reopenIssue")
    def reopen_issue(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for reopened issues. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "reopen_issue")

    @reopen_issue.setter
    def reopen_issue(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reopen_issue", value)

    @property
    @pulumi.getter(name="reopenMergeRequest")
    def reopen_merge_request(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for reopened merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "reopen_merge_request")

    @reopen_merge_request.setter
    def reopen_merge_request(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reopen_merge_request", value)

    @property
    @pulumi.getter(name="successPipeline")
    def success_pipeline(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for successful pipelines. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "success_pipeline")

    @success_pipeline.setter
    def success_pipeline(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "success_pipeline", value)


@pulumi.input_type
class _ProjectLevelNotificationsState:
    def __init__(__self__, *,
                 close_issue: Optional[pulumi.Input[bool]] = None,
                 close_merge_request: Optional[pulumi.Input[bool]] = None,
                 failed_pipeline: Optional[pulumi.Input[bool]] = None,
                 fixed_pipeline: Optional[pulumi.Input[bool]] = None,
                 issue_due: Optional[pulumi.Input[bool]] = None,
                 level: Optional[pulumi.Input[str]] = None,
                 merge_merge_request: Optional[pulumi.Input[bool]] = None,
                 merge_when_pipeline_succeeds: Optional[pulumi.Input[bool]] = None,
                 moved_project: Optional[pulumi.Input[bool]] = None,
                 new_issue: Optional[pulumi.Input[bool]] = None,
                 new_merge_request: Optional[pulumi.Input[bool]] = None,
                 new_note: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 push_to_merge_request: Optional[pulumi.Input[bool]] = None,
                 reassign_issue: Optional[pulumi.Input[bool]] = None,
                 reassign_merge_request: Optional[pulumi.Input[bool]] = None,
                 reopen_issue: Optional[pulumi.Input[bool]] = None,
                 reopen_merge_request: Optional[pulumi.Input[bool]] = None,
                 success_pipeline: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering ProjectLevelNotifications resources.
        :param pulumi.Input[bool] close_issue: Enable notifications for closed issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] close_merge_request: Enable notifications for closed merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] failed_pipeline: Enable notifications for failed pipelines. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] fixed_pipeline: Enable notifications for fixed pipelines. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] issue_due: Enable notifications for due issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[str] level: The level of the notification. Valid values are: `disabled`, `participating`, `watch`, `global`, `mention`, `custom`.
        :param pulumi.Input[bool] merge_merge_request: Enable notifications for merged merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] merge_when_pipeline_succeeds: Enable notifications for merged merge requests when the pipeline succeeds. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] moved_project: Enable notifications for moved projects. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] new_issue: Enable notifications for new issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] new_merge_request: Enable notifications for new merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] new_note: Enable notifications for new notes on merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[str] project: The ID or URL-encoded path of a project where notifications will be configured.
        :param pulumi.Input[bool] push_to_merge_request: Enable notifications for push to merge request branches. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] reassign_issue: Enable notifications for issue reassignments. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] reassign_merge_request: Enable notifications for merge request reassignments. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] reopen_issue: Enable notifications for reopened issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] reopen_merge_request: Enable notifications for reopened merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] success_pipeline: Enable notifications for successful pipelines. Can only be used when `level` is `custom`.
        """
        if close_issue is not None:
            pulumi.set(__self__, "close_issue", close_issue)
        if close_merge_request is not None:
            pulumi.set(__self__, "close_merge_request", close_merge_request)
        if failed_pipeline is not None:
            pulumi.set(__self__, "failed_pipeline", failed_pipeline)
        if fixed_pipeline is not None:
            pulumi.set(__self__, "fixed_pipeline", fixed_pipeline)
        if issue_due is not None:
            pulumi.set(__self__, "issue_due", issue_due)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if merge_merge_request is not None:
            pulumi.set(__self__, "merge_merge_request", merge_merge_request)
        if merge_when_pipeline_succeeds is not None:
            pulumi.set(__self__, "merge_when_pipeline_succeeds", merge_when_pipeline_succeeds)
        if moved_project is not None:
            pulumi.set(__self__, "moved_project", moved_project)
        if new_issue is not None:
            pulumi.set(__self__, "new_issue", new_issue)
        if new_merge_request is not None:
            pulumi.set(__self__, "new_merge_request", new_merge_request)
        if new_note is not None:
            pulumi.set(__self__, "new_note", new_note)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if push_to_merge_request is not None:
            pulumi.set(__self__, "push_to_merge_request", push_to_merge_request)
        if reassign_issue is not None:
            pulumi.set(__self__, "reassign_issue", reassign_issue)
        if reassign_merge_request is not None:
            pulumi.set(__self__, "reassign_merge_request", reassign_merge_request)
        if reopen_issue is not None:
            pulumi.set(__self__, "reopen_issue", reopen_issue)
        if reopen_merge_request is not None:
            pulumi.set(__self__, "reopen_merge_request", reopen_merge_request)
        if success_pipeline is not None:
            pulumi.set(__self__, "success_pipeline", success_pipeline)

    @property
    @pulumi.getter(name="closeIssue")
    def close_issue(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for closed issues. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "close_issue")

    @close_issue.setter
    def close_issue(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "close_issue", value)

    @property
    @pulumi.getter(name="closeMergeRequest")
    def close_merge_request(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for closed merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "close_merge_request")

    @close_merge_request.setter
    def close_merge_request(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "close_merge_request", value)

    @property
    @pulumi.getter(name="failedPipeline")
    def failed_pipeline(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for failed pipelines. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "failed_pipeline")

    @failed_pipeline.setter
    def failed_pipeline(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "failed_pipeline", value)

    @property
    @pulumi.getter(name="fixedPipeline")
    def fixed_pipeline(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for fixed pipelines. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "fixed_pipeline")

    @fixed_pipeline.setter
    def fixed_pipeline(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fixed_pipeline", value)

    @property
    @pulumi.getter(name="issueDue")
    def issue_due(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for due issues. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "issue_due")

    @issue_due.setter
    def issue_due(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "issue_due", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[str]]:
        """
        The level of the notification. Valid values are: `disabled`, `participating`, `watch`, `global`, `mention`, `custom`.
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter(name="mergeMergeRequest")
    def merge_merge_request(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for merged merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "merge_merge_request")

    @merge_merge_request.setter
    def merge_merge_request(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "merge_merge_request", value)

    @property
    @pulumi.getter(name="mergeWhenPipelineSucceeds")
    def merge_when_pipeline_succeeds(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for merged merge requests when the pipeline succeeds. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "merge_when_pipeline_succeeds")

    @merge_when_pipeline_succeeds.setter
    def merge_when_pipeline_succeeds(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "merge_when_pipeline_succeeds", value)

    @property
    @pulumi.getter(name="movedProject")
    def moved_project(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for moved projects. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "moved_project")

    @moved_project.setter
    def moved_project(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "moved_project", value)

    @property
    @pulumi.getter(name="newIssue")
    def new_issue(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for new issues. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "new_issue")

    @new_issue.setter
    def new_issue(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "new_issue", value)

    @property
    @pulumi.getter(name="newMergeRequest")
    def new_merge_request(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for new merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "new_merge_request")

    @new_merge_request.setter
    def new_merge_request(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "new_merge_request", value)

    @property
    @pulumi.getter(name="newNote")
    def new_note(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for new notes on merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "new_note")

    @new_note.setter
    def new_note(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "new_note", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID or URL-encoded path of a project where notifications will be configured.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pushToMergeRequest")
    def push_to_merge_request(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for push to merge request branches. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "push_to_merge_request")

    @push_to_merge_request.setter
    def push_to_merge_request(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "push_to_merge_request", value)

    @property
    @pulumi.getter(name="reassignIssue")
    def reassign_issue(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for issue reassignments. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "reassign_issue")

    @reassign_issue.setter
    def reassign_issue(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reassign_issue", value)

    @property
    @pulumi.getter(name="reassignMergeRequest")
    def reassign_merge_request(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for merge request reassignments. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "reassign_merge_request")

    @reassign_merge_request.setter
    def reassign_merge_request(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reassign_merge_request", value)

    @property
    @pulumi.getter(name="reopenIssue")
    def reopen_issue(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for reopened issues. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "reopen_issue")

    @reopen_issue.setter
    def reopen_issue(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reopen_issue", value)

    @property
    @pulumi.getter(name="reopenMergeRequest")
    def reopen_merge_request(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for reopened merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "reopen_merge_request")

    @reopen_merge_request.setter
    def reopen_merge_request(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reopen_merge_request", value)

    @property
    @pulumi.getter(name="successPipeline")
    def success_pipeline(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for successful pipelines. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "success_pipeline")

    @success_pipeline.setter
    def success_pipeline(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "success_pipeline", value)


class ProjectLevelNotifications(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 close_issue: Optional[pulumi.Input[bool]] = None,
                 close_merge_request: Optional[pulumi.Input[bool]] = None,
                 failed_pipeline: Optional[pulumi.Input[bool]] = None,
                 fixed_pipeline: Optional[pulumi.Input[bool]] = None,
                 issue_due: Optional[pulumi.Input[bool]] = None,
                 level: Optional[pulumi.Input[str]] = None,
                 merge_merge_request: Optional[pulumi.Input[bool]] = None,
                 merge_when_pipeline_succeeds: Optional[pulumi.Input[bool]] = None,
                 moved_project: Optional[pulumi.Input[bool]] = None,
                 new_issue: Optional[pulumi.Input[bool]] = None,
                 new_merge_request: Optional[pulumi.Input[bool]] = None,
                 new_note: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 push_to_merge_request: Optional[pulumi.Input[bool]] = None,
                 reassign_issue: Optional[pulumi.Input[bool]] = None,
                 reassign_merge_request: Optional[pulumi.Input[bool]] = None,
                 reopen_issue: Optional[pulumi.Input[bool]] = None,
                 reopen_merge_request: Optional[pulumi.Input[bool]] = None,
                 success_pipeline: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        The `ProjectLevelNotifications` resource allows to manage notifications for a project.

        > While the API supports both groups and projects, this resource only supports projects currently.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/notification_settings.html#group--project-level-notification-settings)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] close_issue: Enable notifications for closed issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] close_merge_request: Enable notifications for closed merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] failed_pipeline: Enable notifications for failed pipelines. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] fixed_pipeline: Enable notifications for fixed pipelines. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] issue_due: Enable notifications for due issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[str] level: The level of the notification. Valid values are: `disabled`, `participating`, `watch`, `global`, `mention`, `custom`.
        :param pulumi.Input[bool] merge_merge_request: Enable notifications for merged merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] merge_when_pipeline_succeeds: Enable notifications for merged merge requests when the pipeline succeeds. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] moved_project: Enable notifications for moved projects. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] new_issue: Enable notifications for new issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] new_merge_request: Enable notifications for new merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] new_note: Enable notifications for new notes on merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[str] project: The ID or URL-encoded path of a project where notifications will be configured.
        :param pulumi.Input[bool] push_to_merge_request: Enable notifications for push to merge request branches. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] reassign_issue: Enable notifications for issue reassignments. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] reassign_merge_request: Enable notifications for merge request reassignments. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] reopen_issue: Enable notifications for reopened issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] reopen_merge_request: Enable notifications for reopened merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] success_pipeline: Enable notifications for successful pipelines. Can only be used when `level` is `custom`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectLevelNotificationsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `ProjectLevelNotifications` resource allows to manage notifications for a project.

        > While the API supports both groups and projects, this resource only supports projects currently.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/notification_settings.html#group--project-level-notification-settings)

        :param str resource_name: The name of the resource.
        :param ProjectLevelNotificationsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectLevelNotificationsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 close_issue: Optional[pulumi.Input[bool]] = None,
                 close_merge_request: Optional[pulumi.Input[bool]] = None,
                 failed_pipeline: Optional[pulumi.Input[bool]] = None,
                 fixed_pipeline: Optional[pulumi.Input[bool]] = None,
                 issue_due: Optional[pulumi.Input[bool]] = None,
                 level: Optional[pulumi.Input[str]] = None,
                 merge_merge_request: Optional[pulumi.Input[bool]] = None,
                 merge_when_pipeline_succeeds: Optional[pulumi.Input[bool]] = None,
                 moved_project: Optional[pulumi.Input[bool]] = None,
                 new_issue: Optional[pulumi.Input[bool]] = None,
                 new_merge_request: Optional[pulumi.Input[bool]] = None,
                 new_note: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 push_to_merge_request: Optional[pulumi.Input[bool]] = None,
                 reassign_issue: Optional[pulumi.Input[bool]] = None,
                 reassign_merge_request: Optional[pulumi.Input[bool]] = None,
                 reopen_issue: Optional[pulumi.Input[bool]] = None,
                 reopen_merge_request: Optional[pulumi.Input[bool]] = None,
                 success_pipeline: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectLevelNotificationsArgs.__new__(ProjectLevelNotificationsArgs)

            __props__.__dict__["close_issue"] = close_issue
            __props__.__dict__["close_merge_request"] = close_merge_request
            __props__.__dict__["failed_pipeline"] = failed_pipeline
            __props__.__dict__["fixed_pipeline"] = fixed_pipeline
            __props__.__dict__["issue_due"] = issue_due
            __props__.__dict__["level"] = level
            __props__.__dict__["merge_merge_request"] = merge_merge_request
            __props__.__dict__["merge_when_pipeline_succeeds"] = merge_when_pipeline_succeeds
            __props__.__dict__["moved_project"] = moved_project
            __props__.__dict__["new_issue"] = new_issue
            __props__.__dict__["new_merge_request"] = new_merge_request
            __props__.__dict__["new_note"] = new_note
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["push_to_merge_request"] = push_to_merge_request
            __props__.__dict__["reassign_issue"] = reassign_issue
            __props__.__dict__["reassign_merge_request"] = reassign_merge_request
            __props__.__dict__["reopen_issue"] = reopen_issue
            __props__.__dict__["reopen_merge_request"] = reopen_merge_request
            __props__.__dict__["success_pipeline"] = success_pipeline
        super(ProjectLevelNotifications, __self__).__init__(
            'gitlab:index/projectLevelNotifications:ProjectLevelNotifications',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            close_issue: Optional[pulumi.Input[bool]] = None,
            close_merge_request: Optional[pulumi.Input[bool]] = None,
            failed_pipeline: Optional[pulumi.Input[bool]] = None,
            fixed_pipeline: Optional[pulumi.Input[bool]] = None,
            issue_due: Optional[pulumi.Input[bool]] = None,
            level: Optional[pulumi.Input[str]] = None,
            merge_merge_request: Optional[pulumi.Input[bool]] = None,
            merge_when_pipeline_succeeds: Optional[pulumi.Input[bool]] = None,
            moved_project: Optional[pulumi.Input[bool]] = None,
            new_issue: Optional[pulumi.Input[bool]] = None,
            new_merge_request: Optional[pulumi.Input[bool]] = None,
            new_note: Optional[pulumi.Input[bool]] = None,
            project: Optional[pulumi.Input[str]] = None,
            push_to_merge_request: Optional[pulumi.Input[bool]] = None,
            reassign_issue: Optional[pulumi.Input[bool]] = None,
            reassign_merge_request: Optional[pulumi.Input[bool]] = None,
            reopen_issue: Optional[pulumi.Input[bool]] = None,
            reopen_merge_request: Optional[pulumi.Input[bool]] = None,
            success_pipeline: Optional[pulumi.Input[bool]] = None) -> 'ProjectLevelNotifications':
        """
        Get an existing ProjectLevelNotifications resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] close_issue: Enable notifications for closed issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] close_merge_request: Enable notifications for closed merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] failed_pipeline: Enable notifications for failed pipelines. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] fixed_pipeline: Enable notifications for fixed pipelines. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] issue_due: Enable notifications for due issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[str] level: The level of the notification. Valid values are: `disabled`, `participating`, `watch`, `global`, `mention`, `custom`.
        :param pulumi.Input[bool] merge_merge_request: Enable notifications for merged merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] merge_when_pipeline_succeeds: Enable notifications for merged merge requests when the pipeline succeeds. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] moved_project: Enable notifications for moved projects. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] new_issue: Enable notifications for new issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] new_merge_request: Enable notifications for new merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] new_note: Enable notifications for new notes on merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[str] project: The ID or URL-encoded path of a project where notifications will be configured.
        :param pulumi.Input[bool] push_to_merge_request: Enable notifications for push to merge request branches. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] reassign_issue: Enable notifications for issue reassignments. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] reassign_merge_request: Enable notifications for merge request reassignments. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] reopen_issue: Enable notifications for reopened issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] reopen_merge_request: Enable notifications for reopened merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[bool] success_pipeline: Enable notifications for successful pipelines. Can only be used when `level` is `custom`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectLevelNotificationsState.__new__(_ProjectLevelNotificationsState)

        __props__.__dict__["close_issue"] = close_issue
        __props__.__dict__["close_merge_request"] = close_merge_request
        __props__.__dict__["failed_pipeline"] = failed_pipeline
        __props__.__dict__["fixed_pipeline"] = fixed_pipeline
        __props__.__dict__["issue_due"] = issue_due
        __props__.__dict__["level"] = level
        __props__.__dict__["merge_merge_request"] = merge_merge_request
        __props__.__dict__["merge_when_pipeline_succeeds"] = merge_when_pipeline_succeeds
        __props__.__dict__["moved_project"] = moved_project
        __props__.__dict__["new_issue"] = new_issue
        __props__.__dict__["new_merge_request"] = new_merge_request
        __props__.__dict__["new_note"] = new_note
        __props__.__dict__["project"] = project
        __props__.__dict__["push_to_merge_request"] = push_to_merge_request
        __props__.__dict__["reassign_issue"] = reassign_issue
        __props__.__dict__["reassign_merge_request"] = reassign_merge_request
        __props__.__dict__["reopen_issue"] = reopen_issue
        __props__.__dict__["reopen_merge_request"] = reopen_merge_request
        __props__.__dict__["success_pipeline"] = success_pipeline
        return ProjectLevelNotifications(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="closeIssue")
    def close_issue(self) -> pulumi.Output[bool]:
        """
        Enable notifications for closed issues. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "close_issue")

    @property
    @pulumi.getter(name="closeMergeRequest")
    def close_merge_request(self) -> pulumi.Output[bool]:
        """
        Enable notifications for closed merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "close_merge_request")

    @property
    @pulumi.getter(name="failedPipeline")
    def failed_pipeline(self) -> pulumi.Output[bool]:
        """
        Enable notifications for failed pipelines. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "failed_pipeline")

    @property
    @pulumi.getter(name="fixedPipeline")
    def fixed_pipeline(self) -> pulumi.Output[bool]:
        """
        Enable notifications for fixed pipelines. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "fixed_pipeline")

    @property
    @pulumi.getter(name="issueDue")
    def issue_due(self) -> pulumi.Output[bool]:
        """
        Enable notifications for due issues. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "issue_due")

    @property
    @pulumi.getter
    def level(self) -> pulumi.Output[str]:
        """
        The level of the notification. Valid values are: `disabled`, `participating`, `watch`, `global`, `mention`, `custom`.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter(name="mergeMergeRequest")
    def merge_merge_request(self) -> pulumi.Output[bool]:
        """
        Enable notifications for merged merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "merge_merge_request")

    @property
    @pulumi.getter(name="mergeWhenPipelineSucceeds")
    def merge_when_pipeline_succeeds(self) -> pulumi.Output[bool]:
        """
        Enable notifications for merged merge requests when the pipeline succeeds. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "merge_when_pipeline_succeeds")

    @property
    @pulumi.getter(name="movedProject")
    def moved_project(self) -> pulumi.Output[bool]:
        """
        Enable notifications for moved projects. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "moved_project")

    @property
    @pulumi.getter(name="newIssue")
    def new_issue(self) -> pulumi.Output[bool]:
        """
        Enable notifications for new issues. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "new_issue")

    @property
    @pulumi.getter(name="newMergeRequest")
    def new_merge_request(self) -> pulumi.Output[bool]:
        """
        Enable notifications for new merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "new_merge_request")

    @property
    @pulumi.getter(name="newNote")
    def new_note(self) -> pulumi.Output[bool]:
        """
        Enable notifications for new notes on merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "new_note")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID or URL-encoded path of a project where notifications will be configured.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pushToMergeRequest")
    def push_to_merge_request(self) -> pulumi.Output[bool]:
        """
        Enable notifications for push to merge request branches. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "push_to_merge_request")

    @property
    @pulumi.getter(name="reassignIssue")
    def reassign_issue(self) -> pulumi.Output[bool]:
        """
        Enable notifications for issue reassignments. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "reassign_issue")

    @property
    @pulumi.getter(name="reassignMergeRequest")
    def reassign_merge_request(self) -> pulumi.Output[bool]:
        """
        Enable notifications for merge request reassignments. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "reassign_merge_request")

    @property
    @pulumi.getter(name="reopenIssue")
    def reopen_issue(self) -> pulumi.Output[bool]:
        """
        Enable notifications for reopened issues. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "reopen_issue")

    @property
    @pulumi.getter(name="reopenMergeRequest")
    def reopen_merge_request(self) -> pulumi.Output[bool]:
        """
        Enable notifications for reopened merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "reopen_merge_request")

    @property
    @pulumi.getter(name="successPipeline")
    def success_pipeline(self) -> pulumi.Output[bool]:
        """
        Enable notifications for successful pipelines. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "success_pipeline")

