# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ServiceJiraArgs', 'ServiceJira']

@pulumi.input_type
class ServiceJiraArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 project: pulumi.Input[str],
                 url: pulumi.Input[str],
                 api_url: Optional[pulumi.Input[str]] = None,
                 comment_on_event_enabled: Optional[pulumi.Input[bool]] = None,
                 commit_events: Optional[pulumi.Input[bool]] = None,
                 issues_enabled: Optional[pulumi.Input[bool]] = None,
                 jira_auth_type: Optional[pulumi.Input[int]] = None,
                 jira_issue_prefix: Optional[pulumi.Input[str]] = None,
                 jira_issue_regex: Optional[pulumi.Input[str]] = None,
                 jira_issue_transition_automatic: Optional[pulumi.Input[bool]] = None,
                 jira_issue_transition_id: Optional[pulumi.Input[str]] = None,
                 merge_requests_events: Optional[pulumi.Input[bool]] = None,
                 project_key: Optional[pulumi.Input[str]] = None,
                 project_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 use_inherited_settings: Optional[pulumi.Input[bool]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ServiceJira resource.
        :param pulumi.Input[str] password: The Jira API token, password, or personal access token to be used with Jira. When your authentication method is basic (jira*auth*type is 0), use an API token for Jira Cloud or a password for Jira Data Center or Jira Server. When your authentication method is a Jira personal access token (jira*auth*type is 1), use the personal access token.
        :param pulumi.Input[str] project: ID of the project you want to activate integration on.
        :param pulumi.Input[str] url: The URL to the JIRA project which is being linked to this GitLab project. For example, https://jira.example.com.
        :param pulumi.Input[str] api_url: The base URL to the Jira instance API. Web URL value is used if not set. For example, https://jira-api.example.com.
        :param pulumi.Input[bool] comment_on_event_enabled: Enable comments inside Jira issues on each GitLab event (commit / merge request)
        :param pulumi.Input[bool] commit_events: Enable notifications for commit events
        :param pulumi.Input[bool] issues_enabled: Enable viewing Jira issues in GitLab.
        :param pulumi.Input[int] jira_auth_type: The authentication method to be used with Jira. 0 means Basic Authentication. 1 means Jira personal access token. Defaults to 0.
        :param pulumi.Input[str] jira_issue_prefix: Prefix to match Jira issue keys.
        :param pulumi.Input[str] jira_issue_regex: Regular expression to match Jira issue keys.
        :param pulumi.Input[str] jira_issue_transition_id: The ID of a transition that moves issues to a closed state. You can find this number under the JIRA workflow administration (Administration > Issues > Workflows) by selecting View under Operations of the desired workflow of your project. By default, this ID is set to 2. *Note**: importing this field is only supported since GitLab 15.2.
        :param pulumi.Input[bool] merge_requests_events: Enable notifications for merge request events
        :param pulumi.Input[str] project_key: The short identifier for your JIRA project, all uppercase, e.g., PROJ.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] project_keys: Keys of Jira projects. When issues_enabled is true, this setting specifies which Jira projects to view issues from in GitLab.
        :param pulumi.Input[bool] use_inherited_settings: Indicates whether or not to inherit default settings. Defaults to false.
        :param pulumi.Input[str] username: The email or username to be used with Jira. For Jira Cloud use an email, for Jira Data Center and Jira Server use a username. Required when using Basic authentication (jira*auth*type is 0).
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "url", url)
        if api_url is not None:
            pulumi.set(__self__, "api_url", api_url)
        if comment_on_event_enabled is not None:
            pulumi.set(__self__, "comment_on_event_enabled", comment_on_event_enabled)
        if commit_events is not None:
            pulumi.set(__self__, "commit_events", commit_events)
        if issues_enabled is not None:
            pulumi.set(__self__, "issues_enabled", issues_enabled)
        if jira_auth_type is not None:
            pulumi.set(__self__, "jira_auth_type", jira_auth_type)
        if jira_issue_prefix is not None:
            pulumi.set(__self__, "jira_issue_prefix", jira_issue_prefix)
        if jira_issue_regex is not None:
            pulumi.set(__self__, "jira_issue_regex", jira_issue_regex)
        if jira_issue_transition_automatic is not None:
            pulumi.set(__self__, "jira_issue_transition_automatic", jira_issue_transition_automatic)
        if jira_issue_transition_id is not None:
            pulumi.set(__self__, "jira_issue_transition_id", jira_issue_transition_id)
        if merge_requests_events is not None:
            pulumi.set(__self__, "merge_requests_events", merge_requests_events)
        if project_key is not None:
            pulumi.set(__self__, "project_key", project_key)
        if project_keys is not None:
            pulumi.set(__self__, "project_keys", project_keys)
        if use_inherited_settings is not None:
            pulumi.set(__self__, "use_inherited_settings", use_inherited_settings)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The Jira API token, password, or personal access token to be used with Jira. When your authentication method is basic (jira*auth*type is 0), use an API token for Jira Cloud or a password for Jira Data Center or Jira Server. When your authentication method is a Jira personal access token (jira*auth*type is 1), use the personal access token.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        ID of the project you want to activate integration on.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The URL to the JIRA project which is being linked to this GitLab project. For example, https://jira.example.com.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="apiUrl")
    def api_url(self) -> Optional[pulumi.Input[str]]:
        """
        The base URL to the Jira instance API. Web URL value is used if not set. For example, https://jira-api.example.com.
        """
        return pulumi.get(self, "api_url")

    @api_url.setter
    def api_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_url", value)

    @property
    @pulumi.getter(name="commentOnEventEnabled")
    def comment_on_event_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable comments inside Jira issues on each GitLab event (commit / merge request)
        """
        return pulumi.get(self, "comment_on_event_enabled")

    @comment_on_event_enabled.setter
    def comment_on_event_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "comment_on_event_enabled", value)

    @property
    @pulumi.getter(name="commitEvents")
    def commit_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for commit events
        """
        return pulumi.get(self, "commit_events")

    @commit_events.setter
    def commit_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "commit_events", value)

    @property
    @pulumi.getter(name="issuesEnabled")
    def issues_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable viewing Jira issues in GitLab.
        """
        return pulumi.get(self, "issues_enabled")

    @issues_enabled.setter
    def issues_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "issues_enabled", value)

    @property
    @pulumi.getter(name="jiraAuthType")
    def jira_auth_type(self) -> Optional[pulumi.Input[int]]:
        """
        The authentication method to be used with Jira. 0 means Basic Authentication. 1 means Jira personal access token. Defaults to 0.
        """
        return pulumi.get(self, "jira_auth_type")

    @jira_auth_type.setter
    def jira_auth_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "jira_auth_type", value)

    @property
    @pulumi.getter(name="jiraIssuePrefix")
    def jira_issue_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Prefix to match Jira issue keys.
        """
        return pulumi.get(self, "jira_issue_prefix")

    @jira_issue_prefix.setter
    def jira_issue_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jira_issue_prefix", value)

    @property
    @pulumi.getter(name="jiraIssueRegex")
    def jira_issue_regex(self) -> Optional[pulumi.Input[str]]:
        """
        Regular expression to match Jira issue keys.
        """
        return pulumi.get(self, "jira_issue_regex")

    @jira_issue_regex.setter
    def jira_issue_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jira_issue_regex", value)

    @property
    @pulumi.getter(name="jiraIssueTransitionAutomatic")
    def jira_issue_transition_automatic(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "jira_issue_transition_automatic")

    @jira_issue_transition_automatic.setter
    def jira_issue_transition_automatic(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "jira_issue_transition_automatic", value)

    @property
    @pulumi.getter(name="jiraIssueTransitionId")
    def jira_issue_transition_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of a transition that moves issues to a closed state. You can find this number under the JIRA workflow administration (Administration > Issues > Workflows) by selecting View under Operations of the desired workflow of your project. By default, this ID is set to 2. *Note**: importing this field is only supported since GitLab 15.2.
        """
        return pulumi.get(self, "jira_issue_transition_id")

    @jira_issue_transition_id.setter
    def jira_issue_transition_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jira_issue_transition_id", value)

    @property
    @pulumi.getter(name="mergeRequestsEvents")
    def merge_requests_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for merge request events
        """
        return pulumi.get(self, "merge_requests_events")

    @merge_requests_events.setter
    def merge_requests_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "merge_requests_events", value)

    @property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> Optional[pulumi.Input[str]]:
        """
        The short identifier for your JIRA project, all uppercase, e.g., PROJ.
        """
        return pulumi.get(self, "project_key")

    @project_key.setter
    def project_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_key", value)

    @property
    @pulumi.getter(name="projectKeys")
    def project_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Keys of Jira projects. When issues_enabled is true, this setting specifies which Jira projects to view issues from in GitLab.
        """
        return pulumi.get(self, "project_keys")

    @project_keys.setter
    def project_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "project_keys", value)

    @property
    @pulumi.getter(name="useInheritedSettings")
    def use_inherited_settings(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether or not to inherit default settings. Defaults to false.
        """
        return pulumi.get(self, "use_inherited_settings")

    @use_inherited_settings.setter
    def use_inherited_settings(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_inherited_settings", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The email or username to be used with Jira. For Jira Cloud use an email, for Jira Data Center and Jira Server use a username. Required when using Basic authentication (jira*auth*type is 0).
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class _ServiceJiraState:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[bool]] = None,
                 api_url: Optional[pulumi.Input[str]] = None,
                 comment_on_event_enabled: Optional[pulumi.Input[bool]] = None,
                 commit_events: Optional[pulumi.Input[bool]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 issues_enabled: Optional[pulumi.Input[bool]] = None,
                 jira_auth_type: Optional[pulumi.Input[int]] = None,
                 jira_issue_prefix: Optional[pulumi.Input[str]] = None,
                 jira_issue_regex: Optional[pulumi.Input[str]] = None,
                 jira_issue_transition_automatic: Optional[pulumi.Input[bool]] = None,
                 jira_issue_transition_id: Optional[pulumi.Input[str]] = None,
                 merge_requests_events: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 project_key: Optional[pulumi.Input[str]] = None,
                 project_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 use_inherited_settings: Optional[pulumi.Input[bool]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ServiceJira resources.
        :param pulumi.Input[bool] active: Whether the integration is active.
        :param pulumi.Input[str] api_url: The base URL to the Jira instance API. Web URL value is used if not set. For example, https://jira-api.example.com.
        :param pulumi.Input[bool] comment_on_event_enabled: Enable comments inside Jira issues on each GitLab event (commit / merge request)
        :param pulumi.Input[bool] commit_events: Enable notifications for commit events
        :param pulumi.Input[str] created_at: Create time.
        :param pulumi.Input[bool] issues_enabled: Enable viewing Jira issues in GitLab.
        :param pulumi.Input[int] jira_auth_type: The authentication method to be used with Jira. 0 means Basic Authentication. 1 means Jira personal access token. Defaults to 0.
        :param pulumi.Input[str] jira_issue_prefix: Prefix to match Jira issue keys.
        :param pulumi.Input[str] jira_issue_regex: Regular expression to match Jira issue keys.
        :param pulumi.Input[str] jira_issue_transition_id: The ID of a transition that moves issues to a closed state. You can find this number under the JIRA workflow administration (Administration > Issues > Workflows) by selecting View under Operations of the desired workflow of your project. By default, this ID is set to 2. *Note**: importing this field is only supported since GitLab 15.2.
        :param pulumi.Input[bool] merge_requests_events: Enable notifications for merge request events
        :param pulumi.Input[str] password: The Jira API token, password, or personal access token to be used with Jira. When your authentication method is basic (jira*auth*type is 0), use an API token for Jira Cloud or a password for Jira Data Center or Jira Server. When your authentication method is a Jira personal access token (jira*auth*type is 1), use the personal access token.
        :param pulumi.Input[str] project: ID of the project you want to activate integration on.
        :param pulumi.Input[str] project_key: The short identifier for your JIRA project, all uppercase, e.g., PROJ.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] project_keys: Keys of Jira projects. When issues_enabled is true, this setting specifies which Jira projects to view issues from in GitLab.
        :param pulumi.Input[str] title: Title.
        :param pulumi.Input[str] updated_at: Update time.
        :param pulumi.Input[str] url: The URL to the JIRA project which is being linked to this GitLab project. For example, https://jira.example.com.
        :param pulumi.Input[bool] use_inherited_settings: Indicates whether or not to inherit default settings. Defaults to false.
        :param pulumi.Input[str] username: The email or username to be used with Jira. For Jira Cloud use an email, for Jira Data Center and Jira Server use a username. Required when using Basic authentication (jira*auth*type is 0).
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if api_url is not None:
            pulumi.set(__self__, "api_url", api_url)
        if comment_on_event_enabled is not None:
            pulumi.set(__self__, "comment_on_event_enabled", comment_on_event_enabled)
        if commit_events is not None:
            pulumi.set(__self__, "commit_events", commit_events)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if issues_enabled is not None:
            pulumi.set(__self__, "issues_enabled", issues_enabled)
        if jira_auth_type is not None:
            pulumi.set(__self__, "jira_auth_type", jira_auth_type)
        if jira_issue_prefix is not None:
            pulumi.set(__self__, "jira_issue_prefix", jira_issue_prefix)
        if jira_issue_regex is not None:
            pulumi.set(__self__, "jira_issue_regex", jira_issue_regex)
        if jira_issue_transition_automatic is not None:
            pulumi.set(__self__, "jira_issue_transition_automatic", jira_issue_transition_automatic)
        if jira_issue_transition_id is not None:
            pulumi.set(__self__, "jira_issue_transition_id", jira_issue_transition_id)
        if merge_requests_events is not None:
            pulumi.set(__self__, "merge_requests_events", merge_requests_events)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if project_key is not None:
            pulumi.set(__self__, "project_key", project_key)
        if project_keys is not None:
            pulumi.set(__self__, "project_keys", project_keys)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if use_inherited_settings is not None:
            pulumi.set(__self__, "use_inherited_settings", use_inherited_settings)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the integration is active.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="apiUrl")
    def api_url(self) -> Optional[pulumi.Input[str]]:
        """
        The base URL to the Jira instance API. Web URL value is used if not set. For example, https://jira-api.example.com.
        """
        return pulumi.get(self, "api_url")

    @api_url.setter
    def api_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_url", value)

    @property
    @pulumi.getter(name="commentOnEventEnabled")
    def comment_on_event_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable comments inside Jira issues on each GitLab event (commit / merge request)
        """
        return pulumi.get(self, "comment_on_event_enabled")

    @comment_on_event_enabled.setter
    def comment_on_event_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "comment_on_event_enabled", value)

    @property
    @pulumi.getter(name="commitEvents")
    def commit_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for commit events
        """
        return pulumi.get(self, "commit_events")

    @commit_events.setter
    def commit_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "commit_events", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Create time.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="issuesEnabled")
    def issues_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable viewing Jira issues in GitLab.
        """
        return pulumi.get(self, "issues_enabled")

    @issues_enabled.setter
    def issues_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "issues_enabled", value)

    @property
    @pulumi.getter(name="jiraAuthType")
    def jira_auth_type(self) -> Optional[pulumi.Input[int]]:
        """
        The authentication method to be used with Jira. 0 means Basic Authentication. 1 means Jira personal access token. Defaults to 0.
        """
        return pulumi.get(self, "jira_auth_type")

    @jira_auth_type.setter
    def jira_auth_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "jira_auth_type", value)

    @property
    @pulumi.getter(name="jiraIssuePrefix")
    def jira_issue_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Prefix to match Jira issue keys.
        """
        return pulumi.get(self, "jira_issue_prefix")

    @jira_issue_prefix.setter
    def jira_issue_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jira_issue_prefix", value)

    @property
    @pulumi.getter(name="jiraIssueRegex")
    def jira_issue_regex(self) -> Optional[pulumi.Input[str]]:
        """
        Regular expression to match Jira issue keys.
        """
        return pulumi.get(self, "jira_issue_regex")

    @jira_issue_regex.setter
    def jira_issue_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jira_issue_regex", value)

    @property
    @pulumi.getter(name="jiraIssueTransitionAutomatic")
    def jira_issue_transition_automatic(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "jira_issue_transition_automatic")

    @jira_issue_transition_automatic.setter
    def jira_issue_transition_automatic(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "jira_issue_transition_automatic", value)

    @property
    @pulumi.getter(name="jiraIssueTransitionId")
    def jira_issue_transition_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of a transition that moves issues to a closed state. You can find this number under the JIRA workflow administration (Administration > Issues > Workflows) by selecting View under Operations of the desired workflow of your project. By default, this ID is set to 2. *Note**: importing this field is only supported since GitLab 15.2.
        """
        return pulumi.get(self, "jira_issue_transition_id")

    @jira_issue_transition_id.setter
    def jira_issue_transition_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jira_issue_transition_id", value)

    @property
    @pulumi.getter(name="mergeRequestsEvents")
    def merge_requests_events(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable notifications for merge request events
        """
        return pulumi.get(self, "merge_requests_events")

    @merge_requests_events.setter
    def merge_requests_events(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "merge_requests_events", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The Jira API token, password, or personal access token to be used with Jira. When your authentication method is basic (jira*auth*type is 0), use an API token for Jira Cloud or a password for Jira Data Center or Jira Server. When your authentication method is a Jira personal access token (jira*auth*type is 1), use the personal access token.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the project you want to activate integration on.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> Optional[pulumi.Input[str]]:
        """
        The short identifier for your JIRA project, all uppercase, e.g., PROJ.
        """
        return pulumi.get(self, "project_key")

    @project_key.setter
    def project_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_key", value)

    @property
    @pulumi.getter(name="projectKeys")
    def project_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Keys of Jira projects. When issues_enabled is true, this setting specifies which Jira projects to view issues from in GitLab.
        """
        return pulumi.get(self, "project_keys")

    @project_keys.setter
    def project_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "project_keys", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Title.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        Update time.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL to the JIRA project which is being linked to this GitLab project. For example, https://jira.example.com.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="useInheritedSettings")
    def use_inherited_settings(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether or not to inherit default settings. Defaults to false.
        """
        return pulumi.get(self, "use_inherited_settings")

    @use_inherited_settings.setter
    def use_inherited_settings(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_inherited_settings", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The email or username to be used with Jira. For Jira Cloud use an email, for Jira Data Center and Jira Server use a username. Required when using Basic authentication (jira*auth*type is 0).
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


class ServiceJira(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_url: Optional[pulumi.Input[str]] = None,
                 comment_on_event_enabled: Optional[pulumi.Input[bool]] = None,
                 commit_events: Optional[pulumi.Input[bool]] = None,
                 issues_enabled: Optional[pulumi.Input[bool]] = None,
                 jira_auth_type: Optional[pulumi.Input[int]] = None,
                 jira_issue_prefix: Optional[pulumi.Input[str]] = None,
                 jira_issue_regex: Optional[pulumi.Input[str]] = None,
                 jira_issue_transition_automatic: Optional[pulumi.Input[bool]] = None,
                 jira_issue_transition_id: Optional[pulumi.Input[str]] = None,
                 merge_requests_events: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 project_key: Optional[pulumi.Input[str]] = None,
                 project_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 use_inherited_settings: Optional[pulumi.Input[bool]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The `ServiceJira` resource allows to manage the lifecycle of a project integration with Jira.

        > This resource is deprecated. use `IntegrationJira`instead!

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/integrations.html#jira)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        awesome_project = gitlab.Project("awesome_project",
            name="awesome_project",
            description="My awesome project.",
            visibility_level="public")
        jira = gitlab.ServiceJira("jira",
            project=awesome_project.id,
            url="https://jira.example.com",
            username="user",
            password="mypass")
        ```

        ## Import

        Starting in Terraform v1.5.0 you can use an import block to import `gitlab_service_jira`. For example:

        terraform

        import {

          to = gitlab_service_jira.example

          id = "see CLI command below for ID"

        }

        Import using the CLI is supported using the following syntax:

        You can import a gitlab_service_jira state using the project ID, e.g.

        ```sh
        $ pulumi import gitlab:index/serviceJira:ServiceJira jira 1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] api_url: The base URL to the Jira instance API. Web URL value is used if not set. For example, https://jira-api.example.com.
        :param pulumi.Input[bool] comment_on_event_enabled: Enable comments inside Jira issues on each GitLab event (commit / merge request)
        :param pulumi.Input[bool] commit_events: Enable notifications for commit events
        :param pulumi.Input[bool] issues_enabled: Enable viewing Jira issues in GitLab.
        :param pulumi.Input[int] jira_auth_type: The authentication method to be used with Jira. 0 means Basic Authentication. 1 means Jira personal access token. Defaults to 0.
        :param pulumi.Input[str] jira_issue_prefix: Prefix to match Jira issue keys.
        :param pulumi.Input[str] jira_issue_regex: Regular expression to match Jira issue keys.
        :param pulumi.Input[str] jira_issue_transition_id: The ID of a transition that moves issues to a closed state. You can find this number under the JIRA workflow administration (Administration > Issues > Workflows) by selecting View under Operations of the desired workflow of your project. By default, this ID is set to 2. *Note**: importing this field is only supported since GitLab 15.2.
        :param pulumi.Input[bool] merge_requests_events: Enable notifications for merge request events
        :param pulumi.Input[str] password: The Jira API token, password, or personal access token to be used with Jira. When your authentication method is basic (jira*auth*type is 0), use an API token for Jira Cloud or a password for Jira Data Center or Jira Server. When your authentication method is a Jira personal access token (jira*auth*type is 1), use the personal access token.
        :param pulumi.Input[str] project: ID of the project you want to activate integration on.
        :param pulumi.Input[str] project_key: The short identifier for your JIRA project, all uppercase, e.g., PROJ.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] project_keys: Keys of Jira projects. When issues_enabled is true, this setting specifies which Jira projects to view issues from in GitLab.
        :param pulumi.Input[str] url: The URL to the JIRA project which is being linked to this GitLab project. For example, https://jira.example.com.
        :param pulumi.Input[bool] use_inherited_settings: Indicates whether or not to inherit default settings. Defaults to false.
        :param pulumi.Input[str] username: The email or username to be used with Jira. For Jira Cloud use an email, for Jira Data Center and Jira Server use a username. Required when using Basic authentication (jira*auth*type is 0).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceJiraArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `ServiceJira` resource allows to manage the lifecycle of a project integration with Jira.

        > This resource is deprecated. use `IntegrationJira`instead!

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/integrations.html#jira)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        awesome_project = gitlab.Project("awesome_project",
            name="awesome_project",
            description="My awesome project.",
            visibility_level="public")
        jira = gitlab.ServiceJira("jira",
            project=awesome_project.id,
            url="https://jira.example.com",
            username="user",
            password="mypass")
        ```

        ## Import

        Starting in Terraform v1.5.0 you can use an import block to import `gitlab_service_jira`. For example:

        terraform

        import {

          to = gitlab_service_jira.example

          id = "see CLI command below for ID"

        }

        Import using the CLI is supported using the following syntax:

        You can import a gitlab_service_jira state using the project ID, e.g.

        ```sh
        $ pulumi import gitlab:index/serviceJira:ServiceJira jira 1
        ```

        :param str resource_name: The name of the resource.
        :param ServiceJiraArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceJiraArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_url: Optional[pulumi.Input[str]] = None,
                 comment_on_event_enabled: Optional[pulumi.Input[bool]] = None,
                 commit_events: Optional[pulumi.Input[bool]] = None,
                 issues_enabled: Optional[pulumi.Input[bool]] = None,
                 jira_auth_type: Optional[pulumi.Input[int]] = None,
                 jira_issue_prefix: Optional[pulumi.Input[str]] = None,
                 jira_issue_regex: Optional[pulumi.Input[str]] = None,
                 jira_issue_transition_automatic: Optional[pulumi.Input[bool]] = None,
                 jira_issue_transition_id: Optional[pulumi.Input[str]] = None,
                 merge_requests_events: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 project_key: Optional[pulumi.Input[str]] = None,
                 project_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 use_inherited_settings: Optional[pulumi.Input[bool]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceJiraArgs.__new__(ServiceJiraArgs)

            __props__.__dict__["api_url"] = api_url
            __props__.__dict__["comment_on_event_enabled"] = comment_on_event_enabled
            __props__.__dict__["commit_events"] = commit_events
            __props__.__dict__["issues_enabled"] = issues_enabled
            __props__.__dict__["jira_auth_type"] = jira_auth_type
            __props__.__dict__["jira_issue_prefix"] = jira_issue_prefix
            __props__.__dict__["jira_issue_regex"] = jira_issue_regex
            __props__.__dict__["jira_issue_transition_automatic"] = jira_issue_transition_automatic
            __props__.__dict__["jira_issue_transition_id"] = jira_issue_transition_id
            __props__.__dict__["merge_requests_events"] = merge_requests_events
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["project_key"] = project_key
            __props__.__dict__["project_keys"] = project_keys
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = url
            __props__.__dict__["use_inherited_settings"] = use_inherited_settings
            __props__.__dict__["username"] = username
            __props__.__dict__["active"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["title"] = None
            __props__.__dict__["updated_at"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ServiceJira, __self__).__init__(
            'gitlab:index/serviceJira:ServiceJira',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active: Optional[pulumi.Input[bool]] = None,
            api_url: Optional[pulumi.Input[str]] = None,
            comment_on_event_enabled: Optional[pulumi.Input[bool]] = None,
            commit_events: Optional[pulumi.Input[bool]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            issues_enabled: Optional[pulumi.Input[bool]] = None,
            jira_auth_type: Optional[pulumi.Input[int]] = None,
            jira_issue_prefix: Optional[pulumi.Input[str]] = None,
            jira_issue_regex: Optional[pulumi.Input[str]] = None,
            jira_issue_transition_automatic: Optional[pulumi.Input[bool]] = None,
            jira_issue_transition_id: Optional[pulumi.Input[str]] = None,
            merge_requests_events: Optional[pulumi.Input[bool]] = None,
            password: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            project_key: Optional[pulumi.Input[str]] = None,
            project_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            title: Optional[pulumi.Input[str]] = None,
            updated_at: Optional[pulumi.Input[str]] = None,
            url: Optional[pulumi.Input[str]] = None,
            use_inherited_settings: Optional[pulumi.Input[bool]] = None,
            username: Optional[pulumi.Input[str]] = None) -> 'ServiceJira':
        """
        Get an existing ServiceJira resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] active: Whether the integration is active.
        :param pulumi.Input[str] api_url: The base URL to the Jira instance API. Web URL value is used if not set. For example, https://jira-api.example.com.
        :param pulumi.Input[bool] comment_on_event_enabled: Enable comments inside Jira issues on each GitLab event (commit / merge request)
        :param pulumi.Input[bool] commit_events: Enable notifications for commit events
        :param pulumi.Input[str] created_at: Create time.
        :param pulumi.Input[bool] issues_enabled: Enable viewing Jira issues in GitLab.
        :param pulumi.Input[int] jira_auth_type: The authentication method to be used with Jira. 0 means Basic Authentication. 1 means Jira personal access token. Defaults to 0.
        :param pulumi.Input[str] jira_issue_prefix: Prefix to match Jira issue keys.
        :param pulumi.Input[str] jira_issue_regex: Regular expression to match Jira issue keys.
        :param pulumi.Input[str] jira_issue_transition_id: The ID of a transition that moves issues to a closed state. You can find this number under the JIRA workflow administration (Administration > Issues > Workflows) by selecting View under Operations of the desired workflow of your project. By default, this ID is set to 2. *Note**: importing this field is only supported since GitLab 15.2.
        :param pulumi.Input[bool] merge_requests_events: Enable notifications for merge request events
        :param pulumi.Input[str] password: The Jira API token, password, or personal access token to be used with Jira. When your authentication method is basic (jira*auth*type is 0), use an API token for Jira Cloud or a password for Jira Data Center or Jira Server. When your authentication method is a Jira personal access token (jira*auth*type is 1), use the personal access token.
        :param pulumi.Input[str] project: ID of the project you want to activate integration on.
        :param pulumi.Input[str] project_key: The short identifier for your JIRA project, all uppercase, e.g., PROJ.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] project_keys: Keys of Jira projects. When issues_enabled is true, this setting specifies which Jira projects to view issues from in GitLab.
        :param pulumi.Input[str] title: Title.
        :param pulumi.Input[str] updated_at: Update time.
        :param pulumi.Input[str] url: The URL to the JIRA project which is being linked to this GitLab project. For example, https://jira.example.com.
        :param pulumi.Input[bool] use_inherited_settings: Indicates whether or not to inherit default settings. Defaults to false.
        :param pulumi.Input[str] username: The email or username to be used with Jira. For Jira Cloud use an email, for Jira Data Center and Jira Server use a username. Required when using Basic authentication (jira*auth*type is 0).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceJiraState.__new__(_ServiceJiraState)

        __props__.__dict__["active"] = active
        __props__.__dict__["api_url"] = api_url
        __props__.__dict__["comment_on_event_enabled"] = comment_on_event_enabled
        __props__.__dict__["commit_events"] = commit_events
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["issues_enabled"] = issues_enabled
        __props__.__dict__["jira_auth_type"] = jira_auth_type
        __props__.__dict__["jira_issue_prefix"] = jira_issue_prefix
        __props__.__dict__["jira_issue_regex"] = jira_issue_regex
        __props__.__dict__["jira_issue_transition_automatic"] = jira_issue_transition_automatic
        __props__.__dict__["jira_issue_transition_id"] = jira_issue_transition_id
        __props__.__dict__["merge_requests_events"] = merge_requests_events
        __props__.__dict__["password"] = password
        __props__.__dict__["project"] = project
        __props__.__dict__["project_key"] = project_key
        __props__.__dict__["project_keys"] = project_keys
        __props__.__dict__["title"] = title
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["url"] = url
        __props__.__dict__["use_inherited_settings"] = use_inherited_settings
        __props__.__dict__["username"] = username
        return ServiceJira(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[bool]:
        """
        Whether the integration is active.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="apiUrl")
    def api_url(self) -> pulumi.Output[str]:
        """
        The base URL to the Jira instance API. Web URL value is used if not set. For example, https://jira-api.example.com.
        """
        return pulumi.get(self, "api_url")

    @property
    @pulumi.getter(name="commentOnEventEnabled")
    def comment_on_event_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable comments inside Jira issues on each GitLab event (commit / merge request)
        """
        return pulumi.get(self, "comment_on_event_enabled")

    @property
    @pulumi.getter(name="commitEvents")
    def commit_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for commit events
        """
        return pulumi.get(self, "commit_events")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Create time.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="issuesEnabled")
    def issues_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable viewing Jira issues in GitLab.
        """
        return pulumi.get(self, "issues_enabled")

    @property
    @pulumi.getter(name="jiraAuthType")
    def jira_auth_type(self) -> pulumi.Output[Optional[int]]:
        """
        The authentication method to be used with Jira. 0 means Basic Authentication. 1 means Jira personal access token. Defaults to 0.
        """
        return pulumi.get(self, "jira_auth_type")

    @property
    @pulumi.getter(name="jiraIssuePrefix")
    def jira_issue_prefix(self) -> pulumi.Output[Optional[str]]:
        """
        Prefix to match Jira issue keys.
        """
        return pulumi.get(self, "jira_issue_prefix")

    @property
    @pulumi.getter(name="jiraIssueRegex")
    def jira_issue_regex(self) -> pulumi.Output[Optional[str]]:
        """
        Regular expression to match Jira issue keys.
        """
        return pulumi.get(self, "jira_issue_regex")

    @property
    @pulumi.getter(name="jiraIssueTransitionAutomatic")
    def jira_issue_transition_automatic(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "jira_issue_transition_automatic")

    @property
    @pulumi.getter(name="jiraIssueTransitionId")
    def jira_issue_transition_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of a transition that moves issues to a closed state. You can find this number under the JIRA workflow administration (Administration > Issues > Workflows) by selecting View under Operations of the desired workflow of your project. By default, this ID is set to 2. *Note**: importing this field is only supported since GitLab 15.2.
        """
        return pulumi.get(self, "jira_issue_transition_id")

    @property
    @pulumi.getter(name="mergeRequestsEvents")
    def merge_requests_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for merge request events
        """
        return pulumi.get(self, "merge_requests_events")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        The Jira API token, password, or personal access token to be used with Jira. When your authentication method is basic (jira*auth*type is 0), use an API token for Jira Cloud or a password for Jira Data Center or Jira Server. When your authentication method is a Jira personal access token (jira*auth*type is 1), use the personal access token.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        ID of the project you want to activate integration on.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> pulumi.Output[Optional[str]]:
        """
        The short identifier for your JIRA project, all uppercase, e.g., PROJ.
        """
        return pulumi.get(self, "project_key")

    @property
    @pulumi.getter(name="projectKeys")
    def project_keys(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Keys of Jira projects. When issues_enabled is true, this setting specifies which Jira projects to view issues from in GitLab.
        """
        return pulumi.get(self, "project_keys")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[str]:
        """
        Title.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        Update time.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        The URL to the JIRA project which is being linked to this GitLab project. For example, https://jira.example.com.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="useInheritedSettings")
    def use_inherited_settings(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether or not to inherit default settings. Defaults to false.
        """
        return pulumi.get(self, "use_inherited_settings")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[str]]:
        """
        The email or username to be used with Jira. For Jira Cloud use an email, for Jira Data Center and Jira Server use a username. Required when using Basic authentication (jira*auth*type is 0).
        """
        return pulumi.get(self, "username")

