# Generated by Django 5.1.7 on 2025-03-17 12:13

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="APIKey",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "key",
                    models.CharField(
                        db_comment="The API key used for authentication.",
                        editable=False,
                        help_text="A unique API key used for authentication.",
                        max_length=64,
                        unique=True,
                        verbose_name="API Key",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True,
                        db_comment="Timestamp when the API key was generated.",
                        help_text="The date and time when the API key was created.",
                        verbose_name="Created At",
                    ),
                ),
                (
                    "expires_at",
                    models.DateTimeField(
                        blank=True,
                        db_comment="Optional expiration date for the API key.",
                        help_text="The date and time when the API key will expire. Leave blank for no expiration.",
                        null=True,
                        verbose_name="Expiration Date",
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(
                        db_comment="Status flag to enable or disable the API key.",
                        default=True,
                        help_text="Indicates whether the API key is currently active and usable.",
                        verbose_name="Is Active",
                    ),
                ),
                (
                    "requests_count",
                    models.PositiveIntegerField(
                        db_comment="Tracks the total number of requests made using this API key.",
                        default=0,
                        help_text="Number of requests made with this API key.",
                        verbose_name="Requests Count",
                    ),
                ),
                (
                    "max_requests",
                    models.PositiveIntegerField(
                        blank=True,
                        db_comment="Defines the maximum allowed requests, either total or per reset interval.",
                        help_text="Maximum number of requests allowed (total or per reset period).",
                        null=True,
                        verbose_name="Max Requests",
                    ),
                ),
                (
                    "reset_at",
                    models.DateTimeField(
                        blank=True,
                        db_comment="Timestamp when the request count will reset, if rate limiting is time-based.",
                        help_text="Time when the request count resets (if applicable).",
                        null=True,
                        verbose_name="Reset At",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        db_comment="The user associated with this API key.",
                        help_text="The user who owns this API key.",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="api_keys",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="User",
                    ),
                ),
            ],
            options={
                "verbose_name": "API Key",
                "verbose_name_plural": "API Keys",
                "db_table_comment": "Table storing API keys for authentication and rate limiting.",
                "ordering": ["-created_at"],
            },
        ),
    ]
