from setuptools import setup, find_packages

with open("README.md", "r") as readme_file:
    readme = readme_file.read()

setup(
    name="synthetic_data_metrics",
    version="0.0.3",
    author="K.Court",
    author_email="kate.court@ncl.ac.uk",
    description="Synthetic Data Metrics is a Python library for evaluating synthetic data quality across a wide range of data types (image, tabular, time series, language) and approaches to evaluation.",
    long_description=readme,
    long_description_content_type="text/markdown",
    url="https://github.com/NewcastleRSE/synthetic_data_metrics/tree/dev",
    packages=find_packages(),
    install_requires=[
    'absl-py==1.4.0', 
    'astunparse==1.6.3',
    'cachetools==5.3.0',
    'certifi==2022.12.7',
    'charset-normalizer==3.0.1',
    'flatbuffers==23.1.21',
    'gast==0.4.0',
    'google-auth==2.16.0',
    'google-auth-oauthlib==0.4.6',
    'google-pasta==0.2.0',
    'grpcio==1.51.1',
    'h5py==3.8.0',
    'idna==3.4',
    'imageio==2.25.0',
    'joblib==1.2.0',
    'keras==2.11.0',
    'libclang==15.0.6.1',
    'Markdown==3.4.1',
    'MarkupSafe==2.1.2',
    'networkx==3.0',
    'numpy==1.24.2',
    'oauthlib==3.2.2',
    'opt-einsum==3.3.0',
    'packaging==23.0',
    'pandas==1.5.3',
    'Pillow==9.4.0',
    'protobuf==3.19.6',
    'pyasn1==0.4.8',
    'pyasn1-modules==0.2.8',
    'python-dateutil==2.8.2',
    'pytz==2022.7.1',
    'PyWavelets==1.4.1',
    'requests==2.28.2',
    'requests-oauthlib==1.3.1',
    'rsa==4.9',
    'scikit-image==0.19.3',
    'scikit-learn==1.2.1',
    'scipy==1.10.0',
    'six==1.16.0',
    'tensorboard==2.11.2',
    'tensorboard-data-server==0.6.1',
    'tensorboard-plugin-wit==1.8.1',
    'tensorflow==2.11.0',
    'tensorflow-estimator==2.11.0',
    'tensorflow-io-gcs-filesystem==0.30.0',
    'termcolor==2.2.0',
    'threadpoolctl==3.1.0',
    'tifffile==2023.2.3',
    'typing_extensions==4.4.0',
    'urllib3==1.26.14',
    'Werkzeug==2.2.2',
    'wrapt==1.14.1',
    'matplotlib==3.6.3'
    ],
    classifiers=[
        "Programming Language :: Python :: 3.10",
        "License :: OSI Approved :: MIT License",
    ],
)