"""Simple cryptanalysis library."""
# Disable "unused imports" nags
# flake8: noqa

from .pen import (letter_to_num, num_to_letter,
                  complete_alphabet,
                  caesar_shift_letter, caesar_shift)

from .ciphers import (Cipher, CaesarCipher, VigenereCipher,
                      SimpleSubstitutionCipher)

from .codecs import (Codec, Transcoder, BinASCIICodec, HexASCIICodec, Base64Codec,
                     PKCS7PaddingCodec, BlockCodec)

from .analysis import char_frequency, ngram_frequency, hamming_distance

from .scorers import NgramFrequencyScorer

from .bitwise import (get_bit, get_bits,
                      bits_to_bytes, bytes_to_bits,
                      xor_bytes)

from .util import escape_nonprintables, contains_nonprintables
