"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChimePhoneNumber = exports.PhoneProductType = exports.PhoneCountry = exports.PhoneNumberType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const customResource_1 = require("./customResource");
const phoneNumberValidator_1 = require("./phoneNumberValidator");
var PhoneNumberType;
(function (PhoneNumberType) {
    PhoneNumberType["LOCAL"] = "Local";
    PhoneNumberType["TOLLFREE"] = "TollFree";
})(PhoneNumberType = exports.PhoneNumberType || (exports.PhoneNumberType = {}));
var PhoneCountry;
(function (PhoneCountry) {
    PhoneCountry["AU"] = "AU";
    PhoneCountry["AT"] = "AT";
    PhoneCountry["CA"] = "CA";
    PhoneCountry["DK"] = "DK";
    PhoneCountry["DE"] = "DE";
    PhoneCountry["IE"] = "IE";
    PhoneCountry["IT"] = "IT";
    PhoneCountry["NZ"] = "NZ";
    PhoneCountry["NG"] = "NG";
    PhoneCountry["PR"] = "PR";
    PhoneCountry["KR"] = "KR";
    PhoneCountry["SE"] = "SE";
    PhoneCountry["CH"] = "CH";
    PhoneCountry["UK"] = "UK";
    PhoneCountry["US"] = "US";
})(PhoneCountry = exports.PhoneCountry || (exports.PhoneCountry = {}));
var PhoneProductType;
(function (PhoneProductType) {
    PhoneProductType["SMA"] = "SipMediaApplicationDialIn";
    PhoneProductType["VC"] = "VoiceConnector";
})(PhoneProductType = exports.PhoneProductType || (exports.PhoneProductType = {}));
class ChimePhoneNumber extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const uid = cdk.Names.uniqueId(this);
        const { phoneAreaCode, phoneCity, phoneState, phoneNumberTollFreePrefix, phoneNumberType, phoneCountry, phoneProductType, } = props;
        phoneNumberValidator_1.phoneNumberValidator(props);
        const phoneNumberRequest = new customResource_1.ChimeResources(this, 'ChimePhoneNumber', {
            resourceType: 'PhoneNumber',
            uid: uid,
            properties: {
                phoneAreaCode: phoneAreaCode,
                phoneCity: phoneCity,
                phoneState: phoneState,
                phoneNumberType: phoneNumberType,
                phoneNumberTollFreePrefix: phoneNumberTollFreePrefix,
                phoneCountry: phoneCountry || PhoneCountry.US,
                phoneProductType: phoneProductType,
            },
        });
        this.phoneNumber =
            phoneNumberRequest.chimeCustomResource.getAttString('phoneNumber');
    }
    associateWithVoiceConnector(voiceConnectorId) {
        return this.associateNumber(voiceConnectorId.voiceConnectorId, this.phoneNumber);
    }
    associateNumber(voiceConnectorId, e164PhoneNumber) {
        const result = new customResource_1.PhoneAssociation(this, 'phoneAssociation', {
            voiceConnectorId,
            e164PhoneNumber,
        });
        return result;
    }
}
exports.ChimePhoneNumber = ChimePhoneNumber;
_a = JSII_RTTI_SYMBOL_1;
ChimePhoneNumber[_a] = { fqn: "cdk-amazon-chime-resources.ChimePhoneNumber", version: "0.0.102" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGhvbmVOdW1iZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvcGhvbmVOdW1iZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxtQ0FBbUM7QUFDbkMsMkNBQXVDO0FBRXZDLHFEQUFvRTtBQUNwRSxpRUFBOEQ7QUFFOUQsSUFBWSxlQUdYO0FBSEQsV0FBWSxlQUFlO0lBQ3pCLGtDQUFlLENBQUE7SUFDZix3Q0FBcUIsQ0FBQTtBQUN2QixDQUFDLEVBSFcsZUFBZSxHQUFmLHVCQUFlLEtBQWYsdUJBQWUsUUFHMUI7QUFFRCxJQUFZLFlBZ0JYO0FBaEJELFdBQVksWUFBWTtJQUN0Qix5QkFBUyxDQUFBO0lBQ1QseUJBQVMsQ0FBQTtJQUNULHlCQUFTLENBQUE7SUFDVCx5QkFBUyxDQUFBO0lBQ1QseUJBQVMsQ0FBQTtJQUNULHlCQUFTLENBQUE7SUFDVCx5QkFBUyxDQUFBO0lBQ1QseUJBQVMsQ0FBQTtJQUNULHlCQUFTLENBQUE7SUFDVCx5QkFBUyxDQUFBO0lBQ1QseUJBQVMsQ0FBQTtJQUNULHlCQUFTLENBQUE7SUFDVCx5QkFBUyxDQUFBO0lBQ1QseUJBQVMsQ0FBQTtJQUNULHlCQUFTLENBQUE7QUFDWCxDQUFDLEVBaEJXLFlBQVksR0FBWixvQkFBWSxLQUFaLG9CQUFZLFFBZ0J2QjtBQUVELElBQVksZ0JBR1g7QUFIRCxXQUFZLGdCQUFnQjtJQUMxQixxREFBaUMsQ0FBQTtJQUNqQyx5Q0FBcUIsQ0FBQTtBQUN2QixDQUFDLEVBSFcsZ0JBQWdCLEdBQWhCLHdCQUFnQixLQUFoQix3QkFBZ0IsUUFHM0I7QUF3REQsTUFBYSxnQkFBaUIsU0FBUSxzQkFBUztJQUc3QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXVCO1FBQy9ELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsTUFBTSxHQUFHLEdBQVcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLENBQUM7UUFFN0MsTUFBTSxFQUNKLGFBQWEsRUFDYixTQUFTLEVBQ1QsVUFBVSxFQUNWLHlCQUF5QixFQUN6QixlQUFlLEVBQ2YsWUFBWSxFQUNaLGdCQUFnQixHQUNqQixHQUFHLEtBQUssQ0FBQztRQUVWLDJDQUFvQixDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQzVCLE1BQU0sa0JBQWtCLEdBQUcsSUFBSSwrQkFBYyxDQUFDLElBQUksRUFBRSxrQkFBa0IsRUFBRTtZQUN0RSxZQUFZLEVBQUUsYUFBYTtZQUMzQixHQUFHLEVBQUUsR0FBRztZQUNSLFVBQVUsRUFBRTtnQkFDVixhQUFhLEVBQUUsYUFBYTtnQkFDNUIsU0FBUyxFQUFFLFNBQVM7Z0JBQ3BCLFVBQVUsRUFBRSxVQUFVO2dCQUN0QixlQUFlLEVBQUUsZUFBZTtnQkFDaEMseUJBQXlCLEVBQUUseUJBQXlCO2dCQUNwRCxZQUFZLEVBQUUsWUFBWSxJQUFJLFlBQVksQ0FBQyxFQUFFO2dCQUM3QyxnQkFBZ0IsRUFBRSxnQkFBZ0I7YUFDbkM7U0FDRixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsV0FBVztZQUNkLGtCQUFrQixDQUFDLG1CQUFtQixDQUFDLFlBQVksQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUN2RSxDQUFDO0lBRUQsMkJBQTJCLENBQUMsZ0JBQXFDO1FBQy9ELE9BQU8sSUFBSSxDQUFDLGVBQWUsQ0FDekIsZ0JBQWdCLENBQUMsZ0JBQWdCLEVBQ2pDLElBQUksQ0FBQyxXQUFXLENBQ2pCLENBQUM7SUFDSixDQUFDO0lBRU8sZUFBZSxDQUFDLGdCQUF3QixFQUFFLGVBQXVCO1FBQ3ZFLE1BQU0sTUFBTSxHQUFHLElBQUksaUNBQWdCLENBQUMsSUFBSSxFQUFFLGtCQUFrQixFQUFFO1lBQzVELGdCQUFnQjtZQUNoQixlQUFlO1NBQ2hCLENBQUMsQ0FBQztRQUNILE9BQU8sTUFBTSxDQUFDO0lBQ2hCLENBQUM7O0FBbERILDRDQW1EQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNkayBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IENoaW1lVm9pY2VDb25uZWN0b3IgfSBmcm9tICcuJztcbmltcG9ydCB7IENoaW1lUmVzb3VyY2VzLCBQaG9uZUFzc29jaWF0aW9uIH0gZnJvbSAnLi9jdXN0b21SZXNvdXJjZSc7XG5pbXBvcnQgeyBwaG9uZU51bWJlclZhbGlkYXRvciB9IGZyb20gJy4vcGhvbmVOdW1iZXJWYWxpZGF0b3InO1xuXG5leHBvcnQgZW51bSBQaG9uZU51bWJlclR5cGUge1xuICBMT0NBTCA9ICdMb2NhbCcsXG4gIFRPTExGUkVFID0gJ1RvbGxGcmVlJyxcbn1cblxuZXhwb3J0IGVudW0gUGhvbmVDb3VudHJ5IHtcbiAgQVUgPSAnQVUnLFxuICBBVCA9ICdBVCcsXG4gIENBID0gJ0NBJyxcbiAgREsgPSAnREsnLFxuICBERSA9ICdERScsXG4gIElFID0gJ0lFJyxcbiAgSVQgPSAnSVQnLFxuICBOWiA9ICdOWicsXG4gIE5HID0gJ05HJyxcbiAgUFIgPSAnUFInLFxuICBLUiA9ICdLUicsXG4gIFNFID0gJ1NFJyxcbiAgQ0ggPSAnQ0gnLFxuICBVSyA9ICdVSycsXG4gIFVTID0gJ1VTJyxcbn1cblxuZXhwb3J0IGVudW0gUGhvbmVQcm9kdWN0VHlwZSB7XG4gIFNNQSA9ICdTaXBNZWRpYUFwcGxpY2F0aW9uRGlhbEluJyxcbiAgVkMgPSAnVm9pY2VDb25uZWN0b3InLFxufVxuXG4vKipcbiAqIFByb3BzIGZvciBgUGhvbmVOdW1iZXJgLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFBob25lTnVtYmVyUHJvcHMge1xuICAvKipcbiAgICogQXJlYSBDb2RlIGZvciBwaG9uZSBudW1iZXIgcmVxdWVzdCAob3B0aW9uYWwpICAtIFVzYWJsZSBvbmx5IHdpdGggVVMgQ291bnRyeVxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vbmVcbiAgICovXG4gIHJlYWRvbmx5IHBob25lQXJlYUNvZGU/OiBudW1iZXI7XG5cbiAgLyoqXG4gICAqIENpdHkgZm9yIHBob25lIG51bWJlciByZXF1ZXN0IChvcHRpb25hbCkgLSBVc2FibGUgb25seSB3aXRoIFVTIENvdW50cnlcbiAgICpcbiAgICogQGRlZmF1bHQgLSBOb25lXG4gICAqL1xuICByZWFkb25seSBwaG9uZUNpdHk/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFN0YXRlIGZvciBwaG9uZSBudW1iZXIgcmVxdWVzdCAob3B0aW9uYWwpIC0gVXNhYmxlIG9ubHkgd2l0aCBVUyBDb3VudHJ5XG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgcGhvbmVTdGF0ZT86IHN0cmluZztcblxuICAvKipcbiAgICogVG9sbCBGcmVlIFByZWZpeCBmb3IgcGhvbmUgbnVtYmVyIHJlcXVlc3QgKG9wdGlvbmFsKVxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vbmVcbiAgICovXG4gIHJlYWRvbmx5IHBob25lTnVtYmVyVG9sbEZyZWVQcmVmaXg/OiBudW1iZXI7XG5cbiAgLyoqXG4gICAqIFBob25lIE51bWJlciBUeXBlIGZvciBwaG9uZSBudW1iZXIgcmVxdWVzdCAob3B0aW9uYWwpIC0gTG9jYWwgb3IgVG9sbEZyZWUgLSBSZXF1aXJlZCB3aXRoIG5vbi1VUyBjb3VudHJ5XG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgcGhvbmVOdW1iZXJUeXBlPzogUGhvbmVOdW1iZXJUeXBlO1xuXG4gIC8qKlxuICAgKiBDb3VudHJ5IGZvciBwaG9uZSBudW1iZXIgcmVxdWVzdCAob3B0aW9uYWwpIC0gU2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jaGltZS9sYXRlc3QvYWcvcGhvbmUtY291bnRyeS1yZXFzLmh0bWwgZm9yIG1vcmUgZGV0YWlsc1xuICAgKlxuICAgKiBAZGVmYXVsdCAtIFVTXG4gICAqL1xuICByZWFkb25seSBwaG9uZUNvdW50cnk/OiBQaG9uZUNvdW50cnk7XG5cbiAgLyoqXG4gICAqIFBob25lIFByb2R1Y3QgVHlwZSAocmVxdWlyZWQpIC0gU2lwTWVkaWFBcHBsaWNhdGlvbkRpYWxJbiBvciBWb2ljZUNvbm5lY3RvclxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vbmVcbiAgICovXG4gIHJlYWRvbmx5IHBob25lUHJvZHVjdFR5cGU6IFBob25lUHJvZHVjdFR5cGU7XG59XG5cbmV4cG9ydCBjbGFzcyBDaGltZVBob25lTnVtYmVyIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcHVibGljIHJlYWRvbmx5IHBob25lTnVtYmVyOiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFBob25lTnVtYmVyUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgY29uc3QgdWlkOiBzdHJpbmcgPSBjZGsuTmFtZXMudW5pcXVlSWQodGhpcyk7XG5cbiAgICBjb25zdCB7XG4gICAgICBwaG9uZUFyZWFDb2RlLFxuICAgICAgcGhvbmVDaXR5LFxuICAgICAgcGhvbmVTdGF0ZSxcbiAgICAgIHBob25lTnVtYmVyVG9sbEZyZWVQcmVmaXgsXG4gICAgICBwaG9uZU51bWJlclR5cGUsXG4gICAgICBwaG9uZUNvdW50cnksXG4gICAgICBwaG9uZVByb2R1Y3RUeXBlLFxuICAgIH0gPSBwcm9wcztcblxuICAgIHBob25lTnVtYmVyVmFsaWRhdG9yKHByb3BzKTtcbiAgICBjb25zdCBwaG9uZU51bWJlclJlcXVlc3QgPSBuZXcgQ2hpbWVSZXNvdXJjZXModGhpcywgJ0NoaW1lUGhvbmVOdW1iZXInLCB7XG4gICAgICByZXNvdXJjZVR5cGU6ICdQaG9uZU51bWJlcicsXG4gICAgICB1aWQ6IHVpZCxcbiAgICAgIHByb3BlcnRpZXM6IHtcbiAgICAgICAgcGhvbmVBcmVhQ29kZTogcGhvbmVBcmVhQ29kZSxcbiAgICAgICAgcGhvbmVDaXR5OiBwaG9uZUNpdHksXG4gICAgICAgIHBob25lU3RhdGU6IHBob25lU3RhdGUsXG4gICAgICAgIHBob25lTnVtYmVyVHlwZTogcGhvbmVOdW1iZXJUeXBlLFxuICAgICAgICBwaG9uZU51bWJlclRvbGxGcmVlUHJlZml4OiBwaG9uZU51bWJlclRvbGxGcmVlUHJlZml4LFxuICAgICAgICBwaG9uZUNvdW50cnk6IHBob25lQ291bnRyeSB8fCBQaG9uZUNvdW50cnkuVVMsXG4gICAgICAgIHBob25lUHJvZHVjdFR5cGU6IHBob25lUHJvZHVjdFR5cGUsXG4gICAgICB9LFxuICAgIH0pO1xuXG4gICAgdGhpcy5waG9uZU51bWJlciA9XG4gICAgICBwaG9uZU51bWJlclJlcXVlc3QuY2hpbWVDdXN0b21SZXNvdXJjZS5nZXRBdHRTdHJpbmcoJ3Bob25lTnVtYmVyJyk7XG4gIH1cblxuICBhc3NvY2lhdGVXaXRoVm9pY2VDb25uZWN0b3Iodm9pY2VDb25uZWN0b3JJZDogQ2hpbWVWb2ljZUNvbm5lY3Rvcikge1xuICAgIHJldHVybiB0aGlzLmFzc29jaWF0ZU51bWJlcihcbiAgICAgIHZvaWNlQ29ubmVjdG9ySWQudm9pY2VDb25uZWN0b3JJZCxcbiAgICAgIHRoaXMucGhvbmVOdW1iZXIsXG4gICAgKTtcbiAgfVxuXG4gIHByaXZhdGUgYXNzb2NpYXRlTnVtYmVyKHZvaWNlQ29ubmVjdG9ySWQ6IHN0cmluZywgZTE2NFBob25lTnVtYmVyOiBzdHJpbmcpIHtcbiAgICBjb25zdCByZXN1bHQgPSBuZXcgUGhvbmVBc3NvY2lhdGlvbih0aGlzLCAncGhvbmVBc3NvY2lhdGlvbicsIHtcbiAgICAgIHZvaWNlQ29ubmVjdG9ySWQsXG4gICAgICBlMTY0UGhvbmVOdW1iZXIsXG4gICAgfSk7XG4gICAgcmV0dXJuIHJlc3VsdDtcbiAgfVxufVxuIl19