<p align="left">
  <a href="https://carbonplan.org/#gh-light-mode-only">
    <img
      src="https://carbonplan-assets.s3.amazonaws.com/monogram/dark-small.png"
      height="48px"
    />
  </a>
  <a href="https://carbonplan.org/#gh-dark-mode-only">
    <img
      src="https://carbonplan-assets.s3.amazonaws.com/monogram/light-small.png"
      height="48px"
    />
  </a>
</p>

# carbonplan / tonyear

Python package for understanding ton-year accounting

![GitHub branch checks state](https://img.shields.io/github/checks-status/carbonplan/ton-year/main?style=flat-square)
![Codecov](https://img.shields.io/codecov/c/github/carbonplan/ton-year?style=flat-square)![GitHub](https://img.shields.io/github/license/carbonplan/ton-year?style=flat-square)
![GitHub deployments](https://img.shields.io/github/deployments/carbonplan/ton-year/production?label=docs&style=flat-square)
![PyPI](https://img.shields.io/pypi/v/tonyear?style=flat-square)

This repository implements two widely referenced ton-year accounting methods.

Ton-year accounting refers to a family of approaches that quantify the benefit of temporarily storing carbon dioxide that might otherwise enter the atmosphere and exacerbate climate change. We’ve noticed growing interest in using ton-year accounting to generate carbon offsets – an arrangement that uses temporary storage of CO<sub>2</sub> to justify the on-going carbon pollution.

We originally wrote this code as a way to improve our understanding of the climate science, math, and assumptions underlying ton-year accounting methods. By sharing our code, we hope to help facilitate deep thinking about how we value temporary carbon storage. We wrote a short [explainer](https://carbonplan.org/research/ton-year-explainer) documenting what we’ve learned so far.

## license

All the code in this repository is [MIT](https://choosealicense.com/licenses/mit/) licensed, but we request that you please provide attribution if reusing any of our digital content (graphics, logo, articles, etc.).

## about us

CarbonPlan is a non-profit organization that uses data and science for climate action. We aim to improve the transparency and scientific integrity of carbon removal and climate solutions through open data and tools. Find out more at [carbonplan.org](https://carbonplan.org/) or get in touch by [opening an issue](https://github.com/carbonplan/ton-year/issues/new) or [sending us an email](mailto:hello@carbonplan.org).
