"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultCloudFrontDisributionForMediaStoreProps = exports.DefaultCloudFrontWebDistributionForS3Props = exports.DefaultCloudFrontWebDistributionForApiGatewayProps = void 0;
const cloudfront = require("@aws-cdk/aws-cloudfront");
const aws_cloudfront_1 = require("@aws-cdk/aws-cloudfront");
const origins = require("@aws-cdk/aws-cloudfront-origins");
const cdk = require("@aws-cdk/core");
function DefaultCloudFrontWebDistributionForApiGatewayProps(apiEndPoint, loggingBucket, setHttpSecurityHeaders, cfFunction) {
    const apiEndPointUrlWithoutProtocol = cdk.Fn.select(1, cdk.Fn.split("://", apiEndPoint.url));
    const apiEndPointDomainName = cdk.Fn.select(0, cdk.Fn.split("/", apiEndPointUrlWithoutProtocol));
    return {
        defaultBehavior: {
            origin: new origins.HttpOrigin(apiEndPointDomainName, {
                originPath: `/${apiEndPoint.deploymentStage.stageName}`
            }),
            ...getFunctionAssociationsProp(setHttpSecurityHeaders, cfFunction),
            viewerProtocolPolicy: cloudfront.ViewerProtocolPolicy.REDIRECT_TO_HTTPS
        },
        enableLogging: true,
        logBucket: loggingBucket,
    };
}
exports.DefaultCloudFrontWebDistributionForApiGatewayProps = DefaultCloudFrontWebDistributionForApiGatewayProps;
function DefaultCloudFrontWebDistributionForS3Props(sourceBucket, loggingBucket, setHttpSecurityHeaders, cfFunction) {
    return {
        defaultBehavior: {
            origin: new origins.S3Origin(sourceBucket),
            viewerProtocolPolicy: cloudfront.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
            ...getFunctionAssociationsProp(setHttpSecurityHeaders, cfFunction)
        },
        enableLogging: true,
        logBucket: loggingBucket,
        defaultRootObject: 'index.html'
    };
}
exports.DefaultCloudFrontWebDistributionForS3Props = DefaultCloudFrontWebDistributionForS3Props;
function DefaultCloudFrontDisributionForMediaStoreProps(mediastoreContainer, loggingBucket, originRequestPolicy, setHttpSecurityHeaders, customHeaders, cfFunction) {
    const mediaStoreContainerUrlWithoutProtocol = cdk.Fn.select(1, cdk.Fn.split('://', mediastoreContainer.attrEndpoint));
    const mediaStoreContainerDomainName = cdk.Fn.select(0, cdk.Fn.split('/', mediaStoreContainerUrlWithoutProtocol));
    const httpOrigin = customHeaders ?
        new origins.HttpOrigin(mediaStoreContainerDomainName, { customHeaders }) :
        new origins.HttpOrigin(mediaStoreContainerDomainName);
    return {
        defaultBehavior: {
            origin: httpOrigin,
            viewerProtocolPolicy: cloudfront.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
            allowedMethods: cloudfront.AllowedMethods.ALLOW_GET_HEAD_OPTIONS,
            cachedMethods: cloudfront.CachedMethods.CACHE_GET_HEAD_OPTIONS,
            originRequestPolicy,
            ...getFunctionAssociationsProp(setHttpSecurityHeaders, cfFunction)
        },
        enableLogging: true,
        logBucket: loggingBucket
    };
}
exports.DefaultCloudFrontDisributionForMediaStoreProps = DefaultCloudFrontDisributionForMediaStoreProps;
function getFunctionAssociationsProp(setHttpSecurityHeaders, cfFunction) {
    return (setHttpSecurityHeaders && cfFunction) ? {
        functionAssociations: [
            {
                eventType: aws_cloudfront_1.FunctionEventType.VIEWER_RESPONSE,
                function: cfFunction
            }
        ]
    } : {};
}
//# sourceMappingURL=data:application/json;base64,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