"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.MediaStoreContainer = void 0;
const cdk = require("@aws-cdk/core");
const mediastore = require("@aws-cdk/aws-mediastore");
const mediastore_defaults_1 = require("./mediastore-defaults");
const utils_1 = require("./utils");
function MediaStoreContainer(scope, mediaStoreContainerProps) {
    const defaultprops = mediastore_defaults_1.MediaStoreContainerProps();
    let mediaStoreProps;
    if (mediaStoreContainerProps) {
        mediaStoreProps = utils_1.overrideProps(defaultprops, mediaStoreContainerProps);
    }
    else {
        mediaStoreProps = defaultprops;
    }
    // Create the MediaStore Container
    const mediaStoreContainer = new mediastore.CfnContainer(scope, 'MediaStoreContainer', mediaStoreProps);
    // Add deletion policy to retain because it will fail to delete if the container is not empty.
    mediaStoreContainer.cfnOptions.deletionPolicy = cdk.CfnDeletionPolicy.RETAIN;
    return mediaStoreContainer;
}
exports.MediaStoreContainer = MediaStoreContainer;
//# sourceMappingURL=data:application/json;base64,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